/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ListUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.IcalXmlStrMap;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.Period;
import com.zimbra.cs.mailbox.calendar.RdateExdate;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZRecur;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recurrence {
    public static final int TYPE_RECURRENCE = 1;
    public static final int TYPE_EXCEPTION = 2;
    public static final int TYPE_CANCELLATION = 3;
    public static final int TYPE_SINGLE_INSTANCE_DEPRECATED = 4;
    public static final int TYPE_REPEATING = 5;
    public static final int TYPE_SINGLE_DATES = 6;
    static final String FN_RULE_TYPE = "t";
    static final int RULE_SIMPLE_REPEATING_RULE = 2;
    static final int RULE_EXCEPTION_RULE = 3;
    static final int RULE_RECURRENCE_RULE = 4;
    static final int RULE_SINGLE_INSTANCE_DEPRECATED = 5;
    static final int RULE_SINGLE_DATES = 6;

    public static IRecurrence decodeMetadata(Metadata meta, TimeZoneMap tzmap) throws ServiceException {
        try {
            int ruleType = (int)meta.getLong(FN_RULE_TYPE);
            switch (ruleType) {
                case 2: {
                    return new SimpleRepeatingRule(meta, tzmap);
                }
                case 3: {
                    return new ExceptionRule(meta, tzmap);
                }
                case 4: {
                    return new RecurrenceRule(meta, tzmap);
                }
                case 6: {
                    return new SingleDates(meta, tzmap);
                }
            }
        }
        catch (ParseException e) {
            throw ServiceException.FAILURE("Parse excetion on metadata: " + meta, e);
        }
        throw new IllegalArgumentException("Unknown IRecur type: " + meta.get(FN_RULE_TYPE));
    }

    public static List<CalendarItem.Instance> expandInstances(IRecurrence recur, int calItemId, long start, long end) throws ServiceException {
        List<CalendarItem.Instance> list = recur.expandInstances(calItemId, start, end);
        ArrayList<CalendarItem.Instance> toRet = new ArrayList<CalendarItem.Instance>(list.size());
        CalendarItem.Instance prev = null;
        for (CalendarItem.Instance inst : list) {
            if (prev == null) {
                prev = inst;
                continue;
            }
            if (inst == null) continue;
            if (inst.sameTime(prev)) {
                if (inst.fromRdate()) continue;
                prev = inst;
                continue;
            }
            toRet.add(prev);
            prev = inst;
        }
        if (prev != null) {
            toRet.add(prev);
        }
        return toRet;
    }

    public static void main(String[] args) throws Exception {
        ICalTimeZone pacific = new ICalTimeZone("America/Los_Angeles", -28800000, "19710101T020000", "FREQ=YEARLY;WKST=MO;INTERVAL=1;BYMONTH=11;BYDAY=1SU", "PST", -25200000, "19710101T020000", "FREQ=YEARLY;WKST=MO;INTERVAL=1;BYMONTH=3;BYDAY=2SU", "PDT");
        TimeZoneMap tzmap = new TimeZoneMap(pacific);
        String str = "TZID=\"" + pacific.getID() + "\":20090105T120000";
        ParsedDateTime dtStart = ParsedDateTime.parse(str, tzmap);
        ParsedDuration duration = ParsedDuration.parse("PT1H");
        ArrayList<IRecurrence> addRules = new ArrayList<IRecurrence>();
        ArrayList<IRecurrence> subRules = new ArrayList<IRecurrence>();
        ZRecur rule = new ZRecur("FREQ=WEEKLY;INTERVAL=1", tzmap);
        addRules.add(new SimpleRepeatingRule(dtStart, duration, rule, null));
        RdateExdate rdate = new RdateExdate(ZCalendar.ICalTok.RDATE, pacific);
        str = "TZID=\"" + pacific.getID() + "\":20090106T120000";
        ParsedDateTime rd1 = ParsedDateTime.parse(str, tzmap);
        rdate.addValue(rd1);
        str = "TZID=\"" + pacific.getID() + "\":20090107T120000";
        ParsedDateTime rd2 = ParsedDateTime.parse(str, tzmap);
        rdate.addValue(rd2);
        addRules.add(new SingleDates(rdate, duration));
        str = "TZID=\"" + pacific.getID() + "\":20090216T120000";
        ParsedDateTime ridDtModify1 = ParsedDateTime.parse(str, tzmap);
        RecurId ridModify1 = new RecurId(ridDtModify1, RecurId.RANGE_NONE);
        str = "TZID=\"" + pacific.getID() + "\":20090216T130000";
        ParsedDateTime dtStartModify1 = ParsedDateTime.parse(str, tzmap);
        ParsedDuration durModify1 = ParsedDuration.parse("PT2H");
        ExceptionRule modify1 = new ExceptionRule(ridModify1, dtStartModify1, durModify1, null);
        str = "TZID=\"" + pacific.getID() + "\":20090119T120000";
        ParsedDateTime dtCancel1 = ParsedDateTime.parse(str, tzmap);
        RecurId ridCancel1 = new RecurId(dtCancel1, RecurId.RANGE_NONE);
        CancellationRule cancel1 = new CancellationRule(ridCancel1);
        RdateExdate exdate = new RdateExdate(ZCalendar.ICalTok.EXDATE, pacific);
        str = "TZID=\"" + pacific.getID() + "\":20090209T120000";
        ParsedDateTime ex1 = ParsedDateTime.parse(str, tzmap);
        exdate.addValue(ex1);
        SingleDates exdateRule = new SingleDates(exdate, duration);
        subRules.add(exdateRule);
        RecurrenceRule recurrence = new RecurrenceRule(dtStart, duration, null, addRules, subRules);
        recurrence.addException(modify1);
        recurrence.addException(cancel1);
        GregorianCalendar startCal = new GregorianCalendar(pacific);
        startCal.clear();
        startCal.set(2009, 0, 1, 0, 0, 0);
        Calendar endCal = (Calendar)((Calendar)startCal).clone();
        endCal.add(1, 1);
        List<CalendarItem.Instance> instances = recurrence.expandInstances(-1, startCal.getTimeInMillis(), Long.MAX_VALUE);
        for (CalendarItem.Instance inst : instances) {
            System.out.println(inst);
        }
        System.out.println("Got " + instances.size() + " instances");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecurrenceRule
    extends CompoundRuleBase {
        static final String FN_NUM_EXCEPTIONS = "numEx";
        static final String FN_EXCEPTION = "ex";
        static final String FN_CANCELLATION = "ca";
        protected List<IException> mExceptions;

        public RecurrenceRule(ParsedDateTime dtstart, ParsedDuration duration, InviteInfo invId, List<IRecurrence> addRules, List<IRecurrence> subtractRules) {
            super(dtstart, duration, invId, addRules, subtractRules);
            this.mExceptions = new ArrayList<IException>();
        }

        public RecurrenceRule(ParsedDateTime dtstart, ParsedDuration duration, InviteInfo invId) {
            super(dtstart, duration, invId);
            this.mExceptions = new ArrayList<IException>();
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public void setInviteId(InviteInfo invId) {
            super.setInviteId(invId);
            assert (this.mExceptions.size() == 0);
        }

        public Iterator<IException> exceptionsIter() {
            return this.mExceptions.iterator();
        }

        public RecurrenceRule(Metadata meta, TimeZoneMap tzmap) throws ServiceException, ParseException {
            super(meta, tzmap);
            int numEx = (int)meta.getLong(FN_NUM_EXCEPTIONS);
            this.mExceptions = new ArrayList<IException>(numEx);
            for (int i = 0; i < numEx; ++i) {
                if (meta.containsKey(FN_EXCEPTION + i)) {
                    this.mExceptions.add(i, new ExceptionRule(meta.getMap(FN_EXCEPTION + i), tzmap));
                    continue;
                }
                if (!meta.containsKey(FN_CANCELLATION + i)) continue;
                this.mExceptions.add(i, new CancellationRule(meta.getMap(FN_CANCELLATION + i), tzmap));
            }
        }

        @Override
        public Element toXml(Element parent) {
            for (IException cur : this.mExceptions) {
                cur.toXml(parent);
            }
            super.toXml(parent);
            return parent;
        }

        public void addException(IException rule) {
            this.mExceptions.add(rule);
        }

        @Override
        public List<CalendarItem.Instance> expandInstances(int calItemId, long start, long end) throws ServiceException {
            List<CalendarItem.Instance> toRet;
            long startAdjusted = start;
            long endAdjusted = end;
            for (IException except : this.mExceptions) {
                long etTime;
                ParsedDateTime et;
                long stTime;
                ParsedDateTime dt;
                RecurId rid;
                if (except == null || (rid = except.getRecurId()) == null || (dt = rid.getDt()) == null) continue;
                long recurIdTime = dt.getUtcTime();
                ParsedDateTime parsedDateTime = except.getStartTime();
                if (parsedDateTime != null && (stTime = parsedDateTime.getUtcTime()) >= start && stTime < end) {
                    if (recurIdTime < startAdjusted) {
                        startAdjusted = recurIdTime;
                    } else if (recurIdTime > endAdjusted) {
                        endAdjusted = recurIdTime + 1L;
                    }
                }
                if (end >= Long.MAX_VALUE || (et = except.getEndTime()) == null || (etTime = et.getUtcTime()) <= start || etTime > end) continue;
                if (recurIdTime < startAdjusted) {
                    startAdjusted = recurIdTime;
                    continue;
                }
                if (recurIdTime <= endAdjusted) continue;
                endAdjusted = recurIdTime + 1L;
            }
            List<CalendarItem.Instance> stdInstances = super.expandInstances(calItemId, startAdjusted, endAdjusted);
            Iterator<CalendarItem.Instance> iter = stdInstances.iterator();
            block1: while (iter.hasNext()) {
                CalendarItem.Instance inst = iter.next();
                if (inst == null) continue;
                long st = inst.getStart();
                long et = inst.getEnd();
                if (et < start || st >= end) {
                    iter.remove();
                    continue;
                }
                for (IException except : this.mExceptions) {
                    if (except == null || !except.matches(inst.getStart())) continue;
                    iter.remove();
                    continue block1;
                }
            }
            ArrayList<List<CalendarItem.Instance>> exceptionInstancesList = new ArrayList<List<CalendarItem.Instance>>();
            for (IException except : this.mExceptions) {
                if (except == null) continue;
                List<CalendarItem.Instance> instances = except.expandInstances(calItemId, startAdjusted, endAdjusted);
                Iterator<CalendarItem.Instance> iter2 = instances.iterator();
                while (iter2.hasNext()) {
                    CalendarItem.Instance instance = iter2.next();
                    if (instance == null) continue;
                    long st = instance.getStart();
                    long et = instance.getEnd();
                    if (et >= start && st < end) continue;
                    iter2.remove();
                }
                if (instances.isEmpty()) continue;
                exceptionInstancesList.add(instances);
            }
            if (exceptionInstancesList.isEmpty()) {
                toRet = stdInstances;
            } else {
                toRet = new ArrayList<CalendarItem.Instance>();
                List[] toAdd = new List[exceptionInstancesList.size() + 1];
                toAdd[0] = stdInstances;
                int offset = 1;
                for (List list : exceptionInstancesList) {
                    toAdd[offset++] = list;
                }
                ListUtil.mergeSortedLists(toRet, toAdd, true);
            }
            return toRet;
        }

        @Override
        public String toString() {
            StringBuffer toRet = new StringBuffer();
            toRet.append("RECUR(").append(super.toString());
            for (IException ex : this.mExceptions) {
                toRet.append("\n\t\t").append(ex.toString());
            }
            toRet.append(")");
            return toRet.toString();
        }

        @Override
        public Metadata encodeMetadata() {
            Metadata meta = super.encodeMetadata();
            meta.put(Recurrence.FN_RULE_TYPE, Integer.toString(4));
            meta.put(FN_NUM_EXCEPTIONS, Integer.toString(this.mExceptions.size()));
            for (int i = 0; i < this.mExceptions.size(); ++i) {
                IException cur = this.mExceptions.get(i);
                if (cur instanceof ExceptionRule) {
                    meta.put(FN_EXCEPTION + i, cur.encodeMetadata());
                    continue;
                }
                meta.put(FN_CANCELLATION + i, cur.encodeMetadata());
            }
            return meta;
        }

        private RecurrenceRule(RecurrenceRule other) {
            super(other.mDtStart, other.mDuration, other.mAddRules == null ? null : (MultiRuleSorter)other.mAddRules.clone(), other.mSubtractRules == null ? null : (MultiRuleSorter)other.mSubtractRules.clone(), other.mInvId);
            this.mExceptions = new ArrayList<IException>();
            for (IException cur : other.mExceptions) {
                this.mExceptions.add((IException)cur.clone());
            }
        }

        @Override
        public Object clone() {
            return new RecurrenceRule(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExceptionRule
    extends CompoundRuleBase
    implements IException {
        static final String FN_RECURRENCE_ID = "recurId";
        static final String FN_RANGE_TYPE = "rgtyp";
        private RecurId mRecurRange;

        public ExceptionRule(RecurId recurrenceId, ParsedDateTime dtstart, ParsedDuration duration, InviteInfo invId, List<IRecurrence> addRules, List<IRecurrence> subtractRules) {
            super(dtstart, duration, invId, addRules, subtractRules);
            this.mRecurRange = recurrenceId;
        }

        public ExceptionRule(RecurId recurrenceId, ParsedDateTime dtstart, ParsedDuration duration, InviteInfo invId) {
            super(dtstart, duration, invId);
            this.mRecurRange = recurrenceId;
        }

        protected ExceptionRule(Metadata meta, TimeZoneMap tzmap) throws ParseException, ServiceException {
            super(meta, tzmap);
            this.mRecurRange = RecurId.decodeMetadata(meta.getMap(FN_RECURRENCE_ID), tzmap);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public List<CalendarItem.Instance> expandInstances(int calItemId, long start, long end) throws ServiceException {
            List<CalendarItem.Instance> toRet = super.expandInstances(calItemId, start, end);
            for (CalendarItem.Instance cur : toRet) {
                cur.setIsException(true);
            }
            return toRet;
        }

        @Override
        public Element toXml(Element parent) {
            Element elt = parent.addElement("except");
            this.mRecurRange.toXml(elt);
            super.toXml(elt);
            return elt;
        }

        @Override
        public Metadata encodeMetadata() {
            Metadata meta = super.encodeMetadata();
            meta.put(Recurrence.FN_RULE_TYPE, 3L);
            meta.put(FN_RECURRENCE_ID, this.mRecurRange.encodeMetadata());
            return meta;
        }

        @Override
        public boolean matches(long date) {
            return this.mRecurRange.withinRange(date);
        }

        @Override
        public RecurId getRecurId() {
            return this.mRecurRange;
        }

        @Override
        public String toString() {
            StringBuffer toRet = new StringBuffer("EXCEPTION(");
            toRet.append(this.mRecurRange.toString());
            toRet.append(" ");
            toRet.append(super.toString());
            return toRet.toString();
        }

        private ExceptionRule(ExceptionRule other) {
            super(other.mDtStart, other.mDuration, other.mAddRules == null ? null : (MultiRuleSorter)other.mAddRules.clone(), other.mSubtractRules == null ? null : (MultiRuleSorter)other.mSubtractRules.clone(), other.mInvId);
            this.mRecurRange = other.mRecurRange;
        }

        @Override
        public Object clone() {
            return new ExceptionRule(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancellationRule
    implements IException {
        private static final String FN_RECURRENCE_ID = "recurId";
        private RecurId mRecurRange;

        public CancellationRule(RecurId recurId) {
            this.mRecurRange = recurId;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public Iterator addRulesIterator() {
            return null;
        }

        @Override
        public Iterator subRulesIterator() {
            return null;
        }

        @Override
        public void setInviteId(InviteInfo invId) {
        }

        @Override
        public InviteInfo getInviteInfo() {
            return null;
        }

        CancellationRule(Metadata meta, TimeZoneMap tzmap) throws ServiceException, ParseException {
            this.mRecurRange = RecurId.decodeMetadata(meta.getMap(FN_RECURRENCE_ID), tzmap);
        }

        @Override
        public Metadata encodeMetadata() {
            Metadata meta = new Metadata();
            meta.put(FN_RECURRENCE_ID, this.mRecurRange.encodeMetadata());
            return meta;
        }

        @Override
        public List<CalendarItem.Instance> expandInstances(int calItemId, long start, long end) {
            return new ArrayList<CalendarItem.Instance>();
        }

        @Override
        public ParsedDateTime getStartTime() {
            return null;
        }

        @Override
        public ParsedDateTime getEndTime() {
            return null;
        }

        @Override
        public Object clone() {
            return new CancellationRule(this.mRecurRange);
        }

        @Override
        public Element toXml(Element parent) {
            Element elt = parent.addElement("cancel");
            this.mRecurRange.toXml(elt);
            return elt;
        }

        @Override
        public boolean matches(long date) {
            return this.mRecurRange.withinRange(date);
        }

        @Override
        public RecurId getRecurId() {
            return this.mRecurRange;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CompoundRuleBase
    implements IRecurrence {
        static final String FN_DTSTART = "dts";
        static final String FN_DURATION = "duration";
        static final String FN_ADDRULES = "add";
        static final String FN_SUBRULES = "sub";
        static final String FN_INVID = "invid";
        protected ParsedDateTime mDtStart;
        protected ParsedDuration mDuration;
        protected MultiRuleSorter mAddRules;
        protected MultiRuleSorter mSubtractRules;
        protected InviteInfo mInvId;

        protected CompoundRuleBase(ParsedDateTime dtstart, ParsedDuration duration, InviteInfo invId, List<IRecurrence> addRules, List<IRecurrence> subtractRules) {
            this.mDtStart = dtstart;
            this.mDuration = duration;
            if (this.mDuration == null) {
                this.mDuration = this.mDtStart != null && !this.mDtStart.hasTime() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
            }
            this.mInvId = invId;
            this.mAddRules = new MultiRuleSorter(addRules);
            this.mSubtractRules = subtractRules.size() > 0 ? new MultiRuleSorter(subtractRules) : null;
        }

        @Override
        public void setInviteId(InviteInfo invId) {
            this.mInvId = invId;
            this.mAddRules.setInviteId(invId);
            if (this.mSubtractRules != null) {
                this.mSubtractRules.setInviteId(invId);
            }
        }

        @Override
        public InviteInfo getInviteInfo() {
            return this.mInvId;
        }

        protected CompoundRuleBase(ParsedDateTime dtstart, ParsedDuration duration, InviteInfo invId) {
            this.mDtStart = dtstart;
            this.mDuration = duration;
            if (this.mDuration == null) {
                this.mDuration = this.mDtStart != null && !this.mDtStart.hasTime() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
            }
            this.mInvId = invId;
            this.mAddRules = null;
            this.mSubtractRules = null;
        }

        @Override
        public Iterator<IRecurrence> addRulesIterator() {
            return this.mAddRules.iterator();
        }

        @Override
        public Iterator<IRecurrence> subRulesIterator() {
            if (this.mSubtractRules != null) {
                return this.mSubtractRules.iterator();
            }
            return null;
        }

        @Override
        public List<CalendarItem.Instance> expandInstances(int calItemId, long start, long end) throws ServiceException {
            long firstEnd;
            if (this.mDtStart == null) {
                ZimbraLog.calendar.warn("Unable to expand a recurrence with no DTSTART");
                return new ArrayList<CalendarItem.Instance>(0);
            }
            List<Object> toAdd = this.mAddRules != null ? this.mAddRules.expandInstances(calItemId, start, end) : new ArrayList(1);
            long firstStart = this.mDtStart.getUtcTime();
            long l = firstEnd = this.mDuration != null ? this.mDtStart.add(this.mDuration).getUtcTime() : firstStart;
            if (firstStart < end && firstEnd > start) {
                CalendarItem.Instance first = null;
                if (toAdd.size() > 0) {
                    first = (CalendarItem.Instance)toAdd.get(0);
                }
                CalendarItem.Instance dtstartInst = new CalendarItem.Instance(calItemId, this.mInvId, false, firstStart, firstEnd, !this.mDtStart.hasTime(), this.mDtStart.getOffset(), false, true);
                if (first == null || first.compareTo(dtstartInst) != 0) {
                    assert (first == null || first.compareTo(dtstartInst) > 0);
                    toAdd.add(0, dtstartInst);
                }
            }
            if (this.mSubtractRules == null) {
                return toAdd;
            }
            List<CalendarItem.Instance> toExclude = this.mSubtractRules.expandInstances(calItemId, start, end);
            return ListUtil.subtractSortedLists(toAdd, toExclude, new CalendarItem.Instance.StartTimeComparator());
        }

        @Override
        public Element toXml(Element parent) {
            if (this.mAddRules != null) {
                Element addElt = parent.addElement(FN_ADDRULES);
                this.mAddRules.toXml(addElt);
            }
            if (this.mSubtractRules != null) {
                Element excludeElt = parent.addElement("exclude");
                this.mSubtractRules.toXml(excludeElt);
            }
            return parent;
        }

        @Override
        public ParsedDateTime getStartTime() {
            return this.mDtStart;
        }

        @Override
        public ParsedDateTime getEndTime() throws ServiceException {
            if (this.mAddRules != null) {
                return this.mAddRules.getEndTime();
            }
            if (this.mDtStart != null) {
                return this.mDtStart.add(this.mDuration);
            }
            return null;
        }

        @Override
        public Metadata encodeMetadata() {
            Metadata meta = new Metadata();
            meta.put(FN_DTSTART, this.mDtStart);
            meta.put(FN_DURATION, this.mDuration);
            if (this.mAddRules != null) {
                meta.put(FN_ADDRULES, this.mAddRules.encodeMetadata());
            }
            if (this.mSubtractRules != null) {
                meta.put(FN_SUBRULES, this.mSubtractRules.encodeMetadata());
            }
            if (this.mInvId != null) {
                meta.put(FN_INVID, this.mInvId.encodeMetadata());
            }
            return meta;
        }

        protected CompoundRuleBase(Metadata meta, TimeZoneMap tzmap) throws ServiceException, ParseException {
            Metadata metaInvId;
            Metadata metaSubrules;
            Metadata metaRules;
            String str = meta.get(FN_DTSTART, null);
            this.mDtStart = ParsedDateTime.parse(str, tzmap);
            this.mDuration = ParsedDuration.parse(meta.get(FN_DURATION, null));
            if (this.mDuration == null) {
                this.mDuration = this.mDtStart != null && !this.mDtStart.hasTime() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
            }
            if ((metaRules = meta.getMap(FN_ADDRULES, true)) != null) {
                this.mAddRules = new MultiRuleSorter(metaRules, tzmap);
            }
            if ((metaSubrules = meta.getMap(FN_SUBRULES, true)) != null) {
                this.mSubtractRules = new MultiRuleSorter(metaSubrules, tzmap);
            }
            if ((metaInvId = meta.getMap(FN_INVID, true)) != null) {
                this.mInvId = InviteInfo.fromMetadata(metaInvId, tzmap);
            }
        }

        protected CompoundRuleBase(ParsedDateTime dtstart, ParsedDuration duration, MultiRuleSorter addRules, MultiRuleSorter subtractRules, InviteInfo invID) {
            this.mDtStart = dtstart;
            this.mDuration = duration;
            if (this.mDuration == null) {
                this.mDuration = this.mDtStart != null && !this.mDtStart.hasTime() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
            }
            this.mAddRules = addRules;
            this.mSubtractRules = subtractRules;
            this.mInvId = invID;
        }

        public String toString() {
            StringBuffer toRet = new StringBuffer();
            toRet.append("FIRST=").append(this.mDtStart != null ? this.mDtStart.getDate() : "<none>");
            toRet.append(",DUR=").append(this.mDuration);
            if (this.mAddRules != null) {
                toRet.append("\n\t\tADD[").append(this.mAddRules.toString()).append("]");
            }
            if (this.mSubtractRules != null) {
                toRet.append("\n\t\tSUBTRACT[").append(this.mSubtractRules.toString()).append("]");
            }
            return toRet.toString();
        }

        @Override
        public abstract Object clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleRepeatingRule
    implements IInstanceGeneratingRule {
        private static final String FN_DTSTART = "dts";
        private static final String FN_DURATION = "dur";
        private static final String FN_RECUR = "recur";
        private static final String FN_INVID = "inv";
        private ParsedDateTime mDtStart;
        private ZRecur mRecur;
        private ParsedDuration mDuration;
        private InviteInfo mInvId;

        public SimpleRepeatingRule(ParsedDateTime dtstart, ParsedDuration duration, ZRecur recur, InviteInfo invId) {
            this.mDtStart = dtstart;
            this.mRecur = recur;
            this.fixupRecurUntil();
            this.mInvId = invId;
            this.mDuration = duration;
            if (this.mDuration == null) {
                this.mDuration = this.mDtStart != null && !this.mDtStart.hasTime() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
            }
        }

        private void fixupRecurUntil() {
            ParsedDateTime until;
            if (this.mRecur != null && this.mDtStart != null && (until = this.mRecur.getUntil()) != null && until.hasTime() != this.mDtStart.hasTime()) {
                if (this.mDtStart.hasTime()) {
                    Date dayEnd = until.getDateForRecurUntil(this.mDtStart.getTimeZone());
                    ParsedDateTime untilUtc = ParsedDateTime.fromUTCTime(dayEnd.getTime());
                    this.mRecur.setUntil(untilUtc);
                } else {
                    until.setHasTime(false);
                }
            }
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public Iterator addRulesIterator() {
            return null;
        }

        @Override
        public Iterator subRulesIterator() {
            return null;
        }

        @Override
        public void setInviteId(InviteInfo invId) {
            this.mInvId = invId;
        }

        @Override
        public InviteInfo getInviteInfo() {
            return this.mInvId;
        }

        @Override
        public Element toXml(Element parent) {
            ZRecur.ZWeekDay wkst;
            List<Integer> bySetPos;
            List<Integer> byMonth;
            List<Integer> byWeekNo;
            List<Integer> byYearDay;
            List<Integer> byMonthDay;
            List<ZRecur.ZWeekDayNum> byDay;
            List<Integer> byHour;
            List<Integer> byMinute;
            List<Integer> bySecond;
            Element rule = parent.addElement("rule");
            String freq = IcalXmlStrMap.sFreqMap.toXml(this.mRecur.getFrequency().toString());
            rule.addAttribute("freq", freq);
            ParsedDateTime untilDate = this.mRecur.getUntil();
            if (untilDate != null) {
                Element untilElt = rule.addElement("until");
                untilElt.addAttribute("d", untilDate.getDateTimePartString(false));
            } else {
                int count = this.mRecur.getCount();
                if (count > 0) {
                    rule.addElement("count").addAttribute("num", count);
                }
            }
            int ival = this.mRecur.getInterval();
            if (ival > 0) {
                rule.addElement("interval").addAttribute("ival", ival);
            }
            if (!(bySecond = this.mRecur.getBySecondList()).isEmpty()) {
                rule.addElement("bysecond").addAttribute("seclist", ZRecur.listAsStr(bySecond));
            }
            if (!(byMinute = this.mRecur.getByMinuteList()).isEmpty()) {
                rule.addElement("byminute").addAttribute("minlist", ZRecur.listAsStr(byMinute));
            }
            if (!(byHour = this.mRecur.getByHourList()).isEmpty()) {
                rule.addElement("byhour").addAttribute("hrlist", ZRecur.listAsStr(byHour));
            }
            if (!(byDay = this.mRecur.getByDayList()).isEmpty()) {
                Element bydayElt = rule.addElement("byday");
                for (ZRecur.ZWeekDayNum wdn : byDay) {
                    Element wkdayElt = bydayElt.addElement("wkday");
                    if (wdn.mOrdinal != 0) {
                        wkdayElt.addAttribute("ordwk", wdn.mOrdinal);
                    }
                    wkdayElt.addAttribute("day", wdn.mDay.toString());
                }
            }
            if (!(byMonthDay = this.mRecur.getByMonthDayList()).isEmpty()) {
                rule.addElement("bymonthday").addAttribute("modaylist", ZRecur.listAsStr(byMonthDay));
            }
            if (!(byYearDay = this.mRecur.getByYearDayList()).isEmpty()) {
                rule.addElement("byyearday").addAttribute("yrdaylist", ZRecur.listAsStr(byYearDay));
            }
            if (!(byWeekNo = this.mRecur.getByWeekNoList()).isEmpty()) {
                rule.addElement("byweekno").addAttribute("wklist", ZRecur.listAsStr(byWeekNo));
            }
            if (!(byMonth = this.mRecur.getByMonthList()).isEmpty()) {
                rule.addElement("bymonth").addAttribute("molist", ZRecur.listAsStr(byMonth));
            }
            if (!(bySetPos = this.mRecur.getBySetPosList()).isEmpty()) {
                rule.addElement("bysetpos").addAttribute("poslist", ZRecur.listAsStr(bySetPos));
            }
            if ((wkst = this.mRecur.getWkSt()) != null) {
                rule.addElement("wkst").addAttribute("day", wkst.toString());
            }
            return rule;
        }

        @Override
        public List<CalendarItem.Instance> expandInstances(int calItemId, long start, long end) {
            if (this.mDtStart == null) {
                ZimbraLog.calendar.warn("Unable to expand a recurrence with no DTSTART");
                return new ArrayList<CalendarItem.Instance>();
            }
            ICalTimeZone tz = this.mDtStart.getTimeZone();
            if (tz == null) {
                tz = ICalTimeZone.getUTC();
            }
            ArrayList<CalendarItem.Instance> toRet = null;
            try {
                long duration = 0L;
                if (this.mDuration != null) {
                    ParsedDateTime et = this.mDtStart.add(this.mDuration);
                    duration = et.getUtcTime() - this.mDtStart.getUtcTime();
                }
                List<Date> dateList = this.mRecur.expandRecurrenceOverRange(this.mDtStart, start - duration, end);
                toRet = new ArrayList(dateList.size());
                int num = 0;
                for (Date cur : dateList) {
                    long instEnd;
                    long instStart = cur.getTime();
                    if (this.mDuration != null) {
                        ParsedDateTime startDt = ParsedDateTime.fromUTCTime(instStart, tz);
                        instEnd = startDt.add(this.mDuration).getUtcTime();
                    } else {
                        instEnd = instStart;
                    }
                    if (instStart >= end || instEnd <= start) continue;
                    int tzOffset = tz.getOffset(instStart);
                    toRet.add(num++, new CalendarItem.Instance(calItemId, this.mInvId, false, instStart, instEnd, !this.mDtStart.hasTime(), tzOffset, false, false));
                }
            }
            catch (ServiceException se) {
                ZimbraLog.calendar.warn((Object)("ServiceException expanding recurrence rule: " + this.mRecur.toString()), se);
                toRet = new ArrayList<CalendarItem.Instance>();
            }
            catch (IllegalArgumentException iae) {
                ZimbraLog.calendar.warn((Object)("Invalid recurrence rule: " + this.mRecur.toString()), iae);
                toRet = new ArrayList();
            }
            return toRet;
        }

        public ZRecur getRule() {
            return this.mRecur;
        }

        @Override
        public ParsedDateTime getStartTime() {
            return this.mDtStart;
        }

        @Override
        public ParsedDateTime getEndTime() throws ServiceException {
            if (this.mDtStart == null) {
                return ParsedDateTime.MAX_DATETIME;
            }
            if (this.mRecur != null) {
                List<Date> dates;
                long endMillis = this.mRecur.getEstimatedEndTime(this.mDtStart).getTime();
                if (this.mRecur.getCount() > 0 && !(dates = this.mRecur.expandRecurrenceOverRange(this.mDtStart, this.mDtStart.getUtcTime(), endMillis)).isEmpty()) {
                    endMillis = dates.get(dates.size() - 1).getTime();
                }
                ParsedDateTime end = ParsedDateTime.fromUTCTime(endMillis, this.mDtStart.getTimeZone());
                if (this.mDuration != null) {
                    end = end.add(this.mDuration);
                }
                return end;
            }
            ParsedDuration dur = this.mDuration != null ? this.mDuration : ParsedDuration.parse(false, 0, 0, 0, 0, 1);
            return this.mDtStart.add(dur);
        }

        public String toString() {
            StringBuilder toRet = new StringBuilder();
            toRet.append("RULE(FIRST=").append(this.mDtStart != null ? this.mDtStart.getDate() : "<none>");
            toRet.append(",DUR=").append(this.mDuration);
            toRet.append(",RECUR=").append(this.mRecur.toString());
            return toRet.toString();
        }

        @Override
        public Metadata encodeMetadata() {
            Metadata meta = new Metadata();
            meta.put(Recurrence.FN_RULE_TYPE, 2L);
            meta.put(FN_DTSTART, this.mDtStart);
            meta.put(FN_DURATION, this.mDuration);
            meta.put(FN_RECUR, this.mRecur);
            if (this.mInvId != null) {
                meta.put(FN_INVID, this.mInvId.encodeMetadata());
            }
            return meta;
        }

        @Override
        public Object clone() {
            return new SimpleRepeatingRule(this.mDtStart, this.mDuration, this.mRecur, this.mInvId);
        }

        public SimpleRepeatingRule(Metadata meta, TimeZoneMap tzmap) throws ServiceException {
            try {
                this.mDtStart = ParsedDateTime.parse(meta.get(FN_DTSTART, null), tzmap);
                this.mDuration = ParsedDuration.parse(meta.get(FN_DURATION, null));
                if (this.mDuration == null) {
                    this.mDuration = this.mDtStart != null && !this.mDtStart.hasTime() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
                }
            }
            catch (ParseException e) {
                throw ServiceException.FAILURE("ParseException ", e);
            }
            this.mRecur = new ZRecur(meta.get(FN_RECUR).toString(), tzmap);
            Metadata metaInvId = meta.getMap(FN_INVID, true);
            if (metaInvId != null) {
                this.mInvId = InviteInfo.fromMetadata(metaInvId, tzmap);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleDates
    implements IInstanceGeneratingRule {
        private static final String FN_RDATE_EXDATE = "rexd";
        private static final String FN_DEFAULT_DURATION = "defdur";
        private static final String FN_INVID = "inv";
        private RdateExdate mRdateExdate;
        private ParsedDuration mDefaultDuration;
        private InviteInfo mInvId;
        private List<DateValue> mDates;

        @Override
        public int getType() {
            return 6;
        }

        public RdateExdate getRdateExdate() {
            return this.mRdateExdate;
        }

        @Override
        public Iterator addRulesIterator() {
            return null;
        }

        @Override
        public Iterator subRulesIterator() {
            return null;
        }

        @Override
        public void setInviteId(InviteInfo invId) {
            this.mInvId = invId;
        }

        @Override
        public InviteInfo getInviteInfo() {
            return this.mInvId;
        }

        public String toString() {
            StringBuilder toRet = new StringBuilder("[");
            if (this.mRdateExdate != null) {
                if (this.mRdateExdate.isRDATE()) {
                    toRet.append("rdate=[");
                } else {
                    toRet.append("exdate=[");
                }
                toRet.append(this.mRdateExdate.toString()).append("]");
            } else {
                toRet.append("rdate/exdate=<none>");
            }
            toRet.append(", defaultDuration=").append(this.mDefaultDuration.toString());
            if (this.mInvId != null) {
                toRet.append(", InvId=").append(this.mInvId.toString()).append("]");
            }
            return toRet.toString();
        }

        @Override
        public ParsedDateTime getStartTime() {
            ParsedDateTime start = null;
            for (DateValue val : this.mDates) {
                ParsedDateTime valStart = val.getStartTime();
                if (start != null && start.compareTo(valStart) <= 0) continue;
                start = valStart;
            }
            return start;
        }

        @Override
        public ParsedDateTime getEndTime() {
            ParsedDateTime end = null;
            for (DateValue val : this.mDates) {
                ParsedDateTime valEnd = val.getEndTime();
                if (end != null && end.compareTo(valEnd) >= 0) continue;
                end = valEnd;
            }
            return end;
        }

        @Override
        public List<CalendarItem.Instance> expandInstances(int calItemId, long start, long end) {
            ArrayList<CalendarItem.Instance> list = new ArrayList<CalendarItem.Instance>();
            for (DateValue val : this.mDates) {
                ParsedDateTime valStart = val.getStartTime();
                ParsedDateTime valEnd = val.getEndTime();
                list.add(new CalendarItem.Instance(calItemId, this.mInvId, false, valStart.getUtcTime(), valEnd.getUtcTime(), !valStart.hasTime(), valStart.getOffset(), true, true));
            }
            Collections.sort(list);
            return list;
        }

        @Override
        public Metadata encodeMetadata() {
            Metadata meta = new Metadata();
            meta.put(Recurrence.FN_RULE_TYPE, 6L);
            meta.put(FN_RDATE_EXDATE, this.mRdateExdate.encodeMetadata());
            meta.put(FN_DEFAULT_DURATION, this.mDefaultDuration);
            if (this.mInvId != null) {
                meta.put(FN_INVID, this.mInvId.encodeMetadata());
            }
            return meta;
        }

        SingleDates(Metadata meta, TimeZoneMap tzmap) throws ServiceException, ParseException {
            Metadata rexdate = meta.getMap(FN_RDATE_EXDATE);
            this.mRdateExdate = RdateExdate.decodeMetadata(rexdate, tzmap);
            this.mDefaultDuration = ParsedDuration.parse(meta.get(FN_DEFAULT_DURATION));
            Metadata metaInvId = meta.getMap(FN_INVID, true);
            if (metaInvId != null) {
                this.mInvId = InviteInfo.fromMetadata(metaInvId, tzmap);
            }
            this.setDates();
        }

        public SingleDates(RdateExdate rexdate, ParsedDuration defaultDuration) {
            this(rexdate, defaultDuration, null);
        }

        SingleDates(RdateExdate rexdate, ParsedDuration defaultDuration, InviteInfo invId) {
            this.mRdateExdate = rexdate;
            this.mDefaultDuration = defaultDuration;
            this.mInvId = invId;
            this.setDates();
        }

        private void setDates() {
            ArrayList<DateValue> list = new ArrayList<DateValue>(this.mRdateExdate.numValues());
            Iterator<Object> iter = this.mRdateExdate.valueIterator();
            while (iter.hasNext()) {
                Object val = iter.next();
                if (val instanceof ParsedDateTime) {
                    ParsedDateTime start = (ParsedDateTime)val;
                    ParsedDateTime end = start.add(this.mDefaultDuration);
                    DateValue dtval = new DateValue(start, end);
                    list.add(dtval);
                    continue;
                }
                if (!(val instanceof Period)) continue;
                Period p = (Period)val;
                DateValue dtval = new DateValue(p.getStart(), p.getEnd());
                list.add(dtval);
            }
            this.mDates = list;
        }

        @Override
        public Element toXml(Element parent) {
            return this.mRdateExdate.toXml(parent);
        }

        @Override
        public Object clone() {
            return new SingleDates(this.mRdateExdate, this.mDefaultDuration, this.mInvId);
        }

        private static class DateValue {
            private ParsedDateTime mStart;
            private ParsedDateTime mEnd;

            public DateValue(ParsedDateTime start, ParsedDateTime end) {
                assert (start != null && end != null);
                this.mStart = start;
                this.mEnd = end;
            }

            public ParsedDateTime getStartTime() {
                return this.mStart;
            }

            public ParsedDateTime getEndTime() {
                return this.mEnd;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("[start=").append(this.mStart.toString());
                sb.append(", end=").append(this.mEnd.toString());
                sb.append("]");
                return sb.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiRuleSorter {
        private static final String FN_NUM_RULES = "nr";
        private static final String FN_RULE = "r";
        private List<IRecurrence> mRules;

        public Metadata encodeMetadata() {
            Metadata meta = new Metadata();
            meta.put(FN_NUM_RULES, this.mRules.size());
            for (int i = 0; i < this.mRules.size(); ++i) {
                meta.put(FN_RULE + i, this.mRules.get(i).encodeMetadata());
            }
            return meta;
        }

        public Object clone() {
            ArrayList<IRecurrence> newRules = new ArrayList<IRecurrence>();
            for (IRecurrence rule : this.mRules) {
                newRules.add((IRecurrence)rule.clone());
            }
            return new MultiRuleSorter(newRules);
        }

        public Iterator<IRecurrence> iterator() {
            return this.mRules.iterator();
        }

        public MultiRuleSorter(Metadata meta, TimeZoneMap tzmap) throws ServiceException {
            int numRules = (int)meta.getLong(FN_NUM_RULES);
            this.mRules = new ArrayList<IRecurrence>(numRules);
            for (int i = 0; i < numRules; ++i) {
                try {
                    this.mRules.add(Recurrence.decodeMetadata(meta.getMap(FN_RULE + i), tzmap));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public MultiRuleSorter(List<IRecurrence> rules) {
            assert (rules == null || rules.size() == 0 || rules.get(0) instanceof IInstanceGeneratingRule);
            this.mRules = rules;
        }

        public void setInviteId(InviteInfo invId) {
            for (IRecurrence cur : this.mRules) {
                cur.setInviteId(invId);
            }
        }

        public Element toXml(Element parent) {
            for (IRecurrence cur : this.mRules) {
                parent.addElement(cur.toXml(parent));
            }
            return parent;
        }

        List<CalendarItem.Instance> expandInstances(int calItemId, long start, long end) throws ServiceException {
            ArrayList[] lists = new ArrayList[this.mRules.size()];
            int num = 0;
            for (IRecurrence cur : this.mRules) {
                lists[num] = cur.expandInstances(calItemId, start, end);
                ++num;
            }
            LinkedList<CalendarItem.Instance> toRet = new LinkedList<CalendarItem.Instance>();
            ListUtil.mergeSortedLists(toRet, lists, true);
            return toRet;
        }

        public String toString() {
            StringBuffer toRet = new StringBuffer();
            toRet.append("(");
            for (IRecurrence rule : this.mRules) {
                toRet.append(rule.toString());
            }
            toRet.append(")");
            return toRet.toString();
        }

        public ParsedDateTime getStartTime() {
            ParsedDateTime earliestStart = null;
            for (IRecurrence cur : this.mRules) {
                ParsedDateTime start = cur.getStartTime();
                if (earliestStart != null && (start == null || start.compareTo(earliestStart) >= 0)) continue;
                earliestStart = start;
            }
            return earliestStart;
        }

        public ParsedDateTime getEndTime() throws ServiceException {
            ParsedDateTime latestEnd = null;
            for (IRecurrence cur : this.mRules) {
                ParsedDateTime end = cur.getEndTime();
                if (latestEnd != null && (end == null || end.compareTo(latestEnd) <= 0)) continue;
                latestEnd = end;
            }
            return latestEnd;
        }
    }

    public static interface IInstanceGeneratingRule
    extends IRecurrence {
        public InviteInfo getInviteInfo();
    }

    public static interface IException
    extends IRecurrence {
        public boolean matches(long var1);

        public RecurId getRecurId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRecurrence
    extends Cloneable {
        public Metadata encodeMetadata();

        public List<CalendarItem.Instance> expandInstances(int var1, long var2, long var4) throws ServiceException;

        public ParsedDateTime getStartTime();

        public ParsedDateTime getEndTime() throws ServiceException;

        public Object clone();

        public int getType();

        public Iterator addRulesIterator();

        public Iterator subRulesIterator();

        public InviteInfo getInviteInfo();

        public void setInviteId(InviteInfo var1);

        public Element toXml(Element var1);
    }
}

