/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.text.ParseException;
import java.util.Date;

public class RecurId {
    public static int RANGE_NONE = 1;
    public static final int RANGE_THISANDFUTURE = 2;
    public static final int RANGE_THISANDPRIOR = 3;
    private int mRange;
    private ParsedDateTime mDateTime;
    private static final String FN_DT = "dt";
    private static final String FN_RANGE = "r";

    public static RecurId createFromInstance(CalendarItem.Instance inst) {
        return new RecurId(ParsedDateTime.fromUTCTime(inst.getStart()), RANGE_NONE);
    }

    public RecurId(ParsedDateTime dt, String rangeStr) {
        int range = RANGE_NONE;
        if (rangeStr != null) {
            if (rangeStr.equals("THISANDFUTURE")) {
                range = 2;
            } else if (rangeStr.equals("THISANDPRIOR")) {
                range = 3;
            }
        }
        this.mRange = range;
        this.mDateTime = dt;
    }

    public RecurId(ParsedDateTime dt, int range) {
        this.mRange = range;
        this.mDateTime = dt;
    }

    public String toString() {
        StringBuffer toRet = new StringBuffer(this.mDateTime.toString());
        String range = this.getRangeStr();
        if (range != null) {
            toRet.append(";RANGE=").append(range);
        }
        return toRet.toString();
    }

    private String getRangeStr() {
        switch (this.mRange) {
            case 2: {
                return "THISANDFUTURE";
            }
            case 3: {
                return "THISANDPRIOR";
            }
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        RecurId rhs = (RecurId)other;
        return this.mRange == rhs.mRange && this.mDateTime.equals(rhs.mDateTime);
    }

    public int getRange() {
        return this.mRange;
    }

    public ParsedDateTime getDt() {
        return this.mDateTime;
    }

    public String getDtZ() {
        return this.mDateTime.getUtcString();
    }

    public boolean withinRange(RecurId other) {
        if (other == null) {
            return false;
        }
        if (other.withinRange(this.mDateTime.getDate())) {
            return true;
        }
        return this.withinRange(other.mDateTime.getDate());
    }

    public boolean withinRange(Date d) {
        int comp = this.mDateTime.compareTo(d);
        if (comp == 0) {
            return true;
        }
        if (comp < 0) {
            return this.mRange == 2;
        }
        return this.mRange == 3;
    }

    public boolean withinRange(long d) {
        int comp = this.mDateTime.compareTo(d);
        if (comp == 0) {
            return true;
        }
        if (comp < 0) {
            return this.mRange == 2;
        }
        return this.mRange == 3;
    }

    public Metadata encodeMetadata() {
        Metadata md = new Metadata();
        md.put(FN_DT, this.mDateTime.toString());
        md.put(FN_RANGE, this.mRange);
        return md;
    }

    public ZCalendar.ZProperty toProperty(boolean useOutlookCompatMode) {
        ZCalendar.ZProperty toRet = this.mDateTime.toProperty(ZCalendar.ICalTok.RECURRENCE_ID, useOutlookCompatMode);
        String range = this.getRangeStr();
        if (range != null) {
            toRet.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.RANGE, range));
        }
        return toRet;
    }

    public Element toXml(Element parent) {
        parent.addAttribute("recurId", this.mDateTime.getDateTimePartString());
        parent.addAttribute("tz", this.mDateTime.getTZName());
        parent.addAttribute("rangeType", this.mRange);
        return parent;
    }

    public static RecurId fromXml(Element e, TimeZoneMap tzMap) throws ServiceException {
        String recurrenceId = e.getAttribute("recurId", null);
        if (recurrenceId == null) {
            return null;
        }
        String rangeType = e.getAttribute("rangeType", null);
        try {
            ParsedDateTime dt = ParsedDateTime.parse(recurrenceId, tzMap);
            if (rangeType != null) {
                return new RecurId(dt, rangeType);
            }
            return new RecurId(dt, RANGE_NONE);
        }
        catch (ParseException x) {
            throw ServiceException.FAILURE("recurId=" + recurrenceId, x);
        }
    }

    public static RecurId decodeMetadata(Metadata md, TimeZoneMap tzmap) throws ServiceException {
        try {
            return new RecurId(ParsedDateTime.parse(md.get(FN_DT), tzmap), (int)md.getLong(FN_RANGE));
        }
        catch (ParseException e) {
            throw ServiceException.FAILURE("Parsing " + md.get(FN_DT), e);
        }
    }
}

