/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.Period;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdateExdate {
    private ZCalendar.ICalTok mPropertyName;
    private ZCalendar.ICalTok mValueType;
    private ICalTimeZone mTimeZone;
    private List<Object> mValues;
    private boolean mIsRdate;
    private static final String FN_IS_RDATE = "isrd";
    private static final String FN_TZID = "tzid";
    private static final String FN_VALUE_TYPE = "vt";
    private static final String FN_NUM_VALUES = "numV";
    private static final String FN_VALUE = "v";
    private static final String VT_DATE_TIME = "dt";
    private static final String VT_DATE = "d";
    private static final String VT_PERIOD = "p";

    public RdateExdate(ZCalendar.ICalTok propName, ICalTimeZone tz) throws ServiceException {
        this(propName, ZCalendar.ICalTok.DATE_TIME, tz);
    }

    RdateExdate(ZCalendar.ICalTok propName, ZCalendar.ICalTok valueType, ICalTimeZone tz) throws ServiceException {
        if (ZCalendar.ICalTok.RDATE.equals((Object)propName)) {
            this.mIsRdate = true;
        } else if (!ZCalendar.ICalTok.EXDATE.equals((Object)propName)) {
            throw ServiceException.INVALID_REQUEST("Property " + propName.toString() + " is neither a RDATE nor an EXDATE", null);
        }
        this.mPropertyName = propName;
        this.mTimeZone = tz;
        this.setValueType(valueType);
        this.mValues = new ArrayList<Object>();
    }

    public void setValueType(ZCalendar.ICalTok valueType) throws ServiceException {
        switch (valueType) {
            case DATE_TIME: 
            case DATE: {
                break;
            }
            case PERIOD: {
                if (this.mIsRdate) break;
                throw ServiceException.INVALID_REQUEST("PERIOD value type not allowed in EXDATE", null);
            }
            default: {
                throw ServiceException.INVALID_REQUEST("Invalid value type " + valueType.toString() + " in " + this.mPropertyName.toString(), null);
            }
        }
        this.mValueType = valueType;
    }

    public void addValue(Object value) {
        this.mValues.add(value);
    }

    public int numValues() {
        return this.mValues.size();
    }

    public Iterator<Object> valueIterator() {
        return this.mValues.iterator();
    }

    public boolean isRDATE() {
        return this.mIsRdate;
    }

    public boolean isEXDATE() {
        return !this.mIsRdate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.mPropertyName.toString());
        if (!ZCalendar.ICalTok.DATE_TIME.equals((Object)this.mValueType)) {
            sb.append(";VALUE=").append(this.mValueType.toString());
        }
        if (this.mTimeZone != null) {
            sb.append(";TZID=").append(this.mTimeZone.getID());
        }
        sb.append(":");
        sb.append(this.getDatesCSV());
        return sb.toString();
    }

    private String getDatesCSV() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object value : this.mValues) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (value instanceof ParsedDateTime) {
                ParsedDateTime t = (ParsedDateTime)value;
                sb.append(t.getDateTimePartString(false));
                continue;
            }
            if (!(value instanceof Period)) continue;
            sb.append(value.toString());
        }
        return sb.toString();
    }

    public Element toXml(Element parent) {
        Element dateElem = parent.addElement("dates");
        if (this.mTimeZone != null) {
            dateElem.addAttribute("tz", this.mTimeZone.getID());
        }
        for (Object val : this.mValues) {
            Element startElem;
            Element dtvalElem = dateElem.addElement("dtval");
            if (val instanceof ParsedDateTime) {
                ParsedDateTime dt = (ParsedDateTime)val;
                startElem = dtvalElem.addElement("s");
                startElem.addAttribute(VT_DATE, dt.getDateTimePartString(false));
                continue;
            }
            if (!(val instanceof Period)) continue;
            Period p = (Period)val;
            startElem = dtvalElem.addElement("s");
            startElem.addAttribute(VT_DATE, p.getStart().getDateTimePartString(false));
            if (p.hasEnd()) {
                Element endElem = dtvalElem.addElement("e");
                endElem.addAttribute(VT_DATE, p.getEnd().getDateTimePartString(false));
                continue;
            }
            p.getDuration().toXml(dtvalElem);
        }
        return dateElem;
    }

    public ZCalendar.ZProperty toZProperty() {
        ZCalendar.ZProperty prop = new ZCalendar.ZProperty(this.mPropertyName);
        if (this.mTimeZone != null) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.TZID, this.mTimeZone.getID()));
        }
        if (!ZCalendar.ICalTok.DATE_TIME.equals((Object)this.mValueType)) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.VALUE, this.mValueType.toString()));
        }
        prop.setValue(this.getDatesCSV());
        return prop;
    }

    public static RdateExdate parse(ZCalendar.ZProperty prop, TimeZoneMap tzmap) throws ServiceException {
        String typeStr;
        ZCalendar.ICalTok propName = prop.getToken();
        ZCalendar.ZParameter valueParam = prop.getParameter(ZCalendar.ICalTok.VALUE);
        ZCalendar.ICalTok valueType = ZCalendar.ICalTok.DATE_TIME;
        if (valueParam != null && (typeStr = valueParam.getValue()) != null && (valueType = ZCalendar.ICalTok.lookup(typeStr)) == null) {
            throw ServiceException.INVALID_REQUEST("Invalid " + propName.toString() + " value type " + typeStr, null);
        }
        String tzid = prop.getParameterVal(ZCalendar.ICalTok.TZID, null);
        ICalTimeZone tz = null;
        if (tzid != null) {
            tz = tzmap.lookupAndAdd(tzid);
        }
        RdateExdate rexdate = new RdateExdate(propName, valueType, tz);
        String csv = prop.getValue();
        if (csv == null || csv.length() == 0) {
            throw ServiceException.INVALID_REQUEST("Empty value not allowed for " + propName.toString() + " property", null);
        }
        for (String value : csv.split(",")) {
            try {
                switch (valueType) {
                    case DATE_TIME: 
                    case DATE: {
                        ParsedDateTime dt = ParsedDateTime.parse(value, tzmap, tz, tzmap.getLocalTimeZone());
                        rexdate.addValue(dt);
                        break;
                    }
                    case PERIOD: {
                        Period p = Period.parse(value, tz, tzmap);
                        rexdate.addValue(p);
                    }
                }
            }
            catch (ParseException e) {
                throw ServiceException.INVALID_REQUEST("Unable to parse " + propName.toString() + " value \"" + value + "\"", e);
            }
        }
        return rexdate;
    }

    public Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_IS_RDATE, this.isRDATE());
        if (this.mTimeZone != null) {
            meta.put(FN_TZID, this.mTimeZone.getID());
        }
        String vt = VT_DATE_TIME;
        if (!ZCalendar.ICalTok.DATE_TIME.equals((Object)this.mValueType)) {
            vt = ZCalendar.ICalTok.DATE.equals((Object)this.mValueType) ? VT_DATE : VT_PERIOD;
        }
        meta.put(FN_VALUE_TYPE, vt);
        meta.put(FN_NUM_VALUES, this.mValues.size());
        int i = 0;
        for (Object val : this.mValues) {
            if (val instanceof ParsedDateTime) {
                ParsedDateTime dt = (ParsedDateTime)val;
                meta.put(FN_VALUE + i, dt.getDateTimePartString(false));
            } else if (val instanceof Period) {
                Period p = (Period)val;
                meta.put(FN_VALUE + i, p.encodeMetadata());
            }
            ++i;
        }
        return meta;
    }

    public static RdateExdate decodeMetadata(Metadata meta, TimeZoneMap tzmap) throws ServiceException {
        String vt;
        boolean isRdate = meta.getBool(FN_IS_RDATE, true);
        ZCalendar.ICalTok propName = isRdate ? ZCalendar.ICalTok.RDATE : ZCalendar.ICalTok.EXDATE;
        ICalTimeZone tz = null;
        String tzid = meta.get(FN_TZID, null);
        if (tzid != null) {
            tz = tzmap.lookupAndAdd(tzid);
        }
        ZCalendar.ICalTok valueType = (vt = meta.get(FN_VALUE_TYPE, VT_DATE_TIME)).equals(VT_DATE_TIME) ? ZCalendar.ICalTok.DATE_TIME : (vt.equals(VT_DATE) ? ZCalendar.ICalTok.DATE : ZCalendar.ICalTok.PERIOD);
        RdateExdate rexdate = new RdateExdate(propName, valueType, tz);
        int numValues = (int)meta.getLong(FN_NUM_VALUES, 0L);
        for (int i = 0; i < numValues; ++i) {
            String key = FN_VALUE + i;
            if (valueType.equals((Object)ZCalendar.ICalTok.DATE_TIME) || valueType.equals((Object)ZCalendar.ICalTok.DATE)) {
                ParsedDateTime dt;
                String dtStr = meta.get(key);
                try {
                    dt = ParsedDateTime.parse(dtStr, tzmap, tz, tzmap.getLocalTimeZone());
                }
                catch (ParseException e) {
                    throw ServiceException.INVALID_REQUEST("Invalid " + propName.toString() + " date/time in metadata: " + meta.toString(), e);
                }
                rexdate.addValue(dt);
                continue;
            }
            if (!valueType.equals((Object)ZCalendar.ICalTok.PERIOD)) continue;
            Period p = Period.decodeMetadata(meta.getMap(key), tz, tzmap);
            rexdate.addValue(p);
        }
        return rexdate;
    }
}

