/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import java.text.ParseException;

public class Period {
    private ParsedDateTime mStart;
    private ParsedDateTime mEnd;
    private ParsedDuration mDuration;
    private boolean mHasEnd;
    private static final String FN_START = "dts";
    private static final String FN_DURATION = "dur";
    private static final String FN_END = "dte";

    public Period(ParsedDateTime start, ParsedDateTime end) {
        this.mStart = start;
        this.mEnd = end;
        this.mDuration = this.mEnd.difference(this.mStart);
        this.mHasEnd = true;
    }

    public Period(ParsedDateTime start, ParsedDuration dur) {
        this.mStart = start;
        this.mDuration = dur;
        this.mEnd = this.mStart.add(this.mDuration);
        this.mHasEnd = false;
    }

    public ParsedDateTime getStart() {
        return this.mStart;
    }

    public ParsedDateTime getEnd() {
        return this.mEnd;
    }

    public ParsedDuration getDuration() {
        return this.mDuration;
    }

    public boolean hasEnd() {
        return this.mHasEnd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.mStart.getDateTimePartString(false));
        sb.append("/");
        if (this.mHasEnd) {
            if (this.mEnd != null) {
                sb.append(this.mEnd.getDateTimePartString(false));
            }
        } else if (this.mDuration != null) {
            sb.append(this.mDuration.toString());
        }
        return sb.toString();
    }

    public static Period parse(String value, ICalTimeZone tz, TimeZoneMap tzmap) throws ServiceException, ParseException {
        String[] parsed = value.split("\\/", 2);
        if (parsed.length != 2 || parsed[0].length() == 0 || parsed[1].length() == 1) {
            throw ServiceException.INVALID_REQUEST("Invalid PERIOD value \"" + value + "\"", null);
        }
        ParsedDateTime startTime = ParsedDateTime.parse(parsed[0], tzmap, tz, tzmap.getLocalTimeZone());
        char ch = parsed[1].charAt(0);
        if (ch == 'P' || ch == '+' || ch == '-') {
            ParsedDuration duration = ParsedDuration.parse(parsed[1]);
            return new Period(startTime, duration);
        }
        ParsedDateTime endTime = ParsedDateTime.parse(parsed[1], tzmap, tz, tzmap.getLocalTimeZone());
        return new Period(startTime, endTime);
    }

    public Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_START, this.mStart.getDateTimePartString(false));
        if (this.mHasEnd) {
            meta.put(FN_END, this.mEnd.getDateTimePartString(false));
        } else {
            meta.put(FN_DURATION, this.mDuration);
        }
        return meta;
    }

    public static Period decodeMetadata(Metadata meta, ICalTimeZone tz, TimeZoneMap tzmap) throws ServiceException {
        ParsedDateTime startTime;
        String start = meta.get(FN_START);
        try {
            startTime = ParsedDateTime.parse(start, tzmap, tz, tzmap.getLocalTimeZone());
        }
        catch (ParseException e) {
            throw ServiceException.INVALID_REQUEST("Invalid PERIOD start time in metadata: " + meta.toString(), e);
        }
        String end = meta.get(FN_END, null);
        if (end != null) {
            ParsedDateTime endTime;
            try {
                endTime = ParsedDateTime.parse(end, tzmap, tz, tzmap.getLocalTimeZone());
            }
            catch (ParseException e) {
                throw ServiceException.INVALID_REQUEST("Invalid PERIOD end time in metadata: " + meta.toString(), e);
            }
            return new Period(startTime, endTime);
        }
        String durStr = meta.get(FN_DURATION, null);
        if (durStr == null) {
            throw ServiceException.INVALID_REQUEST("PERIOD in metadata missing both end time and duration: " + meta.toString(), null);
        }
        ParsedDuration duration = ParsedDuration.parse(durStr);
        return new Period(startTime, duration);
    }
}

