/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParsedDuration {
    public static final int WEEKS = 1;
    public static final int DAYS = 2;
    public static final int HOURS = 3;
    public static final int MINUTES = 4;
    public static final int SECONDS = 5;
    private int mWeeks = 0;
    private int mDays = 0;
    private int mHours = 0;
    private int mMins = 0;
    private int mSecs = 0;
    private boolean mNegative = false;
    static Pattern sDurationWeekPattern = Pattern.compile("([+-]?P)(\\d+)W");
    static Pattern sDurationDayTimePattern = Pattern.compile("([+-]?P)(?:(\\d+)D)?(?:T(?:(\\d+)H)?(?:(\\d+)M)?(?:(\\d+)S)?)?");
    public static final ParsedDuration ONE_DAY = new ParsedDuration(false, 0, 1, 0, 0, 0);
    public static final ParsedDuration NEGATIVE_ONE_DAY = new ParsedDuration(false, 0, -1, 0, 0, 0);
    public static final ParsedDuration ONE_WEEK = new ParsedDuration(false, 1, 0, 0, 0, 0);
    public static final ParsedDuration ONE_SECOND = new ParsedDuration(false, 0, 0, 0, 0, 1);
    public static final ParsedDuration NEGATIVE_ONE_SECOND = new ParsedDuration(true, 0, 0, 0, 0, 1);
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int SECONDS_IN_HOUR = 3600;
    private static final int SECONDS_IN_DAY = 86400;
    private static final int SECONDS_IN_WEEK = 604800;

    private ParsedDuration(boolean negative, int weeks, int days, int hours, int mins, int secs) {
        this.mNegative = negative;
        this.mWeeks = weeks;
        this.mDays = days;
        this.mHours = hours;
        this.mMins = mins;
        this.mSecs = secs;
    }

    public Object clone() {
        ParsedDuration toRet = new ParsedDuration();
        toRet.mWeeks = this.mWeeks;
        toRet.mDays = this.mDays;
        toRet.mHours = this.mHours;
        toRet.mMins = this.mMins;
        toRet.mSecs = this.mSecs;
        toRet.mNegative = this.mNegative;
        return toRet;
    }

    private int asSeconds() {
        return (this.mWeeks * 604800 + this.mDays * 86400 + this.mHours * 3600 + this.mMins * 60 + this.mSecs) * (this.mNegative ? -1 : 1);
    }

    public int compareTo(ParsedDuration other) {
        return this.asSeconds() - other.asSeconds();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParsedDuration)) {
            return false;
        }
        return this.compareTo((ParsedDuration)other) == 0;
    }

    public ParsedDuration add(int field, int amount) throws ServiceException {
        ParsedDuration dur = (ParsedDuration)this.clone();
        switch (field) {
            case 1: {
                dur.mWeeks += amount;
                break;
            }
            case 2: {
                dur.mDays += amount;
                break;
            }
            case 3: {
                dur.mHours += amount;
                break;
            }
            case 4: {
                dur.mMins += amount;
                break;
            }
            case 5: {
                dur.mSecs += amount;
                break;
            }
            default: {
                throw ServiceException.INVALID_REQUEST("Unknown field in ParsedDuration.add(" + field + "," + amount + ")", null);
            }
        }
        return dur;
    }

    public ParsedDuration abs() {
        return ParsedDuration.parse(false, this.mWeeks, this.mDays, this.mHours, this.mMins, this.mSecs);
    }

    public String toString() {
        String start = "P";
        if (this.mNegative) {
            start = "-P";
        }
        StringBuffer toRet = new StringBuffer(start);
        if (this.mWeeks != 0) {
            assert (this.mDays == 0 && this.mHours == 0 && this.mMins == 0 && this.mSecs == 0);
            toRet.append(this.mWeeks + "W");
            return toRet.toString();
        }
        if (this.mDays != 0) {
            toRet.append(this.mDays + "D");
            if (this.mHours == 0 && this.mMins == 0 && this.mSecs == 0) {
                return toRet.toString();
            }
        }
        toRet.append("T");
        if (this.mHours != 0) {
            toRet.append(this.mHours + "H");
        }
        if (this.mMins != 0) {
            toRet.append(this.mMins + "M");
        }
        if (this.mSecs != 0) {
            toRet.append(this.mSecs + "S");
        }
        return toRet.toString();
    }

    public static ParsedDuration parse(boolean negative, int weeks, int days, int hours, int mins, int secs) {
        ParsedDuration toRet = new ParsedDuration();
        toRet.mNegative = negative;
        toRet.mWeeks = weeks;
        toRet.mDays = days;
        toRet.mHours = hours;
        toRet.mMins = mins;
        toRet.mSecs = secs;
        return toRet;
    }

    private ParsedDuration() {
        this.mNegative = false;
        this.mWeeks = 0;
        this.mDays = 0;
        this.mHours = 0;
        this.mMins = 0;
        this.mSecs = 0;
    }

    public Element toXml(Element parent) {
        return this.toXml(parent, "dur");
    }

    public Element toXml(Element parent, String name) {
        Element elt = parent.addElement(name);
        if (this.mNegative) {
            elt.addAttribute("neg", true);
        }
        if (this.mWeeks > 0) {
            elt.addAttribute("w", this.mWeeks);
        } else {
            if (this.mDays > 0) {
                elt.addAttribute("d", this.mDays);
            }
            if (this.mHours > 0) {
                elt.addAttribute("h", this.mHours);
            }
            if (this.mMins > 0) {
                elt.addAttribute("m", this.mMins);
            }
            if (this.mSecs > 0) {
                elt.addAttribute("s", this.mSecs);
            }
        }
        return elt;
    }

    public static ParsedDuration parse(Element elt) throws ServiceException {
        ParsedDuration toRet = new ParsedDuration();
        toRet.mNegative = elt.getAttributeBool("neg", false);
        toRet.mWeeks = (int)elt.getAttributeLong("w", 0L);
        toRet.mDays = (int)elt.getAttributeLong("d", 0L);
        toRet.mHours = (int)elt.getAttributeLong("h", 0L);
        toRet.mMins = (int)elt.getAttributeLong("m", 0L);
        toRet.mSecs = (int)elt.getAttributeLong("s", 0L);
        if ((toRet.mDays != 0 || toRet.mHours != 0 || toRet.mMins != 0 || toRet.mSecs != 0) && toRet.mWeeks != 0) {
            throw ServiceException.FAILURE("Weeks may not be specified with other granularity in duration element: " + elt.getName(), null);
        }
        return toRet;
    }

    private Date addToDate(Date date, boolean subtract) {
        int mult;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int n = mult = this.mNegative ? -1 : 1;
        if (subtract) {
            mult *= -1;
        }
        cal.add(3, mult * this.mWeeks);
        cal.add(6, mult * this.mDays);
        cal.add(11, mult * this.mHours);
        cal.add(12, mult * this.mMins);
        cal.add(13, mult * this.mSecs);
        return cal.getTime();
    }

    public Date addToDate(Date date) {
        return this.addToDate(date, false);
    }

    public Date subtractFromDate(Date date) {
        return this.addToDate(date, true);
    }

    public long addToTime(long utcTime) {
        return this.addToDate(new Date(utcTime), false).getTime();
    }

    public long subtractFromTime(long utcTime) {
        return this.addToDate(new Date(utcTime), true).getTime();
    }

    public static ParsedDuration parse(String durationStr) throws ServiceException {
        if (durationStr == null) {
            return null;
        }
        ParsedDuration retVal = new ParsedDuration();
        Matcher m = sDurationWeekPattern.matcher(durationStr);
        if (m.matches()) {
            String p = m.group(1);
            String wk = m.group(2);
            if (p.charAt(0) == '-') {
                retVal.mNegative = true;
            }
            retVal.mWeeks = Integer.parseInt(wk);
        } else {
            m = sDurationDayTimePattern.matcher(durationStr);
            if (m.matches()) {
                String se;
                String mi;
                String ho;
                String da;
                String p = m.group(1);
                if (p.charAt(0) == '-') {
                    retVal.mNegative = true;
                }
                if ((da = m.group(2)) != null) {
                    retVal.mDays = Integer.parseInt(da);
                }
                if ((ho = m.group(3)) != null) {
                    retVal.mHours = Integer.parseInt(ho);
                }
                if ((mi = m.group(4)) != null) {
                    retVal.mMins = Integer.parseInt(mi);
                }
                if ((se = m.group(5)) != null) {
                    retVal.mSecs = Integer.parseInt(se);
                }
            } else {
                throw ServiceException.INVALID_REQUEST("Could not parse DURATION string: " + durationStr, null);
            }
        }
        return retVal;
    }

    public int getWeeks() {
        return this.mWeeks * (this.mNegative ? -1 : 1);
    }

    public int getDays() {
        return this.mDays * (this.mNegative ? -1 : 1);
    }

    public int getHours() {
        return this.mHours * (this.mNegative ? -1 : 1);
    }

    public int getMins() {
        return this.mMins * (this.mNegative ? -1 : 1);
    }

    public int getSecs() {
        return this.mSecs * (this.mNegative ? -1 : 1);
    }
}

