/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParsedDateTime {
    private static final boolean OUTLOOK_COMPAT_ALLDAY = LC.calendar_outlook_compatible_allday_events.booleanValue();
    static Pattern sDateTimePattern = Pattern.compile("(\\d{4})(?:-)?(\\d{2})(?:-)?(\\d{2})(?:T(\\d{2})(?:\\:)?(\\d{2})(?:\\:)?(\\d{2})(?:\\.\\d{3})?(Z)?)?");
    public static ParsedDateTime MAX_DATETIME;
    private GregorianCalendar mCal;
    private boolean mHasTime = false;
    private ICalTimeZone mICalTimeZone;
    static final long MSECS_PER_SEC = 1000L;
    static final long MSECS_PER_MIN = 60000L;
    static final long MSECS_PER_HOUR = 3600000L;
    static final long MSECS_PER_DAY = 86400000L;
    static final long MSECS_PER_WEEK = 604800000L;

    public static void main(String[] args) {
        ICalTimeZone utc = ICalTimeZone.getUTC();
        TimeZoneMap tzmap = new TimeZoneMap(utc);
        try {
            ParsedDateTime t1 = ParsedDateTime.parse("20050910", tzmap, null, utc);
            System.out.println(t1);
            ParsedDateTime t2 = ParsedDateTime.parse("20050910T103000", tzmap, null, utc);
            System.out.println(t2);
            ParsedDateTime t3 = ParsedDateTime.parse("20050910T103000Z", tzmap, null, utc);
            System.out.println(t3);
            ParsedDateTime t4 = ParsedDateTime.parse("2005-09-10T10:30:00.000Z", tzmap, null, utc);
            System.out.println(t4);
        }
        catch (ParseException e) {
            System.out.println("Caught " + e);
            e.printStackTrace();
        }
    }

    public static ParsedDateTime fromUTCTime(long utc) {
        return new ParsedDateTime(new Date(utc));
    }

    public static ParsedDateTime fromUTCTime(long millis, ICalTimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        cal.setTimeZone(tz);
        return new ParsedDateTime(cal, tz, true);
    }

    public static ParsedDateTime parseUtcOnly(String str) throws ParseException {
        return ParsedDateTime.parse(str, null, null, null, true);
    }

    public static ParsedDateTime parse(String str, TimeZoneMap tzmap, ICalTimeZone tz, ICalTimeZone localTZ) throws ParseException {
        return ParsedDateTime.parse(str, tzmap, tz, localTZ, false);
    }

    private static ParsedDateTime parse(String str, TimeZoneMap tzmap, ICalTimeZone tz, ICalTimeZone localTZ, boolean utcOnly) throws ParseException {
        assert (tzmap != null || utcOnly);
        Matcher m = sDateTimePattern.matcher(str);
        if (m.matches()) {
            int hour = -1;
            int minute = -1;
            int second = -1;
            boolean zulu = false;
            int year = Integer.parseInt(m.group(1));
            int month = Integer.parseInt(m.group(2)) - 1;
            int date = Integer.parseInt(m.group(3));
            if (m.group(4) != null) {
                hour = Integer.parseInt(m.group(4));
                minute = Integer.parseInt(m.group(5));
                second = Integer.parseInt(m.group(6));
                if (m.group(7) != null && m.group(7).equals("Z")) {
                    zulu = true;
                }
                if (zulu || utcOnly) {
                    tz = ICalTimeZone.getUTC();
                } else if (tz == null) {
                    tz = localTZ;
                }
            } else {
                tz = null;
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            if (zulu || utcOnly) {
                cal.setTimeZone(ICalTimeZone.getUTC());
            } else {
                if (tz == null) {
                    tz = localTZ;
                }
                if (tz != null) {
                    if (tzmap != null) {
                        tzmap.add(tz);
                        ICalTimeZone tzCanon = tzmap.getTimeZone(tz.getID());
                        if (tzCanon != null) {
                            tz = tzCanon;
                        }
                    }
                    cal.setTimeZone(tz);
                }
            }
            boolean hasTime = false;
            if (hour >= 0) {
                cal.set(year, month, date, hour, minute, second);
                hasTime = true;
            } else {
                cal.set(year, month, date, 0, 0, 0);
            }
            return new ParsedDateTime(cal, tz, hasTime);
        }
        if (str.length() == 9 && str.charAt(8) == 'Z') {
            return ParsedDateTime.parse(str.substring(0, 8), tzmap, tz, ICalTimeZone.getUTC(), utcOnly);
        }
        throw new ParseException("Invalid date/time specified: " + str, 0);
    }

    public static ParsedDateTime parse(ZCalendar.ZProperty prop, TimeZoneMap tzmap) throws ParseException, ServiceException {
        assert (tzmap != null);
        String tzname = prop.getParameterVal(ZCalendar.ICalTok.TZID, null);
        ICalTimeZone tz = null;
        if (tzname != null) {
            tz = tzmap.lookupAndAdd(tzname);
        }
        if (tz == null) {
            tz = tzmap.getLocalTimeZone();
        }
        return ParsedDateTime.parse(prop.getValue(), tzmap, tz, tzmap.getLocalTimeZone());
    }

    public static ParsedDateTime parse(String str, TimeZoneMap tzmap) throws ParseException, ServiceException {
        String datetime;
        assert (tzmap != null);
        if (str == null) {
            return null;
        }
        ICalTimeZone tz = null;
        int propValueColonIdx = str.lastIndexOf(58);
        if (propValueColonIdx != -1) {
            datetime = str.substring(propValueColonIdx + 1);
            int tzidIdx = str.indexOf("TZID=");
            if (tzidIdx != -1) {
                int valueParamIdx = str.lastIndexOf(";VALUE=");
                String tzid = valueParamIdx > tzidIdx ? str.substring(tzidIdx + 5, valueParamIdx) : str.substring(tzidIdx + 5, propValueColonIdx);
                if (tzid.equals("UTC") && !datetime.endsWith("Z")) {
                    datetime = datetime + "Z";
                } else {
                    tz = tzmap.lookupAndAdd(tzid);
                }
            }
        } else {
            datetime = str;
        }
        return ParsedDateTime.parse(datetime, tzmap, tz, tzmap.getLocalTimeZone());
    }

    public ICalTimeZone getTimeZone() {
        return this.mICalTimeZone;
    }

    private ParsedDateTime(GregorianCalendar cal, ICalTimeZone iCalTimeZone, boolean hasTime) {
        this.mCal = cal;
        this.mHasTime = hasTime;
        this.mICalTimeZone = iCalTimeZone;
    }

    ParsedDateTime(Date utc) {
        this.mCal = new GregorianCalendar(ICalTimeZone.getUTC());
        this.mCal.setTime(utc);
        this.mICalTimeZone = ICalTimeZone.getUTC();
        this.mHasTime = true;
    }

    public ParsedDateTime add(ParsedDuration dur) {
        GregorianCalendar cal = (GregorianCalendar)this.mCal.clone();
        if (dur != null) {
            cal.add(3, dur.getWeeks());
            cal.add(6, dur.getDays());
            cal.add(11, dur.getHours());
            cal.add(12, dur.getMins());
            cal.add(13, dur.getSecs());
        }
        return new ParsedDateTime(cal, this.mICalTimeZone, this.mHasTime);
    }

    public ParsedDateTime cloneWithNewDate(ParsedDateTime date) {
        GregorianCalendar cal = (GregorianCalendar)this.mCal.clone();
        GregorianCalendar calDate = date.mCal;
        cal.set(calDate.get(1), calDate.get(2), calDate.get(5));
        return new ParsedDateTime(cal, this.mICalTimeZone, this.mHasTime);
    }

    public Object clone() {
        GregorianCalendar cal = (GregorianCalendar)this.mCal.clone();
        return new ParsedDateTime(cal, this.mICalTimeZone, this.mHasTime);
    }

    public int compareTo(Date other) {
        return this.getDate().compareTo(other);
    }

    public int compareTo(long other) {
        long myTime = this.getDate().getTime();
        return (int)(myTime - other);
    }

    public int compareTo(Object other) {
        return this.compareTo(((ParsedDateTime)other).getDate());
    }

    public int compareTo(ParsedDateTime other) {
        return this.compareTo(other.getDate());
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public boolean sameTime(ParsedDateTime other) {
        GregorianCalendar otherCal;
        ICalTimeZone otherTZ;
        if (other == null) {
            return false;
        }
        ICalTimeZone thisTZ = this.getTimeZone();
        if (thisTZ.equals(otherTZ = other.getTimeZone())) {
            otherCal = other.mCal;
        } else {
            otherCal = new GregorianCalendar(thisTZ);
            otherCal.setTimeInMillis(other.getUtcTime());
        }
        return this.mCal.get(11) == otherCal.get(11) && this.mCal.get(12) == otherCal.get(12) && this.mCal.get(13) == otherCal.get(13) && this.mCal.get(14) == otherCal.get(14);
    }

    public ParsedDuration difference(ParsedDateTime other) {
        long myTime = this.mCal.getTimeInMillis();
        long otherTime = other.mCal.getTimeInMillis();
        long diff = myTime - otherTime;
        boolean negative = false;
        if (diff < 0L) {
            negative = true;
            diff *= -1L;
        }
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int mins = 0;
        int secs = 0;
        if (this.mHasTime || other.mHasTime) {
            if (diff >= 604800000L && diff % 604800000L == 0L) {
                weeks = (int)(diff / 604800000L);
            } else {
                long dleft = diff;
                days = (int)(dleft / 86400000L);
                hours = (int)((dleft %= 86400000L) / 3600000L);
                mins = (int)((dleft %= 3600000L) / 60000L);
                secs = (int)((dleft %= 60000L) / 1000L);
            }
        } else {
            long dleft = diff;
            days = (int)(dleft / 86400000L);
            if ((dleft %= 86400000L) >= 43200000L) {
                ++days;
            }
        }
        return ParsedDuration.parse(negative, weeks, days, hours, mins, secs);
    }

    public Date getDate() {
        return this.mCal.getTime();
    }

    public Date getDateForRecurUntil(ICalTimeZone dtStartTZ) {
        if (!this.mHasTime || this.isUTC() && this.mCal.get(11) == 0 && this.mCal.get(12) == 0 && this.mCal.get(13) == 0 && this.mCal.get(14) == 0) {
            GregorianCalendar cal = new GregorianCalendar(dtStartTZ);
            cal.clear();
            cal.set(this.mCal.get(1), this.mCal.get(2), this.mCal.get(5), 0, 0, 0);
            cal.add(5, 1);
            cal.add(13, -1);
            Date until = cal.getTime();
            Date untilOriginal = this.mCal.getTime();
            if (until.before(untilOriginal)) {
                until = untilOriginal;
            }
            return until;
        }
        return this.getDate();
    }

    public String getDateTimePartString() {
        return this.getDateTimePartString(OUTLOOK_COMPAT_ALLDAY);
    }

    public String getDateTimePartString(boolean useOutlookCompatMode) {
        DecimalFormat fourDigitFormat = new DecimalFormat("0000");
        DecimalFormat twoDigitFormat = new DecimalFormat("00");
        StringBuffer toRet = new StringBuffer();
        toRet.append(fourDigitFormat.format(this.mCal.get(1)));
        toRet.append(twoDigitFormat.format(this.mCal.get(2) + 1));
        toRet.append(twoDigitFormat.format(this.mCal.get(5)));
        if (this.mHasTime) {
            toRet.append("T");
            toRet.append(twoDigitFormat.format(this.mCal.get(11)));
            if (this.mCal.isSet(12)) {
                toRet.append(twoDigitFormat.format(this.mCal.get(12)));
            } else {
                toRet.append("00");
            }
            if (this.mCal.isSet(13)) {
                toRet.append(twoDigitFormat.format(this.mCal.get(13)));
            } else {
                toRet.append("00");
            }
            if (this.isUTC()) {
                toRet.append("Z");
            }
        } else if (useOutlookCompatMode) {
            toRet.append("T000000");
            if (this.getTZName() == null) {
                toRet.append("Z");
            }
        }
        return toRet.toString();
    }

    public boolean isUTC() {
        return this.mICalTimeZone.getID() != null && this.mICalTimeZone.getID().equals("Z");
    }

    public void toUTC() {
        if (!this.isUTC()) {
            this.mICalTimeZone = ICalTimeZone.getUTC();
            Date time = this.mCal.getTime();
            this.mCal.setTimeZone(this.mICalTimeZone);
            this.mCal.setTime(time);
        }
    }

    public void toTimeZone(ICalTimeZone tz) {
        if (this.mHasTime) {
            Date time = this.mCal.getTime();
            this.mICalTimeZone = tz;
            this.mCal.setTimeZone(this.mICalTimeZone);
            this.mCal.setTime(time);
        }
    }

    public String getTZName() {
        if ((this.mHasTime || OUTLOOK_COMPAT_ALLDAY) && this.mICalTimeZone != null && !this.isUTC()) {
            return this.mICalTimeZone.getID();
        }
        return null;
    }

    public GregorianCalendar getCalendarCopy() {
        return (GregorianCalendar)this.mCal.clone();
    }

    public long getUtcTime() {
        return this.mCal.getTimeInMillis();
    }

    public String getUtcString() {
        if (this.isUTC()) {
            return this.getDateTimePartString(false);
        }
        ParsedDateTime dtZ = (ParsedDateTime)this.clone();
        dtZ.toUTC();
        return dtZ.getDateTimePartString(false);
    }

    public boolean hasTime() {
        return this.mHasTime;
    }

    public void setHasTime(boolean hasTime) {
        this.mHasTime = hasTime;
    }

    public boolean hasZeroTime() {
        int hour = this.mCal.get(11);
        if (hour != 0) {
            return false;
        }
        int minute = this.mCal.get(12);
        if (minute != 0) {
            return false;
        }
        int second = this.mCal.get(13);
        if (second != 0) {
            return false;
        }
        int milli = this.mCal.get(14);
        return milli == 0;
    }

    public String toString() {
        if (this.mHasTime) {
            String tzName = this.getTZName();
            if (tzName != null) {
                return "TZID=" + tzName + ":" + this.getDateTimePartString();
            }
            return this.getDateTimePartString();
        }
        return "VALUE=DATE:" + this.getDateTimePartString(false);
    }

    public ZCalendar.ZProperty toProperty(ZCalendar.ICalTok tok, boolean useOutlookCompatMode) {
        ZCalendar.ZProperty toRet = new ZCalendar.ZProperty(tok, this.getDateTimePartString(useOutlookCompatMode));
        String tzName = this.getTZName();
        if (!useOutlookCompatMode && !this.hasTime()) {
            toRet.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.VALUE, ZCalendar.ICalTok.DATE.toString()));
        } else {
            assert (this.isUTC() || tzName != null);
            if (tzName != null) {
                toRet.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.TZID, tzName));
            }
        }
        return toRet;
    }

    void forceDateOnly() {
        this.mHasTime = false;
    }

    public int getOffset() {
        if (this.mICalTimeZone == null) {
            return 0;
        }
        return this.mICalTimeZone.getOffset(this.getUtcTime());
    }

    static {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2099, 1, 1);
        cal.setTimeZone(ICalTimeZone.getUTC());
        MAX_DATETIME = new ParsedDateTime(cal, ICalTimeZone.getUTC(), false);
    }
}

