/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import java.util.Comparator;
import java.util.TimeZone;
import java.util.TreeSet;

public class ListJavaTimeZones {
    public static void main(String[] args) throws Exception {
        String[] tzids = TimeZone.getAvailableIDs();
        TreeSet<TimeZone> tzset = new TreeSet<TimeZone>(new TZComparatorByOffset());
        for (String tzid : tzids) {
            tzset.add(TimeZone.getTimeZone(tzid));
        }
        for (TimeZone tz : tzset) {
            ListJavaTimeZones.printTZ(tz);
        }
    }

    private static String toGMTOffsetString(int offsetMillis) {
        String sign;
        int minutes = offsetMillis / 1000 / 60;
        if (minutes < 0) {
            minutes *= -1;
            sign = "-";
        } else {
            sign = "+";
        }
        int hours = minutes / 60;
        return String.format("GMT%s%02d:%02d", sign, hours, minutes %= 60);
    }

    private static void printTZ(TimeZone tz) {
        String tzid = tz.getID();
        String gmtOffset = ListJavaTimeZones.toGMTOffsetString(tz.getRawOffset());
        boolean isDst = tz.useDaylightTime();
        String clazz = tz.getClass().getSimpleName();
        String text = String.format("%-20s (%s) - hasDST=%s (%s:%08x)", tzid, gmtOffset, isDst ? "Y" : "N", clazz, tz.hashCode());
        System.out.println(text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TZComparatorByOffset
    implements Comparator<TimeZone> {
        private TZComparatorByOffset() {
        }

        @Override
        public int compare(TimeZone tz1, TimeZone tz2) {
            if (tz1 != null && tz2 != null) {
                int off2;
                int off1 = tz1.getRawOffset();
                if (off1 != (off2 = tz2.getRawOffset())) {
                    return off1 - off2;
                }
                return tz1.getID().compareTo(tz2.getID());
            }
            if (tz1 != null) {
                return -1;
            }
            if (tz2 != null) {
                return 1;
            }
            return 0;
        }
    }
}

