/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InviteInfo
implements Comparable<InviteInfo> {
    private int mMsgId;
    private int mComponentId;
    private RecurId mRecurrenceId;
    private String mMethod;
    private static final String FN_MSGID = "i";
    private static final String FN_COMPNUM = "c";
    private static final String FN_RECURRENCEID = "r";
    private static final String FN_METHOD = "m";
    private static final int METHOD_REQUEST = 3;
    private static final int METHOD_CANCEL = 4;

    public InviteInfo(Invite inv) {
        this.mMsgId = inv.getMailItemId();
        this.mComponentId = inv.getComponentNum();
        this.mRecurrenceId = inv.getRecurId();
        this.mMethod = inv.getMethod();
    }

    private InviteInfo(int msgId, int componentId, RecurId recurrenceId, String method) {
        this.mMsgId = msgId;
        this.mComponentId = componentId;
        this.mRecurrenceId = recurrenceId;
        this.mMethod = method;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InviteInfo)) {
            return false;
        }
        InviteInfo other = (InviteInfo)o;
        return this.mMsgId == other.mMsgId && this.mComponentId == other.mComponentId && StringUtil.equal(this.mMethod, other.mMethod) && (this.mRecurrenceId == null && other.mRecurrenceId == null || this.mRecurrenceId != null && this.mRecurrenceId.equals(other.mRecurrenceId));
    }

    @Override
    public int compareTo(InviteInfo other) {
        String ridOther;
        String rid;
        if (other == null) {
            return 1;
        }
        int toRet = this.mMsgId - other.mMsgId;
        if (toRet == 0 && (toRet = this.mComponentId - other.mComponentId) == 0 && (toRet = StringUtil.compareTo(rid = this.mRecurrenceId != null ? this.mRecurrenceId.toString() : null, ridOther = other.mRecurrenceId != null ? other.mRecurrenceId.toString() : null)) == 0) {
            toRet = StringUtil.compareTo(this.mMethod, other.mMethod);
        }
        return toRet;
    }

    public static InviteInfo fromMetadata(Metadata md, TimeZoneMap tzmap) throws ServiceException {
        RecurId recurrenceId = null;
        int methodInt = 0;
        String method = ZCalendar.ICalTok.REQUEST.toString();
        int msgId = (int)md.getLong(FN_MSGID);
        int compNum = (int)md.getLong(FN_COMPNUM);
        methodInt = (int)md.getLong(FN_METHOD);
        switch (methodInt) {
            case 4: {
                method = ZCalendar.ICalTok.CANCEL.toString();
            }
        }
        if (md.containsKey(FN_RECURRENCEID)) {
            recurrenceId = RecurId.decodeMetadata(md.getMap(FN_RECURRENCEID), tzmap);
        }
        return new InviteInfo(msgId, compNum, recurrenceId, method);
    }

    public Metadata encodeMetadata() {
        Metadata md = new Metadata();
        md.put(FN_MSGID, this.mMsgId);
        md.put(FN_COMPNUM, this.mComponentId);
        if (this.mRecurrenceId != null) {
            md.put(FN_RECURRENCEID, this.mRecurrenceId.encodeMetadata());
        }
        if (this.mMethod.equals(ZCalendar.ICalTok.CANCEL.toString())) {
            md.put(FN_METHOD, 4L);
        } else {
            md.put(FN_METHOD, 3L);
        }
        return md;
    }

    public String toString() {
        return this.mMsgId + "-" + this.mComponentId + "-" + this.mMethod + "-" + this.mRecurrenceId;
    }

    public int getMsgId() {
        return this.mMsgId;
    }

    public int getComponentId() {
        return this.mComponentId;
    }

    public boolean hasRecurrenceId() {
        return this.mRecurrenceId != null;
    }

    public RecurId getRecurrenceId() {
        return this.mRecurrenceId;
    }

    public String getMethod() {
        return this.mMethod;
    }
}

