/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.Fragment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.Alarm;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.IcalXmlStrMap;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.RdateExdate;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.Recurrence;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.Util;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.ZRecur;
import com.zimbra.cs.util.AccountUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invite {
    private static final boolean OUTLOOK_COMPAT_ALLDAY = LC.calendar_outlook_compatible_allday_events.booleanValue();
    private static final String HEADER_SEPARATOR = "*~*~*~*~*~*~*~*~*~*";
    static Log sLog = LogFactory.getLog(Invite.class);
    private Recurrence.IRecurrence mRecurrence;
    protected RecurId mRecurrenceId = null;
    private boolean mSentByMe;
    private String mFragment;
    private static final String FN_ITEMTYPE = "it";
    private static final String FN_APPT_FLAGS = "af";
    private static final String FN_ATTENDEE = "at";
    private static final String FN_SENTBYME = "byme";
    private static final String FN_CATEGORY = "cat";
    private static final String FN_CLASS = "cl";
    private static final String FN_CLASS_SETBYME = "clSetByMe";
    private static final String FN_COMPLETED = "completed";
    private static final String FN_COMPNUM = "comp";
    private static final String FN_COMMENT = "cmt";
    private static final String FN_CONTACT = "contact";
    private static final String FN_DESC = "desc";
    private static final String FN_DESC_HTML = "descH";
    private static final String FN_DESC_IN_META = "dinM";
    private static final String FN_FRAGMENT = "frag";
    private static final String FN_DTSTAMP = "dts";
    private static final String FN_DURATION = "duration";
    private static final String FN_END = "et";
    private static final String FN_APPT_FREEBUSY = "fb";
    private static final String FN_GEO = "geo";
    private static final String FN_LOCATION = "l";
    private static final String FN_LOCAL_ONLY = "lo";
    private static final String FN_INVMSGID = "mid";
    private static final String FN_METHOD = "mthd";
    private static final String FN_NAME = "n";
    private static final String FN_NUM_ATTENDEES = "numAt";
    private static final String FN_NUM_CATEGORIES = "numCat";
    private static final String FN_NUM_COMMENTS = "numCmt";
    private static final String FN_NUM_CONTACTS = "numContacts";
    private static final String FN_ORGANIZER = "org";
    private static final String FN_IS_ORGANIZER = "isOrg";
    private static final String FN_PARTSTAT = "ptst";
    private static final String FN_RSVP = "rsvp";
    private static final String FN_RECURRENCE = "recurrence";
    private static final String FN_RECUR_ID = "rid";
    private static final String FN_SEQ_NO = "seq";
    private static final String FN_STATUS = "status";
    private static final String FN_START = "st";
    private static final String FN_TRANSP = "tr";
    private static final String FN_TZMAP = "tzm";
    private static final String FN_UID = "u";
    private static final String FN_PRIORITY = "prio";
    private static final String FN_PCT_COMPLETE = "pctcompl";
    private static final String FN_NUM_ALARMS = "numAl";
    private static final String FN_ALARM = "al";
    private static final String FN_DONT_INDEX_MM = "noidxmm";
    private static final String FN_URL = "url";
    private String mDescription;
    private String mDescHtml;
    private boolean mDescInMeta = true;
    private boolean mDontIndexMimeMessage = false;
    public static final int APPT_FLAG_TODO = 1;
    public static final int APPT_FLAG_EVENT = 2;
    public static final int APPT_FLAG_ALLDAY = 4;
    public static final int APPT_FLAG_HASALARM = 16;
    public static final int APPT_FLAG_ISRECUR = 32;
    public static final int APPT_FLAG_NEEDS_REPLY = 64;
    public static final int APPT_FLAG_HAS_ATTACHMENT = 128;
    protected CalendarItem mCalItem = null;
    protected String mUid;
    protected String mStatus = "CONF";
    protected String mFreeBusy = null;
    protected String mTransparency = "O";
    protected String mClass = "PUB";
    protected boolean mClassSetByMe;
    protected ParsedDateTime mStart = null;
    protected ParsedDateTime mEnd = null;
    protected ParsedDuration mDuration = null;
    protected long mCompleted = 0L;
    protected String mName;
    protected String mLocation;
    protected int mFlags = 2;
    protected long mDTStamp = 0L;
    protected int mSeqNo = 0;
    protected String mPartStat = "NE";
    protected boolean mRsvp = false;
    protected long mMailboxId = 0L;
    protected int mMailItemId = 0;
    protected int mComponentNum = 0;
    private List<ZAttendee> mAttendees = new ArrayList<ZAttendee>();
    private ZOrganizer mOrganizer;
    private boolean mIsOrganizer;
    private boolean mLocalOnly = true;
    private String mPriority;
    private String mPercentComplete;
    private List<String> mCategories = new ArrayList<String>();
    private List<String> mContacts = new ArrayList<String>();
    private List<String> mComments = new ArrayList<String>();
    private Geo mGeo;
    private String mUrl;
    private byte mItemType = (byte)11;
    private ZCalendar.ICalTok mMethod;
    private List<Alarm> mAlarms = new ArrayList<Alarm>();
    private List<ZCalendar.ZProperty> mXProps = new ArrayList<ZCalendar.ZProperty>();
    private TimeZoneMap mTzMap;

    Invite(byte itemType, String methodStr, TimeZoneMap tzmap, CalendarItem calItem, String uid, String status, String priority, String pctComplete, long completed, String freebusy, String transp, String classProp, ParsedDateTime start, ParsedDateTime end, ParsedDuration duration, Recurrence.IRecurrence recurrence, boolean isOrganizer, ZOrganizer org, List<ZAttendee> attendees, String name, String loc, int flags, String partStat, boolean rsvp, RecurId recurrenceId, long dtstamp, int seqno, long mailboxId, int mailItemId, int componentNum, boolean sentByMe, String description, String descHtml, String fragment, List<String> comments, List<String> categories, List<String> contacts, Geo geo, String url) {
        this.setItemType(itemType);
        this.mMethod = Invite.lookupMethod(methodStr);
        this.mTzMap = tzmap;
        this.mCalItem = calItem;
        this.mUid = uid;
        this.mStatus = status;
        this.mPriority = priority;
        this.mPercentComplete = pctComplete;
        this.mCompleted = completed;
        this.mFreeBusy = freebusy;
        this.mTransparency = transp;
        this.mClass = classProp;
        this.mClassSetByMe = sentByMe;
        this.mStart = start;
        this.mEnd = end;
        this.mDuration = duration;
        this.mIsOrganizer = isOrganizer;
        this.mOrganizer = org;
        this.mAttendees = attendees;
        this.mName = name != null ? name : "";
        this.mLocation = loc != null ? loc : "";
        this.mFlags = flags;
        this.mPartStat = partStat;
        this.mRsvp = rsvp;
        this.mSeqNo = seqno;
        this.setDtStamp(dtstamp);
        this.mMailboxId = mailboxId;
        this.mMailItemId = mailItemId;
        this.mComponentNum = componentNum;
        this.mSentByMe = sentByMe;
        this.setDescription(description, descHtml);
        this.mFragment = fragment != null ? fragment : "";
        this.mComments = comments != null ? comments : new ArrayList();
        this.mCategories = categories != null ? categories : new ArrayList();
        this.mContacts = contacts != null ? contacts : new ArrayList();
        this.mGeo = geo;
        this.setUrl(url);
        this.setRecurrence(recurrence);
        this.setRecurId(recurrenceId);
    }

    public Recurrence.IRecurrence getRecurrence() {
        return this.mRecurrence;
    }

    public void setRecurrence(Recurrence.IRecurrence recur) {
        if (this.mRecurrenceId == null) {
            this.mRecurrence = recur;
            this.setIsRecurrence(this.mRecurrence != null);
        }
    }

    private void clearRecurrence() {
        this.mRecurrence = null;
        this.setIsRecurrence(false);
    }

    public RecurId getRecurId() {
        return this.mRecurrenceId;
    }

    public void setRecurId(RecurId rid) {
        this.mRecurrenceId = rid;
        if (this.mRecurrenceId != null) {
            this.clearRecurrence();
        }
    }

    public boolean hasRecurId() {
        return this.mRecurrenceId != null;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public void setFragment(String fragment) {
        this.mFragment = fragment;
    }

    public static Invite createInvite(long mailboxId, byte itemType, String method, TimeZoneMap tzMap, String uidOrNull, String status, String priority, String pctComplete, long completed, String freeBusy, String transparency, String classProp, boolean allDayEvent, ParsedDateTime dtStart, ParsedDateTime dtEndOrNull, ParsedDuration durationOrNull, RecurId recurId, Recurrence.IRecurrence recurrenceOrNull, boolean isOrganizer, ZOrganizer organizer, List<ZAttendee> attendees, String name, String location, String description, String descHtml, List<String> comments, List<String> categories, List<String> contacts, Geo geo, String url, long dtStampOrZero, int sequenceNoOrZero, String partStat, boolean rsvp, boolean sentByMe) {
        return new Invite(itemType, method, tzMap, null, uidOrNull, status, priority, pctComplete, completed, freeBusy, transparency, classProp, dtStart, dtEndOrNull, durationOrNull, recurrenceOrNull, isOrganizer, organizer, attendees, name, location, 2 | (allDayEvent ? 4 : 0), partStat, rsvp, recurId, dtStampOrZero, sequenceNoOrZero, mailboxId, 0, 0, sentByMe, description, descHtml, Fragment.getFragment(description, true), comments, categories, contacts, geo, url);
    }

    public void setInviteId(int invId) {
        this.mMailItemId = invId;
        if (this.mRecurrence != null) {
            this.mRecurrence.setInviteId(new InviteInfo(this));
        }
    }

    public static int getMaxDescInMeta() {
        return LC.calendar_max_desc_in_metadata.intValueWithinRange(0, 0x100000);
    }

    public static Metadata encodeMetadata(Invite inv) {
        String url;
        Geo geo;
        int numCat;
        List<String> categories;
        int numContacts;
        List<String> contacts;
        int numComm;
        Metadata meta = new Metadata();
        if (inv.isLocalOnly()) {
            meta.put(FN_LOCAL_ONLY, true);
        }
        meta.put(FN_ITEMTYPE, inv.getItemType());
        meta.put(FN_UID, inv.getUid());
        meta.put(FN_INVMSGID, inv.getMailItemId());
        meta.put(FN_COMPNUM, inv.getComponentNum());
        meta.put(FN_SENTBYME, inv.mSentByMe);
        if (!inv.isPublic()) {
            meta.put(FN_CLASS, inv.getClassProp());
        }
        meta.put(FN_CLASS_SETBYME, inv.classPropSetByMe());
        meta.put(FN_STATUS, inv.getStatus());
        if (inv.hasFreeBusy()) {
            meta.put(FN_APPT_FREEBUSY, inv.getFreeBusy());
        }
        meta.put(FN_TRANSP, inv.getTransparency());
        meta.put(FN_START, inv.mStart);
        meta.put(FN_END, inv.mEnd);
        if (inv.mCompleted != 0L) {
            meta.put(FN_COMPLETED, inv.mCompleted);
        }
        meta.put(FN_DURATION, inv.mDuration);
        meta.put(FN_METHOD, inv.mMethod.toString());
        meta.put(FN_FRAGMENT, inv.mFragment);
        if (inv.mDescInMeta) {
            meta.put(FN_DESC_IN_META, inv.mDescInMeta);
            if (inv.mDescription != null) {
                meta.put(FN_DESC, inv.mDescription);
            }
            if (inv.mDescHtml != null) {
                meta.put(FN_DESC_HTML, inv.mDescHtml);
            }
        }
        if (inv.mRecurrence != null) {
            meta.put(FN_RECURRENCE, inv.mRecurrence.encodeMetadata());
        }
        meta.put(FN_NAME, inv.getName());
        meta.put(FN_LOCATION, inv.mLocation);
        meta.put(FN_APPT_FLAGS, inv.getFlags());
        meta.put(FN_PARTSTAT, inv.getPartStat());
        meta.put(FN_RSVP, inv.getRsvp());
        meta.put(FN_TZMAP, inv.mTzMap.encodeAsMetadata());
        if (inv.hasRecurId()) {
            meta.put(FN_RECUR_ID, inv.getRecurId().encodeMetadata());
        }
        meta.put(FN_DTSTAMP, inv.getDTStamp());
        meta.put(FN_SEQ_NO, inv.getSeqNo());
        if (inv.hasOrganizer()) {
            meta.put(FN_ORGANIZER, inv.getOrganizer().encodeMetadata());
        }
        meta.put(FN_IS_ORGANIZER, inv.isOrganizer());
        List<ZAttendee> ats = inv.getAttendees();
        meta.put(FN_NUM_ATTENDEES, String.valueOf(ats.size()));
        int i = 0;
        for (ZAttendee at : ats) {
            meta.put(FN_ATTENDEE + i, at.encodeAsMetadata());
            ++i;
        }
        meta.put(FN_PRIORITY, inv.getPriority());
        meta.put(FN_PCT_COMPLETE, inv.getPercentComplete());
        List<String> comments = inv.getComments();
        if (comments != null && (numComm = comments.size()) > 0) {
            meta.put(FN_NUM_COMMENTS, numComm);
            int idx = 0;
            for (String comm : comments) {
                meta.put(FN_COMMENT + idx, comm);
                ++idx;
            }
        }
        if ((contacts = inv.getContacts()) != null && (numContacts = contacts.size()) > 0) {
            meta.put(FN_NUM_CONTACTS, numContacts);
            int idx = 0;
            for (String contact : contacts) {
                meta.put(FN_CONTACT + idx, contact);
                ++idx;
            }
        }
        if ((categories = inv.getCategories()) != null && (numCat = categories.size()) > 0) {
            meta.put(FN_NUM_CATEGORIES, numCat);
            int idx = 0;
            for (String cat : categories) {
                meta.put(FN_CATEGORY + idx, cat);
                ++idx;
            }
        }
        if ((geo = inv.getGeo()) != null) {
            meta.put(FN_GEO, geo.encodeMetadata());
        }
        if ((url = inv.getUrl()) != null && url.length() > 0) {
            meta.put(FN_URL, url);
        }
        if (!inv.mAlarms.isEmpty()) {
            meta.put(FN_NUM_ALARMS, inv.mAlarms.size());
            i = 0;
            for (Alarm alarm : inv.mAlarms) {
                meta.put(FN_ALARM + i, alarm.encodeMetadata());
                ++i;
            }
        }
        if (inv.mXProps.size() > 0) {
            Util.encodeXPropsAsMetadata(meta, inv.xpropsIterator());
        }
        if (inv.mDontIndexMimeMessage) {
            meta.put(FN_DONT_INDEX_MM, true);
        }
        return meta;
    }

    public static ZCalendar.ICalTok lookupMethod(String methodName) {
        ZCalendar.ICalTok toRet;
        block5: {
            String methodNameUpper = methodName.toUpperCase();
            try {
                toRet = ZCalendar.ICalTok.valueOf(methodNameUpper);
            }
            catch (IllegalArgumentException e) {
                toRet = ZCalendar.ICalTok.PUBLISH;
                if (methodNameUpper.compareToIgnoreCase("EXPORT") == 0) break block5;
                sLog.warn((Object)("Invalid METHOD " + methodName + "; assuming PUBLISH"), e);
            }
        }
        switch (toRet) {
            case REQUEST: 
            case PUBLISH: 
            case REPLY: 
            case ADD: 
            case CANCEL: 
            case REFRESH: 
            case COUNTER: 
            case DECLINECOUNTER: {
                return toRet;
            }
        }
        return ZCalendar.ICalTok.PUBLISH;
    }

    public static Invite decodeMetadata(long mailboxId, Metadata meta, CalendarItem calItem, ICalTimeZone accountTZ) throws ServiceException {
        byte itemType = (byte)meta.getLong(FN_ITEMTYPE, 11L);
        String uid = meta.get(FN_UID, null);
        int mailItemId = (int)meta.getLong(FN_INVMSGID);
        int componentNum = (int)meta.getLong(FN_COMPNUM);
        String classProp = meta.get(FN_CLASS, "PUB");
        boolean classPropSetByMe = meta.getBool(FN_CLASS_SETBYME, false);
        String status = meta.get(FN_STATUS, "CONF");
        String freebusy = meta.get(FN_APPT_FREEBUSY, null);
        String transp = meta.get(FN_TRANSP, "O");
        boolean sentByMe = meta.getBool(FN_SENTBYME);
        String fragment = meta.get(FN_FRAGMENT, "");
        boolean descInMeta = meta.getBool(FN_DESC_IN_META, false);
        String desc = descInMeta ? meta.get(FN_DESC, null) : null;
        String descHtml = descInMeta ? meta.get(FN_DESC_HTML, null) : null;
        long completed = meta.getLong(FN_COMPLETED, 0L);
        ParsedDateTime dtStart = null;
        ParsedDateTime dtEnd = null;
        ParsedDuration duration = null;
        RecurId recurrenceId = null;
        TimeZoneMap tzMap = TimeZoneMap.decodeFromMetadata(meta.getMap(FN_TZMAP), accountTZ);
        Metadata metaRecur = meta.getMap(FN_RECURRENCE, true);
        Recurrence.IRecurrence recurrence = null;
        if (metaRecur != null) {
            recurrence = Recurrence.decodeMetadata(metaRecur, tzMap);
        }
        String methodStr = meta.get(FN_METHOD, ZCalendar.ICalTok.PUBLISH.toString());
        if (ZCalendar.ICalTok.CANCEL.toString().equals(methodStr)) {
            status = "CANC";
        }
        int flags = (int)meta.getLong(FN_APPT_FLAGS, 0L);
        try {
            dtStart = ParsedDateTime.parse(meta.get(FN_START, null), tzMap);
            dtEnd = ParsedDateTime.parse(meta.get(FN_END, null), tzMap);
            if ((flags & 4) != 0) {
                if (dtStart != null) {
                    dtStart.forceDateOnly();
                }
                if (dtEnd != null) {
                    dtEnd.forceDateOnly();
                }
            }
            duration = ParsedDuration.parse(meta.get(FN_DURATION, null));
            if (meta.containsKey(FN_RECUR_ID)) {
                Metadata rdata = meta.getMap(FN_RECUR_ID);
                recurrenceId = RecurId.decodeMetadata(rdata, tzMap);
            }
        }
        catch (java.text.ParseException e) {
            throw ServiceException.FAILURE("Error parsing metadata for invite " + mailItemId + "-" + componentNum + " in calItem " + calItem != null ? Integer.toString(calItem.getId()) : "(null)", e);
        }
        String name = meta.get(FN_NAME, "");
        String loc = meta.get(FN_LOCATION, null);
        String partStat = meta.get(FN_PARTSTAT, "AC");
        boolean rsvp = meta.getBool(FN_RSVP, true);
        long dtstamp = meta.getLong(FN_DTSTAMP, 0L);
        int seqno = (int)meta.getLong(FN_SEQ_NO, 0L);
        ZOrganizer org = null;
        try {
            Metadata metaOrg = meta.getMap(FN_ORGANIZER, true);
            org = metaOrg != null ? new ZOrganizer(metaOrg) : null;
        }
        catch (ServiceException e) {
            sLog.warn("Problem decoding organizer for calItem " + calItem != null ? Integer.toString(calItem.getId()) : "(null) invite " + mailItemId + "-" + componentNum);
        }
        long numAts = meta.getLong(FN_NUM_ATTENDEES, 0L);
        ArrayList<ZAttendee> attendees = new ArrayList<ZAttendee>((int)numAts);
        int i = 0;
        while ((long)i < numAts) {
            try {
                Metadata metaAttendee = meta.getMap(FN_ATTENDEE + i, true);
                if (metaAttendee != null) {
                    attendees.add(new ZAttendee(metaAttendee));
                }
            }
            catch (ServiceException e) {
                ZimbraLog.calendar.warn("Problem decoding attendee " + i + " for calendar item " + calItem != null ? Integer.toString(calItem.getId()) : "(null) invite " + mailItemId + "-" + componentNum);
            }
            ++i;
        }
        boolean isOrganizer = false;
        if (meta.containsKey(FN_IS_ORGANIZER)) {
            isOrganizer = meta.getBool(FN_IS_ORGANIZER);
        } else if (org != null) {
            String orgAddr = org.getAddress();
            Account account = MailboxManager.getInstance().getMailboxById(mailboxId).getAccount();
            isOrganizer = AccountUtil.addressMatchesAccount(account, orgAddr);
        } else {
            isOrganizer = numAts < 1L;
        }
        String priority = meta.get(FN_PRIORITY, null);
        String pctComplete = meta.get(FN_PCT_COMPLETE, null);
        ArrayList<String> comments = null;
        int numComm = (int)meta.getLong(FN_NUM_COMMENTS, 0L);
        if (numComm > 0) {
            comments = new ArrayList<String>(numComm);
            for (int i2 = 0; i2 < numComm; ++i2) {
                String comm = meta.get(FN_COMMENT + i2, null);
                if (comm == null) continue;
                comments.add(comm);
            }
        }
        ArrayList<String> contacts = null;
        int numContacts = (int)meta.getLong(FN_NUM_CONTACTS, 0L);
        if (numContacts > 0) {
            contacts = new ArrayList<String>(numContacts);
            for (int i3 = 0; i3 < numContacts; ++i3) {
                String contact = meta.get(FN_CONTACT + i3, null);
                if (contact == null) continue;
                contacts.add(contact);
            }
        }
        ArrayList<String> categories = null;
        int numCat = (int)meta.getLong(FN_NUM_CATEGORIES, 0L);
        if (numCat > 0) {
            categories = new ArrayList<String>(numCat);
            for (int i4 = 0; i4 < numCat; ++i4) {
                String cat = meta.get(FN_CATEGORY + i4, null);
                if (cat == null) continue;
                categories.add(cat);
            }
        }
        Geo geo = null;
        Metadata metaGeo = meta.getMap(FN_GEO, true);
        if (metaGeo != null) {
            geo = Geo.decodeMetadata(metaGeo);
        }
        String url = meta.get(FN_URL, null);
        Invite invite = new Invite(itemType, methodStr, tzMap, calItem, uid, status, priority, pctComplete, completed, freebusy, transp, classProp, dtStart, dtEnd, duration, recurrence, isOrganizer, org, attendees, name, loc, flags, partStat, rsvp, recurrenceId, dtstamp, seqno, mailboxId, mailItemId, componentNum, sentByMe, desc, descHtml, fragment, comments, categories, contacts, geo, url);
        invite.mDescInMeta = descInMeta;
        invite.setClassPropSetByMe(classPropSetByMe);
        long numAlarms = meta.getLong(FN_NUM_ALARMS, 0L);
        int i5 = 0;
        while ((long)i5 < numAlarms) {
            try {
                Alarm alarm;
                Metadata metaAlarm = meta.getMap(FN_ALARM + i5, true);
                if (metaAlarm != null && (alarm = Alarm.decodeMetadata(metaAlarm)) != null) {
                    invite.addAlarm(alarm);
                }
            }
            catch (ServiceException e) {
                ZimbraLog.calendar.warn((Object)("Problem decoding alarm " + i5 + " for calendar item " + calItem != null ? Integer.toString(calItem.getId()) : "(null) invite " + mailItemId + "-" + componentNum), e);
            }
            ++i5;
        }
        List<ZCalendar.ZProperty> xprops = Util.decodeXPropsFromMetadata(meta);
        if (xprops != null) {
            for (ZCalendar.ZProperty xprop : xprops) {
                ZCalendar.ZParameter fmttype;
                boolean isHtmlDesc = false;
                if (ZCalendar.ICalTok.X_ALT_DESC.equals((Object)xprop.getToken()) && (fmttype = xprop.getParameter(ZCalendar.ICalTok.FMTTYPE)) != null && "text/html".equalsIgnoreCase(fmttype.getValue())) {
                    isHtmlDesc = true;
                    invite.mDescHtml = xprop.getValue();
                }
                if (isHtmlDesc) continue;
                invite.addXProp(xprop);
            }
        }
        invite.setDontIndexMimeMessage(meta.getBool(FN_DONT_INDEX_MM, false));
        boolean localOnly = meta.getBool(FN_LOCAL_ONLY, false);
        invite.setLocalOnly(localOnly);
        invite.sanitize(false);
        return invite;
    }

    public synchronized void setDontIndexMimeMessage(boolean truthiness) {
        this.mDontIndexMimeMessage = truthiness;
    }

    public synchronized boolean getDontIndexMimeMessage() {
        return this.mDontIndexMimeMessage;
    }

    public boolean descInMeta() {
        return this.mDescInMeta;
    }

    public boolean hasBlobPart() {
        return !this.descInMeta() || this.hasAttachment();
    }

    public synchronized String getDescription() throws ServiceException {
        if (!this.mDescInMeta && this.mDescription == null) {
            this.loadDescFromBlob();
        }
        return this.mDescription;
    }

    public synchronized String getDescriptionHtml() throws ServiceException {
        if (!this.mDescInMeta && this.mDescHtml == null) {
            this.loadDescFromBlob();
        }
        return this.mDescHtml;
    }

    private synchronized void loadDescFromBlob() throws ServiceException {
        MimeMessage mmInv;
        MimeMessage mimeMessage = mmInv = this.mCalItem != null ? this.mCalItem.getSubpartMessage(this.mMailItemId) : null;
        if (mmInv != null) {
            this.mDescription = Invite.getDescription((Part)mmInv, "text/plain");
            this.mDescHtml = Invite.getDescription((Part)mmInv, "text/html");
        }
    }

    public synchronized void setDescription(String desc, String html) {
        int maxInMeta = Invite.getMaxDescInMeta();
        boolean shortDesc = desc == null || desc.length() <= maxInMeta;
        boolean shortHtml = html == null || html.length() <= maxInMeta * 3;
        this.mDescInMeta = shortDesc && shortHtml;
        this.mDescription = desc;
        this.mDescHtml = html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDescription(Part mmInv, String mimeType) throws ServiceException {
        if (mmInv == null) {
            return null;
        }
        try {
            Object mmInvContent;
            ContentType mmCt;
            String mmCtStr = mmInv.getContentType();
            if (mmCtStr != null && (mmCt = new ContentType(mmCtStr)).match("text/calendar")) {
                InputStream is;
                block19: {
                    String string;
                    block21: {
                        String string2;
                        block20: {
                            boolean wantHtml = "text/html".equalsIgnoreCase(mimeType);
                            Object mmInvContent2 = mmInv.getContent();
                            is = null;
                            try {
                                String charset = "utf-8";
                                if (mmInvContent2 instanceof InputStream) {
                                    charset = mmCt.getParameter("charset");
                                    if (charset == null) {
                                        charset = "utf-8";
                                    }
                                    is = (InputStream)mmInvContent2;
                                } else if (mmInvContent2 instanceof String) {
                                    String str = (String)mmInvContent2;
                                    charset = "utf-8";
                                    is = new ByteArrayInputStream(str.getBytes(charset));
                                }
                                if (is == null) break block19;
                                ZCalendar.ZVCalendar iCal = ZCalendar.ZCalendarBuilder.build(is, charset);
                                Iterator<ZCalendar.ZComponent> compIter = iCal.getComponentIterator();
                                while (compIter.hasNext()) {
                                    ZCalendar.ZComponent component = compIter.next();
                                    ZCalendar.ICalTok compTypeTok = component.getTok();
                                    if (compTypeTok != ZCalendar.ICalTok.VEVENT && compTypeTok != ZCalendar.ICalTok.VTODO) continue;
                                    if (!wantHtml) {
                                        string2 = component.getPropVal(ZCalendar.ICalTok.DESCRIPTION, null);
                                        Object var14_20 = null;
                                        break block20;
                                    }
                                    string = component.getDescriptionHtml();
                                    break block21;
                                }
                                break block19;
                            }
                            catch (Throwable throwable) {
                                Object var14_23 = null;
                                ByteUtil.closeStream(is);
                                throw throwable;
                            }
                        }
                        ByteUtil.closeStream(is);
                        return string2;
                    }
                    Object var14_21 = null;
                    ByteUtil.closeStream(is);
                    return string;
                }
                Object var14_22 = null;
                ByteUtil.closeStream(is);
            }
            if (!((mmInvContent = mmInv.getContent()) instanceof MimeMultipart)) {
                return null;
            }
            MimeMultipart mm = (MimeMultipart)mmInvContent;
            int numParts = mm.getCount();
            String charset = null;
            for (int i = 0; i < numParts; ++i) {
                String str;
                BodyPart part = mm.getBodyPart(i);
                String ctStr = part.getContentType();
                try {
                    ContentType ct = new ContentType(ctStr);
                    if (ct.match(mimeType)) {
                        charset = ct.getParameter("charset");
                        if (charset == null) {
                            charset = "us-ascii";
                        }
                        byte[] descBytes = ByteUtil.getContent(part.getInputStream(), part.getSize());
                        return new String(descBytes, charset);
                    }
                }
                catch (ParseException e) {
                    ZimbraLog.calendar.warn((Object)("Invalid Content-Type found: \"" + ctStr + "\"; skipping part"), e);
                }
                Object mmObj = part.getContent();
                if (!(mmObj instanceof MimeMultipart) || (str = Invite.getDescription((Part)part, mimeType)) == null) continue;
                return str;
            }
            return null;
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to get calendar item notes MIME part", e);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Unable to get calendar item notes MIME part", e);
        }
    }

    public MimeMessage getMimeMessage() throws ServiceException {
        if (this.mCalItem == null || this.mMailItemId <= 0) {
            return null;
        }
        return this.mCalItem.getSubpartMessage(this.mMailItemId);
    }

    void modifyFlag(Mailbox mbx, int flag, boolean add) throws ServiceException {
        boolean changed = false;
        if (add) {
            if ((this.mFlags & flag) == 0) {
                this.mFlags |= flag;
                changed = true;
            }
        } else if ((this.mFlags & flag) != 0) {
            this.mFlags &= ~flag;
            changed = true;
        }
        if (changed) {
            this.mCalItem.saveMetadata();
            if (mbx != null) {
                this.mCalItem.markItemModified(131072);
            }
        }
    }

    public void setPartStat(String partStat) {
        this.mPartStat = partStat;
    }

    public void updateMyPartStat(Account acct, String partStat) throws ServiceException {
        if (this.mIsOrganizer) {
            this.setPartStat("AC");
            this.setRsvp(false);
        } else {
            ZAttendee at = this.getMatchingAttendee(acct);
            if (at != null) {
                this.setRsvp(at.hasRsvp() ? at.getRsvp() : false);
                if (this.mMethod == ZCalendar.ICalTok.REQUEST || this.mMethod == ZCalendar.ICalTok.COUNTER) {
                    this.setPartStat(partStat);
                    at.setPartStat(partStat);
                }
            } else {
                this.setRsvp(true);
            }
        }
    }

    public CalendarItem getCalendarItem() throws ServiceException {
        return this.mCalItem;
    }

    public void setCalendarItem(CalendarItem calItem) {
        this.mCalItem = calItem;
    }

    public void setIsAllDayEvent(boolean allDayEvent) {
        this.mFlags = allDayEvent ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
    }

    public int getComponentNum() {
        return this.mComponentNum;
    }

    public void setComponentNum(int num) {
        this.mComponentNum = num;
    }

    public long getMailboxId() {
        return this.mMailboxId;
    }

    void setMailboxId(long id) {
        this.mMailboxId = id;
    }

    public int getMailItemId() {
        return this.mMailItemId;
    }

    public void setMailItemId(int id) {
        this.mMailItemId = id;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setFlags(int flags) {
        this.mFlags = flags;
    }

    public String getPartStat() {
        return this.mPartStat;
    }

    public boolean getRsvp() {
        return this.mRsvp;
    }

    public void setRsvp(boolean rsvp) {
        this.mRsvp = rsvp;
    }

    public String getUid() {
        return this.mUid;
    }

    public void setUid(String uid) {
        this.mUid = uid;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public void setStatus(String status) {
        this.mStatus = status;
    }

    public boolean hasFreeBusy() {
        return this.mFreeBusy != null;
    }

    public String getFreeBusy() {
        return this.mFreeBusy != null ? this.mFreeBusy : "B";
    }

    public void setFreeBusy(String fb) {
        this.mFreeBusy = fb;
    }

    public String getTransparency() {
        return this.mTransparency;
    }

    public boolean isTransparent() {
        return "T".equals(this.mTransparency);
    }

    public void setTransparency(String transparency) {
        this.mTransparency = transparency;
    }

    public String getClassProp() {
        return this.mClass;
    }

    public void setClassProp(String classProp) {
        this.mClass = classProp;
    }

    public boolean classPropSetByMe() {
        return this.mClassSetByMe;
    }

    public void setClassPropSetByMe(boolean b) {
        this.mClassSetByMe = b;
    }

    public long getCompleted() {
        return this.mCompleted;
    }

    public void setCompleted(long completed) {
        this.mCompleted = completed;
    }

    public int getSeqNo() {
        return this.mSeqNo;
    }

    public void setSeqNo(int seqNo) {
        this.mSeqNo = seqNo;
    }

    public ParsedDateTime getStartTime() {
        return this.mStart;
    }

    public void setDtStart(ParsedDateTime dtStart) {
        this.mStart = dtStart;
    }

    public ParsedDateTime getEndTime() {
        return this.mEnd;
    }

    public void setDtEnd(ParsedDateTime dtend) {
        this.mEnd = dtend;
    }

    public ParsedDuration getDuration() {
        return this.mDuration;
    }

    public void setDuration(ParsedDuration dur) {
        this.mDuration = dur;
    }

    public String getPriority() {
        return this.mPriority;
    }

    public void setPriority(String prio) {
        this.mPriority = prio;
    }

    public String getPercentComplete() {
        return this.mPercentComplete;
    }

    public void setPercentComplete(String pct) {
        this.mPercentComplete = pct;
    }

    public List<String> getCategories() {
        return this.mCategories;
    }

    public void addCategory(String category) {
        this.mCategories.add(category);
    }

    public List<String> getContacts() {
        return this.mContacts;
    }

    public void addContact(String contact) {
        this.mContacts.add(contact);
    }

    public List<String> getComments() {
        return this.mComments;
    }

    public void addComment(String comment) {
        this.mComments.add(comment);
    }

    public Geo getGeo() {
        return this.mGeo;
    }

    public void setGeo(Geo geo) {
        this.mGeo = geo;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url != null ? url : "";
    }

    public long getDTStamp() {
        return this.mDTStamp;
    }

    public void setDtStamp(long stamp) {
        this.mDTStamp = stamp / 1000L * 1000L;
    }

    public boolean isPublic() {
        return "PUB".equals(this.mClass);
    }

    public boolean isCancel() {
        return ZCalendar.ICalTok.CANCEL.toString().equals((Object)this.mMethod) || "CANC".equals(this.mStatus);
    }

    public String getFreeBusyActual() {
        return this.partStatToFreeBusyActual(this.mPartStat);
    }

    public String partStatToFreeBusyActual(String partStat) {
        String fb = this.getFreeBusy();
        if ("F".equals(fb)) {
            return "F";
        }
        if ("AC".equals(partStat)) {
            return fb;
        }
        if ("NE".equals(partStat) || "TE".equals(partStat) || "TENT".equals(this.mStatus)) {
            return "T";
        }
        if ("DE".equals(partStat) || "DG".equals(partStat) || "CANC".equals(this.mStatus)) {
            return "F";
        }
        return fb;
    }

    public ParsedDateTime getEffectiveEndTime() {
        if (this.mEnd != null) {
            return this.mEnd;
        }
        if (this.mStart == null) {
            return null;
        }
        ParsedDuration dur = this.mDuration;
        if (dur == null) {
            dur = !this.mStart.hasTime() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
        }
        return this.mStart.add(dur);
    }

    public ParsedDuration getEffectiveDuration() throws ServiceException {
        if (this.mDuration != null) {
            return this.mDuration;
        }
        if (this.mStart == null) {
            return null;
        }
        if (this.mEnd != null) {
            return this.mEnd.difference(this.mStart);
        }
        if (!this.mStart.hasTime()) {
            return ParsedDuration.ONE_DAY;
        }
        return ParsedDuration.ONE_SECOND;
    }

    public String getEffectivePartStat() throws ServiceException {
        if (this.mCalItem == null) {
            return this.getPartStat();
        }
        CalendarItem.Instance inst = CalendarItem.Instance.fromInvite(this.mCalItem.getId(), this);
        return this.mCalItem.getEffectivePartStat(this, inst);
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void setLocation(String location) {
        this.mLocation = location;
    }

    public boolean isAllDayEvent() {
        return (this.mFlags & 4) != 0;
    }

    public boolean hasOrganizer() {
        return this.mOrganizer != null;
    }

    public boolean hasOtherAttendees() {
        return this.mAttendees != null && this.mAttendees.size() > 0;
    }

    void setIsRecurrence(boolean isRecurrence) {
        this.mFlags = isRecurrence ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
    }

    public boolean isRecurrence() {
        return (this.mFlags & 0x20) != 0;
    }

    public boolean hasAlarm() {
        return !this.mAlarms.isEmpty();
    }

    public boolean hasAttachment() {
        return (this.mFlags & 0x80) != 0;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.mFlags = hasAttachment ? (this.mFlags |= 0x80) : (this.mFlags &= 0xFFFFFF7F);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        sb.append("mboxid: ").append(this.mMailboxId);
        sb.append(", mailitem: ").append(this.mMailItemId);
        sb.append(", compnum: ").append(this.mComponentNum);
        sb.append(", uid: ").append(this.mUid);
        sb.append(", status: ").append(this.getStatus());
        sb.append(", partStat: ").append(this.getPartStat());
        sb.append(", rsvp: ").append(this.getRsvp());
        sb.append(", freeBusy: ").append(this.mFreeBusy);
        sb.append(", transp: ").append(this.getTransparency());
        sb.append(", class: ").append(this.getClassProp());
        sb.append(", classSetByMe: ").append(this.classPropSetByMe());
        sb.append(", sentByMe: ").append(this.sentByMe());
        sb.append(", start: ").append(this.mStart);
        sb.append(", end: ").append(this.mEnd);
        sb.append(", duration: ").append(this.mDuration);
        sb.append(", organizer: ");
        if (this.hasOrganizer()) {
            sb.append(this.getOrganizer().getAddress());
        } else {
            sb.append("(not specified)");
        }
        sb.append(", name: ").append(this.mName);
        sb.append(", location: ").append(this.mLocation);
        sb.append(", allDay: ").append(this.isAllDayEvent());
        sb.append(", otherAts: ").append(this.hasOtherAttendees());
        sb.append(", hasAlarm: ").append(this.hasAlarm());
        sb.append(", isRecur: ").append(this.isRecurrence());
        sb.append(", recurId: ").append(this.getRecurId());
        sb.append(", DTStamp: ").append(this.mDTStamp);
        sb.append(", mSeqNo ").append(this.mSeqNo);
        for (Alarm alarm : this.mAlarms) {
            sb.append(", alarm: ").append(alarm.toString());
        }
        for (ZCalendar.ZProperty xprop : this.mXProps) {
            sb.append(", ").append(xprop.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public Invite(String method, TimeZoneMap tzMap, boolean isOrganizer) {
        this.setItemType((byte)11);
        this.mMethod = Invite.lookupMethod(method);
        if (ZCalendar.ICalTok.CANCEL.equals((Object)this.mMethod)) {
            this.mStatus = "CANC";
        }
        this.mTzMap = tzMap;
        this.mIsOrganizer = isOrganizer;
        this.mFragment = "";
    }

    public Invite(byte itemType, String method, TimeZoneMap tzMap, boolean isOrganizer) {
        this.setItemType(itemType);
        this.mMethod = Invite.lookupMethod(method);
        if (ZCalendar.ICalTok.CANCEL.equals((Object)this.mMethod)) {
            this.mStatus = "CANC";
        }
        this.mTzMap = tzMap;
        this.mIsOrganizer = isOrganizer;
        this.mFragment = "";
    }

    public String getMethod() {
        return this.mMethod.toString();
    }

    public void setMethod(String methodStr) {
        this.mMethod = Invite.lookupMethod(methodStr);
    }

    public boolean sentByMe() {
        return this.mSentByMe;
    }

    void setSentByMe(boolean sentByMe) {
        this.mSentByMe = sentByMe;
    }

    private boolean thisAcctIsOrganizer(Account acct) throws ServiceException {
        if (this.hasOrganizer()) {
            String prefFromAddr;
            String addr = this.getOrganizer().getAddress();
            boolean isOrg = AccountUtil.addressMatchesAccount(acct, addr);
            if (!isOrg && acct != null && (prefFromAddr = acct.getPrefFromAddress()) != null && prefFromAddr.equalsIgnoreCase(addr)) {
                isOrg = true;
            }
            return isOrg;
        }
        return !this.hasOtherAttendees();
    }

    public ZAttendee getMatchingAttendee(Account acct) throws ServiceException {
        List<ZAttendee> attendees = this.getAttendees();
        for (ZAttendee at : attendees) {
            String thisAtEmail = at.getAddress();
            if (!AccountUtil.addressMatchesAccount(acct, thisAtEmail)) continue;
            return at;
        }
        return null;
    }

    public ZAttendee getMatchingAttendee(String atName) throws ServiceException {
        List<ZAttendee> attendees = this.getAttendees();
        for (ZAttendee at : attendees) {
            String thisAtEmail = at.getAddress();
            if (thisAtEmail == null || !thisAtEmail.equalsIgnoreCase(atName)) continue;
            return at;
        }
        return null;
    }

    public boolean updateMatchingAttendeesFromReply(Invite reply) throws ServiceException {
        List<ZAttendee> attendees = this.getAttendees();
        ArrayList<ZAttendee> toAdd = new ArrayList<ZAttendee>();
        boolean modified = false;
        block0: for (ZAttendee replyAt : reply.getAttendees()) {
            Account replyAcct = null;
            String replyAddress = replyAt.getAddress();
            if (replyAddress != null) {
                replyAcct = Provisioning.getInstance().get(Provisioning.AccountBy.name, replyAddress);
            }
            for (ZAttendee at : attendees) {
                if (!replyAt.addressesMatch(at) && (replyAcct == null || !CalendarItem.accountMatchesCalendarUser(replyAcct, at))) continue;
                if (!replyAt.hasPartStat() || replyAt.getPartStat().equals(at.getPartStat())) continue block0;
                at.setPartStat(replyAt.getPartStat());
                modified = true;
                continue block0;
            }
            if ("DE".equalsIgnoreCase(replyAt.getPartStat())) continue;
            toAdd.add(replyAt);
        }
        if (toAdd.size() > 0) {
            for (ZAttendee add : toAdd) {
                modified = true;
                attendees.add(add);
            }
        }
        if (modified) {
            this.mCalItem.saveMetadata();
            Mailbox mbx = this.mCalItem.getMailbox();
            if (mbx != null) {
                this.mCalItem.markItemModified(131072);
            }
            return true;
        }
        return false;
    }

    public List<ZAttendee> getAttendees() {
        return this.mAttendees;
    }

    public void clearAttendees() {
        this.mAttendees.clear();
    }

    public void addAttendee(ZAttendee at) {
        this.mAttendees.add(at);
    }

    public void setOrganizer(ZOrganizer org) throws ServiceException {
        this.mOrganizer = org;
    }

    public ZOrganizer getOrganizer() {
        return this.mOrganizer;
    }

    public Account getOrganizerAccount() throws ServiceException {
        Account account = null;
        if (this.mIsOrganizer && this.mCalItem != null) {
            return this.mCalItem.getAccount();
        }
        if (this.hasOrganizer()) {
            String address = this.getOrganizer().getAddress();
            if (address != null) {
                try {
                    account = Provisioning.getInstance().get(Provisioning.AccountBy.name, address);
                }
                catch (ServiceException e) {
                    if ("service.INVALID_REQUEST".equals(e.getCode())) {
                        ZimbraLog.calendar.warn("Ignoring invalid organizer address: " + address);
                    }
                    throw e;
                }
            }
        } else if (this.mCalItem != null) {
            account = this.mCalItem.getAccount();
        }
        return account;
    }

    public boolean isOrganizer() {
        return this.mIsOrganizer;
    }

    public void setIsOrganizer(Account acct) throws ServiceException {
        this.mIsOrganizer = this.thisAcctIsOrganizer(acct);
    }

    public void setIsOrganizer(boolean isOrganizer) {
        this.mIsOrganizer = isOrganizer;
    }

    public boolean isLocalOnly() {
        return this.mLocalOnly && !this.mIsOrganizer;
    }

    public void setLocalOnly(boolean localOnly) {
        this.mLocalOnly = localOnly;
    }

    public boolean isEvent() {
        return this.mItemType == 11;
    }

    public boolean isTodo() {
        return this.mItemType == 15;
    }

    public byte getItemType() {
        return this.mItemType;
    }

    public void setItemType(byte t) {
        this.mItemType = t;
        if (this.mItemType == 15 && "CONF".equals(this.mStatus)) {
            this.mStatus = "NEED";
        }
    }

    public TimeZoneMap getTimeZoneMap() {
        return this.mTzMap;
    }

    public ZCalendar.ZVCalendar newToICalendar(boolean includePrivateData) throws ServiceException {
        return this.newToICalendar(OUTLOOK_COMPAT_ALLDAY, includePrivateData);
    }

    public ZCalendar.ZVCalendar newToICalendar(boolean useOutlookCompatMode, boolean includePrivateData) throws ServiceException {
        ZCalendar.ZVCalendar vcal = new ZCalendar.ZVCalendar();
        vcal.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.METHOD, this.mMethod.toString()));
        ICalTimeZone local = this.mTzMap.getLocalTimeZone();
        if (local != null && !this.mTzMap.contains(local)) {
            vcal.addComponent(local.newToVTimeZone());
        }
        Iterator<ICalTimeZone> iter = this.mTzMap.tzIterator();
        while (iter.hasNext()) {
            ICalTimeZone cur = iter.next();
            vcal.addComponent(cur.newToVTimeZone());
        }
        vcal.addComponent(this.newToVComponent(useOutlookCompatMode, includePrivateData));
        return vcal;
    }

    public static List<Invite> createFromCalendar(Account account, String fragment, ZCalendar.ZVCalendar cal, boolean sentByMe) throws ServiceException {
        return Invite.createFromCalendar(account, fragment, cal, sentByMe, null, 0);
    }

    public static List<Invite> createFromCalendar(Account account, String fragment, ZCalendar.ZVCalendar cal, boolean sentByMe, Mailbox mbx, int mailItemId) throws ServiceException {
        ArrayList<Invite> list = new ArrayList<Invite>();
        Invite.createFromCalendar(list, account, fragment, cal, sentByMe, mbx, mailItemId, false, null);
        return list;
    }

    public static List<Invite> createFromCalendar(Account account, String fragment, List<ZCalendar.ZVCalendar> cals, boolean sentByMe) throws ServiceException {
        return Invite.createFromCalendar(account, fragment, cals, sentByMe, false, null);
    }

    public static void createFromCalendar(Account account, String fragment, String method, TimeZoneMap tzmap, Iterator<ZCalendar.ZComponent> compIter, boolean sentByMe, boolean continueOnError, InviteVisitor visitor) throws ServiceException {
        Invite.createFromCalendar(null, account, fragment, method, tzmap, compIter, sentByMe, null, 0, continueOnError, visitor);
    }

    public static List<Invite> createFromCalendar(Account account, String fragment, List<ZCalendar.ZVCalendar> cals, boolean sentByMe, boolean continueOnError, InviteVisitor visitor) throws ServiceException {
        ArrayList<Invite> list = new ArrayList<Invite>();
        for (ZCalendar.ZVCalendar cal : cals) {
            Invite.createFromCalendar(list, account, fragment, cal, sentByMe, null, 0, continueOnError, visitor);
        }
        return list;
    }

    private static void createFromCalendar(List<Invite> toAdd, Account account, String fragment, ZCalendar.ZVCalendar cal, boolean sentByMe, Mailbox mbx, int mailItemId, boolean continueOnError, InviteVisitor visitor) throws ServiceException {
        String method = cal.getPropVal(ZCalendar.ICalTok.METHOD, ZCalendar.ICalTok.PUBLISH.toString());
        TimeZoneMap tzmap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(account));
        for (ZCalendar.ZComponent comp : cal.mComponents) {
            if (!ZCalendar.ICalTok.VTIMEZONE.equals((Object)comp.getTok())) continue;
            ICalTimeZone tz = ICalTimeZone.fromVTimeZone(comp);
            tzmap.add(tz);
        }
        Invite.createFromCalendar(toAdd, account, fragment, method, tzmap, cal.getComponentIterator(), sentByMe, mbx, mailItemId, continueOnError, visitor);
    }

    private static void createFromCalendar(List<Invite> toAdd, Account account, String fragment, String method, TimeZoneMap tzmap, Iterator<ZCalendar.ZComponent> compIter, boolean sentByMe, Mailbox mbx, int mailItemId, boolean continueOnError, InviteVisitor visitor) throws ServiceException {
        int compNum = 0;
        block46: while (compIter.hasNext()) {
            ZCalendar.ZComponent comp = compIter.next();
            Invite newInv = null;
            try {
                ZCalendar.ICalTok compTypeTok = comp.getTok();
                if (compTypeTok == null) continue;
                byte type = ZCalendar.ICalTok.VTODO.equals((Object)compTypeTok) ? (byte)15 : 11;
                switch (compTypeTok) {
                    case VEVENT: 
                    case VTODO: {
                        boolean isEvent = ZCalendar.ICalTok.VEVENT.equals((Object)compTypeTok);
                        boolean isTodo = ZCalendar.ICalTok.VTODO.equals((Object)compTypeTok);
                        try {
                            String string;
                            ParsedDateTime st;
                            ParsedDateTime end;
                            newInv = new Invite(type, method, tzmap, false);
                            newInv.setLocalOnly(false);
                            if (toAdd != null) {
                                toAdd.add(newInv);
                            }
                            ArrayList<Object> addRecurs = new ArrayList<Object>();
                            ArrayList<Object> subRecurs = new ArrayList<Object>();
                            newInv.setComponentNum(compNum);
                            if (mbx != null) {
                                newInv.setMailboxId(mbx.getId());
                            }
                            newInv.setMailItemId(mailItemId);
                            newInv.setSentByMe(sentByMe);
                            ++compNum;
                            for (ZCalendar.ZComponent subcomp : comp.mComponents) {
                                ZCalendar.ICalTok subCompTypeTok = subcomp.getTok();
                                switch (subCompTypeTok) {
                                    case VALARM: {
                                        Alarm alarm = Alarm.parse(subcomp);
                                        if (alarm == null) break;
                                        newInv.addAlarm(alarm);
                                        break;
                                    }
                                }
                            }
                            boolean sawIntendedFreeBusy = false;
                            block48: for (ZCalendar.ZProperty prop : comp.mProperties) {
                                String val = prop.getValue();
                                if (val == null || val.length() < 1) continue;
                                if (prop.mTok == null) {
                                    String name = prop.getName();
                                    if (!name.startsWith("X-") && !name.startsWith("x-")) continue;
                                    newInv.addXProp(prop);
                                    continue;
                                }
                                switch (prop.mTok) {
                                    case ORGANIZER: {
                                        newInv.setOrganizer(new ZOrganizer(prop));
                                        break;
                                    }
                                    case ATTENDEE: {
                                        newInv.addAttendee(new ZAttendee(prop));
                                        break;
                                    }
                                    case DTSTAMP: {
                                        ParsedDateTime dtstamp = ParsedDateTime.parse(prop, tzmap);
                                        newInv.setDtStamp(dtstamp.getUtcTime());
                                        break;
                                    }
                                    case RECURRENCE_ID: {
                                        ParsedDateTime parsedDateTime = ParsedDateTime.parse(prop, tzmap);
                                        newInv.setRecurId(new RecurId(parsedDateTime, RecurId.RANGE_NONE));
                                        break;
                                    }
                                    case SEQUENCE: {
                                        newInv.setSeqNo(prop.getIntValue());
                                        break;
                                    }
                                    case DTSTART: {
                                        ParsedDateTime dtstart = ParsedDateTime.parse(prop, tzmap);
                                        newInv.setDtStart(dtstart);
                                        if (dtstart.hasTime()) break;
                                        newInv.setIsAllDayEvent(true);
                                        break;
                                    }
                                    case DTEND: {
                                        if (!isEvent) break;
                                        ParsedDateTime dtend = ParsedDateTime.parse(prop, tzmap);
                                        newInv.setDtEnd(dtend);
                                        break;
                                    }
                                    case DUE: {
                                        if (!isTodo) break;
                                        ParsedDateTime due = ParsedDateTime.parse(prop, tzmap);
                                        newInv.setDtEnd(due);
                                        break;
                                    }
                                    case DURATION: {
                                        ParsedDuration dur = ParsedDuration.parse(prop.getValue());
                                        newInv.setDuration(dur);
                                        break;
                                    }
                                    case LOCATION: {
                                        newInv.setLocation(prop.getValue());
                                        break;
                                    }
                                    case SUMMARY: {
                                        String summary = prop.getValue();
                                        if (summary != null) {
                                            summary = ZCalendar.unescape(summary);
                                            summary = summary.replaceAll("[\\\r\\\n]+", " ");
                                        }
                                        prop.setValue(summary);
                                        newInv.setName(summary);
                                        break;
                                    }
                                    case DESCRIPTION: {
                                        newInv.setDescription(prop.mValue, newInv.mDescHtml);
                                        newInv.setFragment(Fragment.getFragment(prop.mValue, true));
                                        break;
                                    }
                                    case X_ALT_DESC: {
                                        ZCalendar.ZParameter fmttype = prop.getParameter(ZCalendar.ICalTok.FMTTYPE);
                                        if (fmttype != null && "text/html".equalsIgnoreCase(fmttype.getValue())) {
                                            String html = prop.getValue();
                                            newInv.setDescription(newInv.mDescription, html);
                                            break;
                                        }
                                        newInv.addXProp(prop);
                                        break;
                                    }
                                    case COMMENT: {
                                        newInv.addComment(prop.getValue());
                                        break;
                                    }
                                    case UID: {
                                        newInv.setUid(prop.getValue());
                                        break;
                                    }
                                    case RRULE: {
                                        ZRecur recur = new ZRecur(prop.getValue(), tzmap);
                                        addRecurs.add(recur);
                                        newInv.setIsRecurrence(true);
                                        break;
                                    }
                                    case RDATE: {
                                        RdateExdate rdate = RdateExdate.parse(prop, tzmap);
                                        addRecurs.add(rdate);
                                        newInv.setIsRecurrence(true);
                                        break;
                                    }
                                    case EXRULE: {
                                        ZRecur exrecur = new ZRecur(prop.getValue(), tzmap);
                                        subRecurs.add(exrecur);
                                        newInv.setIsRecurrence(true);
                                        break;
                                    }
                                    case EXDATE: {
                                        RdateExdate exdate = RdateExdate.parse(prop, tzmap);
                                        subRecurs.add(exdate);
                                        newInv.setIsRecurrence(true);
                                        break;
                                    }
                                    case STATUS: {
                                        String status = IcalXmlStrMap.sStatusMap.toXml(prop.getValue());
                                        if (status == null) break;
                                        if ("INPR".equals(status)) {
                                            String zstatus = prop.getParameterVal(ZCalendar.ICalTok.X_ZIMBRA_STATUS, null);
                                            if (ZCalendar.ICalTok.X_ZIMBRA_STATUS_WAITING.toString().equals(zstatus) || ZCalendar.ICalTok.X_ZIMBRA_STATUS_DEFERRED.toString().equals(zstatus)) {
                                                newInv.setStatus(IcalXmlStrMap.sStatusMap.toXml(zstatus));
                                                break;
                                            }
                                            newInv.setStatus(status);
                                            break;
                                        }
                                        newInv.setStatus(status);
                                        break;
                                    }
                                    case TRANSP: {
                                        if (!isEvent || sawIntendedFreeBusy) break;
                                        String transp = IcalXmlStrMap.sTranspMap.toXml(prop.getValue());
                                        if (transp == null) continue block48;
                                        newInv.setTransparency(transp);
                                        if (!newInv.isTransparent()) continue block48;
                                        newInv.setFreeBusy("F");
                                        break;
                                    }
                                    case CLASS: {
                                        String classProp = IcalXmlStrMap.sClassMap.toXml(prop.getValue());
                                        if (classProp == null) break;
                                        newInv.setClassProp(classProp);
                                        break;
                                    }
                                    case X_MICROSOFT_CDO_ALLDAYEVENT: {
                                        if (!isEvent || !prop.getBoolValue()) break;
                                        newInv.setIsAllDayEvent(true);
                                        break;
                                    }
                                    case X_MICROSOFT_CDO_INTENDEDSTATUS: {
                                        sawIntendedFreeBusy = true;
                                        if (!isEvent) break;
                                        String fb = IcalXmlStrMap.sOutlookFreeBusyMap.toXml(prop.getValue());
                                        if (fb == null) continue block48;
                                        newInv.setFreeBusy(fb);
                                        if ("F".equals(fb)) {
                                            newInv.setTransparency("T");
                                            break;
                                        }
                                        newInv.setTransparency("O");
                                        break;
                                    }
                                    case PRIORITY: {
                                        String prio = prop.getValue();
                                        if (prio == null) break;
                                        newInv.setPriority(prio);
                                        break;
                                    }
                                    case PERCENT_COMPLETE: {
                                        if (!isTodo) break;
                                        String pctComplete = prop.getValue();
                                        if (pctComplete == null) continue block48;
                                        newInv.setPercentComplete(pctComplete);
                                        break;
                                    }
                                    case COMPLETED: {
                                        if (!isTodo) break;
                                        ParsedDateTime completed = ParsedDateTime.parseUtcOnly(prop.getValue());
                                        newInv.setCompleted(completed.getUtcTime());
                                        break;
                                    }
                                    case CATEGORIES: {
                                        List<String> categories = ZCalendar.parseCommaSepText(prop.getValue());
                                        for (String cat : categories) {
                                            newInv.addCategory(cat);
                                        }
                                        continue block48;
                                    }
                                    case CONTACT: {
                                        newInv.addContact(prop.getValue());
                                        break;
                                    }
                                    case GEO: {
                                        Geo geo = Geo.parse(prop);
                                        newInv.setGeo(geo);
                                        break;
                                    }
                                    case URL: {
                                        newInv.setUrl(prop.getValue());
                                        break;
                                    }
                                    case X_ZIMBRA_LOCAL_ONLY: {
                                        if (!prop.getBoolValue()) break;
                                        newInv.setLocalOnly(true);
                                        break;
                                    }
                                    case X_ZIMBRA_DISCARD_EXCEPTIONS: {
                                        newInv.addXProp(prop);
                                    }
                                }
                            }
                            newInv.setIsOrganizer(account);
                            newInv.validateDuration();
                            ParsedDuration duration = newInv.getDuration();
                            if (duration == null && (end = newInv.getEndTime()) != null && newInv.getStartTime() != null) {
                                duration = end.difference(newInv.getStartTime());
                            }
                            if (!(addRecurs.isEmpty() && subRecurs.isEmpty() || (st = newInv.getStartTime()) != null)) {
                                ParsedDateTime et = newInv.getEndTime();
                                if (et != null) {
                                    st = et.hasTime() ? et.add(ParsedDuration.NEGATIVE_ONE_SECOND) : et.add(ParsedDuration.NEGATIVE_ONE_DAY);
                                    newInv.setDtStart(st);
                                } else {
                                    throw ServiceException.INVALID_REQUEST("recurrence used without DTSTART", null);
                                }
                            }
                            InviteInfo inviteInfo = new InviteInfo(newInv);
                            ArrayList<Recurrence.IRecurrence> addRules = new ArrayList<Recurrence.IRecurrence>();
                            if (addRecurs.size() > 0) {
                                for (Object e : addRecurs) {
                                    if (e instanceof ZRecur) {
                                        ZRecur cur = (ZRecur)e;
                                        addRules.add(new Recurrence.SimpleRepeatingRule(newInv.getStartTime(), duration, cur, inviteInfo));
                                        continue;
                                    }
                                    if (!(e instanceof RdateExdate)) continue;
                                    RdateExdate rdate = (RdateExdate)e;
                                    addRules.add(new Recurrence.SingleDates(rdate, duration, inviteInfo));
                                }
                            }
                            ArrayList<Recurrence.IRecurrence> subRules = new ArrayList<Recurrence.IRecurrence>();
                            if (subRecurs.size() > 0) {
                                Iterator iterator = subRecurs.iterator();
                                while (iterator.hasNext()) {
                                    Object next = iterator.next();
                                    if (next instanceof ZRecur) {
                                        ZRecur cur = (ZRecur)iterator.next();
                                        subRules.add(new Recurrence.SimpleRepeatingRule(newInv.getStartTime(), duration, cur, inviteInfo));
                                        continue;
                                    }
                                    if (!(next instanceof RdateExdate)) continue;
                                    RdateExdate exdate = (RdateExdate)next;
                                    subRules.add(new Recurrence.SingleDates(exdate, duration, inviteInfo));
                                }
                            }
                            if (newInv.hasRecurId()) {
                                if (addRules.size() > 0) {
                                    newInv.setRecurrence(new Recurrence.ExceptionRule(newInv.getRecurId(), newInv.getStartTime(), duration, new InviteInfo(newInv), addRules, subRules));
                                }
                            } else if (addRules.size() > 0) {
                                newInv.setRecurrence(new Recurrence.RecurrenceRule(newInv.getStartTime(), duration, new InviteInfo(newInv), addRules, subRules));
                            }
                            if ((string = newInv.getLocation()) == null) {
                                newInv.setLocation("");
                            }
                            if (visitor == null) continue block46;
                            visitor.visit(newInv);
                            break;
                        }
                        catch (java.text.ParseException e) {
                            throw ServiceException.PARSE_ERROR("Unable to parse iCalendar data: " + e.getMessage(), e);
                        }
                    }
                }
            }
            catch (ServiceException e) {
                if (!continueOnError) {
                    throw e;
                }
                if (newInv != null) {
                    Invite.logIcsParseImportError(newInv, e);
                    continue;
                }
                ZimbraLog.calendar.warn((Object)"Skipping error during ics parse/import", e);
            }
            catch (RuntimeException e) {
                if (!continueOnError) {
                    throw e;
                }
                if (newInv != null) {
                    Invite.logIcsParseImportError(newInv, e);
                    continue;
                }
                ZimbraLog.calendar.warn((Object)"Skipping error during ics parse/import", e);
            }
        }
    }

    private static void logIcsParseImportError(Invite inv, Exception e) {
        String uid = inv.getUid();
        String recurrenceId = inv.hasRecurId() ? inv.getRecurId().toString() : null;
        int seq = inv.getSeqNo();
        String dtStart = inv.getStartTime() != null ? inv.getStartTime().toString() : null;
        String summary = inv.getName();
        ZimbraLog.calendar.warn((Object)("Skipping error during ics parse/import: UID:" + uid + (recurrenceId != null ? ", RECURRENCE-ID:" + recurrenceId : "") + ", SEQUENCE:" + seq + (dtStart != null ? ", DTSTART:" + dtStart : "") + (summary != null ? ", SUMMARY:" + summary : "")), e);
    }

    public ZCalendar.ZComponent newToVComponent(boolean useOutlookCompatAllDayEvents, boolean includePrivateData) throws ServiceException {
        RecurId recurId;
        ParsedDuration dur;
        ParsedDateTime dtend;
        ParsedDateTime dtstart;
        ZCalendar.ICalTok compTok;
        boolean isRequestPublishCancel;
        boolean bl = isRequestPublishCancel = ZCalendar.ICalTok.REQUEST.equals((Object)this.mMethod) || ZCalendar.ICalTok.PUBLISH.equals((Object)this.mMethod) || ZCalendar.ICalTok.CANCEL.equals((Object)this.mMethod);
        if (this.mItemType == 15) {
            compTok = ZCalendar.ICalTok.VTODO;
            useOutlookCompatAllDayEvents = false;
        } else {
            compTok = ZCalendar.ICalTok.VEVENT;
        }
        ZCalendar.ZComponent component = new ZCalendar.ZComponent(compTok);
        component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.UID, this.getUid()));
        Recurrence.IRecurrence recur = this.getRecurrence();
        if (recur != null) {
            Recurrence.SimpleRepeatingRule srr;
            Recurrence.SingleDates sd;
            Recurrence.IRecurrence cur;
            Iterator iter = recur.addRulesIterator();
            while (iter != null && iter.hasNext()) {
                cur = (Recurrence.IRecurrence)iter.next();
                switch (cur.getType()) {
                    case 6: {
                        sd = (Recurrence.SingleDates)cur;
                        RdateExdate rdate = sd.getRdateExdate();
                        component.addProperty(rdate.toZProperty());
                        break;
                    }
                    case 5: {
                        srr = (Recurrence.SimpleRepeatingRule)cur;
                        component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.RRULE, srr.getRule().toString()));
                    }
                }
            }
            iter = recur.subRulesIterator();
            while (iter != null && iter.hasNext()) {
                cur = (Recurrence.IRecurrence)iter.next();
                switch (cur.getType()) {
                    case 6: {
                        sd = (Recurrence.SingleDates)cur;
                        RdateExdate exdate = sd.getRdateExdate();
                        component.addProperty(exdate.toZProperty());
                        break;
                    }
                    case 5: {
                        srr = (Recurrence.SimpleRepeatingRule)cur;
                        component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.EXRULE, srr.getRule().toString()));
                    }
                }
            }
        }
        if (includePrivateData || this.isPublic()) {
            List<String> contacts;
            List<String> categories;
            String location;
            List<String> comments;
            String descHtml;
            String desc;
            String name = this.getName();
            if (name != null && name.length() > 0) {
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.SUMMARY, name));
            }
            if ((desc = this.getDescription()) != null) {
                int delim = desc.indexOf(HEADER_SEPARATOR);
                if (delim >= 0) {
                    desc = desc.substring(delim + HEADER_SEPARATOR.length());
                    desc = desc.replaceFirst("^\\r?\\n\\r?\\n", "");
                }
                if (desc.length() > 0) {
                    component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.DESCRIPTION, desc));
                }
            }
            if ((descHtml = this.getDescriptionHtml()) != null && descHtml.length() > 0) {
                ZCalendar.ZProperty altDesc = new ZCalendar.ZProperty(ZCalendar.ICalTok.X_ALT_DESC, descHtml);
                altDesc.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.FMTTYPE, "text/html"));
                component.addProperty(altDesc);
            }
            if ((comments = this.getComments()) != null && !comments.isEmpty()) {
                for (String comment : comments) {
                    component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.COMMENT, comment));
                }
            }
            if ((location = this.getLocation()) != null && location.length() > 0) {
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.LOCATION, location.toString()));
            }
            for (ZAttendee at : this.getAttendees()) {
                component.addProperty(at.toProperty());
            }
            if (this.mPriority != null) {
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.PRIORITY, this.mPriority));
            }
            if (this.isTodo() && this.mPercentComplete != null) {
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.PERCENT_COMPLETE, this.mPercentComplete));
            }
            if (this.isTodo() && this.mCompleted != 0L) {
                ParsedDateTime completed = ParsedDateTime.fromUTCTime(this.mCompleted);
                component.addProperty(completed.toProperty(ZCalendar.ICalTok.COMPLETED, false));
            }
            if ((categories = this.getCategories()) != null && !categories.isEmpty()) {
                String encodedCat = ZCalendar.toCommaSepText(categories);
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.CATEGORIES, encodedCat));
            }
            if ((contacts = this.getContacts()) != null && !contacts.isEmpty()) {
                for (String contact : contacts) {
                    component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.CONTACT, contact));
                }
            }
            if (this.mGeo != null) {
                component.addProperty(this.mGeo.toZProperty());
            }
            for (Alarm alarm : this.mAlarms) {
                ZCalendar.ZComponent alarmComp = alarm.toZComponent();
                component.addComponent(alarmComp);
            }
            for (ZCalendar.ZProperty xprop : this.mXProps) {
                component.addProperty(xprop);
            }
        }
        if (this.hasOrganizer()) {
            String sentByParam;
            ZOrganizer organizer = this.getOrganizer();
            ZCalendar.ZProperty orgProp = organizer.toProperty();
            component.addProperty(orgProp);
            if (organizer.hasSentBy() && !ZCalendar.ICalTok.REPLY.equals((Object)this.mMethod) && !ZCalendar.ICalTok.COUNTER.equals((Object)this.mMethod) && (sentByParam = orgProp.paramVal(ZCalendar.ICalTok.SENT_BY, null)) != null) {
                ZCalendar.ZProperty xMsOlkSender = new ZCalendar.ZProperty("X-MS-OLK-SENDER");
                xMsOlkSender.setValue(sentByParam);
                component.addProperty(xMsOlkSender);
            }
        }
        if ((dtstart = this.getStartTime()) != null) {
            component.addProperty(dtstart.toProperty(ZCalendar.ICalTok.DTSTART, useOutlookCompatAllDayEvents));
        }
        if ((dtend = this.getEndTime()) != null) {
            ZCalendar.ICalTok prop = ZCalendar.ICalTok.DTEND;
            if (this.isTodo()) {
                prop = ZCalendar.ICalTok.DUE;
            }
            component.addProperty(dtend.toProperty(prop, useOutlookCompatAllDayEvents));
        }
        if ((dur = this.getDuration()) != null) {
            component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.DURATION, dur.toString()));
        }
        String status = this.getStatus();
        String statusIcal = IcalXmlStrMap.sStatusMap.toIcal(status);
        if ("WAITING".equals(status) || "DEFERRED".equals(status)) {
            ZCalendar.ZParameter param = new ZCalendar.ZParameter(ZCalendar.ICalTok.X_ZIMBRA_STATUS, statusIcal);
            ZCalendar.ZProperty prop = new ZCalendar.ZProperty(ZCalendar.ICalTok.STATUS, ZCalendar.ICalTok.IN_PROCESS.toString());
            prop.addParameter(param);
            component.addProperty(prop);
        } else {
            component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.STATUS, statusIcal));
        }
        component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.CLASS, IcalXmlStrMap.sClassMap.toIcal(this.getClassProp())));
        if (this.isEvent()) {
            if (this.isAllDayEvent()) {
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.X_MICROSOFT_CDO_ALLDAYEVENT, true));
            }
            if (isRequestPublishCancel) {
                String outlookFreeBusy = IcalXmlStrMap.sOutlookFreeBusyMap.toIcal(this.getFreeBusy());
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.X_MICROSOFT_CDO_INTENDEDSTATUS, outlookFreeBusy));
            }
            component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TRANSP, IcalXmlStrMap.sTranspMap.toIcal(this.getTransparency())));
            if (isRequestPublishCancel) {
                component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.X_MICROSOFT_DISALLOW_COUNTER, true));
            }
        }
        if ((recurId = this.getRecurId()) != null) {
            component.addProperty(recurId.toProperty(useOutlookCompatAllDayEvents));
        }
        ParsedDateTime dtStamp = ParsedDateTime.fromUTCTime(this.getDTStamp());
        component.addProperty(dtStamp.toProperty(ZCalendar.ICalTok.DTSTAMP, useOutlookCompatAllDayEvents));
        component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.SEQUENCE, this.getSeqNo()));
        String url = this.getUrl();
        if (url != null && url.length() > 0) {
            component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.URL, url));
        }
        if (this.isLocalOnly()) {
            component.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.X_ZIMBRA_LOCAL_ONLY, true));
        }
        return component;
    }

    public static ZCalendar.ZComponent[] toVComponents(Invite[] invites, boolean includePrivateData, boolean useOutlookCompatAllDayEvents, boolean convertCanceledInstancesToExdates) throws ServiceException {
        ArrayList<ZCalendar.ZComponent> comps = new ArrayList<ZCalendar.ZComponent>(invites.length);
        if (!convertCanceledInstancesToExdates || invites.length <= 1) {
            for (Invite inv : invites) {
                ZCalendar.ZComponent comp = inv.newToVComponent(useOutlookCompatAllDayEvents, includePrivateData);
                comps.add(comp);
            }
        } else {
            ZCalendar.ZComponent comp;
            Invite seriesInv = null;
            ZCalendar.ZComponent seriesComp = null;
            for (Invite inv : invites) {
                if (!inv.isRecurrence()) continue;
                seriesComp = comp = inv.newToVComponent(useOutlookCompatAllDayEvents, includePrivateData);
                comps.add(seriesComp);
                seriesInv = inv;
                break;
            }
            for (Invite inv : invites) {
                if (inv == seriesInv) continue;
                if (inv.hasRecurId() && inv.isCancel()) {
                    if (seriesComp != null) {
                        RecurId rid = inv.getRecurId();
                        ZCalendar.ZProperty ridProp = rid.toProperty(false);
                        ZCalendar.ZProperty exdateProp = new ZCalendar.ZProperty(ZCalendar.ICalTok.EXDATE, ridProp.getValue());
                        Iterator<ZCalendar.ZParameter> paramsIter = ridProp.parameterIterator();
                        while (paramsIter.hasNext()) {
                            ZCalendar.ZParameter param = paramsIter.next();
                            exdateProp.addParameter(param);
                        }
                        seriesComp.addProperty(exdateProp);
                        continue;
                    }
                    comp = inv.newToVComponent(useOutlookCompatAllDayEvents, includePrivateData);
                    if (comp == null) continue;
                    comps.add(comp);
                    continue;
                }
                comp = inv.newToVComponent(useOutlookCompatAllDayEvents, includePrivateData);
                if (comp == null) continue;
                comps.add(comp);
            }
        }
        return comps.toArray(new ZCalendar.ZComponent[0]);
    }

    public Iterator<Alarm> alarmsIterator() {
        return this.mAlarms.iterator();
    }

    public void addAlarm(Alarm alarm) {
        this.mAlarms.add(alarm);
    }

    public List<Alarm> getAlarms() {
        return this.mAlarms;
    }

    public void clearAlarms() {
        this.mAlarms.clear();
    }

    public Iterator<ZCalendar.ZProperty> xpropsIterator() {
        return this.mXProps.iterator();
    }

    public void addXProp(ZCalendar.ZProperty prop) {
        this.mXProps.add(prop);
    }

    public ZCalendar.ZProperty getXProperty(String xpropName) {
        for (ZCalendar.ZProperty prop : this.mXProps) {
            if (!prop.getName().equalsIgnoreCase(xpropName)) continue;
            return prop;
        }
        return null;
    }

    public void validateDuration() throws ServiceException {
        if (this.mStart == null) {
            return;
        }
        if (!this.isTodo()) {
            ParsedDateTime et;
            long durMillis;
            ParsedDuration durMinimum;
            ParsedDuration parsedDuration = durMinimum = this.mStart.hasTime() ? ParsedDuration.parse(false, 0, 0, 0, 0, 1) : ParsedDuration.parse(false, 0, 1, 0, 0, 0);
            if (this.mEnd != null && this.mEnd.compareTo(this.mStart) <= 0) {
                this.mEnd = this.mStart.add(durMinimum);
            } else if (this.mDuration != null && (durMillis = (et = this.mStart.add(this.mDuration)).getUtcTime() - this.mStart.getUtcTime()) <= 0L) {
                this.mDuration = durMinimum;
            }
        }
    }

    public boolean isSameOrNewerVersion(Invite other) {
        int otherSeq;
        if (other == null) {
            return false;
        }
        int thisSeq = this.getSeqNo();
        return thisSeq > (otherSeq = other.getSeqNo()) || thisSeq == otherSeq && this.getDTStamp() >= other.getDTStamp();
    }

    public Invite newCopy() {
        ArrayList<ZAttendee> attendees = new ArrayList<ZAttendee>(this.mAttendees.size());
        for (ZAttendee at : this.mAttendees) {
            attendees.add(new ZAttendee(at));
        }
        ZOrganizer org = this.mOrganizer != null ? new ZOrganizer(this.mOrganizer) : null;
        Invite inv = new Invite(this.mItemType, this.mMethod != null ? this.mMethod.toString() : null, this.mTzMap, this.mCalItem, this.mUid, this.mStatus, this.mPriority, this.mPercentComplete, this.mCompleted, this.mFreeBusy, this.mTransparency, this.mClass, this.mStart, this.mEnd, this.mDuration, this.mRecurrence, this.mIsOrganizer, org, attendees, this.mName, this.mLocation, this.mFlags, this.mPartStat, this.mRsvp, this.mRecurrenceId, this.mDTStamp, this.mSeqNo, 0L, 0, 0, this.mSentByMe, this.mDescription, this.mDescHtml, this.mFragment, new ArrayList<String>(this.mComments), new ArrayList<String>(this.mCategories), new ArrayList<String>(this.mContacts), this.mGeo != null ? new Geo(this.mGeo.getLatitude(), this.mGeo.getLongitude()) : null, this.mUrl);
        inv.setClassPropSetByMe(this.classPropSetByMe());
        inv.setDontIndexMimeMessage(this.getDontIndexMimeMessage());
        inv.mLocalOnly = this.mLocalOnly;
        return inv;
    }

    private static String limitIntegerRange(String value, int min, int max, String defaultValue) {
        String retval = defaultValue;
        if (value != null) {
            try {
                int num = Integer.parseInt(value);
                retval = num < min ? Integer.toString(min) : (num > max ? Integer.toString(max) : value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return retval;
    }

    public static boolean isOrganizerMethod(String method) {
        ZCalendar.ICalTok methodTok = ZCalendar.ICalTok.lookup(method);
        return Invite.isOrganizerMethod(methodTok);
    }

    public static boolean isOrganizerMethod(ZCalendar.ICalTok method) {
        boolean isRequesting;
        if (method != null) {
            switch (method) {
                case REQUEST: 
                case PUBLISH: 
                case ADD: 
                case CANCEL: 
                case DECLINECOUNTER: {
                    isRequesting = true;
                    break;
                }
                default: {
                    isRequesting = false;
                    break;
                }
            }
        } else {
            isRequesting = true;
        }
        return isRequesting;
    }

    public void sanitize(boolean throwException) throws ServiceException {
        if ((this.mUid == null || this.mUid.length() == 0) && throwException) {
            throw ServiceException.INVALID_REQUEST("missing UID", null);
        }
        if (this.mStart == null) {
            this.setIsAllDayEvent(false);
        } else if (!this.mStart.hasTime()) {
            this.setIsAllDayEvent(true);
        } else if (!this.mStart.hasZeroTime()) {
            this.setIsAllDayEvent(false);
        }
        if (Invite.isOrganizerMethod(this.mMethod) && this.hasOtherAttendees() && !this.hasOrganizer()) {
            if (throwException) {
                throw ServiceException.INVALID_REQUEST("ORGANIZER missing when ATTENDEEs are present", null);
            }
            this.clearAttendees();
        }
        if (this.mStart != null && this.mEnd != null && this.mEnd.compareTo(this.mStart) < 0) {
            this.mEnd = (ParsedDateTime)this.mStart.clone();
        }
        if (this.mRecurrence != null && this.mStart == null) {
            if (throwException) {
                throw ServiceException.INVALID_REQUEST("recurrence used without DTSTART", null);
            }
            this.mRecurrence = null;
        }
        this.mPercentComplete = Invite.limitIntegerRange(this.mPercentComplete, 0, 100, null);
        this.mPriority = Invite.limitIntegerRange(this.mPriority, 0, 9, null);
    }

    public static void setDefaultAlarm(Invite inv, Account acct) throws ServiceException {
        inv.clearAlarms();
        int prefNonAllDayMinutesBefore = (int)acct.getLongAttr("zimbraPrefCalendarApptReminderWarningTime", 0L);
        int hoursBefore = 0;
        int minutesBefore = 0;
        if (!inv.isAllDayEvent()) {
            hoursBefore = 0;
            minutesBefore = prefNonAllDayMinutesBefore;
        } else if (prefNonAllDayMinutesBefore > 0) {
            hoursBefore = 18;
            minutesBefore = 0;
        }
        if (minutesBefore > 0 || hoursBefore > 0) {
            String summary = inv.getName();
            Alarm newAlarm = new Alarm(Alarm.Action.DISPLAY, Alarm.TriggerType.RELATIVE, Alarm.TriggerRelated.START, ParsedDuration.parse(true, 0, 0, hoursBefore, minutesBefore, 0), null, null, 0, null, summary, null, null);
            inv.addAlarm(newAlarm);
        }
    }

    public static interface InviteVisitor {
        public void visit(Invite var1) throws ServiceException;
    }
}

