/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.data.ParserException;

public class IcsImportParseHandler
implements ZCalendar.ZICalendarParseHandler {
    ZCalendar.ZVCalendar mCurCal = null;
    List<ZCalendar.ZComponent> mComponents = new ArrayList<ZCalendar.ZComponent>();
    ZCalendar.ZProperty mCurProperty = null;
    private int mNumCals;
    private boolean mInZCalendar;
    private Account mAccount;
    private boolean mContinueOnError;
    private String mMethod;
    private TimeZoneMap mTimeZoneMap;
    private Set<String> mTZIDsSeen;
    private Invite.InviteVisitor mInviteVisitor;

    public IcsImportParseHandler(OperationContext ctxt, Account account, Folder folder, boolean continueOnError, boolean preserveExistingAlarms) {
        this.mAccount = account;
        this.mContinueOnError = continueOnError;
        this.mTZIDsSeen = new HashSet<String>();
        this.mInviteVisitor = new ImportInviteVisitor(ctxt, folder, preserveExistingAlarms);
    }

    public IcsImportParseHandler(OperationContext ctxt, Account account, Invite.InviteVisitor visitor, boolean continueOnError, boolean removeAlarms) {
        this.mAccount = account;
        this.mContinueOnError = continueOnError;
        this.mTZIDsSeen = new HashSet<String>();
        this.mInviteVisitor = visitor;
    }

    public void startCalendar() throws ParserException {
        this.mComponents.clear();
        this.mInZCalendar = true;
        this.mCurCal = new ZCalendar.ZVCalendar();
        this.mMethod = ZCalendar.ICalTok.PUBLISH.toString();
        this.mTimeZoneMap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(this.mAccount));
    }

    public void endCalendar() throws ParserException {
        this.mInZCalendar = false;
        ++this.mNumCals;
        this.mCurCal = null;
    }

    public boolean inZCalendar() {
        return this.mInZCalendar;
    }

    public int getNumCals() {
        return this.mNumCals;
    }

    public void startComponent(String name) {
        if (this.mComponents.isEmpty()) {
            this.mTZIDsSeen.clear();
        }
        this.mComponents.add(new ZCalendar.ZComponent(name));
    }

    public void endComponent(String name) throws ParserException {
        if (this.mComponents.isEmpty()) {
            throw new ParserException("Found END:" + name + " without BEGIN");
        }
        ZCalendar.ZComponent comp = this.mComponents.remove(this.mComponents.size() - 1);
        if (this.mComponents.size() == 0) {
            ZCalendar.ICalTok tok = comp.getTok();
            if (tok != null) {
                try {
                    switch (tok) {
                        case VEVENT: 
                        case VTODO: {
                            this.doComp(comp);
                            break;
                        }
                        case VTIMEZONE: {
                            ICalTimeZone tz = ICalTimeZone.fromVTimeZone(comp);
                            this.mTimeZoneMap.add(tz);
                        }
                    }
                }
                catch (ServiceException e) {
                    throw new ParserException("Error while parsing " + tok.toString(), (Throwable)e);
                }
            }
        } else {
            this.mComponents.get((int)(this.mComponents.size() - 1)).mComponents.add(comp);
        }
    }

    public void startProperty(String name) {
        this.mCurProperty = new ZCalendar.ZProperty(name);
        if (this.mComponents.size() > 0) {
            this.mComponents.get((int)(this.mComponents.size() - 1)).mProperties.add(this.mCurProperty);
        } else {
            this.mCurCal.mProperties.add(this.mCurProperty);
        }
    }

    public void propertyValue(String value) throws ParserException {
        this.mCurProperty.mValue = value;
        if (this.mComponents.size() == 0) {
            if (ZCalendar.ICalTok.METHOD.equals((Object)this.mCurProperty.getToken())) {
                this.mMethod = value;
            }
            if (ZCalendar.ICalTok.VERSION.equals((Object)this.mCurProperty.getToken())) {
                if ("1.0".equals(value)) {
                    throw new ParserException("vCalendar 1.0 format not supported; use iCalendar instead");
                }
                if (!"2.0".equals(value)) {
                    throw new ParserException("Unknow iCalendar version " + value);
                }
            }
        }
    }

    public void endProperty(String name) {
        this.mCurProperty = null;
    }

    public void parameter(String name, String value) {
        ZCalendar.ZParameter param = new ZCalendar.ZParameter(name, value);
        if (this.mCurProperty != null) {
            this.mCurProperty.mParameters.add(param);
            if (ZCalendar.ICalTok.TZID.equals((Object)param.getToken())) {
                this.mTZIDsSeen.add(value);
            }
        } else {
            ZimbraLog.calendar.debug("ERROR: got parameter " + name + "," + value + " outside of Property");
        }
    }

    private void doComp(ZCalendar.ZComponent comp) throws ServiceException {
        TimeZoneMap tzmap = null;
        for (String tzid : this.mTZIDsSeen) {
            ICalTimeZone tz = this.mTimeZoneMap.getTimeZone(tzid);
            if (tz != null) {
                if (tzmap == null) {
                    tzmap = new TimeZoneMap(tz);
                }
                tzmap.add(tz);
                continue;
            }
            System.out.println("Couldnt find: " + tzid + "; in tzidmap: " + this.mTimeZoneMap);
            System.out.println("Bad comp = " + comp);
            throw ServiceException.PARSE_ERROR("TZID reference encountered before/without its VTIMEZONE: " + tzid, null);
        }
        if (tzmap == null) {
            tzmap = new TimeZoneMap(this.mTimeZoneMap.getLocalTimeZone());
        }
        ArrayList<ZCalendar.ZComponent> comps = new ArrayList<ZCalendar.ZComponent>(1);
        comps.add(comp);
        Invite.createFromCalendar(this.mAccount, null, this.mMethod, tzmap, comps.iterator(), true, this.mContinueOnError, this.mInviteVisitor);
    }

    public static class ImportInviteVisitor
    implements Invite.InviteVisitor {
        private OperationContext mCtxt;
        private Folder mFolder;
        private boolean mPreserveExistingAlarms;
        private Set<String> mUidsSeen = new HashSet<String>();

        public ImportInviteVisitor(OperationContext ctxt, Folder folder, boolean preserveExistingAlarms) {
            this.mCtxt = ctxt;
            this.mFolder = folder;
            this.mPreserveExistingAlarms = preserveExistingAlarms;
        }

        public void visit(Invite inv) throws ServiceException {
            boolean addRevision;
            String uid = inv.getUid();
            if (uid == null) {
                uid = LdapUtil.generateUUID();
                inv.setUid(uid);
            }
            if (!this.mUidsSeen.contains(uid)) {
                addRevision = true;
                this.mUidsSeen.add(uid);
            } else {
                addRevision = false;
            }
            this.mFolder.getMailbox().addInvite(this.mCtxt, inv, this.mFolder.getId(), this.mPreserveExistingAlarms, addRevision);
            if (ZimbraLog.calendar.isDebugEnabled()) {
                if (inv.isEvent()) {
                    ZimbraLog.calendar.debug("Appointment imported: UID=" + inv.getUid());
                } else if (inv.isTodo()) {
                    ZimbraLog.calendar.debug("Task imported: UID=" + inv.getUid());
                }
            }
        }
    }
}

