/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZRecur;
import java.util.HashMap;

public class IcalXmlStrMap {
    public static IcalXmlStrMap sFreqMap = new IcalXmlStrMap("Freq");
    public static IcalXmlStrMap sClassMap = new IcalXmlStrMap("Class");
    public static IcalXmlStrMap sTranspMap = new IcalXmlStrMap("Transparency");
    public static IcalXmlStrMap sFreeBusyMap = new IcalXmlStrMap("FreeBusy");
    public static IcalXmlStrMap sOutlookFreeBusyMap = new IcalXmlStrMap("OutlookFreeBusy");
    public static IcalXmlStrMap sStatusMap = new IcalXmlStrMap("Status");
    public static IcalXmlStrMap sPartStatMap = new IcalXmlStrMap("PartStat");
    public static IcalXmlStrMap sRoleMap = new IcalXmlStrMap("Role");
    public static IcalXmlStrMap sCUTypeMap = new IcalXmlStrMap("CUType");
    private HashMap<String, String> fwdMap = new HashMap();
    private HashMap<String, String> bakMap = new HashMap();
    private String mMapName;
    public static final String FREQ_YEARLY = "YEA";
    public static final String FREQ_WEEKLY = "WEE";
    public static final String FREQ_SECONDLY = "SEC";
    public static final String FREQ_MONTHLY = "MON";
    public static final String FREQ_MINUTELY = "MIN";
    public static final String FREQ_HOURLY = "HOU";
    public static final String FREQ_DAILY = "DAI";
    public static final String CLASS_PUBLIC = "PUB";
    public static final String CLASS_PRIVATE = "PRI";
    public static final String CLASS_CONFIDENTIAL = "CON";
    public static final String FBTYPE_BUSY = "B";
    public static final String FBTYPE_FREE = "F";
    public static final String FBTYPE_BUSY_TENTATIVE = "T";
    public static final String FBTYPE_BUSY_UNAVAILABLE = "O";
    public static final String TRANSP_OPAQUE = "O";
    public static final String TRANSP_TRANSPARENT = "T";
    public static final String STATUS_TENTATIVE = "TENT";
    public static final String STATUS_CONFIRMED = "CONF";
    public static final String STATUS_CANCELLED = "CANC";
    public static final String STATUS_NEEDS_ACTION = "NEED";
    public static final String STATUS_COMPLETED = "COMP";
    public static final String STATUS_IN_PROCESS = "INPR";
    public static final String STATUS_ZCO_WAITING = "WAITING";
    public static final String STATUS_ZCO_DEFERRED = "DEFERRED";
    public static final String PARTSTAT_TENTATIVE = "TE";
    public static final String PARTSTAT_NEEDS_ACTION = "NE";
    public static final String PARTSTAT_DELEGATED = "DG";
    public static final String PARTSTAT_DECLINED = "DE";
    public static final String PARTSTAT_COMPLETED = "CO";
    public static final String PARTSTAT_ACCEPTED = "AC";
    public static final String PARTSTAT_IN_PROCESS = "IN";
    public static final String PARTSTAT_ZCO_WAITING = "WA";
    public static final String PARTSTAT_ZCO_DEFERRED = "DF";
    public static final String ROLE_NON_PARTICIPANT = "NON";
    public static final String ROLE_OPT_PARTICIPANT = "OPT";
    public static final String ROLE_REQUIRED = "REQ";
    public static final String ROLE_CHAIR = "CHA";
    public static final String CUTYPE_INDIVIDUAL = "IND";
    public static final String CUTYPE_GROUP = "GRO";
    public static final String CUTYPE_RESOURCE = "RES";
    public static final String CUTYPE_ROOM = "ROO";
    public static final String CUTYPE_UNKNOWN = "UNK";

    IcalXmlStrMap(String name) {
        this.mMapName = name;
    }

    public void add(String ical, String xml) {
        this.fwdMap.put(ical.toUpperCase(), xml);
        this.bakMap.put(xml.toUpperCase(), ical);
    }

    public String toXml(String name) {
        return this.fwdMap.get(name.toUpperCase());
    }

    public String toIcal(String name) throws ServiceException {
        String toRet = this.bakMap.get(name.toUpperCase());
        if (toRet == null) {
            throw MailServiceException.INVALID_REQUEST("Unknown string '" + name + "' for parameter " + this.mMapName, null);
        }
        return toRet;
    }

    public boolean validXml(String str) {
        return this.bakMap.containsKey(str.toUpperCase());
    }

    public boolean validICal(String str) {
        return this.fwdMap.containsKey(str.toUpperCase());
    }

    static {
        sCUTypeMap.add(ZCalendar.ICalTok.INDIVIDUAL.toString(), CUTYPE_INDIVIDUAL);
        sCUTypeMap.add(ZCalendar.ICalTok.GROUP.toString(), CUTYPE_GROUP);
        sCUTypeMap.add(ZCalendar.ICalTok.RESOURCE.toString(), CUTYPE_RESOURCE);
        sCUTypeMap.add(ZCalendar.ICalTok.ROOM.toString(), CUTYPE_ROOM);
        sCUTypeMap.add(ZCalendar.ICalTok.UNKNOWN.toString(), CUTYPE_UNKNOWN);
        sRoleMap.add(ZCalendar.ICalTok.CHAIR.toString(), ROLE_CHAIR);
        sRoleMap.add(ZCalendar.ICalTok.REQ_PARTICIPANT.toString(), ROLE_REQUIRED);
        sRoleMap.add(ZCalendar.ICalTok.OPT_PARTICIPANT.toString(), ROLE_OPT_PARTICIPANT);
        sRoleMap.add(ZCalendar.ICalTok.NON_PARTICIPANT.toString(), ROLE_NON_PARTICIPANT);
        sStatusMap.add(ZCalendar.ICalTok.TENTATIVE.toString(), STATUS_TENTATIVE);
        sStatusMap.add(ZCalendar.ICalTok.CONFIRMED.toString(), STATUS_CONFIRMED);
        sStatusMap.add(ZCalendar.ICalTok.CANCELLED.toString(), STATUS_CANCELLED);
        sStatusMap.add(ZCalendar.ICalTok.NEEDS_ACTION.toString(), STATUS_NEEDS_ACTION);
        sStatusMap.add(ZCalendar.ICalTok.COMPLETED.toString(), STATUS_COMPLETED);
        sStatusMap.add(ZCalendar.ICalTok.IN_PROCESS.toString(), STATUS_IN_PROCESS);
        sStatusMap.add(ZCalendar.ICalTok.X_ZIMBRA_STATUS_WAITING.toString(), STATUS_ZCO_WAITING);
        sStatusMap.add(ZCalendar.ICalTok.X_ZIMBRA_STATUS_DEFERRED.toString(), STATUS_ZCO_DEFERRED);
        sPartStatMap.add(ZCalendar.ICalTok.ACCEPTED.toString(), PARTSTAT_ACCEPTED);
        sPartStatMap.add(ZCalendar.ICalTok.COMPLETED.toString(), PARTSTAT_COMPLETED);
        sPartStatMap.add(ZCalendar.ICalTok.DECLINED.toString(), PARTSTAT_DECLINED);
        sPartStatMap.add(ZCalendar.ICalTok.DELEGATED.toString(), PARTSTAT_DELEGATED);
        sPartStatMap.add(ZCalendar.ICalTok.IN_PROCESS.toString(), PARTSTAT_IN_PROCESS);
        sPartStatMap.add(ZCalendar.ICalTok.NEEDS_ACTION.toString(), PARTSTAT_NEEDS_ACTION);
        sPartStatMap.add(ZCalendar.ICalTok.TENTATIVE.toString(), PARTSTAT_TENTATIVE);
        sPartStatMap.add(ZCalendar.ICalTok.X_ZIMBRA_PARTSTAT_WAITING.toString(), PARTSTAT_ZCO_WAITING);
        sPartStatMap.add(ZCalendar.ICalTok.X_ZIMBRA_PARTSTAT_DEFERRED.toString(), PARTSTAT_ZCO_DEFERRED);
        sClassMap.add(ZCalendar.ICalTok.PUBLIC.toString(), CLASS_PUBLIC);
        sClassMap.add(ZCalendar.ICalTok.PRIVATE.toString(), CLASS_PRIVATE);
        sClassMap.add(ZCalendar.ICalTok.CONFIDENTIAL.toString(), CLASS_CONFIDENTIAL);
        sFreeBusyMap.add("FREE", FBTYPE_FREE);
        sFreeBusyMap.add("BUSY", FBTYPE_BUSY);
        sFreeBusyMap.add("BUSY-TENTATIVE", "T");
        sFreeBusyMap.add("BUSY-UNAVAILABLE", "O");
        sOutlookFreeBusyMap.add("FREE", FBTYPE_FREE);
        sOutlookFreeBusyMap.add("BUSY", FBTYPE_BUSY);
        sOutlookFreeBusyMap.add("TENTATIVE", "T");
        sOutlookFreeBusyMap.add("OOF", "O");
        sTranspMap.add(ZCalendar.ICalTok.TRANSPARENT.toString(), "T");
        sTranspMap.add(ZCalendar.ICalTok.OPAQUE.toString(), "O");
        sFreqMap.add(ZRecur.Frequency.DAILY.toString(), FREQ_DAILY);
        sFreqMap.add(ZRecur.Frequency.HOURLY.toString(), FREQ_HOURLY);
        sFreqMap.add(ZRecur.Frequency.MINUTELY.toString(), FREQ_MINUTELY);
        sFreqMap.add(ZRecur.Frequency.MONTHLY.toString(), FREQ_MONTHLY);
        sFreqMap.add(ZRecur.Frequency.SECONDLY.toString(), FREQ_SECONDLY);
        sFreqMap.add(ZRecur.Frequency.WEEKLY.toString(), FREQ_WEEKLY);
        sFreqMap.add(ZRecur.Frequency.YEARLY.toString(), FREQ_YEARLY);
    }
}

