/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.WellKnownTimeZones;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.util.Calendar;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;

public class ICalTimeZone
extends SimpleTimeZone {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DTSTART = "19710101T000000";
    private int mStandardOffset = 0;
    private String mDayToStdDtStart = "19710101T000000";
    private String mDayToStdRule = null;
    private String mStandardTzname = null;
    private int mDaylightOffset = 0;
    private String mStdToDayDtStart = "19710101T000000";
    private String mStdToDayRule = null;
    private String mDaylightTzname = null;
    private SimpleOnset mStandardOnset;
    private SimpleOnset mDaylightOnset;
    static final String FN_TZID = "tzid";
    private static final String FN_STANDARD_OFFSET = "so";
    private static final String FN_DAYLIGHT_OFFSET = "do";
    private static final String FN_DAYTOSTD_DTSTART = "d2ss";
    private static final String FN_STDTODAY_DTSTART = "s2ds";
    private static final String FN_DAYTOSTD_RULE = "d2sr";
    private static final String FN_STDTODAY_RULE = "s2dr";
    private static final String FN_STANDARD_TZNAME = "sn";
    private static final String FN_DAYLIGHT_TZNAME = "dn";
    private static ICalTimeZone sUTC = new ICalTimeZone("Z", 0, "19710101T000000", null, "UTC", 0, "19710101T000000", null, "UTC");
    private static String[] sDayOfWeekNames = new String[8];
    private static Map<String, Integer> sDayOfWeekMap;
    private static final long MSEC_PER_HOUR = 3600000L;
    private static final long MSEC_PER_MIN = 60000L;
    private static final long MSEC_PER_SEC = 1000L;

    public ICalTimeZone cloneWithNewTZID(String tzid) {
        ICalTimeZone cloneTZ = new ICalTimeZone(tzid, this.mStandardOffset, this.mDayToStdDtStart, this.mDayToStdRule, this.mStandardTzname, this.mDaylightOffset, this.mStdToDayDtStart, this.mStdToDayRule, this.mDaylightTzname);
        return cloneTZ;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TZID=").append(this.getID());
        sb.append("\nSimpleTimeZone: ").append(super.toString());
        sb.append("\nmStandardOffset=").append(this.mStandardOffset);
        sb.append(", mDayToStdDtStart=").append(this.mDayToStdDtStart);
        sb.append(", mDayToStdRule=\"").append(this.mDayToStdRule).append("\"");
        sb.append("\nmStandardOnset=\"").append(this.mStandardOnset).append("\"");
        sb.append("\nmDaylightOffset=").append(this.mDaylightOffset);
        sb.append(", mStdToDayDtStart=").append(this.mStdToDayDtStart);
        sb.append(", mStdToDayRule=\"").append(this.mStdToDayRule).append("\"");
        sb.append("\nmDaylightOnset=\"").append(this.mDaylightOnset).append("\"");
        return sb.toString();
    }

    public static ICalTimeZone getAccountTimeZone(Account account) {
        String tzid = account.getAttr("zimbraPrefTimeZoneId");
        ICalTimeZone timeZone = WellKnownTimeZones.getTimeZoneById(tzid = TZIDMapper.canonicalize(tzid));
        if (timeZone == null) {
            return sUTC;
        }
        return timeZone;
    }

    public static ICalTimeZone getUTC() {
        return sUTC;
    }

    public Metadata encodeAsMetadata() {
        Metadata meta = new Metadata();
        String tzid = this.getID();
        meta.put(FN_TZID, tzid);
        if (ICalTimeZone.lookupByTZID(tzid) != null) {
            return meta;
        }
        meta.put(FN_STANDARD_OFFSET, this.mStandardOffset);
        meta.put(FN_DAYTOSTD_DTSTART, this.mDayToStdDtStart);
        meta.put(FN_DAYTOSTD_RULE, this.mDayToStdRule);
        meta.put(FN_STANDARD_TZNAME, this.mStandardTzname);
        meta.put(FN_DAYLIGHT_OFFSET, this.mDaylightOffset);
        meta.put(FN_STDTODAY_DTSTART, this.mStdToDayDtStart);
        meta.put(FN_STDTODAY_RULE, this.mStdToDayRule);
        meta.put(FN_DAYLIGHT_TZNAME, this.mDaylightTzname);
        return meta;
    }

    public String getStandardDtStart() {
        return this.mDayToStdDtStart;
    }

    public String getStandardRule() {
        return this.mDayToStdRule;
    }

    public String getStandardTzname() {
        return this.mStandardTzname;
    }

    public String getDaylightDtStart() {
        return this.mStdToDayDtStart;
    }

    public String getDaylightRule() {
        return this.mStdToDayRule;
    }

    public String getDaylightTzname() {
        return this.mDaylightTzname;
    }

    public boolean sameAsUTC() {
        return this.mStandardOffset == 0 && this.mDaylightOffset == 0;
    }

    public static ICalTimeZone decodeFromMetadata(Metadata m) throws ServiceException {
        ICalTimeZone tz;
        String tzid;
        if (m.containsKey(FN_TZID)) {
            tzid = m.get(FN_TZID);
            boolean hasDef = m.containsKey(FN_STANDARD_OFFSET);
            if (!DebugConfig.disableCalendarTZMatchByID || !hasDef) {
                tz = WellKnownTimeZones.getTimeZoneById(tzid);
                if (tz != null) {
                    return tz;
                }
                if (!hasDef) {
                    ZimbraLog.calendar.debug("Unknown time zone \"" + tzid + "\" in metadata; using UTC instead");
                    return sUTC.cloneWithNewTZID(tzid);
                }
            }
        } else {
            tzid = "unknown time zone";
        }
        ICalTimeZone newTz = new ICalTimeZone(tzid, m);
        tz = ICalTimeZone.lookupByRule(newTz, false);
        return tz;
    }

    private ICalTimeZone(String tzId, Metadata meta) throws ServiceException {
        super(0, tzId);
        this.mStandardOffset = (int)meta.getLong(FN_STANDARD_OFFSET, 0L);
        this.mDayToStdDtStart = meta.get(FN_DAYTOSTD_DTSTART, null);
        this.mDayToStdRule = meta.get(FN_DAYTOSTD_RULE, null);
        this.mStandardTzname = meta.get(FN_STANDARD_TZNAME, null);
        this.mDaylightOffset = (int)meta.getLong(FN_DAYLIGHT_OFFSET, this.mStandardOffset);
        this.mStdToDayDtStart = meta.get(FN_STDTODAY_DTSTART, this.mDayToStdDtStart);
        this.mStdToDayRule = meta.get(FN_STDTODAY_RULE, null);
        this.mDaylightTzname = meta.get(FN_DAYLIGHT_TZNAME, null);
        this.initFromICalData(true);
    }

    private void initFromICalData(boolean fromMetadata) {
        int dstSavings = this.mDaylightOffset - this.mStandardOffset;
        if (dstSavings < 0) {
            int tmp = this.mStandardOffset;
            this.mStandardOffset = this.mDaylightOffset;
            this.mDaylightOffset = tmp;
            dstSavings *= -1;
        }
        this.setRawOffset(this.mStandardOffset);
        if (dstSavings != 0) {
            this.mStandardOnset = ICalTimeZone.parseOnset(this.mDayToStdRule, this.mDayToStdDtStart, fromMetadata);
            this.mDaylightOnset = ICalTimeZone.parseOnset(this.mStdToDayRule, this.mStdToDayDtStart, fromMetadata);
            SimpleTimeZoneRule stzDaylight = new SimpleTimeZoneRule(this.mDaylightOnset);
            this.setStartRule(stzDaylight.mMonth, stzDaylight.mDayOfMonth, stzDaylight.mDayOfWeek, stzDaylight.mDtStartMillis);
            SimpleTimeZoneRule stzStandard = new SimpleTimeZoneRule(this.mStandardOnset);
            this.setEndRule(stzStandard.mMonth, stzStandard.mDayOfMonth, stzStandard.mDayOfWeek, stzStandard.mDtStartMillis);
            this.setDSTSavings(dstSavings);
        }
    }

    public static SimpleOnset parseOnset(String rrule, String dtstart, boolean fromMetadata) {
        int week = 0;
        int dayOfWeek = 0;
        int month = 0;
        int dayOfMonth = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (rrule != null) {
            StringTokenizer t = new StringTokenizer(rrule.toUpperCase(), ";=");
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if ("BYMONTH".equals(token)) {
                    try {
                        month = Integer.parseInt(t.nextToken());
                    }
                    catch (NumberFormatException ne) {}
                    continue;
                }
                if ("BYDAY".equals(token)) {
                    char num;
                    boolean negative = false;
                    int weekNum = 1;
                    String value = t.nextToken();
                    char sign = value.charAt(0);
                    if (sign == '-') {
                        negative = true;
                        value = value.substring(1);
                    }
                    if (sign == '+') {
                        value = value.substring(1);
                    }
                    if (Character.isDigit(num = value.charAt(0))) {
                        weekNum = num - 48;
                        value = value.substring(1);
                    }
                    week = negative ? -1 * weekNum : weekNum;
                    Integer day = sDayOfWeekMap.get(value);
                    if (day == null) {
                        throw new IllegalArgumentException("Invalid day of week value: " + value);
                    }
                    dayOfWeek = day;
                    continue;
                }
                if ("BYMONTHDAY".equals(token)) {
                    try {
                        dayOfMonth = Integer.parseInt(t.nextToken());
                    }
                    catch (NumberFormatException ne) {}
                    continue;
                }
                t.nextToken();
            }
        } else {
            week = 0;
            dayOfMonth = 1;
            month = 1;
            if (dtstart != null) {
                try {
                    month = Integer.parseInt(dtstart.substring(4, 6));
                    dayOfMonth = Integer.parseInt(dtstart.substring(6, 8));
                }
                catch (StringIndexOutOfBoundsException se) {
                }
                catch (NumberFormatException ne) {
                    // empty catch block
                }
            }
        }
        if (dtstart != null) {
            try {
                int indexOfT = dtstart.indexOf(84);
                hour = Integer.parseInt(dtstart.substring(indexOfT + 1, indexOfT + 3));
                minute = Integer.parseInt(dtstart.substring(indexOfT + 3, indexOfT + 5));
                second = Integer.parseInt(dtstart.substring(indexOfT + 5, indexOfT + 7));
            }
            catch (StringIndexOutOfBoundsException se) {
                second = 0;
                minute = 0;
                hour = 0;
            }
            catch (NumberFormatException ne) {
                second = 0;
                minute = 0;
                hour = 0;
            }
        }
        return new SimpleOnset(week, dayOfWeek, month, dayOfMonth, hour, minute, second, fromMetadata);
    }

    public int getStandardOffset() {
        return this.mStandardOffset;
    }

    public SimpleOnset getStandardOnset() {
        return this.mStandardOnset;
    }

    public int getDaylightOffset() {
        return this.mDaylightOffset;
    }

    public SimpleOnset getDaylightOnset() {
        return this.mDaylightOnset;
    }

    public static ICalTimeZone lookup(String tzid, int stdOffset, String stdDtStart, String stdRRule, String stdTzname, int dayOffset, String dayDtStart, String dayRRule, String dayTzname) {
        ICalTimeZone tz = ICalTimeZone.lookupByTZID(tzid);
        if (tz != null) {
            return tz;
        }
        ICalTimeZone newTz = new ICalTimeZone(tzid, stdOffset, stdDtStart, stdRRule, stdTzname, dayOffset, dayDtStart, dayRRule, dayTzname);
        tz = ICalTimeZone.lookupByRule(newTz, true);
        return tz;
    }

    ICalTimeZone(String tzId, int stdOffset, String stdDtStart, String stdRRule, String stdTzname, int dayOffset, String dayDtStart, String dayRRule, String dayTzname) {
        super(0, tzId);
        this.mStandardOffset = stdOffset;
        if (stdDtStart != null) {
            this.mDayToStdDtStart = stdDtStart;
        }
        this.mDayToStdRule = stdRRule;
        this.mStandardTzname = stdTzname;
        this.mDaylightOffset = dayOffset;
        this.mStdToDayDtStart = dayDtStart != null ? dayDtStart : this.mDayToStdDtStart;
        this.mStdToDayRule = dayRRule;
        this.mDaylightTzname = dayTzname;
        this.initFromICalData(false);
    }

    public static ICalTimeZone lookup(String tzid, int standardOffset, SimpleOnset standardOnset, String standardTzname, int daylightOffset, SimpleOnset daylightOnset, String daylightTzname) {
        ICalTimeZone tz = ICalTimeZone.lookupByTZID(tzid);
        if (tz != null) {
            return tz;
        }
        ICalTimeZone newTz = new ICalTimeZone(tzid, standardOffset, standardOnset, standardTzname, daylightOffset, daylightOnset, daylightTzname);
        tz = ICalTimeZone.lookupByRule(newTz, true);
        return tz;
    }

    private ICalTimeZone(String tzId, int standardOffset, SimpleOnset standardOnset, String standardTzname, int daylightOffset, SimpleOnset daylightOnset, String daylightTzname) {
        super(0, tzId);
        this.mStandardOffset = standardOffset;
        this.mDaylightOffset = daylightOffset;
        this.mStandardTzname = standardTzname;
        this.mDaylightTzname = daylightTzname;
        this.setRawOffset(this.mStandardOffset);
        if (this.mDaylightOffset != this.mStandardOffset && standardOnset != null && daylightOnset != null) {
            this.mDayToStdDtStart = ICalTimeZone.toICalDtStart(standardOnset);
            this.mDayToStdRule = ICalTimeZone.toICalRRule(standardOnset);
            this.mStdToDayDtStart = ICalTimeZone.toICalDtStart(daylightOnset);
            this.mStdToDayRule = ICalTimeZone.toICalRRule(daylightOnset);
            this.mStandardOnset = standardOnset;
            this.mDaylightOnset = daylightOnset;
            SimpleTimeZoneRule stzDaylight = new SimpleTimeZoneRule(daylightOnset);
            this.setStartRule(stzDaylight.mMonth, stzDaylight.mDayOfMonth, stzDaylight.mDayOfWeek, stzDaylight.mDtStartMillis);
            SimpleTimeZoneRule stzStandard = new SimpleTimeZoneRule(standardOnset);
            this.setEndRule(stzStandard.mMonth, stzStandard.mDayOfMonth, stzStandard.mDayOfWeek, stzStandard.mDtStartMillis);
            this.setDSTSavings(this.mDaylightOffset - this.mStandardOffset);
        }
    }

    private static String toICalDtStart(SimpleOnset onset) {
        String hourStr = Integer.toString(onset.getHour() + 100).substring(1);
        String minuteStr = Integer.toString(onset.getMinute() + 100).substring(1);
        String secondStr = Integer.toString(onset.getSecond() + 100).substring(1);
        StringBuilder sb = new StringBuilder("19710101T");
        sb.append(hourStr).append(minuteStr).append(secondStr);
        return sb.toString();
    }

    private static String toICalRRule(SimpleOnset onset) {
        int week = onset.getWeek();
        int mday = onset.getDayOfMonth();
        StringBuilder sb = new StringBuilder("FREQ=YEARLY;INTERVAL=1;BYMONTH=");
        sb.append(onset.getMonth());
        if (week != 0) {
            sb.append(";BYDAY=");
            sb.append(week).append(sDayOfWeekNames[onset.getDayOfWeek()]);
            sb.append(";WKST=MO");
        } else if (mday > 0) {
            sb.append(";BYMONTHDAY=").append(mday);
        } else {
            return null;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        boolean pass = SelfTest.doit();
        if (!pass) {
            System.exit(1);
        }
    }

    private static int tzOffsetTime(String utcOffset) throws ServiceException {
        try {
            int offset;
            int sign;
            int len;
            int n = len = utcOffset != null ? utcOffset.length() : 0;
            if (len < 1) {
                throw ServiceException.INVALID_REQUEST("Invalid " + (Object)((Object)ZCalendar.ICalTok.TZOFFSETFROM) + "/" + (Object)((Object)ZCalendar.ICalTok.TZOFFSETTO) + " value \"" + utcOffset + "\"; must have format \"+/-hhmm[ss]\"", null);
            }
            char signChar = utcOffset.charAt(0);
            if (signChar == '-') {
                sign = -1;
                offset = 1;
            } else {
                sign = 1;
                offset = signChar == '+' ? 1 : 0;
            }
            int toRet = 0;
            try {
                if ((len - offset) % 2 == 0) {
                    toRet = (int)((long)toRet + (long)Integer.parseInt(utcOffset.substring(offset, offset + 2)) * 3600000L);
                    offset += 2;
                } else {
                    toRet = (int)((long)toRet + (long)Integer.parseInt(utcOffset.substring(offset, offset + 1)) * 3600000L);
                    ++offset;
                }
                toRet = (int)((long)toRet + (long)Integer.parseInt(utcOffset.substring(offset, offset + 2)) * 60000L);
                if (len - (offset += 2) >= 2) {
                    toRet = (int)((long)toRet + (long)Integer.parseInt(utcOffset.substring(offset, offset + 2)) * 1000L);
                }
            }
            catch (NumberFormatException e) {
                throw ServiceException.INVALID_REQUEST("Invalid " + (Object)((Object)ZCalendar.ICalTok.TZOFFSETFROM) + "/" + (Object)((Object)ZCalendar.ICalTok.TZOFFSETTO) + " value \"" + utcOffset + "\"; must have format \"+/-hhmm[ss]\"", e);
            }
            return toRet *= sign;
        }
        catch (NumberFormatException e) {
            throw ServiceException.INVALID_REQUEST("Invalid " + (Object)((Object)ZCalendar.ICalTok.TZOFFSETFROM) + "/" + (Object)((Object)ZCalendar.ICalTok.TZOFFSETTO) + " value \"" + utcOffset + "\"; must have format \"+/-hhmm[ss]\"", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw ServiceException.INVALID_REQUEST("Invalid " + (Object)((Object)ZCalendar.ICalTok.TZOFFSETFROM) + "/" + (Object)((Object)ZCalendar.ICalTok.TZOFFSETTO) + " value \"" + utcOffset + "\"; must have format \"+/-hhmm[ss]\"", e);
        }
    }

    static String timeToTzOffsetString(int time) {
        StringBuilder toRet = new StringBuilder(time > 0 ? "+" : "-");
        time = Math.abs(time / 1000);
        int secs = time % 60;
        int mins = (time /= 60) % 60;
        int hours = time / 60;
        if (secs > 0) {
            toRet.append(new Formatter().format("%02d%02d%02d", hours, mins, secs));
        } else {
            toRet.append(new Formatter().format("%02d%02d", hours, mins));
        }
        return toRet.toString();
    }

    public ZCalendar.ZComponent newToVTimeZone() {
        ZCalendar.ZComponent vtz = new ZCalendar.ZComponent(ZCalendar.ICalTok.VTIMEZONE);
        vtz.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TZID, this.getID()));
        if (this.mDayToStdDtStart != null) {
            ZCalendar.ZComponent standard = new ZCalendar.ZComponent(ZCalendar.ICalTok.STANDARD);
            vtz.addComponent(standard);
            standard.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.DTSTART, this.mDayToStdDtStart));
            standard.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TZOFFSETTO, ICalTimeZone.timeToTzOffsetString(this.mStandardOffset)));
            standard.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TZOFFSETFROM, ICalTimeZone.timeToTzOffsetString(this.mDaylightOffset)));
            if (this.mDayToStdRule != null) {
                standard.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.RRULE, this.mDayToStdRule));
            }
            if (this.mStandardTzname != null) {
                standard.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TZNAME, this.mStandardTzname));
            }
        }
        if (this.mStdToDayDtStart != null && (this.mStandardOffset != this.mDaylightOffset || this.mDayToStdDtStart == null)) {
            ZCalendar.ZComponent daylight = new ZCalendar.ZComponent(ZCalendar.ICalTok.DAYLIGHT);
            vtz.addComponent(daylight);
            daylight.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.DTSTART, this.mStdToDayDtStart));
            daylight.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TZOFFSETTO, ICalTimeZone.timeToTzOffsetString(this.mDaylightOffset)));
            daylight.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TZOFFSETFROM, ICalTimeZone.timeToTzOffsetString(this.mStandardOffset)));
            if (this.mStdToDayRule != null) {
                daylight.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.RRULE, this.mStdToDayRule));
            }
            if (this.mDaylightTzname != null) {
                daylight.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.TZNAME, this.mDaylightTzname));
            }
        }
        return vtz;
    }

    private static ZCalendar.ZComponent moreRecentTzComp(ZCalendar.ZComponent tzComp1, ZCalendar.ZComponent tzComp2) {
        String dtStart1 = tzComp1.getPropVal(ZCalendar.ICalTok.DTSTART, null);
        String dtStart2 = tzComp2.getPropVal(ZCalendar.ICalTok.DTSTART, null);
        if (dtStart1 == null) {
            return tzComp2;
        }
        if (dtStart2 == null) {
            return tzComp1;
        }
        if (dtStart2.compareToIgnoreCase(dtStart1) >= 0) {
            return tzComp2;
        }
        return tzComp1;
    }

    public static ICalTimeZone fromVTimeZone(ZCalendar.ZComponent comp) throws ServiceException {
        return ICalTimeZone.fromVTimeZone(comp, false);
    }

    static ICalTimeZone fromVTimeZone(ZCalendar.ZComponent comp, boolean skipLookup) throws ServiceException {
        ICalTimeZone tz;
        String tzid = comp.getPropVal(ZCalendar.ICalTok.TZID, null);
        if (!skipLookup && (tz = ICalTimeZone.lookupByTZID(tzid)) != null) {
            return tz;
        }
        ZCalendar.ZComponent standard = null;
        ZCalendar.ZComponent daylight = null;
        Iterator<ZCalendar.ZComponent> iter = comp.getComponentIterator();
        while (iter.hasNext()) {
            ZCalendar.ZComponent tzComp = iter.next();
            if (tzComp == null) continue;
            ZCalendar.ICalTok tok = tzComp.getTok();
            if (ZCalendar.ICalTok.STANDARD.equals((Object)tok)) {
                if (standard == null) {
                    standard = tzComp;
                    continue;
                }
                standard = ICalTimeZone.moreRecentTzComp(standard, tzComp);
                continue;
            }
            if (!ZCalendar.ICalTok.DAYLIGHT.equals((Object)tok)) continue;
            if (daylight == null) {
                daylight = tzComp;
                continue;
            }
            daylight = ICalTimeZone.moreRecentTzComp(daylight, tzComp);
        }
        if (standard != null && daylight != null) {
            String stdRule = standard.getPropVal(ZCalendar.ICalTok.RRULE, null);
            String dayRule = daylight.getPropVal(ZCalendar.ICalTok.RRULE, null);
            if (stdRule == null || dayRule == null) {
                String stdStart = standard.getPropVal(ZCalendar.ICalTok.DTSTART, null);
                String dayStart = daylight.getPropVal(ZCalendar.ICalTok.DTSTART, null);
                if (stdStart != null && dayStart != null) {
                    try {
                        String stdStartMMDD = stdStart.substring(4, 8);
                        String dayStartMMDD = dayStart.substring(4, 8);
                        if (stdStartMMDD.equals(dayStartMMDD)) {
                            standard = ICalTimeZone.moreRecentTzComp(standard, daylight);
                            daylight = null;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        standard = ICalTimeZone.moreRecentTzComp(standard, daylight);
                        daylight = null;
                    }
                }
            }
        }
        if (standard == null) {
            standard = daylight;
            daylight = null;
        }
        if (standard == null) {
            throw new IllegalArgumentException("VTIMEZONE has neither STANDARD nor DAYLIGHT: TZID=" + tzid);
        }
        String stddtStart = null;
        int stdoffsetTime = 0;
        String stdrrule = null;
        String stdTzname = null;
        if (standard != null) {
            ZCalendar.ZComponent moreRecent;
            int tzoffsetFromTime;
            stddtStart = standard.getPropVal(ZCalendar.ICalTok.DTSTART, null);
            String stdtzOffsetTo = standard.getPropVal(ZCalendar.ICalTok.TZOFFSETTO, null);
            stdoffsetTime = ICalTimeZone.tzOffsetTime(stdtzOffsetTo);
            stdTzname = standard.getPropVal(ZCalendar.ICalTok.TZNAME, null);
            String stdtzOffsetFrom = standard.getPropVal(ZCalendar.ICalTok.TZOFFSETFROM, null);
            if (stdtzOffsetFrom != null && (tzoffsetFromTime = ICalTimeZone.tzOffsetTime(stdtzOffsetFrom)) == stdoffsetTime && daylight != null && (moreRecent = ICalTimeZone.moreRecentTzComp(standard, daylight)) == standard) {
                daylight = null;
            }
            if (daylight != null) {
                stdrrule = standard.getPropVal(ZCalendar.ICalTok.RRULE, null);
            }
        }
        String daydtStart = null;
        int dayoffsetTime = stdoffsetTime;
        String dayrrule = null;
        String dayTzname = null;
        if (daylight != null) {
            ZCalendar.ZComponent moreRecent;
            int tzoffsetFromTime;
            daydtStart = daylight.getPropVal(ZCalendar.ICalTok.DTSTART, null);
            String daytzOffsetTo = daylight.getPropVal(ZCalendar.ICalTok.TZOFFSETTO, null);
            dayoffsetTime = ICalTimeZone.tzOffsetTime(daytzOffsetTo);
            dayrrule = daylight.getPropVal(ZCalendar.ICalTok.RRULE, null);
            dayTzname = daylight.getPropVal(ZCalendar.ICalTok.TZNAME, null);
            String daytzOffsetFrom = daylight.getPropVal(ZCalendar.ICalTok.TZOFFSETFROM, null);
            if (daytzOffsetFrom != null && (tzoffsetFromTime = ICalTimeZone.tzOffsetTime(daytzOffsetFrom)) == dayoffsetTime && standard != null && (moreRecent = ICalTimeZone.moreRecentTzComp(standard, daylight)) == daylight) {
                standard = daylight;
                stdoffsetTime = dayoffsetTime;
                stddtStart = daydtStart;
                stdrrule = dayrrule;
                stdTzname = dayTzname;
                daylight = null;
                daydtStart = null;
                dayrrule = null;
                dayTzname = null;
            }
        }
        ICalTimeZone newTz = new ICalTimeZone(tzid, stdoffsetTime, stddtStart, stdrrule, stdTzname, dayoffsetTime, daydtStart, dayrrule, dayTzname);
        if (!skipLookup) {
            newTz = ICalTimeZone.lookupByRule(newTz, true);
        }
        return newTz;
    }

    private static ICalTimeZone lookupByTZID(String tzid) {
        ICalTimeZone match;
        if (!DebugConfig.disableCalendarTZMatchByID && (match = WellKnownTimeZones.getTimeZoneById(tzid)) != null) {
            if (match.getID().equals(tzid)) {
                return match;
            }
            return match.cloneWithNewTZID(tzid);
        }
        return null;
    }

    private static ICalTimeZone lookupByRule(ICalTimeZone tz, boolean keepTZID) {
        ICalTimeZone match;
        if (!DebugConfig.disableCalendarTZMatchByRule && (match = WellKnownTimeZones.getBestMatch(tz)) != null) {
            if (keepTZID) {
                String tzid = tz.getID();
                if (match.getID().equals(tzid)) {
                    return match;
                }
                return match.cloneWithNewTZID(tzid);
            }
            return match;
        }
        return tz;
    }

    public static ICalTimeZone lookupMatchingWellKnownTZ(ICalTimeZone tz) {
        ICalTimeZone match;
        if (!DebugConfig.disableCalendarTZMatchByID && (match = WellKnownTimeZones.getTimeZoneById(tz.getID())) != null) {
            return match;
        }
        if (!DebugConfig.disableCalendarTZMatchByRule && (match = WellKnownTimeZones.getBestMatch(tz)) != null) {
            return match;
        }
        return tz;
    }

    static {
        ICalTimeZone.sDayOfWeekNames[0] = "XX";
        ICalTimeZone.sDayOfWeekNames[1] = "SU";
        ICalTimeZone.sDayOfWeekNames[2] = "MO";
        ICalTimeZone.sDayOfWeekNames[3] = "TU";
        ICalTimeZone.sDayOfWeekNames[4] = "WE";
        ICalTimeZone.sDayOfWeekNames[5] = "TH";
        ICalTimeZone.sDayOfWeekNames[6] = "FR";
        ICalTimeZone.sDayOfWeekNames[7] = "SA";
        sDayOfWeekMap = new HashMap<String, Integer>(7);
        sDayOfWeekMap.put("SU", new Integer(1));
        sDayOfWeekMap.put("MO", new Integer(2));
        sDayOfWeekMap.put("TU", new Integer(3));
        sDayOfWeekMap.put("WE", new Integer(4));
        sDayOfWeekMap.put("TH", new Integer(5));
        sDayOfWeekMap.put("FR", new Integer(6));
        sDayOfWeekMap.put("SA", new Integer(7));
    }

    private static class SelfTest {
        private static final int INCBY_MONTH = 0;
        private static final int INCBY_DAY = 1;
        private static final int INCBY_HOUR = 2;
        private static final int INCBY_MINUTE = 3;

        private SelfTest() {
        }

        public static boolean doit() throws Exception {
            int badCount = 0;
            ICalTimeZone mytz = new ICalTimeZone("Custom TZ", -28800000, "19710101T020000", "FREQ=YEARLY;WKST=MO;INTERVAL=1;BYMONTH=10;BYDAY=-3FR", "FOO", -25200000, "19710101T020000", "FREQ=YEARLY;WKST=MO;INTERVAL=1;BYMONTH=4;BYDAY=2TU", "BAR");
            if (!SelfTest.verifyTZRules(mytz, 2005)) {
                ++badCount;
            }
            System.out.println();
            return badCount == 0;
        }

        private static String offsetToHHMM(int offsetMillis) {
            String sign = (offsetMillis /= 60000) < 0 ? "-" : "+";
            offsetMillis = Math.abs(offsetMillis);
            int offsetHours = offsetMillis / 60;
            String offsetHoursStr = Integer.toString(offsetHours);
            if (offsetHours < 10) {
                offsetHoursStr = "0" + offsetHoursStr;
            }
            int offsetMins = offsetMillis % 60;
            String offsetMinsStr = Integer.toString(offsetMins);
            if (offsetMins < 10) {
                offsetMinsStr = "0" + offsetMinsStr;
            }
            return sign + offsetHoursStr + ":" + offsetMinsStr;
        }

        private static String toTimestamp(Calendar cal) {
            Calendar oneHourAgo = (Calendar)cal.clone();
            oneHourAgo.add(11, -1);
            int hour = oneHourAgo.get(11);
            if (++hour == 24) {
                hour = 0;
            }
            Calendar yesterday = (Calendar)cal.clone();
            yesterday.add(6, -1);
            Calendar tomorrow = (Calendar)cal.clone();
            tomorrow.add(6, 1);
            long beforeOffset = yesterday.getTimeZone().getOffset(yesterday.getTimeInMillis());
            long afterOffset = tomorrow.getTimeZone().getOffset(tomorrow.getTimeInMillis());
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            int minute = cal.get(12);
            int second = cal.get(13);
            String monthStr = Integer.toString(++month);
            if (month < 10) {
                monthStr = "0" + monthStr;
            }
            String dayStr = Integer.toString(day);
            if (day < 10) {
                dayStr = "0" + dayStr;
            }
            String hourStr = Integer.toString(hour);
            if (hour < 10) {
                hourStr = "0" + hourStr;
            }
            String minuteStr = Integer.toString(minute);
            if (minute < 10) {
                minuteStr = "0" + minuteStr;
            }
            String secondStr = Integer.toString(second);
            if (second < 10) {
                secondStr = "0" + secondStr;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(year).append("/");
            sb.append(monthStr).append("/");
            sb.append(dayStr).append(" T");
            sb.append(hourStr).append(minuteStr).append(secondStr);
            if (beforeOffset < afterOffset) {
                sb.append(" - to daylight");
            } else if (beforeOffset > afterOffset) {
                sb.append(" - to standard");
            }
            return sb.toString();
        }

        public static boolean verifyTZRules(ICalTimeZone tz, int year) {
            boolean hasDaylight;
            boolean goodOrBad = true;
            System.out.println("Verifying DST rules for time zone " + tz.getID());
            String tzStr = tz.toString();
            String defStandardTime = null;
            String defDaylightTime = null;
            String actualStandardTime = null;
            String actualDaylightTime = null;
            Calendar[] onsets = SelfTest.findOnsetDates(tz, year);
            for (int i = 0; i < onsets.length; ++i) {
                System.out.print("  Onset " + (i + 1) + ": ");
                if (onsets[i] == null) {
                    System.out.println("null");
                    continue;
                }
                String tstamp = SelfTest.toTimestamp(onsets[i]);
                System.out.println(tstamp);
                if (tstamp.indexOf("to standard") != -1) {
                    actualStandardTime = SelfTest.parseHHMMSS(tstamp);
                    continue;
                }
                actualDaylightTime = SelfTest.parseHHMMSS(tstamp);
            }
            boolean bl = hasDaylight = tz.mStandardOffset != tz.mDaylightOffset;
            if (!tz.useDaylightTime()) {
                if (onsets[0] != null || onsets[1] != null) {
                    System.out.println("ERROR: Onset dates present in a non-DST TZ.");
                    goodOrBad = false;
                }
                System.out.println("  DST supported:   " + hasDaylight);
                System.out.println("  toString:\n" + tz.toString());
            } else {
                if (onsets[0] == null || onsets[1] == null) {
                    System.out.println("ERROR: Not enough onset dates present in a DST TZ.");
                    goodOrBad = false;
                }
                System.out.println("  DST supported:   " + hasDaylight);
                System.out.println("  Daylight Offset: " + SelfTest.offsetToHHMM(tz.mDaylightOffset));
                System.out.println("  Daylight Start:  " + tz.mStdToDayDtStart);
                System.out.println("  Daylight RRule:  " + tz.mStdToDayRule);
                System.out.println("  Standard Offset: " + SelfTest.offsetToHHMM(tz.mStandardOffset));
                System.out.println("  Standard Start:  " + tz.mDayToStdDtStart);
                System.out.println("  Standard RRule:  " + tz.mDayToStdRule);
                System.out.println("  toString:\n" + tz.toString());
                defStandardTime = SelfTest.parseHHMMSS(tz.mDayToStdDtStart);
                defDaylightTime = SelfTest.parseHHMMSS(tz.mStdToDayDtStart);
                if (!defStandardTime.equals(actualStandardTime) || !defDaylightTime.equals(actualDaylightTime)) {
                    System.out.println("ERROR: Onset times don't match between definition and actual.");
                    System.out.println("defStandardTime    = " + defStandardTime);
                    System.out.println("actualStandardTime = " + actualStandardTime);
                    System.out.println("defDaylightTime    = " + defDaylightTime);
                    System.out.println("actualDaylightTime = " + actualDaylightTime);
                    goodOrBad = false;
                }
            }
            ICalTimeZone onsetClone = SelfTest.cloneFromSimpleOnset(tz);
            String onsetCloneStr = onsetClone.toString();
            if (!onsetClone.hasSameRules(tz)) {
                System.out.println("ERROR: Onset-clone doesn't have the same rules as original.");
                System.out.println("Onset-clone:\n" + onsetCloneStr);
                goodOrBad = false;
            }
            ICalTimeZone icalClone = SelfTest.cloneFromICalData(onsetClone);
            String icalCloneStr = icalClone.toString();
            if (!icalClone.hasSameRules(onsetClone)) {
                System.out.println("ERROR: iCal-clone doesn't have the same rules as Onset-clone.");
                System.out.println("iCal-clone:\n" + icalCloneStr);
                goodOrBad = false;
            }
            if (!tzStr.equals(onsetCloneStr)) {
                System.out.println("ERROR: Onset-clone's toString is different than original.");
                goodOrBad = false;
            }
            if (!tzStr.equals(icalCloneStr)) {
                System.out.println("ERROR: iCal-clone's toString is different than original.");
                goodOrBad = false;
            }
            return goodOrBad;
        }

        private static ICalTimeZone cloneFromSimpleOnset(ICalTimeZone tz) {
            ICalTimeZone newtz = new ICalTimeZone(tz.getID(), tz.getStandardOffset(), tz.getStandardOnset(), tz.getStandardTzname(), tz.getDaylightOffset(), tz.getDaylightOnset(), tz.getDaylightTzname());
            return newtz;
        }

        private static ICalTimeZone cloneFromICalData(ICalTimeZone tz) {
            ICalTimeZone newtz = new ICalTimeZone(tz.getID(), tz.getStandardOffset(), tz.mDayToStdDtStart, tz.mDayToStdRule, tz.mStandardTzname, tz.getDaylightOffset(), tz.mStdToDayDtStart, tz.mStdToDayRule, tz.mDaylightTzname);
            return newtz;
        }

        private static String parseHHMMSS(String text) {
            int indexT = text.indexOf(84);
            if (indexT == -1) {
                return null;
            }
            String time = text.substring(indexT);
            if (time.length() < 7) {
                return null;
            }
            return time.substring(0, 7);
        }

        public static Calendar[] findOnsetDates(ICalTimeZone tz, int year) {
            Calendar[] onsets = new Calendar[2];
            GregorianCalendar cal = new GregorianCalendar(tz);
            cal.clear();
            cal.set(year, 0, 1, 12, 0, 0);
            cal.set(14, 0);
            onsets[0] = SelfTest.findOnsetDate(tz, cal, tz.getOffset(cal.getTimeInMillis()));
            if (onsets[0] != null) {
                Calendar firstDate = (Calendar)onsets[0].clone();
                firstDate.set(11, 12);
                firstDate.set(12, 0);
                firstDate.set(13, 0);
                firstDate.set(14, 0);
                firstDate.add(6, 1);
                onsets[1] = SelfTest.findOnsetDate(tz, firstDate, tz.getOffset(firstDate.getTimeInMillis()));
            }
            return onsets;
        }

        private static Calendar findOnsetDate(ICalTimeZone tz, Calendar startDate, long beforeOffset) {
            int startYear = startDate.get(1);
            Calendar onsetDate = (Calendar)startDate.clone();
            boolean incBy = false;
            while (true) {
                int year;
                if ((year = onsetDate.get(1)) > startYear) {
                    return null;
                }
                long offset = tz.getOffset(onsetDate.getTimeInMillis());
                if (offset != beforeOffset) {
                    if (incBy) break;
                    onsetDate.add(2, -1);
                    incBy = true;
                }
                if (!incBy) {
                    onsetDate.add(2, 1);
                    continue;
                }
                onsetDate.add(6, 1);
            }
            onsetDate = SelfTest.findOnsetTime(tz, onsetDate, beforeOffset);
            return onsetDate;
        }

        private static Calendar findOnsetTime(ICalTimeZone tz, Calendar onsetDate, long beforeOffset) {
            Calendar lowerBound = (Calendar)onsetDate.clone();
            lowerBound.set(11, 0);
            lowerBound.set(12, 0);
            lowerBound.set(13, 0);
            lowerBound.set(14, 0);
            long lowerBoundMillis = lowerBound.getTimeInMillis();
            long upperBoundMillis = onsetDate.getTimeInMillis();
            Calendar onsetTime = (Calendar)lowerBound.clone();
            int incBy = 2;
            while (true) {
                long millis;
                if ((millis = onsetTime.getTimeInMillis()) >= upperBoundMillis) {
                    return null;
                }
                int offset = tz.getOffset(millis);
                if ((long)offset != beforeOffset) {
                    if (millis == lowerBoundMillis || incBy != 2) break;
                    onsetTime.add(11, -1);
                    incBy = 3;
                }
                if (incBy == 2) {
                    onsetTime.add(11, 1);
                    continue;
                }
                onsetTime.add(12, 1);
            }
            return onsetTime;
        }
    }

    private static class SimpleTimeZoneRule {
        public int mMonth;
        public int mDayOfMonth;
        public int mDayOfWeek;
        public int mDtStartMillis;

        public SimpleTimeZoneRule(SimpleOnset onset) {
            this.mMonth = onset.getMonth() - 1;
            int week = onset.getWeek();
            if (week != 0) {
                if (week < 0) {
                    this.mDayOfMonth = week;
                    this.mDayOfWeek = onset.getDayOfWeek();
                } else {
                    this.mDayOfMonth = (week - 1) * 7 + 1;
                    this.mDayOfWeek = -1 * onset.getDayOfWeek();
                }
            } else {
                this.mDayOfMonth = onset.getDayOfMonth();
                this.mDayOfWeek = 0;
            }
            this.mDtStartMillis = onset.getHour() * 3600000 + onset.getMinute() * 60000 + onset.getSecond() * 1000;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleOnset
    implements Comparable<SimpleOnset> {
        private int mWeek = 0;
        private int mDayOfWeek = 0;
        private int mMonth = 0;
        private int mDayOfMonth = 0;
        private int mHour = 0;
        private int mMinute = 0;
        private int mSecond = 0;

        public int getWeek() {
            return this.mWeek;
        }

        public int getDayOfWeek() {
            return this.mDayOfWeek;
        }

        public int getMonth() {
            return this.mMonth;
        }

        public int getDayOfMonth() {
            return this.mDayOfMonth;
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public int getSecond() {
            return this.mSecond;
        }

        public SimpleOnset(int week, int dayOfWeek, int month, int dayOfMonth, int hour, int minute, int second) {
            this(week, dayOfWeek, month, dayOfMonth, hour, minute, second, false);
        }

        public SimpleOnset(int week, int dayOfWeek, int month, int dayOfMonth, int hour, int minute, int second, boolean skipBYMONTHDAYFixup) {
            this.mWeek = week;
            this.mDayOfWeek = dayOfWeek;
            this.mMonth = month;
            this.mDayOfMonth = dayOfMonth;
            this.mHour = hour;
            this.mMinute = minute;
            this.mSecond = second;
            if (!skipBYMONTHDAYFixup) {
                this.applyBYMONTHDAYFixup();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("week=").append(this.mWeek);
            sb.append(", dayOfWeek=").append(this.mDayOfWeek);
            sb.append(", month=").append(this.mMonth);
            sb.append(", dayOfMonth=").append(this.mDayOfMonth);
            sb.append(", hour=").append(this.mHour);
            sb.append(", minute=").append(this.mMinute);
            sb.append(", second=").append(this.mSecond);
            return sb.toString();
        }

        private void applyBYMONTHDAYFixup() {
            if (this.mWeek != 0 && this.mDayOfWeek != 0) {
                return;
            }
            if (this.mDayOfMonth != 0) {
                GregorianCalendar cal = new GregorianCalendar();
                int currentYear = cal.get(1);
                int month = this.mMonth - 1;
                cal.clear();
                cal.set(currentYear, month, this.mDayOfMonth);
                int dayOfWeek = cal.get(7);
                int week = (this.mDayOfMonth - 1) / 7 + 1;
                ((Calendar)cal).add(5, 7);
                if (cal.get(2) > month) {
                    week = -1;
                }
                this.mWeek = week;
                this.mDayOfWeek = dayOfWeek;
                this.mDayOfMonth = 0;
            }
        }

        @Override
        public int compareTo(SimpleOnset other) {
            int comp = this.mMonth - other.mMonth;
            if (comp != 0) {
                return comp;
            }
            comp = this.mWeek - other.mWeek;
            if (comp != 0) {
                return comp;
            }
            comp = this.mWeek != 0 ? this.mDayOfWeek - other.mDayOfWeek : this.mDayOfMonth - other.mDayOfMonth;
            if (comp != 0) {
                return comp;
            }
            comp = this.mHour - other.mHour;
            if (comp != 0) {
                return comp;
            }
            comp = this.mMinute - other.mMinute;
            if (comp != 0) {
                return comp;
            }
            comp = this.mSecond - other.mSecond;
            return comp;
        }
    }
}

