/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ZCalendar;

public class Geo {
    private String mLatitude;
    private String mLongitude;
    private static final String FN_LATITUDE = "lat";
    private static final String FN_LONGITUDE = "lon";

    public String getLatitude() {
        return this.mLatitude;
    }

    public String getLongitude() {
        return this.mLongitude;
    }

    public Geo(String lat, String lon) {
        this.mLatitude = lat;
        this.mLongitude = lon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Geo)) {
            return false;
        }
        Geo other = (Geo)o;
        return this.mLatitude != null && this.mLatitude.equals(other.mLatitude) && this.mLongitude != null && this.mLongitude.equals(other.mLongitude);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mLatitude).append(";").append(this.mLongitude);
        return sb.toString();
    }

    public Element toXml(Element parent) {
        Element geo = parent.addElement("geo");
        geo.addAttribute(FN_LATITUDE, this.mLatitude);
        geo.addAttribute(FN_LONGITUDE, this.mLongitude);
        return geo;
    }

    public static Geo parse(Element geoElem) throws ServiceException {
        String latitude = geoElem.getAttribute(FN_LATITUDE, "0");
        String longitude = geoElem.getAttribute(FN_LONGITUDE, "0");
        return new Geo(latitude, longitude);
    }

    public ZCalendar.ZProperty toZProperty() throws ServiceException {
        ZCalendar.ZProperty prop = new ZCalendar.ZProperty(ZCalendar.ICalTok.GEO);
        prop.setValue(this.mLatitude + ";" + this.mLongitude);
        return prop;
    }

    public static Geo parse(ZCalendar.ZProperty prop) {
        String val = prop.getValue();
        String[] latlon = val.split(";");
        if (latlon != null && latlon.length == 2) {
            return new Geo(latlon[0], latlon[1]);
        }
        return new Geo("0", "0");
    }

    public Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_LATITUDE, this.mLatitude);
        meta.put(FN_LONGITUDE, this.mLongitude);
        return meta;
    }

    public static Geo decodeMetadata(Metadata meta) throws ServiceException {
        String lat = meta.get(FN_LATITUDE, "0");
        String lon = meta.get(FN_LONGITUDE, "0");
        return new Geo(lat, lon);
    }
}

