/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.util.SoapCLI;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class FixCalendarEndTimeUtil
extends SoapCLI {
    protected static final String O_ACCOUNT = "a";
    protected static final String O_SYNC = "sync";

    protected void setupCommandLineOptions() {
        super.setupCommandLineOptions();
        Options options = this.getOptions();
        Option accountOpt = new Option(O_ACCOUNT, "account", true, "account email addresses seperated by white space or \"all\" for all accounts");
        accountOpt.setArgs(-2);
        options.addOption(accountOpt);
        options.addOption(new Option(null, O_SYNC, false, "run synchronously; default is asynchronous"));
        options.addOption(SoapCLI.OPT_AUTHTOKEN);
        options.addOption(SoapCLI.OPT_AUTHTOKENFILE);
    }

    protected String getCommandUsage() {
        return "zmfixcalendtime -a <account(s)> [options]";
    }

    public FixCalendarEndTimeUtil() throws ServiceException {
        this.setupCommandLineOptions();
    }

    public static void main(String[] args) {
        CliUtil.toolSetup();
        FixCalendarEndTimeUtil util = null;
        try {
            util = new FixCalendarEndTimeUtil();
        }
        catch (ServiceException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            CommandLine cl = util.getCommandLine(args);
            if (cl == null) {
                return;
            }
            util.doit(FixCalendarEndTimeUtil.getZAuthToken(cl), cl.getOptionValues(O_ACCOUNT), cl.hasOption(O_SYNC));
            System.exit(0);
        }
        catch (ParseException e) {
            util.usage(e);
        }
        catch (Exception e) {
            System.err.println("Error occurred: " + e.getMessage());
            util.usage(null);
        }
        System.exit(1);
    }

    private void doit(ZAuthToken zat, String[] accts, boolean sync) throws SoapFaultException, IOException, ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.FIX_CALENDAR_END_TIME_REQUEST);
        if (accts == null || accts.length == 0) {
            throw ServiceException.INVALID_REQUEST("Missing -a option", null);
        }
        for (String acct : accts) {
            Element acctElem = ((Element)req).addElement("account");
            acctElem.addAttribute("name", acct);
        }
        if (sync) {
            req.addAttribute(O_SYNC, true);
        }
        this.auth(zat);
        this.getTransport().invokeWithoutSession(req);
    }
}

