/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.Util;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarUser {
    protected static final String FN_ADDRESS = "a";
    protected static final String FN_CN = "cn";
    protected static final String FN_SENTBY = "sentby";
    protected static final String FN_DIR = "dir";
    protected static final String FN_LANGUAGE = "lang";
    private String mAddress;
    private String mCn;
    private String mSentBy;
    private String mDir;
    private String mLanguage;
    private List<ZCalendar.ZParameter> mXParams = new ArrayList<ZCalendar.ZParameter>();

    public String getAddress() {
        return this.mAddress;
    }

    public void setAddress(String a) {
        this.mAddress = CalendarUser.getMailToAddress(a);
    }

    public boolean hasCn() {
        return !StringUtil.isNullOrEmpty(this.mCn);
    }

    public String getCn() {
        return this.mCn;
    }

    public void setCn(String cn) {
        this.mCn = cn;
    }

    public boolean hasSentBy() {
        return !StringUtil.isNullOrEmpty(this.mSentBy);
    }

    public String getSentBy() {
        return this.mSentBy;
    }

    public void setSentBy(String sb) {
        this.mSentBy = CalendarUser.getMailToAddress(sb);
    }

    public boolean hasDir() {
        return !StringUtil.isNullOrEmpty(this.mDir);
    }

    public String getDir() {
        return this.mDir;
    }

    public void setDir(String d) {
        this.mDir = d;
    }

    public boolean hasLanguage() {
        return !StringUtil.isNullOrEmpty(this.mLanguage);
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public void setLanguage(String lang) {
        this.mLanguage = lang;
    }

    private final String blankIfNullSpaceAfterIfNot(String str) {
        if (str == null) {
            return "";
        }
        return str + " ";
    }

    public String getIndexString() {
        StringBuilder s = new StringBuilder();
        s.append(this.blankIfNullSpaceAfterIfNot(this.getCn()));
        s.append(this.blankIfNullSpaceAfterIfNot(this.getAddress()));
        s.append(this.blankIfNullSpaceAfterIfNot(this.getSentBy()));
        s.append(this.blankIfNullSpaceAfterIfNot(this.getDir()));
        return s.toString().trim();
    }

    public CalendarUser(String address, String cn, String sentBy, String dir, String language) {
        this.setAddress(address);
        this.setCn(cn);
        this.setSentBy(sentBy);
        this.setDir(dir);
        this.setLanguage(language);
    }

    public CalendarUser(String address, String cn, String sentBy, String dir, String language, List<ZCalendar.ZParameter> xparams) {
        this(address, cn, sentBy, dir, language);
        if (xparams != null) {
            this.mXParams = xparams;
        }
    }

    public CalendarUser(ZCalendar.ZProperty prop) {
        this(prop.getValue(), prop.paramVal(ZCalendar.ICalTok.CN, null), prop.paramVal(ZCalendar.ICalTok.SENT_BY, null), prop.paramVal(ZCalendar.ICalTok.DIR, null), prop.paramVal(ZCalendar.ICalTok.LANGUAGE, null));
        Iterator<ZCalendar.ZParameter> paramIter = prop.parameterIterator();
        while (paramIter.hasNext()) {
            String name;
            ZCalendar.ZParameter param = paramIter.next();
            if (param.mTok != null || !(name = param.getName()).startsWith("X-") && !name.startsWith("x-")) continue;
            this.addXParam(param);
        }
    }

    public CalendarUser(Metadata meta) throws ServiceException {
        this(meta.get(FN_ADDRESS, null), meta.get(FN_CN, null), meta.get(FN_SENTBY, null), meta.get(FN_DIR, null), meta.get(FN_LANGUAGE, null));
        List<ZCalendar.ZParameter> xparams = Util.decodeXParamsFromMetadata(meta);
        if (xparams != null) {
            for (ZCalendar.ZParameter xparam : xparams) {
                this.mXParams.add(xparam);
            }
        }
    }

    protected CalendarUser(CalendarUser other) {
        this.mAddress = other.mAddress;
        this.mCn = other.mCn;
        this.mSentBy = other.mSentBy;
        this.mDir = other.mDir;
        this.mLanguage = other.mLanguage;
        this.mXParams.addAll(other.mXParams);
    }

    public Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_ADDRESS, this.mAddress);
        meta.put(FN_CN, this.mCn);
        meta.put(FN_SENTBY, this.mSentBy);
        meta.put(FN_DIR, this.mDir);
        meta.put(FN_LANGUAGE, this.mLanguage);
        if (this.mXParams.size() > 0) {
            Util.encodeXParamsAsMetadata(meta, this.xparamsIterator());
        }
        return meta;
    }

    public InternetAddress getFriendlyAddress() throws MailServiceException {
        try {
            String address = this.getAddress();
            if (address == null || address.length() < 1) {
                throw MailServiceException.ADDRESS_PARSE_ERROR("No address value", null);
            }
            InternetAddress addr = this.hasCn() ? new InternetAddress(address, this.getCn(), "utf-8") : new InternetAddress(address);
            return addr;
        }
        catch (UnsupportedEncodingException e) {
            throw MailServiceException.ADDRESS_PARSE_ERROR(e);
        }
        catch (AddressException e) {
            throw MailServiceException.ADDRESS_PARSE_ERROR(e);
        }
    }

    public InternetAddress getReplyAddress() throws MailServiceException {
        try {
            InternetAddress addr = this.hasSentBy() ? new InternetAddress(this.getSentBy()) : this.getFriendlyAddress();
            return addr;
        }
        catch (AddressException e) {
            throw MailServiceException.ADDRESS_PARSE_ERROR(e);
        }
    }

    public URI getURI() throws ServiceException {
        try {
            return new URI("mailto", this.mAddress, null);
        }
        catch (URISyntaxException e) {
            throw ServiceException.FAILURE("Could not create URI for address " + this.mAddress, e);
        }
    }

    protected abstract ZCalendar.ICalTok getPropertyName();

    protected void setProperty(ZCalendar.ZProperty prop) throws ServiceException {
        if (this.hasCn()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.CN, this.getCn()));
        }
        if (this.hasSentBy()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.SENT_BY, "mailto:" + this.getSentBy()));
        }
        if (this.hasDir()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.DIR, this.getDir()));
        }
        if (this.hasLanguage()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.LANGUAGE, this.getLanguage()));
        }
    }

    public ZCalendar.ZProperty toProperty() throws ServiceException {
        String addr = this.getAddress();
        if (addr != null && addr.indexOf(58) < 0) {
            addr = "mailto:" + addr;
        }
        ZCalendar.ZProperty prop = new ZCalendar.ZProperty(this.getPropertyName(), addr);
        this.setProperty(prop);
        for (ZCalendar.ZParameter xparam : this.mXParams) {
            prop.addParameter(xparam);
        }
        return prop;
    }

    public List<ZCalendar.ZParameter> getXParams() {
        return this.mXParams;
    }

    public Iterator<ZCalendar.ZParameter> xparamsIterator() {
        return this.mXParams.iterator();
    }

    public void addXParam(ZCalendar.ZParameter param) {
        this.mXParams.add(param);
    }

    public ZCalendar.ZParameter getXParam(String xparamName) {
        for (ZCalendar.ZParameter param : this.mXParams) {
            if (!param.getName().equalsIgnoreCase(xparamName)) continue;
            return param;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.addToStringBuilder(sb);
        for (ZCalendar.ZParameter xparam : this.mXParams) {
            sb.append(", ").append(xparam.toString());
        }
        return sb.toString();
    }

    protected static String getMailToAddress(String address) {
        if (address != null) {
            if (address.toLowerCase().startsWith("mailto:")) {
                address = address.substring(7);
            }
            if (address.length() > 0) {
                return address;
            }
        }
        return null;
    }

    protected StringBuilder addToStringBuilder(StringBuilder sb) {
        if (this.hasCn()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("CN=\"").append(this.getCn()).append('\"');
        }
        if (this.hasSentBy()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("SENT-BY=\"mailto:").append(this.getSentBy()).append('\"');
        }
        if (this.hasDir()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("DIR=").append(this.getDir());
        }
        if (this.hasLanguage()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("LANGUAGE=").append(this.getLanguage()).append(";");
        }
        if (sb.length() > 0) {
            sb.append(':');
        }
        sb.append("mailto:").append(this.getAddress());
        return sb;
    }

    protected static <T> boolean sameValues(T val1, T val2) {
        if (val1 != null) {
            return val1.equals(val2);
        }
        return val2 == null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarUser)) {
            return false;
        }
        CalendarUser other = (CalendarUser)o;
        if (!CalendarUser.sameValues(this.mAddress, other.mAddress)) {
            return false;
        }
        if (!CalendarUser.sameValues(this.mCn, other.mCn)) {
            return false;
        }
        if (!CalendarUser.sameValues(this.mSentBy, other.mSentBy)) {
            return false;
        }
        if (!CalendarUser.sameValues(this.mDir, other.mDir)) {
            return false;
        }
        if (!CalendarUser.sameValues(this.mLanguage, other.mLanguage)) {
            return false;
        }
        return CalendarUser.sameValues(this.mXParams, other.mXParams);
    }
}

