/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarDataSource;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.util.Zimbra;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarMailSender {
    public static final String X_ZIMBRA_CALENDAR_INTENDED_FOR = "X-Zimbra-Calendar-Intended-For";
    public static final Verb VERB_ACCEPT = new Verb("ACCEPT", "AC");
    public static final Verb VERB_DECLINE = new Verb("DECLINE", "DE");
    public static final Verb VERB_TENTATIVE = new Verb("TENTATIVE", "TE");
    protected static Map<String, Verb> sVerbs = new HashMap<String, Verb>();
    private static Map<Verb, L10nUtil.MsgKey> sVerbMsgKeys;

    public static Verb parseVerb(String str) throws ServiceException {
        Verb verb = sVerbs.get(str.toLowerCase());
        if (verb != null) {
            return verb;
        }
        throw ServiceException.INVALID_REQUEST("Unknown Reply Verb: " + str, null);
    }

    public static String getReplySubject(Verb verb, String subject, Locale lc) {
        L10nUtil.MsgKey key = sVerbMsgKeys.get(verb);
        String prefix = L10nUtil.getMessage(key, lc, new Object[0]);
        return prefix + ": " + subject;
    }

    public static String getCancelSubject(String subject, Locale lc) {
        String prefix = L10nUtil.getMessage(L10nUtil.MsgKey.calendarSubjectCancelled, lc, new Object[0]) + ": ";
        if (subject != null && subject.startsWith(prefix)) {
            return subject;
        }
        return prefix + subject;
    }

    public static MimeMessage createOrganizerChangeMessage(Account fromAccount, Account authAccount, boolean asAdmin, CalendarItem calItem, Invite inv, List<Address> rcpts) throws ServiceException {
        MimeMessage mmInv;
        ZOrganizer organizer = inv.getOrganizer();
        assert (organizer != null);
        boolean onBehalfOf = organizer.hasSentBy();
        String senderAddr = onBehalfOf ? organizer.getSentBy() : organizer.getAddress();
        Locale locale = fromAccount.getLocale();
        boolean hidePrivate = !calItem.isPublic() && !calItem.allowPrivateAccess(authAccount, asAdmin);
        String subject = hidePrivate ? L10nUtil.getMessage(L10nUtil.MsgKey.calendarSubjectWithheld, locale, new Object[0]) : inv.getName();
        StringBuilder sb = new StringBuilder("Organizer has been changed to " + fromAccount.getName());
        sb.append("\r\n\r\n");
        if (!hidePrivate && (mmInv = inv.getMimeMessage()) != null) {
            CalendarMailSender.attachInviteSummary(sb, inv, mmInv, locale);
        }
        ZCalendar.ZVCalendar iCal = inv.newToICalendar(true);
        InternetAddress from = AccountUtil.getFriendlyEmailAddress(fromAccount);
        InternetAddress sender = null;
        if (onBehalfOf) {
            try {
                sender = new InternetAddress(senderAddr);
            }
            catch (AddressException e) {
                throw MailServiceException.ADDRESS_PARSE_ERROR(e);
            }
        }
        return CalendarMailSender.createCalendarMessage((Address)from, (Address)sender, rcpts, subject, sb.toString(), null, inv.getUid(), iCal);
    }

    public static MimeMessage createDefaultReply(Account fromAccount, Account authAccount, boolean asAdmin, boolean onBehalfOf, CalendarItem calItem, Invite inv, MimeMessage mmInv, String replySubject, Verb verb, String additionalMsgBody, ZCalendar.ZVCalendar iCal) throws ServiceException {
        return CalendarMailSender.createDefaultReply(fromAccount, authAccount, asAdmin, onBehalfOf, calItem, inv, mmInv, replySubject, verb, false, additionalMsgBody, iCal);
    }

    public static MimeMessage createDefaultReply(Account fromAccount, Account authAccount, boolean asAdmin, boolean onBehalfOf, CalendarItem calItem, Invite inv, MimeMessage mmInv, String replySubject, Verb verb, boolean partialAccept, String additionalMsgBody, ZCalendar.ZVCalendar iCal) throws ServiceException {
        boolean allowPrivateAccess;
        Locale lc;
        InternetAddress organizerAddress;
        if (inv.hasOrganizer()) {
            ZOrganizer org = inv.getOrganizer();
            organizerAddress = org.getReplyAddress();
            Account organizer = Provisioning.getInstance().get(Provisioning.AccountBy.name, organizerAddress.getAddress());
            lc = organizer != null ? organizer.getLocale() : authAccount.getLocale();
        } else {
            organizerAddress = null;
            lc = authAccount.getLocale();
        }
        String fromDisplayName = fromAccount.getAttr("displayName", fromAccount.getName());
        StringBuilder replyText = new StringBuilder();
        boolean isResourceAccount = fromAccount instanceof CalendarResource;
        L10nUtil.MsgKey statusMsgKey = VERB_ACCEPT.equals(verb) ? (isResourceAccount ? (partialAccept ? L10nUtil.MsgKey.calendarResourceDefaultReplyPartiallyAccept : L10nUtil.MsgKey.calendarResourceDefaultReplyAccept) : L10nUtil.MsgKey.calendarDefaultReplyAccept) : (VERB_DECLINE.equals(verb) ? (isResourceAccount ? (partialAccept ? L10nUtil.MsgKey.calendarResourceDefaultReplyPartiallyDecline : L10nUtil.MsgKey.calendarResourceDefaultReplyDecline) : L10nUtil.MsgKey.calendarDefaultReplyDecline) : (VERB_TENTATIVE.equals(verb) ? (isResourceAccount ? L10nUtil.MsgKey.calendarResourceDefaultReplyTentativelyAccept : L10nUtil.MsgKey.calendarDefaultReplyTentativelyAccept) : L10nUtil.MsgKey.calendarDefaultReplyOther));
        String statusMsg = !statusMsgKey.equals((Object)L10nUtil.MsgKey.calendarDefaultReplyOther) ? L10nUtil.getMessage(statusMsgKey, lc, fromDisplayName) : L10nUtil.getMessage(statusMsgKey, lc, fromDisplayName, verb.toString());
        replyText.append(statusMsg).append("\r\n\r\n");
        if (additionalMsgBody != null) {
            replyText.append(additionalMsgBody).append("\r\n");
        }
        boolean bl = allowPrivateAccess = calItem != null ? calItem.allowPrivateAccess(authAccount, asAdmin) : true;
        if (inv.isPublic() || allowPrivateAccess) {
            CalendarMailSender.attachInviteSummary(replyText, inv, mmInv, lc);
        }
        ArrayList<Address> toList = new ArrayList<Address>(1);
        if (organizerAddress != null) {
            toList.add((Address)organizerAddress);
        }
        InternetAddress senderAddr = null;
        if (onBehalfOf) {
            senderAddr = AccountUtil.getFriendlyEmailAddress(authAccount);
        }
        return CalendarMailSender.createCalendarMessage((Address)AccountUtil.getFriendlyEmailAddress(fromAccount), (Address)senderAddr, toList, replySubject, replyText.toString(), null, inv.getUid(), iCal);
    }

    private static void attachInviteSummary(StringBuilder sb, Invite inv, MimeMessage mmInv, Locale lc) throws ServiceException {
        String notes = inv.getDescription();
        if ((notes == null || notes.length() < 1) && mmInv != null) {
            notes = Invite.getDescription((Part)mmInv, "text/plain");
        }
        if (notes != null && notes.length() > 0) {
            notes = notes.replaceAll("[\\r\\n]+[\\*~]+[\\r\\n]+", "\r\n\r\n ~ ~ ~ ~ ~ ~ ~ ~ ~\r\n\r\n");
            sb.append("\r\n-----");
            sb.append(L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceReplyOriginalInviteSeparatorLabel, lc, new Object[0]));
            sb.append("-----\r\n\r\n");
            sb.append(notes);
        }
    }

    public static String formatDateTime(Date d, TimeZone tz, Locale lc) {
        String dateTimeFmt = L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceConflictDateTimeFormat, lc, new Object[0]);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(dateTimeFmt, lc);
        dateTimeFormat.setTimeZone(tz);
        return dateTimeFormat.format(d);
    }

    public static String formatTime(Date t, TimeZone tz, Locale lc) {
        String timeOnlyFmt = L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceConflictTimeOnlyFormat, lc, new Object[0]);
        SimpleDateFormat timeFormat = new SimpleDateFormat(timeOnlyFmt, lc);
        timeFormat.setTimeZone(tz);
        return timeFormat.format(t);
    }

    public static String formatDate(Date t, TimeZone tz, Locale lc) {
        String dateOnlyFmt = L10nUtil.getMessage(L10nUtil.MsgKey.calendarResourceConflictDateOnlyFormat, lc, new Object[0]);
        SimpleDateFormat timeFormat = new SimpleDateFormat(dateOnlyFmt, lc);
        timeFormat.setTimeZone(tz);
        return timeFormat.format(t);
    }

    public static List<Address> toListFromAttendees(List<ZAttendee> list) throws MailServiceException {
        ArrayList<Address> toList = new ArrayList<Address>(list.size());
        for (ZAttendee attendee : list) {
            toList.add((Address)attendee.getFriendlyAddress());
        }
        return toList;
    }

    public static MimeMessage createCancelMessage(Account fromAccount, Account senderAccount, boolean asAdmin, boolean onBehalfOf, List<Address> toAddrs, CalendarItem calItem, Invite inv, String text, ZCalendar.ZVCalendar iCal) throws ServiceException {
        boolean hidePrivate;
        Locale locale = !onBehalfOf ? fromAccount.getLocale() : senderAccount.getLocale();
        Invite defaultInv = calItem.getDefaultInviteOrNull();
        boolean bl = hidePrivate = !calItem.isPublic() && !calItem.allowPrivateAccess(senderAccount, asAdmin);
        String defaultSubject = hidePrivate ? L10nUtil.getMessage(L10nUtil.MsgKey.calendarSubjectWithheld, locale, new Object[0]) : (defaultInv != null ? defaultInv.getName() : "");
        String sbj = CalendarMailSender.getCancelSubject(defaultSubject, locale);
        StringBuilder sb = new StringBuilder(text);
        sb.append("\r\n\r\n");
        if (!inv.equals(defaultInv) && inv.getStartTime() != null) {
            sb.append(L10nUtil.getMessage(L10nUtil.MsgKey.calendarCancelAppointmentInstanceWhich, locale, new Object[0]));
            sb.append(" ");
            ParsedDateTime start = inv.getStartTime();
            ICalTimeZone tz = start.getTimeZone();
            Date startDate = new Date(start.getUtcTime());
            sb.append(CalendarMailSender.formatDateTime(startDate, tz, locale));
            sb.append("\r\n\r\n");
        }
        if (!hidePrivate) {
            MimeMessage mmInv = inv.getMimeMessage();
            if (mmInv == null && defaultInv != null) {
                mmInv = defaultInv.getMimeMessage();
            }
            if (mmInv != null) {
                CalendarMailSender.attachInviteSummary(sb, inv, mmInv, locale);
            }
        }
        InternetAddress from = AccountUtil.getFriendlyEmailAddress(fromAccount);
        InternetAddress sender = null;
        if (onBehalfOf) {
            sender = AccountUtil.getFriendlyEmailAddress(senderAccount);
        }
        return CalendarMailSender.createCalendarMessage((Address)from, (Address)sender, toAddrs, sbj, sb.toString(), null, defaultInv != null ? defaultInv.getUid() : "unknown", iCal);
    }

    public static MimeMessage createCalendarMessage(Invite inv) throws ServiceException {
        String subject = inv.getName();
        String desc = inv.getDescription();
        String descHtml = inv.getDescriptionHtml();
        String uid = inv.getUid();
        ZCalendar.ZVCalendar cal = inv.newToICalendar(true);
        return CalendarMailSender.createCalendarMessage(null, null, null, subject, desc, descHtml, uid, cal);
    }

    public static MimeMessage createCalendarMessage(Address fromAddr, Address senderAddr, List<Address> toAddrs, String subject, String desc, String descHtml, String uid, ZCalendar.ZVCalendar cal) throws ServiceException {
        if (desc == null) {
            desc = "";
        }
        try {
            Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession());
            MimeMultipart mmp = new MimeMultipart("alternative");
            mm.setContent((Multipart)mmp);
            cal.addDescription(desc, null);
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(desc, "utf-8");
            mmp.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            if (descHtml != null) {
                ContentType ct = new ContentType("text/html");
                ct.setParameter("charset", "utf-8");
                htmlPart.setText(descHtml, "utf-8");
                htmlPart.setHeader("Content-Type", ct.toString());
            } else {
                htmlPart.setDataHandler(new DataHandler(new HtmlPartDataSource(desc)));
            }
            mmp.addBodyPart((BodyPart)htmlPart);
            MimeBodyPart icalPart = CalendarMailSender.makeICalIntoMimePart(uid, cal);
            mmp.addBodyPart((BodyPart)icalPart);
            if (subject != null) {
                mm.setSubject(subject, "utf-8");
            }
            if (toAddrs != null) {
                Address[] addrs = new Address[toAddrs.size()];
                toAddrs.toArray(addrs);
                mm.addRecipients(Message.RecipientType.TO, addrs);
            }
            if (fromAddr != null) {
                mm.setFrom(fromAddr);
            }
            if (senderAddr != null) {
                mm.setSender(senderAddr);
                mm.setReplyTo(new Address[]{senderAddr});
            }
            mm.setSentDate(new Date());
            mm.saveChanges();
            return mm;
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Messaging Exception while building MimeMessage from invite", e);
        }
    }

    public static MimeMessage createCalendarMessage(Address fromAddr, Address senderAddr, List<Address> toAddrs, MimeMessage srcMm, Invite inv, ZCalendar.ZVCalendar cal) throws ServiceException {
        try {
            String uid = inv.getUid();
            if (srcMm != null) {
                MimeMessage mm = new MimeMessage(srcMm);
                mm.setHeader("Message-ID", null);
                mm.setSentDate(new Date());
                if (toAddrs != null) {
                    Address[] addrs = new Address[toAddrs.size()];
                    toAddrs.toArray(addrs);
                    mm.setRecipients(Message.RecipientType.TO, addrs);
                }
                mm.setRecipients(Message.RecipientType.CC, (Address[])null);
                mm.setRecipients(Message.RecipientType.BCC, (Address[])null);
                if (fromAddr != null) {
                    mm.setFrom(fromAddr);
                }
                if (senderAddr != null) {
                    mm.setSender(senderAddr);
                    mm.setReplyTo(new Address[]{senderAddr});
                }
                CalendarPartReplacingVisitor visitor = new CalendarPartReplacingVisitor(uid, cal);
                visitor.accept(mm);
                mm.saveChanges();
                return mm;
            }
            String subject = inv.getName();
            String desc = inv.getDescription();
            String descHtml = inv.getDescriptionHtml();
            return CalendarMailSender.createCalendarMessage(fromAddr, senderAddr, toAddrs, subject, desc, descHtml, uid, cal);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Messaging Exception while building calendar message from source MimeMessage", e);
        }
    }

    public static MimeMessage createForwardedInviteMessage(MimeMessage mmOrig, String origSenderEmail, String forwarderEmail, String[] forwardTo) throws ServiceException {
        ArrayList<InternetAddress> rcpts = new ArrayList<InternetAddress>(forwardTo.length);
        for (String to : forwardTo) {
            try {
                rcpts.add(new InternetAddress(to));
            }
            catch (AddressException e) {
                ZimbraLog.calendar.warn("Ignoring invalid address \"" + to + "\" during invite forward");
            }
        }
        if (rcpts.isEmpty()) {
            return null;
        }
        MimeMessage mm = null;
        try {
            mm = new MimeMessage(mmOrig);
            mm.removeHeader("To");
            mm.removeHeader("Cc");
            mm.removeHeader("Bcc");
            mm.addRecipients(Message.RecipientType.TO, rcpts.toArray(new Address[0]));
            mm.setReplyTo(new Address[]{new InternetAddress(origSenderEmail)});
            mm.removeHeader("Date");
            mm.removeHeader("Message-ID");
            mm.removeHeader("Return-Path");
            mm.removeHeader("Received");
            mm.setHeader(X_ZIMBRA_CALENDAR_INTENDED_FOR, forwarderEmail);
            mm.saveChanges();
        }
        catch (MessagingException e) {
            ZimbraLog.calendar.warn((Object)"Unable to compose email for invite forwarding", e);
        }
        return mm;
    }

    private static MimeMessage createCalendarInviteDeniedMessage(Account fromAccount, Account senderAccount, boolean onBehalfOf, boolean allowPrivateAccess, Address toAddr, Invite inv, L10nUtil.MsgKey bodyTextKey) throws ServiceException {
        Locale locale = !onBehalfOf ? fromAccount.getLocale() : senderAccount.getLocale();
        String subject = L10nUtil.getMessage(L10nUtil.MsgKey.calendarReplySubjectDecline, locale, new Object[0]) + ": " + inv.getName();
        String text = L10nUtil.getMessage(bodyTextKey, locale, new Object[0]);
        String uid = inv.getUid();
        ParsedDateTime exceptDt = null;
        if (inv.hasRecurId()) {
            exceptDt = inv.getRecurId().getDt();
        }
        Invite replyInv = CalendarMailSender.replyToInvite(fromAccount, senderAccount, onBehalfOf, allowPrivateAccess, inv, VERB_DECLINE, subject, exceptDt);
        ZCalendar.ZVCalendar iCal = replyInv.newToICalendar(true);
        InternetAddress fromAddr = AccountUtil.getFriendlyEmailAddress(fromAccount);
        InternetAddress senderAddr = null;
        if (onBehalfOf) {
            senderAddr = AccountUtil.getFriendlyEmailAddress(senderAccount);
        }
        ArrayList<Address> toAddrs = new ArrayList<Address>(1);
        toAddrs.add(toAddr);
        return CalendarMailSender.createCalendarMessage((Address)fromAddr, (Address)senderAddr, toAddrs, subject, text, null, uid, iCal);
    }

    public static void sendInviteDeniedMessage(final OperationContext octxt, Account fromAccount, Account senderAccount, boolean onBehalfOf, boolean allowPrivateAccess, final Mailbox mbox, final ItemId origMsgId, String toEmail, Invite inv) throws ServiceException {
        InternetAddress toAddr;
        try {
            toAddr = new InternetAddress(toEmail);
        }
        catch (AddressException e) {
            throw ServiceException.FAILURE("Bad address: " + toEmail, e);
        }
        L10nUtil.MsgKey bodyTextKey = fromAccount instanceof CalendarResource ? L10nUtil.MsgKey.calendarResourceDefaultReplyPermissionDenied : L10nUtil.MsgKey.calendarUserReplyPermissionDenied;
        final MimeMessage mm = CalendarMailSender.createCalendarInviteDeniedMessage(fromAccount, senderAccount, onBehalfOf, allowPrivateAccess, (Address)toAddr, inv, bodyTextKey);
        Runnable r = new Runnable(){

            public void run() {
                try {
                    mbox.getMailSender().sendMimeMessage(octxt, mbox, true, mm, null, null, origMsgId, MailSender.MSGTYPE_REPLY, null, true, true);
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)"Ignoring error while sending permission-denied auto reply", e);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("OutOfMemoryError while sending permission-denied auto reply", e);
                }
            }
        };
        Thread senderThread = new Thread(r, "CalendarPermDeniedReplySender");
        senderThread.setDaemon(true);
        senderThread.start();
    }

    public static void sendInviteForwardMessage(final OperationContext octxt, final Mailbox mbox, final ItemId origMsgId, final MimeMessage mm) throws ServiceException {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    MailSender sender = mbox.getMailSender().setSaveToSent(true).setOriginalMessageId(origMsgId).setReplyType(MailSender.MSGTYPE_REPLY).setIgnoreFailedAddresses(true).setSkipSendAsCheck(true);
                    sender.sendMimeMessage(octxt, mbox, mm);
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)"Ignoring error while sending permission-denied auto reply", e);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("OutOfMemoryError while sending permission-denied auto reply", e);
                }
            }
        };
        Thread senderThread = new Thread(r, "CalendarInviteForwardSender");
        senderThread.setDaemon(true);
        senderThread.start();
    }

    public static Invite replyToInvite(Account acct, Account authAcct, boolean onBehalfOf, boolean allowPrivateAccess, Invite oldInv, Verb verb, String replySubject, ParsedDateTime exceptDt) throws ServiceException {
        Invite reply = new Invite(oldInv.getItemType(), ZCalendar.ICalTok.REPLY.toString(), new TimeZoneMap(ICalTimeZone.getAccountTimeZone(onBehalfOf ? authAcct : acct)), oldInv.isOrganizer());
        reply.setLocalOnly(false);
        reply.getTimeZoneMap().add(oldInv.getTimeZoneMap());
        ZAttendee meReply = null;
        ZAttendee me = oldInv.getMatchingAttendee(acct);
        if (me != null) {
            meReply = new ZAttendee(me.getAddress());
            meReply.setPartStat(verb.getXmlPartStat());
            if (me.hasRole()) {
                meReply.setRole(me.getRole());
            }
            if (me.hasCUType()) {
                meReply.setCUType(me.getCUType());
            }
            if (me.hasCn()) {
                meReply.setCn(me.getCn());
            }
            if (onBehalfOf) {
                meReply.setSentBy(authAcct.getName());
            }
            reply.addAttendee(meReply);
        } else {
            String name = acct.getName();
            meReply = new ZAttendee(name);
            meReply.setPartStat(verb.getXmlPartStat());
            if (onBehalfOf) {
                meReply.setSentBy(authAcct.getName());
            }
            reply.addAttendee(meReply);
        }
        boolean hidePrivate = !oldInv.isPublic() && !allowPrivateAccess;
        reply.setClassProp(oldInv.getClassProp());
        reply.setDtStart(oldInv.getStartTime());
        reply.setDtEnd(oldInv.getEffectiveEndTime());
        if (!hidePrivate) {
            reply.setLocation(oldInv.getLocation());
        } else {
            reply.setLocation("");
        }
        if (oldInv.hasOrganizer()) {
            reply.setOrganizer(oldInv.getOrganizer());
        }
        reply.setUid(oldInv.getUid());
        if (exceptDt != null) {
            reply.setRecurId(new RecurId(exceptDt, RecurId.RANGE_NONE));
        } else if (oldInv.hasRecurId()) {
            reply.setRecurId(oldInv.getRecurId());
        }
        reply.setSeqNo(oldInv.getSeqNo());
        Date now = new Date();
        Date dtStampDate = new Date(oldInv.getDTStamp());
        if (now.after(dtStampDate)) {
            dtStampDate = now;
        }
        reply.setDtStamp(dtStampDate.getTime());
        reply.setName(replySubject);
        return reply;
    }

    private static void setCalendarContent(Part part, String uid, ZCalendar.ZVCalendar cal) throws MessagingException {
        String filename = "meeting.ics";
        part.setDataHandler(new DataHandler(new CalendarDataSource(cal, uid, filename)));
    }

    public static MimeBodyPart makeICalIntoMimePart(String uid, ZCalendar.ZVCalendar cal) throws ServiceException {
        try {
            MimeBodyPart mbp = new MimeBodyPart();
            CalendarMailSender.setCalendarContent((Part)mbp, uid, cal);
            return mbp;
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Failure creating MimeBodyPart from calendar", e);
        }
    }

    public static MimeMessage createResourceAutoReply(OperationContext octxt, Mailbox mbox, Verb verb, boolean partialAccept, String additionalMsgBody, CalendarItem calItem, Invite inv, Invite[] replies, MimeMessage mmInv) throws ServiceException {
        Account organizer;
        Account authuser;
        Account acct;
        boolean onBehalfOf = false;
        Account authAcct = acct = mbox.getAccount();
        if (octxt != null && (authuser = octxt.getAuthenticatedUser()) != null) {
            boolean bl = onBehalfOf = !acct.getId().equalsIgnoreCase(authuser.getId());
            if (onBehalfOf) {
                authAcct = authuser;
            }
        }
        Locale lc = (organizer = inv.getOrganizerAccount()) != null ? organizer.getLocale() : authAcct.getLocale();
        boolean asAdmin = octxt != null ? octxt.isUsingAdminPrivileges() : false;
        boolean allowPrivateAccess = calItem.allowPrivateAccess(authAcct, asAdmin);
        boolean hidePrivate = !inv.isPublic() && !allowPrivateAccess;
        String subject = hidePrivate ? L10nUtil.getMessage(L10nUtil.MsgKey.calendarSubjectWithheld, lc, new Object[0]) : inv.getName();
        String replySubject = CalendarMailSender.getReplySubject(verb, subject, lc);
        ZCalendar.ZVCalendar iCal = null;
        for (Invite replyInv : replies) {
            if (iCal == null) {
                iCal = replyInv.newToICalendar(!hidePrivate);
                continue;
            }
            ZCalendar.ZComponent cancelComp = replyInv.newToVComponent(true, !hidePrivate);
            iCal.addComponent(cancelComp);
        }
        return CalendarMailSender.createDefaultReply(acct, authAcct, asAdmin, onBehalfOf, calItem, inv, mmInv, replySubject, verb, partialAccept, additionalMsgBody, iCal);
    }

    public static void sendResourceAutoReply(final OperationContext octxt, final Mailbox mbox, final boolean saveToSent, Verb verb, boolean partialAccept, String additionalMsgBody, CalendarItem calItem, Invite inv, Invite[] replies, MimeMessage mmInv) throws ServiceException {
        final MimeMessage mm = CalendarMailSender.createResourceAutoReply(octxt, mbox, verb, partialAccept, additionalMsgBody, calItem, inv, replies, mmInv);
        final String replyType = MailSender.MSGTYPE_REPLY;
        final int invId = inv.getMailItemId();
        Runnable r = new Runnable(){

            public void run() {
                try {
                    mbox.getMailSender().sendMimeMessage(octxt, mbox, saveToSent, mm, null, null, new ItemId(mbox, invId), replyType, null, false, true);
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)"Ignoring error while sending auto accept/decline reply", e);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("OutOfMemoryError while sending calendar resource auto accept/decline reply", e);
                }
            }
        };
        Thread senderThread = new Thread(r, "CalendarAutoAcceptDeclineReplySender");
        senderThread.setDaemon(true);
        senderThread.start();
    }

    static {
        sVerbs.put("accept", VERB_ACCEPT);
        sVerbs.put("decline", VERB_DECLINE);
        sVerbs.put("tentative", VERB_TENTATIVE);
        sVerbMsgKeys = new HashMap<Verb, L10nUtil.MsgKey>();
        sVerbMsgKeys.put(VERB_ACCEPT, L10nUtil.MsgKey.calendarReplySubjectAccept);
        sVerbMsgKeys.put(VERB_DECLINE, L10nUtil.MsgKey.calendarReplySubjectDecline);
        sVerbMsgKeys.put(VERB_TENTATIVE, L10nUtil.MsgKey.calendarReplySubjectTentative);
    }

    private static class HtmlPartDataSource
    implements DataSource {
        private static final String CONTENT_TYPE = "text/html; charset=utf-8";
        private static final String HEAD = "<html><body>\n<pre style=\"font-family: monospace; font-size: 14px\">\n";
        private static final String TAIL = "</pre>\n</body></html>\n";
        private static final String NAME = "HtmlDataSource";
        private String mText;
        private byte[] mBuf = null;

        public HtmlPartDataSource(String text) {
            this.mText = text;
            this.mText = this.mText.replaceAll("&", "&amp;");
            this.mText = this.mText.replaceAll("<", "&lt;");
            this.mText = this.mText.replaceAll(">", "&gt;");
        }

        public String getContentType() {
            return CONTENT_TYPE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws IOException {
            HtmlPartDataSource htmlPartDataSource = this;
            synchronized (htmlPartDataSource) {
                if (this.mBuf == null) {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    OutputStreamWriter wout = new OutputStreamWriter((OutputStream)buf, "utf-8");
                    String text = HEAD + this.mText + TAIL;
                    wout.write(text);
                    wout.flush();
                    this.mBuf = buf.toByteArray();
                }
            }
            ByteArrayInputStream in = new ByteArrayInputStream(this.mBuf);
            return in;
        }

        public String getName() {
            return NAME;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CalendarPartReplacingVisitor
    extends MimeVisitor {
        private String mUid;
        private ZCalendar.ZVCalendar mCal;
        private boolean mReplaced;
        private MimeBodyPart mCalendarPart;

        public CalendarPartReplacingVisitor(String uid, ZCalendar.ZVCalendar cal) {
            this.mUid = uid;
            this.mCal = cal;
        }

        private static boolean isCalendarPart(Part part) throws MessagingException {
            String mmCtStr = part.getContentType();
            if (mmCtStr != null) {
                ContentType mmCt = new ContentType(mmCtStr);
                return mmCt.match("text/calendar");
            }
            return false;
        }

        protected boolean visitBodyPart(MimeBodyPart bp) throws MessagingException {
            if (this.mCalendarPart == null && CalendarPartReplacingVisitor.isCalendarPart((Part)bp)) {
                this.mCalendarPart = bp;
            }
            return false;
        }

        protected boolean visitMessage(MimeMessage mm, MimeVisitor.VisitPhase visitKind) throws MessagingException {
            if (MimeVisitor.VisitPhase.VISIT_END.equals((Object)visitKind)) {
                if (!this.mReplaced) {
                    CalendarMailSender.setCalendarContent((Part)mm, this.mUid, this.mCal);
                }
                return true;
            }
            return false;
        }

        protected boolean visitMultipart(MimeMultipart mp, MimeVisitor.VisitPhase visitKind) throws MessagingException {
            if (MimeVisitor.VisitPhase.VISIT_END.equals((Object)visitKind) && !this.mReplaced && this.mCalendarPart != null) {
                if (mp.removeBodyPart((BodyPart)this.mCalendarPart)) {
                    MimeBodyPart newCalendarPart = new MimeBodyPart();
                    CalendarMailSender.setCalendarContent((Part)newCalendarPart, this.mUid, this.mCal);
                    mp.addBodyPart((BodyPart)newCalendarPart);
                    this.mReplaced = true;
                    return true;
                }
                throw new MessagingException("Unable to remove old calendar part");
            }
            return false;
        }
    }

    public static final class Verb {
        String mName;
        String mPartStat;

        public Verb(String name, String xmlPartStat) {
            this.mName = name;
            this.mPartStat = xmlPartStat;
        }

        public String toString() {
            return this.mName;
        }

        public String getXmlPartStat() {
            return this.mPartStat;
        }
    }
}

