/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;

public class CalendarDataSource
implements DataSource {
    private ZCalendar.ZVCalendar mICal;
    private String mUid;
    private String mMethod;
    private String mAttachName;
    private byte[] mBuf = null;

    public CalendarDataSource(ZCalendar.ZVCalendar iCal, String uid, String attachmentName) {
        this.mICal = iCal;
        this.mUid = uid != null && uid.length() > 0 ? uid : LdapUtil.generateUUID();
        this.mAttachName = attachmentName;
        if (this.mAttachName == null || this.mAttachName.equals("")) {
            this.mAttachName = "meeting.ics";
        }
        this.mMethod = iCal.getPropVal(ZCalendar.ICalTok.METHOD, ZCalendar.ICalTok.PUBLISH.toString());
    }

    public String getContentType() {
        ContentType ct = new ContentType();
        ct.setParameter("charset", "utf-8");
        ct.setPrimaryType("text");
        ct.setSubType("calendar");
        ct.setParameter("method", this.mMethod);
        if (!this.mAttachName.toLowerCase().endsWith(".ics")) {
            this.mAttachName = this.mAttachName + ".ics";
        }
        ct.setParameter("name", this.mAttachName);
        return ct.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        CalendarDataSource calendarDataSource = this;
        synchronized (calendarDataSource) {
            if (this.mBuf == null) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                OutputStreamWriter wout = new OutputStreamWriter((OutputStream)buf, "utf-8");
                this.mICal.toICalendar(wout);
                wout.flush();
                this.mBuf = buf.toByteArray();
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.mBuf);
        return in;
    }

    public String getName() {
        return this.mUid;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

