/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ZCalendar;

public class Attach {
    private String mContentType;
    private String mUri;
    private String mBinaryB64Data;
    private static final String FN_CONTENT_TYPE = "ct";
    private static final String FN_URI = "uri";
    private static final String FN_BINARY = "bin";

    private Attach(String uri, String contentType) {
        this.mUri = uri;
        this.mContentType = contentType;
    }

    private Attach(String binaryB64Data) {
        this.mBinaryB64Data = binaryB64Data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mUri != null) {
            sb.append("uri=").append(this.mUri);
            if (this.mContentType != null) {
                sb.append(", ct=").append(this.mContentType);
            }
        } else {
            sb.append("binaryBase64=").append(this.mBinaryB64Data);
        }
        return sb.toString();
    }

    public Element toXml(Element parent) {
        Element attachElem = parent.addElement("attach");
        if (this.mUri != null) {
            attachElem.addAttribute(FN_URI, this.mUri);
            if (this.mContentType != null) {
                attachElem.addAttribute(FN_CONTENT_TYPE, this.mContentType);
            }
        } else {
            attachElem.setText(this.mBinaryB64Data);
        }
        return attachElem;
    }

    public static Attach parse(Element element) throws ServiceException {
        String uri = element.getAttribute(FN_URI, null);
        if (uri != null) {
            String ct = element.getAttribute(FN_CONTENT_TYPE, null);
            return new Attach(uri, ct);
        }
        String binB64 = element.getTextTrim();
        return new Attach(binB64);
    }

    public ZCalendar.ZProperty toZProperty() {
        if (this.mUri != null) {
            ZCalendar.ZProperty prop = new ZCalendar.ZProperty(ZCalendar.ICalTok.ATTACH, this.mUri);
            if (this.mContentType != null) {
                prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.FMTTYPE, this.mContentType));
            }
            return prop;
        }
        ZCalendar.ZProperty prop = new ZCalendar.ZProperty(ZCalendar.ICalTok.ATTACH, this.mBinaryB64Data);
        prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.VALUE, "BINARY"));
        prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.ENCODING, "BASE64"));
        return prop;
    }

    public static Attach parse(ZCalendar.ZProperty prop) {
        String value = prop.getValue();
        ZCalendar.ZParameter valueType = prop.getParameter(ZCalendar.ICalTok.VALUE);
        if (valueType != null && valueType.getValue().equals("BINARY")) {
            return new Attach(value);
        }
        String ct = null;
        ZCalendar.ZParameter fmttype = prop.getParameter(ZCalendar.ICalTok.FMTTYPE);
        if (fmttype != null) {
            ct = fmttype.getValue();
        }
        return new Attach(value, ct);
    }

    public Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        if (this.mUri != null) {
            meta.put(FN_URI, this.mUri);
            meta.put(FN_CONTENT_TYPE, this.mContentType);
        } else {
            meta.put(FN_BINARY, this.mBinaryB64Data);
        }
        return meta;
    }

    public static Attach decodeMetadata(Metadata meta) throws ServiceException {
        String uri = meta.get(FN_URI, null);
        if (uri != null) {
            String ct = meta.get(FN_CONTENT_TYPE, null);
            return new Attach(uri, ct);
        }
        String binary = meta.get(FN_BINARY, null);
        return new Attach(binary);
    }
}

