/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.Attach;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.Util;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ToXML;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alarm {
    private Action mAction;
    private TriggerType mTriggerType;
    private TriggerRelated mTriggerRelated;
    private ParsedDuration mTriggerRelative;
    private ParsedDateTime mTriggerAbsolute;
    private ParsedDuration mRepeatDuration;
    private int mRepeatCount;
    private String mDescription;
    private String mSummary;
    private Attach mAttach;
    private List<ZAttendee> mAttendees;
    private List<ZCalendar.ZProperty> mXProps = new ArrayList<ZCalendar.ZProperty>();
    private static final String FN_ACTION = "ac";
    private static final String FN_TRIGGER_TYPE = "tt";
    private static final String FN_TRIGGER_RELATED = "trd";
    private static final String FN_TRIGGER_RELATIVE = "tr";
    private static final String FN_TRIGGER_ABSOLUTE = "ta";
    private static final String FN_REPEAT_DURATION = "rd";
    private static final String FN_REPEAT_COUNT = "rc";
    private static final String FN_DESCRIPTION = "ds";
    private static final String FN_SUMMARY = "su";
    private static final String FN_NUM_ATTENDEES = "numAt";
    private static final String FN_ATTENDEE = "at";
    private static final String FN_ATTACH = "attach";

    public String getDescription() {
        return this.mDescription;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public Action getAction() {
        return this.mAction;
    }

    public List<ZAttendee> getAttendees() {
        return this.mAttendees;
    }

    public Alarm(Action action, TriggerType triggerType, TriggerRelated related, ParsedDuration triggerRelative, ParsedDateTime triggerAbsolute, ParsedDuration repeatDuration, int repeatCount, String description, String summary, Attach attach, List<ZAttendee> attendees) throws ServiceException {
        if (action == null) {
            throw ServiceException.INVALID_REQUEST("Missing ACTION in VALARM", null);
        }
        this.mAction = action;
        this.mTriggerType = triggerType;
        if (TriggerType.ABSOLUTE.equals((Object)triggerType)) {
            if (triggerAbsolute == null) {
                throw ServiceException.INVALID_REQUEST("Missing absolute TRIGGER in VALARM", null);
            }
            this.mTriggerAbsolute = triggerAbsolute;
        } else {
            if (triggerRelative == null) {
                throw ServiceException.INVALID_REQUEST("Missing relative TRIGGER in VALARM", null);
            }
            this.mTriggerRelated = related;
            this.mTriggerRelative = triggerRelative;
        }
        if (repeatDuration != null) {
            this.mRepeatDuration = repeatDuration;
            this.mRepeatCount = repeatCount;
        }
        this.mDescription = description;
        this.mSummary = summary;
        this.mAttach = attach;
        this.mAttendees = attendees;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("action=").append(this.mAction.toString());
        sb.append(", triggerType=").append(this.mTriggerType.toString());
        if (TriggerType.ABSOLUTE.equals((Object)this.mTriggerType)) {
            sb.append(", triggerAbsolute=").append(this.mTriggerAbsolute != null ? this.mTriggerAbsolute.toString() : "<none>");
        } else {
            sb.append(", triggerRelated").append(this.mTriggerRelated != null ? this.mTriggerRelated.toString() : "<default>");
            sb.append(", triggerRelative=").append(this.mTriggerRelative != null ? this.mTriggerRelative.toString() : "<none>");
        }
        if (this.mRepeatDuration != null) {
            sb.append(", repeatDuration=").append(this.mRepeatDuration != null ? this.mRepeatDuration.toString() : "<none>");
            sb.append(", repeatCount=").append(this.mRepeatCount);
        } else {
            sb.append(", repeat=<none>");
        }
        sb.append(", summary=\"").append(this.mSummary).append("\"");
        sb.append(", desc=\"").append(this.mDescription).append("\"");
        if (this.mAttach != null) {
            sb.append(", attach=").append(this.mAttach.toString());
        }
        if (this.mAttendees != null) {
            sb.append(", attendees=[");
            boolean first = true;
            for (ZAttendee attendee : this.mAttendees) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append("[").append(attendee.toString()).append("]");
            }
            sb.append("]");
        }
        for (ZCalendar.ZProperty xprop : this.mXProps) {
            sb.append(", ").append(xprop.toString());
        }
        return sb.toString();
    }

    public Element toXml(Element parent) {
        Element alarm = parent.addElement("alarm");
        alarm.addAttribute("action", this.mAction.toString());
        Element trigger = alarm.addElement("trigger");
        if (TriggerType.ABSOLUTE.equals((Object)this.mTriggerType)) {
            Element absolute = trigger.addElement("abs");
            absolute.addAttribute("d", this.mTriggerAbsolute.getDateTimePartString(false));
        } else {
            Element relative = this.mTriggerRelative.toXml(trigger, "rel");
            if (this.mTriggerRelated != null) {
                relative.addAttribute("related", this.mTriggerRelated.toString());
            }
        }
        if (this.mRepeatDuration != null) {
            Element repeat = this.mRepeatDuration.toXml(alarm, "repeat");
            repeat.addAttribute("count", this.mRepeatCount);
        }
        if (!Action.AUDIO.equals((Object)this.mAction) && this.mDescription != null) {
            Element desc = alarm.addElement("desc");
            desc.setText(this.mDescription);
        }
        if (this.mAttach != null) {
            this.mAttach.toXml(alarm);
        }
        if (Action.EMAIL.equals((Object)this.mAction) || Action.X_YAHOO_CALENDAR_ACTION_IM.equals((Object)this.mAction) || Action.X_YAHOO_CALENDAR_ACTION_MOBILE.equals((Object)this.mAction)) {
            Element summary = alarm.addElement("summary");
            if (this.mSummary != null) {
                summary.setText(this.mSummary);
            }
            if (this.mAttendees != null) {
                for (ZAttendee attendee : this.mAttendees) {
                    attendee.toXml(alarm);
                }
            }
        }
        ToXML.encodeXProps(alarm, this.xpropsIterator());
        return alarm;
    }

    public static boolean actionAllowed(Action action) {
        if (!DebugConfig.calendarAllowNonDisplayAlarms) {
            if (action != null && !Action.AUDIO.equals((Object)action) && !Action.PROCEDURE.equals((Object)action)) {
                return true;
            }
            ZimbraLog.calendar.warn("Action " + (action != null ? action.toString() : "null") + " is not allowed; ignoring alarm");
            return false;
        }
        return true;
    }

    public static Alarm parse(Element alarmElem) throws ServiceException {
        Element attachElem;
        Element summaryElem;
        Element descElem;
        Action action = Action.DISPLAY;
        TriggerType triggerType = TriggerType.RELATIVE;
        TriggerRelated triggerRelated = null;
        ParsedDuration triggerRelative = null;
        ParsedDateTime triggerAbsolute = null;
        ParsedDuration repeatDuration = null;
        int repeatCount = 0;
        String description = null;
        String summary = null;
        Attach attach = null;
        ArrayList<ZAttendee> attendees = null;
        String val = alarmElem.getAttribute("action");
        action = Action.lookup(val);
        if (action == null) {
            throw ServiceException.INVALID_REQUEST("Invalid action value " + val, null);
        }
        if (!Alarm.actionAllowed(action)) {
            return null;
        }
        Element triggerElem = alarmElem.getElement("trigger");
        Element triggerRelativeElem = triggerElem.getOptionalElement("rel");
        if (triggerRelativeElem != null) {
            triggerType = TriggerType.RELATIVE;
            String related = triggerRelativeElem.getAttribute("related", null);
            if (related != null && (triggerRelated = TriggerRelated.lookup(related)) == null) {
                throw ServiceException.INVALID_REQUEST("Invalid related value " + val, null);
            }
            triggerRelative = ParsedDuration.parse(triggerRelativeElem);
        } else {
            triggerType = TriggerType.ABSOLUTE;
            Element triggerAbsoluteElem = triggerElem.getOptionalElement("abs");
            if (triggerAbsoluteElem == null) {
                throw ServiceException.INVALID_REQUEST("<trigger> must have either <rel> or <abs> child element", null);
            }
            String datetime = triggerAbsoluteElem.getAttribute("d");
            try {
                triggerAbsolute = ParsedDateTime.parseUtcOnly(datetime);
            }
            catch (ParseException e) {
                throw ServiceException.INVALID_REQUEST("Invalid absolute trigger value " + val, e);
            }
        }
        Element repeatElem = alarmElem.getOptionalElement("repeat");
        if (repeatElem != null) {
            repeatDuration = ParsedDuration.parse(repeatElem);
            repeatCount = (int)repeatElem.getAttributeLong("count", 0L);
        }
        if ((descElem = alarmElem.getOptionalElement("desc")) != null) {
            description = descElem.getText();
        }
        if ((summaryElem = alarmElem.getOptionalElement("summary")) != null) {
            summary = summaryElem.getText();
        }
        if ((attachElem = alarmElem.getOptionalElement(FN_ATTACH)) != null) {
            attach = Attach.parse(attachElem);
        }
        Iterator<Element> attendeesIter = alarmElem.elementIterator(FN_ATTENDEE);
        while (attendeesIter.hasNext()) {
            ZAttendee at = ZAttendee.parse(attendeesIter.next());
            if (attendees == null) {
                attendees = new ArrayList<ZAttendee>();
            }
            attendees.add(at);
        }
        Alarm alarm = new Alarm(action, triggerType, triggerRelated, triggerRelative, triggerAbsolute, repeatDuration, repeatCount, description, summary, attach, attendees);
        List<ZCalendar.ZProperty> xprops = CalendarUtils.parseXProps(alarmElem);
        for (ZCalendar.ZProperty prop : xprops) {
            alarm.addXProp(prop);
        }
        return alarm;
    }

    public ZCalendar.ZComponent toZComponent() throws ServiceException {
        ZCalendar.ZComponent comp = new ZCalendar.ZComponent(ZCalendar.ICalTok.VALARM);
        ZCalendar.ZProperty action = new ZCalendar.ZProperty(ZCalendar.ICalTok.ACTION, this.mAction.toString());
        comp.addProperty(action);
        ZCalendar.ZProperty trigger = new ZCalendar.ZProperty(ZCalendar.ICalTok.TRIGGER);
        if (TriggerType.ABSOLUTE.equals((Object)this.mTriggerType)) {
            ZCalendar.ZParameter vt = new ZCalendar.ZParameter(ZCalendar.ICalTok.VALUE, ZCalendar.ICalTok.DATE_TIME.toString());
            trigger.addParameter(vt);
            trigger.setValue(this.mTriggerAbsolute.getDateTimePartString(false));
        } else {
            if (this.mTriggerRelated != null) {
                ZCalendar.ZParameter related = new ZCalendar.ZParameter(ZCalendar.ICalTok.RELATED, this.mTriggerRelated.toString());
                trigger.addParameter(related);
            }
            trigger.setValue(this.mTriggerRelative.toString());
        }
        comp.addProperty(trigger);
        if (this.mRepeatDuration != null) {
            ZCalendar.ZProperty duration = new ZCalendar.ZProperty(ZCalendar.ICalTok.DURATION, this.mRepeatDuration.toString());
            comp.addProperty(duration);
            ZCalendar.ZProperty repeat = new ZCalendar.ZProperty(ZCalendar.ICalTok.REPEAT, this.mRepeatCount);
            comp.addProperty(repeat);
        }
        if (!Action.AUDIO.equals((Object)this.mAction)) {
            String d = this.mDescription;
            if (d == null && !Action.PROCEDURE.equals((Object)this.mAction)) {
                d = "Reminder";
            }
            ZCalendar.ZProperty desc = new ZCalendar.ZProperty(ZCalendar.ICalTok.DESCRIPTION, d);
            comp.addProperty(desc);
        }
        if (this.mAttach != null) {
            comp.addProperty(this.mAttach.toZProperty());
        }
        if (Action.EMAIL.equals((Object)this.mAction) || Action.X_YAHOO_CALENDAR_ACTION_IM.equals((Object)this.mAction) || Action.X_YAHOO_CALENDAR_ACTION_MOBILE.equals((Object)this.mAction)) {
            String s = this.mSummary;
            if (s == null) {
                s = "Reminder";
            }
            ZCalendar.ZProperty summary = new ZCalendar.ZProperty(ZCalendar.ICalTok.SUMMARY, s);
            comp.addProperty(summary);
            if (this.mAttendees != null) {
                for (ZAttendee attendee : this.mAttendees) {
                    comp.addProperty(attendee.toProperty());
                }
            }
        }
        for (ZCalendar.ZProperty xprop : this.mXProps) {
            comp.addProperty(xprop);
        }
        return comp;
    }

    public static Alarm parse(ZCalendar.ZComponent comp) throws ServiceException {
        Action action = Action.DISPLAY;
        TriggerType triggerType = TriggerType.RELATIVE;
        TriggerRelated triggerRelated = null;
        ParsedDuration triggerRelative = null;
        ParsedDateTime triggerAbsolute = null;
        ParsedDuration repeatDuration = null;
        int repeatCount = 0;
        String description = null;
        String summary = null;
        Attach attach = null;
        ArrayList<ZAttendee> attendees = null;
        ArrayList<ZCalendar.ZProperty> xprops = new ArrayList<ZCalendar.ZProperty>();
        Iterator<ZCalendar.ZProperty> propIter = comp.getPropertyIterator();
        block14: while (propIter.hasNext()) {
            ZCalendar.ZProperty prop = propIter.next();
            ZCalendar.ICalTok tok = prop.getToken();
            String val = prop.getValue();
            if (tok == null) {
                String name = prop.getName();
                if (!name.startsWith("X-") && !name.startsWith("x-")) continue;
                xprops.add(prop);
                continue;
            }
            switch (tok) {
                case ACTION: {
                    if (val == null) break;
                    action = Action.lookup(val);
                    if (action == null) {
                        throw ServiceException.INVALID_REQUEST("Invalid ACTION value " + val, null);
                    }
                    if (Alarm.actionAllowed(action)) break;
                    return null;
                }
                case TRIGGER: {
                    ZCalendar.ZParameter valueType = prop.getParameter(ZCalendar.ICalTok.VALUE);
                    if (valueType != null) {
                        String vt = valueType.getValue();
                        if (ZCalendar.ICalTok.DATE_TIME.toString().equals(vt)) {
                            triggerType = TriggerType.ABSOLUTE;
                        }
                    }
                    if (TriggerType.RELATIVE.equals((Object)triggerType)) {
                        String rel;
                        ZCalendar.ZParameter related = prop.getParameter(ZCalendar.ICalTok.RELATED);
                        if (related != null && (rel = related.getValue()) != null && (triggerRelated = TriggerRelated.lookup(rel)) == null) {
                            throw ServiceException.INVALID_REQUEST("Invalid RELATED value " + rel, null);
                        }
                        triggerRelative = ParsedDuration.parse(val);
                        break;
                    }
                    try {
                        if (val == null) continue block14;
                        triggerAbsolute = ParsedDateTime.parseUtcOnly(val);
                        break;
                    }
                    catch (ParseException e) {
                        throw ServiceException.INVALID_REQUEST("Invalid TRIGGER value " + val, e);
                    }
                }
                case DURATION: {
                    if (val == null) break;
                    repeatDuration = ParsedDuration.parse(val);
                    break;
                }
                case REPEAT: {
                    if (val == null) break;
                    try {
                        repeatCount = Integer.parseInt(val);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ServiceException.INVALID_REQUEST("Invalid REPEAT value " + val, e);
                    }
                }
                case DESCRIPTION: {
                    description = val;
                    break;
                }
                case SUMMARY: {
                    summary = val;
                    break;
                }
                case ATTACH: {
                    attach = Attach.parse(prop);
                    break;
                }
                case ATTENDEE: {
                    ZAttendee attendee = new ZAttendee(prop);
                    if (attendees == null) {
                        attendees = new ArrayList<ZAttendee>();
                    }
                    attendees.add(attendee);
                }
            }
        }
        Alarm alarm = new Alarm(action, triggerType, triggerRelated, triggerRelative, triggerAbsolute, repeatDuration, repeatCount, description, summary, attach, attendees);
        for (ZCalendar.ZProperty xprop : xprops) {
            alarm.addXProp(xprop);
        }
        return alarm;
    }

    public Iterator<ZCalendar.ZProperty> xpropsIterator() {
        return this.mXProps.iterator();
    }

    public void addXProp(ZCalendar.ZProperty prop) {
        this.mXProps.add(prop);
    }

    public ZCalendar.ZProperty getXProperty(String xpropName) {
        for (ZCalendar.ZProperty prop : this.mXProps) {
            if (!prop.getName().equalsIgnoreCase(xpropName)) continue;
            return prop;
        }
        return null;
    }

    public static Alarm fromSimpleReminder(int minBeforeStart) throws ServiceException {
        return new Alarm(Action.DISPLAY, TriggerType.RELATIVE, TriggerRelated.START, ParsedDuration.parse(true, 0, 0, 0, minBeforeStart, 0), null, null, 0, null, null, null, null);
    }

    public static Alarm fromSimpleTime(ParsedDateTime time) throws ServiceException {
        return new Alarm(Action.DISPLAY, TriggerType.ABSOLUTE, null, null, time, null, 0, null, null, null, null);
    }

    private static String abbrevAction(Action action) {
        String str;
        switch (action) {
            case DISPLAY: {
                str = "d";
                break;
            }
            case AUDIO: {
                str = "a";
                break;
            }
            case EMAIL: {
                str = "e";
                break;
            }
            case PROCEDURE: {
                str = "p";
                break;
            }
            default: {
                str = action.toString();
            }
        }
        return str;
    }

    private static Action expandAction(String abbrev) {
        Action action;
        if (abbrev == null || abbrev.length() == 0) {
            return Action.DISPLAY;
        }
        char ch = abbrev.charAt(0);
        switch (ch) {
            case 'd': {
                action = Action.DISPLAY;
                break;
            }
            case 'a': {
                action = Action.AUDIO;
                break;
            }
            case 'e': {
                action = Action.EMAIL;
                break;
            }
            case 'p': {
                action = Action.PROCEDURE;
                break;
            }
            default: {
                action = Action.lookup(abbrev);
                if (action != null) break;
                action = Action.DISPLAY;
            }
        }
        return action;
    }

    private static String abbrevTriggerType(TriggerType tt) {
        if (tt == null || TriggerType.RELATIVE.equals((Object)tt)) {
            return "r";
        }
        return "a";
    }

    private static TriggerType expandTriggerType(String abbrev) {
        if (abbrev == null || abbrev.length() == 0) {
            return TriggerType.RELATIVE;
        }
        char ch = abbrev.charAt(0);
        if (ch == 'a') {
            return TriggerType.ABSOLUTE;
        }
        return TriggerType.RELATIVE;
    }

    private static String abbrevTriggerRelated(TriggerRelated tr) {
        if (tr == null) {
            return null;
        }
        if (TriggerRelated.END.equals((Object)tr)) {
            return "e";
        }
        return "s";
    }

    private static TriggerRelated expandTriggerRelated(String abbrev) {
        if (abbrev == null || abbrev.length() == 0) {
            return null;
        }
        char ch = abbrev.charAt(0);
        if (ch == 'e') {
            return TriggerRelated.END;
        }
        return TriggerRelated.START;
    }

    public Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_ACTION, Alarm.abbrevAction(this.mAction));
        meta.put(FN_TRIGGER_TYPE, Alarm.abbrevTriggerType(this.mTriggerType));
        if (TriggerType.RELATIVE.equals((Object)this.mTriggerType)) {
            meta.put(FN_TRIGGER_RELATED, Alarm.abbrevTriggerRelated(this.mTriggerRelated));
            meta.put(FN_TRIGGER_RELATIVE, this.mTriggerRelative.toString());
        } else {
            meta.put(FN_TRIGGER_ABSOLUTE, this.mTriggerAbsolute.getDateTimePartString(false));
        }
        if (this.mRepeatDuration != null) {
            meta.put(FN_REPEAT_DURATION, this.mRepeatDuration.toString());
            meta.put(FN_REPEAT_COUNT, this.mRepeatCount);
        }
        meta.put(FN_DESCRIPTION, this.mDescription);
        meta.put(FN_SUMMARY, this.mSummary);
        if (this.mAttach != null) {
            meta.put(FN_ATTACH, this.mAttach.encodeMetadata());
        }
        if (this.mAttendees != null) {
            meta.put(FN_NUM_ATTENDEES, this.mAttendees.size());
            int i = 0;
            for (ZAttendee at : this.mAttendees) {
                meta.put(FN_ATTENDEE + i, at.encodeAsMetadata());
                ++i;
            }
        }
        if (this.mXProps.size() > 0) {
            Util.encodeXPropsAsMetadata(meta, this.xpropsIterator());
        }
        return meta;
    }

    public static Alarm decodeMetadata(Metadata meta) throws ServiceException {
        Action action = Alarm.expandAction(meta.get(FN_ACTION));
        if (!Alarm.actionAllowed(action)) {
            return null;
        }
        TriggerType tt = Alarm.expandTriggerType(meta.get(FN_TRIGGER_TYPE));
        TriggerRelated triggerRelated = null;
        ParsedDuration triggerRelative = null;
        ParsedDateTime triggerAbsolute = null;
        if (TriggerType.ABSOLUTE.equals((Object)tt)) {
            try {
                triggerAbsolute = ParsedDateTime.parseUtcOnly(meta.get(FN_TRIGGER_ABSOLUTE));
            }
            catch (ParseException e) {
                throw ServiceException.FAILURE("Error parsing metadata for alarm", e);
            }
        } else {
            triggerRelative = ParsedDuration.parse(meta.get(FN_TRIGGER_RELATIVE));
            triggerRelated = Alarm.expandTriggerRelated(meta.get(FN_TRIGGER_RELATED, null));
        }
        ParsedDuration repeatDuration = null;
        int repeatCount = 0;
        String val = meta.get(FN_REPEAT_DURATION, null);
        if (val != null) {
            repeatDuration = ParsedDuration.parse(val);
            repeatCount = (int)meta.getLong(FN_REPEAT_COUNT, 0L);
        }
        String description = meta.get(FN_DESCRIPTION, null);
        String summary = meta.get(FN_SUMMARY, null);
        Attach attach = null;
        Metadata metaAttach = meta.getMap(FN_ATTACH, true);
        if (metaAttach != null) {
            attach = Attach.decodeMetadata(metaAttach);
        }
        int numAts = (int)meta.getLong(FN_NUM_ATTENDEES, 0L);
        ArrayList<ZAttendee> attendees = new ArrayList<ZAttendee>(numAts);
        for (int i = 0; i < numAts; ++i) {
            try {
                Metadata metaAttendee = meta.getMap(FN_ATTENDEE + i, true);
                if (metaAttendee == null) continue;
                attendees.add(new ZAttendee(metaAttendee));
                continue;
            }
            catch (ServiceException e) {
                ZimbraLog.calendar.warn("Problem decoding attendee " + i + " in ALARM ");
            }
        }
        Alarm alarm = new Alarm(action, tt, triggerRelated, triggerRelative, triggerAbsolute, repeatDuration, repeatCount, description, summary, attach, attendees);
        List<ZCalendar.ZProperty> xprops = Util.decodeXPropsFromMetadata(meta);
        if (xprops != null) {
            for (ZCalendar.ZProperty xprop : xprops) {
                alarm.addXProp(xprop);
            }
        }
        return alarm;
    }

    public long getTriggerTime(long instStart, long instEnd) {
        if (TriggerType.ABSOLUTE.equals((Object)this.mTriggerType)) {
            assert (this.mTriggerAbsolute != null);
            return this.mTriggerAbsolute.getUtcTime();
        }
        if (TriggerRelated.END.equals((Object)this.mTriggerRelated)) {
            return this.mTriggerRelative.addToTime(instEnd);
        }
        return this.mTriggerRelative.addToTime(instStart);
    }

    public ParsedDuration getTriggerRelative() {
        return this.mTriggerRelative;
    }

    public ParsedDateTime getTriggerAbsolute() {
        return this.mTriggerAbsolute;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TriggerRelated {
        START,
        END;


        public static TriggerRelated lookup(String str) {
            if (str != null) {
                try {
                    str = str.replace('-', '_').toUpperCase();
                    return TriggerRelated.valueOf(str);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TriggerType {
        RELATIVE,
        ABSOLUTE;


        public static TriggerType lookup(String str) {
            if (str != null) {
                try {
                    str = str.replace('-', '_').toUpperCase();
                    return TriggerType.valueOf(str);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        DISPLAY,
        AUDIO,
        EMAIL,
        PROCEDURE,
        X_YAHOO_CALENDAR_ACTION_IM,
        X_YAHOO_CALENDAR_ACTION_MOBILE;


        public static Action lookup(String str) {
            if (str != null) {
                try {
                    str = str.replace('-', '_').toUpperCase();
                    return Action.valueOf(str);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        public String toString() {
            return super.toString().replace('_', '-');
        }
    }
}

