/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.acl;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.acl.EffectiveACLCache;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.util.ItemId;
import java.io.IOException;

public class FolderACL {
    OperationContext mOctxt;
    ShareTarget mShareTarget;

    public FolderACL(OperationContext octxt, String ownerAcctId, int folderId) throws ServiceException {
        this.mOctxt = octxt;
        this.mShareTarget = new ShareTarget(ownerAcctId, folderId);
    }

    public short getEffectivePermissions() throws ServiceException {
        short rightsNeeded = -1;
        return this.checkRights(rightsNeeded);
    }

    public boolean canAccess(short rightsNeeded) throws ServiceException {
        short hasRights = this.checkRights(rightsNeeded);
        return (hasRights & rightsNeeded) == rightsNeeded;
    }

    private short checkRights(short rightsNeeded) throws ServiceException {
        return this.checkRights(rightsNeeded, this.getAuthenticatedAccount(), this.isUsingAdminPrivileges());
    }

    private Account getAuthenticatedAccount() throws ServiceException {
        Account authuser = null;
        if (this.mOctxt != null) {
            authuser = this.mOctxt.getAuthenticatedUser();
        }
        if (authuser != null && authuser.getId().equals(this.mShareTarget.getAccountId())) {
            authuser = null;
        }
        return authuser;
    }

    private boolean isUsingAdminPrivileges() {
        return this.mOctxt != null && this.mOctxt.isUsingAdminPrivileges();
    }

    private short checkRights(short rightsNeeded, Account authuser, boolean asAdmin) throws ServiceException {
        if (rightsNeeded == 0) {
            return rightsNeeded;
        }
        if (authuser == null || authuser.getId().equals(this.mShareTarget.getAccountId())) {
            return rightsNeeded;
        }
        if (AccessManager.getInstance().canAccessAccount(authuser, this.mShareTarget.getAccount(), asAdmin)) {
            return rightsNeeded;
        }
        Short granted = null;
        ACL rights = this.getEffectiveACLFromCache();
        granted = rights != null ? rights.getGrantedRights(authuser) : this.getEffectivePermissionsFromServer();
        if (granted != null) {
            return (short)(granted & rightsNeeded);
        }
        return 0;
    }

    private ACL getEffectiveACLFromCache() throws ServiceException {
        return EffectiveACLCache.get(this.mShareTarget.getAccountId(), this.mShareTarget.getFolderId());
    }

    private Short getEffectivePermissionsFromServer() throws ServiceException {
        if (this.mShareTarget.onLocalServer()) {
            return this.getEffectivePermissionsLocal();
        }
        return this.getEffectivePermissionsRemote();
    }

    private Short getEffectivePermissionsLocal() throws ServiceException {
        Mailbox ownerMbx = MailboxManager.getInstance().getMailboxByAccountId(this.mShareTarget.getAccountId(), false);
        Folder folder = ownerMbx.getFolderById(null, this.mShareTarget.getFolderId());
        return FolderACL.getEffectivePermissionsLocal(this.mOctxt, ownerMbx, folder);
    }

    public static Short getEffectivePermissionsLocal(OperationContext octxt, Mailbox ownerMbx, Folder folder) throws ServiceException {
        ACL acl = folder.getEffectiveACL();
        EffectiveACLCache.put(folder.getAccount().getId(), folder.getId(), acl);
        return ownerMbx.getEffectivePermissions(octxt, folder.getId(), (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Short getEffectivePermissionsRemote() throws ServiceException {
        Short perms;
        block7: {
            Element.XMLElement request = new Element.XMLElement(MailConstants.GET_EFFECTIVE_FOLDER_PERMS_REQUEST);
            ItemId iid = new ItemId(this.mShareTarget.getAccountId(), this.mShareTarget.getFolderId());
            ((Element)request).addElement("folder").addAttribute("l", iid.toString((Account)null));
            Server server = Provisioning.getInstance().getServer(this.mShareTarget.getAccount());
            String url = URLUtil.getSoapURL(server, false);
            SoapHttpTransport transport = new SoapHttpTransport(url);
            AuthToken authToken = null;
            if (this.mOctxt != null) {
                authToken = this.mOctxt.getAuthToken();
            }
            if (authToken == null) {
                authToken = AuthProvider.getAuthToken(ACL.ANONYMOUS_ACCT);
            }
            transport.setAuthToken(authToken.toZAuthToken());
            transport.setTargetAcctId(this.mShareTarget.getAccountId());
            perms = null;
            try {
                try {
                    Element response = transport.invoke(request);
                    Element eFolder = response.getElement("folder");
                    String permsStr = eFolder.getAttribute("perm");
                    perms = ACL.stringToRights(permsStr);
                }
                catch (ServiceException e) {
                    ZimbraLog.misc.warn((Object)("cannot get effective perms from server " + server.getName()), e);
                    Object var12_14 = null;
                    transport.shutdown();
                    break block7;
                }
                catch (IOException e) {
                    ZimbraLog.misc.warn((Object)("cannot get effective perms from server " + server.getName()), e);
                    Object var12_15 = null;
                    transport.shutdown();
                }
                Object var12_13 = null;
                transport.shutdown();
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                transport.shutdown();
                throw throwable;
            }
        }
        return perms;
    }

    private static class ShareTarget {
        private Account mOwnerAcct;
        int mFolderId;

        private ShareTarget(String ownerAcctId, int folderId) throws ServiceException {
            this.mOwnerAcct = Provisioning.getInstance().get(Provisioning.AccountBy.id, ownerAcctId);
            if (this.mOwnerAcct == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(ownerAcctId);
            }
            this.mFolderId = folderId;
        }

        private Account getAccount() {
            return this.mOwnerAcct;
        }

        private String getAccountId() {
            return this.mOwnerAcct.getId();
        }

        int getFolderId() {
            return this.mFolderId;
        }

        boolean onLocalServer() throws ServiceException {
            return Provisioning.onLocalServer(this.mOwnerAcct);
        }
    }
}

