/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.acl;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.memcached.MemcachedMap;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.acl.EffectiveACLCacheKey;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.session.PendingModifications;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EffectiveACLCache {
    private static EffectiveACLCache sTheInstance = new EffectiveACLCache();
    private MemcachedMap<EffectiveACLCacheKey, ACL> mMemcachedLookup;

    public static EffectiveACLCache getInstance() {
        return sTheInstance;
    }

    EffectiveACLCache() {
        ZimbraMemcachedClient memcachedClient = MemcachedConnector.getClient();
        ACLSerializer serializer = new ACLSerializer();
        this.mMemcachedLookup = new MemcachedMap(memcachedClient, serializer);
    }

    private ACL get(EffectiveACLCacheKey key) throws ServiceException {
        return this.mMemcachedLookup.get(key);
    }

    private void put(EffectiveACLCacheKey key, ACL data) throws ServiceException {
        this.mMemcachedLookup.put(key, data);
    }

    public static ACL get(String acctId, int folderId) throws ServiceException {
        EffectiveACLCacheKey key = new EffectiveACLCacheKey(acctId, folderId);
        return sTheInstance.get(key);
    }

    public static void put(String acctId, int folderId, ACL acl) throws ServiceException {
        EffectiveACLCacheKey key = new EffectiveACLCacheKey(acctId, folderId);
        if (acl == null) {
            acl = new ACL();
        }
        sTheInstance.put(key, acl);
    }

    public void purgeMailbox(Mailbox mbox) throws ServiceException {
        String accountId = mbox.getAccountId();
        List<Folder> folders = mbox.getFolderList(null, SortBy.NONE);
        ArrayList<EffectiveACLCacheKey> keys = new ArrayList<EffectiveACLCacheKey>(folders.size());
        for (Folder folder : folders) {
            EffectiveACLCacheKey key = new EffectiveACLCacheKey(accountId, folder.getId());
            keys.add(key);
        }
        this.mMemcachedLookup.removeMulti(keys);
    }

    public void notifyCommittedChanges(PendingModifications mods, int changeId) {
        HashSet<EffectiveACLCacheKey> keysToInvalidate = new HashSet<EffectiveACLCacheKey>();
        if (mods.modified != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.modified.entrySet()) {
                PendingModifications.Change change = (PendingModifications.Change)entry.getValue();
                Object whatChanged = change.what;
                if (!(whatChanged instanceof Folder) || (change.why & 0x200100) == 0) continue;
                Folder folder = (Folder)whatChanged;
                String acctId = folder.getMailbox().getAccountId();
                List<Folder> subfolders = folder.getSubfolderHierarchy();
                for (Folder subf : subfolders) {
                    EffectiveACLCacheKey key = new EffectiveACLCacheKey(acctId, subf.getId());
                    keysToInvalidate.add(key);
                }
            }
        }
        if (mods.deleted != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.deleted.entrySet()) {
                String acctId;
                Object deletedObj = entry.getValue();
                if (deletedObj instanceof Folder) {
                    Folder folder = (Folder)deletedObj;
                    EffectiveACLCacheKey key = new EffectiveACLCacheKey(folder.getMailbox().getAccountId(), folder.getId());
                    keysToInvalidate.add(key);
                    continue;
                }
                if (!(deletedObj instanceof Integer) || (acctId = entry.getKey().getAccountId()) == null) continue;
                int itemId = (Integer)deletedObj;
                EffectiveACLCacheKey key = new EffectiveACLCacheKey(acctId, itemId);
                keysToInvalidate.add(key);
            }
        }
        try {
            this.mMemcachedLookup.removeMulti(keysToInvalidate);
        }
        catch (ServiceException e) {
            ZimbraLog.calendar.warn((Object)"Unable to notify folder acl cache.  Some cached data may become stale.", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ACLSerializer
    implements MemcachedSerializer<ACL> {
        private ACLSerializer() {
        }

        @Override
        public Object serialize(ACL value) {
            return value.encode().toString();
        }

        @Override
        public ACL deserialize(Object obj) throws ServiceException {
            MetadataList meta = new MetadataList((String)obj);
            return new ACL(meta);
        }
    }
}

