/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.MetadataCallback;
import com.zimbra.cs.mailbox.SenderList;
import com.zimbra.cs.mailbox.Tag;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualConversation
extends Conversation {
    VirtualConversation(Mailbox mbox, Message msg) throws ServiceException {
        super(mbox, VirtualConversation.wrapMessage(msg));
    }

    public int getMessageId() {
        return -this.mId;
    }

    @Override
    boolean loadSenderList() throws ServiceException {
        this.mSenderList = new SenderList(this.getMessage());
        return false;
    }

    @Override
    SenderList recalculateMetadata(List<Message> msgs) throws ServiceException {
        Message msg = msgs.get(0);
        this.mData = VirtualConversation.wrapMessage(msg);
        this.mExtendedData = MetadataCallback.duringConversationAdd(null, msg);
        return this.getSenderList();
    }

    Message getMessage() throws ServiceException {
        return this.mMailbox.getMessageById(this.getMessageId());
    }

    @Override
    List<Message> getMessages(SortBy sort) throws ServiceException {
        ArrayList<Message> msgs = new ArrayList<Message>(1);
        msgs.add(this.getMessage());
        return msgs;
    }

    static VirtualConversation create(Mailbox mbox, Message msg) throws ServiceException {
        VirtualConversation vconv = new VirtualConversation(mbox, msg);
        mbox.markItemCreated(vconv);
        return vconv;
    }

    private static MailItem.UnderlyingData wrapMessage(Message msg) {
        MailItem.CustomMetadata.CustomMetadataList extended = MetadataCallback.duringConversationAdd(null, msg);
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = -msg.getId();
        data.type = (byte)12;
        data.folderId = 9;
        data.subject = msg.getSubject();
        data.date = (int)(msg.getDate() / 1000L);
        data.modMetadata = msg.getSavedSequence();
        data.modContent = msg.getSavedSequence();
        data.size = 1L;
        data.unreadCount = msg.getUnreadCount();
        data.flags = msg.getInternalFlagBitmask();
        data.tags = msg.getTagBitmask();
        data.metadata = VirtualConversation.encodeMetadata(DEFAULT_COLOR_RGB, 1, extended, new SenderList(msg));
        return data;
    }

    @Override
    void open(String hash) throws ServiceException {
        DbMailItem.openConversation(hash, this.getMessage());
    }

    @Override
    void close(String hash) throws ServiceException {
        DbMailItem.closeConversation(hash, this.getMessage());
    }

    @Override
    void alterTag(Tag tag, boolean add) throws ServiceException {
        this.getMessage().alterTag(tag, add);
    }

    @Override
    protected void inheritedTagChanged(Tag tag, boolean add) throws ServiceException {
        if (tag == null || add == this.isTagged(tag)) {
            return;
        }
        this.markItemModified(tag instanceof Flag ? 4 : 2);
        this.tagChanged(tag, add);
    }

    @Override
    protected void inheritedCustomDataChanged(Message msg, MailItem.CustomMetadata custom) {
        this.markItemModified(524288);
        this.mExtendedData = MetadataCallback.duringConversationAdd(null, msg);
    }

    @Override
    void addChild(MailItem child) throws ServiceException {
        throw MailServiceException.CANNOT_PARENT();
    }

    @Override
    void removeChild(MailItem child) throws ServiceException {
        if (child.getId() != this.getMessageId()) {
            throw MailServiceException.IS_NOT_CHILD();
        }
        this.markItemDeleted();
        this.mMailbox.uncache(this);
    }
}

