/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.redolog.op.CreateCalendarItemPlayer;
import com.zimbra.cs.redolog.op.CreateCalendarItemRecorder;
import javax.mail.internet.MimeMessage;

public class Task
extends CalendarItem {
    public Task(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
        if (this.mData.type != 15) {
            throw new IllegalArgumentException();
        }
    }

    protected String processPartStat(Invite invite, MimeMessage mmInv, boolean forCreate, String defaultPartStat) throws ServiceException {
        Invite defaultInvite;
        String p;
        Mailbox mbox = this.getMailbox();
        OperationContext octxt = mbox.getOperationContext();
        CreateCalendarItemPlayer player = octxt != null ? (CreateCalendarItemPlayer)((Object)octxt.getPlayer()) : null;
        String partStat = defaultPartStat;
        if (player != null && (p = player.getCalendarItemPartStat()) != null) {
            partStat = p;
        }
        CreateCalendarItemRecorder recorder = (CreateCalendarItemRecorder)((Object)mbox.getRedoRecorder());
        recorder.setCalendarItemPartStat(partStat);
        Account account = this.getMailbox().getAccount();
        invite.updateMyPartStat(account, partStat);
        if (forCreate && (defaultInvite = this.getDefaultInviteOrNull()) != null && !defaultInvite.equals(invite) && !partStat.equals(defaultInvite.getPartStat())) {
            defaultInvite.updateMyPartStat(account, partStat);
            this.saveMetadata();
        }
        return partStat;
    }
}

