/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.filter.RuleManager;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends MailItem {
    private static final String INVALID_PREFIX = "\\";

    Tag(Mailbox mbox, MailItem.UnderlyingData ud) throws ServiceException {
        super(mbox, ud);
        if (this.mData.type != 3 && this.mData.type != 10) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getSender() {
        return "";
    }

    public byte getIndex() {
        return Tag.getIndex(this.mId);
    }

    public static byte getIndex(int id) {
        return (byte)(id - 64);
    }

    public static boolean validateId(int id) {
        return id >= 64 && id < 127;
    }

    public long getBitmask() {
        return 1L << this.getIndex();
    }

    boolean canTag(MailItem item) {
        return item.isTaggable();
    }

    public static long tagsToBitmask(String csv) {
        long bitmask = 0L;
        if (csv != null && !csv.equals("")) {
            String[] tags = csv.split(",");
            for (int i = 0; i < tags.length; ++i) {
                int value = 0;
                try {
                    value = Integer.parseInt(tags[i]);
                }
                catch (NumberFormatException e) {
                    ZimbraLog.mailbox.error((Object)("unable to parse tags: '" + csv + "'"), e);
                    throw e;
                }
                if (!Tag.validateId(value)) continue;
                bitmask |= 1L << Tag.getIndex(value);
            }
        }
        return bitmask;
    }

    public static String bitmaskToTags(long bitmask) {
        if (bitmask == 0L) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; bitmask != 0L && i < 62; ++i) {
            if ((bitmask & 1L << i) == 0L) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(i + 64);
            bitmask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return sb.toString();
    }

    static List<Tag> bitmaskToTagList(Mailbox mbox, long bitmask) throws ServiceException {
        if (bitmask == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int i = 0; bitmask != 0L && i < 62; ++i) {
            if ((bitmask & 1L << i) == 0L) continue;
            tags.add(mbox.getTagById(i + 64));
            bitmask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return tags;
    }

    @Override
    boolean isTaggable() {
        return false;
    }

    @Override
    boolean isCopyable() {
        return false;
    }

    @Override
    boolean isMovable() {
        return false;
    }

    @Override
    boolean isMutable() {
        return true;
    }

    @Override
    boolean isIndexed() {
        return false;
    }

    @Override
    boolean canHaveChildren() {
        return false;
    }

    static Tag create(Mailbox mbox, int id, String name, MailItem.Color color) throws ServiceException {
        if (!Tag.validateId(id)) {
            throw MailServiceException.INVALID_ID(id);
        }
        Folder tagFolder = mbox.getFolderById(8);
        if (!tagFolder.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the necessary permissions");
        }
        name = Tag.validateItemName(name);
        try {
            mbox.getTagByName(name);
            throw MailServiceException.ALREADY_EXISTS(name, new ServiceException.Argument[0]);
        }
        catch (MailServiceException.NoSuchItemException nsie) {
            MailItem.UnderlyingData data = new MailItem.UnderlyingData();
            data.id = id;
            data.type = (byte)3;
            data.folderId = tagFolder.getId();
            data.date = mbox.getOperationTimestamp();
            data.name = name;
            data.subject = name;
            data.metadata = Tag.encodeMetadata(color, 1);
            data.contentChanged(mbox);
            ZimbraLog.mailop.info("Adding Tag %s: id=%d.", name, data.id);
            DbMailItem.create(mbox, data, null);
            Tag tag = new Tag(mbox, data);
            tag.finishCreation(null);
            return tag;
        }
    }

    @Override
    void alterUnread(boolean unread) throws ServiceException {
        if (unread) {
            throw ServiceException.INVALID_REQUEST("tags can only be marked read", null);
        }
        if (!this.canAccess((short)1)) {
            throw ServiceException.PERM_DENIED("you do not have the necessary permissions on the tag");
        }
        if (!this.isUnread()) {
            return;
        }
        ArrayList<Integer> targets = new ArrayList<Integer>();
        boolean missed = false;
        for (MailItem.UnderlyingData data : DbMailItem.getUnreadMessages(this)) {
            Message msg = this.mMailbox.getMessage(data);
            if (msg.checkChangeID() || !msg.canAccess((short)2)) {
                msg.updateUnread(unread ? 1 : -1);
                msg.mData.metadataChanged(this.mMailbox);
                targets.add(msg.getId());
                continue;
            }
            missed = true;
        }
        if (!missed) {
            DbMailItem.alterUnread(this, unread);
        } else {
            DbMailItem.alterUnread(this.mMailbox, targets, unread);
        }
    }

    static String validateItemName(String name) throws ServiceException {
        if ((name = MailItem.validateItemName(name == null ? null : name.trim())).startsWith(INVALID_PREFIX)) {
            throw MailServiceException.INVALID_NAME(name);
        }
        return name;
    }

    @Override
    void rename(String name, Folder target) throws ServiceException {
        String originalName = this.getName();
        super.rename(name, target);
        if (!originalName.equals(name)) {
            for (Folder folder : this.mMailbox.listAllFolders()) {
                if (folder.getItemCount() <= 0L) continue;
                folder.updateHighestMODSEQ();
            }
            RuleManager.tagRenamed(this.getAccount(), originalName, name);
        }
    }

    @Override
    void purgeCache(MailItem.PendingDelete info, boolean purgeItem) throws ServiceException {
        if (ZimbraLog.mailop.isDebugEnabled()) {
            ZimbraLog.mailop.debug("Removing %s from all items.", Tag.getMailopContext(this));
        }
        DbMailItem.clearTag(this);
        this.mMailbox.purge((byte)5);
        super.purgeCache(info, purgeItem);
    }

    protected void saveTagCounts() throws ServiceException {
        DbMailItem.persistCounts(this, this.encodeMetadata());
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        super.decodeMetadata(meta);
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return Tag.encodeMetadata(meta, this.mRGBColor, this.mVersion);
    }

    private static String encodeMetadata(MailItem.Color color, int version) {
        return Tag.encodeMetadata(new Metadata(), color, version).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version) {
        return MailItem.encodeMetadata(meta, color, version, null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("tag: {");
        this.appendCommonMembers(sb);
        sb.append("}");
        return sb.toString();
    }
}

