/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mime.ParsedAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenderList {
    private static final int MAX_PARTICIPANT_COUNT = 5;
    private ParsedAddress mFirst;
    private List<ParsedAddress> mParticipants;
    private boolean mIsElided;
    private long mLastDate;
    private int mSize;
    private static final String FN_EMAIL = "a";
    private static final String FN_PERSONAL = "p";
    private static final String FN_DISPLAY = "d";

    public SenderList() {
    }

    public SenderList(Message msg) {
        String sender = msg.getSender();
        if (sender != null && !sender.trim().equals("")) {
            this.mFirst = new ParsedAddress(sender).parse();
            this.mLastDate = msg.getDate();
        }
        this.mSize = 1;
    }

    public SenderList(List<Message> msgs) {
        this(msgs == null ? null : msgs.toArray(new Message[msgs.size()]));
    }

    public SenderList(Message[] msgs) {
        if (msgs == null || msgs.length == 0) {
            return;
        }
        Arrays.sort(msgs, new MailItem.SortDateAscending());
        this.mLastDate = msgs[msgs.length - 1].getDate();
        this.mSize = msgs.length;
        int first = 0;
        do {
            String sender;
            if ((sender = msgs[first].getSender()) == null || sender.trim().equals("")) continue;
            this.mFirst = new ParsedAddress(sender).parse();
        } while (this.mFirst == null && ++first < this.mSize);
        for (int i = msgs.length - 1; i >= first && !this.mIsElided; --i) {
            ParsedAddress pa;
            String sender = msgs[i].getSender();
            if (sender == null || sender.trim().equals("") || (pa = new ParsedAddress(sender).parse()).equals(this.mFirst) || this.mParticipants != null && this.mParticipants.contains(pa)) continue;
            if (this.mParticipants == null) {
                this.mParticipants = new ArrayList<ParsedAddress>(5);
                this.mParticipants.add(pa);
                continue;
            }
            if (this.mParticipants.size() >= 5) {
                this.mIsElided = true;
                continue;
            }
            this.mParticipants.add(pa);
        }
    }

    public SenderList add(Message msg) throws RefreshException {
        String sender = msg.getSender();
        if (sender == null || sender.trim().equals("")) {
            ++this.mSize;
            return this;
        }
        long date = msg.getDate();
        if (date < this.mLastDate) {
            throw new RefreshException("appended message predates existing last message");
        }
        this.mLastDate = date;
        ++this.mSize;
        ParsedAddress pa = new ParsedAddress(sender).parse();
        if (this.mFirst == null) {
            this.mFirst = pa;
        } else {
            if (pa.equals(this.mFirst)) {
                return this;
            }
            if (this.mParticipants == null) {
                this.mParticipants = new ArrayList<ParsedAddress>(5);
                this.mParticipants.add(pa);
            } else {
                this.mParticipants.remove(pa);
                this.mParticipants.add(0, pa);
                while (this.mParticipants.size() > 5) {
                    this.mParticipants.remove(5);
                    this.mIsElided = true;
                }
            }
        }
        return this;
    }

    public int size() {
        return this.mSize;
    }

    public boolean isElided() {
        return this.mIsElided;
    }

    public ParsedAddress getFirstAddress() {
        return this.mFirst;
    }

    public List<ParsedAddress> getLastAddresses() {
        if (this.mParticipants == null || this.mParticipants.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ParsedAddress> addrs = new ArrayList<ParsedAddress>(this.mParticipants);
        if (addrs.size() > 1) {
            Collections.reverse(addrs);
        }
        return addrs;
    }

    private static ParsedAddress importAddress(Metadata meta) {
        if (meta == null) {
            return null;
        }
        ParsedAddress pa = new ParsedAddress(meta.get(FN_EMAIL, null), meta.get(FN_PERSONAL, null));
        pa.firstName = meta.get(FN_DISPLAY, null);
        return pa;
    }

    public static SenderList parse(String encoded) throws ServiceException {
        return SenderList.parse(new Metadata(encoded));
    }

    public static SenderList parse(Metadata meta) throws ServiceException {
        SenderList sl = new SenderList();
        sl.mSize = (int)meta.getLong("no");
        sl.mLastDate = meta.getLong("ld", 0L);
        sl.mFirst = SenderList.importAddress(meta.getMap("f", true));
        sl.mIsElided = meta.getBool("X");
        MetadataList entries = meta.getList("en", true);
        if (entries != null && !entries.isEmpty()) {
            sl.mParticipants = new ArrayList<ParsedAddress>(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                sl.mParticipants.add(SenderList.importAddress(entries.getMap(i)));
            }
        }
        return sl;
    }

    private static Metadata exportAddress(ParsedAddress pa) {
        if (pa == null) {
            return null;
        }
        Metadata meta = new Metadata();
        meta.put(FN_EMAIL, pa.emailPart);
        meta.put(FN_PERSONAL, pa.personalPart);
        meta.put(FN_DISPLAY, pa.firstName);
        return meta;
    }

    public String toString() {
        Metadata meta = new Metadata();
        meta.put("no", this.mSize);
        meta.put("ld", this.mLastDate);
        meta.put("f", SenderList.exportAddress(this.mFirst));
        meta.put("X", this.mIsElided);
        if (this.mParticipants != null && !this.mParticipants.isEmpty()) {
            MetadataList entries = new MetadataList();
            for (ParsedAddress pa : this.mParticipants) {
                entries.add(SenderList.exportAddress(pa));
            }
            meta.put("en", entries);
        }
        return meta.toString();
    }

    public static class RefreshException
    extends Exception {
        private static final long serialVersionUID = 7137768259442997280L;

        public RefreshException(String message) {
            super(message);
        }
    }
}

