/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;

public class SearchFolder
extends Folder {
    private String mQuery;
    private String mTypes;
    private String mSort;
    private static final String CN_NAME = "name";
    private static final String CN_QUERY = "query";

    public SearchFolder(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
        if (this.mData.type != 2) {
            throw new IllegalArgumentException();
        }
    }

    public String getQuery() {
        return this.mQuery == null ? "" : this.mQuery;
    }

    public String getReturnTypes() {
        return this.mTypes == null ? "" : this.mTypes;
    }

    public String getSortField() {
        return this.mSort == null ? "" : this.mSort;
    }

    public boolean isImapVisible() {
        try {
            return this.mMailbox.getAccount().getBooleanAttr("zimbraPrefImapSearchFoldersEnabled", true);
        }
        catch (ServiceException e) {
            return true;
        }
    }

    boolean canContain(byte type) {
        return type == 2;
    }

    static SearchFolder create(int id, Folder parent, String name, String query, String types, String sort, int flags, MailItem.Color color, MailItem.CustomMetadata custom) throws ServiceException {
        if (parent == null || !parent.canContain((byte)2)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!parent.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the parent folder");
        }
        name = SearchFolder.validateItemName(name);
        query = SearchFolder.validateQuery(query);
        if (parent.findSubfolder(name) != null) {
            throw MailServiceException.ALREADY_EXISTS(name, new ServiceException.Argument[0]);
        }
        if (types != null && types.trim().equals("")) {
            types = null;
        }
        if (sort != null && sort.trim().equals("")) {
            sort = null;
        }
        Mailbox mbox = parent.getMailbox();
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = (byte)2;
        data.folderId = parent.getId();
        data.parentId = parent.getId();
        data.date = mbox.getOperationTimestamp();
        data.flags = flags;
        data.name = name;
        data.subject = name;
        data.metadata = SearchFolder.encodeMetadata(color, 1, custom, query, types, sort);
        data.contentChanged(mbox);
        ZimbraLog.mailop.info("Adding SearchFolder %s: id=%d, parentId=%d, parentName=%s.", name, data.id, parent.getId(), parent.getName());
        DbMailItem.create(mbox, data, null);
        SearchFolder search = new SearchFolder(mbox, data);
        search.finishCreation(parent);
        return search;
    }

    void changeQuery(String query, String types, String sort) throws ServiceException {
        if (!this.isMutable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the search folder");
        }
        if ((query = SearchFolder.validateQuery(query)).equals(this.mQuery) && this.getReturnTypes().equals(types) && this.getSortField().equals(sort)) {
            return;
        }
        this.markItemModified(32768);
        this.mQuery = query;
        this.mTypes = types;
        this.mSort = sort;
        this.saveMetadata();
    }

    protected static String validateQuery(String query) throws ServiceException {
        if (query != null) {
            query = StringUtil.stripControlCharacters(query).trim();
        }
        if (query == null || query.equals("")) {
            throw ServiceException.INVALID_REQUEST("search query must not be empty", null);
        }
        return query;
    }

    void decodeMetadata(Metadata meta) throws ServiceException {
        super.decodeMetadata(meta);
        this.mQuery = meta.get("q");
        this.mTypes = meta.get("t", null);
        this.mSort = meta.get("s", null);
    }

    Metadata encodeMetadata(Metadata meta) {
        return SearchFolder.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mQuery, this.mTypes, this.mSort);
    }

    private static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata custom, String query, String types, String sort) {
        MailItem.CustomMetadata.CustomMetadataList extended = custom == null ? null : custom.asList();
        return SearchFolder.encodeMetadata(new Metadata(), color, version, extended, query, types, sort).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, String query, String types, String sort) {
        meta.put("q", query);
        meta.put("t", types);
        meta.put("s", sort);
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("search: {");
        this.appendCommonMembers(sb).append(", ");
        sb.append(CN_NAME).append(": ").append(this.getName()).append(", ");
        sb.append(CN_QUERY).append(": ").append(this.getQuery());
        sb.append("}");
        return sb.toString();
    }
}

