/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ScheduledTaskCallback;
import com.zimbra.common.util.TaskScheduler;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbScheduledTask;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.ScheduledTask;
import java.util.Random;
import java.util.concurrent.Callable;

public class ScheduledTaskManager {
    private static TaskScheduler<Void> sScheduler;
    private static Random sRandom;

    public static void startup() throws ServiceException {
        if (sScheduler != null) {
            ZimbraLog.scheduler.info((Object)"Scheduled tasks have already been initialized", new Exception());
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        int numThreads = prov.getLocalServer().getIntAttr("zimbraScheduledTaskNumThreads", 20);
        int minThreads = numThreads / 2;
        sScheduler = new TaskScheduler(null, minThreads, numThreads);
        sScheduler.addCallback(new TaskCleanup());
        for (ScheduledTask task : DbScheduledTask.getTasks(null, 0L)) {
            try {
                if (task.getMailboxId() > 0L) {
                    MailboxManager.getInstance().getMailboxById(task.getMailboxId());
                }
                ScheduledTaskManager.schedule(null, task);
            }
            catch (ServiceException e) {
                ZimbraLog.scheduler.warn("Unable to schedule %s.", (Object)task, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(ScheduledTask task) throws ServiceException {
        DbPool.Connection conn = null;
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            try {
                conn = DbPool.getConnection();
                ScheduledTaskManager.schedule(conn, task);
                conn.commit();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
        }
    }

    public static void schedule(DbPool.Connection conn, ScheduledTask task) throws ServiceException {
        if (conn != null) {
            DbScheduledTask.createTask(conn, task);
        }
        if (task.isRecurring()) {
            long delay = Math.abs(sRandom.nextLong()) % task.getIntervalMillis();
            sScheduler.schedule(ScheduledTaskManager.getKey(task), task, true, task.getIntervalMillis(), delay);
        } else {
            if (task.getExecTime() == null) {
                throw ServiceException.FAILURE("Exec time not set for scheduled task.", null);
            }
            long delay = task.getExecTime().getTime() - System.currentTimeMillis();
            if (delay < 0L) {
                delay = 0L;
            }
            sScheduler.schedule(ScheduledTaskManager.getKey(task), task, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledTask cancel(String className, String taskName, long mailboxId, boolean mayInterruptIfRunning) throws ServiceException {
        DbPool.Connection conn = null;
        ScheduledTask task = null;
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            try {
                conn = DbPool.getConnection();
                task = ScheduledTaskManager.cancel(conn, className, taskName, mailboxId, mayInterruptIfRunning);
                conn.commit();
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
        }
        return task;
    }

    public static ScheduledTask cancel(DbPool.Connection conn, String className, String taskName, long mailboxId, boolean mayInterruptIfRunning) throws ServiceException {
        if (conn != null) {
            DbScheduledTask.deleteTask(conn, className, taskName);
        }
        return (ScheduledTask)sScheduler.cancel(ScheduledTaskManager.getKey(className, taskName, mailboxId), mayInterruptIfRunning);
    }

    private static String getKey(String className, String taskName, long mailboxId) {
        StringBuilder sb = new StringBuilder();
        sb.append(className).append(':').append(taskName);
        if (mailboxId > 0L) {
            sb.append(':').append(mailboxId);
        }
        return sb.toString();
    }

    private static String getKey(ScheduledTask task) {
        return ScheduledTaskManager.getKey(task.getClass().getName(), task.getName(), task.getMailboxId());
    }

    static {
        sRandom = new Random();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskCleanup
    implements ScheduledTaskCallback<Void> {
        TaskCleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void afterTaskRun(Callable<Void> c) {
            DbPool.Connection conn = null;
            ScheduledTask task = (ScheduledTask)c;
            if (task.isRecurring()) {
                return;
            }
            Object object = DbMailbox.getSynchronizer();
            synchronized (object) {
                block7: {
                    try {
                        try {
                            conn = DbPool.getConnection();
                            DbScheduledTask.deleteTask(conn, task.getClass().getName(), task.getName());
                            conn.commit();
                        }
                        catch (ServiceException e) {
                            ZimbraLog.scheduler.warn("Unable to clean up %s", (Object)task, e);
                            Object var7_6 = null;
                            DbPool.quietClose(conn);
                            break block7;
                        }
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        DbPool.quietClose(conn);
                        throw throwable;
                    }
                    DbPool.quietClose(conn);
                }
                return;
            }
        }
    }
}

