/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.lmtpserver.LmtpCallback;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.ParsedMessage;
import java.util.Date;
import java.util.HashMap;
import javax.mail.internet.MailDateFormat;

public class QuotaWarning
implements LmtpCallback {
    private static final QuotaWarning sInstance = new QuotaWarning();

    private QuotaWarning() {
    }

    public static QuotaWarning getInstance() {
        return sInstance;
    }

    public void afterDelivery(Account account, Mailbox mbox, String envelopeSender, String recipientEmail, Message newMessage) {
        try {
            int warnPercent = account.getIntAttr("zimbraQuotaWarnPercent", 90);
            long quota = account.getLongAttr("zimbraMailQuota", 0L);
            long warnInterval = account.getTimeInterval("zimbraQuotaWarnInterval", 86400000L);
            String template = account.getAttr("zimbraQuotaWarnMessage", null);
            Date lastWarnTime = account.getGeneralizedTimeAttr("zimbraQuotaLastWarnTime", null);
            Date now = new Date();
            ZimbraLog.lmtp.debug("Checking quota warning: mbox size=%d, quota=%d, lastWarnTime=%s, warnInterval=%d, warnPercent=%d", mbox.getSize(), quota, lastWarnTime, warnInterval, warnPercent);
            if (quota == 0L || warnPercent == 0) {
                return;
            }
            if (mbox.getSize() * 100L / quota < (long)warnPercent) {
                return;
            }
            if (lastWarnTime != null && now.getTime() - lastWarnTime.getTime() < warnInterval) {
                return;
            }
            if (template == null) {
                ZimbraLog.lmtp.warn("%s not specified.  Unable to send quota warning message.", "zimbraQuotaWarnMessage");
            }
            ZimbraLog.lmtp.info("Sending quota warning: mbox size=%d, quota=%d, lastWarnTime=%s, warnInterval=%dms, warnPercent=%d", mbox.getSize(), quota, lastWarnTime, warnInterval, warnPercent);
            String address = account.getAttr("zimbraMailDeliveryAddress");
            String domain = EmailUtil.getLocalPartAndDomain(address)[1];
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("RECIPIENT_NAME", account.getAttr("displayName"));
            vars.put("RECIPIENT_DOMAIN", domain);
            vars.put("RECIPIENT_ADDRESS", address);
            vars.put("DATE", new MailDateFormat().format(new Date()));
            vars.put("MBOX_SIZE_MB", String.format("%.2f", (double)mbox.getSize() / 1024.0 / 1024.0));
            vars.put("QUOTA_MB", String.format("%.2f", (double)quota / 1024.0 / 1024.0));
            vars.put("WARN_PERCENT", warnPercent);
            vars.put("NEWLINE", "\r\n");
            String msgBody = StringUtil.fillTemplate(template, vars);
            ParsedMessage pm = new ParsedMessage(msgBody.getBytes(), (Long)now.getTime(), false);
            mbox.addMessage(null, pm, 2, false, Flag.BITMASK_UNREAD | Flag.BITMASK_HIGH_PRIORITY, null);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraQuotaLastWarnTime", DateUtil.toGeneralizedTime(now));
            Provisioning.getInstance().modifyAttrs(account, attrs);
        }
        catch (Exception e) {
            ZimbraLog.lmtp.warn((Object)"Unable to send quota warning message", e);
        }
    }
}

