/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.util.Config;
import com.zimbra.cs.util.Zimbra;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeThread
extends Thread {
    private static volatile PurgeThread sPurgeThread = null;
    private static Object THREAD_CONTROL_LOCK = new Object();
    private boolean mShutdownRequested = false;
    private static long sSleepInterval = 0L;

    private PurgeThread() {
        this.setName("MailboxPurge");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startup() {
        Object object = THREAD_CONTROL_LOCK;
        synchronized (object) {
            if (PurgeThread.isRunning()) {
                ZimbraLog.purge.warn("Cannot start a second purge thread while another one is running.");
                return;
            }
            if (PurgeThread.getSleepInterval() == 0L) {
                ZimbraLog.purge.info("Not starting purge thread because %s is 0.", "zimbraMailPurgeSleepInterval");
                return;
            }
            try {
                String displayInterval = Provisioning.getInstance().getLocalServer().getAttr("zimbraMailPurgeSleepInterval", null);
                ZimbraLog.purge.info("Starting purge thread with sleep interval %s.", displayInterval);
            }
            catch (ServiceException e) {
                ZimbraLog.purge.warn("Unable to get %s.  Aborting thread startup.", (Object)"zimbraMailPurgeSleepInterval", e);
                return;
            }
            sPurgeThread = new PurgeThread();
            sPurgeThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isRunning() {
        Object object = THREAD_CONTROL_LOCK;
        synchronized (object) {
            return sPurgeThread != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown() {
        Object object = THREAD_CONTROL_LOCK;
        synchronized (object) {
            if (sPurgeThread != null) {
                sPurgeThread.requestShutdown();
                sPurgeThread.interrupt();
                sPurgeThread = null;
            } else {
                ZimbraLog.purge.debug("shutdown() called, but purge thread is not running.");
            }
        }
    }

    @Override
    public void run() {
        long sleepTime = LC.purge_initial_sleep_time.longValue();
        ZimbraLog.purge.info("Purge thread sleeping for %dms before doing work.", sleepTime);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            ZimbraLog.purge.info("Shutting down purge thread.");
            sPurgeThread = null;
            return;
        }
        while (true) {
            List<Long> mailboxIds = this.getMailboxIds();
            boolean slept = false;
            for (long mailboxId : mailboxIds) {
                if (this.mShutdownRequested) {
                    ZimbraLog.purge.info("Shutting down purge thread.");
                    sPurgeThread = null;
                    return;
                }
                ZimbraLog.addMboxToContext(mailboxId);
                boolean attemptedPurge = false;
                try {
                    MailboxManager mm = MailboxManager.getInstance();
                    if (mm.isMailboxLoadedAndAvailable(mailboxId)) {
                        attemptedPurge = true;
                        Mailbox mbox = mm.getMailboxById(mailboxId);
                        Account account = mbox.getAccount();
                        ZimbraLog.addAccountNameToContext(account.getName());
                        mbox.purgeMessages(null);
                        Config.setLong("purge.lastMailboxId", mbox.getId());
                    } else {
                        ZimbraLog.purge.debug("Skipping mailbox %d because it is not loaded into memory.", mailboxId);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof OutOfMemoryError) {
                        Zimbra.halt("Ran out of memory while purging mailboxes", t);
                    }
                    ZimbraLog.purge.warn("Unable to purge mailbox %d", (Object)mailboxId, t);
                }
                ZimbraLog.clearContext();
                if (!attemptedPurge) continue;
                this.sleep();
                slept = true;
            }
            if (slept) continue;
            this.sleep();
        }
    }

    private void sleep() {
        long interval = PurgeThread.getSleepInterval();
        ZimbraLog.purge.debug("Sleeping for %d milliseconds.", interval);
        if (interval > 0L) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                ZimbraLog.purge.debug("Purge thread was interrupted.");
                this.mShutdownRequested = true;
            }
        } else {
            this.mShutdownRequested = true;
        }
    }

    private void requestShutdown() {
        this.mShutdownRequested = true;
    }

    private static long getSleepInterval() {
        try {
            Provisioning prov = Provisioning.getInstance();
            Server server = prov.getLocalServer();
            sSleepInterval = server.getTimeInterval("zimbraMailPurgeSleepInterval", 0L);
        }
        catch (ServiceException e) {
            ZimbraLog.purge.warn("Unable to determine value of %s.  Using previous value: %d.", (Object)"zimbraMailPurgeSleepInterval", (Object)sSleepInterval, e);
        }
        return sSleepInterval;
    }

    private List<Long> getMailboxIds() {
        ArrayList<Long> mailboxIds = new ArrayList<Long>();
        try {
            for (long id : MailboxManager.getInstance().getMailboxIds()) {
                mailboxIds.add(id);
            }
            Collections.sort(mailboxIds);
            long lastId = Config.getLong("purge.lastMailboxId", 0L);
            for (int i = 0; i < mailboxIds.size(); ++i) {
                if ((Long)mailboxIds.get(i) <= lastId) continue;
                Collections.rotate(mailboxIds, -i);
                break;
            }
        }
        catch (ServiceException e) {
            ZimbraLog.purge.warn((Object)"Unable to get mailbox id's", e);
            return Collections.emptyList();
        }
        return mailboxIds;
    }
}

