/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class OperationContextData {
    protected OperationContext mOctxt;

    protected OperationContextData(OperationContext octxt) {
        this.mOctxt = octxt;
    }

    public static void addGranteeNames(OperationContext octxt, Mailbox.FolderNode node) {
        if (octxt == null || node == null) {
            return;
        }
        GranteeNames data = OperationContextData.getOrInitGranteeNames(octxt);
        data.addRootNode(node);
    }

    public static GranteeNames getGranteeNames(OperationContext octxt) {
        return octxt == null ? null : (GranteeNames)octxt.getCtxtData("GranteeNames");
    }

    public static void setNeedGranteeName(OperationContext octxt, boolean needGranteeName) {
        if (octxt == null) {
            return;
        }
        GranteeNames data = OperationContextData.getOrInitGranteeNames(octxt);
        data.setNeedGranteeName(needGranteeName);
    }

    public static boolean getNeedGranteeName(OperationContext octxt) {
        if (octxt == null) {
            return true;
        }
        GranteeNames data = OperationContextData.getGranteeNames(octxt);
        if (data == null) {
            return true;
        }
        return data.needGranteeName();
    }

    private static GranteeNames getOrInitGranteeNames(OperationContext octxt) {
        GranteeNames data = OperationContextData.getGranteeNames(octxt);
        if (data == null) {
            data = new GranteeNames(octxt);
            octxt.SetCtxtData("GranteeNames", data);
        }
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GranteeNames
    extends OperationContextData {
        private static final String KEY = "GranteeNames";
        private static final int USR_GRANTEES = 0;
        private static final int GRP_GRANTEES = 1;
        private static final int COS_GRANTEES = 2;
        private static final int DOM_GRANTEES = 3;
        private static final int NUM_GRANTEE_TYPES = 4;
        private boolean mEncounteredLDAPFailure = false;
        private boolean mNeedGranteeName = true;
        private Set<Mailbox.FolderNode> mUnresolvedRootNodes;
        private Set<Mailbox.FolderNode> mResolvedRootNodes;
        private Map<String, String>[] mIdsToNamesMap = new Map[4];
        public static final String EMPTY_NAME = "";
        public static final String INVALID_GRANT = new String("***INVALID***");

        private GranteeNames(OperationContext octxt) {
            super(octxt);
        }

        private void setNeedGranteeName(boolean needGranteeName) {
            this.mNeedGranteeName = needGranteeName;
        }

        private boolean needGranteeName() {
            return this.mNeedGranteeName;
        }

        private void addRootNode(Mailbox.FolderNode node) {
            if (this.mUnresolvedRootNodes == null) {
                this.mUnresolvedRootNodes = new HashSet<Mailbox.FolderNode>();
            }
            boolean alreadyResolved = false;
            if (this.mResolvedRootNodes != null) {
                for (Mailbox.FolderNode resolvedNode : this.mResolvedRootNodes) {
                    if (resolvedNode.mId != node.mId) continue;
                    alreadyResolved = true;
                    break;
                }
            }
            boolean alreadyAdded = false;
            for (Mailbox.FolderNode unresolvedNode : this.mUnresolvedRootNodes) {
                if (unresolvedNode.mId != node.mId) continue;
                alreadyAdded = true;
                break;
            }
            if (!alreadyResolved && !alreadyAdded) {
                this.mUnresolvedRootNodes.add(node);
            }
        }

        private void resolveIfNecessary() {
            if (this.mUnresolvedRootNodes == null || this.mUnresolvedRootNodes.isEmpty()) {
                return;
            }
            for (Mailbox.FolderNode unresolvedNode : this.mUnresolvedRootNodes) {
                Set[] idHolders = new Set[4];
                this.collectGranteeIds(unresolvedNode, idHolders);
                for (int bucket = 0; bucket < 4; ++bucket) {
                    if (idHolders[bucket] == null || this.mIdsToNamesMap[bucket] == null) continue;
                    idHolders[bucket] = SetUtil.subtract(idHolders[bucket], this.mIdsToNamesMap[bucket].keySet());
                }
                this.populateIdToNameMaps(idHolders);
            }
            if (this.mResolvedRootNodes == null) {
                this.mResolvedRootNodes = new HashSet<Mailbox.FolderNode>();
            }
            this.mResolvedRootNodes.addAll(this.mUnresolvedRootNodes);
            this.mUnresolvedRootNodes.clear();
        }

        private void populateIdToNameMaps(Set<String>[] idHolders) {
            Map<String, String> result = null;
            for (int bucket = 0; bucket < 4; ++bucket) {
                if (idHolders[bucket] == null || idHolders[bucket].isEmpty()) continue;
                try {
                    Provisioning.EntryType entryType = null;
                    if (bucket == 0) {
                        entryType = Provisioning.EntryType.account;
                    } else if (bucket == 1) {
                        entryType = Provisioning.EntryType.group;
                    } else if (bucket == 2) {
                        entryType = Provisioning.EntryType.cos;
                    } else if (bucket == 3) {
                        entryType = Provisioning.EntryType.domain;
                    }
                    if (entryType != null) {
                        result = Provisioning.getInstance().getNamesForIds(idHolders[bucket], entryType);
                    }
                }
                catch (ServiceException e) {
                    ZimbraLog.mailbox.warn((Object)"cannot lookup user grantee names", e);
                    this.mEncounteredLDAPFailure = true;
                }
                if (result == null) continue;
                if (this.mIdsToNamesMap[bucket] == null) {
                    this.mIdsToNamesMap[bucket] = result;
                    continue;
                }
                this.mIdsToNamesMap[bucket].putAll(result);
            }
        }

        private void collectGranteeIds(Mailbox.FolderNode node, Set<String>[] idHolders) {
            if (node.mFolder != null) {
                ACL acl = node.mFolder.getEffectiveACL();
                this.collectGranteeIdsOnACL(acl, idHolders);
            }
            for (Mailbox.FolderNode subNode : node.mSubfolders) {
                this.collectGranteeIds(subNode, idHolders);
            }
        }

        int getGranteeBucket(byte granteeType) {
            switch (granteeType) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
            }
            return -1;
        }

        private void collectGranteeIdsOnACL(ACL acl, Set<String>[] idHolders) {
            if (acl != null) {
                for (ACL.Grant grant : acl.getGrants()) {
                    int idx = this.getGranteeBucket(grant.getGranteeType());
                    if (idx == -1) continue;
                    if (idHolders[idx] == null) {
                        idHolders[idx] = new HashSet<String>();
                    }
                    idHolders[idx].add(grant.getGranteeId());
                }
            }
        }

        public String getNameById(String id, byte granteeType) {
            this.resolveIfNecessary();
            int idx = this.getGranteeBucket(granteeType);
            if (idx != -1) {
                if (this.mIdsToNamesMap[idx] == null) {
                    return null;
                }
                String name = this.mIdsToNamesMap[idx].get(id);
                if (name == null) {
                    if (this.mEncounteredLDAPFailure) {
                        return EMPTY_NAME;
                    }
                    return INVALID_GRANT;
                }
                return name;
            }
            return null;
        }
    }
}

