/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContextData;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.session.Session;
import java.util.HashMap;
import java.util.Map;

public class OperationContext {
    public static final boolean CHECK_CREATED = false;
    public static final boolean CHECK_MODIFIED = true;
    private Account authuser;
    private boolean isAdmin;
    private Session session;
    private RedoableOp player;
    private String requestIP;
    private String userAgent;
    private AuthToken authToken;
    private Map<String, OperationContextData> contextData;
    boolean changetype = false;
    int change = -1;

    public OperationContext(RedoableOp redoPlayer) {
        this.player = redoPlayer;
    }

    public OperationContext(Account acct) {
        this(acct, false);
    }

    public OperationContext(Mailbox mbox) throws ServiceException {
        this(mbox.getAccount());
    }

    public OperationContext(Account acct, boolean admin) {
        this.authuser = acct;
        this.isAdmin = admin;
    }

    public OperationContext(String accountId) throws ServiceException {
        this.authuser = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId);
        if (this.authuser == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(accountId);
        }
    }

    public OperationContext(AuthToken auth) throws ServiceException {
        this.authToken = auth;
        String accountId = auth.getAccountId();
        this.isAdmin = AuthToken.isAnyAdmin(auth);
        this.authuser = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId, this.authToken);
        if (this.authuser == null || !auth.isZimbraUser()) {
            this.authuser = auth.getDigest() != null || auth.getAccessKey() != null ? new ACL.GuestAccount(auth) : ACL.ANONYMOUS_ACCT;
        }
        if (this.authuser == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(accountId);
        }
    }

    public OperationContext(OperationContext octxt) {
        this.player = octxt.player;
        this.session = octxt.session;
        this.authuser = octxt.authuser;
        this.isAdmin = octxt.isAdmin;
        this.changetype = octxt.changetype;
        this.change = octxt.change;
        this.authToken = octxt.authToken;
    }

    public OperationContext setChangeConstraint(boolean checkModified, int changeId) {
        this.changetype = checkModified;
        this.change = changeId;
        return this;
    }

    public OperationContext unsetChangeConstraint() {
        this.changetype = false;
        this.change = -1;
        return this;
    }

    public OperationContext setSession(Session s) {
        this.session = s;
        return this;
    }

    Session getSession() {
        return this.session;
    }

    public RedoableOp getPlayer() {
        return this.player;
    }

    public long getTimestamp() {
        return this.player == null ? System.currentTimeMillis() : this.player.getTimestamp();
    }

    int getChangeId() {
        return this.player == null ? -1 : this.player.getChangeId();
    }

    public boolean needRedo() {
        return this.player == null || !this.player.getUnloggedReplay();
    }

    public Account getAuthenticatedUser() {
        return this.authuser;
    }

    public AuthToken getAuthToken() throws ServiceException {
        return this.getAuthToken(true);
    }

    public AuthToken getAuthToken(boolean constructIfNotPresent) throws ServiceException {
        if (this.authToken != null) {
            return this.authToken;
        }
        if (constructIfNotPresent && this.getAuthenticatedUser() != null) {
            return AuthProvider.getAuthToken(this.getAuthenticatedUser(), this.isUsingAdminPrivileges());
        }
        return null;
    }

    public boolean isUsingAdminPrivileges() {
        return this.isAdmin;
    }

    public boolean isDelegatedRequest(Mailbox mbox) {
        return this.authuser != null && !this.authuser.getId().equalsIgnoreCase(mbox.getAccountId());
    }

    public OperationContext setRequestIP(String addr) {
        this.requestIP = addr;
        return this;
    }

    public String getRequestIP() {
        return this.requestIP;
    }

    public OperationContext setUserAgent(String ua) {
        this.userAgent = ua;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    void SetCtxtData(String key, OperationContextData data) {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, OperationContextData>();
        }
        this.contextData.put(key, data);
    }

    OperationContextData getCtxtData(String key) {
        if (this.contextData == null) {
            return null;
        }
        return this.contextData.get(key);
    }
}

