/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.sun.mail.smtp.SMTPMessage;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbOutOfOffice;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.lmtpserver.LmtpCallback;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Notification
implements LmtpCallback {
    public static final long DEFAULT_OUT_OF_OFFICE_CACHE_DURATION_MILLIS = 604800000L;
    private static final int OUT_OF_OFFICE_DIRECT_CHECK_NUM_RECIPIENTS = 10;
    private static final Notification sInstance = new Notification();

    private Notification() {
    }

    public void afterDelivery(Account account, Mailbox mbox, String envelopeSender, String recipientEmail, Message newMessage) {
        try {
            this.notifyIfNecessary(account, newMessage, recipientEmail);
        }
        catch (MessagingException e) {
            ZimbraLog.mailbox.warn((Object)"Unable to send new mail notification", e);
        }
        catch (ServiceException e) {
            ZimbraLog.mailbox.warn((Object)"Unable to send new mail notification", e);
        }
        try {
            this.outOfOfficeIfNecessary(account, mbox, newMessage, recipientEmail, envelopeSender);
        }
        catch (MessagingException e) {
            ZimbraLog.mailbox.warn((Object)"Unable to send out-of-office reply", e);
        }
        catch (ServiceException e) {
            ZimbraLog.mailbox.warn((Object)"Unable to send out-of-office reply", e);
        }
    }

    public static Notification getInstance() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void outOfOfficeIfNecessary(Account account, Mailbox mbox, Message msg, String rcpt, String envSenderString) throws ServiceException, MessagingException {
        String[] precedence;
        InternetAddress envSender;
        String destination = null;
        boolean replyEnabled = account.getBooleanAttr("zimbraPrefOutOfOfficeReplyEnabled", false);
        if (ZimbraLog.mailbox.isDebugEnabled()) {
            ZimbraLog.mailbox.debug("outofoffice reply enabled=" + replyEnabled + " rcpt='" + rcpt + "' mid=" + msg.getId());
        }
        if (!replyEnabled) {
            return;
        }
        if (msg.inSpam()) {
            Notification.ofailed("in spam", destination, rcpt, msg);
            return;
        }
        if (msg.inTrash()) {
            Notification.ofailed("in trash", destination, rcpt, msg);
            return;
        }
        Date now = new Date();
        Date fromDate = account.getGeneralizedTimeAttr("zimbraPrefOutOfOfficeFromDate", null);
        if (fromDate != null && now.before(fromDate)) {
            Notification.ofailed("from date not reached", destination, rcpt, msg);
            return;
        }
        Date untilDate = account.getGeneralizedTimeAttr("zimbraPrefOutOfOfficeUntilDate", null);
        if (untilDate != null && now.after(untilDate)) {
            Notification.ofailed("until date reached", destination, rcpt, msg);
            return;
        }
        MimeMessage mm = msg.getMimeMessage();
        if (envSenderString == null) {
            Notification.ofailed("envelope sender null", destination, rcpt, msg);
            return;
        }
        if (envSenderString.length() < 1) {
            Notification.ofailed("envelope sender empty", destination, rcpt, msg);
            return;
        }
        try {
            envSender = new InternetAddress(envSenderString, true);
        }
        catch (AddressException ae) {
            Notification.ofailed("envelope sender invalid", envSenderString, rcpt, msg, (Exception)((Object)ae));
            return;
        }
        destination = envSender.getAddress();
        String[] autoSubmitted = mm.getHeader("Auto-Submitted");
        if (autoSubmitted != null) {
            for (int i = 0; i < autoSubmitted.length; ++i) {
                if (autoSubmitted[i].equalsIgnoreCase("no")) continue;
                Notification.ofailed("auto-submitted not no", destination, rcpt, msg);
                return;
            }
        }
        if (Notification.hasPrecedence(precedence = mm.getHeader("Precedence"), "bulk")) {
            Notification.ofailed("precedence bulk", destination, rcpt, msg);
            return;
        }
        if (Notification.hasPrecedence(precedence, "junk")) {
            Notification.ofailed("precedence junk", destination, rcpt, msg);
            return;
        }
        if (Notification.hasPrecedence(precedence, "list")) {
            Notification.ofailed("precedence list", destination, rcpt, msg);
            return;
        }
        String[] envSenderAddrParts = EmailUtil.getLocalPartAndDomain(destination);
        if (envSenderAddrParts == null) {
            Notification.ofailed("envelope sender invalid", destination, rcpt, msg);
            return;
        }
        String envSenderLocalPart = envSenderAddrParts[0];
        if ((envSenderLocalPart = envSenderLocalPart.toLowerCase()).startsWith("owner-") || envSenderLocalPart.endsWith("-owner")) {
            Notification.ofailed("envelope sender has owner- or -owner", destination, rcpt, msg);
            return;
        }
        if (envSenderLocalPart.indexOf("-request") != -1) {
            Notification.ofailed("envelope sender contains -request", destination, rcpt, msg);
            return;
        }
        if (envSenderLocalPart.equals("mailer-daemon")) {
            Notification.ofailed("envelope sender is mailer-daemon", destination, rcpt, msg);
            return;
        }
        if (envSenderLocalPart.equals("majordomo")) {
            Notification.ofailed("envelope sender is majordomo", destination, rcpt, msg);
            return;
        }
        if (envSenderLocalPart.equals("listserv")) {
            Notification.ofailed("envelope sender is listserv", destination, rcpt, msg);
            return;
        }
        String ct = mm.getContentType();
        if (ct != null && ct.equalsIgnoreCase("multipart/report")) {
            Notification.ofailed("content-type multipart/report", destination, rcpt, msg);
            return;
        }
        String[] otherAccountAddrs = account.getMultiAttr("zimbraPrefOutOfOfficeDirectAddress");
        if (!AccountUtil.isDirectRecipient(account, otherAccountAddrs, mm, 10)) {
            Notification.ofailed("not direct", destination, rcpt, msg);
            return;
        }
        Object object = DbMailbox.getZimbraSynchronizer(mbox);
        synchronized (object) {
            DbPool.Connection conn;
            block42: {
                conn = null;
                try {
                    conn = DbPool.getConnection(mbox);
                    if (!DbOutOfOffice.alreadySent(conn, mbox, destination, account.getTimeInterval("zimbraPrefOutOfOfficeCacheDuration", 604800000L))) break block42;
                    Notification.ofailed("already sent", destination, rcpt, msg);
                    Object var22_24 = null;
                }
                catch (Throwable throwable) {
                    Object var22_26 = null;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
                return;
            }
            Object var22_25 = null;
            DbPool.quietClose(conn);
        }
        try {
            InternetAddress fromAddress;
            SMTPMessage out = new SMTPMessage(JMSession.getSession());
            String prefAddress = account.getPrefFromAddress();
            if (prefAddress != null) {
                fromAddress = new InternetAddress(prefAddress);
                String prefDisplay = account.getPrefFromDisplay();
                if (prefDisplay != null) {
                    try {
                        fromAddress.setPersonal(prefDisplay, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw ServiceException.FAILURE("Unable to set From address", e);
                    }
                }
            } else {
                fromAddress = AccountUtil.getFriendlyEmailAddress(account);
            }
            out.setFrom((Address)fromAddress);
            String replyTo = account.getAttr("zimbraPrefReplyToAddress");
            if (replyTo != null && !replyTo.trim().equals("")) {
                out.setHeader("Reply-To", replyTo);
            }
            out.setRecipient(Message.RecipientType.TO, (Address)envSender);
            out.setSentDate(new Date());
            String subject = "Re: " + msg.getSubject();
            String charset = this.getCharset(account, subject);
            out.setSubject(subject, charset);
            String messageId = mm.getMessageID();
            if (messageId != null && !messageId.trim().equals("")) {
                out.setHeader("In-Reply-To", messageId);
            }
            out.setHeader("Auto-Submitted", "auto-replied (zimbra; vacation)");
            out.setHeader("Precedence", "bulk");
            String body = account.getAttr("zimbraPrefOutOfOfficeReply", "");
            charset = this.getCharset(account, body);
            out.setText(body, charset);
            if (Provisioning.getInstance().getConfig().getBooleanAttr("zimbraAutoSubmittedNullReturnPath", true)) {
                out.setEnvelopeFrom("<>");
            } else {
                out.setEnvelopeFrom(account.getName());
            }
            MailSender sender = mbox.getMailSender();
            sender.setSaveToSent(false);
            sender.sendMimeMessage(null, mbox, (MimeMessage)out);
            ZimbraLog.mailbox.info("outofoffice sent dest='" + destination + "' rcpt='" + rcpt + "' mid=" + msg.getId());
            Object object2 = DbMailbox.getZimbraSynchronizer(mbox);
            synchronized (object2) {
                DbPool.Connection conn = null;
                try {
                    conn = DbPool.getConnection(mbox);
                    DbOutOfOffice.setSentTime(conn, mbox, destination);
                    conn.commit();
                    Object var31_37 = null;
                }
                catch (Throwable throwable) {
                    Object var31_38 = null;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
                return;
            }
        }
        catch (MessagingException me) {
            Notification.ofailed("send failed", destination, rcpt, msg, (Exception)((Object)me));
            return;
        }
    }

    private String getCharset(Account account, String data) {
        String requestedCharset = account.getAttr("zimbraPrefMailDefaultCharset", "utf-8");
        return StringUtil.checkCharset(data, requestedCharset);
    }

    private void notifyIfNecessary(Account account, Message msg, String rcpt) throws MessagingException, ServiceException {
        boolean notify = account.getBooleanAttr("zimbraPrefNewMailNotificationEnabled", false);
        if (!notify) {
            return;
        }
        String destination = account.getAttr("zimbraPrefNewMailNotificationAddress");
        if (destination == null) {
            Notification.nfailed("destination not set", null, rcpt, msg, null);
            return;
        }
        try {
            new InternetAddress(destination);
        }
        catch (AddressException ae) {
            Notification.nfailed("invalid destination", destination, rcpt, msg, (Exception)((Object)ae));
            return;
        }
        if (msg.inSpam()) {
            Notification.nfailed("in spam", destination, rcpt, msg);
            return;
        }
        try {
            if (msg.inTrash()) {
                Notification.nfailed("in trash", destination, rcpt, msg);
                return;
            }
        }
        catch (ServiceException e) {
            Notification.nfailed("call to Message.inTrash() failed", destination, rcpt, msg, e);
            return;
        }
        MimeMessage mm = msg.getMimeMessage();
        String[] precedence = mm.getHeader("Precedence");
        if (Notification.hasPrecedence(precedence, "bulk")) {
            Notification.nfailed("precedence bulk", destination, rcpt, msg);
            return;
        }
        if (Notification.hasPrecedence(precedence, "junk")) {
            Notification.nfailed("precedence junk", destination, rcpt, msg);
            return;
        }
        String[] autoSubmittedHeaders = mm.getHeader("Auto-Submitted");
        if (autoSubmittedHeaders != null) {
            for (int i = 0; i < autoSubmittedHeaders.length; ++i) {
                String headerValue = autoSubmittedHeaders[i].toLowerCase();
                if (headerValue.indexOf("notification") == -1) continue;
                Notification.nfailed("detected a mail loop", destination, rcpt, msg);
                return;
            }
        }
        String from = account.getAttr("zimbraNewMailNotificationFrom");
        String subject = account.getAttr("zimbraNewMailNotificationSubject");
        String body = account.getAttr("zimbraNewMailNotificationBody");
        if (from == null || subject == null || body == null) {
            Notification.nfailed("null from, subject or body", destination, rcpt, msg);
            return;
        }
        String recipientDomain = Notification.getDomain(rcpt);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("SENDER_ADDRESS", msg.getSender());
        vars.put("RECIPIENT_ADDRESS", rcpt);
        vars.put("RECIPIENT_DOMAIN", recipientDomain);
        vars.put("NOTIFICATION_ADDRESS", destination);
        vars.put("SUBJECT", msg.getSubject());
        vars.put("NEWLINE", "\n");
        from = StringUtil.fillTemplate(from, vars);
        subject = StringUtil.fillTemplate(subject, vars);
        body = StringUtil.fillTemplate(body, vars);
        try {
            SMTPMessage out = new SMTPMessage(JMSession.getSession());
            out.setHeader("Auto-Submitted", "auto-replied (notification; " + rcpt + ")");
            InternetAddress address = new InternetAddress(from);
            out.setFrom((Address)address);
            address = new InternetAddress(destination);
            out.setRecipient(Message.RecipientType.TO, (Address)address);
            String charset = this.getCharset(account, subject);
            out.setSubject(subject, charset);
            charset = this.getCharset(account, body);
            out.setText(body, charset);
            String envFrom = "<>";
            try {
                if (!Provisioning.getInstance().getConfig().getBooleanAttr("zimbraAutoSubmittedNullReturnPath", true)) {
                    envFrom = account.getName();
                }
            }
            catch (ServiceException se) {
                ZimbraLog.mailbox.warn((Object)"error encoutered looking up return path configuration, using null return path instead", se);
            }
            out.setEnvelopeFrom(envFrom);
            Transport.send((javax.mail.Message)out);
            ZimbraLog.mailbox.info("notification sent dest='" + destination + "' rcpt='" + rcpt + "' mid=" + msg.getId());
        }
        catch (MessagingException me) {
            Notification.nfailed("send failed", destination, rcpt, msg, (Exception)((Object)me));
        }
    }

    private static String getDomain(String address) {
        String[] parts = EmailUtil.getLocalPartAndDomain(address);
        if (parts == null) {
            return null;
        }
        return parts[1];
    }

    void interceptIfNecessary(Mailbox mbox, MimeMessage msg, String operation, Folder folder) throws ServiceException {
        Account account = mbox.getAccount();
        String[] interceptAddresses = account.getMultiAttr("zimbraInterceptAddress");
        if (interceptAddresses.length == 0) {
            return;
        }
        for (String interceptAddress : interceptAddresses) {
            try {
                ZimbraLog.mailbox.info("Sending intercept of message %s to %s.", msg.getMessageID(), interceptAddress);
                String folderName = "none";
                String folderId = "none";
                if (folder != null) {
                    folderName = folder.getName();
                    folderId = Integer.toString(folder.getId());
                }
                HashMap<String, String> vars = new HashMap<String, String>();
                vars.put("ACCOUNT_DOMAIN", Notification.getDomain(account.getName()));
                vars.put("ACCOUNT_ADDRESS", account.getName());
                vars.put("MESSAGE_SUBJECT", Mime.getSubject(msg));
                vars.put("OPERATION", operation);
                vars.put("FOLDER_NAME", folderName);
                vars.put("FOLDER_ID", folderId);
                vars.put("NEWLINE", "\r\n");
                String from = StringUtil.fillTemplate(account.getAttr("zimbraInterceptFrom"), vars);
                String subject = StringUtil.fillTemplate(account.getAttr("zimbraInterceptSubject"), vars);
                String bodyText = StringUtil.fillTemplate(account.getAttr("zimbraInterceptBody"), vars);
                MimeMessage attached = msg;
                boolean headersOnly = account.getBooleanAttr("zimbraInterceptSendHeadersOnly", false);
                if (headersOnly) {
                    attached = new MimeMessageWithId(msg.getMessageID());
                    Enumeration e = msg.getAllHeaderLines();
                    while (e.hasMoreElements()) {
                        attached.addHeaderLine((String)e.nextElement());
                    }
                    attached.setContent((Object)"", msg.getContentType());
                }
                SMTPMessage out = new SMTPMessage(JMSession.getSession());
                out.setHeader("Auto-Submitted", "auto-replied (zimbra; intercept)");
                InternetAddress address = new InternetAddress(from);
                out.setFrom((Address)address);
                address = new InternetAddress(interceptAddress);
                out.setRecipient(Message.RecipientType.TO, (Address)address);
                String charset = this.getCharset(account, subject);
                out.setSubject(subject, charset);
                charset = this.getCharset(account, bodyText);
                MimeMultipart multi = new MimeMultipart();
                MimeBodyPart part = new MimeBodyPart();
                part.setText(bodyText, charset);
                multi.addBodyPart((BodyPart)part);
                part = new MimeBodyPart();
                part.setContent((Object)attached, "message/rfc822");
                multi.addBodyPart((BodyPart)part);
                out.setContent((Multipart)multi);
                String envFrom = "<>";
                out.setEnvelopeFrom(envFrom);
                out.saveChanges();
                Transport.send((javax.mail.Message)out);
            }
            catch (MessagingException e) {
                ZimbraLog.lmtp.warn("Unable to send intercept message to %s.", (Object)interceptAddress, e);
            }
        }
    }

    private static boolean hasPrecedence(String[] precedence, String value) {
        if (precedence != null) {
            for (int i = 0; i < precedence.length; ++i) {
                if (!precedence[i].equalsIgnoreCase(value)) continue;
                return true;
            }
        }
        return false;
    }

    private static void failed(String op, String why, String destAddr, String rcptAddr, Message msg, Exception e) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(op).append(" not sent (");
        sb.append(why).append(")");
        sb.append(" mid=").append(msg.getId());
        sb.append(" rcpt='").append(rcptAddr).append("'");
        if (destAddr != null) {
            sb.append(" dest='").append(destAddr).append("'");
        }
        ZimbraLog.mailbox.info((Object)sb.toString(), e);
    }

    private static void nfailed(String why, String destAddr, String rcptAddr, Message msg, Exception e) {
        Notification.failed("notification", why, destAddr, rcptAddr, msg, e);
    }

    private static void nfailed(String why, String destAddr, String rcptAddr, Message msg) {
        Notification.failed("notification", why, destAddr, rcptAddr, msg, null);
    }

    private static void ofailed(String why, String destAddr, String rcptAddr, Message msg, Exception e) {
        Notification.failed("outofoffice", why, destAddr, rcptAddr, msg, e);
    }

    private static void ofailed(String why, String destAddr, String rcptAddr, Message msg) {
        Notification.failed("outofoffice", why, destAddr, rcptAddr, msg, null);
    }

    private class MimeMessageWithId
    extends MimeMessage {
        private String mMessageId;

        private MimeMessageWithId(String messageId) throws MessagingException {
            super(JMSession.getSession());
            this.mMessageId = messageId;
        }

        protected void updateMessageID() throws MessagingException {
            this.setHeader("Message-ID", this.mMessageId);
        }
    }
}

