/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Note
extends MailItem {
    private Rectangle mBounds;
    private static final String CN_BOUNDS = "bounds";

    public Note(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        super(mbox, data);
        if (this.mData.type != 9) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getSender() {
        return "";
    }

    public String getText() {
        return this.getSubject();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.mBounds);
    }

    @Override
    boolean isTaggable() {
        return true;
    }

    @Override
    boolean isCopyable() {
        return true;
    }

    @Override
    boolean isMovable() {
        return true;
    }

    @Override
    boolean isMutable() {
        return true;
    }

    @Override
    boolean isIndexed() {
        return true;
    }

    @Override
    boolean canHaveChildren() {
        return false;
    }

    static Note create(int id, Folder folder, String content, Rectangle location, MailItem.Color color, MailItem.CustomMetadata custom) throws ServiceException {
        if (folder == null || !folder.canContain((byte)9)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!folder.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the folder");
        }
        if ((content = StringUtil.stripControlCharacters(content)) == null || content.equals("")) {
            throw ServiceException.INVALID_REQUEST("notes may not be empty", null);
        }
        if (location == null) {
            location = new Rectangle();
        }
        Mailbox mbox = folder.getMailbox();
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = (byte)9;
        data.folderId = folder.getId();
        if (!folder.inSpam() || mbox.getAccount().getBooleanAttr("zimbraJunkMessagesIndexingEnabled", false)) {
            data.indexId = mbox.generateIndexId(id);
        }
        data.date = mbox.getOperationTimestamp();
        data.subject = content;
        data.metadata = Note.encodeMetadata(color, 1, custom, location);
        data.contentChanged(mbox);
        ZimbraLog.mailop.info("Adding Note: id=%d, folderId=%d, folderName=%s.", data.id, folder.getId(), folder.getName());
        DbMailItem.create(mbox, data, null);
        Note note = new Note(mbox, data);
        note.finishCreation(null);
        return note;
    }

    @Override
    public List<IndexDocument> generateIndexData(boolean doConsistencyCheck) {
        String toIndex = this.getText();
        Document doc = new Document();
        doc.add(new Field("l.content", toIndex, Field.Store.NO, Field.Index.TOKENIZED));
        doc.add(new Field("subject", toIndex, Field.Store.NO, Field.Index.TOKENIZED));
        doc.add(new Field("l.partname", "NOTE", Field.Store.YES, Field.Index.UN_TOKENIZED));
        ArrayList<IndexDocument> toRet = new ArrayList<IndexDocument>(1);
        toRet.add(new IndexDocument(doc));
        return toRet;
    }

    void setContent(String content) throws ServiceException {
        if (!this.isMutable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the note");
        }
        if ((content = StringUtil.stripControlCharacters(content)) == null || content.equals("")) {
            throw ServiceException.INVALID_REQUEST("notes may not be empty", null);
        }
        if (content.equals(this.mData.subject)) {
            return;
        }
        this.addRevision(false);
        this.markItemModified(65568);
        this.mData.subject = content;
        this.mData.date = this.mMailbox.getOperationTimestamp();
        this.saveData(null);
    }

    protected void saveSubject() throws ServiceException {
        this.mData.contentChanged(this.mMailbox);
        DbMailItem.saveSubject(this);
    }

    void reposition(Rectangle bounds) throws ServiceException {
        if (!this.isMutable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the note");
        }
        if (bounds == null) {
            throw ServiceException.INVALID_REQUEST("must specify bounds", null);
        }
        if (bounds.equals(this.mBounds)) {
            return;
        }
        this.markItemModified(16384);
        this.mBounds = new Rectangle(bounds);
        this.saveMetadata();
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        super.decodeMetadata(meta);
        this.mBounds = new Rectangle(meta.get("l", null));
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return Note.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mBounds);
    }

    private static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata custom, Rectangle bounds) {
        MailItem.CustomMetadata.CustomMetadataList extended = custom == null ? null : custom.asList();
        return Note.encodeMetadata(new Metadata(), color, version, extended, bounds).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, Rectangle bounds) {
        meta.put("l", bounds);
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("note: {");
        this.appendCommonMembers(sb).append(", ");
        sb.append(CN_BOUNDS).append(": ").append(this.mBounds);
        sb.append("}");
        return sb.toString();
    }

    public static class Rectangle {
        public int x;
        public int y;
        public int width;
        public int height;

        public Rectangle() {
        }

        public Rectangle(Rectangle r) {
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
        }

        public Rectangle(int ax, int ay, int awidth, int aheight) {
            this.x = ax;
            this.y = ay;
            this.width = awidth;
            this.height = aheight;
        }

        public Rectangle(String bounds) {
            if (bounds == null) {
                return;
            }
            String[] dimensions = bounds.split(",");
            if (dimensions.length == 2 || dimensions.length == 4) {
                this.x = Integer.parseInt(dimensions[0]);
                this.y = Integer.parseInt(dimensions[1]);
                if (dimensions.length == 4) {
                    this.width = Integer.parseInt(dimensions[2]);
                    this.height = Integer.parseInt(dimensions[3]);
                }
            }
        }

        public boolean equals(Rectangle r) {
            return r != null && this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }

        public String toString() {
            return this.x + "," + this.y + "," + this.width + "," + this.height;
        }
    }
}

