/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.service.util.ItemId;

public class Mountpoint
extends Folder {
    private String mOwnerId;
    private int mRemoteId;

    Mountpoint(Mailbox mbox, MailItem.UnderlyingData ud) throws ServiceException {
        super(mbox, ud);
    }

    public String getOwnerId() {
        return this.mOwnerId;
    }

    public int getRemoteId() {
        return this.mRemoteId;
    }

    public ItemId getTarget() {
        return new ItemId(this.mOwnerId, this.mRemoteId);
    }

    public boolean isLocal() {
        return this.getOwnerId().equals(this.getMailbox().getAccountId());
    }

    void grantAccess(String liquidId, byte type, short rights, boolean inherit) throws ServiceException {
        throw ServiceException.PERM_DENIED("you may not share the mounted folder " + this.getPath());
    }

    void revokeAccess(String liquidId) {
    }

    boolean canHaveChildren() {
        return false;
    }

    boolean trackUnread() {
        return false;
    }

    boolean canParent(MailItem child) {
        return false;
    }

    boolean canContain(MailItem child) {
        return false;
    }

    boolean canContain(byte type) {
        return false;
    }

    static Mountpoint create(int id, Folder parent, String name, String ownerId, int remoteId, byte view, int flags, MailItem.Color color, MailItem.CustomMetadata custom) throws ServiceException {
        if (parent == null || ownerId == null || remoteId <= 0) {
            throw ServiceException.INVALID_REQUEST("invalid parameters when creating mountpoint", null);
        }
        if (!parent.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the parent folder");
        }
        if (parent == null || !parent.canContain((byte)13)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        name = Mountpoint.validateItemName(name);
        if (view != -1) {
            Mountpoint.validateType(view);
        }
        if (parent.findSubfolder(name) != null) {
            throw MailServiceException.ALREADY_EXISTS(name, new ServiceException.Argument[0]);
        }
        Mailbox mbox = parent.getMailbox();
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = (byte)13;
        data.parentId = data.folderId = parent.getId();
        data.date = mbox.getOperationTimestamp();
        data.flags = flags & Flag.FLAGS_FOLDER;
        data.name = name;
        data.subject = name;
        data.metadata = Mountpoint.encodeMetadata(color, 1, custom, view, ownerId, remoteId);
        data.contentChanged(mbox);
        ZimbraLog.mailop.info("Adding Mountpoint %s: id=%d, parentId=%d, parentName=%s.", name, data.id, parent.getId(), parent.getName());
        DbMailItem.create(mbox, data, null);
        Mountpoint mpt = new Mountpoint(mbox, data);
        mpt.finishCreation(parent);
        return mpt;
    }

    void delete(MailItem.DeleteScope scope, boolean writeTombstones) throws ServiceException {
        if (!this.getFolder().canAccess((short)8)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the parent folder");
        }
        this.deleteSingleFolder(writeTombstones);
    }

    void decodeMetadata(Metadata meta) throws ServiceException {
        super.decodeMetadata(meta);
        this.mOwnerId = meta.get("aid");
        this.mRemoteId = (int)meta.getLong("id");
    }

    Metadata encodeMetadata(Metadata meta) {
        return Mountpoint.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mAttributes, this.mDefaultView, this.mOwnerId, this.mRemoteId);
    }

    private static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata custom, byte view, String owner, int remoteId) {
        MailItem.CustomMetadata.CustomMetadataList extended = custom == null ? null : custom.asList();
        return Mountpoint.encodeMetadata(new Metadata(), color, version, extended, (byte)0, view, owner, remoteId).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, byte attrs, byte view, String owner, int remoteId) {
        meta.put("aid", owner);
        meta.put("id", remoteId);
        return Folder.encodeMetadata(meta, color, version, extended, attrs, view, null, null, 0, 0L, 0, 0, 0);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("mountpoint: {");
        sb.append("n:\"").append(this.getName()).append("\", ");
        this.appendCommonMembers(sb).append(", ");
        sb.append("attributes").append(": ").append(this.mAttributes);
        sb.append("}");
        return sb.toString();
    }
}

