/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.BEncoding;
import com.zimbra.cs.mailbox.Metadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetadataList {
    int mVersion;
    List mList;

    public MetadataList() {
        this.mList = new ArrayList();
    }

    public MetadataList(List list) {
        this(list, 10);
    }

    MetadataList(List list, int version) {
        this.mList = new ArrayList(list);
        this.mVersion = version;
    }

    public MetadataList(String encoded) throws ServiceException {
        try {
            this.mList = (List)BEncoding.decode(encoded);
        }
        catch (BEncoding.BEncodingException e) {
            throw ServiceException.FAILURE("error decoding list metadata: " + encoded, e);
        }
    }

    public int size() {
        return this.mList.size();
    }

    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    public int getVersion() {
        return this.mVersion;
    }

    public MetadataList copy(MetadataList source) {
        this.mList.addAll(source.mList);
        return this;
    }

    public List asList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.mList.size(); ++i) {
            Object obj = this.mList.get(i);
            if (obj == null) continue;
            if (obj instanceof Map) {
                list.add(new Metadata((Map)obj, this.mVersion));
                continue;
            }
            if (obj instanceof List) {
                list.add(new MetadataList((List)obj, this.mVersion));
                continue;
            }
            list.add(obj);
        }
        return list;
    }

    public MetadataList add(Object value) {
        if (value != null) {
            this.mList.add(value);
        }
        return this;
    }

    public MetadataList add(long value) {
        this.mList.add(new Long(value));
        return this;
    }

    public MetadataList add(double value) {
        this.mList.add(new Double(value));
        return this;
    }

    public MetadataList add(boolean value) {
        this.mList.add(new Boolean(value));
        return this;
    }

    public MetadataList add(Metadata value) {
        if (value != null) {
            this.mList.add(value.mMap);
        }
        return this;
    }

    public MetadataList add(MetadataList value) {
        if (value != null) {
            this.mList.add(value.mList);
        }
        return this;
    }

    public void remove(int index) {
        if (index < this.mList.size()) {
            this.mList.remove(index);
        }
    }

    public void remove(Object value) {
        this.mList.remove(value);
    }

    public String get(int index) throws ServiceException {
        Object obj = this.mList.get(index);
        return MetadataList.checkNull(index, obj).toString();
    }

    public long getLong(int index) throws ServiceException {
        return MetadataList.parseLong(index, this.get(index));
    }

    public double getDouble(int index) throws ServiceException {
        return MetadataList.parseDouble(index, this.get(index));
    }

    public boolean getBool(int index) throws ServiceException {
        return MetadataList.parseBool(index, this.get(index));
    }

    public MetadataList getList(int index) throws ServiceException {
        Object value = this.mList.get(index);
        if (value instanceof List) {
            return new MetadataList((List)value, this.mVersion);
        }
        throw ServiceException.INVALID_REQUEST("invalid/null value for index: " + index, null);
    }

    public Metadata getMap(int index) throws ServiceException {
        Object value = this.mList.get(index);
        if (value instanceof Map) {
            return new Metadata((Map)value, this.mVersion);
        }
        throw ServiceException.INVALID_REQUEST("invalid/null value for attribute: " + index, null);
    }

    private static Object checkNull(int index, Object value) throws ServiceException {
        if (value == null) {
            throw ServiceException.INVALID_REQUEST("null element in list: " + index, null);
        }
        return value;
    }

    public static long parseLong(int index, String value) throws ServiceException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw ServiceException.INVALID_REQUEST("invalid value for index: " + index, nfe);
        }
    }

    public static double parseDouble(int index, String value) throws ServiceException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw ServiceException.INVALID_REQUEST("invalid value for index: " + index, nfe);
        }
    }

    public static boolean parseBool(int index, String value) throws ServiceException {
        if (value.equals("1") || value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equals("0") || value.equalsIgnoreCase("false")) {
            return false;
        }
        throw ServiceException.INVALID_REQUEST("invalid boolean value for index: " + index, null);
    }

    public String toString() {
        return BEncoding.encode(this.mList);
    }
}

