/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.ParsedMessage;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class MetadataCallback {
    private static Set<String> sCallbackKeys = new CopyOnWriteArraySet<String>();
    private static List<MetadataCallback> sCallbacks = new CopyOnWriteArrayList<MetadataCallback>();
    private final String mSectionKey;
    private static String CONVERSATION_METADATA;

    public static synchronized void addCallback(MetadataCallback callback) {
        if (callback == null) {
            ZimbraLog.mailbox.error((Object)"", new IllegalStateException("MetadataCallback cannot be null"));
        } else if (sCallbackKeys.contains(callback.getMetadataSectionKey())) {
            ZimbraLog.mailbox.error((Object)"", new IllegalStateException("second MetadataCallback for key " + callback.getMetadataSectionKey()));
        } else {
            ZimbraLog.mailbox.info("Adding metadata callback: %s", callback.getClass().getName());
            sCallbacks.add(callback);
            sCallbackKeys.add(callback.getMetadataSectionKey());
        }
    }

    public static boolean isSectionRegistered(String key) {
        return sCallbackKeys.contains(key);
    }

    protected MetadataCallback(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("metadata callback section key cannot be blank");
        }
        this.mSectionKey = key;
    }

    protected String getMetadataSectionKey() {
        return this.mSectionKey;
    }

    public static MailItem.CustomMetadata.CustomMetadataList preDelivery(ParsedMessage pm) {
        if (pm == null || sCallbacks.isEmpty()) {
            return null;
        }
        MailItem.CustomMetadata.CustomMetadataList extended = null;
        for (MetadataCallback callback : sCallbacks) {
            MailItem.CustomMetadata custom = callback.analyzeMessage(pm);
            if (custom == null) continue;
            if (extended == null) {
                extended = custom.asList();
                continue;
            }
            extended.addSection(custom);
        }
        return extended;
    }

    protected abstract MailItem.CustomMetadata analyzeMessage(ParsedMessage var1);

    public static MailItem.CustomMetadata.CustomMetadataList duringConversationAdd(MailItem.CustomMetadata.CustomMetadataList extended, Message msg) {
        if (msg == null) {
            return extended;
        }
        List<String> msgSections = msg.getCustomDataSections();
        if (msgSections != null && !msgSections.isEmpty()) {
            for (String key : msgSections) {
                if (extended == null) {
                    extended = new MailItem.CustomMetadata.CustomMetadataList();
                }
                extended.addSection(key, CONVERSATION_METADATA);
            }
        }
        return extended;
    }

    static {
        MailItem.CustomMetadata meta = new MailItem.CustomMetadata("ignored");
        meta.put("_exists", "1");
        CONVERSATION_METADATA = meta.getSerializedValue();
    }
}

