/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.BEncoding;
import com.zimbra.common.util.BlobMetaData;
import com.zimbra.common.util.BlobMetaDataEncodingException;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MetadataList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Metadata {
    public static final int CURRENT_METADATA_VERSION = 10;
    static final String FN_ATTRS = "a";
    static final String FN_RIGHTS = "acl";
    static final String FN_ALARM_DATA = "ad";
    static final String FN_ACCOUNT_ID = "aid";
    static final String FN_CALITEM_IDS = "ais";
    static final String FN_CALITEM_END = "ape";
    static final String FN_CALITEM_START = "aps";
    static final String FN_ATTACHMENTS = "att";
    static final String FN_COLOR = "c";
    static final String FN_CAL_INTENDED_FOR = "cif";
    static final String FN_COMPONENT = "comp";
    static final String FN_CREATOR = "cr";
    static final String FN_MIME_TYPE = "ct";
    static final String FN_DRAFT = "d";
    static final String FN_REPLY_ORIG = "do";
    static final String FN_REPLY_TYPE = "dt";
    static final String FN_ENTRIES = "en";
    static final String FN_FRAGMENT = "f";
    static final String FN_FIRST = "f";
    static final String FN_FIELDS = "fld";
    static final String FN_RECENT = "i4l";
    static final String FN_RECENT_CUTOFF = "i4r";
    static final String FN_REMOTE_ID = "id";
    static final String FN_IDENTITY_ID = "idnt";
    static final String FN_INV = "inv";
    static final String FN_BOUNDS = "l";
    static final String FN_LAST_DATE = "ld";
    static final String FN_MODSEQ = "mseq";
    static final String FN_NUM_COMPONENTS = "nc";
    static final String FN_NODES = "no";
    static final String FN_PREFIX = "p";
    static final String FN_PARTICIPANTS = "prt";
    static final String FN_QUERY = "q";
    static final String FN_RAW_SUBJ = "r";
    static final String FN_REV_DATE = "rd";
    static final String FN_REVISIONS = "rev";
    static final String FN_REV_ID = "rid";
    static final String FN_REPLY_LIST = "rl";
    static final String FN_REV_SIZE = "rs";
    static final String FN_REPLY_TO = "rt";
    static final String FN_SENDER = "s";
    static final String FN_SORT = "s";
    static final String FN_SYNC_DATE = "sd";
    static final String FN_SYNC_GUID = "sg";
    static final String FN_TOTAL_SIZE = "sz";
    static final String FN_RECIPIENTS = "t";
    static final String FN_TYPES = "t";
    static final String FN_TZMAP = "tzm";
    static final String FN_UID = "u";
    static final String FN_USER_AGENT = "ua";
    static final String FN_UIDNEXT = "unxt";
    static final String FN_URL = "url";
    static final String FN_MD_VERSION = "v";
    static final String FN_VERSION = "ver";
    static final String FN_VIEW = "vt";
    static final String FN_WIKI_WORD = "ww";
    static final String FN_ELIDED = "X";
    static final String FN_EXTRA_DATA = "xd";
    private int mVersion;
    Map mMap;

    public Metadata() {
        this.mVersion = 10;
        this.mMap = new TreeMap();
    }

    public Metadata(Map map) {
        this(map, 10);
    }

    Metadata(Map map, int version) {
        this.mVersion = 10;
        this.mMap = new TreeMap(map);
        this.mVersion = version;
    }

    public Metadata(String encoded) throws ServiceException {
        this(encoded, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Metadata(String encoded, MailItem item) throws ServiceException {
        block13: {
            this.mVersion = 10;
            if (encoded == null || encoded.equals("")) {
                this.mMap = new HashMap();
                return;
            }
            try {
                try {
                    this.mMap = (Map)BEncoding.decode(encoded);
                    Object var6_3 = null;
                    if (this.mMap == null || !this.mMap.containsKey(FN_MD_VERSION)) break block13;
                }
                catch (BEncoding.BEncodingException e) {
                    try {
                        this.mMap = BlobMetaData.decodeRecursive(encoded);
                    }
                    catch (BlobMetaDataEncodingException e1) {
                        String message = "error decoding " + (item == null ? "" : MailItem.getNameForType(item) + ' ' + item.getId() + ' ') + "metadata: " + encoded;
                        throw ServiceException.FAILURE(message, e);
                    }
                    Object var6_4 = null;
                    if (this.mMap != null && this.mMap.containsKey(FN_MD_VERSION)) {
                        try {
                            this.mVersion = (int)this.getLong(FN_MD_VERSION, 10L);
                            this.mMap.remove(FN_MD_VERSION);
                            return;
                        }
                        catch (Exception e2) {
                            return;
                        }
                    }
                    this.mVersion = 1;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (this.mMap != null && this.mMap.containsKey(FN_MD_VERSION)) {
                    try {}
                    catch (Exception e2) {
                        throw throwable;
                    }
                    this.mVersion = (int)this.getLong(FN_MD_VERSION, 10L);
                    this.mMap.remove(FN_MD_VERSION);
                    throw throwable;
                }
                this.mVersion = 1;
                throw throwable;
            }
            try {}
            catch (Exception e2) {
                return;
            }
            this.mVersion = (int)this.getLong(FN_MD_VERSION, 10L);
            this.mMap.remove(FN_MD_VERSION);
            return;
        }
        this.mVersion = 1;
    }

    public boolean containsKey(String key) {
        return this.mMap.containsKey(key);
    }

    public int size() {
        return this.mMap.size();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public int getVersion() {
        return this.mVersion;
    }

    public Metadata copy(Metadata source) {
        if (source != null) {
            this.mMap.putAll(source.mMap);
        }
        return this;
    }

    public Map asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : this.mMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Map) {
                map.put(key.toString(), new Metadata((Map)value, this.mVersion));
                continue;
            }
            if (value instanceof List) {
                map.put(key.toString(), new MetadataList((List)value, this.mVersion));
                continue;
            }
            map.put(key.toString(), value);
        }
        return map;
    }

    public Metadata remove(String key) {
        this.mMap.remove(key);
        return this;
    }

    public Metadata put(String key, Object value) {
        if (key != null && value != null) {
            this.mMap.put(key, value);
        }
        return this;
    }

    public Metadata put(String key, long value) {
        if (key != null) {
            this.mMap.put(key, new Long(value));
        }
        return this;
    }

    public Metadata put(String key, double value) {
        if (key != null) {
            this.mMap.put(key, new Double(value));
        }
        return this;
    }

    public Metadata put(String key, boolean value) {
        if (key != null) {
            this.mMap.put(key, new Boolean(value));
        }
        return this;
    }

    public Metadata put(String key, Metadata value) {
        if (key != null && value != null) {
            this.mMap.put(key, value.mMap);
        }
        return this;
    }

    public Metadata put(String key, MetadataList value) {
        if (key != null && value != null) {
            this.mMap.put(key, value.mList);
        }
        return this;
    }

    public String get(String key) throws ServiceException {
        return Element.checkNull(key, this.get(key, null));
    }

    public long getLong(String key) throws ServiceException {
        return Element.parseLong(key, Element.checkNull(key, this.get(key, null)));
    }

    public double getDouble(String key) throws ServiceException {
        return Element.parseDouble(key, Element.checkNull(key, this.get(key, null)));
    }

    public boolean getBool(String key) throws ServiceException {
        return Element.parseBool(key, Element.checkNull(key, this.get(key, null)));
    }

    public String get(String key, String defaultValue) {
        Object value = this.mMap.get(key);
        return value == null ? defaultValue : value.toString();
    }

    public long getLong(String key, long defaultValue) throws ServiceException {
        String raw = this.get(key, null);
        return raw == null ? defaultValue : Element.parseLong(key, raw);
    }

    public double getDouble(String key, double defaultValue) throws ServiceException {
        String raw = this.get(key, null);
        return raw == null ? defaultValue : Element.parseDouble(key, raw);
    }

    public boolean getBool(String key, boolean defaultValue) throws ServiceException {
        String raw = this.get(key, null);
        return raw == null ? defaultValue : Element.parseBool(key, raw);
    }

    public MetadataList getList(String key) throws ServiceException {
        return this.getList(key, false);
    }

    public MetadataList getList(String key, boolean nullOK) throws ServiceException {
        Object value = this.mMap.get(key);
        if (nullOK && value == null) {
            return null;
        }
        if (value instanceof List) {
            return new MetadataList((List)value, this.mVersion);
        }
        throw ServiceException.INVALID_REQUEST("invalid/missing value for attribute: " + key, null);
    }

    public Metadata getMap(String key) throws ServiceException {
        return this.getMap(key, false);
    }

    public Metadata getMap(String key, boolean nullOK) throws ServiceException {
        Object value = this.mMap.get(key);
        if (nullOK && value == null) {
            return null;
        }
        if (value instanceof Map) {
            return new Metadata((Map)value, this.mVersion);
        }
        throw ServiceException.INVALID_REQUEST("invalid/missing value for attribute: " + key, null);
    }

    public String toString() {
        this.put(FN_MD_VERSION, this.mVersion);
        String result = BEncoding.encode(this.mMap);
        this.mMap.remove(FN_MD_VERSION);
        return result;
    }

    public String prettyPrint() {
        StringBuffer sb = new StringBuffer(2048);
        sb.append("MetaData version = ").append(this.mVersion).append("\n");
        Metadata.prettyEncode(sb, this.mMap, 0);
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static StringBuffer prettyEncode(StringBuffer sb, Object object, int indentLevel) {
        if (object instanceof Map) {
            SortedMap tree = object instanceof SortedMap ? (SortedMap)object : new TreeMap((Map)object);
            sb.append("{\n");
            if (!tree.isEmpty()) {
                for (Map.Entry entry : tree.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    Metadata.appendIndent(sb, indentLevel + 1);
                    sb.append(entry.getKey().toString()).append(" = ");
                    Metadata.prettyEncode(sb, entry.getValue(), indentLevel + 1);
                }
            }
            Metadata.appendIndent(sb, indentLevel);
            sb.append("}\n");
        } else if (object instanceof List) {
            sb.append("[\n");
            for (Object value : (List)object) {
                if (value == null) continue;
                Metadata.appendIndent(sb, indentLevel + 1);
                Metadata.prettyEncode(sb, value, indentLevel + 1);
            }
            Metadata.appendIndent(sb, indentLevel);
            sb.append("]\n");
        } else if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            sb.append(object).append("\n");
        } else if (object != null) {
            sb.append(object.toString()).append("\n");
        }
        return sb;
    }

    private static void appendIndent(StringBuffer sb, int indentLevel) {
        int num = indentLevel * 2;
        for (int i = 0; i < num; ++i) {
            sb.append(' ');
        }
    }
}

