/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.Mime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.MessagingException;

public class MessageDataSource
implements DataSource {
    private Message mMessage;
    private String mContentType;

    public MessageDataSource(Message message) throws MessagingException, ServiceException {
        if (message == null) {
            throw new NullPointerException("message cannot be null");
        }
        this.mMessage = message;
        this.mContentType = message.getMimeMessage().getContentType();
    }

    public String getContentType() {
        return this.mContentType;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return Mime.getInputStream(this.mMessage.getMimeMessage());
        }
        catch (Exception e) {
            ZimbraLog.mailbox.error((Object)("Unable to get stream to message " + this.mMessage.getId()), e);
            throw new IOException(e.toString());
        }
    }

    public String getName() {
        return this.mMessage.getSubject();
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }
}

