/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mime.ExpandMimeMessage;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.util.JMSession;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class MessageCache {
    private static final Log sLog = LogFactory.getLog(MessageCache.class);
    private static Map<String, CacheNode> sCache = new LinkedHashMap<String, CacheNode>(150, 0.75f, true);
    private static int sMaxCacheSize;
    private static volatile long sDataSize;
    private static final int MESSAGE_CACHE_DISK_STREAMING_THRESHOLD = 4096;

    public static void loadSettings() throws ServiceException {
        sMaxCacheSize = Provisioning.getInstance().getLocalServer().getMessageCacheSize();
        ZimbraLog.cache.info("setting message cache size to " + sMaxCacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSize() {
        Map<String, CacheNode> map = sCache;
        synchronized (map) {
            return sCache.size();
        }
    }

    public static long getDataSize() {
        return sDataSize;
    }

    static void purge(MailItem item) {
        String digest = item.getDigest();
        if (digest != null) {
            sLog.debug("Purging item %d from the message cache.", item.getId());
            MessageCache.purge(item.getDigest());
        }
    }

    static void purge(Mailbox mbox, int itemId) {
        String digest = null;
        try {
            digest = DbMailItem.getBlobDigest(mbox, itemId);
        }
        catch (ServiceException e) {
            sLog.warn("Unable to uncache message for item %d.", (Object)itemId, e);
        }
        if (digest != null) {
            sLog.debug("Purging item %d from the message cache.", itemId);
            MessageCache.purge(digest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purge(String digest) {
        if (digest != null) {
            Map<String, CacheNode> map = sCache;
            synchronized (map) {
                CacheNode node = sCache.remove(digest);
                if (node != null) {
                    sLog.debug("Purged digest %s from the message cache.", digest);
                    sDataSize -= node.size;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MimeMessage getMimeMessage(MailItem item, boolean expand) throws ServiceException {
        String digest = item.getDigest();
        CacheNode cnode = null;
        boolean cacheHit = true;
        boolean newNode = false;
        InputStream in = null;
        Map<String, CacheNode> map = sCache;
        synchronized (map) {
            cnode = sCache.get(digest);
            if (cnode == null) {
                newNode = true;
                cnode = new CacheNode();
            }
        }
        try {
            block20: {
                try {
                    if (cnode.message == null) {
                        sLog.debug("Loading MimeMessage for item %d.", item.getId());
                        cacheHit = false;
                        try {
                            in = MessageCache.fetchFromStore(item);
                            cnode.message = new Mime.FixedMimeMessage(JMSession.getSession(), in);
                            if (item.getSize() < 4096L) {
                                cnode.size = item.getSize();
                                sDataSize += cnode.size;
                            }
                            Object var10_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            ByteUtil.closeStream(in);
                            throw throwable;
                        }
                        ByteUtil.closeStream(in);
                        {
                        }
                    }
                    if (expand && cnode.expanded == null) {
                        sLog.debug("Expanding MimeMessage for item %d.", item.getId());
                        cacheHit = false;
                        try {
                            ExpandMimeMessage expander = new ExpandMimeMessage(cnode.message);
                            expander.expand();
                            cnode.expanded = expander.getExpanded();
                            if (cnode.expanded != cnode.message) {
                                sDataSize += cnode.size;
                                cnode.size *= 2L;
                            }
                        }
                        catch (Exception e) {
                            sLog.warn("MIME converter failed for message %d.  Reverting to original.", (Object)item.getId(), e);
                            cnode.expanded = cnode.message;
                        }
                    }
                    if (!newNode) break block20;
                    MessageCache.cacheItem(digest, cnode);
                }
                catch (IOException e) {
                    throw ServiceException.FAILURE("IOException while retrieving content for item " + item.getId(), e);
                }
                catch (MessagingException e) {
                    throw ServiceException.FAILURE("MessagingException while creating MimeMessage for item " + item.getId(), e);
                }
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
        if (cacheHit) {
            sLog.debug("Cache hit for item %d: digest=%s, expand=%b.", item.getId(), item.getDigest(), expand);
            ZimbraPerf.COUNTER_MBOX_MSG_CACHE.increment(100L);
        } else {
            sLog.debug("Cache miss for item %d: digest=%s, expand=%b.", item.getId(), item.getDigest(), expand);
            ZimbraPerf.COUNTER_MBOX_MSG_CACHE.increment(0L);
        }
        if (expand) {
            return cnode.expanded;
        }
        return cnode.message;
    }

    static InputStream fetchFromStore(MailItem item) throws ServiceException, IOException {
        MailboxBlob mblob = item.getBlob();
        if (mblob == null) {
            throw ServiceException.FAILURE("missing blob for id: " + item.getId() + ", change: " + item.getModifiedSequence(), null);
        }
        if (item.getSize() < 4096L) {
            return StoreManager.getInstance().getContent(mblob);
        }
        return new BlobInputStream(mblob.getLocalBlob());
    }

    public static void cacheMessage(String digest, MimeMessage original, MimeMessage expanded) {
        sLog.debug("Caching existing MimeMessage, digest=%s.", digest);
        CacheNode cnode = new CacheNode();
        cnode.message = original;
        cnode.expanded = expanded;
        MessageCache.cacheItem(digest, cnode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheItem(String digest, CacheNode cnode) {
        sLog.debug("Caching MimeMessage for digest %s.", digest);
        Map<String, CacheNode> map = sCache;
        synchronized (map) {
            sCache.put(digest, cnode);
            if (sCache.size() > sMaxCacheSize) {
                Iterator<Map.Entry<String, CacheNode>> it = sCache.entrySet().iterator();
                while (sCache.size() > sMaxCacheSize && it.hasNext()) {
                    Map.Entry<String, CacheNode> entry = it.next();
                    sLog.debug("Pruning digest %s from the cache.", entry.getKey());
                    it.remove();
                    sDataSize -= entry.getValue().size;
                }
            }
        }
    }

    static {
        sDataSize = 0L;
        try {
            MessageCache.loadSettings();
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class CacheNode {
        MimeMessage message;
        MimeMessage expanded;
        long size = 0L;

        CacheNode() {
        }
    }
}

