/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttrProvisioning;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.VirtualConversation;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mime.ParsedAddress;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.mime.ParsedMessageOptions;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.cs.redolog.op.CreateCalendarItemPlayer;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StagedBlob;
import com.zimbra.cs.util.AccountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends MailItem {
    static Log sLog = LogFactory.getLog(Message.class);
    private String mSender;
    private String mRecipients;
    private String mFragment;
    private String mRawSubject;
    private DraftInfo mDraftInfo;
    private ArrayList<CalendarItemInfo> mCalendarItemInfos;
    private String mCalendarIntendedFor;
    private static final String CN_SENDER = "sender";
    private static final String CN_RECIPIENTS = "to";
    private static final String CN_FRAGMENT = "fragment";

    Message(Mailbox mbox, MailItem.UnderlyingData ud) throws ServiceException {
        super(mbox, ud);
        if (this.mData.type != 5 && this.mData.type != 16) {
            throw new IllegalArgumentException();
        }
        if (this.mData.parentId < 0) {
            this.mData.parentId = -this.mId;
        }
    }

    public boolean isDraft() {
        return this.isTagged(-7);
    }

    public String getRecipients() {
        return this.mRecipients == null ? "" : this.mRecipients;
    }

    public String getFragment() {
        return this.mFragment == null ? "" : this.mFragment;
    }

    public String getNormalizedSubject() {
        return super.getSubject();
    }

    @Override
    public String getSubject() {
        return this.mRawSubject == null ? "" : this.mRawSubject;
    }

    @Override
    public String getSender() {
        return this.mSender == null ? "" : this.mSender;
    }

    @Override
    public String getSortSubject() {
        String subject = this.getNormalizedSubject();
        return subject.toUpperCase().substring(0, Math.min(1024, subject.length()));
    }

    @Override
    public String getSortSender() {
        String sender = new ParsedAddress(this.getSender()).getSortString();
        return sender.toUpperCase().substring(0, Math.min(128, sender.length()));
    }

    public boolean isFromMe() {
        return (this.mData.flags & Flag.BITMASK_FROM_ME) != 0;
    }

    public int getConversationId() {
        return this.mData.parentId;
    }

    public String getDraftOrigId() {
        return this.mDraftInfo == null || this.mDraftInfo.origId == null ? "" : this.mDraftInfo.origId;
    }

    public String getDraftReplyType() {
        return this.mDraftInfo == null || this.mDraftInfo.replyType == null ? "" : this.mDraftInfo.replyType;
    }

    public String getDraftAccountId() {
        return this.mDraftInfo == null || this.mDraftInfo.accountId == null ? "" : this.mDraftInfo.accountId;
    }

    public String getDraftIdentityId() {
        return this.mDraftInfo == null || this.mDraftInfo.identityId == null ? "" : this.mDraftInfo.identityId;
    }

    public boolean isInvite() {
        return (this.mData.flags & Flag.BITMASK_INVITE) != 0;
    }

    public boolean hasCalendarItemInfos() {
        return this.mCalendarItemInfos != null && !this.mCalendarItemInfos.isEmpty();
    }

    public Iterator<CalendarItemInfo> getCalendarItemInfoIterator() {
        if (this.mCalendarItemInfos != null) {
            return this.mCalendarItemInfos.iterator();
        }
        return new ArrayList().iterator();
    }

    public CalendarItemInfo getCalendarItemInfo(int componentId) {
        if (this.mCalendarItemInfos != null && (componentId < 0 || componentId < this.mCalendarItemInfos.size())) {
            return this.mCalendarItemInfos.get(componentId);
        }
        return null;
    }

    public String getCalendarIntendedFor() {
        return this.mCalendarIntendedFor;
    }

    public MimeMessage getMimeMessage() throws ServiceException {
        return this.getMimeMessage(true);
    }

    public MimeMessage getMimeMessage(boolean runConverters) throws ServiceException {
        return MessageCache.getMimeMessage(this, runConverters);
    }

    @Override
    boolean isTaggable() {
        return true;
    }

    @Override
    boolean isCopyable() {
        return true;
    }

    @Override
    boolean isMovable() {
        return true;
    }

    @Override
    boolean isMutable() {
        return this.isTagged(-7);
    }

    @Override
    boolean isIndexed() {
        return true;
    }

    @Override
    boolean canHaveChildren() {
        return false;
    }

    @Override
    boolean canParent(MailItem item) {
        return false;
    }

    static Message create(int id, Folder folder, Conversation conv, ParsedMessage pm, StagedBlob staged, boolean unread, int flags, long tags, DraftInfo dinfo, boolean noICal, ZCalendar.ZVCalendar cal, MailItem.CustomMetadata.CustomMetadataList extended) throws ServiceException, IOException {
        return Message.createInternal(id, folder, conv, pm, staged, unread, flags, tags, dinfo, noICal, cal, extended, new MessageCreateFactory());
    }

    protected static Message createInternal(int id, Folder folder, Conversation conv, ParsedMessage pm, StagedBlob staged, boolean unread, int flags, long tags, DraftInfo dinfo, boolean noICal, ZCalendar.ZVCalendar cal, MailItem.CustomMetadata.CustomMetadataList extended, MessageCreateFactory fact) throws ServiceException, IOException {
        if (folder == null || !folder.canContain((byte)5)) {
            throw MailServiceException.CANNOT_CONTAIN(folder, (byte)5);
        }
        if (!folder.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        Mailbox mbox = folder.getMailbox();
        Account acct = mbox.getAccount();
        List<Invite> components = null;
        String methodStr = null;
        if (cal != null && folder.getId() != 4 && folder.getId() != 3) {
            boolean sentByMe = false;
            String pmSender = pm.getSenderEmail();
            if (pmSender != null && pmSender.length() > 0) {
                sentByMe = AccountUtil.addressMatchesAccount(acct, pmSender);
            }
            try {
                components = Invite.createFromCalendar(acct, pm.getFragment(), cal, sentByMe, mbox, id);
                methodStr = cal.getPropVal(ZCalendar.ICalTok.METHOD, ZCalendar.ICalTok.PUBLISH.toString()).toUpperCase();
                if (components != null) {
                    flags |= Flag.BITMASK_INVITE;
                    if (ZCalendar.ICalTok.PUBLISH.toString().equals(methodStr) && !acct.getBooleanAttr("zimbraPrefCalendarAllowPublishMethodInvite", false)) {
                        flags |= Flag.BITMASK_ATTACHED;
                        components = null;
                    }
                }
            }
            catch (Exception e) {
                ZimbraLog.calendar.warn((Object)"Unable to process iCalendar attachment", e);
            }
        }
        long date = pm.getReceivedDate();
        long now = System.currentTimeMillis();
        if (date < 0L || date > now) {
            date = now;
        }
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = fact.getType();
        if (conv != null) {
            data.parentId = conv.getId();
        }
        data.folderId = folder.getId();
        if (!folder.inSpam() || acct.getBooleanAttr("zimbraJunkMessagesIndexingEnabled", false)) {
            data.indexId = mbox.generateIndexId(id);
        }
        data.locator = staged.getStagedLocator();
        data.imapId = id;
        data.date = (int)(date / 1000L);
        data.size = staged.getStagedSize();
        data.setBlobDigest(staged.getStagedDigest());
        data.flags = flags & (Flag.FLAGS_MESSAGE | Flag.FLAGS_GENERIC);
        data.tags = tags;
        data.subject = pm.getNormalizedSubject();
        data.metadata = Message.encodeMetadata(DEFAULT_COLOR_RGB, 1, extended, pm, flags, dinfo, null, null);
        data.unreadCount = unread ? 1 : 0;
        data.contentChanged(mbox);
        ZimbraLog.mailop.info("Adding Message: id=%d, Message-ID=%s, parentId=%d, folderId=%d, folderName=%s.", data.id, pm.getMessageID(), data.parentId, folder.getId(), folder.getName());
        DbMailItem.create(mbox, data, pm.getParsedSender().getSortString());
        Message msg = fact.create(mbox, data);
        if (components != null) {
            try {
                msg.processInvitesAfterCreate(methodStr, folder.getId(), !noICal, pm, components, cal);
            }
            catch (Exception e) {
                ZimbraLog.calendar.warn((Object)"Unable to process iCalendar attachment", e);
            }
        }
        msg.finishCreation(conv);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processInvitesAfterCreate(String method, int folderId, boolean createCalItem, ParsedMessage pm, List<Invite> invites, ZCalendar.ZVCalendar cal) throws ServiceException {
        String forwarder;
        CreateCalendarItemPlayer player;
        boolean intendedForMe;
        String intendedForAddress;
        boolean isForwardedInvite;
        OperationContext octxt;
        Account acct;
        block46: {
            if (pm == null) {
                throw ServiceException.INVALID_REQUEST("null ParsedMessage while processing invite in message " + this.mId, null);
            }
            acct = this.getAccount();
            octxt = this.getMailbox().getOperationContext();
            isForwardedInvite = false;
            intendedForAddress = null;
            intendedForMe = true;
            try {
                String headerVal = pm.getMimeMessage().getHeader("X-Zimbra-Calendar-Intended-For", null);
                if (headerVal == null || headerVal.length() <= 0) break block46;
                isForwardedInvite = true;
                intendedForAddress = headerVal;
                intendedForMe = AccountUtil.addressMatchesAccount(acct, headerVal);
                if (!intendedForMe) {
                    this.mCalendarIntendedFor = headerVal;
                }
            }
            catch (MessagingException e) {
                ZimbraLog.calendar.warn((Object)"ignoring error while checking for X-Zimbra-Calendar-Intended-For header on incoming message", e);
            }
        }
        boolean autoAddNew = octxt != null && octxt.getPlayer() instanceof CreateCalendarItemPlayer ? (player = (CreateCalendarItemPlayer)((Object)octxt.getPlayer())).getCalendarItemId() != 0 : acct.isPrefCalendarAutoAddInvites();
        boolean isOrganizerMethod = Invite.isOrganizerMethod(method);
        if (!invites.isEmpty() && intendedForMe && isOrganizerMethod) {
            boolean canInvite;
            String senderEmail;
            Account senderAcct = null;
            boolean onBehalfOf = false;
            AccessManager accessMgr = AccessManager.getInstance();
            if (octxt != null && octxt.getAuthenticatedUser() != null) {
                onBehalfOf = octxt.isDelegatedRequest(this.getMailbox());
                senderAcct = octxt.getAuthenticatedUser();
                senderEmail = senderAcct.getName();
                canInvite = accessMgr.canDo(senderAcct, (Entry)acct, (Right)Rights.User.R_invite, octxt.isUsingAdminPrivileges());
            } else {
                senderEmail = pm.getSenderEmail(false);
                if (senderEmail != null) {
                    senderAcct = Provisioning.getInstance().get(Provisioning.AccountBy.name, senderEmail);
                }
                canInvite = accessMgr.canDo(senderEmail, (Entry)acct, (Right)Rights.User.R_invite, false);
            }
            if (!canInvite) {
                boolean directAttendee;
                Invite invite = invites.get(0);
                boolean sameDomain = false;
                if (senderAcct != null) {
                    String senderDomain = senderAcct.getDomainName();
                    sameDomain = senderDomain != null && senderDomain.equalsIgnoreCase(acct.getDomainName());
                }
                boolean bl = directAttendee = DebugConfig.calendarEnableInviteDeniedReplyForUnlistedAttendee || invite.getMatchingAttendee(acct) != null;
                if (acct.isPrefCalendarSendInviteDeniedAutoReply() && senderEmail != null && sameDomain && directAttendee) {
                    boolean needAutoReply;
                    RedoableOp redoPlayer = octxt != null ? octxt.getPlayer() : null;
                    RedoLogProvider redoProvider = RedoLogProvider.getInstance();
                    boolean bl2 = needAutoReply = redoProvider.isMaster() && (redoPlayer == null || redoProvider.getRedoLogManager().getInCrashRecovery());
                    if (needAutoReply) {
                        ItemId origMsgId = new ItemId(this.getMailbox(), this.getId());
                        CalendarMailSender.sendInviteDeniedMessage(octxt, acct, senderAcct, onBehalfOf, true, this.getMailbox(), origMsgId, senderEmail, invite);
                    }
                }
                String sender = senderEmail != null ? senderEmail : "unkonwn sender";
                ZimbraLog.calendar.info("Calendar invite from " + sender + " to " + acct.getName() + " is not allowed");
                autoAddNew = false;
            }
        }
        boolean updatedMetadata = false;
        ZAttrProvisioning.PrefCalendarApptVisibility prefClass = acct.getPrefCalendarApptVisibility();
        boolean forcePrivateClass = prefClass != null && !prefClass.equals((Object)ZAttrProvisioning.PrefCalendarApptVisibility.public_);
        boolean allowOrganizerAlarm = DebugConfig.calendarAllowOrganizerSpecifiedAlarms;
        if (this.mCalendarItemInfos == null) {
            this.mCalendarItemInfos = new ArrayList();
        }
        if (invites.size() > 1) {
            ZOrganizer seriesOrganizer = null;
            boolean seriesIsOrganizer = false;
            List<ZAttendee> seriesAttendees = null;
            for (Invite inv : invites) {
                if (inv.hasRecurId()) continue;
                seriesOrganizer = inv.getOrganizer();
                seriesIsOrganizer = inv.isOrganizer();
                seriesAttendees = inv.getAttendees();
                break;
            }
            if (seriesOrganizer != null) {
                for (Invite inv : invites) {
                    if (!inv.hasRecurId() || inv.hasOrganizer()) continue;
                    inv.setOrganizer(seriesOrganizer);
                    inv.setIsOrganizer(seriesIsOrganizer);
                    if (inv.hasOtherAttendees() || seriesAttendees == null) continue;
                    for (ZAttendee at : seriesAttendees) {
                        inv.addAttendee(at);
                    }
                }
            }
        }
        HashSet<String> calUidsSeen = new HashSet<String>();
        for (Invite cur : invites) {
            Object var33_64;
            boolean success;
            CalendarItem calItem;
            block48: {
                block47: {
                    boolean addRevision;
                    String fromEmail;
                    if (!cur.hasOrganizer() && cur.hasOtherAttendees() && (fromEmail = pm.getSenderEmail(true)) != null) {
                        boolean dangerousSender = false;
                        if (intendedForAddress != null) {
                            if (intendedForAddress.equalsIgnoreCase(fromEmail)) {
                                ZimbraLog.calendar.info("Got malformed invite without organizer.  Clearing attendees to prevent inadvertent cancels.");
                                cur.clearAttendees();
                                dangerousSender = true;
                            }
                        } else if (AccountUtil.addressMatchesAccount(acct, fromEmail)) {
                            ZimbraLog.calendar.info("Got malformed invite without organizer.  Clearing attendees to prevent inadvertent cancels.");
                            cur.clearAttendees();
                            dangerousSender = true;
                        }
                        if (!dangerousSender) {
                            ZOrganizer org = new ZOrganizer(fromEmail, null);
                            String senderEmail = pm.getSenderEmail(false);
                            if (senderEmail != null && !senderEmail.equalsIgnoreCase(fromEmail)) {
                                org.setSentBy(senderEmail);
                            }
                            cur.setOrganizer(org);
                            ZimbraLog.calendar.info("Got malformed invite that lists attendees without specifying an organizer.  Defaulting organizer to: " + org.toString());
                        }
                    }
                    cur.setLocalOnly(false);
                    String uid = cur.getUid();
                    if (!calUidsSeen.contains(uid)) {
                        addRevision = true;
                        calUidsSeen.add(uid);
                    } else {
                        addRevision = false;
                    }
                    if (cur.isEvent() && acct instanceof CalendarResource) {
                        cur.setFreeBusy("B");
                        cur.setTransparency("O");
                    }
                    if (forcePrivateClass) {
                        cur.setClassProp("PRI");
                        cur.setClassPropSetByMe(true);
                    }
                    ZCalendar.ICalTok methodTok = Invite.lookupMethod(method);
                    if (!allowOrganizerAlarm && cur.isEvent() && isOrganizerMethod && !cur.isCancel() && !ZCalendar.ICalTok.DECLINECOUNTER.equals((Object)methodTok)) {
                        Invite.setDefaultAlarm(cur, acct);
                    }
                    boolean calItemIsNew = false;
                    boolean modifiedCalItem = false;
                    calItem = null;
                    success = false;
                    try {
                        block52: {
                            block49: {
                                block50: {
                                    block51: {
                                        if (!intendedForMe) break block49;
                                        calItem = this.mMailbox.getCalendarItemByUid(cur.getUid());
                                        if (!createCalItem || ZCalendar.ICalTok.COUNTER.equals((Object)methodTok) || ZCalendar.ICalTok.DECLINECOUNTER.equals((Object)methodTok)) break block50;
                                        if (calItem != null) break block51;
                                        if (ZCalendar.ICalTok.REQUEST.equals((Object)methodTok) || ZCalendar.ICalTok.PUBLISH.equals((Object)methodTok) && this.getAccount().getBooleanAttr("zimbraPrefCalendarAllowPublishMethodInvite", false)) {
                                            if (autoAddNew) {
                                                int flags = 0;
                                                int defaultFolder = cur.isTodo() ? 15 : 10;
                                                calItem = this.mMailbox.createCalendarItem(defaultFolder, flags, 0L, cur.getUid(), pm, cur, null);
                                                calItemIsNew = true;
                                            }
                                            break block50;
                                        } else {
                                            sLog.info("Mailbox " + this.getMailboxId() + " Message " + this.getId() + " SKIPPING Invite " + method + " b/c no CalendarItem could be found");
                                            success = true;
                                            var33_64 = null;
                                            if (success || calItem == null) continue;
                                            break block47;
                                        }
                                    }
                                    boolean ignore = false;
                                    Invite defInv = calItem.getDefaultInviteOrNull();
                                    if (defInv != null && defInv.isOrganizer()) {
                                        String orgAddress;
                                        ZOrganizer org = cur.getOrganizer();
                                        String string = orgAddress = org != null ? org.getAddress() : null;
                                        if (AccountUtil.addressMatchesAccount(acct, orgAddress)) {
                                            boolean bl = ignore = !acct.getBooleanAttr("zimbraPrefCalendarAllowCancelEmailToSelf", false);
                                        }
                                    }
                                    if (ignore) {
                                        ZimbraLog.calendar.info("Ignoring calendar request emailed from organizer to self, possibly in a mail loop involving mailing lists and/or forwards; calItemId=" + calItem.getId() + ", msgId=" + this.getId());
                                    } else {
                                        if (addRevision) {
                                            calItem.snapshotRevision();
                                        }
                                        boolean discardExistingInvites = false;
                                        int calFolderId = calItem.getFolderId();
                                        if (!cur.isCancel() && calFolderId == 3) {
                                            discardExistingInvites = true;
                                            calFolderId = calItem.getType() == 15 ? 15 : 10;
                                        }
                                        modifiedCalItem = calItem.processNewInvite(pm, cur, calFolderId, discardExistingInvites);
                                    }
                                }
                                int calItemId = calItem != null ? calItem.getId() : 0;
                                CalendarItemInfo info = new CalendarItemInfo(calItemId, cur.getComponentNum(), cur);
                                this.mCalendarItemInfos.add(info);
                                updatedMetadata = true;
                                if (calItem != null && (calItemIsNew || modifiedCalItem)) {
                                    this.mMailbox.queueForIndexing(calItem, !calItemIsNew, null);
                                }
                                break block52;
                            }
                            CalendarItemInfo info = new CalendarItemInfo(0, cur.getComponentNum(), cur);
                            this.mCalendarItemInfos.add(info);
                            updatedMetadata = true;
                        }
                        success = true;
                        break block48;
                    }
                    catch (Throwable throwable) {
                        var33_64 = null;
                        if (success) throw throwable;
                        if (calItem == null) throw throwable;
                        this.getMailbox().uncache(calItem);
                        throw throwable;
                    }
                }
                this.getMailbox().uncache(calItem);
                continue;
            }
            var33_64 = null;
            if (success || calItem == null) continue;
            this.getMailbox().uncache(calItem);
        }
        if (updatedMetadata) {
            this.saveMetadata();
        }
        if (isForwardedInvite) return;
        if (!intendedForMe) return;
        if (!isOrganizerMethod) return;
        if (folderId == 5) return;
        RedoableOp redoPlayer = octxt != null ? octxt.getPlayer() : null;
        RedoLogProvider redoProvider = RedoLogProvider.getInstance();
        if (!redoProvider.isMaster()) return;
        if (redoPlayer != null) {
            if (!redoProvider.getRedoLogManager().getInCrashRecovery()) return;
        }
        boolean bl = true;
        boolean needToForward = bl;
        if (!needToForward) return;
        String[] forwardTo = acct.getPrefCalendarForwardInvitesTo();
        if (forwardTo == null) return;
        if (forwardTo.length <= 0) return;
        ArrayList<String> sanitizedTo = new ArrayList<String>();
        for (String fwd : forwardTo) {
            if (AccountUtil.addressMatchesAccount(acct, fwd)) continue;
            sanitizedTo.add(fwd);
        }
        if (sanitizedTo.isEmpty()) return;
        MimeMessage mmOrig = pm.getMimeMessage();
        if (mmOrig == null) return;
        String origSender = pm.getSenderEmail(false);
        MimeMessage mm = CalendarMailSender.createForwardedInviteMessage(mmOrig, origSender, forwarder = AccountUtil.getCanonicalAddress(acct), sanitizedTo.toArray(new String[0]));
        if (mm == null) return;
        ItemId origMsgId = new ItemId(this.getMailbox(), this.getId());
        CalendarMailSender.sendInviteForwardMessage(octxt, this.getMailbox(), origMsgId, mm);
    }

    void updateBlobData(MailboxBlob mblob) throws IOException, ServiceException {
        long size = mblob.getSize();
        if (this.getSize() == size && StringUtil.equal(this.getDigest(), mblob.getDigest()) && StringUtil.equal(this.getLocator(), mblob.getLocator())) {
            return;
        }
        this.mMailbox.updateSize(size - this.mData.size, true);
        this.getFolder().updateSize(0, size - this.mData.size);
        this.mData.size = size;
        this.mData.locator = mblob.getLocator();
        this.mData.setBlobDigest(mblob.getDigest());
        DbMailItem.saveBlobInfo(this);
    }

    @Override
    void setCustomData(MailItem.CustomMetadata custom) throws ServiceException {
        super.setCustomData(custom);
        ((Conversation)this.getParent()).inheritedCustomDataChanged(this, custom);
    }

    @Override
    protected void updateUnread(int delta) throws ServiceException {
        if (delta == 0 || !this.trackUnread()) {
            return;
        }
        this.markItemModified(1);
        MailItem parent = this.getParent();
        this.mData.unreadCount += delta;
        if (this.mData.unreadCount < 0) {
            throw ServiceException.FAILURE("inconsistent state: unread < 0 for " + this.getClass().getName() + " " + this.mId, null);
        }
        this.getFolder().updateUnread(delta);
        if (parent != null) {
            parent.updateUnread(delta);
        }
        this.updateTagUnread(delta);
    }

    @Override
    MailItem copy(Folder folder, int id, int parentId) throws IOException, ServiceException {
        Message copy = (Message)super.copy(folder, id, parentId);
        Conversation parent = (Conversation)this.getParent();
        if (parent instanceof VirtualConversation && parent.getId() == parentId && !this.isDraft() && this.inSpam() == folder.inSpam()) {
            Conversation conv = this.mMailbox.createConversation(new Message[]{this, copy}, -1);
            DbMailItem.changeOpenTarget(Mailbox.getHash(this.getNormalizedSubject()), this, conv.getId());
            parent.removeChild(this);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexDocument> generateIndexData(boolean doConsistencyCheck) throws MailItem.TemporaryIndexingException {
        try {
            ParsedMessage pm = null;
            Mailbox mailbox = this.getMailbox();
            synchronized (mailbox) {
                ParsedMessageOptions opt = new ParsedMessageOptions().setContent(this.getMimeMessage(false)).setReceivedDate(this.getDate()).setAttachmentIndexing(this.getMailbox().attachmentsIndexingEnabled()).setSize(this.getSize()).setDigest(this.getDigest());
                pm = new ParsedMessage(opt);
            }
            if (doConsistencyCheck) {
                boolean subjectChanged;
                String fragment = pm.getFragment();
                boolean fragmentChanged = !this.getFragment().equals(fragment == null ? "" : fragment);
                String subject = pm.getNormalizedSubject();
                boolean bl = subjectChanged = !this.getNormalizedSubject().equals(subject == null ? "" : subject);
                if (fragmentChanged || subjectChanged) {
                    this.getMailbox().reanalyze(this.getId(), this.getType(), pm);
                }
            }
            pm.analyzeFully();
            if (pm.hasTemporaryAnalysisFailure()) {
                throw new MailItem.TemporaryIndexingException();
            }
            return pm.getLuceneDocuments();
        }
        catch (ServiceException e) {
            ZimbraLog.index.warn((Object)("Unable to generate index data for Message " + this.getId() + ". Item will not be indexed"), e);
            return new ArrayList<IndexDocument>(0);
        }
    }

    public void reanalyze() throws ServiceException {
        ParsedMessageOptions opt = new ParsedMessageOptions().setContent(this.getMimeMessage(false)).setReceivedDate(this.getDate()).setAttachmentIndexing(this.getMailbox().attachmentsIndexingEnabled()).setSize(this.getSize()).setDigest(this.getDigest());
        ParsedMessage pm = new ParsedMessage(opt);
        this.reanalyze(pm);
    }

    @Override
    void reanalyze(Object data) throws ServiceException {
        int size;
        if (!(data instanceof ParsedMessage)) {
            throw ServiceException.FAILURE("cannot reanalyze non-ParsedMessage object", null);
        }
        ParsedMessage pm = (ParsedMessage)data;
        try {
            size = pm.getRawSize();
        }
        catch (Exception e) {
            throw MailServiceException.MESSAGE_PARSE_ERROR(e);
        }
        MailItem parent = this.getParent();
        if (!this.getSubject().equals(pm.getSubject())) {
            this.markItemModified(64);
        }
        this.mRawSubject = pm.getSubject();
        this.mData.subject = pm.getNormalizedSubject();
        this.mFragment = pm.getFragment();
        boolean hadAttachment = (this.mData.flags & Flag.BITMASK_ATTACHED) != 0;
        this.mData.flags &= ~Flag.BITMASK_ATTACHED;
        if (pm.hasAttachments()) {
            this.mData.flags |= Flag.BITMASK_ATTACHED;
        }
        if (hadAttachment != pm.hasAttachments()) {
            this.markItemModified(4);
            parent.tagChanged(this.mMailbox.getFlagById(-2), pm.hasAttachments());
        }
        int oldUrgency = this.mData.flags & (Flag.BITMASK_HIGH_PRIORITY | Flag.BITMASK_LOW_PRIORITY);
        int urgency = pm.getPriorityBitmask();
        this.mData.flags &= ~(Flag.BITMASK_HIGH_PRIORITY | Flag.BITMASK_LOW_PRIORITY);
        this.mData.flags |= urgency;
        if (oldUrgency != urgency) {
            this.markItemModified(4);
            if (urgency == Flag.BITMASK_HIGH_PRIORITY || oldUrgency == Flag.BITMASK_HIGH_PRIORITY) {
                parent.tagChanged(this.mMailbox.getFlagById(-11), urgency == Flag.BITMASK_HIGH_PRIORITY);
            }
            if (urgency == Flag.BITMASK_LOW_PRIORITY || oldUrgency == Flag.BITMASK_LOW_PRIORITY) {
                parent.tagChanged(this.mMailbox.getFlagById(-12), urgency == Flag.BITMASK_LOW_PRIORITY);
            }
        }
        if (this.mData.size != (long)size) {
            this.markItemModified(16);
            this.mMailbox.updateSize((long)size - this.mData.size, false);
            this.getFolder().updateSize(0, (long)size - this.mData.size);
            this.mData.size = size;
        }
        String metadata = Message.encodeMetadata(this.mRGBColor, this.mVersion, this.mExtendedData, pm, this.mData.flags, this.mDraftInfo, this.mCalendarItemInfos, this.mCalendarIntendedFor);
        this.saveData(pm.getParsedSender().getSortString(), metadata);
        if (parent instanceof VirtualConversation) {
            ((VirtualConversation)parent).recalculateMetadata(Arrays.asList(this));
        }
    }

    @Override
    void detach() throws ServiceException {
        MailItem parent = this.getParent();
        if (!(parent instanceof Conversation)) {
            return;
        }
        if (parent.getSize() <= 1L) {
            this.mMailbox.closeConversation((Conversation)parent, null);
        } else {
            this.markItemModified(512);
            parent.removeChild(this);
            VirtualConversation vconv = new VirtualConversation(this.mMailbox, this);
            this.mData.parentId = vconv.getId();
            DbMailItem.setParent(this, (MailItem)vconv);
        }
    }

    @Override
    void delete(MailItem.DeleteScope scope, boolean writeTombstones) throws ServiceException {
        MailItem parent = this.getParent();
        if (parent instanceof Conversation && ((Conversation)parent).getMessageCount() == 1) {
            parent.delete(MailItem.DeleteScope.ENTIRE_ITEM, writeTombstones);
        } else {
            super.delete(scope, writeTombstones);
        }
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        String rawSubject;
        super.decodeMetadata(meta);
        this.mSender = meta.get("s", null);
        this.mRecipients = meta.get("t", null);
        this.mFragment = meta.get("f", null);
        if (meta.containsKey("ais")) {
            this.mCalendarItemInfos = new ArrayList();
            MetadataList mdList = meta.getList("ais");
            for (int i = 0; i < mdList.size(); ++i) {
                Metadata md = mdList.getMap(i);
                this.mCalendarItemInfos.add(CalendarItemInfo.decodeMetadata(md, this.getMailbox()));
            }
        }
        this.mCalendarIntendedFor = meta.get("cif", null);
        Metadata draftMeta = meta.getMap("d", true);
        if (draftMeta != null) {
            this.mDraftInfo = new DraftInfo(draftMeta);
        }
        this.mRawSubject = this.mData.subject;
        String prefix = meta.get("p", null);
        if (prefix != null) {
            String string = this.mRawSubject = this.mData.subject == null ? prefix : prefix + this.mData.subject;
        }
        if ((rawSubject = meta.get("r", null)) != null) {
            this.mRawSubject = rawSubject;
        }
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return Message.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mSender, this.mRecipients, this.mFragment, this.mData.subject, this.mRawSubject, this.mDraftInfo, this.mCalendarItemInfos, this.mCalendarIntendedFor);
    }

    private static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, ParsedMessage pm, int flags, DraftInfo dinfo, List<CalendarItemInfo> calItemInfos, String calIntendedFor) {
        String recipients = (flags & Flag.BITMASK_FROM_ME) == 0 ? null : pm.getRecipients();
        return Message.encodeMetadata(new Metadata(), color, version, extended, pm.getSender(), recipients, pm.getFragment(), pm.getNormalizedSubject(), pm.getSubject(), dinfo, calItemInfos, calIntendedFor).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, String sender, String recipients, String fragment, String subject, String rawSubject, DraftInfo dinfo, List<CalendarItemInfo> calItemInfos, String calIntendedFor) {
        String prefix = null;
        if (rawSubject == null || rawSubject.equals(subject)) {
            rawSubject = null;
        } else if (rawSubject.endsWith(subject)) {
            prefix = rawSubject.substring(0, rawSubject.length() - subject.length());
            rawSubject = null;
        }
        meta.put("s", sender);
        meta.put("t", recipients);
        meta.put("f", fragment);
        meta.put("p", prefix);
        meta.put("r", rawSubject);
        if (calItemInfos != null) {
            MetadataList mdList = new MetadataList();
            for (CalendarItemInfo info : calItemInfos) {
                mdList.add(info.encodeMetadata());
            }
            meta.put("ais", mdList);
        }
        meta.put("cif", calIntendedFor);
        if (dinfo != null) {
            Metadata dmeta = new Metadata();
            dmeta.put("do", dinfo.origId);
            dmeta.put("dt", dinfo.replyType);
            dmeta.put("idnt", dinfo.identityId);
            dmeta.put("aid", dinfo.accountId);
            meta.put("d", dmeta);
        }
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("message: {");
        this.appendCommonMembers(sb);
        sb.append(CN_SENDER).append(": ").append(this.mSender).append(", ");
        if (this.mRecipients != null) {
            sb.append(CN_RECIPIENTS).append(": ").append(this.mRecipients).append(", ");
        }
        sb.append(CN_FRAGMENT).append(": ").append(this.mFragment);
        sb.append("}");
        return sb.toString();
    }

    static class MessageCreateFactory {
        MessageCreateFactory() {
        }

        Message create(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
            return new Message(mbox, data);
        }

        byte getType() {
            return 5;
        }
    }

    public static class CalendarItemInfo {
        public static final int CALITEM_ID_NONE = 0;
        private int mCalendarItemId;
        private int mComponentNo;
        private Invite mInvite;
        private static final String FN_CALITEMID = "a";
        private static final String FN_COMPNO = "c";
        private static final String FN_INV = "inv";

        CalendarItemInfo(int calItemId, int componentNo, Invite inv) {
            this.mCalendarItemId = calItemId;
            this.mComponentNo = componentNo;
            this.mInvite = inv;
        }

        public int getCalendarItemId() {
            return this.mCalendarItemId;
        }

        public int getComponentNo() {
            return this.mComponentNo;
        }

        public Invite getInvite() {
            return this.mInvite;
        }

        public boolean calItemCreated() {
            return this.mCalendarItemId != 0;
        }

        Metadata encodeMetadata() {
            Metadata meta = new Metadata();
            meta.put(FN_CALITEMID, this.mCalendarItemId);
            meta.put(FN_COMPNO, this.mComponentNo);
            if (this.mInvite != null) {
                meta.put(FN_INV, Invite.encodeMetadata(this.mInvite));
            }
            return meta;
        }

        static CalendarItemInfo decodeMetadata(Metadata meta, Mailbox mbox) throws ServiceException {
            int calItemId = (int)meta.getLong(FN_CALITEMID, 0L);
            int componentNo = (int)meta.getLong(FN_COMPNO);
            Invite inv = null;
            Metadata metaInv = meta.getMap(FN_INV, true);
            if (metaInv != null) {
                long mboxId = mbox.getId();
                ICalTimeZone accountTZ = ICalTimeZone.getAccountTimeZone(mbox.getAccount());
                inv = Invite.decodeMetadata(mboxId, metaInv, null, accountTZ);
            }
            return new CalendarItemInfo(calItemId, componentNo, inv);
        }
    }

    static class DraftInfo {
        String accountId;
        String identityId;
        String replyType;
        String origId;

        public DraftInfo() {
        }

        public DraftInfo(String ident) {
            this.identityId = ident;
        }

        public DraftInfo(String rt, String id) {
            this.replyType = rt;
            this.origId = id;
        }

        public DraftInfo(String rt, String id, String ident) {
            this.replyType = rt;
            this.origId = id;
            this.identityId = ident;
        }

        public DraftInfo(String rt, String id, String ident, String account) {
            this.replyType = rt;
            this.origId = id;
            this.identityId = ident;
            this.accountId = account;
        }

        public DraftInfo(Metadata meta) {
            this.accountId = meta.get("aid", null);
            this.identityId = meta.get("idnt", null);
            this.replyType = meta.get("dt", null);
            this.origId = meta.get("do", null);
        }
    }
}

