/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;

public class MailboxVersion {
    private static final short CURRENT_MAJOR = 1;
    private static final short CURRENT_MINOR = 6;
    private short mMajorVer;
    private short mMinorVer;

    static MailboxVersion CURRENT() {
        return new MailboxVersion();
    }

    MailboxVersion() {
        this.mMajorVer = 1;
        this.mMinorVer = (short)6;
    }

    MailboxVersion(short major, short minor) {
        this.mMajorVer = major;
        this.mMinorVer = minor;
    }

    MailboxVersion(MailboxVersion other) {
        this.mMajorVer = other.mMajorVer;
        this.mMinorVer = other.mMinorVer;
    }

    static MailboxVersion fromMetadata(Metadata md) throws ServiceException {
        short majorVer = 1;
        short minorVer = 0;
        if (md != null) {
            majorVer = (short)md.getLong("vmaj", 1L);
            minorVer = (short)md.getLong("vmin", 0L);
        }
        return new MailboxVersion(majorVer, minorVer);
    }

    Metadata writeToMetadata(Metadata md) {
        md.put("vmaj", this.mMajorVer);
        md.put("vmin", this.mMinorVer);
        return md;
    }

    public boolean atLeast(int major, int minor) {
        return this.mMajorVer > major || this.mMajorVer == major && this.mMinorVer >= minor;
    }

    public boolean atLeast(MailboxVersion b) {
        return this.atLeast(b.mMajorVer, b.mMinorVer);
    }

    public boolean isLatest() {
        return this.mMajorVer == 1 && this.mMinorVer == 6;
    }

    public boolean tooHigh() {
        return this.mMajorVer > 1 || this.mMajorVer == 1 && this.mMinorVer > 6;
    }

    public String toString() {
        return Integer.toString(this.mMajorVer) + "." + Integer.toString(this.mMinorVer);
    }
}

