/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.extension.ExtensionUtil;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.IndexHelper;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.redolog.op.CreateMailbox;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.util.Zimbra;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailboxManager {
    private CopyOnWriteArrayList<Listener> mListeners = new CopyOnWriteArrayList();
    private static MailboxManager sInstance;
    private Map<String, Long> mMailboxIds;
    private MailboxMap mMailboxCache;

    public void addListener(Listener listener) {
        assert (!this.mListeners.contains(listener));
        this.mListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        assert (this.mListeners.contains(listener));
        this.mListeners.remove(listener);
    }

    private void notifyMailboxAvailable(Mailbox mbox) {
        if (ZimbraLog.mbxmgr.isInfoEnabled()) {
            ZimbraLog.mbxmgr.info("Mailbox " + mbox.getId() + " account " + mbox.getAccountId() + " AVAILABLE");
        }
        for (Listener listener : this.mListeners) {
            listener.mailboxAvailable(mbox);
        }
    }

    private void notifyMailboxLoaded(Mailbox mbox) {
        if (ZimbraLog.mbxmgr.isInfoEnabled()) {
            ZimbraLog.mbxmgr.info("Mailbox " + mbox.getId() + " account " + mbox.getAccountId() + " LOADED");
        }
        for (Listener listener : this.mListeners) {
            listener.mailboxLoaded(mbox);
        }
    }

    private void notifyMailboxCreated(Mailbox mbox) {
        if (ZimbraLog.mbxmgr.isInfoEnabled()) {
            ZimbraLog.mbxmgr.info("Mailbox " + mbox.getId() + " account " + mbox.getAccountId() + " CREATED");
        }
        for (Listener listener : this.mListeners) {
            listener.mailboxCreated(mbox);
        }
    }

    private void notifyMailboxDeleted(String accountId) {
        if (ZimbraLog.mbxmgr.isInfoEnabled()) {
            ZimbraLog.mbxmgr.info("Mailbox for account " + accountId + " DELETED");
        }
        for (Listener listener : this.mListeners) {
            listener.mailboxDeleted(accountId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailboxManager() throws ServiceException {
        DbPool.Connection conn = null;
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            try {
                conn = DbPool.getConnection();
                this.mMailboxIds = DbMailbox.listMailboxes(conn, this);
                this.mMailboxCache = new MailboxMap(LC.zimbra_mailbox_manager_hardref_cache.intValue());
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
        }
    }

    public static synchronized MailboxManager getInstance() throws ServiceException {
        if (sInstance == null) {
            String className = LC.zimbra_class_mboxmanager.value();
            if (className != null && !className.equals("")) {
                try {
                    try {
                        sInstance = (MailboxManager)Class.forName(className).newInstance();
                    }
                    catch (ClassNotFoundException cnfe) {
                        sInstance = (MailboxManager)ExtensionUtil.findClass(className).newInstance();
                    }
                }
                catch (Exception e) {
                    ZimbraLog.account.error((Object)("could not instantiate MailboxManager interface of class '" + className + "'; defaulting to MailboxManager"), e);
                }
            }
            if (sInstance == null) {
                sInstance = new MailboxManager();
            }
        }
        return sInstance;
    }

    public static void setInstance(MailboxManager mmgr) {
        sInstance = mmgr;
    }

    public void startup() {
    }

    public void shutdown() {
        IndexHelper.shutdown();
    }

    public Mailbox getMailboxByAccount(Account account) throws ServiceException {
        return this.getMailboxByAccount(account, FetchMode.AUTOCREATE);
    }

    public Mailbox getMailboxByAccount(Account account, boolean autocreate) throws ServiceException {
        return this.getMailboxByAccount(account, autocreate ? FetchMode.AUTOCREATE : FetchMode.DO_NOT_AUTOCREATE);
    }

    public Mailbox getMailboxByAccount(Account account, FetchMode fetchMode) throws ServiceException {
        if (account == null) {
            throw new IllegalArgumentException();
        }
        return this.getMailboxByAccountId(account.getId(), fetchMode);
    }

    public Mailbox getMailboxByAccountId(String accountId) throws ServiceException {
        return this.getMailboxByAccountId(accountId, FetchMode.AUTOCREATE);
    }

    public Mailbox getMailboxByAccountId(String accountId, boolean autocreate) throws ServiceException {
        return this.getMailboxByAccountId(accountId, autocreate ? FetchMode.AUTOCREATE : FetchMode.DO_NOT_AUTOCREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mailbox getMailboxByAccountId(String accountId, FetchMode fetchMode) throws ServiceException {
        Long mailboxKey;
        if (accountId == null) {
            throw new IllegalArgumentException();
        }
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            mailboxKey = this.mMailboxIds.get(accountId.toLowerCase());
        }
        if (mailboxKey != null) {
            if (DebugConfig.mockMultiserverInstall) {
                this.verifyCorrectHost(accountId);
            }
            return this.getMailboxById(mailboxKey, fetchMode, false);
        }
        if (fetchMode != FetchMode.AUTOCREATE) {
            return null;
        }
        Account account = this.verifyCorrectHost(accountId);
        MailboxManager mailboxManager2 = this;
        synchronized (mailboxManager2) {
            mailboxKey = this.mMailboxIds.get(accountId.toLowerCase());
        }
        if (mailboxKey != null) {
            return this.getMailboxById(mailboxKey, fetchMode, false);
        }
        return this.createMailbox(null, account);
    }

    private Account verifyCorrectHost(String accountId) throws ServiceException {
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId);
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(accountId);
        }
        if (!Provisioning.onLocalServer(account)) {
            throw ServiceException.WRONG_HOST(account.getAttr("zimbraMailHost"), null);
        }
        return account;
    }

    public Mailbox getMailboxById(long mailboxId) throws ServiceException {
        return this.getMailboxById(mailboxId, FetchMode.DO_NOT_AUTOCREATE, false);
    }

    public Mailbox getMailboxById(long mailboxId, boolean skipMailHostCheck) throws ServiceException {
        return this.getMailboxById(mailboxId, FetchMode.DO_NOT_AUTOCREATE, skipMailHostCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Mailbox getMailboxById(long mailboxId, FetchMode fetchMode, boolean skipMailHostCheck) throws ServiceException {
        Account account;
        Mailbox.MailboxData data;
        assert (fetchMode == FetchMode.ONLY_IF_CACHED || !Thread.holdsLock(this));
        if (mailboxId <= 0L) {
            throw MailServiceException.NO_SUCH_MBOX(mailboxId);
        }
        long startTime = ZimbraPerf.STOPWATCH_MBOX_GET.start();
        MailboxManager mailboxManager = this;
        // MONITORENTER : mailboxManager
        Object cached = this.retrieveFromCache(mailboxId, true);
        if (cached instanceof Mailbox) {
            ZimbraPerf.STOPWATCH_MBOX_GET.stop(startTime);
            ZimbraPerf.COUNTER_MBOX_CACHE.increment(100L);
            // MONITOREXIT : mailboxManager
            return (Mailbox)cached;
        }
        // MONITOREXIT : mailboxManager
        if (fetchMode == FetchMode.ONLY_IF_CACHED) {
            return null;
        }
        ZimbraPerf.COUNTER_MBOX_CACHE.increment(0L);
        cached = DbMailbox.getSynchronizer();
        // MONITORENTER : cached
        DbPool.Connection conn = null;
        try {
            conn = DbPool.getConnection();
            data = DbMailbox.getMailboxStats(conn, mailboxId);
            if (data == null) {
                throw MailServiceException.NO_SUCH_MBOX(mailboxId);
            }
            Object var11_8 = null;
            if (conn != null) {
                DbPool.quietClose(conn);
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (conn == null) throw throwable;
            DbPool.quietClose(conn);
            throw throwable;
        }
        Mailbox mbox = this.instantiateMailbox(data);
        if (!skipMailHostCheck && !Provisioning.onLocalServer(account = mbox.getAccount())) {
            throw ServiceException.WRONG_HOST(account.getAttr("zimbraMailHost"), null);
        }
        MailboxManager mailboxManager2 = this;
        // MONITORENTER : mailboxManager2
        Object cached2 = this.retrieveFromCache(mailboxId, false);
        if (cached2 instanceof Mailbox) {
            mbox = (Mailbox)cached2;
        } else if (cached2 instanceof MailboxLock) {
            ((MailboxLock)cached2).cacheMailbox(mbox);
        } else {
            this.cacheMailbox(mbox);
        }
        // MONITOREXIT : mailboxManager2
        if (mbox.finishInitialization()) {
            this.notifyMailboxLoaded(mbox);
        }
        ZimbraPerf.STOPWATCH_MBOX_GET.stop(startTime);
        return mbox;
    }

    public synchronized List<Mailbox> getAllLoadedMailboxes() {
        ArrayList<Mailbox> mboxes = new ArrayList<Mailbox>(this.mMailboxCache.size());
        for (Object o : this.mMailboxCache.values()) {
            MailboxLock lock;
            if (o instanceof Mailbox) {
                mboxes.add((Mailbox)o);
                continue;
            }
            if (!(o instanceof MailboxLock) || !(lock = (MailboxLock)o).canAccess()) continue;
            mboxes.add(lock.getMailbox());
        }
        return mboxes;
    }

    public synchronized int getCacheSize() {
        int count = 0;
        for (Object o : this.mMailboxCache.values()) {
            if (!(o instanceof Mailbox) && !(o instanceof MailboxLock)) continue;
            ++count;
        }
        return count;
    }

    public synchronized boolean isMailboxLoadedAndAvailable(long mailboxId) {
        Object cached = this.mMailboxCache.get(mailboxId);
        if (cached == null) {
            return false;
        }
        if (cached instanceof MailboxLock) {
            return ((MailboxLock)cached).canAccess();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object retrieveFromCache(long mailboxId, boolean trackGC) throws MailServiceException {
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            Object cached = this.mMailboxCache.get(mailboxId, trackGC);
            if (cached instanceof MailboxLock) {
                MailboxLock lock = (MailboxLock)cached;
                if (!lock.canAccess()) {
                    throw MailServiceException.MAINTENANCE(mailboxId);
                }
                if (lock.getMailbox() != null) {
                    return lock.getMailbox();
                }
            }
            return cached;
        }
    }

    protected Mailbox instantiateMailbox(Mailbox.MailboxData data) throws ServiceException {
        return new Mailbox(data);
    }

    protected synchronized void cacheAccount(String accountId, long mailboxId) {
        this.mMailboxIds.put(accountId.toLowerCase(), new Long(mailboxId));
    }

    private Mailbox cacheMailbox(Mailbox mailbox) {
        this.mMailboxCache.put(mailbox.getId(), (Object)mailbox);
        return mailbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailboxLock beginMaintenance(String accountId, long mailboxId) throws ServiceException {
        Object object;
        Mailbox mbox = this.getMailboxByAccountId(accountId, false);
        if (mbox == null) {
            object = this;
            synchronized (object) {
                if (this.mMailboxIds.get(accountId.toLowerCase()) == null) {
                    MailboxLock lock = new MailboxLock(accountId, mailboxId);
                    this.mMailboxCache.put(mailboxId, (Object)lock);
                    return lock;
                }
            }
            mbox = this.getMailboxByAccountId(accountId);
        }
        object = mbox;
        synchronized (object) {
            MailboxLock lock = mbox.beginMaintenance();
            MailboxManager mailboxManager = this;
            synchronized (mailboxManager) {
                this.mMailboxCache.put(mailboxId, (Object)lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endMaintenance(MailboxLock lock, boolean success, boolean removeFromCache) throws ServiceException {
        if (lock == null) {
            throw ServiceException.INVALID_REQUEST("no lock provided", null);
        }
        Mailbox availableMailbox = null;
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            Object obj = this.mMailboxCache.get(lock.getMailboxId());
            if (obj != lock) {
                throw MailServiceException.MAINTENANCE(lock.getMailboxId());
            }
            this.mMailboxCache.remove(lock.getMailboxId());
            Mailbox mbox = lock.getMailbox();
            if (success) {
                this.cacheAccount(lock.getAccountId(), lock.getMailboxId());
                if (mbox != null) {
                    assert (lock == mbox.getMailboxLock() || mbox.getMailboxLock() == null);
                    mbox.purge((byte)-1);
                    if (removeFromCache) {
                        MailboxIndex mi = mbox.getMailboxIndex();
                        if (mi != null) {
                            mi.flush();
                        }
                    } else {
                        mbox.endMaintenance(success);
                        this.cacheMailbox(lock.getMailbox());
                    }
                    availableMailbox = mbox;
                }
            } else {
                if (mbox != null) {
                    mbox.endMaintenance(success);
                }
                lock.markUnavailable();
            }
        }
        if (availableMailbox != null) {
            this.notifyMailboxAvailable(availableMailbox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMailboxCount() {
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            return this.mMailboxIds.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getMailboxIds() {
        int i = 0;
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            Collection<Long> col = this.mMailboxIds.values();
            long[] mailboxIds = new long[col.size()];
            for (long id : col) {
                mailboxIds[i++] = id;
            }
            return mailboxIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAccountIds() {
        int i = 0;
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            Set<String> set = this.mMailboxIds.keySet();
            String[] accountIds = new String[set.size()];
            for (String o : set) {
                accountIds[i++] = o;
            }
            return accountIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Long> getMailboxSizes(List<NamedEntry> accounts) throws ServiceException {
        ArrayList<Long> requested;
        Object object = this;
        synchronized (object) {
            if (accounts == null) {
                requested = new ArrayList<Long>(this.mMailboxIds.values());
            } else {
                requested = new ArrayList(accounts.size());
                for (NamedEntry account : accounts) {
                    Long mailboxId = this.mMailboxIds.get(account.getId());
                    if (mailboxId == null) continue;
                    requested.add(mailboxId);
                }
            }
        }
        object = DbMailbox.getSynchronizer();
        synchronized (object) {
            Map<String, Long> map;
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                map = DbMailbox.getMailboxSizes(conn, requested);
                Object var9_7 = null;
                if (conn == null) return map;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (conn == null) throw throwable;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mailbox createMailbox(OperationContext octxt, Account account) throws ServiceException {
        if (account == null) {
            throw ServiceException.FAILURE("createMailbox: must specify an account", null);
        }
        if (!Provisioning.onLocalServer(account)) {
            throw ServiceException.WRONG_HOST(account.getAttr("zimbraMailHost"), null);
        }
        Mailbox mbox = null;
        Long mailboxKey = null;
        do {
            if (mailboxKey != null) {
                return this.getMailboxById(mailboxKey);
            }
            MailboxManager mailboxManager = this;
            synchronized (mailboxManager) {
                mailboxKey = this.mMailboxIds.get(account.getId().toLowerCase());
                if (mailboxKey != null) {
                    continue;
                }
                mbox = this.createMailboxInternal(octxt, account);
            }
        } while (mbox == null);
        if (mbox.finishInitialization()) {
            this.notifyMailboxCreated(mbox);
        }
        return mbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized Mailbox createMailboxInternal(OperationContext octxt, Account account) throws ServiceException {
        Mailbox mbox;
        block36: {
            Object v0;
            CreateMailbox redoRecorder = new CreateMailbox(account.getId());
            mbox = null;
            DbPool.Connection conn = null;
            boolean success = false;
            conn = DbPool.getConnection();
            CreateMailbox redoPlayer = octxt == null ? null : (CreateMailbox)octxt.getPlayer();
            long id = redoPlayer == null ? -1L : redoPlayer.getMailboxId();
            Mailbox.MailboxData data = DbMailbox.createMailbox(conn, id, account.getId(), account.getName(), -1);
            ZimbraLog.mailbox.info("Creating mailbox with id %d and group id %d for %s.", data.id, data.schemaGroupId, account.getName());
            Mailbox mailbox = mbox = this.instantiateMailbox(data);
            synchronized (mailbox) {
                mbox.beginTransaction("createMailbox", octxt, redoRecorder, conn);
            }
            mbox.initialize();
            this.cacheAccount(data.accountId, data.id);
            this.cacheMailbox(mbox);
            redoRecorder.setMailboxId(mbox.getId());
            success = true;
            Object var14_15 = null;
            try {
                if (mbox != null) {
                    Mailbox mailbox2 = mbox;
                    synchronized (mailbox2) {
                        mbox.endTransaction(success);
                    }
                    conn = null;
                } else if (conn != null) {
                    conn.rollback();
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                Object var18_27;
                v0 = var18_27 = null;
            }
            if (conn != null) {
                DbPool.quietClose(conn);
            }
            break block36;
            {
                catch (ServiceException e) {
                    ZimbraLog.mailbox.error((Object)"Error during mailbox creation", e);
                    throw e;
                }
                catch (OutOfMemoryError e) {
                    Object v1;
                    Zimbra.halt("out of memory", e);
                    Object var14_16 = null;
                    try {
                        if (mbox != null) {
                            Mailbox mailbox3 = mbox;
                            synchronized (mailbox3) {
                                mbox.endTransaction(success);
                            }
                            conn = null;
                        } else if (conn != null) {
                            conn.rollback();
                        }
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_28;
                        v1 = var18_28 = null;
                    }
                    if (conn != null) {
                        DbPool.quietClose(conn);
                    }
                    break block36;
                }
                catch (Throwable t) {
                    ZimbraLog.mailbox.error((Object)"Error during mailbox creation", t);
                    throw ServiceException.FAILURE("createMailbox", t);
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var14_17 = null;
                try {
                    if (mbox != null) {
                        Mailbox mailbox4 = mbox;
                        synchronized (mailbox4) {
                            mbox.endTransaction(success);
                        }
                        conn = null;
                    } else if (conn != null) {
                        conn.rollback();
                    }
                    v2 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_29;
                    v2 = var18_29 = null;
                }
                if (conn != null) {
                    DbPool.quietClose(conn);
                }
                throw throwable;
            }
        }
        return mbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markMailboxDeleted(Mailbox mailbox) {
        String accountId = mailbox.getAccountId().toLowerCase();
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            this.mMailboxIds.remove(accountId);
            this.mMailboxCache.remove(mailbox.getId());
        }
        this.notifyMailboxDeleted(accountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpMailboxCache() {
        StringBuilder sb = new StringBuilder();
        sb.append("MAILBOX CACHE DUMPS\n");
        sb.append("----------------------------------------------------------------------\n");
        MailboxManager mailboxManager = this;
        synchronized (mailboxManager) {
            for (Map.Entry<String, Long> entry : this.mMailboxIds.entrySet()) {
                sb.append("1) key=" + entry.getKey() + " (hash=" + entry.getKey().hashCode() + "); val=" + entry.getValue() + "\n");
            }
            for (Map.Entry<Object, Object> entry : this.mMailboxCache.entrySet()) {
                sb.append("2) key=" + entry.getKey() + "; val=" + entry.getValue() + "(class= " + entry.getValue().getClass().getName() + ",hash=" + entry.getValue().hashCode() + ")");
            }
        }
        sb.append("----------------------------------------------------------------------\n");
        ZimbraLog.mailbox.debug(sb.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MailboxMap
    implements Map<Long, Object> {
        final int mHardSize;
        final LinkedHashMap<Long, Object> mHardMap;
        final HashMap<Long, Object> mSoftMap;

        MailboxMap(int hardSize) {
            this.mHardSize = hardSize = Math.max(hardSize, 0);
            this.mSoftMap = new HashMap();
            this.mHardMap = new LinkedHashMap<Long, Object>(this.mHardSize / 4, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, Object> eldest) {
                    if (this.size() <= MailboxMap.this.mHardSize) {
                        return false;
                    }
                    SoftReference<Mailbox> obj = eldest.getValue();
                    if (obj instanceof Mailbox) {
                        obj = new SoftReference<Mailbox>((Mailbox)((Object)obj));
                    }
                    MailboxMap.this.mSoftMap.put(eldest.getKey(), obj);
                    return true;
                }
            };
        }

        @Override
        public void clear() {
            this.mHardMap.clear();
            this.mSoftMap.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.mHardMap.containsKey(key) || this.mSoftMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.mHardMap.containsValue(value) || this.mSoftMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Long, Object>> entrySet() {
            HashSet<Map.Entry<Long, Object>> entries = new HashSet<Map.Entry<Long, Object>>(this.size());
            if (this.mHardSize > 0) {
                entries.addAll(this.mHardMap.entrySet());
            }
            entries.addAll(this.mSoftMap.entrySet());
            return entries;
        }

        @Override
        public Object get(Object key) {
            return this.get(key, false);
        }

        public Object get(Object key, boolean trackGC) {
            Object obj;
            Object object = obj = this.mHardSize > 0 ? this.mHardMap.get(key) : null;
            if (obj == null && (obj = this.mSoftMap.get(key)) instanceof SoftReference) {
                obj = ((SoftReference)obj).get();
                if (trackGC && obj == null) {
                    ZimbraLog.mailbox.debug("mailbox " + key + " has been GCed; reloading");
                }
            }
            return obj;
        }

        @Override
        public boolean isEmpty() {
            return this.mHardMap.isEmpty() && this.mSoftMap.isEmpty();
        }

        @Override
        public Set<Long> keySet() {
            HashSet<Long> keys = new HashSet<Long>(this.size());
            if (this.mHardSize > 0) {
                keys.addAll(this.mHardMap.keySet());
            }
            keys.addAll(this.mSoftMap.keySet());
            return keys;
        }

        @Override
        public Object put(Long key, Object value) {
            SoftReference<Object> removed;
            if (this.mHardSize > 0) {
                removed = this.mHardMap.put(key, value);
                if (removed == null) {
                    removed = this.mSoftMap.remove(key);
                }
            } else {
                if (value instanceof Mailbox) {
                    value = new SoftReference<Object>(value);
                }
                removed = this.mSoftMap.put(key, value);
            }
            if (removed instanceof SoftReference) {
                removed = removed.get();
            }
            return removed;
        }

        @Override
        public void putAll(Map<? extends Long, ? extends Object> t) {
            for (Map.Entry<? extends Long, ? extends Object> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            Object removed;
            Object object = removed = this.mHardSize > 0 ? (Object)this.mHardMap.remove(key) : null;
            if (removed == null && (removed = this.mSoftMap.remove(key)) instanceof SoftReference) {
                removed = ((SoftReference)removed).get();
            }
            return removed;
        }

        @Override
        public int size() {
            return this.mHardMap.size() + this.mSoftMap.size();
        }

        @Override
        public Collection<Object> values() {
            ArrayList<Object> values = new ArrayList<Object>(this.size());
            if (this.mHardSize > 0) {
                values.addAll(this.mHardMap.values());
            }
            for (Object o : this.mSoftMap.values()) {
                if (o instanceof SoftReference) {
                    o = ((SoftReference)o).get();
                }
                values.add(o);
            }
            return values;
        }

        public String toString() {
            return "<" + this.mHardMap.toString() + ", " + this.mSoftMap.toString() + ">";
        }
    }

    public static final class MailboxLock {
        private final String accountId;
        private final long mailboxId;
        private Mailbox mailbox;
        private List<Thread> allowedThreads;

        MailboxLock(String acct, long id) {
            this(acct, id, null);
        }

        MailboxLock(String acct, long id, Mailbox mbox) {
            this.accountId = acct.toLowerCase();
            this.mailboxId = id;
            this.mailbox = mbox;
            this.allowedThreads = new ArrayList<Thread>();
            this.allowedThreads.add(Thread.currentThread());
        }

        String getAccountId() {
            return this.accountId;
        }

        long getMailboxId() {
            return this.mailboxId;
        }

        Mailbox getMailbox() {
            return this.mailbox;
        }

        public synchronized void registerAllowedThread(Thread t) {
            this.allowedThreads.add(t);
        }

        synchronized boolean canAccess() {
            Thread curr = Thread.currentThread();
            for (Thread t : this.allowedThreads) {
                if (curr != t) continue;
                return true;
            }
            return false;
        }

        synchronized void markUnavailable() {
            this.mailbox = null;
            this.allowedThreads.clear();
        }

        void cacheMailbox(Mailbox mbox) {
            if (mbox.getId() == this.mailboxId && mbox.getAccountId().equalsIgnoreCase(this.accountId)) {
                this.mailbox = mbox;
            }
        }
    }

    public static interface Listener {
        public void mailboxAvailable(Mailbox var1);

        public void mailboxLoaded(Mailbox var1);

        public void mailboxCreated(Mailbox var1);

        public void mailboxDeleted(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FetchMode {
        AUTOCREATE,
        DO_NOT_AUTOCREATE,
        ONLY_IF_CACHED;

    }
}

