/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.cs.mailbox.OperationContext;
import java.util.HashSet;

public abstract class MailboxListener {
    private static HashSet<MailboxListener> sListeners = new HashSet();

    public abstract void handleMailboxChange(String var1, int var2, OperationContext var3);

    public abstract int registerForItemTypes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(MailboxListener listener) {
        HashSet<MailboxListener> hashSet = sListeners;
        synchronized (hashSet) {
            sListeners.add(listener);
        }
    }

    public static void mailboxChanged(String accountId, int changedTypes, OperationContext octxt) {
        for (MailboxListener l : sListeners) {
            if ((changedTypes & l.registerForItemTypes()) <= 0) continue;
            l.handleMailboxChange(accountId, changedTypes, octxt);
        }
    }
}

