/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ArrayUtil;
import com.zimbra.common.util.BufferStream;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CopyInputStream;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttrAccount;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.fb.FreeBusyProvider;
import com.zimbra.cs.fb.LocalFreeBusyProvider;
import com.zimbra.cs.filter.RuleManager;
import com.zimbra.cs.im.IMNotification;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.index.BrowseTerm;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraQuery;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.BrowseResult;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Chat;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.DeliveryOptions;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.FoldersTagsCache;
import com.zimbra.cs.mailbox.IndexHelper;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.MailboxListener;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.MailboxVersion;
import com.zimbra.cs.mailbox.MemcachedCacheManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataCallback;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.Notification;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.SenderList;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.Task;
import com.zimbra.cs.mailbox.VirtualConversation;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryCache;
import com.zimbra.cs.mailbox.calendar.cache.CalendarCacheManager;
import com.zimbra.cs.mailbox.calendar.tzfixup.TimeZoneFixupRules;
import com.zimbra.cs.mailbox.util.TypedIdList;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.mime.ParsedDocument;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.mime.ParsedMessageDataSource;
import com.zimbra.cs.mime.ParsedMessageOptions;
import com.zimbra.cs.pop3.Pop3Message;
import com.zimbra.cs.redolog.op.AddDocumentRevision;
import com.zimbra.cs.redolog.op.AlterItemTag;
import com.zimbra.cs.redolog.op.ColorItem;
import com.zimbra.cs.redolog.op.CopyItem;
import com.zimbra.cs.redolog.op.CreateCalendarItemPlayer;
import com.zimbra.cs.redolog.op.CreateCalendarItemRecorder;
import com.zimbra.cs.redolog.op.CreateChat;
import com.zimbra.cs.redolog.op.CreateContact;
import com.zimbra.cs.redolog.op.CreateFolder;
import com.zimbra.cs.redolog.op.CreateFolderPath;
import com.zimbra.cs.redolog.op.CreateInvite;
import com.zimbra.cs.redolog.op.CreateMessage;
import com.zimbra.cs.redolog.op.CreateMountpoint;
import com.zimbra.cs.redolog.op.CreateNote;
import com.zimbra.cs.redolog.op.CreateSavedSearch;
import com.zimbra.cs.redolog.op.CreateTag;
import com.zimbra.cs.redolog.op.DateItem;
import com.zimbra.cs.redolog.op.DeleteItem;
import com.zimbra.cs.redolog.op.DeleteMailbox;
import com.zimbra.cs.redolog.op.DismissCalendarItemAlarm;
import com.zimbra.cs.redolog.op.EditNote;
import com.zimbra.cs.redolog.op.EmptyFolder;
import com.zimbra.cs.redolog.op.FixCalendarItemEndTime;
import com.zimbra.cs.redolog.op.FixCalendarItemTZ;
import com.zimbra.cs.redolog.op.GrantAccess;
import com.zimbra.cs.redolog.op.ICalReply;
import com.zimbra.cs.redolog.op.ImapCopyItem;
import com.zimbra.cs.redolog.op.ModifyContact;
import com.zimbra.cs.redolog.op.ModifyInvitePartStat;
import com.zimbra.cs.redolog.op.ModifySavedSearch;
import com.zimbra.cs.redolog.op.MoveItem;
import com.zimbra.cs.redolog.op.PurgeImapDeleted;
import com.zimbra.cs.redolog.op.PurgeOldMessages;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.RenameItem;
import com.zimbra.cs.redolog.op.RenameItemPath;
import com.zimbra.cs.redolog.op.RenameMailbox;
import com.zimbra.cs.redolog.op.RepositionNote;
import com.zimbra.cs.redolog.op.RevokeAccess;
import com.zimbra.cs.redolog.op.SaveChat;
import com.zimbra.cs.redolog.op.SaveDocument;
import com.zimbra.cs.redolog.op.SaveDraft;
import com.zimbra.cs.redolog.op.SetCalendarItem;
import com.zimbra.cs.redolog.op.SetConfig;
import com.zimbra.cs.redolog.op.SetCustomData;
import com.zimbra.cs.redolog.op.SetFolderDefaultView;
import com.zimbra.cs.redolog.op.SetFolderUrl;
import com.zimbra.cs.redolog.op.SetImapUid;
import com.zimbra.cs.redolog.op.SetItemTags;
import com.zimbra.cs.redolog.op.SetPermissions;
import com.zimbra.cs.redolog.op.SetSubscriptionData;
import com.zimbra.cs.redolog.op.StoreIncomingBlob;
import com.zimbra.cs.redolog.op.TrackImap;
import com.zimbra.cs.redolog.op.TrackSync;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.FeedManager;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.SpamHandler;
import com.zimbra.cs.service.util.SyncToken;
import com.zimbra.cs.session.AllAccountsRedoCommitCallback;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SessionCache;
import com.zimbra.cs.session.SoapSession;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.MailboxBlobDataSource;
import com.zimbra.cs.store.StagedBlob;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.upgrade.ContactUpgrade;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.cs.zclient.ZMailbox;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mailbox {
    public static final String BROWSE_BY_DOMAINS = "domains";
    public static final String BROWSE_BY_OBJECTS = "objects";
    public static final String BROWSE_BY_ATTACHMENTS = "attachments";
    public static final int ID_AUTO_INCREMENT = -1;
    public static final int ID_FOLDER_USER_ROOT = 1;
    public static final int ID_FOLDER_INBOX = 2;
    public static final int ID_FOLDER_TRASH = 3;
    public static final int ID_FOLDER_SPAM = 4;
    public static final int ID_FOLDER_SENT = 5;
    public static final int ID_FOLDER_DRAFTS = 6;
    public static final int ID_FOLDER_CONTACTS = 7;
    public static final int ID_FOLDER_TAGS = 8;
    public static final int ID_FOLDER_CONVERSATIONS = 9;
    public static final int ID_FOLDER_CALENDAR = 10;
    public static final int ID_FOLDER_ROOT = 11;
    public static final int ID_FOLDER_NOTEBOOK = 12;
    public static final int ID_FOLDER_AUTO_CONTACTS = 13;
    public static final int ID_FOLDER_IM_LOGS = 14;
    public static final int ID_FOLDER_TASKS = 15;
    public static final int ID_FOLDER_BRIEFCASE = 16;
    public static final int HIGHEST_SYSTEM_ID = 16;
    public static final int FIRST_USER_ID = 256;
    static final String MD_CONFIG_VERSION = "ver";
    protected IndexHelper mIndexHelper = new IndexHelper(this);
    private static final int MAX_ITEM_CACHE_WITH_LISTENERS = LC.zimbra_mailbox_active_cache.intValue();
    private static final int MAX_ITEM_CACHE_WITHOUT_LISTENERS = LC.zimbra_mailbox_inactive_cache.intValue();
    private static final int MAX_MSGID_CACHE = 10;
    private long mId;
    private MailboxData mData;
    private MailboxChange mCurrentChange = new MailboxChange();
    private List<Session> mListeners = new CopyOnWriteArrayList<Session>();
    private Map<Integer, Folder> mFolderCache;
    private Map<Object, Tag> mTagCache;
    private SoftReference<Map<Integer, MailItem>> mItemCache = new SoftReference<Object>(null);
    private LRUMap mConvHashes = new LRUMap(10);
    private LRUMap mSentMessageIDs = new LRUMap(10);
    private MailboxManager.MailboxLock mMaintenance = null;
    private IMPersona mPersona = null;
    private MailboxVersion mVersion = null;
    private boolean mInitializationComplete = false;
    private static final List<Integer> EMPTY_ITEMS = Collections.emptyList();
    private static final String DEDUPE_ALL = "dedupeAll";
    private static final String DEDUPE_INBOX = "moveSentMessageToInbox";
    private static final String DEDUPE_SECOND = "secondCopyifOnToOrCC";
    private SharedDeliveryCoordinator mSharedDelivCoord = new SharedDeliveryCoordinator();
    public static final int NON_DELIVERY_FLAGS = Flag.BITMASK_DRAFT | Flag.BITMASK_FROM_ME | Flag.BITMASK_COPIED | Flag.BITMASK_DELETED;
    private static final String CN_ID = "id";
    private static final String CN_ACCOUNT_ID = "account_id";
    private static final String CN_NEXT_ID = "next_item_id";
    private static final String CN_SIZE = "size";

    public void indexingCompleted(int count, SyncToken highestModContent, boolean succeeded) {
        this.mIndexHelper.indexingCompleted(count, highestModContent, succeeded);
    }

    protected Mailbox(MailboxData data) {
        this.mId = data.id;
        this.mData = data;
        this.mData.lastChangeDate = System.currentTimeMillis();
    }

    synchronized boolean finishInitialization() throws ServiceException {
        if (!this.mInitializationComplete) {
            if (!DebugConfig.disableIndexing) {
                this.mIndexHelper.instantiateMailboxIndex();
            }
            if (this.mVersion == null) {
                Metadata md = this.getConfig(null, MD_CONFIG_VERSION);
                this.mVersion = MailboxVersion.fromMetadata(md);
            }
            if (!this.getVersion().atLeast(1, 2)) {
                this.mIndexHelper.upgradeMailboxTo1_2();
            }
            if (!this.getVersion().atLeast(1, 4)) {
                this.recalculateFolderAndTagCounts();
                this.updateVersion(new MailboxVersion(1, 4));
            }
            if (!this.getVersion().atLeast(1, 5)) {
                this.mIndexHelper.indexAllDeferredFlagItems();
            }
            if (!this.getVersion().atLeast(1, 6)) {
                ContactUpgrade.upgradeContactsTo1_6(this);
                this.updateVersion(new MailboxVersion(1, 6));
            }
            this.mInitializationComplete = true;
            return true;
        }
        return false;
    }

    public long getId() {
        return this.mId;
    }

    public long getSchemaGroupId() {
        return this.mData.schemaGroupId;
    }

    public String getAccountId() {
        return this.mData.accountId;
    }

    public Account getAccount() throws ServiceException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.getAccountId());
        if (acct != null) {
            return acct;
        }
        ZimbraLog.mailbox.warn("no account found in directory for mailbox " + this.mId + " (was expecting " + this.getAccountId() + ')');
        throw AccountServiceException.NO_SUCH_ACCOUNT(this.mData.accountId);
    }

    public synchronized IMPersona getPersona() throws ServiceException {
        if (this.mPersona == null) {
            this.mPersona = IMPersona.loadPersona(this);
        }
        return this.mPersona;
    }

    public MailboxIndex getMailboxIndex() {
        return this.mIndexHelper.getMailboxIndex();
    }

    public short getIndexVolume() {
        return this.mData.indexVolumeId;
    }

    public MailboxManager.MailboxLock getMailboxLock() {
        return this.mMaintenance;
    }

    public MailSender getMailSender() throws ServiceException {
        MailSender sender = new MailSender();
        sender.setTrackBadHosts(true);
        Account account = this.getAccount();
        try {
            sender.setSession(JMSession.getSmtpSession(account));
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Unable to get SMTP session for " + account, e);
        }
        Domain domain = Provisioning.getInstance().getDomain(account);
        ArrayList<String> hosts = new ArrayList<String>();
        hosts.addAll(JMSession.getSmtpHosts(domain));
        if (hosts.size() > 1) {
            Collections.shuffle(hosts);
        }
        sender.setSmtpHosts(hosts);
        return sender;
    }

    public List<Session> getListeners(Session.Type stype) {
        if (this.mListeners.isEmpty()) {
            return Collections.emptyList();
        }
        if (stype == null) {
            return new ArrayList<Session>(this.mListeners);
        }
        ArrayList<Session> sessions = new ArrayList<Session>(this.mListeners.size());
        for (Session s : this.mListeners) {
            if (s.getType() != stype) continue;
            sessions.add(s);
        }
        return sessions;
    }

    boolean hasListeners(Session.Type stype) {
        if (this.mListeners.isEmpty()) {
            return false;
        }
        if (stype == null) {
            return true;
        }
        for (Session s : this.mListeners) {
            if (s.getType() != stype) continue;
            return true;
        }
        return false;
    }

    public Session getListener(String sessionId) {
        if (sessionId != null) {
            for (Session session : this.mListeners) {
                if (!sessionId.equals(session.getSessionId())) continue;
                return session;
            }
        }
        return null;
    }

    public synchronized void addListener(Session session) throws ServiceException {
        if (session == null) {
            return;
        }
        assert (session.getSessionId() != null);
        if (this.mMaintenance != null) {
            throw MailServiceException.MAINTENANCE(this.mId);
        }
        if (!this.mListeners.contains(session)) {
            this.mListeners.add(session);
        }
        if (ZimbraLog.mailbox.isDebugEnabled()) {
            ZimbraLog.mailbox.debug("adding listener: " + session);
        }
    }

    public void removeListener(Session session) {
        this.mListeners.remove(session);
        if (ZimbraLog.mailbox.isDebugEnabled()) {
            ZimbraLog.mailbox.debug("clearing listener: " + session);
        }
    }

    private void purgeListeners() {
        if (ZimbraLog.mailbox.isDebugEnabled()) {
            ZimbraLog.mailbox.debug("purging listeners");
        }
        if (this.mPersona != null) {
            this.mPersona.purgeListeners();
        }
        for (Session session : this.mListeners) {
            SessionCache.clearSession(session);
        }
        this.mListeners.clear();
    }

    public void postIMNotification(IMNotification imn) {
        for (Session session : this.mListeners) {
            session.notifyIM(imn);
        }
    }

    boolean isTrackingSync() {
        return (this.mCurrentChange.sync == null ? this.mData.trackSync : this.mCurrentChange.sync) > 0;
    }

    public boolean isTrackingImap() {
        return this.mCurrentChange.imap == null ? this.mData.trackImap : this.mCurrentChange.imap;
    }

    public int getOperationTimestamp() {
        return (int)(this.mCurrentChange.timestamp / 1000L);
    }

    public long getOperationTimestampMillis() {
        return this.mCurrentChange.timestamp;
    }

    public long getLastChangeDate() {
        return this.mData.lastChangeDate;
    }

    public int getIndexDeferredCount() {
        int toRet = this.mCurrentChange.idxDeferred == -1 ? this.mData.idxDeferredCount : this.mCurrentChange.idxDeferred;
        return Math.max(toRet, 0);
    }

    public SyncToken getHighestFlushedToIndex() {
        return this.mCurrentChange.highestModContentIndexed == null ? this.mData.highestModContentIndexed : this.mCurrentChange.highestModContentIndexed;
    }

    public int getLastChangeID() {
        return this.mCurrentChange.changeId == -1 ? this.mData.lastChangeId : Math.max(this.mData.lastChangeId, this.mCurrentChange.changeId);
    }

    private void setOperationChangeID(int changeFromRedo) throws ServiceException {
        int nextId;
        if (this.mCurrentChange.changeId != -1) {
            if (this.mCurrentChange.changeId == changeFromRedo) {
                return;
            }
            throw ServiceException.FAILURE("cannot specify change ID after change is in progress", null);
        }
        int lastId = this.getLastChangeID();
        this.mCurrentChange.changeId = nextId = changeFromRedo == -1 ? lastId + 1 : changeFromRedo;
    }

    public int getOperationChangeID() throws ServiceException {
        if (this.mCurrentChange.changeId == -1) {
            this.setOperationChangeID(-1);
        }
        return this.mCurrentChange.changeId;
    }

    boolean checkItemChangeID(MailItem item) throws ServiceException {
        if (item == null) {
            return true;
        }
        return this.checkItemChangeID(item.getModifiedSequence(), item.getSavedSequence());
    }

    public boolean checkItemChangeID(int modMetadata, int modContent) throws ServiceException {
        if (this.mCurrentChange.octxt == null || this.mCurrentChange.octxt.change < 0) {
            return true;
        }
        OperationContext octxt = this.mCurrentChange.octxt;
        if (!octxt.changetype && modContent > octxt.change) {
            return false;
        }
        if (octxt.changetype && modMetadata > octxt.change) {
            throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
        }
        return true;
    }

    public int getLastItemId() {
        return this.mCurrentChange.itemId == -1 ? this.mData.lastItemId : this.mCurrentChange.itemId;
    }

    private int getNextItemId(int idFromRedo) {
        int nextId;
        int lastId = this.getLastItemId();
        int n = nextId = idFromRedo == -1 ? lastId + 1 : idFromRedo;
        if (nextId > lastId) {
            this.mCurrentChange.itemId = nextId;
        }
        return nextId;
    }

    MailItem.TargetConstraint getOperationTargetConstraint() {
        return this.mCurrentChange.tcon;
    }

    void setOperationTargetConstraint(MailItem.TargetConstraint tcon) {
        this.mCurrentChange.tcon = tcon;
    }

    public OperationContext getOperationContext() {
        return this.mCurrentChange.active ? this.mCurrentChange.octxt : null;
    }

    RedoableOp getRedoRecorder() {
        return this.mCurrentChange.recorder;
    }

    PendingModifications getPendingModifications() {
        return this.mCurrentChange.mDirty;
    }

    Account getAuthenticatedAccount() {
        ZAttrAccount authuser = null;
        if (this.mCurrentChange.active && this.mCurrentChange.octxt != null) {
            authuser = this.mCurrentChange.octxt.getAuthenticatedUser();
        }
        if (authuser != null && authuser.getId().equals(this.getAccountId())) {
            authuser = null;
        }
        return authuser;
    }

    boolean isUsingAdminPrivileges() {
        return this.mCurrentChange.active && this.mCurrentChange.octxt != null && this.mCurrentChange.octxt.isUsingAdminPrivileges();
    }

    boolean hasFullAccess() throws ServiceException {
        Account authuser = this.getAuthenticatedAccount();
        if (authuser == null || this.getAccountId().equals(authuser.getId())) {
            return true;
        }
        if (this.mCurrentChange.active && this.mCurrentChange.octxt != null) {
            return AccessManager.getInstance().canAccessAccount(authuser, this.getAccount(), this.isUsingAdminPrivileges());
        }
        return false;
    }

    public long getSize() {
        return this.mCurrentChange.size == -1L ? this.mData.size : this.mCurrentChange.size;
    }

    void updateSize(long delta) throws ServiceException {
        this.updateSize(delta, true);
    }

    void updateSize(long delta, boolean checkQuota) throws ServiceException {
        if (delta == 0L) {
            return;
        }
        this.mCurrentChange.mDirty.recordModified(this, 16);
        this.mCurrentChange.size = Math.max(0L, (this.mCurrentChange.size == -1L ? this.mData.size : this.mCurrentChange.size) + delta);
        if (delta < 0L || !checkQuota) {
            return;
        }
        long quota = this.getAccount().getLongAttr("zimbraMailQuota", 0L);
        if (quota != 0L && this.mCurrentChange.size > quota) {
            throw MailServiceException.QUOTA_EXCEEDED(quota);
        }
    }

    public synchronized long getLastSoapAccessTime() {
        long lastAccess = (long)(this.mCurrentChange.accessed == -1 ? this.mData.lastWriteDate : this.mCurrentChange.accessed) * 1000L;
        for (Session s : this.mListeners) {
            if (!(s instanceof SoapSession)) continue;
            lastAccess = Math.max(lastAccess, ((SoapSession)s).getLastWriteAccessTime());
        }
        return lastAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordLastSoapAccessTime(long time) throws ServiceException {
        boolean success = false;
        try {
            this.beginTransaction("recordLastSoapAccessTime", null);
            if (time > (long)this.mData.lastWriteDate) {
                this.mCurrentChange.accessed = (int)(time / 1000L);
                DbMailbox.recordLastSoapAccess(this);
            }
            success = true;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public int getRecentMessageCount() {
        return this.mCurrentChange.recent == -1 ? this.mData.recentMessages : this.mCurrentChange.recent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetRecentMessageCount(OperationContext octxt) throws ServiceException {
        boolean success = false;
        try {
            this.beginTransaction("resetRecentMessageCount", octxt);
            if (this.getRecentMessageCount() != 0) {
                this.mCurrentChange.recent = 0;
            }
            success = true;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public int getContactCount() {
        return this.mCurrentChange.contacts == -1 ? this.mData.contacts : this.mCurrentChange.contacts;
    }

    void updateContactCount(int delta) throws ServiceException {
        if (delta == 0) {
            return;
        }
        this.mCurrentChange.contacts = Math.max(0, (this.mCurrentChange.contacts == -1 ? this.mData.contacts : this.mCurrentChange.contacts) + delta);
        if (delta < 0) {
            return;
        }
        int quota = this.getAccount().getIntAttr("zimbraContactMaxNumEntries", 0);
        if (quota != 0 && this.mCurrentChange.contacts > quota) {
            throw MailServiceException.TOO_MANY_CONTACTS(quota);
        }
    }

    void markItemCreated(MailItem item) {
        this.mCurrentChange.mDirty.recordCreated(item);
    }

    void markItemDeleted(MailItem item) {
        this.mCurrentChange.mDirty.recordDeleted(item);
    }

    void markItemDeleted(byte type, int itemId) {
        this.mCurrentChange.mDirty.recordDeleted(this.mData.accountId, itemId, type);
    }

    void markItemDeleted(int typesMask, List<Integer> itemIds) {
        this.mCurrentChange.mDirty.recordDeleted(this.mData.accountId, itemIds, typesMask);
    }

    void markItemModified(MailItem item, int reason) {
        this.mCurrentChange.mDirty.recordModified(item, reason);
    }

    void markOtherItemDirty(Object obj) {
        if (obj instanceof MailItem.PendingDelete) {
            this.mCurrentChange.addPendingDelete((MailItem.PendingDelete)obj);
        } else {
            this.mCurrentChange.mOtherDirtyStuff.add(obj);
        }
    }

    String generateIndexId(int itemId) {
        return this.mIndexHelper.generateIndexId(itemId);
    }

    void queueForIndexing(MailItem item, boolean deleteFirst, List<IndexDocument> data) {
        assert (Thread.holdsLock(this));
        if (item.getIndexId() == null) {
            return;
        }
        if (deleteFirst) {
            this.mCurrentChange.addIndexDelete(item.getIndexId());
        }
        if (data != null && this.mIndexHelper.getNumNotSubmittedToIndex() > 0) {
            if (ZimbraLog.index_add.isDebugEnabled()) {
                ZimbraLog.index_add.debug("Deferring indexing for item " + item.getId() + " b/c index is " + "not up-to-date (not-submitted = " + this.mIndexHelper.getNumNotSubmittedToIndex() + ")");
            }
            data = null;
        }
        if (data != null && this.indexImmediately()) {
            if (item.getIndexId() != null) {
                this.mCurrentChange.addIndexItem(new IndexItemEntry(deleteFirst, item, item.getSavedSequence(), data));
            }
        } else {
            int oldCount = this.mCurrentChange.idxDeferred == -1 ? this.mData.idxDeferredCount : this.mCurrentChange.idxDeferred;
            this.mCurrentChange.idxDeferred = Math.max(0, oldCount + 1);
        }
    }

    public void setIndexImmediatelyMode() {
        this.mIndexHelper.setIndexImmediatelyMode();
    }

    public void clearIndexImmediatelyMode() {
        this.mIndexHelper.clearIndexImmediatelyMode();
    }

    private boolean indexImmediately() {
        return this.mIndexHelper.getBatchedIndexingCount() == 0;
    }

    public synchronized DbPool.Connection getOperationConnection() throws ServiceException {
        if (!this.mCurrentChange.isActive()) {
            throw ServiceException.FAILURE("cannot fetch Connection outside transaction", new Exception());
        }
        return this.mCurrentChange.getConnection();
    }

    private synchronized void setOperationConnection(DbPool.Connection conn) throws ServiceException {
        if (!this.mCurrentChange.isActive()) {
            throw ServiceException.FAILURE("cannot set Connection outside transaction", new Exception());
        }
        if (conn == null) {
            return;
        }
        if (this.mCurrentChange.conn != null) {
            throw ServiceException.FAILURE("cannot set Connection for in-progress transaction", new Exception());
        }
        this.mCurrentChange.conn = conn;
    }

    synchronized MailboxManager.MailboxLock beginMaintenance() throws ServiceException {
        if (this.mMaintenance != null) {
            throw MailServiceException.MAINTENANCE(this.mId);
        }
        ZimbraLog.mailbox.info("Locking mailbox %d for maintenance.", this.getId());
        this.purgeListeners();
        this.mIndexHelper.flush();
        this.mMaintenance = new MailboxManager.MailboxLock(this.mData.accountId, this.mId, this);
        return this.mMaintenance;
    }

    synchronized void endMaintenance(boolean success) throws ServiceException {
        if (this.mMaintenance == null) {
            throw ServiceException.FAILURE("mainbox not in maintenance mode", null);
        }
        if (success) {
            ZimbraLog.mailbox.info("Ending maintenance on mailbox %d.", this.getId());
            this.mMaintenance = null;
        } else {
            ZimbraLog.mailbox.info("Ending maintenance and marking mailbox %d as unavailable.", this.getId());
            this.mMaintenance.markUnavailable();
        }
    }

    protected void beginTransaction(String caller, OperationContext octxt) throws ServiceException {
        this.beginTransaction(caller, System.currentTimeMillis(), octxt, null, null);
    }

    protected void beginTransaction(String caller, OperationContext octxt, RedoableOp recorder) throws ServiceException {
        long timestamp = octxt == null ? System.currentTimeMillis() : octxt.getTimestamp();
        this.beginTransaction(caller, timestamp, octxt, recorder, null);
    }

    void beginTransaction(String caller, OperationContext octxt, RedoableOp recorder, DbPool.Connection conn) throws ServiceException {
        long timestamp = octxt == null ? System.currentTimeMillis() : octxt.getTimestamp();
        this.beginTransaction(caller, timestamp, octxt, recorder, conn);
    }

    private void beginTransaction(String caller, long time, OperationContext octxt, RedoableOp recorder, DbPool.Connection conn) throws ServiceException {
        Map<Integer, MailItem> cache;
        assert (Thread.holdsLock(this));
        this.mCurrentChange.startChange(caller, octxt, recorder);
        if (conn != null) {
            this.setOperationConnection(conn);
        }
        boolean needRedo = octxt == null || octxt.needRedo();
        this.mCurrentChange.setTimestamp(time);
        if (recorder != null && needRedo) {
            recorder.start(time);
        }
        if (recorder != null && needRedo && octxt != null && octxt.change > 0) {
            recorder.setChangeConstraint(octxt.changetype, octxt.change);
        }
        if (octxt != null && octxt.getChangeId() > 0) {
            this.setOperationChangeID(octxt.getChangeId());
        }
        if (recorder != null && needRedo) {
            recorder.setChangeId(this.getOperationChangeID());
        }
        if ((cache = this.mItemCache.get()) == null) {
            cache = new LinkedHashMap<Integer, MailItem>(MAX_ITEM_CACHE_WITH_LISTENERS, 0.75f, true);
            this.mItemCache = new SoftReference<Map<Integer, MailItem>>(cache);
            ZimbraLog.cache.debug("created a new MailItem cache for mailbox " + this.getId());
        }
        this.mCurrentChange.itemCache = cache;
        if (this.mMaintenance != null && !this.mMaintenance.canAccess()) {
            throw MailServiceException.MAINTENANCE(this.mId);
        }
        if (recorder != null && needRedo && this.mCurrentChange.depth > 1) {
            throw ServiceException.FAILURE("cannot start a logged transaction from within another transaction (current recorder=" + this.mCurrentChange.recorder + ")", null);
        }
        this.loadFoldersAndTags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Metadata getConfig(OperationContext octxt, String section) throws ServiceException {
        Metadata metadata;
        boolean success;
        block12: {
            Metadata metadata2;
            block11: {
                Metadata metadata3;
                block10: {
                    Metadata metadata4;
                    block9: {
                        if (section == null) return null;
                        if (section.equals("")) {
                            return null;
                        }
                        success = true;
                        try {
                            this.beginTransaction("getConfig", octxt, null);
                            if (!this.hasFullAccess()) {
                                metadata4 = null;
                                Object var8_7 = null;
                                break block9;
                            }
                            if (this.mData.configKeys == null || !this.mData.configKeys.contains(section)) {
                                metadata3 = null;
                                break block10;
                            }
                            String config = DbMailbox.getConfig(this, section);
                            if (config == null) {
                                metadata2 = null;
                                break block11;
                            }
                            try {
                                metadata = new Metadata(config);
                                break block12;
                            }
                            catch (ServiceException e) {
                                success = false;
                                ZimbraLog.mailbox.warn("could not decode config metadata for section:" + section);
                                Metadata metadata5 = null;
                                Object var8_11 = null;
                                this.endTransaction(success);
                                return metadata5;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_12 = null;
                            this.endTransaction(success);
                            throw throwable;
                        }
                    }
                    this.endTransaction(success);
                    return metadata4;
                }
                Object var8_8 = null;
                this.endTransaction(success);
                return metadata3;
            }
            Object var8_9 = null;
            this.endTransaction(success);
            return metadata2;
        }
        Object var8_10 = null;
        this.endTransaction(success);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConfig(OperationContext octxt, String section, Metadata config) throws ServiceException {
        if (section == null) {
            throw new IllegalArgumentException();
        }
        SetConfig redoPlayer = new SetConfig(this.mId, section, config);
        boolean success = false;
        try {
            this.beginTransaction("setConfig", octxt, redoPlayer);
            if (!this.hasFullAccess()) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
            }
            this.mCurrentChange.mDirty.recordModified(this, 8);
            this.mCurrentChange.config = new Pair<String, Metadata>(section, config);
            DbMailbox.updateConfig(this, section, config);
            success = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    private Map<Integer, MailItem> getItemCache() throws ServiceException {
        if (!this.mCurrentChange.isActive()) {
            throw ServiceException.FAILURE("cannot access item cache outside a transaction", null);
        }
        return this.mCurrentChange.itemCache;
    }

    private void clearItemCache() {
        if (this.mCurrentChange.isActive()) {
            this.mCurrentChange.itemCache.clear();
        } else {
            this.mItemCache.clear();
        }
    }

    void cache(MailItem item) throws ServiceException {
        if (item == null || item.isTagged(-31)) {
            return;
        }
        if (item instanceof Tag) {
            if (this.mTagCache != null) {
                this.mTagCache.put(item.getId(), (Tag)item);
                this.mTagCache.put(item.getName().toLowerCase(), (Tag)item);
            }
        } else if (item instanceof Folder) {
            if (this.mFolderCache != null) {
                this.mFolderCache.put(item.getId(), (Folder)item);
            }
        } else {
            this.getItemCache().put(item.getId(), item);
        }
        if (ZimbraLog.cache.isDebugEnabled()) {
            ZimbraLog.cache.debug("cached " + MailItem.getNameForType(item) + " " + item.getId() + " in mailbox " + this.getId());
        }
    }

    protected void uncache(MailItem item) throws ServiceException {
        if (item == null) {
            return;
        }
        if (item instanceof Tag) {
            if (this.mTagCache == null) {
                return;
            }
            this.mTagCache.remove(item.getId());
            this.mTagCache.remove(item.getName().toLowerCase());
        } else if (item instanceof Folder) {
            if (this.mFolderCache == null) {
                return;
            }
            this.mFolderCache.remove(item.getId());
        } else {
            this.getItemCache().remove(item.getId());
            MessageCache.purge(item);
        }
        if (ZimbraLog.cache.isDebugEnabled()) {
            ZimbraLog.cache.debug("uncached " + MailItem.getNameForType(item) + " " + item.getId() + " in mailbox " + this.getId());
        }
        this.uncacheChildren(item);
    }

    void uncacheItem(Integer itemId) throws ServiceException {
        MailItem item = this.getItemCache().remove(itemId);
        if (ZimbraLog.cache.isDebugEnabled()) {
            ZimbraLog.cache.debug("uncached item " + itemId + " in mailbox " + this.getId());
        }
        if (item != null) {
            MessageCache.purge(item);
            this.uncacheChildren(item);
        } else {
            MessageCache.purge(this, itemId);
        }
    }

    void uncacheChildren(MailItem parent) throws ServiceException {
        Collection<MailItem> cached;
        if (parent == null || !parent.canHaveChildren()) {
            return;
        }
        if (!(parent instanceof Folder)) {
            cached = this.getItemCache().values();
        } else if (this.mFolderCache != null) {
            cached = this.mFolderCache.values();
        } else {
            return;
        }
        int parentId = parent.getId();
        ArrayList<MailItem> children = new ArrayList<MailItem>();
        for (MailItem item : cached) {
            if (item.getParentId() != parentId) continue;
            children.add(item);
        }
        if (!children.isEmpty()) {
            for (MailItem child : children) {
                this.uncache(child);
            }
        }
    }

    public synchronized void purge(byte type) {
        switch (type) {
            case 1: 
            case 2: 
            case 13: {
                this.mFolderCache = null;
                break;
            }
            case 3: 
            case 10: {
                this.mTagCache = null;
                break;
            }
            default: {
                this.clearItemCache();
                break;
            }
            case -1: {
                this.mFolderCache = null;
                this.mTagCache = null;
                this.clearItemCache();
            }
        }
        if (ZimbraLog.cache.isDebugEnabled()) {
            ZimbraLog.cache.debug("purged " + MailItem.getNameForType(type) + " cache in mailbox " + this.getId());
        }
    }

    protected synchronized void initialize() throws ServiceException {
        byte hidden = 3;
        Folder root = Folder.create(11, this, null, "ROOT", hidden, (byte)-1, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(8, this, root, "Tags", hidden, (byte)3, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(9, this, root, "Conversations", hidden, (byte)4, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        byte system = 1;
        Folder userRoot = Folder.create(1, this, root, "USER_ROOT", system, (byte)-1, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(2, this, userRoot, "Inbox", system, (byte)5, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(3, this, userRoot, "Trash", system, (byte)-1, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(4, this, userRoot, "Junk", system, (byte)5, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(5, this, userRoot, "Sent", system, (byte)5, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(6, this, userRoot, "Drafts", system, (byte)5, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(7, this, userRoot, "Contacts", system, (byte)6, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(12, this, userRoot, "Notebook", system, (byte)14, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(10, this, userRoot, "Calendar", system, (byte)11, Flag.BITMASK_CHECKED, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(15, this, userRoot, "Tasks", system, (byte)15, Flag.BITMASK_CHECKED, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(13, this, userRoot, "Emailed Contacts", system, (byte)6, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(14, this, userRoot, "Chats", system, (byte)5, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        Folder.create(16, this, userRoot, "Briefcase", system, (byte)8, 0, MailItem.DEFAULT_COLOR_RGB, null, null);
        this.mCurrentChange.itemId = this.getInitialItemId();
        DbMailbox.updateMailboxStats(this);
        Metadata md = new Metadata();
        this.mVersion = new MailboxVersion(MailboxVersion.CURRENT());
        this.mVersion.writeToMetadata(md);
        DbMailbox.updateConfig(this, MD_CONFIG_VERSION, md);
    }

    int getInitialItemId() {
        return 256;
    }

    private void loadFoldersAndTags() throws ServiceException {
        boolean initial;
        boolean bl = initial = this.mData.contacts < 0 || this.mData.size < 0L;
        if (this.mFolderCache != null && this.mTagCache != null && !initial) {
            return;
        }
        ZimbraLog.cache.info("initializing folder and tag caches for mailbox " + this.getId());
        try {
            boolean persist;
            FoldersTagsCache ftCache;
            FoldersTagsCache.FoldersTags ftData;
            HashMap<MailItem.UnderlyingData, Long> folderData = new HashMap<MailItem.UnderlyingData, Long>();
            HashMap<MailItem.UnderlyingData, Long> tagData = new HashMap<MailItem.UnderlyingData, Long>();
            MailboxData stats = null;
            boolean loadedFromMemcached = false;
            if (!initial && !DebugConfig.disableFoldersTagsCache && (ftData = (ftCache = FoldersTagsCache.getInstance()).get(this)) != null) {
                List<Metadata> foldersMeta = ftData.getFolders();
                for (Metadata meta : foldersMeta) {
                    MailItem.UnderlyingData ud = new MailItem.UnderlyingData();
                    ud.deserialize(meta);
                    folderData.put(ud, -1L);
                }
                List<Metadata> tagsMeta = ftData.getTags();
                for (Metadata meta : tagsMeta) {
                    MailItem.UnderlyingData ud = new MailItem.UnderlyingData();
                    ud.deserialize(meta);
                    tagData.put(ud, -1L);
                }
                loadedFromMemcached = true;
            }
            if (!loadedFromMemcached) {
                stats = DbMailItem.getFoldersAndTags(this, folderData, tagData, initial);
            }
            boolean bl2 = persist = stats != null;
            if (stats != null) {
                if (this.mData.size != stats.size) {
                    this.mCurrentChange.mDirty.recordModified(this, 16);
                    ZimbraLog.mailbox.debug("setting mailbox size to " + stats.size + " (was " + this.mData.size + ") for mailbox " + this.mId);
                    this.mData.size = stats.size;
                }
                if (this.mData.contacts != stats.contacts) {
                    ZimbraLog.mailbox.debug("setting contact count to " + stats.contacts + " (was " + this.mData.contacts + ") for mailbox " + this.mId);
                    this.mData.contacts = stats.contacts;
                }
                DbMailbox.updateMailboxStats(this);
            }
            this.mFolderCache = new HashMap<Integer, Folder>();
            for (Map.Entry entry : folderData.entrySet()) {
                Folder folder = (Folder)MailItem.constructItem(this, (MailItem.UnderlyingData)entry.getKey());
                if ((Long)entry.getValue() <= 0L) continue;
                folder.setSize(folder.getItemCount(), (Long)entry.getValue());
            }
            for (Folder folder : this.mFolderCache.values()) {
                boolean badChangeDate;
                Folder parent = this.mFolderCache.get(folder.getFolderId());
                if (parent != null) {
                    parent.addChild(folder);
                }
                boolean bl3 = badChangeDate = folder.getChangeDate() <= 0L;
                if (badChangeDate) {
                    this.markItemModified(folder, 0x10000000);
                    folder.mData.metadataChanged(this);
                }
                if (!persist && !badChangeDate) continue;
                folder.saveFolderCounts(initial);
            }
            this.mTagCache = new HashMap<Object, Tag>(tagData.size() * 3);
            for (MailItem.UnderlyingData ud : tagData.keySet()) {
                Tag tag = new Tag(this, ud);
                if (!persist) continue;
                tag.saveTagCounts();
            }
            if (!loadedFromMemcached && !DebugConfig.disableFoldersTagsCache) {
                this.cacheFoldersTagsToMemcached();
            }
        }
        catch (ServiceException e) {
            this.mTagCache = null;
            this.mFolderCache = null;
            throw e;
        }
    }

    synchronized void cacheFoldersTagsToMemcached() throws ServiceException {
        ArrayList<Folder> folderList = new ArrayList<Folder>(this.mFolderCache.values());
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Map.Entry<Object, Tag> entry : this.mTagCache.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            tagList.add(entry.getValue());
        }
        FoldersTagsCache.FoldersTags ftData = new FoldersTagsCache.FoldersTags(folderList, tagList);
        FoldersTagsCache ftCache = FoldersTagsCache.getInstance();
        ftCache.put(this, ftData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recalculateFolderAndTagCounts() throws ServiceException {
        boolean success = false;
        try {
            this.beginTransaction("recalculateFolderAndTagCounts", null);
            this.mTagCache = null;
            this.mFolderCache = null;
            this.mData.contacts = -1;
            this.loadFoldersAndTags();
            success = true;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized void deleteMailbox() throws ServiceException {
        this.deleteMailbox(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deleteMailbox(OperationContext octxt) throws ServiceException {
        DeleteMailbox redoRecorder;
        block17: {
            MailboxManager.MailboxLock lock;
            block16: {
                lock = null;
                try {
                    lock = MailboxManager.getInstance().beginMaintenance(this.mData.accountId, this.mId);
                }
                catch (MailServiceException e) {
                    if ("mail.WRONG_MAILBOX".equals(e.getCode())) break block16;
                    throw e;
                }
            }
            boolean needRedo = octxt == null || octxt.needRedo();
            redoRecorder = new DeleteMailbox(this.mId);
            boolean success = false;
            try {
                this.beginTransaction("deleteMailbox", octxt, redoRecorder);
                if (needRedo) {
                    redoRecorder.log();
                }
                try {
                    DbPool.Connection conn = this.getOperationConnection();
                    DbMailbox.clearMailboxContent(this);
                    Object object = DbMailbox.getSynchronizer();
                    synchronized (object) {
                        DbMailbox.deleteMailbox(conn, this);
                    }
                    MemcachedCacheManager.purgeMailbox(this);
                    success = true;
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    this.endTransaction(success);
                    throw throwable;
                }
                this.endTransaction(success);
                if (success) {
                    MailboxManager.getInstance().markMailboxDeleted(this);
                    try {
                        this.mIndexHelper.deleteIndex();
                    }
                    catch (IOException iox) {
                        ZimbraLog.store.warn((Object)"Unable to delete index data.", iox);
                    }
                    try {
                        StoreManager.getInstance().deleteStore(this);
                    }
                    catch (IOException iox) {
                        ZimbraLog.store.warn((Object)"Unable to delete message data.", iox);
                    }
                    if (lock != null) {
                        lock.markUnavailable();
                    }
                }
                Object var12_14 = null;
                if (!needRedo) return;
                if (!success) break block17;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (!needRedo) throw throwable;
                if (success) {
                    redoRecorder.commit();
                    throw throwable;
                }
                redoRecorder.abort();
                throw throwable;
            }
            redoRecorder.commit();
            return;
        }
        redoRecorder.abort();
    }

    public synchronized void renameMailbox(String oldName, String newName) throws ServiceException {
        this.renameMailbox(null, oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void renameMailbox(OperationContext octxt, String oldName, String newName) throws ServiceException {
        if (newName == null || newName.length() < 1) {
            throw ServiceException.INVALID_REQUEST("Cannot rename mailbox to empty name", null);
        }
        RenameMailbox redoRecorder = new RenameMailbox(this.mId, oldName, newName);
        boolean success = false;
        try {
            this.beginTransaction("renameMailbox", octxt, redoRecorder);
            DbMailbox.renameMailbox(this, newName);
            Account acct = this.getAccount();
            boolean imEnabledThisAcct = acct.getBooleanAttr("zimbraFeatureIMEnabled", false);
            boolean xmppEnabled = Provisioning.getInstance().getServer(acct).getBooleanAttr("zimbraXMPPEnabled", false);
            if (this.mPersona != null || xmppEnabled && imEnabledThisAcct) {
                this.getPersona().renamePersona(newName);
            }
            success = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized MailboxVersion getVersion() {
        return this.mVersion;
    }

    synchronized void updateVersion(MailboxVersion vers) throws ServiceException {
        this.mVersion = new MailboxVersion(vers);
        Metadata md = this.getConfig(null, MD_CONFIG_VERSION);
        if (md == null) {
            md = new Metadata();
        }
        this.mVersion.writeToMetadata(md);
        this.setConfig(null, MD_CONFIG_VERSION, md);
    }

    public synchronized boolean isReIndexInProgress() {
        return this.getReIndexStatus() != null;
    }

    public synchronized BatchedIndexStatus getReIndexStatus() {
        return this.mIndexHelper.getReIndexStatus();
    }

    public void reIndex(OperationContext octxt, Set<Byte> types, Set<Integer> itemIds, boolean skipDelete) throws ServiceException {
        this.mIndexHelper.reIndexInBackgroundThread(octxt, types, itemIds, skipDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reanalyze(int id, byte type, Object data) throws ServiceException {
        boolean success = false;
        try {
            this.beginTransaction("reanalyze", null);
            MailItem item = this.getItemById(null, id, type);
            item.reanalyze(data);
            success = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized short getEffectivePermissions(OperationContext octxt, int itemId, byte type) throws ServiceException {
        short s;
        MailItem item = this.getItemById(null, itemId, type);
        boolean success = false;
        try {
            this.beginTransaction("getEffectivePermissions", octxt);
            short rights = item.checkRights((short)-1, this.getAuthenticatedAccount(), this.isUsingAdminPrivileges());
            success = true;
            s = rights;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return s;
    }

    public static boolean isCachedType(byte type) {
        return type == 1 || type == 2 || type == 3 || type == 10 || type == 13;
    }

    private <T extends MailItem> T checkAccess(T item) throws ServiceException {
        if (item == null || item.canAccess((short)1)) {
            return item;
        }
        throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MailItem getItemById(OperationContext octxt, int id, byte type) throws ServiceException {
        MailItem mailItem;
        boolean success = false;
        try {
            this.beginTransaction("getItemById", octxt);
            MailItem item = this.checkAccess(this.getItemById(id, type));
            success = true;
            mailItem = item;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return mailItem;
    }

    MailItem getItemById(int id, byte type) throws ServiceException {
        MailItem item = this.getCachedItem(new Integer(id), type);
        if (item != null) {
            return item;
        }
        if (Mailbox.isCachedType(type)) {
            throw MailItem.noSuchItem(id, type);
        }
        if (id <= -256) {
            if (type != 4 && type != -1) {
                throw MailItem.noSuchItem(id, type);
            }
            Message msg = this.getCachedMessage(new Integer(-id));
            if (msg == null) {
                msg = this.getMessageById(-id);
            }
            if (msg.getConversationId() != id) {
                return msg.getParent();
            }
            item = new VirtualConversation(this, msg);
        } else {
            item = MailItem.getById(this, id, type);
        }
        return item;
    }

    public synchronized MailItem[] getItemById(OperationContext octxt, Collection<Integer> ids, byte type) throws ServiceException {
        return this.getItemById(octxt, ArrayUtil.toIntArray(ids), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MailItem[] getItemById(OperationContext octxt, int[] ids, byte type) throws ServiceException {
        MailItem[] mailItemArray;
        boolean success = false;
        try {
            this.beginTransaction("getItemById[]", octxt);
            MailItem[] items = this.getItemById(ids, type);
            for (int i = 0; i < items.length; ++i) {
                this.checkAccess(items[i]);
            }
            success = true;
            mailItemArray = items;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return mailItemArray;
    }

    MailItem[] getItemById(Collection<Integer> ids, byte type) throws ServiceException {
        return this.getItemById(ArrayUtil.toIntArray(ids), type);
    }

    MailItem[] getItemById(int[] ids, byte type) throws ServiceException {
        MailItem item;
        int i;
        if (!this.mCurrentChange.active) {
            throw ServiceException.FAILURE("must be in transaction", null);
        }
        if (ids == null) {
            return null;
        }
        MailItem[] items = new MailItem[ids.length];
        HashSet<Integer> uncached = new HashSet<Integer>();
        Integer miss = null;
        boolean relaxType = false;
        for (i = 0; i < ids.length; ++i) {
            if (ids[i] == -1) {
                items[i] = null;
                continue;
            }
            Integer key = ids[i];
            MailItem item2 = this.getCachedItem(key, type);
            if (item2 == null && ids[i] <= -256) {
                if (!MailItem.isAcceptableType(type, (byte)4)) {
                    throw MailItem.noSuchItem(ids[i], type);
                }
                key = -ids[i];
                Message msg = this.getCachedMessage(key);
                if (msg != null) {
                    if (msg.getConversationId() == ids[i]) {
                        item2 = new VirtualConversation(this, msg);
                    }
                } else {
                    relaxType = true;
                }
            }
            items[i] = item2;
            if (item2 != null) continue;
            miss = key;
            uncached.add(miss);
        }
        if (uncached.isEmpty()) {
            return items;
        }
        if (Mailbox.isCachedType(type)) {
            throw MailItem.noSuchItem(miss, type);
        }
        MailItem.getById(this, uncached, relaxType ? (byte)-1 : (byte)type);
        uncached.clear();
        for (i = 0; i < ids.length; ++i) {
            if (ids[i] == -1 || items[i] != null) continue;
            if (ids[i] <= -256) {
                item = this.getCachedItem(-ids[i]);
                if (!(item instanceof Message)) {
                    throw MailItem.noSuchItem(ids[i], type);
                }
                if (item.getParentId() == ids[i]) {
                    items[i] = new VirtualConversation(this, (Message)item);
                    continue;
                }
                items[i] = this.getCachedItem(item.getParentId());
                if (items[i] != null) continue;
                uncached.add(item.getParentId());
                continue;
            }
            items[i] = this.getCachedItem(ids[i]);
            if (items[i] != null) continue;
            throw MailItem.noSuchItem(ids[i], type);
        }
        if (!uncached.isEmpty()) {
            MailItem.getById(this, uncached, (byte)4);
            for (i = 0; i < ids.length; ++i) {
                if (ids[i] > -256 || items[i] != null) continue;
                item = this.getCachedItem(-ids[i]);
                if (!(item instanceof Message) || item.getParentId() == ids[i]) {
                    throw ServiceException.FAILURE("item should be cached but is not: " + -ids[i], null);
                }
                items[i] = this.getCachedItem(item.getParentId());
                if (items[i] != null) continue;
                throw MailItem.noSuchItem(ids[i], type);
            }
        }
        return items;
    }

    MailItem getCachedItem(Integer key) throws ServiceException {
        MailItem item = null;
        if (key < 0) {
            item = Flag.getFlag(this, key);
        }
        if (item == null && this.mTagCache != null) {
            item = this.mTagCache.get(key);
        }
        if (item == null && this.mFolderCache != null) {
            item = this.mFolderCache.get(key);
        }
        if (item == null) {
            item = this.getItemCache().get(key);
        }
        this.logCacheActivity(key, item == null ? (byte)-1 : (byte)item.getType(), item);
        return item;
    }

    MailItem getCachedItem(Integer key, byte type) throws ServiceException {
        MailItem item = null;
        switch (type) {
            case -1: {
                return this.getCachedItem(key);
            }
            case 3: 
            case 10: {
                if (key < 0) {
                    item = Flag.getFlag(this, key);
                    break;
                }
                if (this.mTagCache == null) break;
                item = this.mTagCache.get(key);
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                if (this.mFolderCache == null) break;
                item = this.mFolderCache.get(key);
                break;
            }
            default: {
                item = this.getItemCache().get(key);
            }
        }
        if (item != null && !MailItem.isAcceptableType(type, item.mData.type)) {
            item = null;
        }
        this.logCacheActivity(key, type, item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MailItem getItemFromUnderlyingData(MailItem.UnderlyingData data) throws ServiceException {
        MailItem mailItem;
        boolean success = false;
        try {
            this.beginTransaction("getItemFromUnderlyingData", null);
            MailItem item = this.getItem(data);
            success = true;
            mailItem = item;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return mailItem;
    }

    MailItem getItem(MailItem.UnderlyingData data) throws ServiceException {
        if (data == null) {
            return null;
        }
        MailItem item = this.getCachedItem(data.id, data.type);
        if (item != null) {
            return item;
        }
        return MailItem.constructItem(this, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MailItem getItemRevision(OperationContext octxt, int id, byte type, int version) throws ServiceException {
        MailItem mailItem;
        boolean success = false;
        try {
            this.beginTransaction("getItemRevision", octxt);
            MailItem revision = this.checkAccess(this.getItemById(id, type)).getRevision(version);
            success = true;
            mailItem = revision;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return mailItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends MailItem> List<T> getAllRevisions(OperationContext octxt, int id, byte type) throws ServiceException {
        ArrayList<MailItem> arrayList;
        boolean success = false;
        try {
            this.beginTransaction("getAllRevisions", octxt);
            MailItem item = this.checkAccess(this.getItemById(id, type));
            List<MailItem> previousRevisions = item.loadRevisions();
            ArrayList<MailItem> result = new ArrayList<MailItem>(previousRevisions.size());
            for (MailItem rev : previousRevisions) {
                result.add(rev);
            }
            result.add(item);
            success = true;
            arrayList = result;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MailItem getItemByImapId(OperationContext octxt, int imapId, int folderId) throws ServiceException {
        MailItem mailItem;
        boolean success = false;
        try {
            this.beginTransaction("getItemByImapId", octxt);
            MailItem item = this.checkAccess(this.getCachedItem(imapId));
            if (item == null) {
                try {
                    item = this.checkAccess(MailItem.getById(this, imapId));
                    if (item.getImapUid() != imapId) {
                        item = null;
                    }
                }
                catch (MailServiceException.NoSuchItemException nsie) {
                    // empty catch block
                }
            }
            if (item == null) {
                item = this.checkAccess(MailItem.getByImapId(this, imapId, folderId));
            }
            if (Mailbox.isCachedType(item.getType()) || item.getImapUid() != imapId || item.getFolderId() != folderId) {
                throw MailServiceException.NO_SUCH_ITEM(imapId);
            }
            success = true;
            mailItem = item;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return mailItem;
    }

    public synchronized MailItem getItemByPath(OperationContext octxt, String path) throws ServiceException {
        return this.getItemByPath(octxt, path, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MailItem getItemByPath(OperationContext octxt, String name, int folderId) throws ServiceException {
        MailItem mailItem;
        if (name == null || name.equals("")) {
            return this.getFolderById(octxt, folderId);
        }
        if (name.equals("/")) {
            return this.getFolderById(octxt, 1);
        }
        if (name.startsWith("/")) {
            folderId = 1;
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        Folder parent = this.getFolderById(null, folderId);
        boolean success = false;
        try {
            this.beginTransaction("getItemByName", octxt);
            int slash = name.lastIndexOf(47);
            if (slash != -1) {
                for (String segment : name.substring(0, slash).split("/")) {
                    if ((parent = parent.findSubfolder(segment)) != null) continue;
                    throw MailServiceException.NO_SUCH_FOLDER(name);
                }
                name = name.substring(slash + 1);
            }
            MailItem item = null;
            if (folderId == 8) {
                item = this.getTagByName(name);
            } else {
                item = parent.findSubfolder(name);
                if (item == null) {
                    this.checkAccess(parent);
                    item = this.getItem(DbMailItem.getByName(this, parent.getId(), name, (byte)8));
                }
            }
            if (this.checkAccess(item) == null) {
                throw MailServiceException.NO_SUCH_ITEM(name);
            }
            success = true;
            mailItem = item;
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return mailItem;
    }

    public synchronized <T extends MailItem> List<T> getItemList(OperationContext octxt, byte type) throws ServiceException {
        return this.getItemList(octxt, type, -1);
    }

    public synchronized <T extends MailItem> List<T> getItemList(OperationContext octxt, byte type, int folderId) throws ServiceException {
        return this.getItemList(octxt, type, folderId, SortBy.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized <T extends MailItem> List<T> getItemList(OperationContext octxt, byte type, int folderId, SortBy sort) throws ServiceException {
        ArrayList<MailItem> result;
        boolean success;
        block16: {
            List i$;
            block19: {
                List i$2;
                block18: {
                    List i$3;
                    block17: {
                        success = false;
                        if (type == -1) {
                            return Collections.emptyList();
                        }
                        try {
                            Folder folder;
                            this.beginTransaction("getItemList", octxt);
                            Folder folder2 = folder = folderId == -1 ? null : this.getFolderById(folderId);
                            if (folder == null ? !this.hasFullAccess() : !folder.canAccess((short)1, this.getAuthenticatedAccount(), this.isUsingAdminPrivileges())) {
                                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
                            }
                            if (type == 1 || type == 2 || type == 13) {
                                result = new ArrayList<MailItem>(this.mFolderCache.size());
                                for (Folder subfolder : this.mFolderCache.values()) {
                                    if (subfolder.getType() != type && type != 1 || folder != null && subfolder.getFolderId() != folderId) continue;
                                    result.add(subfolder);
                                }
                                success = true;
                                break block16;
                            }
                            if (type == 3) {
                                if (folderId != -1 && folderId != 8) {
                                    i$3 = Collections.emptyList();
                                    Object var12_19 = null;
                                    break block17;
                                }
                                result = new ArrayList(this.mTagCache.size() / 2);
                                for (Map.Entry<Object, Tag> entry : this.mTagCache.entrySet()) {
                                    if (!(entry.getKey() instanceof String)) continue;
                                    result.add(entry.getValue());
                                }
                                success = true;
                                break block16;
                            }
                            if (type == 10) {
                                if (folderId != -1 && folderId != 8) {
                                    i$2 = Collections.emptyList();
                                    break block18;
                                }
                                List<Flag> allFlags = Flag.getAllFlags(this);
                                result = new ArrayList(allFlags.size());
                                for (Flag flag : allFlags) {
                                    result.add(flag);
                                }
                                success = true;
                                break block16;
                            }
                            List<MailItem.UnderlyingData> dataList = folder != null ? DbMailItem.getByFolder(folder, type, sort) : DbMailItem.getByType(this, type, sort);
                            if (dataList == null) {
                                i$ = Collections.emptyList();
                                break block19;
                            }
                            result = new ArrayList(dataList.size());
                            for (MailItem.UnderlyingData data : dataList) {
                                if (data == null) continue;
                                result.add(this.getItem(data));
                            }
                            if (sort.getCriterion() == SortBy.SortCriterion.NAME_NATURAL_ORDER) {
                                sort = SortBy.NONE;
                            }
                            success = true;
                            break block16;
                        }
                        catch (Throwable throwable) {
                            Object var12_23 = null;
                            this.endTransaction(success);
                            throw throwable;
                        }
                    }
                    this.endTransaction(success);
                    return i$3;
                }
                Object var12_20 = null;
                this.endTransaction(success);
                return i$2;
            }
            Object var12_21 = null;
            this.endTransaction(success);
            return i$;
        }
        Object var12_22 = null;
        this.endTransaction(success);
        Comparator<MailItem> comp = MailItem.getComparator(sort);
        if (comp != null) {
            Collections.sort(result, comp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Integer> listItemIds(OperationContext octxt, byte type, int folderId) throws ServiceException {
        List<Integer> list;
        boolean success = false;
        try {
            this.beginTransaction("listItemIds", octxt);
            Folder folder = this.getFolderById(folderId);
            List<Integer> ids = DbMailItem.listByFolder(folder, type, true);
            success = true;
            list = ids;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TypedIdList getItemIds(OperationContext octxt, int folderId) throws ServiceException {
        TypedIdList typedIdList;
        boolean success = false;
        try {
            this.beginTransaction("listAllItemIds", octxt);
            Folder folder = this.getFolderById(folderId);
            TypedIdList ids = DbMailItem.listByFolder(folder, true);
            success = true;
            typedIdList = ids;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return typedIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ImapMessage> openImapFolder(OperationContext octxt, int folderId) throws ServiceException {
        List<ImapMessage> list;
        boolean success = false;
        try {
            this.beginTransaction("openImapFolder", octxt);
            Folder folder = this.getFolderById(folderId);
            List<ImapMessage> i4list = DbMailItem.loadImapFolder(folder);
            success = true;
            list = i4list;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Pop3Message> openPop3Folder(OperationContext octxt, int folderId, Date popSince) throws ServiceException {
        List<Pop3Message> list;
        boolean success = false;
        try {
            this.beginTransaction("openPop3Folder", octxt);
            Folder folder = this.getFolderById(folderId);
            List<Pop3Message> p3list = DbMailItem.loadPop3Folder(folder, popSince);
            success = true;
            list = p3list;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getImapRecent(OperationContext octxt, int folderId) throws ServiceException {
        int n;
        boolean success = false;
        try {
            this.beginTransaction("openImapFolder", octxt);
            Folder folder = this.checkAccess(this.getFolderById(folderId));
            int recent = folder.getImapRECENT();
            success = true;
            n = recent;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginTrackingImap() throws ServiceException {
        if (this.isTrackingImap()) {
            return;
        }
        TrackImap redoRecorder = new TrackImap(this.mId);
        boolean success = false;
        try {
            this.beginTransaction("beginTrackingImap", null, redoRecorder);
            DbMailbox.startTrackingImap(this);
            this.mCurrentChange.imap = Boolean.TRUE;
            success = true;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginTrackingSync() throws ServiceException {
        if (this.isTrackingSync()) {
            return;
        }
        TrackSync redoRecorder = new TrackSync(this.mId);
        boolean success = false;
        try {
            this.beginTransaction("beginTrackingSync", null, redoRecorder);
            DbMailbox.startTrackingSync(this);
            this.mCurrentChange.sync = this.getLastChangeID();
            success = true;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordImapSession(int folderId) throws ServiceException {
        boolean success = false;
        try {
            this.beginTransaction("recordImapSession", null);
            this.getFolderById(folderId).checkpointRECENT();
            success = true;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized List<Integer> listTombstones(int lastSync) throws ServiceException {
        return this.getTombstones(lastSync).getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TypedIdList getTombstones(int lastSync) throws ServiceException {
        TypedIdList typedIdList;
        if (!this.isTrackingSync()) {
            throw ServiceException.FAILURE("not tracking sync", null);
        }
        boolean success = false;
        try {
            this.beginTransaction("getTombstones", null);
            TypedIdList tombstones = DbMailItem.readTombstones(this, lastSync);
            success = true;
            typedIdList = tombstones;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return typedIdList;
    }

    public synchronized List<Folder> getModifiedFolders(int lastSync) throws ServiceException {
        return this.getModifiedFolders(lastSync, (byte)-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Folder> getModifiedFolders(int lastSync, byte type) throws ServiceException {
        ArrayList<Folder> arrayList;
        if (lastSync >= this.getLastChangeID()) {
            return Collections.emptyList();
        }
        ArrayList<Folder> modified = new ArrayList<Folder>();
        boolean success = false;
        try {
            this.beginTransaction("getModifiedFolders", null);
            for (Folder subfolder : this.getFolderById(11).getSubfolderHierarchy()) {
                if (type != -1 && subfolder.getType() != type || subfolder.getModifiedSequence() <= lastSync) continue;
                modified.add(subfolder);
            }
            success = true;
            arrayList = modified;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Tag> getModifiedTags(OperationContext octxt, int lastSync) throws ServiceException {
        ArrayList<Tag> arrayList;
        if (lastSync >= this.getLastChangeID()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> modified = new ArrayList<Tag>();
        boolean success = false;
        try {
            this.beginTransaction("getModifiedTags", octxt);
            if (this.hasFullAccess()) {
                for (Map.Entry<Object, Tag> entry : this.mTagCache.entrySet()) {
                    Tag tag;
                    if (!(entry.getKey() instanceof String) || (tag = entry.getValue()).getModifiedSequence() <= lastSync) continue;
                    modified.add(tag);
                }
            }
            success = true;
            arrayList = modified;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return arrayList;
    }

    public synchronized Pair<List<Integer>, TypedIdList> getModifiedItems(OperationContext octxt, int lastSync) throws ServiceException {
        return this.getModifiedItems(octxt, lastSync, (byte)-1, null);
    }

    public synchronized Pair<List<Integer>, TypedIdList> getModifiedItems(OperationContext octxt, int lastSync, byte type) throws ServiceException {
        return this.getModifiedItems(octxt, lastSync, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<List<Integer>, TypedIdList> getModifiedItems(OperationContext octxt, int lastSync, byte type, Set<Integer> folderIds) throws ServiceException {
        Pair<List<Integer>, TypedIdList> dataList;
        boolean success;
        block7: {
            Pair<List<Integer>, TypedIdList> pair;
            if (lastSync >= this.getLastChangeID()) {
                return new Pair<List<Integer>, TypedIdList>(EMPTY_ITEMS, new TypedIdList());
            }
            success = false;
            try {
                this.beginTransaction("getModifiedItems", octxt);
                Set<Integer> visible = this.getVisibleFolderIds();
                if (folderIds == null) {
                    folderIds = visible;
                } else if (visible != null) {
                    folderIds = SetUtil.intersect(folderIds, visible);
                }
                dataList = DbMailItem.getModifiedItems(this, type, lastSync, folderIds);
                if (dataList != null) break block7;
                pair = null;
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.endTransaction(success);
                throw throwable;
            }
            this.endTransaction(success);
            return pair;
        }
        success = true;
        Pair<List<Integer>, TypedIdList> pair = dataList;
        Object var10_11 = null;
        this.endTransaction(success);
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<Folder> getVisibleFolders(OperationContext octxt) throws ServiceException {
        Set<Folder> set;
        boolean success = false;
        try {
            this.beginTransaction("getVisibleFolders", octxt);
            Set<Folder> visible = this.getVisibleFolders();
            success = true;
            set = visible;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return set;
    }

    Set<Folder> getVisibleFolders() throws ServiceException {
        return this.getAccessibleFolders((short)1);
    }

    Set<Folder> getAccessibleFolders(short rights) throws ServiceException {
        if (!this.mCurrentChange.isActive()) {
            throw ServiceException.FAILURE("cannot get visible hierarchy outside transaction", null);
        }
        if (this.hasFullAccess()) {
            return null;
        }
        boolean incomplete = false;
        HashSet<Folder> visible = new HashSet<Folder>();
        for (Folder folder : this.mFolderCache.values()) {
            if (folder.canAccess(rights)) {
                visible.add(folder);
                continue;
            }
            incomplete = true;
        }
        return incomplete ? visible : null;
    }

    Set<Integer> getVisibleFolderIds() throws ServiceException {
        Set<Folder> folders = this.getVisibleFolders();
        if (folders == null) {
            return null;
        }
        HashSet<Integer> visible = new HashSet<Integer>(folders.size());
        for (Folder folder : folders) {
            visible.add(folder.getId());
        }
        return visible;
    }

    public Flag getFlagById(int flagId) throws ServiceException {
        Flag flag = Flag.getFlag(this, flagId);
        if (flag == null) {
            throw MailServiceException.NO_SUCH_TAG(flagId);
        }
        return flag;
    }

    public List<Flag> getFlagList() throws ServiceException {
        return Flag.getAllFlags(this);
    }

    public synchronized Tag getTagById(OperationContext octxt, int id) throws ServiceException {
        return (Tag)this.getItemById(octxt, id, (byte)3);
    }

    Tag getTagById(int id) throws ServiceException {
        return (Tag)this.getItemById(id, (byte)3);
    }

    public synchronized List<Tag> getTagList(OperationContext octxt) throws ServiceException {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (MailItem item : this.getItemList(octxt, (byte)3)) {
            tags.add((Tag)item);
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Tag getTagByName(String name) throws ServiceException {
        Flag flag;
        boolean success = false;
        try {
            Flag tag;
            this.beginTransaction("getTagByName", null);
            if (name == null || name.equals("")) {
                throw ServiceException.INVALID_REQUEST("tag name may not be null", null);
            }
            Tag tag2 = tag = name.charAt(0) == '\\' ? Flag.getFlag(this, name) : this.mTagCache.get(name.toLowerCase());
            if (tag == null) {
                throw MailServiceException.NO_SUCH_TAG(name);
            }
            this.checkAccess(tag);
            success = true;
            flag = tag;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return flag;
    }

    public synchronized Folder getFolderById(OperationContext octxt, int id) throws ServiceException {
        return (Folder)this.getItemById(octxt, id, (byte)1);
    }

    protected Folder getFolderById(int id) throws ServiceException {
        return (Folder)this.getItemById(id, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Folder getFolderByName(OperationContext octxt, int parentId, String name) throws ServiceException {
        Folder folder;
        boolean success = false;
        try {
            this.beginTransaction("getFolderByName", octxt);
            Folder folder2 = this.getFolderById(parentId).findSubfolder(name);
            if (folder2 == null) {
                throw MailServiceException.NO_SUCH_FOLDER(name);
            }
            if (!folder2.canAccess((short)1)) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions on folder " + name);
            }
            success = true;
            folder = folder2;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Folder getFolderByPath(OperationContext octxt, String path) throws ServiceException {
        Folder folder;
        if (path == null) {
            throw MailServiceException.NO_SUCH_FOLDER(path);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Folder folder2 = this.getFolderById(null, 1);
        boolean success = false;
        try {
            this.beginTransaction("getFolderByPath", octxt);
            if (!path.equals("")) {
                String segment;
                String[] arr$ = path.split("/");
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (folder2 = folder2.findSubfolder(segment = arr$[i$])) != null; ++i$) {
                }
            }
            if (folder2 == null) {
                throw MailServiceException.NO_SUCH_FOLDER("/" + path);
            }
            if (!folder2.canAccess((short)1)) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions on folder /" + path);
            }
            success = true;
            folder = folder2;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<Folder, String> getFolderByPathLongestMatch(OperationContext octxt, int startingFolderId, String path) throws ServiceException {
        Pair<Folder, Object> pair;
        if (path == null) {
            throw MailServiceException.NO_SUCH_FOLDER(path);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            throw MailServiceException.NO_SUCH_FOLDER("/" + path);
        }
        Folder folder = this.getFolderById(null, startingFolderId);
        assert (folder != null);
        boolean success = false;
        try {
            this.beginTransaction("getFolderByPathLongestMatch", octxt);
            String unmatched = null;
            Object[] segments = path.split("/");
            for (int i = 0; i < segments.length; ++i) {
                Folder subfolder = folder.findSubfolder(segments[i]);
                if (subfolder == null) {
                    unmatched = StringUtil.join("/", segments, i, segments.length - i);
                    break;
                }
                folder = subfolder;
            }
            pair = new Pair<Folder, Object>(this.checkAccess(folder), unmatched);
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return pair;
    }

    public synchronized List<Folder> getFolderList(OperationContext octxt, SortBy sort) throws ServiceException {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (MailItem item : this.getItemList(octxt, (byte)1, -1, sort)) {
            folders.add((Folder)item);
        }
        return folders;
    }

    List<Folder> listAllFolders() {
        return new ArrayList<Folder>(this.mFolderCache.values());
    }

    public synchronized FolderNode getFolderTree(OperationContext octxt, ItemId iid, boolean returnAllVisibleFolders) throws ServiceException {
        int folderId = iid != null ? iid.getId() : 1;
        Folder folder = this.getFolderById(returnAllVisibleFolders ? null : octxt, folderId);
        Set<Folder> visibleFolders = this.getVisibleFolders(octxt);
        return this.handleFolder(folder, visibleFolders, returnAllVisibleFolders);
    }

    private FolderNode handleFolder(Folder folder, Set<Folder> visible, boolean returnAllVisibleFolders) throws ServiceException {
        boolean isVisible;
        boolean bl = isVisible = visible == null || visible.remove(folder);
        if (!isVisible && !returnAllVisibleFolders) {
            return null;
        }
        List<Folder> subfolders = folder.getSubfolders(null);
        if (!isVisible && subfolders.isEmpty()) {
            return null;
        }
        FolderNode node = new FolderNode();
        node.mId = folder.getId();
        node.mName = node.mId == 11 ? null : folder.getName();
        Folder folder2 = node.mFolder = isVisible ? folder : null;
        if (isVisible && visible != null && visible.isEmpty()) {
            return node;
        }
        for (Folder subfolder : subfolders) {
            FolderNode child = this.handleFolder(subfolder, visible, returnAllVisibleFolders);
            if (child == null) continue;
            node.mSubfolders.add(child);
            isVisible = true;
        }
        return isVisible ? node : null;
    }

    public synchronized List<Folder> getCalendarFolders(OperationContext octxt, SortBy sort) throws ServiceException {
        byte view;
        Folder f;
        ArrayList<Folder> calFolders = new ArrayList<Folder>();
        for (MailItem item : this.getItemList(octxt, (byte)1, -1, sort)) {
            f = (Folder)item;
            view = f.getDefaultView();
            if (view != 11 && view != 15) continue;
            calFolders.add((Folder)item);
        }
        for (MailItem item : this.getItemList(octxt, (byte)13, -1, sort)) {
            f = (Folder)item;
            view = f.getDefaultView();
            if (view != 11 && view != 15) continue;
            calFolders.add((Folder)item);
        }
        return calFolders;
    }

    public synchronized SearchFolder getSearchFolderById(OperationContext octxt, int searchId) throws ServiceException {
        return (SearchFolder)this.getItemById(octxt, searchId, (byte)2);
    }

    SearchFolder getSearchFolderById(int searchId) throws ServiceException {
        return (SearchFolder)this.getItemById(searchId, (byte)2);
    }

    public synchronized Mountpoint getMountpointById(OperationContext octxt, int mptId) throws ServiceException {
        return (Mountpoint)this.getItemById(octxt, mptId, (byte)13);
    }

    public synchronized Note getNoteById(OperationContext octxt, int noteId) throws ServiceException {
        return (Note)this.getItemById(octxt, noteId, (byte)9);
    }

    Note getNoteById(int noteId) throws ServiceException {
        return (Note)this.getItemById(noteId, (byte)9);
    }

    public synchronized List<Note> getNoteList(OperationContext octxt, int folderId) throws ServiceException {
        return this.getNoteList(octxt, folderId, SortBy.NONE);
    }

    public synchronized List<Note> getNoteList(OperationContext octxt, int folderId, SortBy sort) throws ServiceException {
        ArrayList<Note> notes = new ArrayList<Note>();
        for (MailItem item : this.getItemList(octxt, (byte)9, folderId, sort)) {
            notes.add((Note)item);
        }
        return notes;
    }

    public synchronized Chat getChatById(OperationContext octxt, int id) throws ServiceException {
        return (Chat)this.getItemById(octxt, id, (byte)16);
    }

    Chat getChatById(int id) throws ServiceException {
        return (Chat)this.getItemById(id, (byte)16);
    }

    public synchronized List<Chat> getChatList(OperationContext octxt, int folderId) throws ServiceException {
        return this.getChatList(octxt, folderId, SortBy.NONE);
    }

    public synchronized List<Chat> getChatList(OperationContext octxt, int folderId, SortBy sort) throws ServiceException {
        ArrayList<Chat> chats = new ArrayList<Chat>();
        for (MailItem item : this.getItemList(octxt, (byte)16, folderId, sort)) {
            chats.add((Chat)item);
        }
        return chats;
    }

    public synchronized Contact getContactById(OperationContext octxt, int id) throws ServiceException {
        return (Contact)this.getItemById(octxt, id, (byte)6);
    }

    Contact getContactById(int id) throws ServiceException {
        return (Contact)this.getItemById(id, (byte)6);
    }

    public synchronized List<Contact> getContactList(OperationContext octxt, int folderId) throws ServiceException {
        return this.getContactList(octxt, folderId, SortBy.NONE);
    }

    public synchronized List<Contact> getContactList(OperationContext octxt, int folderId, SortBy sort) throws ServiceException {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (MailItem item : this.getItemList(octxt, (byte)6, folderId, sort)) {
            contacts.add((Contact)item);
        }
        return contacts;
    }

    public synchronized Message getMessageById(OperationContext octxt, int id) throws ServiceException {
        return (Message)this.getItemById(octxt, id, (byte)5);
    }

    Message getMessageById(int id) throws ServiceException {
        return (Message)this.getItemById(id, (byte)5);
    }

    Message getMessage(MailItem.UnderlyingData data) throws ServiceException {
        return (Message)this.getItem(data);
    }

    Message getCachedMessage(Integer id) throws ServiceException {
        return (Message)this.getCachedItem(id, (byte)5);
    }

    public synchronized List<Message> getMessagesByConversation(OperationContext octxt, int convId) throws ServiceException {
        return this.getMessagesByConversation(octxt, convId, SortBy.DATE_ASCENDING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Message> getMessagesByConversation(OperationContext octxt, int convId, SortBy sort) throws ServiceException {
        List<Message> list;
        boolean success = false;
        try {
            this.beginTransaction("getMessagesByConversation", octxt);
            List<Message> msgs = this.getConversationById(convId).getMessages(sort);
            if (!this.hasFullAccess()) {
                ArrayList<Message> visible = new ArrayList<Message>(msgs.size());
                for (Message msg : msgs) {
                    if (!msg.canAccess((short)1)) continue;
                    visible.add(msg);
                }
                msgs = visible;
            }
            success = true;
            list = msgs;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return list;
    }

    public synchronized Conversation getConversationById(OperationContext octxt, int id) throws ServiceException {
        return (Conversation)this.getItemById(octxt, id, (byte)4);
    }

    Conversation getConversationById(int id) throws ServiceException {
        return (Conversation)this.getItemById(id, (byte)4);
    }

    Conversation getConversation(MailItem.UnderlyingData data) throws ServiceException {
        return (Conversation)this.getItem(data);
    }

    Conversation getCachedConversation(Integer id) throws ServiceException {
        return (Conversation)this.getCachedItem(id, (byte)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Conversation getConversationByHash(OperationContext octxt, String hash) throws ServiceException {
        Conversation conversation;
        boolean success = false;
        try {
            this.beginTransaction("getConversationByHash", octxt);
            Conversation item = this.checkAccess(this.getConversationByHash(hash));
            success = true;
            conversation = item;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return conversation;
    }

    Conversation getConversationByHash(String hash) throws ServiceException {
        Conversation conv = null;
        Integer convId = (Integer)this.mConvHashes.get((Object)hash);
        if (convId != null) {
            conv = this.getCachedConversation(convId);
        }
        if (conv != null) {
            return conv;
        }
        MailItem.UnderlyingData data = DbMailItem.getByHash(this, hash);
        if (data == null || data.type == 4) {
            return this.getConversation(data);
        }
        return (Conversation)this.getMessage(data).getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SenderList getConversationSenderList(int convId) throws ServiceException {
        SenderList senderList;
        boolean success = false;
        try {
            this.beginTransaction("getSenderList", null);
            Conversation conv = this.getConversationById(convId);
            SenderList sl = conv.getSenderList();
            success = true;
            senderList = sl;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return senderList;
    }

    public WikiItem getWikiById(OperationContext octxt, int id) throws ServiceException {
        return (WikiItem)this.getItemById(octxt, id, (byte)14);
    }

    public Document getDocumentById(OperationContext octxt, int id) throws ServiceException {
        return (Document)this.getItemById(octxt, id, (byte)8);
    }

    Document getDocumentById(int id) throws ServiceException {
        return (Document)this.getItemById(id, (byte)8);
    }

    public synchronized List<Document> getDocumentList(OperationContext octxt, int folderId) throws ServiceException {
        return this.getDocumentList(octxt, folderId, SortBy.NONE);
    }

    public synchronized List<Document> getDocumentList(OperationContext octxt, int folderId, SortBy sort) throws ServiceException {
        ArrayList<Document> docs = new ArrayList<Document>();
        for (MailItem item : this.getItemList(octxt, (byte)8, folderId, sort)) {
            docs.add((Document)item);
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<CalendarItem.CalendarMetadata> getCalendarItemMetadata(OperationContext octxt, int folderId, long start, long end) throws ServiceException {
        List<CalendarItem.CalendarMetadata> list;
        boolean success = false;
        try {
            this.beginTransaction("getCalendarItemMetadata", null);
            Folder f = this.getFolderById(folderId);
            if (!f.canAccess((short)1)) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
            }
            success = true;
            list = DbMailItem.getCalendarItemMetadata(f, start, end);
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return list;
    }

    private void checkCalendarType(MailItem item) throws ServiceException {
        byte type = item.getType();
        if (type != 11 && type != 15) {
            throw MailServiceException.NO_SUCH_CALITEM(item.getId());
        }
    }

    public synchronized CalendarItem getCalendarItemById(OperationContext octxt, int id) throws ServiceException {
        MailItem item = this.getItemById(octxt, id, (byte)-1);
        this.checkCalendarType(item);
        return (CalendarItem)item;
    }

    CalendarItem getCalendarItemById(int id) throws ServiceException {
        MailItem item = this.getItemById(id, (byte)-1);
        this.checkCalendarType(item);
        return (CalendarItem)item;
    }

    CalendarItem getCalendarItem(MailItem.UnderlyingData data) throws ServiceException {
        return (CalendarItem)this.getItem(data);
    }

    public synchronized List getCalendarItemList(OperationContext octxt, int folderId) throws ServiceException {
        return this.getItemList(octxt, (byte)-1, folderId);
    }

    public synchronized Appointment getAppointmentById(OperationContext octxt, int id) throws ServiceException {
        return (Appointment)this.getItemById(octxt, id, (byte)11);
    }

    Appointment getAppointmentById(int id) throws ServiceException {
        return (Appointment)this.getItemById(id, (byte)11);
    }

    public synchronized List getAppointmentList(OperationContext octxt, int folderId) throws ServiceException {
        return this.getItemList(octxt, (byte)11, folderId);
    }

    public synchronized Task getTaskById(OperationContext octxt, int id) throws ServiceException {
        return (Task)this.getItemById(octxt, id, (byte)15);
    }

    Task getTaskById(int id) throws ServiceException {
        return (Task)this.getItemById(id, (byte)15);
    }

    public synchronized List getTaskList(OperationContext octxt, int folderId) throws ServiceException {
        return this.getItemList(octxt, (byte)15, folderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TypedIdList listCalendarItemsForRange(OperationContext octxt, byte type, long start, long end, int folderId) throws ServiceException {
        TypedIdList typedIdList;
        if (folderId == -1) {
            return new TypedIdList();
        }
        boolean success = false;
        try {
            this.beginTransaction("listCalendarItemsForRange", octxt);
            this.getFolderById(folderId);
            TypedIdList ids = DbMailItem.listCalendarItems(this, type, start, end, folderId, null);
            success = true;
            typedIdList = ids;
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return typedIdList;
    }

    public synchronized List<CalendarItem> getCalendarItems(OperationContext octxt, byte type, int folderId) throws ServiceException {
        return this.getCalendarItemsForRange(octxt, type, -1L, -1L, folderId, null);
    }

    public synchronized List<CalendarItem> getCalendarItemsForRange(OperationContext octxt, long start, long end, int folderId, int[] excludeFolders) throws ServiceException {
        return this.getCalendarItemsForRange(octxt, (byte)-1, start, end, folderId, excludeFolders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<CalendarItem> getCalendarItemsForRange(OperationContext octxt, byte type, long start, long end, int folderId, int[] excludeFolders) throws ServiceException {
        ArrayList<CalendarItem> arrayList;
        boolean success = false;
        try {
            this.beginTransaction("getCalendarItemsForRange", octxt);
            if (folderId != -1) {
                this.getFolderById(folderId);
            }
            ArrayList<CalendarItem> calItems = new ArrayList<CalendarItem>();
            List<MailItem.UnderlyingData> invData = DbMailItem.getCalendarItems(this, type, start, end, folderId, excludeFolders);
            for (MailItem.UnderlyingData data : invData) {
                try {
                    CalendarItem calItem = this.getCalendarItem(data);
                    if (folderId != calItem.getFolderId() && (folderId != -1 || !calItem.inMailbox()) || !calItem.canAccess((short)1)) continue;
                    calItems.add(calItem);
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)("Error while retrieving calendar item " + data.id + " in mailbox " + this.mId + "; skipping item"), e);
                }
            }
            success = true;
            arrayList = calItems;
            Object var16_14 = null;
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Integer> getItemListByDates(OperationContext octxt, byte type, long start, long end, int folderId, boolean descending) throws ServiceException {
        List<Integer> list;
        boolean success = false;
        try {
            this.beginTransaction("getItemListByDates", octxt);
            List<Integer> msgIds = DbMailItem.getItemListByDates(this, type, start, end, folderId, descending);
            success = true;
            list = msgIds;
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return list;
    }

    public synchronized ZCalendar.ZVCalendar getZCalendarForCalendarItems(Collection<CalendarItem> calItems, boolean useOutlookCompatMode, boolean ignoreErrors, boolean allowPrivateAccess) throws ServiceException {
        ZCalendar.ZVCalendar cal = new ZCalendar.ZVCalendar();
        cal.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.METHOD, ZCalendar.ICalTok.PUBLISH.toString()));
        ICalTimeZone localTz = ICalTimeZone.getAccountTimeZone(this.getAccount());
        TimeZoneMap tzmap = new TimeZoneMap(localTz);
        for (CalendarItem calItem : calItems) {
            tzmap.add(calItem.getTimeZoneMap());
        }
        Iterator<ICalTimeZone> iter = tzmap.tzIterator();
        while (iter.hasNext()) {
            ICalTimeZone cur = iter.next();
            cal.addComponent(cur.newToVTimeZone());
        }
        for (CalendarItem calItem : calItems) {
            calItem.appendRawCalendarData(cal, useOutlookCompatMode, ignoreErrors, allowPrivateAccess);
        }
        return cal;
    }

    public synchronized void writeICalendarForCalendarItems(Writer writer, OperationContext octxt, Collection<CalendarItem> calItems, boolean useOutlookCompatMode, boolean ignoreErrors, boolean needAppleICalHacks, boolean trimCalItemsList) throws ServiceException {
        try {
            writer.write("BEGIN:VCALENDAR\r\n");
            ZCalendar.ZProperty prop = new ZCalendar.ZProperty(ZCalendar.ICalTok.PRODID, "Zimbra-Calendar-Provider");
            prop.toICalendar(writer, needAppleICalHacks);
            prop = new ZCalendar.ZProperty(ZCalendar.ICalTok.VERSION, "2.0");
            prop.toICalendar(writer, needAppleICalHacks);
            prop = new ZCalendar.ZProperty(ZCalendar.ICalTok.METHOD, ZCalendar.ICalTok.PUBLISH.toString());
            prop.toICalendar(writer, needAppleICalHacks);
            ICalTimeZone localTz = ICalTimeZone.getAccountTimeZone(this.getAccount());
            TimeZoneMap tzmap = new TimeZoneMap(localTz);
            for (CalendarItem calItem : calItems) {
                tzmap.add(calItem.getTimeZoneMap());
            }
            Iterator<Object> iter = tzmap.tzIterator();
            while (iter.hasNext()) {
                ICalTimeZone tz = iter.next();
                tz.newToVTimeZone().toICalendar(writer, needAppleICalHacks);
            }
            tzmap = null;
            iter = calItems.iterator();
            while (iter.hasNext()) {
                Invite[] invites;
                boolean allowPrivateAccess;
                CalendarItem calItem;
                calItem = (CalendarItem)iter.next();
                boolean bl = allowPrivateAccess = calItem.isPublic() || calItem.allowPrivateAccess(octxt.getAuthenticatedUser(), octxt.isUsingAdminPrivileges());
                if (trimCalItemsList) {
                    iter.remove();
                }
                if ((invites = calItem.getInvites()) == null || invites.length <= 0) continue;
                boolean appleICalExdateHack = LC.calendar_apple_ical_compatible_canceled_instances.booleanValue();
                ZCalendar.ZComponent[] comps = null;
                try {
                    comps = Invite.toVComponents(invites, allowPrivateAccess, useOutlookCompatMode, appleICalExdateHack);
                }
                catch (ServiceException e) {
                    if (ignoreErrors) {
                        ZimbraLog.calendar.warn((Object)("Error retrieving iCalendar data for item " + calItem.getId() + ": " + e.getMessage()), e);
                    }
                    throw e;
                }
                if (comps == null) continue;
                for (ZCalendar.ZComponent comp : comps) {
                    comp.toICalendar(writer, needAppleICalHacks);
                }
            }
            writer.write("END:VCALENDAR\r\n");
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Error writing iCalendar", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeICalendarForRange(Writer writer, OperationContext octxt, long start, long end, int folderId, boolean useOutlookCompatMode, boolean ignoreErrors, boolean needAppleICalHacks) throws ServiceException {
        boolean success = false;
        try {
            this.beginTransaction("writeICalendarForRange", octxt);
            List<CalendarItem> calItems = this.getCalendarItemsForRange(octxt, start, end, folderId, null);
            this.writeICalendarForCalendarItems(writer, octxt, calItems, useOutlookCompatMode, ignoreErrors, needAppleICalHacks, true);
            Object var14_11 = null;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized CalSummaryCache.CalendarDataResult getCalendarSummaryForRange(OperationContext octxt, int folderId, byte itemType, long start, long end) throws ServiceException {
        Folder folder = this.getFolderById(folderId);
        if (!folder.canAccess((short)1)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on folder " + folder.getName());
        }
        return CalendarCacheManager.getInstance().getSummaryCache().getCalendarSummary(octxt, this.getAccountId(), folderId, itemType, start, end, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<CalSummaryCache.CalendarDataResult> getAllCalendarsSummaryForRange(OperationContext octxt, byte itemType, long start, long end) throws ServiceException {
        ArrayList<CalSummaryCache.CalendarDataResult> arrayList;
        boolean success = false;
        try {
            this.beginTransaction("getAllCalendarsSummaryForRange", octxt);
            success = true;
            ArrayList<CalSummaryCache.CalendarDataResult> list = new ArrayList<CalSummaryCache.CalendarDataResult>();
            for (Folder folder : this.listAllFolders()) {
                CalSummaryCache.CalendarDataResult result;
                if (folder.inTrash() || folder.inSpam() || folder.getDefaultView() != itemType || !folder.canAccess((short)1) || (result = CalendarCacheManager.getInstance().getSummaryCache().getCalendarSummary(octxt, this.getAccountId(), folder.getId(), itemType, start, end, true)) == null) continue;
                list.add(result);
            }
            arrayList = list;
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return arrayList;
    }

    public ZimbraQueryResults search(OperationContext octxt, String queryString, byte[] types, SortBy sortBy, int chunkSize) throws IOException, ParseException, ServiceException {
        SearchParams params = new SearchParams();
        params.setQueryStr(queryString);
        params.setTimeZone(null);
        params.setLocale(null);
        params.setTypes(types);
        params.setSortBy(sortBy);
        params.setChunkSize(chunkSize);
        params.setPrefetch(true);
        params.setMode(SearchResultMode.NORMAL);
        return this.search(SoapProtocol.Soap12, octxt, params);
    }

    public synchronized void redoIndexItem(MailItem item, boolean deleteFirst, int itemId, byte itemType, long timestamp, boolean noRedo, List<IndexDocument> docList) {
        this.mIndexHelper.redoIndexItem(item, deleteFirst, itemId, itemType, timestamp, noRedo, docList);
    }

    public ZimbraQueryResults search(SoapProtocol proto, OperationContext octxt, SearchParams params) throws IOException, ParseException, ServiceException {
        return this.mIndexHelper.search(proto, octxt, params);
    }

    public String getRewrittenQueryString(OperationContext octxt, SearchParams params) throws ParseException, ServiceException {
        if (octxt == null) {
            throw ServiceException.INVALID_REQUEST("The OperationContext must not be null", null);
        }
        ZimbraQuery zq = new ZimbraQuery(octxt, SoapProtocol.Soap12, this, params);
        return zq.toQueryString();
    }

    public synchronized FreeBusy getFreeBusy(OperationContext octxt, long start, long end, int folder) throws ServiceException {
        return this.getFreeBusy(octxt, this.getAccount().getName(), start, end, folder, null);
    }

    public synchronized FreeBusy getFreeBusy(OperationContext octxt, long start, long end, Appointment exAppt) throws ServiceException {
        return this.getFreeBusy(octxt, this.getAccount().getName(), start, end, -1, exAppt);
    }

    public synchronized FreeBusy getFreeBusy(OperationContext octxt, String name, long start, long end, int folder) throws ServiceException {
        return this.getFreeBusy(octxt, name, start, end, folder, null);
    }

    public synchronized FreeBusy getFreeBusy(OperationContext octxt, String name, long start, long end, int folder, Appointment exAppt) throws ServiceException {
        boolean asAdmin;
        Account authAcct;
        if (octxt != null) {
            authAcct = octxt.getAuthenticatedUser();
            asAdmin = octxt.isUsingAdminPrivileges();
        } else {
            authAcct = null;
            asAdmin = false;
        }
        return LocalFreeBusyProvider.getFreeBusyList(authAcct, asAdmin, this, name, start, end, folder, exAppt);
    }

    private void addDomains(HashMap<String, BrowseResult.DomainItem> domainItems, HashSet<BrowseTerm> newDomains, int flag) {
        for (BrowseTerm domain : newDomains) {
            BrowseResult.DomainItem di = domainItems.get(domain.term);
            if (di == null) {
                di = new BrowseResult.DomainItem(domain);
                domainItems.put(domain.term, di);
            }
            di.addFlag(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BrowseResult browse(OperationContext octxt, BrowseBy browseBy, String regex, int max) throws IOException, ServiceException {
        BrowseResult browseResult;
        boolean success = false;
        try {
            this.beginTransaction("browse", octxt);
            if (!this.hasFullAccess()) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions on this mailbox");
            }
            BrowseResult browseResult2 = new BrowseResult();
            MailboxIndex idx = this.getMailboxIndex();
            if (idx != null) {
                switch (browseBy) {
                    case attachments: {
                        idx.getAttachments(regex, browseResult2.getResult());
                        break;
                    }
                    case domains: {
                        HashMap<String, BrowseResult.DomainItem> domainItems = new HashMap<String, BrowseResult.DomainItem>();
                        HashSet<BrowseTerm> set = new HashSet<BrowseTerm>();
                        idx.getDomainsForField("cc", regex, set);
                        this.addDomains(domainItems, set, 4);
                        set.clear();
                        idx.getDomainsForField("from", regex, set);
                        this.addDomains(domainItems, set, 1);
                        set.clear();
                        idx.getDomainsForField("to", regex, set);
                        this.addDomains(domainItems, set, 2);
                        browseResult2.getResult().addAll(domainItems.values());
                        break;
                    }
                    case objects: {
                        idx.getObjects(regex, browseResult2.getResult());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown browseBy: " + (Object)((Object)browseBy));
                    }
                }
            }
            if (max > 0 && browseResult2.getResult().size() > max) {
                Comparator<BrowseTerm> reverseComp = new Comparator<BrowseTerm>(){

                    @Override
                    public int compare(BrowseTerm o1, BrowseTerm o2) {
                        int retVal = o2.freq - o1.freq;
                        if (retVal == 0) {
                            retVal = o1.term.compareTo(o2.term);
                        }
                        return retVal;
                    }
                };
                Collections.sort(browseResult2.getResult(), reverseComp);
                int num = 0;
                Iterator<BrowseTerm> iter = browseResult2.getResult().iterator();
                while (iter.hasNext()) {
                    iter.next();
                    if (++num <= max) continue;
                    iter.remove();
                }
            }
            success = true;
            browseResult = browseResult2;
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return browseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dismissCalendarItemAlarm(OperationContext octxt, int calItemId, long dismissedAt) throws ServiceException {
        DismissCalendarItemAlarm redoRecorder = new DismissCalendarItemAlarm(this.getId(), calItemId, dismissedAt);
        boolean success = false;
        try {
            this.beginTransaction("setLastAlarm", octxt, redoRecorder);
            CalendarItem calItem = this.getCalendarItemById(octxt, calItemId);
            if (calItem == null) {
                throw MailServiceException.NO_SUCH_CALITEM(calItemId);
            }
            calItem.snapshotRevision();
            calItem.updateNextAlarm(dismissedAt + 1L);
            this.markItemModified(calItem, 131072);
            success = true;
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized CalendarItem setCalendarItem(OperationContext octxt, int folderId, int flags, long tags, SetCalendarItemData defaultInv, SetCalendarItemData[] exceptions, List<CalendarItem.ReplyInfo> replies, long nextAlarm) throws ServiceException {
        CalendarItem calendarItem;
        boolean success;
        block21: {
            CalendarItem calendarItem2;
            block20: {
                SetCalendarItem redoRecorder = new SetCalendarItem(this.getId(), this.attachmentsIndexingEnabled(), flags &= ~Flag.FLAG_SYSTEM, tags);
                success = false;
                try {
                    this.beginTransaction("setCalendarItem", octxt, redoRecorder);
                    SetCalendarItem redoPlayer = octxt == null ? null : (SetCalendarItem)octxt.getPlayer();
                    int scidLen = (defaultInv != null ? 1 : 0) + (exceptions != null ? exceptions.length : 0);
                    ArrayList<SetCalendarItemData> scidList = new ArrayList<SetCalendarItemData>(scidLen);
                    if (defaultInv != null) {
                        scidList.add(defaultInv);
                    }
                    if (exceptions != null) {
                        for (SetCalendarItemData scid : exceptions) {
                            scidList.add(scid);
                        }
                    }
                    CalendarItem calItem = null;
                    if (!scidList.isEmpty()) {
                        Invite currInv;
                        calItem = this.getCalendarItemByUid(((SetCalendarItemData)scidList.get((int)0)).mInv.getUid());
                        for (SetCalendarItemData scid : scidList) {
                            int idBeingSet = scid.mInv.getMailItemId();
                            if (idBeingSet > 0) continue;
                            if (calItem != null) {
                                currInv = calItem.getInvite(scid.mInv.getRecurId());
                                if (currInv != null) {
                                    scid.mInv.setInviteId(currInv.getMailItemId());
                                    boolean currLO = currInv.isLocalOnly();
                                    boolean newLO = scid.mInv.isLocalOnly();
                                    scid.mInv.setLocalOnly(currLO && newLO);
                                    continue;
                                }
                                scid.mInv.setInviteId(this.getNextItemId(-1));
                                continue;
                            }
                            scid.mInv.setInviteId(this.getNextItemId(-1));
                        }
                        if (calItem != null && calItem.getFolderId() != 3) {
                            Invite currSeries = calItem.getDefaultInviteOrNull();
                            for (SetCalendarItemData scid : scidList) {
                                if (scid.mInv.hasFreeBusy()) continue;
                                currInv = calItem.getInvite(scid.mInv.getRecurId());
                                if (currInv == null) {
                                    currInv = currSeries;
                                }
                                if (currInv == null || !currInv.hasFreeBusy()) continue;
                                scid.mInv.setFreeBusy(currInv.getFreeBusy());
                            }
                        }
                    }
                    redoRecorder.setData(defaultInv, exceptions, replies, nextAlarm);
                    boolean first = true;
                    boolean calItemIsNew = true;
                    long oldNextAlarm = 0L;
                    for (SetCalendarItemData scid : scidList) {
                        block22: {
                            block24: {
                                block23: {
                                    if (scid.mPm == null) {
                                        scid.mInv.setDontIndexMimeMessage(true);
                                        String desc = scid.mInv.getDescription();
                                        if (desc != null && desc.length() > Invite.getMaxDescInMeta()) {
                                            MimeMessage mm = CalendarMailSender.createCalendarMessage(scid.mInv);
                                            scid.mPm = new ParsedMessage(mm, octxt == null ? System.currentTimeMillis() : octxt.getTimestamp(), true);
                                        }
                                    }
                                    if (!first) break block22;
                                    first = false;
                                    boolean bl = calItemIsNew = calItem == null;
                                    if (!calItemIsNew) break block23;
                                    String method = scid.mInv.getMethod();
                                    if ("REQUEST".equals(method) || "PUBLISH".equals(method)) {
                                        calItem = this.createCalendarItem(folderId, flags, tags, scid.mInv.getUid(), scid.mPm, scid.mInv, null);
                                        break block24;
                                    } else {
                                        calendarItem2 = null;
                                        Object var26_31 = null;
                                        break block20;
                                    }
                                }
                                calItem.snapshotRevision();
                                CalendarItem.AlarmData alarmData = calItem.getAlarmData();
                                if (alarmData != null) {
                                    oldNextAlarm = alarmData.getNextAt();
                                }
                                calItem.setTags(flags, tags);
                                calItem.processNewInvite(scid.mPm, scid.mInv, folderId, nextAlarm, false, true);
                            }
                            redoRecorder.setCalendarItemAttrs(calItem.getId(), calItem.getFolderId());
                            continue;
                        }
                        calItem.processNewInvite(scid.mPm, scid.mInv, folderId, nextAlarm, false, false);
                    }
                    if (nextAlarm == 0L) {
                        nextAlarm = oldNextAlarm;
                    }
                    calItem.updateNextAlarm(nextAlarm);
                    if (replies != null) {
                        calItem.setReplies(replies);
                    }
                    this.queueForIndexing(calItem, !calItemIsNew, null);
                    success = true;
                    calendarItem = calItem;
                    break block21;
                }
                catch (Throwable throwable) {
                    Object var26_33 = null;
                    this.endTransaction(success);
                    throw throwable;
                }
            }
            this.endTransaction(success);
            return calendarItem2;
        }
        Object var26_32 = null;
        this.endTransaction(success);
        return calendarItem;
    }

    public int fixAllCalendarItemTZ(OperationContext octxt, long after, TimeZoneFixupRules fixupRules) throws ServiceException {
        int numFixedCalItems = 0;
        int numFixedTZs = 0;
        ZimbraLog.calendar.info("Started: timezone fixup in calendar of mailbox " + this.getId());
        List[] lists = new List[]{this.getItemList(octxt, (byte)11), this.getItemList(octxt, (byte)15)};
        for (List items : lists) {
            for (Object obj : items) {
                CalendarItem calItem;
                long end;
                if (!(obj instanceof CalendarItem) || (end = (calItem = (CalendarItem)obj).getEndTime()) <= after) continue;
                try {
                    int num = this.fixCalendarItemTZ(octxt, calItem.getId(), fixupRules);
                    numFixedTZs += num;
                    if (num <= 0) continue;
                    ++numFixedCalItems;
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.error((Object)("Error fixing calendar item " + calItem.getId() + " in mailbox " + this.getId() + ": " + e.getMessage()), e);
                }
            }
        }
        ZimbraLog.calendar.info("Finished: timezone fixup in calendar of mailbox " + this.getId() + "; fixed " + numFixedTZs + " timezone entries in " + numFixedCalItems + " calendar items");
        return numFixedCalItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int fixCalendarItemTZ(OperationContext octxt, int calItemId, TimeZoneFixupRules fixupRules) throws ServiceException {
        int n;
        FixCalendarItemTZ redoRecorder = new FixCalendarItemTZ(this.getId(), calItemId);
        boolean success = false;
        try {
            this.beginTransaction("fixCalendarItemTimeZone2", octxt, redoRecorder);
            CalendarItem calItem = this.getCalendarItemById(octxt, calItemId);
            HashMap<String, ICalTimeZone> replaced = new HashMap<String, ICalTimeZone>();
            int numFixed = fixupRules.fixCalendarItem(calItem, replaced);
            if (numFixed > 0) {
                ZimbraLog.calendar.info("Fixed " + numFixed + " timezone entries in calendar item " + calItem.getId());
                redoRecorder.setReplacementMap(replaced);
                calItem.snapshotRevision();
                calItem.saveMetadata();
                this.uncacheItem(calItemId);
                calItem = this.getCalendarItemById(octxt, calItemId);
                this.markItemModified(calItem, 196608);
                success = true;
                CalendarItem.Callback cb = calItem.getCallback();
                if (cb != null) {
                    cb.modified(calItem);
                }
            }
            n = numFixed;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return n;
    }

    public int fixAllCalendarItemEndTime(OperationContext octxt) throws ServiceException {
        int numFixed = 0;
        ZimbraLog.calendar.info("Started: end time fixup in calendar of mailbox " + this.getId());
        List[] lists = new List[]{this.getItemList(octxt, (byte)11), this.getItemList(octxt, (byte)15)};
        for (List items : lists) {
            for (Object obj : items) {
                if (!(obj instanceof CalendarItem)) continue;
                CalendarItem calItem = (CalendarItem)obj;
                try {
                    numFixed += this.fixCalendarItemEndTime(octxt, calItem);
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.error((Object)("Error fixing calendar item " + calItem.getId() + " in mailbox " + this.getId() + ": " + e.getMessage()), e);
                }
            }
        }
        ZimbraLog.calendar.info("Finished: end time fixup in calendar of mailbox " + this.getId() + "; fixed " + numFixed + " timezone entries");
        return numFixed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int fixCalendarItemEndTime(OperationContext octxt, CalendarItem calItem) throws ServiceException {
        int n;
        FixCalendarItemEndTime redoRecorder = new FixCalendarItemEndTime(this.getId(), calItem.getId());
        boolean success = false;
        try {
            this.beginTransaction("fixupCalendarItemEndTime", octxt, redoRecorder);
            int numFixed = calItem.fixRecurrenceEndTime();
            if (numFixed > 0) {
                ZimbraLog.calendar.info("Fixed calendar item " + calItem.getId());
                calItem.snapshotRevision();
                calItem.saveMetadata();
                this.markItemModified(calItem, 196608);
                success = true;
            }
            n = numFixed;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return n;
    }

    public int[] addInvite(OperationContext octxt, Invite inv, int folderId) throws ServiceException {
        this.mIndexHelper.maybeIndexDeferredItems();
        boolean addRevision = true;
        return this.addInvite(octxt, inv, folderId, null, false, false, addRevision);
    }

    public int[] addInvite(OperationContext octxt, Invite inv, int folderId, ParsedMessage pm) throws ServiceException {
        this.mIndexHelper.maybeIndexDeferredItems();
        boolean addRevision = true;
        return this.addInvite(octxt, inv, folderId, pm, false, false, addRevision);
    }

    public int[] addInvite(OperationContext octxt, Invite inv, int folderId, boolean preserveExistingAlarms, boolean addRevision) throws ServiceException {
        this.mIndexHelper.maybeIndexDeferredItems();
        return this.addInvite(octxt, inv, folderId, null, preserveExistingAlarms, false, addRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] addInvite(OperationContext octxt, Invite inv, int folderId, ParsedMessage pm, boolean preserveExistingAlarms, boolean discardExistingInvites, boolean addRevision) throws ServiceException {
        if (pm == null) {
            inv.setDontIndexMimeMessage(true);
            String desc = inv.getDescription();
            if (desc != null && desc.length() > Invite.getMaxDescInMeta()) {
                MimeMessage mm = CalendarMailSender.createCalendarMessage(inv);
                pm = new ParsedMessage(mm, octxt == null ? System.currentTimeMillis() : octxt.getTimestamp(), true);
            }
        }
        byte[] data = null;
        try {
            if (pm != null) {
                data = pm.getRawData();
            }
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("Caught IOException", ioe);
        }
        CreateInvite redoRecorder = new CreateInvite(this.mId, inv, folderId, data, preserveExistingAlarms, discardExistingInvites, addRevision);
        Mailbox mailbox = this;
        synchronized (mailbox) {
            int[] nArray;
            boolean success;
            block20: {
                block19: {
                    int[] nArray2;
                    block18: {
                        success = false;
                        try {
                            boolean processed;
                            CalendarItem calItem;
                            boolean calItemIsNew;
                            block22: {
                                Invite currInv;
                                block21: {
                                    CreateInvite redoPlayer;
                                    this.beginTransaction("addInvite", octxt, redoRecorder);
                                    CreateInvite createInvite = redoPlayer = octxt == null ? null : (CreateInvite)octxt.getPlayer();
                                    if (redoPlayer == null || redoPlayer.getCalendarItemId() == 0) {
                                        int currId = inv.getMailItemId();
                                        if (currId <= 0) {
                                            currId = -1;
                                        }
                                        inv.setInviteId(this.getNextItemId(currId));
                                    }
                                    calItemIsNew = false;
                                    calItem = this.getCalendarItemByUid(inv.getUid());
                                    processed = true;
                                    if (calItem != null) break block21;
                                    if (inv.getMethod().equals("REQUEST") || inv.getMethod().equals("PUBLISH")) {
                                        calItem = this.createCalendarItem(folderId, 0, 0L, inv.getUid(), pm, inv, null);
                                        calItemIsNew = true;
                                        break block22;
                                    } else {
                                        nArray2 = null;
                                        Object var18_19 = null;
                                        break block18;
                                    }
                                }
                                if (!this.checkItemChangeID(calItem)) {
                                    throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
                                }
                                if ((inv.getMethod().equals("REQUEST") || inv.getMethod().equals("PUBLISH")) && (currInv = calItem.getInvite(inv.getRecurId())) != null) {
                                    inv.setInviteId(currInv.getMailItemId());
                                }
                                if (addRevision) {
                                    calItem.snapshotRevision();
                                }
                                processed = calItem.processNewInvite(pm, inv, folderId, 0L, preserveExistingAlarms, discardExistingInvites);
                            }
                            this.queueForIndexing(calItem, !calItemIsNew, null);
                            redoRecorder.setCalendarItemAttrs(calItem.getId(), calItem.getFolderId());
                            success = true;
                            if (processed) {
                                nArray = new int[]{calItem.getId(), inv.getMailItemId()};
                                break block19;
                            }
                            nArray = null;
                            break block20;
                        }
                        catch (Throwable throwable) {
                            Object var18_22 = null;
                            this.endTransaction(success);
                            throw throwable;
                        }
                    }
                    this.endTransaction(success);
                    return nArray2;
                }
                Object var18_20 = null;
                this.endTransaction(success);
                return nArray;
            }
            Object var18_21 = null;
            this.endTransaction(success);
            return nArray;
        }
    }

    public synchronized CalendarItem getCalendarItemByUid(String uid) throws ServiceException {
        return this.getCalendarItemByUid(null, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CalendarItem getCalendarItemByUid(OperationContext octxt, String uid) throws ServiceException {
        CalendarItem calendarItem;
        boolean success = false;
        try {
            this.beginTransaction("getCalendarItemByUid", octxt);
            MailItem.UnderlyingData data = DbMailItem.getCalendarItem(this, uid);
            CalendarItem calItem = (CalendarItem)this.getItem(data);
            success = true;
            calendarItem = calItem;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return calendarItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, CalendarItem> getCalendarItemsByUid(OperationContext octxt, List<String> uids) throws ServiceException {
        HashMap<String, CalendarItem> hashMap;
        boolean success = false;
        try {
            this.beginTransaction("getCalendarItemsByUid", octxt);
            ArrayList<String> uidList = new ArrayList<String>(uids);
            HashMap<String, CalendarItem> calItems = new HashMap<String, CalendarItem>();
            List<MailItem.UnderlyingData> invData = DbMailItem.getCalendarItems(this, uids);
            for (MailItem.UnderlyingData data : invData) {
                try {
                    CalendarItem calItem = this.getCalendarItem(data);
                    calItems.put(calItem.getUid(), calItem);
                    uidList.remove(calItem.getUid());
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)("Error while retrieving calendar item " + data.id + " in mailbox " + this.mId + "; skipping item"), e);
                }
            }
            success = true;
            for (String missingUid : uidList) {
                calItems.put(missingUid, null);
            }
            hashMap = calItems;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return hashMap;
    }

    private boolean dedupe(MimeMessage mm, Integer sentMsgId) throws ServiceException {
        Account acct = this.getAccount();
        String pref = acct.getAttr("zimbraPrefDedupeMessagesSentToSelf", null);
        if (pref == null) {
            return false;
        }
        if (pref.equalsIgnoreCase(DEDUPE_ALL)) {
            return true;
        }
        if (pref.equalsIgnoreCase(DEDUPE_SECOND)) {
            try {
                return !AccountUtil.isDirectRecipient(acct, mm);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (pref.equalsIgnoreCase(DEDUPE_INBOX)) {
            return false;
        }
        return false;
    }

    public int getConversationIdFromReferent(MimeMessage newMsg, int parentID) {
        block3: {
            try {
                Message parentMsg = this.getMessageById(null, parentID);
                if (parentMsg.getNormalizedSubject().equals(ParsedMessage.normalize(Mime.getSubject(newMsg)))) {
                    return parentMsg.getConversationId();
                }
            }
            catch (Exception e) {
                if (e instanceof MailServiceException.NoSuchItemException) break block3;
                ZimbraLog.mailbox.warn((Object)("ignoring error while checking conversation: " + parentID), e);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void processICalReply(OperationContext octxt, Invite inv) throws ServiceException {
        boolean success;
        block4: {
            block3: {
                ICalReply redoRecorder = new ICalReply(this.getId(), inv);
                success = false;
                try {
                    this.beginTransaction("iCalReply", octxt, redoRecorder);
                    String uid = inv.getUid();
                    CalendarItem calItem = this.getCalendarItemByUid(uid);
                    if (calItem == null) {
                        ZimbraLog.calendar.warn("Unknown calendar item UID " + uid + " in mailbox " + this.getId());
                        Object var8_7 = null;
                        break block3;
                    }
                    calItem.snapshotRevision();
                    calItem.processNewInviteReply(inv);
                    success = true;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.endTransaction(success);
                    throw throwable;
                }
            }
            this.endTransaction(success);
            return;
        }
        Object var8_8 = null;
        this.endTransaction(success);
    }

    private AuthToken getAuthToken(OperationContext octxt) throws ServiceException {
        AuthToken authToken;
        AuthToken authToken2 = authToken = octxt == null ? null : octxt.getAuthToken();
        if (authToken == null) {
            Account authuser = octxt == null ? this.getAccount() : octxt.getAuthenticatedUser();
            boolean isAdminRequest = octxt == null ? false : octxt.isUsingAdminPrivileges();
            authToken = AuthProvider.getAuthToken(authuser, isAdminRequest);
        }
        return authToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processICalReplies(OperationContext octxt, ZCalendar.ZVCalendar cal) throws ServiceException {
        List<Invite> components = Invite.createFromCalendar(this.getAccount(), null, cal, false);
        Iterator<Invite> i$ = components.iterator();
        while (i$.hasNext()) {
            String orgAddress;
            Invite inv = i$.next();
            if (inv.hasOrganizer()) {
                ZOrganizer org = inv.getOrganizer();
                orgAddress = org.getAddress();
            } else {
                ZimbraLog.calendar.warn("No ORGANIZER found in REPLY.  Assuming current mailbox.");
                orgAddress = this.getAccount().getName();
            }
            if (AccountUtil.addressMatchesAccount(this.getAccount(), orgAddress)) {
                this.processICalReply(octxt, inv);
                continue;
            }
            Account orgAccount = inv.getOrganizerAccount();
            if (orgAccount == null) {
                ZimbraLog.calendar.warn("Unknown organizer " + orgAddress + " in REPLY");
                continue;
            }
            if (Provisioning.onLocalServer(orgAccount)) {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(orgAccount);
                OperationContext orgOctxt = new OperationContext(mbox);
                mbox.processICalReply(orgOctxt, inv);
                continue;
            }
            String uri = AccountUtil.getSoapUri(orgAccount);
            if (uri == null) {
                ZimbraLog.calendar.warn("Unable to determine URI for organizer account " + orgAddress);
                continue;
            }
            try {
                String ical;
                block13: {
                    Object var12_14;
                    StringWriter sr = null;
                    try {
                        sr = new StringWriter();
                        inv.newToICalendar(true).toICalendar(sr);
                        ical = sr.toString();
                        var12_14 = null;
                        if (sr == null) break block13;
                    }
                    catch (Throwable throwable) {
                        var12_14 = null;
                        if (sr != null) {
                            sr.close();
                        }
                        throw throwable;
                    }
                    sr.close();
                }
                ZMailbox.Options options = new ZMailbox.Options();
                options.setAuthToken(this.getAuthToken(octxt).toZAuthToken());
                options.setTargetAccount(orgAccount.getName());
                options.setTargetAccountBy(Provisioning.AccountBy.name);
                options.setUri(uri);
                options.setNoSession(true);
                ZMailbox zmbox = ZMailbox.getMailbox(options);
                zmbox.iCalReply(ical);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("Error while posting REPLY to organizer mailbox host", e);
            }
        }
        return;
    }

    public Message addMessage(OperationContext octxt, ParsedMessage pm, DeliveryOptions dopt) throws IOException, ServiceException {
        return this.addMessage(octxt, pm, dopt.getFolderId(), dopt.getNoICal(), dopt.getFlags(), dopt.getTagString(), dopt.getConversationId(), dopt.getRecipientEmail(), dopt.getCustomMetadata(), null);
    }

    public Message addMessage(OperationContext octxt, InputStream in, int sizeHint, Long receivedDate, DeliveryOptions dopt) throws IOException, ServiceException {
        return this.addMessage(octxt, in, sizeHint, receivedDate, dopt.getFolderId(), dopt.getNoICal(), dopt.getFlags(), dopt.getTagString(), dopt.getConversationId(), dopt.getRecipientEmail(), dopt.getCustomMetadata(), null);
    }

    public Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, boolean noICal, int flags, String tags, int conversationId) throws IOException, ServiceException {
        DeliveryContext dctxt = new DeliveryContext();
        return this.addMessage(octxt, pm, folderId, noICal, flags, tags, conversationId, ":API:", null, dctxt);
    }

    public Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, boolean noICal, int flags, String tags) throws IOException, ServiceException {
        DeliveryContext dctxt = new DeliveryContext();
        return this.addMessage(octxt, pm, folderId, noICal, flags, tags, -1, ":API:", null, dctxt);
    }

    public Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, boolean noICal, int flags, String tags, String rcptEmail, DeliveryContext dctxt) throws IOException, ServiceException {
        return this.addMessage(octxt, pm, folderId, noICal, flags, tags, -1, rcptEmail, null, dctxt);
    }

    public Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, boolean noICal, int flags, String tags, String rcptEmail, MailItem.CustomMetadata customData, DeliveryContext dctxt) throws IOException, ServiceException {
        return this.addMessage(octxt, pm, folderId, noICal, flags, tags, -1, rcptEmail, customData, dctxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message addMessage(OperationContext octxt, InputStream in, int sizeHint, Long receivedDate, int folderId, boolean noIcal, int flags, String tagStr, int conversationId, String rcptEmail, MailItem.CustomMetadata customData, DeliveryContext dctxt) throws IOException, ServiceException {
        Message message;
        int bufLen = Provisioning.getInstance().getLocalServer().getMailDiskStreamingThreshold();
        CopyInputStream cs = new CopyInputStream(in, sizeHint, bufLen, bufLen);
        Blob blob = null;
        try {
            BufferStream bs = cs.getBufferStream();
            ParsedMessage pm = null;
            blob = StoreManager.getInstance().storeIncoming(cs, sizeHint, null);
            pm = new ParsedMessage(new ParsedMessageOptions(blob, bs.isPartial() ? null : bs.getBuffer(), receivedDate, this.attachmentsIndexingEnabled()));
            cs.release();
            if (dctxt == null) {
                dctxt = new DeliveryContext();
            }
            dctxt.setIncomingBlob(blob);
            message = this.addMessage(octxt, pm, folderId, noIcal, flags, tagStr, conversationId, rcptEmail, customData, dctxt);
            Object var20_19 = null;
            cs.release();
            StoreManager.getInstance().quietDelete(blob);
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            cs.release();
            StoreManager.getInstance().quietDelete(blob);
            throw throwable;
        }
        return message;
    }

    public Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, boolean noICal, int flags, String tagStr, int conversationId, String rcptEmail, MailItem.CustomMetadata customData, DeliveryContext dctxt) throws IOException, ServiceException {
        return this.addMessage(octxt, pm, folderId, noICal, flags, tagStr, conversationId, rcptEmail, null, customData, dctxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, boolean noICal, int flags, String tagStr, int conversationId, String rcptEmail, Message.DraftInfo dinfo, MailItem.CustomMetadata customData, DeliveryContext dctxt) throws IOException, ServiceException {
        Message msg;
        StagedBlob staged;
        StoreManager sm;
        long start;
        block12: {
            this.mIndexHelper.maybeIndexDeferredItems();
            if (this.indexImmediately()) {
                pm.analyzeFully();
            }
            start = ZimbraPerf.STOPWATCH_MBOX_ADD_MSG.start();
            if (!noICal) {
                try {
                    ParsedMessage.CalendarPartInfo cpi = pm.getCalendarPartInfo();
                    if (cpi != null && CalendarItem.isAcceptableInvite(this.getAccount(), cpi) && ZCalendar.ICalTok.REPLY.equals((Object)cpi.method)) {
                        this.processICalReplies(octxt, cpi.cal);
                        noICal = true;
                    }
                }
                catch (Exception e) {
                    ZimbraLog.calendar.warn((Object)"Error during calendar processing.  Continuing with message add", e);
                }
            }
            if (dctxt == null) {
                dctxt = new DeliveryContext();
            }
            sm = StoreManager.getInstance();
            Blob blob = dctxt.getIncomingBlob();
            boolean deleteIncoming = false;
            if (blob == null) {
                InputStream in = null;
                try {
                    int size = pm.getRawSize();
                    in = pm.getRawInputStream();
                    blob = sm.storeIncoming(in, size, null);
                    Object var20_20 = null;
                }
                catch (Throwable throwable) {
                    Object var20_21 = null;
                    ByteUtil.closeStream(in);
                    throw throwable;
                }
                ByteUtil.closeStream(in);
                dctxt.setIncomingBlob(blob);
                deleteIncoming = true;
            }
            staged = sm.stage(blob, this);
            msg = null;
            try {
                msg = this.addMessageInternal(octxt, pm, folderId, noICal, flags, tagStr, conversationId, rcptEmail, dinfo, customData, dctxt, staged);
                Object var22_23 = null;
                if (!deleteIncoming) break block12;
                sm.quietDelete(dctxt.getIncomingBlob());
            }
            catch (Throwable throwable) {
                Object var22_24 = null;
                if (deleteIncoming) {
                    sm.quietDelete(dctxt.getIncomingBlob());
                }
                sm.quietDelete(staged);
                throw throwable;
            }
            {
            }
        }
        sm.quietDelete(staged);
        ZimbraPerf.STOPWATCH_MBOX_ADD_MSG.stop(start);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Message addMessageInternal(OperationContext octxt, ParsedMessage pm, int folderId, boolean noICal, int flags, String tagStr, int conversationId, String rcptEmail, Message.DraftInfo dinfo, MailItem.CustomMetadata customData, DeliveryContext dctxt, StagedBlob staged) throws IOException, ServiceException {
        boolean success;
        Message msg;
        boolean checkDuplicates;
        boolean isSent;
        String msgidHeader;
        block60: {
            RedoableOp storeRedoRecorder;
            block61: {
                int msgSize;
                String digest;
                if (pm == null) {
                    throw ServiceException.INVALID_REQUEST("null ParsedMessage when adding message to mailbox " + this.mId, null);
                }
                boolean debug = ZimbraLog.mailbox.isDebugEnabled();
                if (conversationId <= 16) {
                    conversationId = -1;
                }
                boolean needRedo = octxt == null || octxt.needRedo();
                CreateMessage redoPlayer = octxt == null ? null : (CreateMessage)octxt.getPlayer();
                boolean isRedo = redoPlayer != null;
                Blob blob = dctxt.getIncomingBlob();
                if (blob == null) {
                    throw ServiceException.FAILURE("Incoming blob not found.", null);
                }
                msgidHeader = pm.getMessageID();
                isSent = (flags & Flag.BITMASK_FROM_ME) != 0;
                boolean bl = checkDuplicates = !isRedo && msgidHeader != null;
                if (checkDuplicates && !isSent && this.mSentMessageIDs.containsKey((Object)msgidHeader)) {
                    Integer sentMsgID = (Integer)this.mSentMessageIDs.get((Object)msgidHeader);
                    ParsedMessage.CalendarPartInfo cpi = pm.getCalendarPartInfo();
                    if ((cpi == null || !CalendarItem.isAcceptableInvite(this.getAccount(), cpi)) && this.dedupe(pm.getMimeMessage(), sentMsgID)) {
                        ZimbraLog.mailbox.info("Not delivering message with Message-ID %s because it is a duplicate of sent message %d.", msgidHeader, sentMsgID);
                        return null;
                    }
                    if (conversationId == -1) {
                        conversationId = this.getConversationIdFromReferent(pm.getMimeMessage(), sentMsgID);
                        if (debug) {
                            ZimbraLog.mailbox.debug("  duplicate detected but not deduped (" + msgidHeader + "); " + "will try to slot into conversation " + conversationId);
                        }
                    }
                }
                flags &= ~Flag.FLAG_SYSTEM | Flag.BITMASK_DRAFT | Flag.BITMASK_FROM_ME;
                flags &= Flag.FLAGS_GENERIC | Flag.FLAGS_MESSAGE;
                try {
                    digest = pm.getRawDigest();
                    msgSize = pm.getRawSize();
                }
                catch (IOException e) {
                    throw ServiceException.FAILURE("Unable to get message properties.", e);
                }
                CreateMessage redoRecorder = new CreateMessage(this.mId, rcptEmail, pm.getReceivedDate(), dctxt.getShared(), digest, msgSize, folderId, noICal, flags, tagStr, customData);
                storeRedoRecorder = null;
                boolean unread = (flags & Flag.BITMASK_UNREAD) > 0;
                flags &= ~Flag.BITMASK_UNREAD;
                flags = pm.hasAttachments() ? (flags |= Flag.BITMASK_ATTACHED) : (flags &= ~Flag.BITMASK_ATTACHED);
                flags &= ~(Flag.BITMASK_HIGH_PRIORITY | Flag.BITMASK_LOW_PRIORITY);
                boolean isSpam = folderId == 4;
                boolean isDraft = ((flags |= pm.getPriorityBitmask()) & Flag.BITMASK_DRAFT) != 0;
                msg = null;
                success = false;
                boolean deferIndexing = !this.indexImmediately() || pm.hasTemporaryAnalysisFailure();
                MailItem.CustomMetadata.CustomMetadataList extended = MetadataCallback.preDelivery(pm);
                if (customData != null) {
                    if (extended == null) {
                        extended = customData.asList();
                    } else {
                        extended.addSection(customData);
                    }
                }
                try {
                    Conversation convTarget;
                    String hash;
                    Conversation conv;
                    int messageId;
                    long tags;
                    Folder folder;
                    block58: {
                        this.beginTransaction("addMessage", octxt, redoRecorder);
                        if (isRedo) {
                            rcptEmail = redoPlayer.getRcptEmail();
                        }
                        folder = this.getFolderById(folderId);
                        String subject = pm.getNormalizedSubject();
                        tags = Tag.tagsToBitmask(tagStr);
                        messageId = this.getNextItemId(!isRedo ? -1 : redoPlayer.getMessageId());
                        if (isRedo) {
                            conversationId = redoPlayer.getConvId();
                        }
                        conv = null;
                        hash = null;
                        if (!DebugConfig.disableConversation) {
                            if (conversationId != -1) {
                                try {
                                    conv = this.getConversationById(conversationId);
                                    if (debug) {
                                        ZimbraLog.mailbox.debug("  fetched explicitly-specified conversation " + conv.getId());
                                    }
                                    break block58;
                                }
                                catch (ServiceException e) {
                                    if (e.getCode() != "mail.NO_SUCH_CONV") {
                                        throw e;
                                    }
                                    if (debug) {
                                        ZimbraLog.mailbox.debug("  could not find explicitly-specified conversation " + conversationId);
                                    }
                                    break block58;
                                }
                            }
                            if (!isRedo && !isSpam && !isDraft && pm.isReply()) {
                                hash = Mailbox.getHash(subject);
                                conv = this.getConversationByHash(hash);
                                if (debug) {
                                    ZimbraLog.mailbox.debug("  found conversation " + (conv == null ? -1 : conv.getId()) + " for hash: " + hash);
                                }
                                if (conv != null && pm.getReceivedDate() > conv.getDate() + 2678400000L) {
                                    conv = null;
                                    if (debug) {
                                        ZimbraLog.mailbox.debug("  but rejected it because it's too old");
                                    }
                                }
                            }
                        }
                    }
                    Conversation conversation = convTarget = conv instanceof VirtualConversation ? null : conv;
                    if (convTarget != null && debug) {
                        ZimbraLog.mailbox.debug("  placing message in existing conversation " + convTarget.getId());
                    }
                    ParsedMessage.CalendarPartInfo cpi = pm.getCalendarPartInfo();
                    ZCalendar.ZVCalendar iCal = null;
                    if (cpi != null && CalendarItem.isAcceptableInvite(this.getAccount(), cpi)) {
                        iCal = cpi.cal;
                    }
                    msg = Message.create(messageId, folder, convTarget, pm, staged, unread, flags, tags, dinfo, noICal, iCal, extended);
                    redoRecorder.setMessageId(msg.getId());
                    if (!DebugConfig.disableConversation && convTarget == null) {
                        if (conv == null && conversationId == -1) {
                            conv = VirtualConversation.create(this, msg);
                            if (debug) {
                                ZimbraLog.mailbox.debug("  placed message " + msg.getId() + " in vconv " + conv.getId());
                            }
                            redoRecorder.setConvFirstMsgId(-1);
                        } else {
                            Message[] contents = null;
                            VirtualConversation vconv = null;
                            if (!isRedo) {
                                Message[] messageArray;
                                vconv = (VirtualConversation)conv;
                                if (conv == null) {
                                    Message[] messageArray2 = new Message[1];
                                    messageArray = messageArray2;
                                    messageArray2[0] = msg;
                                } else {
                                    Message[] messageArray3 = new Message[2];
                                    messageArray3[0] = vconv.getMessage();
                                    messageArray = messageArray3;
                                    messageArray3[1] = msg;
                                }
                                contents = messageArray;
                            } else {
                                int convFirstMsgId = redoPlayer.getConvFirstMsgId();
                                Message convFirstMsg = null;
                                if (convFirstMsgId > 0) {
                                    block59: {
                                        try {
                                            convFirstMsg = this.getMessageById(octxt, redoPlayer.getConvFirstMsgId());
                                        }
                                        catch (MailServiceException e) {
                                            if ("mail.NO_SUCH_MSG".equals(e.getCode())) break block59;
                                            throw e;
                                        }
                                    }
                                    if (convFirstMsg != null && convFirstMsg.getConversationId() < 0) {
                                        contents = new Message[]{convFirstMsg, msg};
                                        vconv = new VirtualConversation(this, convFirstMsg);
                                    }
                                }
                                if (contents == null) {
                                    contents = new Message[]{msg};
                                }
                            }
                            redoRecorder.setConvFirstMsgId(vconv != null ? vconv.getMessageId() : -1);
                            conv = this.createConversation(contents, conversationId);
                            if (vconv != null) {
                                if (debug) {
                                    ZimbraLog.mailbox.debug("  removed vconv " + vconv.getId());
                                }
                                vconv.removeChild(vconv.getMessage());
                            }
                        }
                        if (!isSpam && !isDraft) {
                            this.openConversation(conv, hash);
                        }
                    } else {
                        redoRecorder.setConvFirstMsgId(-1);
                    }
                    redoRecorder.setConvId(conv != null && !(conv instanceof VirtualConversation) ? conv.getId() : -1);
                    if (dctxt.getShared()) {
                        if (dctxt.isFirst() && needRedo) {
                            storeRedoRecorder = new StoreIncomingBlob(digest, msgSize, dctxt.getMailboxIdList());
                            storeRedoRecorder.start(this.getOperationTimestampMillis());
                            ((StoreIncomingBlob)storeRedoRecorder).setBlobBodyInfo(blob.getFile());
                            storeRedoRecorder.log();
                        }
                        redoRecorder.setMessageLinkInfo(blob.getPath());
                    } else {
                        redoRecorder.setMessageBodyInfo(blob.getFile());
                    }
                    MailboxBlob mblob = StoreManager.getInstance().link(staged, this, messageId, this.getOperationChangeID());
                    this.markOtherItemDirty(mblob);
                    msg.updateBlobData(mblob);
                    if (dctxt.getMailboxBlob() == null) {
                        dctxt.setMailboxBlob(mblob);
                    }
                    this.queueForIndexing(msg, false, deferIndexing ? null : pm.getLuceneDocuments());
                    success = true;
                    try {
                        Notification.getInstance().interceptIfNecessary(this, pm.getMimeMessage(), "add message", folder);
                    }
                    catch (ServiceException e) {
                        ZimbraLog.mailbox.error((Object)"Unable to send legal intercept message.", e);
                    }
                    Object var48_50 = null;
                    if (storeRedoRecorder == null) break block60;
                    if (!success) break block61;
                }
                catch (Throwable throwable) {
                    Object var48_51 = null;
                    if (storeRedoRecorder != null) {
                        if (success) {
                            storeRedoRecorder.commit();
                        } else {
                            storeRedoRecorder.abort();
                        }
                    }
                    this.endTransaction(success);
                    if (success) {
                        dctxt.setFirst(false);
                    }
                    throw throwable;
                }
                storeRedoRecorder.commit();
                break block60;
            }
            storeRedoRecorder.abort();
        }
        this.endTransaction(success);
        if (success) {
            dctxt.setFirst(false);
        }
        if (isSent && checkDuplicates) {
            this.mSentMessageIDs.put((Object)msgidHeader, (Object)new Integer(msg.getId()));
        }
        return msg;
    }

    public static String getHash(String subject) {
        if (subject == null) {
            subject = "";
        }
        try {
            return ByteUtil.getSHA1Digest(subject.getBytes("utf-8"), true);
        }
        catch (UnsupportedEncodingException uee) {
            return ByteUtil.getSHA1Digest(subject.getBytes(), true);
        }
    }

    void openConversation(Conversation conv, String hash) throws ServiceException {
        if (hash == null) {
            hash = Mailbox.getHash(conv.getNormalizedSubject());
        }
        conv.open(hash);
        this.markOtherItemDirty(hash);
        this.mConvHashes.put((Object)hash, (Object)new Integer(conv.getId()));
    }

    void closeConversation(Conversation conv, String hash) throws ServiceException {
        if (hash == null) {
            hash = Mailbox.getHash(conv.getSubject());
        }
        conv.close(hash);
        this.mConvHashes.remove((Object)hash);
    }

    Conversation createConversation(Message[] contents, int id) throws ServiceException {
        id = Math.max(id, -1);
        Conversation conv = Conversation.create(this, this.getNextItemId(id), contents);
        if (ZimbraLog.mailbox.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < contents.length; ++i) {
                sb.append(i == 0 ? "" : ",").append(contents[i].getId());
            }
            ZimbraLog.mailbox.debug("  created conv " + conv.getId() + " holding msg(s): " + sb);
        }
        return conv;
    }

    public Message saveDraft(OperationContext octxt, ParsedMessage pm, int id) throws IOException, ServiceException {
        return this.saveDraft(octxt, pm, id, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message saveDraft(OperationContext octxt, ParsedMessage pm, int id, String origId, String replyType, String identityId, String accountId) throws IOException, ServiceException {
        StagedBlob staged;
        if (id == -1) {
            Message.DraftInfo dinfo = null;
            if (!(replyType != null && origId != null || identityId != null && !identityId.equals(""))) {
                if (accountId == null) return this.addMessage(octxt, pm, 6, true, Flag.BITMASK_DRAFT | Flag.BITMASK_FROM_ME, null, -1, ":API:", dinfo, null, null);
                if (accountId.equals("")) return this.addMessage(octxt, pm, 6, true, Flag.BITMASK_DRAFT | Flag.BITMASK_FROM_ME, null, -1, ":API:", dinfo, null, null);
            }
            dinfo = new Message.DraftInfo(replyType, origId, identityId, accountId);
            return this.addMessage(octxt, pm, 6, true, Flag.BITMASK_DRAFT | Flag.BITMASK_FROM_ME, null, -1, ":API:", dinfo, null, null);
        }
        this.mIndexHelper.maybeIndexDeferredItems();
        if (this.indexImmediately()) {
            pm.analyzeFully();
        }
        String digest = pm.getRawDigest();
        int size = pm.getRawSize();
        boolean deferIndexing = !this.indexImmediately() || pm.hasTemporaryAnalysisFailure();
        StoreManager sm = StoreManager.getInstance();
        InputStream is = pm.getRawInputStream();
        try {
            staged = sm.stage(is, size, null, this);
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        Mailbox mailbox = this;
        synchronized (mailbox) {
            Message message;
            SaveDraft redoRecorder = new SaveDraft(this.mId, id, digest, size);
            InputStream redoStream = null;
            boolean success = false;
            try {
                this.beginTransaction("saveDraft", octxt, redoRecorder);
                SaveDraft redoPlayer = (SaveDraft)this.mCurrentChange.getRedoPlayer();
                Message msg = this.getMessageById(id);
                if (!msg.isTagged(-7)) {
                    throw MailServiceException.IMMUTABLE_OBJECT(id);
                }
                if (!this.checkItemChangeID(msg)) {
                    throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
                }
                int imapID = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getImapId());
                redoRecorder.setImapId(imapID);
                redoRecorder.setMessageBodyInfo(new ParsedMessageDataSource(pm), size);
                msg.setContent(staged, pm);
                this.queueForIndexing(msg, true, deferIndexing ? null : pm.getLuceneDocuments());
                success = true;
                try {
                    Notification.getInstance().interceptIfNecessary(this, pm.getMimeMessage(), "save draft", msg.getFolder());
                }
                catch (ServiceException e) {
                    ZimbraLog.mailbox.error((Object)"Unable to send lawful intercept message.", e);
                }
                message = msg;
                Object var23_26 = null;
            }
            catch (Throwable throwable) {
                Object var23_27 = null;
                this.endTransaction(success);
                ByteUtil.closeStream(redoStream);
                sm.quietDelete(staged);
                throw throwable;
            }
            this.endTransaction(success);
            ByteUtil.closeStream(redoStream);
            sm.quietDelete(staged);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifyPartStat(OperationContext octxt, int calItemId, RecurId recurId, String cnStr, String addressStr, String cutypeStr, String roleStr, String partStatStr, Boolean rsvp, int seqNo, long dtStamp) throws ServiceException {
        ModifyInvitePartStat redoRecorder = new ModifyInvitePartStat(this.mId, calItemId, recurId, cnStr, addressStr, cutypeStr, roleStr, partStatStr, rsvp, seqNo, dtStamp);
        boolean success = false;
        try {
            this.beginTransaction("updateInvitePartStat", octxt, redoRecorder);
            CalendarItem calItem = this.getCalendarItemById(calItemId);
            Account acct = this.getAccount();
            calItem.modifyPartStat(acct, recurId, cnStr, addressStr, cutypeStr, roleStr, partStatStr, rsvp, seqNo, dtStamp);
            this.markItemModified(calItem, 131072);
            success = true;
            Object var18_16 = null;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Integer> resetImapUid(OperationContext octxt, List<Integer> itemIds) throws ServiceException {
        ArrayList<Integer> arrayList;
        SetImapUid redoRecorder = new SetImapUid(this.mId, itemIds);
        ArrayList<Integer> newIds = new ArrayList<Integer>();
        boolean success = false;
        try {
            this.beginTransaction("resetImapUid", octxt, redoRecorder);
            SetImapUid redoPlayer = (SetImapUid)this.mCurrentChange.getRedoPlayer();
            for (int id : itemIds) {
                MailItem item = this.getItemById(id, (byte)-1);
                int imapId = redoPlayer == null ? -1 : redoPlayer.getImapUid(id);
                item.setImapUid(this.getNextItemId(imapId));
                redoRecorder.setImapUid(item.getId(), item.getImapUid());
                newIds.add(item.getImapUid());
            }
            success = true;
            arrayList = newIds;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return arrayList;
    }

    public synchronized void setColor(OperationContext octxt, int itemId, byte type, byte color) throws ServiceException {
        this.setColor(octxt, new int[]{itemId}, type, color);
    }

    public synchronized void setColor(OperationContext octxt, int[] itemIds, byte type, byte color) throws ServiceException {
        this.setColor(octxt, itemIds, type, new MailItem.Color(color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColor(OperationContext octxt, int[] itemIds, byte type, MailItem.Color color) throws ServiceException {
        ColorItem redoRecorder = new ColorItem(this.mId, itemIds, type, color);
        boolean success = false;
        try {
            MailItem[] items;
            this.beginTransaction("setColor", octxt, redoRecorder);
            for (MailItem item : items = this.getItemById(itemIds, type)) {
                if (this.checkItemChangeID(item)) continue;
                throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
            }
            for (MailItem item : items) {
                item.setColor(color);
            }
            success = true;
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCustomData(OperationContext octxt, int itemId, byte type, MailItem.CustomMetadata custom) throws ServiceException {
        String key = custom.getSectionKey();
        if (MetadataCallback.isSectionRegistered(key)) {
            throw ServiceException.PERM_DENIED("custom metadata section '" + key + "' may only be calculated, not set");
        }
        SetCustomData redoRecorder = new SetCustomData(this.mId, itemId, type, custom);
        boolean success = false;
        try {
            this.beginTransaction("setCustomData", octxt, redoRecorder);
            MailItem item = this.checkAccess(this.getItemById(itemId, type));
            if (!this.checkItemChangeID(item)) {
                throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
            }
            item.setCustomData(custom);
            success = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDate(OperationContext octxt, int itemId, byte type, long date) throws ServiceException {
        DateItem redoRecorder = new DateItem(this.mId, itemId, type, date);
        boolean success = false;
        try {
            this.beginTransaction("setDate", octxt, redoRecorder);
            MailItem item = this.getItemById(itemId, type);
            if (!this.checkItemChangeID(item)) {
                throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
            }
            item.setDate(date);
            success = true;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized void alterTag(OperationContext octxt, int itemId, byte type, int tagId, boolean addTag) throws ServiceException {
        this.alterTag(octxt, new int[]{itemId}, type, tagId, addTag, null);
    }

    public synchronized void alterTag(OperationContext octxt, int itemId, byte type, int tagId, boolean addTag, MailItem.TargetConstraint tcon) throws ServiceException {
        this.alterTag(octxt, new int[]{itemId}, type, tagId, addTag, tcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void alterTag(OperationContext octxt, int[] itemIds, byte type, int tagId, boolean addTag, MailItem.TargetConstraint tcon) throws ServiceException {
        AlterItemTag redoRecorder = new AlterItemTag(this.mId, itemIds, type, tagId, addTag, tcon);
        boolean success = false;
        try {
            MailItem[] items;
            this.beginTransaction("alterTag", octxt, redoRecorder);
            this.setOperationTargetConstraint(tcon);
            Tag tag = tagId < 0 ? this.getFlagById(tagId) : this.getTagById(tagId);
            for (MailItem item : items = this.getItemById(itemIds, type)) {
                if (item instanceof Conversation || this.checkItemChangeID(item) || !(item instanceof Tag)) continue;
                throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
            }
            for (MailItem item : items) {
                if (item == null) continue;
                if (tagId == -10) {
                    item.alterUnread(addTag);
                    continue;
                }
                item.alterTag(tag, addTag);
            }
            success = true;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized void setTags(OperationContext octxt, int itemId, byte type, int flags, long tags) throws ServiceException {
        this.setTags(octxt, itemId, type, flags, tags, null);
    }

    public synchronized void setTags(OperationContext octxt, int itemId, byte type, String flagStr, String tagIDs, MailItem.TargetConstraint tcon) throws ServiceException {
        int flags = flagStr == null ? Integer.MIN_VALUE : Flag.flagsToBitmask(flagStr);
        long tags = tagIDs == null ? 0x80000000L : Tag.tagsToBitmask(tagIDs);
        this.setTags(octxt, itemId, type, flags, tags, tcon);
    }

    public synchronized void setTags(OperationContext octxt, int[] itemIds, byte type, String flagStr, String tagIDs, MailItem.TargetConstraint tcon) throws ServiceException {
        int flags = flagStr == null ? Integer.MIN_VALUE : Flag.flagsToBitmask(flagStr);
        long tags = tagIDs == null ? 0x80000000L : Tag.tagsToBitmask(tagIDs);
        this.setTags(octxt, itemIds, type, flags, tags, tcon);
    }

    public synchronized void setTags(OperationContext octxt, int itemId, byte type, int flags, long tags, MailItem.TargetConstraint tcon) throws ServiceException {
        this.setTags(octxt, new int[]{itemId}, type, flags, tags, tcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTags(OperationContext octxt, int[] itemIds, byte type, int flags, long tags, MailItem.TargetConstraint tcon) throws ServiceException {
        if (flags == Integer.MIN_VALUE && tags == 0x80000000L) {
            return;
        }
        SetItemTags redoRecorder = new SetItemTags(this.mId, itemIds, type, flags, tags, tcon);
        boolean success = false;
        try {
            MailItem[] items;
            this.beginTransaction("setTags", octxt, redoRecorder);
            this.setOperationTargetConstraint(tcon);
            for (MailItem item : items = this.getItemById(itemIds, type)) {
                this.checkItemChangeID(item);
            }
            Flag unreadFlag = this.getFlagById(-10);
            for (MailItem item : items) {
                if (item == null) continue;
                int iflags = flags;
                long itags = tags;
                if ((iflags & Integer.MIN_VALUE) != 0) {
                    iflags = item.getFlagBitmask();
                }
                if ((itags & 0x80000000L) != 0L) {
                    itags = item.getTagBitmask();
                }
                boolean iunread = (iflags & Flag.BITMASK_UNREAD) > 0;
                item.setTags(iflags &= ~Flag.BITMASK_UNREAD, itags);
                if (!unreadFlag.canTag(item)) continue;
                item.alterUnread(iunread);
            }
            success = true;
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized MailItem copy(OperationContext octxt, int itemId, byte type, int folderId) throws ServiceException {
        return this.copy(octxt, new int[]{itemId}, type, folderId).get(0);
    }

    public synchronized List<MailItem> copy(OperationContext octxt, int[] itemIds, byte type, int folderId) throws ServiceException {
        ArrayList<MailItem> arrayList;
        CopyItem redoRecorder = new CopyItem(this.mId, type, folderId);
        boolean success = false;
        try {
            MailItem[] items;
            this.beginTransaction("copy", octxt, redoRecorder);
            CopyItem redoPlayer = (CopyItem)this.mCurrentChange.getRedoPlayer();
            ArrayList<MailItem> result = new ArrayList<MailItem>();
            Folder folder = this.getFolderById(folderId);
            for (MailItem item : items = this.getItemById(itemIds, type)) {
                this.checkItemChangeID(item);
            }
            for (MailItem item : items) {
                MailItem copy;
                if (item instanceof Conversation) {
                    Conversation conv = (Conversation)item;
                    ArrayList<Message> msgs = new ArrayList<Message>((int)conv.getSize());
                    for (Message original : conv.getMessages()) {
                        if (!original.canAccess((short)1)) continue;
                        int newId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getDestId(original.getId()));
                        Message msg = (Message)original.copy(folder, newId, -1);
                        msgs.add(msg);
                        redoRecorder.setDestId(original.getId(), newId);
                    }
                    if (msgs.isEmpty()) {
                        throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
                    }
                    if (msgs.size() == 1) {
                        copy = ((Message)msgs.get(0)).getParent();
                    } else {
                        int newId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getDestId(conv.getId()));
                        copy = Conversation.create(this, newId, msgs.toArray(new Message[msgs.size()]));
                        redoRecorder.setDestId(conv.getId(), newId);
                    }
                } else {
                    int newId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getDestId(item.getId()));
                    copy = item.copy(folder, newId, item.getParentId());
                    redoRecorder.setDestId(item.getId(), newId);
                }
                result.add(copy);
            }
            success = true;
            arrayList = result;
            Object var23_25 = null;
        }
        catch (IOException e) {
            try {
                throw ServiceException.FAILURE("IOException while copying items", e);
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                this.endTransaction(success);
                throw throwable;
            }
        }
        this.endTransaction(success);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<MailItem> imapCopy(OperationContext octxt, int[] itemIds, byte type, int folderId) throws IOException, ServiceException {
        ArrayList<MailItem> arrayList;
        this.beginTrackingImap();
        for (int id : itemIds) {
            if (id > 0) continue;
            throw MailItem.noSuchItem(id, type);
        }
        ImapCopyItem redoRecorder = new ImapCopyItem(this.mId, type, folderId);
        boolean success = false;
        try {
            MailItem[] items;
            this.beginTransaction("icopy", octxt, redoRecorder);
            ImapCopyItem redoPlayer = (ImapCopyItem)this.mCurrentChange.getRedoPlayer();
            Folder target = this.getFolderById(folderId);
            for (MailItem item : items = this.getItemById(itemIds, type)) {
                this.checkItemChangeID(item);
            }
            ArrayList<MailItem> result = new ArrayList<MailItem>();
            for (MailItem item : items) {
                int srcId = item.getId();
                int newId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getDestId(srcId));
                this.trainSpamFilter(octxt, item, target);
                MailItem copy = item.icopy(target, newId);
                result.add(copy);
                redoRecorder.setDestId(srcId, newId);
            }
            success = true;
            arrayList = result;
            Object var19_22 = null;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return arrayList;
    }

    private <T extends MailItem> T trainSpamFilter(OperationContext octxt, T item, Folder target) {
        if (this.mCurrentChange.getRedoPlayer() != null) {
            return item;
        }
        MailItem.TargetConstraint tcon = this.getOperationTargetConstraint();
        try {
            List<MailItem> items = item instanceof Conversation ? ((Conversation)item).getMessages() : Arrays.asList(item);
            for (MailItem mailItem : items) {
                boolean fromSpam = mailItem.inSpam();
                boolean toSpam = target.inSpam();
                if (!fromSpam && !toSpam || fromSpam && (toSpam || target.inTrash()) || !MailItem.TargetConstraint.checkItem(tcon, item) || !item.canAccess((short)1)) continue;
                try {
                    SpamHandler.getInstance().handle(octxt, this, mailItem.getId(), mailItem.getType(), toSpam);
                    ZimbraLog.mailop.info(MailItem.getMailopContext(mailItem) + " sent to spam filter for training (marked as " + (toSpam ? "" : "not ") + "spam)");
                }
                catch (Exception e) {
                    ZimbraLog.mailop.info((Object)("could not train spam filter: " + MailItem.getMailopContext(mailItem)), e);
                }
            }
        }
        catch (ServiceException e) {
            ZimbraLog.mailop.info((Object)("could not train spam filter: " + MailItem.getMailopContext(item)), e);
        }
        return item;
    }

    public synchronized void move(OperationContext octxt, int itemId, byte type, int targetId) throws ServiceException {
        this.move(octxt, new int[]{itemId}, type, targetId, null);
    }

    public synchronized void move(OperationContext octxt, int itemId, byte type, int targetId, MailItem.TargetConstraint tcon) throws ServiceException {
        this.move(octxt, new int[]{itemId}, type, targetId, tcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void move(OperationContext octxt, int[] itemIds, byte type, int targetId, MailItem.TargetConstraint tcon) throws ServiceException {
        MoveItem redoRecorder = new MoveItem(this.mId, itemIds, type, targetId, tcon);
        HashMap<Integer, String> oldFolderPaths = new HashMap<Integer, String>();
        boolean success = false;
        try {
            MailItem[] items;
            this.beginTransaction("move", octxt, redoRecorder);
            this.setOperationTargetConstraint(tcon);
            Folder target = this.getFolderById(targetId);
            for (MailItem item : items = this.getItemById(itemIds, type)) {
                this.checkItemChangeID(item);
            }
            int oldUIDNEXT = target.getImapUIDNEXT();
            boolean resetUIDNEXT = false;
            for (MailItem item : items) {
                if (item instanceof Folder && !oldFolderPaths.containsKey(item.getId())) {
                    oldFolderPaths.put(item.getId(), ((Folder)item).getPath());
                }
                this.trainSpamFilter(octxt, item, target);
                boolean moved = item.move(target);
                if (!moved || resetUIDNEXT || !this.isTrackingImap() || !(item instanceof Conversation) && !(item instanceof Message) && !(item instanceof Contact)) continue;
                resetUIDNEXT = true;
            }
            if (resetUIDNEXT && oldUIDNEXT == target.getImapUIDNEXT()) {
                MoveItem redoPlayer = (MoveItem)this.mCurrentChange.getRedoPlayer();
                redoRecorder.setUIDNEXT(this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getUIDNEXT()));
                target.updateUIDNEXT();
            }
            success = true;
            Object var19_22 = null;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        if (success) {
            Iterator i$ = oldFolderPaths.keySet().iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                this.updateFilterRules(id, (String)oldFolderPaths.get(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rename(OperationContext octxt, int id, byte type, String name, int folderId) throws ServiceException {
        if (name != null && name.startsWith("/")) {
            this.rename(octxt, id, type, name);
            return;
        }
        if ((name = StringUtil.stripControlCharacters(name)) == null || name.equals("")) {
            throw ServiceException.INVALID_REQUEST("cannot set name to empty string", null);
        }
        RenameItem redoRecorder = new RenameItem(this.mId, id, type, name, folderId);
        boolean success = false;
        String oldFolderPath = null;
        try {
            this.beginTransaction("rename", octxt, redoRecorder);
            MailItem item = this.getItemById(id, type);
            if (item instanceof Folder) {
                oldFolderPath = ((Folder)item).getPath();
            }
            this.checkItemChangeID(item);
            if (folderId <= 0) {
                folderId = item.getFolderId();
            }
            Folder target = this.getFolderById(folderId);
            this.trainSpamFilter(octxt, item, target);
            String oldName = item.getName();
            item.rename(name, target);
            if (item instanceof Tag) {
                this.mTagCache.remove(oldName.toLowerCase());
                this.mTagCache.put(name.toLowerCase(), (Tag)item);
            }
            success = true;
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        if (success && oldFolderPath != null) {
            this.updateFilterRules(id, oldFolderPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rename(OperationContext octxt, int id, byte type, String path) throws ServiceException {
        if (path == null || !path.startsWith("/")) {
            this.rename(octxt, id, type, path, -1);
            return;
        }
        RenameItemPath redoRecorder = new RenameItemPath(this.mId, id, type, path);
        boolean success = false;
        HashMap<Integer, String> oldFolderPaths = new HashMap<Integer, String>();
        try {
            int[] playerParentIds;
            this.beginTransaction("renameFolderPath", octxt, redoRecorder);
            RenameItemPath redoPlayer = (RenameItemPath)this.mCurrentChange.getRedoPlayer();
            MailItem item = this.getItemById(id, type);
            this.checkItemChangeID(item);
            String[] parts = path.substring(1).split("/");
            if (parts.length == 0) {
                throw MailServiceException.ALREADY_EXISTS(path, new ServiceException.Argument[0]);
            }
            int[] recorderParentIds = new int[parts.length - 1];
            int[] nArray = playerParentIds = redoPlayer == null ? null : redoPlayer.getParentIds();
            if (playerParentIds != null && playerParentIds.length != recorderParentIds.length) {
                throw ServiceException.FAILURE("incorrect number of path segments in redo player", null);
            }
            Folder parent = this.getFolderById(1);
            for (int i = 0; i < parts.length - 1; ++i) {
                String name = MailItem.validateItemName(parts[i]);
                int subfolderId = playerParentIds == null ? -1 : playerParentIds[i];
                Folder subfolder = parent.findSubfolder(name);
                if (subfolder == null) {
                    subfolder = Folder.create(this.getNextItemId(subfolderId), this, parent, name);
                } else {
                    if (subfolderId != -1 && subfolderId != subfolder.getId()) {
                        throw ServiceException.FAILURE("parent folder id changed since operation was recorded", null);
                    }
                    if (!subfolder.getName().equals(name) && subfolder.isMutable()) {
                        if (!oldFolderPaths.containsKey(subfolder.getId())) {
                            oldFolderPaths.put(subfolder.getId(), subfolder.getPath());
                        }
                        subfolder.rename(name, parent);
                    }
                }
                recorderParentIds[i] = subfolder.getId();
                parent = subfolder;
            }
            redoRecorder.setParentIds(recorderParentIds);
            this.trainSpamFilter(octxt, item, parent);
            String name = parts[parts.length - 1];
            if (item instanceof Folder && !oldFolderPaths.containsKey(item.getId())) {
                oldFolderPaths.put(item.getId(), ((Folder)item).getPath());
            }
            item.rename(name, parent);
            success = true;
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        if (success) {
            Iterator i$ = oldFolderPaths.keySet().iterator();
            while (i$.hasNext()) {
                int folderId = (Integer)i$.next();
                this.updateFilterRules(folderId, (String)oldFolderPaths.get(folderId));
            }
        }
    }

    protected void updateFilterRules(int folderId, String oldPath) {
        try {
            Folder folder = this.getFolderById(folderId);
            if (!folder.getPath().equals(oldPath) && !folder.isHidden()) {
                RuleManager.folderRenamed(this.getAccount(), oldPath, folder.getPath());
            }
        }
        catch (ServiceException e) {
            ZimbraLog.filter.warn((Object)"Unable to update filter rules with new folder path.", e);
        }
    }

    public synchronized void delete(OperationContext octxt, int itemId, byte type) throws ServiceException {
        this.delete(octxt, new int[]{itemId}, type, null);
    }

    public synchronized void delete(OperationContext octxt, MailItem item, MailItem.TargetConstraint tcon) throws ServiceException {
        this.delete(octxt, new int[]{item.getId()}, item.getType(), tcon);
    }

    public synchronized void delete(OperationContext octxt, int itemId, byte type, MailItem.TargetConstraint tcon) throws ServiceException {
        this.delete(octxt, new int[]{itemId}, type, tcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(OperationContext octxt, int[] itemIds, byte type, MailItem.TargetConstraint tcon) throws ServiceException {
        DeleteItem redoRecorder = new DeleteItem(this.mId, itemIds, type, tcon);
        boolean success = false;
        try {
            this.beginTransaction("delete", octxt, redoRecorder);
            this.setOperationTargetConstraint(tcon);
            for (int id : itemIds) {
                MailItem item;
                if (id == -1) continue;
                try {
                    item = this.getItemById(id, (byte)-1);
                }
                catch (MailServiceException.NoSuchItemException nsie) {
                    continue;
                }
                if (!MailItem.isAcceptableType(type, item.getType())) {
                    throw MailItem.noSuchItem(id, type);
                }
                if (!this.checkItemChangeID(item) && item instanceof Tag) {
                    throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
                }
                item.delete(MailItem.DeleteScope.ENTIRE_ITEM, false);
            }
            TypedIdList tombstones = this.collectPendingTombstones();
            if (tombstones != null && !tombstones.isEmpty()) {
                DbMailItem.writeTombstones(this, tombstones);
            }
            success = true;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    TypedIdList collectPendingTombstones() {
        if (!this.isTrackingSync() || this.mCurrentChange.deletes == null) {
            return null;
        }
        return new TypedIdList(this.mCurrentChange.deletes.itemIds);
    }

    public synchronized Tag createTag(OperationContext octxt, String name, byte color) throws ServiceException {
        return this.createTag(octxt, name, new MailItem.Color(color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Tag createTag(OperationContext octxt, String name, MailItem.Color color) throws ServiceException {
        Tag tag;
        if ((name = StringUtil.stripControlCharacters(name)) == null || name.equals("")) {
            throw ServiceException.INVALID_REQUEST("tag must have a name", null);
        }
        CreateTag redoRecorder = new CreateTag(this.mId, name, color);
        boolean success = false;
        try {
            int tagId;
            this.beginTransaction("createTag", octxt, redoRecorder);
            CreateTag redoPlayer = (CreateTag)this.mCurrentChange.getRedoPlayer();
            int n = tagId = redoPlayer == null ? -1 : redoPlayer.getTagId();
            if (tagId != -1 && !Tag.validateId(tagId)) {
                throw ServiceException.INVALID_REQUEST("invalid tag id " + tagId, null);
            }
            if (tagId == -1) {
                for (tagId = 64; tagId < 127 && this.mTagCache.get(new Integer(tagId)) != null; ++tagId) {
                }
                if (tagId >= 127) {
                    throw MailServiceException.TOO_MANY_TAGS();
                }
            }
            Tag tag2 = Tag.create(this, tagId, name, color);
            redoRecorder.setTagId(tagId);
            success = true;
            tag = tag2;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return tag;
    }

    public synchronized Note createNote(OperationContext octxt, String content, Note.Rectangle location, byte color, int folderId) throws ServiceException {
        return this.createNote(octxt, content, location, new MailItem.Color(color), folderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Note createNote(OperationContext octxt, String content, Note.Rectangle location, MailItem.Color color, int folderId) throws ServiceException {
        Note note;
        if ((content = StringUtil.stripControlCharacters(content)) == null || content.equals("")) {
            throw ServiceException.INVALID_REQUEST("note content may not be empty", null);
        }
        CreateNote redoRecorder = new CreateNote(this.mId, folderId, content, color, location);
        boolean success = false;
        try {
            this.beginTransaction("createNote", octxt, redoRecorder);
            CreateNote redoPlayer = (CreateNote)this.mCurrentChange.getRedoPlayer();
            int noteId = redoPlayer == null ? this.getNextItemId(-1) : this.getNextItemId(redoPlayer.getNoteId());
            redoRecorder.setNoteId(noteId);
            Note note2 = Note.create(noteId, this.getFolderById(folderId), content, location, color, null);
            this.queueForIndexing(note2, false, null);
            success = true;
            note = note2;
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return note;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void editNote(OperationContext octxt, int noteId, String content) throws ServiceException {
        if ((content = StringUtil.stripControlCharacters(content)) == null || content.equals("")) {
            throw ServiceException.INVALID_REQUEST("note content may not be empty", null);
        }
        EditNote redoRecorder = new EditNote(this.mId, noteId, content);
        boolean success = false;
        try {
            this.beginTransaction("editNote", octxt, redoRecorder);
            Note note = this.getNoteById(noteId);
            this.checkItemChangeID(note);
            note.setContent(content);
            this.queueForIndexing(note, true, null);
            success = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void repositionNote(OperationContext octxt, int noteId, Note.Rectangle location) throws ServiceException {
        if (location == null) {
            throw new IllegalArgumentException("must specify note bounds");
        }
        RepositionNote redoRecorder = new RepositionNote(this.mId, noteId, location);
        boolean success = false;
        try {
            this.beginTransaction("repositionNote", octxt, redoRecorder);
            Note note = this.getNoteById(noteId);
            this.checkItemChangeID(note);
            note.reposition(location);
            success = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    CalendarItem createCalendarItem(int folderId, int flags, long tags, String uid, ParsedMessage pm, Invite invite, MailItem.CustomMetadata custom) throws ServiceException {
        CreateCalendarItemPlayer redoPlayer = (CreateCalendarItemPlayer)((Object)this.mCurrentChange.getRedoPlayer());
        CreateCalendarItemRecorder redoRecorder = (CreateCalendarItemRecorder)((Object)this.mCurrentChange.getRedoRecorder());
        int newCalItemId = redoPlayer == null ? -1 : redoPlayer.getCalendarItemId();
        int createId = this.getNextItemId(newCalItemId);
        CalendarItem calItem = CalendarItem.create(createId, this.getFolderById(folderId), flags, tags, uid, pm, invite, -2L, custom);
        if (redoRecorder != null) {
            redoRecorder.setCalendarItemAttrs(calItem.getId(), calItem.getFolderId());
        }
        return calItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Contact createContact(OperationContext octxt, ParsedContact pc, int folderId, String tags) throws ServiceException {
        boolean deferIndexing = !this.indexImmediately() || pc.hasTemporaryAnalysisFailure();
        List<IndexDocument> indexData = null;
        if (!deferIndexing) {
            try {
                indexData = pc.getLuceneDocuments(this);
            }
            catch (ServiceException e) {
                ZimbraLog.index_add.info((Object)("Caught exception analyzing new contact in folder " + folderId + "; contact will not be indexed"), e);
                indexData = Collections.emptyList();
            }
        }
        StoreManager sm = StoreManager.getInstance();
        StagedBlob staged = null;
        if (pc.hasAttachment()) {
            InputStream is = null;
            try {
                try {
                    is = pc.getContentStream();
                    staged = sm.stage(is, (int)pc.getSize(), null, this);
                }
                catch (IOException ioe) {
                    throw ServiceException.FAILURE("could not save contact blob", ioe);
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
        }
        Mailbox mailbox = this;
        synchronized (mailbox) {
            Contact contact;
            CreateContact redoRecorder = new CreateContact(this.mId, folderId, pc, tags);
            boolean success = false;
            try {
                this.beginTransaction("createContact", octxt, redoRecorder);
                CreateContact redoPlayer = (CreateContact)this.mCurrentChange.getRedoPlayer();
                boolean isRedo = redoPlayer != null;
                int contactId = this.getNextItemId(isRedo ? redoPlayer.getContactId() : -1);
                redoRecorder.setContactId(contactId);
                MailboxBlob mblob = null;
                if (pc.hasAttachment()) {
                    try {
                        mblob = sm.renameTo(staged, this, contactId, this.getOperationChangeID());
                        this.markOtherItemDirty(mblob);
                    }
                    catch (IOException ioe) {
                        throw ServiceException.FAILURE("could not save contact blob", ioe);
                    }
                }
                int flags = 0;
                Contact con = Contact.create(contactId, this.getFolderById(folderId), mblob, pc, flags, tags, null);
                this.queueForIndexing(con, false, deferIndexing ? null : indexData);
                success = true;
                contact = con;
                Object var20_24 = null;
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                this.endTransaction(success);
                sm.quietDelete(staged);
                throw throwable;
            }
            this.endTransaction(success);
            sm.quietDelete(staged);
            return contact;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyContact(OperationContext octxt, int contactId, ParsedContact pc) throws ServiceException {
        boolean deferIndexing;
        pc.analyze(this);
        List<IndexDocument> indexData = null;
        boolean bl = deferIndexing = !this.indexImmediately() || pc.hasTemporaryAnalysisFailure();
        if (!deferIndexing) {
            try {
                indexData = pc.getLuceneDocuments(this);
            }
            catch (Exception e) {
                ZimbraLog.index_add.info((Object)("caught exception analyzing contact " + contactId + "; contact will not be indexed"), e);
                indexData = new ArrayList<IndexDocument>();
            }
        }
        StoreManager sm = StoreManager.getInstance();
        StagedBlob staged = null;
        if (pc.hasAttachment()) {
            InputStream is = null;
            try {
                try {
                    is = pc.getContentStream();
                    staged = sm.stage(is, (int)pc.getSize(), null, this);
                }
                catch (IOException ioe) {
                    throw ServiceException.FAILURE("could not save contact blob", ioe);
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
        }
        Mailbox mailbox = this;
        synchronized (mailbox) {
            ModifyContact redoRecorder = new ModifyContact(this.mId, contactId, pc);
            boolean success = false;
            try {
                this.beginTransaction("modifyContact", octxt, redoRecorder);
                Contact con = this.getContactById(contactId);
                if (!this.checkItemChangeID(con)) {
                    throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
                }
                try {
                    con.setContent(staged, pc);
                }
                catch (IOException ioe) {
                    throw ServiceException.FAILURE("could not save contact blob", ioe);
                }
                this.queueForIndexing(con, true, indexData);
                success = true;
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                this.endTransaction(success);
                sm.quietDelete(staged);
                throw throwable;
            }
            this.endTransaction(success);
            sm.quietDelete(staged);
            return;
        }
    }

    public synchronized Folder createFolder(OperationContext octxt, String name, int parentId, byte defaultView, int flags, byte color, String url) throws ServiceException {
        return this.createFolder(octxt, name, parentId, (byte)0, defaultView, flags, color, url);
    }

    public synchronized Folder createFolder(OperationContext octxt, String name, int parentId, byte attrs, byte defaultView, int flags, byte color, String url) throws ServiceException {
        return this.createFolder(octxt, name, parentId, attrs, defaultView, flags, new MailItem.Color(color), url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Folder createFolder(OperationContext octxt, String name, int parentId, byte attrs, byte defaultView, int flags, MailItem.Color color, String url) throws ServiceException {
        Folder folder;
        CreateFolder redoRecorder = new CreateFolder(this.mId, name, parentId, attrs, defaultView, flags, color, url);
        boolean success = false;
        try {
            this.beginTransaction("createFolder", octxt, redoRecorder);
            CreateFolder redoPlayer = (CreateFolder)this.mCurrentChange.getRedoPlayer();
            int folderId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getFolderId());
            Folder folder2 = Folder.create(folderId, this, this.getFolderById(parentId), name, attrs, defaultView, flags, color, url, null);
            redoRecorder.setFolderId(folder2.getId());
            success = true;
            this.updateRssDataSource(folder2);
            folder = folder2;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return folder;
    }

    public synchronized Folder createFolder(OperationContext octxt, String path, byte attrs, byte defaultView) throws ServiceException {
        return this.createFolder(octxt, path, attrs, defaultView, 0, (byte)0, (String)null);
    }

    public synchronized Folder createFolder(OperationContext octxt, String path, byte attrs, byte defaultView, int flags, byte color, String url) throws ServiceException {
        return this.createFolder(octxt, path, attrs, defaultView, flags, new MailItem.Color(color), url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Folder createFolder(OperationContext octxt, String path, byte attrs, byte defaultView, int flags, MailItem.Color color, String url) throws ServiceException {
        Folder folder;
        if (path == null) {
            throw ServiceException.FAILURE("null path passed to Mailbox.createFolderPath", null);
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        CreateFolderPath redoRecorder = new CreateFolderPath(this.mId, path, attrs, defaultView, flags, color, url);
        boolean success = false;
        try {
            int[] playerFolderIds;
            this.beginTransaction("createFolderPath", octxt, redoRecorder);
            CreateFolderPath redoPlayer = (CreateFolderPath)this.mCurrentChange.getRedoPlayer();
            String[] parts = path.substring(1).split("/");
            if (parts.length == 0) {
                throw MailServiceException.ALREADY_EXISTS(path, new ServiceException.Argument[0]);
            }
            int[] recorderFolderIds = new int[parts.length];
            int[] nArray = playerFolderIds = redoPlayer == null ? null : redoPlayer.getFolderIds();
            if (playerFolderIds != null && playerFolderIds.length != recorderFolderIds.length) {
                throw ServiceException.FAILURE("incorrect number of path segments in redo player", null);
            }
            Folder folder2 = this.getFolderById(1);
            for (int i = 0; i < parts.length; ++i) {
                boolean last = i == parts.length - 1;
                int folderId = playerFolderIds == null ? -1 : playerFolderIds[i];
                Folder subfolder = folder2.findSubfolder(parts[i]);
                if (subfolder == null) {
                    subfolder = Folder.create(this.getNextItemId(folderId), this, folder2, parts[i], (byte)0, last ? defaultView : (byte)-1, flags, color, last ? url : null, null);
                } else {
                    if (folderId != -1 && folderId != subfolder.getId()) {
                        throw ServiceException.FAILURE("parent folder id changed since operation was recorded", null);
                    }
                    if (last) {
                        throw MailServiceException.ALREADY_EXISTS(path, new ServiceException.Argument[0]);
                    }
                }
                recorderFolderIds[i] = subfolder.getId();
                folder2 = subfolder;
            }
            redoRecorder.setFolderIds(recorderFolderIds);
            success = true;
            folder = folder2;
            Object var20_20 = null;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return folder;
    }

    public String getItemFlagString(MailItem mi) {
        return mi.getFlagString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ACL.Grant grantAccess(OperationContext octxt, int folderId, String grantee, byte granteeType, short rights, String args) throws ServiceException {
        GrantAccess redoPlayer = new GrantAccess(this.mId, folderId, grantee, granteeType, rights, args);
        boolean success = false;
        ACL.Grant grant = null;
        try {
            this.beginTransaction("grantAccess", octxt, redoPlayer);
            Folder folder = this.getFolderById(folderId);
            this.checkItemChangeID(folder);
            grant = folder.grantAccess(grantee, granteeType, rights, args);
            success = true;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return grant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void revokeAccess(OperationContext octxt, int folderId, String grantee) throws ServiceException {
        RevokeAccess redoPlayer = new RevokeAccess(this.mId, folderId, grantee);
        boolean success = false;
        try {
            this.beginTransaction("revokeAccess", octxt, redoPlayer);
            Folder folder = this.getFolderById(folderId);
            this.checkItemChangeID(folder);
            folder.revokeAccess(grantee);
            success = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPermissions(OperationContext octxt, int folderId, ACL acl) throws ServiceException {
        SetPermissions redoPlayer = new SetPermissions(this.mId, folderId, acl);
        boolean success = false;
        try {
            this.beginTransaction("setPermissions", octxt, redoPlayer);
            Folder folder = this.getFolderById(folderId);
            this.checkItemChangeID(folder);
            folder.setPermissions(acl);
            success = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFolderDefaultView(OperationContext octxt, int folderId, byte view) throws ServiceException {
        SetFolderDefaultView redoRecorder = new SetFolderDefaultView(this.mId, folderId, view);
        boolean success = false;
        try {
            this.beginTransaction("setFolderDefaultView", octxt, redoRecorder);
            Folder folder = this.getFolderById(folderId);
            if (!this.checkItemChangeID(folder)) {
                throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
            }
            folder.setDefaultView(view);
            success = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFolderUrl(OperationContext octxt, int folderId, String url) throws ServiceException {
        SetFolderUrl redoRecorder = new SetFolderUrl(this.mId, folderId, url);
        boolean success = false;
        try {
            this.beginTransaction("setFolderUrl", octxt, redoRecorder);
            Folder folder = this.getFolderById(folderId);
            this.checkItemChangeID(folder);
            folder.setUrl(url);
            success = true;
            this.updateRssDataSource(folder);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    protected void updateRssDataSource(Folder folder) {
        try {
            Provisioning prov = Provisioning.getInstance();
            Account account = this.getAccount();
            NamedEntry ds = null;
            List<DataSource> dataSources = prov.getAllDataSources(account);
            for (DataSource i : dataSources) {
                if (i.getFolderId() != folder.getId() || i.getType() != DataSource.Type.rss && i.getType() != DataSource.Type.cal) continue;
                ds = i;
                break;
            }
            if (StringUtil.isNullOrEmpty(folder.getUrl())) {
                if (ds != null) {
                    String dsid = ds.getId();
                    prov.deleteDataSource(account, dsid);
                    DataSourceManager.updateSchedule(account.getId(), dsid);
                }
                return;
            }
            if (ds == null) {
                String name;
                DataSource.Type type;
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("zimbraDataSourceEnabled", "TRUE");
                attrs.put("zimbraDataSourceFolderId", Integer.toString(folder.getId()));
                if (folder.getDefaultView() == 11) {
                    type = DataSource.Type.cal;
                    name = "CAL-" + folder.getId();
                } else {
                    type = DataSource.Type.rss;
                    name = "RSS-" + folder.getId();
                }
                ds = prov.createDataSource(account, type, name, attrs);
                DataSourceManager.updateSchedule(account.getId(), ds.getId());
            }
        }
        catch (ServiceException e) {
            ZimbraLog.mailbox.warn("Unable to update data source for folder %s.", (Object)folder.getPath(), e);
        }
    }

    public synchronized void synchronizeFolder(OperationContext octxt, int folderId) throws ServiceException {
        Folder folder = this.getFolderById(octxt, folderId);
        if (!folder.getUrl().equals("")) {
            this.importFeed(octxt, folderId, folder.getUrl(), true);
        }
    }

    public synchronized void importFeed(OperationContext octxt, int folderId, String url, boolean subscription) throws ServiceException {
        if (url == null || url.equals("")) {
            return;
        }
        Folder folder = this.getFolderById(octxt, folderId);
        Folder.SyncData fsd = subscription ? folder.getSyncData() : null;
        FeedManager.SubscriptionData<?> sdata = FeedManager.retrieveRemoteDatasource(this.getAccount(), url, fsd);
        boolean isCalendar = folder.getDefaultView() == 11 || folder.getDefaultView() == 15;
        HashSet<Integer> existingCalItems = new HashSet<Integer>();
        if (subscription && isCalendar) {
            for (int i : this.listItemIds(octxt, (byte)-1, folderId)) {
                existingCalItems.add(i);
            }
        }
        if (sdata.items.isEmpty()) {
            if (subscription && isCalendar) {
                this.emptyFolder(octxt, folderId, false);
            }
            this.updateRssDataSource(folder);
            return;
        }
        OperationContext octxtNoConflicts = null;
        octxtNoConflicts = octxt != null ? new OperationContext(octxt).unsetChangeConstraint() : new OperationContext(this.getAccountId()).unsetChangeConstraint();
        HashSet<String> calUidsSeen = new HashSet<String>();
        for (Object obj : sdata.items) {
            try {
                if (obj instanceof Invite) {
                    boolean addRevision;
                    Invite inv = (Invite)obj;
                    String uid = inv.getUid();
                    if (uid == null) {
                        uid = LdapUtil.generateUUID();
                        inv.setUid(uid);
                    }
                    if (!calUidsSeen.contains(uid)) {
                        addRevision = true;
                        calUidsSeen.add(uid);
                    } else {
                        addRevision = false;
                    }
                    inv.sanitize(false);
                    try {
                        int[] calIds = this.addInvite(octxtNoConflicts, inv, folderId, true, addRevision);
                        if (calIds == null || calIds.length <= 0) continue;
                        existingCalItems.remove(calIds[0]);
                    }
                    catch (ServiceException e) {
                        ZimbraLog.calendar.warn((Object)("Skipping bad iCalendar object during import: uid=" + inv.getUid()), e);
                    }
                    continue;
                }
                if (!(obj instanceof ParsedMessage)) continue;
                this.addMessage(octxtNoConflicts, (ParsedMessage)obj, folderId, true, Flag.BITMASK_UNREAD, null);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("IOException", e);
            }
        }
        Iterator<Object> i$ = existingCalItems.iterator();
        while (i$.hasNext()) {
            int toRemove = (Integer)i$.next();
            this.delete(octxtNoConflicts, toRemove, (byte)-1);
        }
        if (subscription && sdata.lastDate > 0L) {
            try {
                this.setSubscriptionData(octxt, folderId, sdata.lastDate, sdata.lastGuid);
            }
            catch (Exception e) {
                ZimbraLog.mailbox.warn((Object)"could not update feed metadata", e);
            }
        }
        this.updateRssDataSource(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSubscriptionData(OperationContext octxt, int folderId, long date, String guid) throws ServiceException {
        SetSubscriptionData redoRecorder = new SetSubscriptionData(this.mId, folderId, date, guid);
        boolean success = false;
        try {
            this.beginTransaction("setSubscriptionData", octxt, redoRecorder);
            this.getFolderById(folderId).setSubscriptionData(guid, date);
            success = true;
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSyncDate(OperationContext octxt, int folderId, long date) throws ServiceException {
        SetSubscriptionData redoRecorder = new SetSubscriptionData(this.mId, folderId, date, null);
        boolean success = false;
        try {
            this.beginTransaction("setSyncDate", octxt, redoRecorder);
            this.getFolderById(folderId).setSyncDate(date);
            success = true;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void emptyFolder(OperationContext octxt, int folderId, boolean removeSubfolders) throws ServiceException {
        EmptyFolder redoRecorder = new EmptyFolder(this.mId, folderId, removeSubfolders);
        boolean success = false;
        try {
            this.beginTransaction("emptyFolder", octxt, redoRecorder);
            Folder folder = this.getFolderById(folderId);
            folder.empty(removeSubfolders);
            success = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized SearchFolder createSearchFolder(OperationContext octxt, int folderId, String name, String query, String types, String sort, int flags, byte color) throws ServiceException {
        return this.createSearchFolder(octxt, folderId, name, query, types, sort, flags, new MailItem.Color(color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SearchFolder createSearchFolder(OperationContext octxt, int folderId, String name, String query, String types, String sort, int flags, MailItem.Color color) throws ServiceException {
        SearchFolder searchFolder;
        CreateSavedSearch redoRecorder = new CreateSavedSearch(this.mId, folderId, name, query, types, sort, flags, color);
        boolean success = false;
        try {
            this.beginTransaction("createSearchFolder", octxt, redoRecorder);
            CreateSavedSearch redoPlayer = (CreateSavedSearch)this.mCurrentChange.getRedoPlayer();
            int searchId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getSearchId());
            SearchFolder search = SearchFolder.create(searchId, this.getFolderById(folderId), name, query, types, sort, flags, color, null);
            redoRecorder.setSearchId(search.getId());
            success = true;
            searchFolder = search;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return searchFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifySearchFolder(OperationContext octxt, int id, String query, String types, String sort) throws ServiceException {
        ModifySavedSearch redoRecorder = new ModifySavedSearch(this.mId, id, query, types, sort);
        boolean success = false;
        try {
            this.beginTransaction("modifySearchFolder", octxt, redoRecorder);
            SearchFolder search = this.getSearchFolderById(id);
            this.checkItemChangeID(search);
            search.changeQuery(query, types, sort);
            success = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public synchronized Mountpoint createMountpoint(OperationContext octxt, int folderId, String name, String ownerId, int remoteId, byte view, int flags, byte color) throws ServiceException {
        return this.createMountpoint(octxt, folderId, name, ownerId, remoteId, view, flags, new MailItem.Color(color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Mountpoint createMountpoint(OperationContext octxt, int folderId, String name, String ownerId, int remoteId, byte view, int flags, MailItem.Color color) throws ServiceException {
        Mountpoint mountpoint;
        CreateMountpoint redoRecorder = new CreateMountpoint(this.mId, folderId, name, ownerId, remoteId, view, flags, color);
        boolean success = false;
        try {
            this.beginTransaction("createMountpoint", octxt, redoRecorder);
            CreateMountpoint redoPlayer = (CreateMountpoint)this.mCurrentChange.getRedoPlayer();
            int mptId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getId());
            Mountpoint mpt = Mountpoint.create(mptId, this.getFolderById(folderId), name, ownerId, remoteId, view, flags, color, null);
            redoRecorder.setId(mpt.getId());
            success = true;
            mountpoint = mpt;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
        return mountpoint;
    }

    public void purgeMessages(OperationContext octxt) throws ServiceException {
        this.purgeMessages(octxt, this.getAccount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void purgeMessages(OperationContext octxt, Account acct) throws ServiceException {
        if (ZimbraLog.purge.isDebugEnabled()) {
            ZimbraLog.purge.debug("Purging messages.");
            ZimbraLog.purge.debug("System retention policy: Trash=%s, Junk=%s, All messages=%s", acct.getAttr("zimbraMailTrashLifetime"), acct.getAttr("zimbraMailSpamLifetime"), acct.getAttr("zimbraMailMessageLifetime"));
            ZimbraLog.purge.debug("User-specified retention policy: Inbox read=%s, Inbox unread=%s, Sent=%s, Junk=%s, Trash=%s", acct.getAttr("zimbraPrefInboxReadLifetime"), acct.getAttr("zimbraPrefInboxUnreadLifetime"), acct.getAttr("zimbraPrefSentLifetime"), acct.getAttr("zimbraPrefJunkLifetime"), acct.getAttr("zimbraPrefTrashLifetime"));
        }
        int globalTimeout = (int)(acct.getTimeInterval("zimbraMailMessageLifetime", 0L) / 1000L);
        int systemTrashTimeout = (int)(acct.getTimeInterval("zimbraMailTrashLifetime", 0L) / 1000L);
        int systemJunkTimeout = (int)(acct.getTimeInterval("zimbraMailSpamLifetime", 0L) / 1000L);
        int userInboxReadTimeout = (int)(acct.getTimeInterval("zimbraPrefInboxReadLifetime", 0L) / 1000L);
        int userInboxUnreadTimeout = (int)(acct.getTimeInterval("zimbraPrefInboxUnreadLifetime", 0L) / 1000L);
        int userTrashTimeout = (int)(acct.getTimeInterval("zimbraPrefTrashLifetime", 0L) / 1000L);
        int userJunkTimeout = (int)(acct.getTimeInterval("zimbraPrefJunkLifetime", 0L) / 1000L);
        int userSentTimeout = (int)(acct.getTimeInterval("zimbraPrefSentLifetime", 0L) / 1000L);
        int trashTimeout = this.pickTimeout(systemTrashTimeout, userTrashTimeout);
        int junkTimeout = this.pickTimeout(systemJunkTimeout, userJunkTimeout);
        if (globalTimeout <= 0 && trashTimeout <= 0 && junkTimeout <= 0 && userInboxReadTimeout <= 0 && userInboxReadTimeout <= 0 && userInboxUnreadTimeout <= 0 && userSentTimeout <= 0) {
            return;
        }
        if (globalTimeout > 0 && globalTimeout < 2678400) {
            ZimbraLog.purge.warn("global message timeout < 1 month; defaulting to 31 days");
            globalTimeout = 2678400;
        }
        PurgeOldMessages redoRecorder = new PurgeOldMessages(this.mId);
        boolean success = false;
        try {
            TypedIdList tombstones;
            this.beginTransaction("purgeMessages", octxt, redoRecorder);
            Folder trash = this.getFolderById(3);
            Folder junk = this.getFolderById(4);
            Folder sent = this.getFolderById(5);
            Folder inbox = this.getFolderById(2);
            if (globalTimeout > 0) {
                Folder.purgeMessages(this, null, this.getOperationTimestamp() - globalTimeout, null, false, false);
            }
            if (trashTimeout > 0) {
                boolean useChangeDate = acct.getBooleanAttr("zimbraMailPurgeUseChangeDateForTrash", true);
                Folder.purgeMessages(this, trash, this.getOperationTimestamp() - trashTimeout, null, useChangeDate, true);
            }
            if (junkTimeout > 0) {
                Folder.purgeMessages(this, junk, this.getOperationTimestamp() - junkTimeout, null, false, false);
            }
            if (userInboxReadTimeout > 0) {
                Folder.purgeMessages(this, inbox, this.getOperationTimestamp() - userInboxReadTimeout, false, false, false);
            }
            if (userInboxUnreadTimeout > 0) {
                Folder.purgeMessages(this, inbox, this.getOperationTimestamp() - userInboxUnreadTimeout, true, false, false);
            }
            if (userSentTimeout > 0) {
                Folder.purgeMessages(this, sent, this.getOperationTimestamp() - userSentTimeout, null, false, false);
            }
            if ((tombstones = this.collectPendingTombstones()) != null && !tombstones.isEmpty()) {
                DbMailItem.writeTombstones(this, tombstones);
            }
            int convTimeout = (int)(LC.conversation_max_age_ms.longValue() / 1000L);
            int tombstoneTimeout = (int)(LC.tombstone_max_age_ms.longValue() / 1000L);
            DbMailItem.closeOldConversations(this, this.getOperationTimestamp() - convTimeout);
            success = true;
            Object var23_23 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    private int pickTimeout(int t1, int t2) {
        if (t1 == 0) {
            return t2;
        }
        if (t2 == 0) {
            return t1;
        }
        return Math.min(t1, t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void purgeImapDeleted(OperationContext octxt) throws ServiceException {
        PurgeImapDeleted redoRecorder = new PurgeImapDeleted(this.mId);
        boolean success = false;
        try {
            this.beginTransaction("purgeImapDeleted", octxt, redoRecorder);
            Set<Folder> purgeable = this.getAccessibleFolders((short)9);
            MailItem.PendingDelete info = DbMailItem.getImapDeleted(this, purgeable);
            MailItem.delete(this, info, null, MailItem.DeleteScope.ENTIRE_ITEM, true);
            success = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endTransaction(success);
            throw throwable;
        }
        this.endTransaction(success);
    }

    public WikiItem createWiki(OperationContext octxt, int folderId, String wikiword, String author, InputStream data) throws ServiceException {
        return (WikiItem)this.createDocument(octxt, folderId, wikiword, "text/html; charset=utf-8", author, data, (byte)14);
    }

    public Document createDocument(OperationContext octxt, int folderId, String filename, String mimeType, String author, InputStream data) throws ServiceException {
        return this.createDocument(octxt, folderId, filename, mimeType, author, data, (byte)8);
    }

    public Document createDocument(OperationContext octxt, int folderId, String filename, String mimeType, String author, InputStream data, byte type) throws ServiceException {
        this.mIndexHelper.maybeIndexDeferredItems();
        try {
            ParsedDocument pd = new ParsedDocument(data, filename, mimeType, System.currentTimeMillis(), author);
            return this.createDocument(octxt, folderId, pd, type);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("error writing document blob", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document createDocument(OperationContext octxt, int folderId, ParsedDocument pd, byte type) throws IOException, ServiceException {
        StoreManager sm = StoreManager.getInstance();
        StagedBlob staged = sm.stage(pd.getBlob(), this);
        Mailbox mailbox = this;
        synchronized (mailbox) {
            Document document;
            SaveDocument redoRecorder = new SaveDocument(this.mId, pd.getDigest(), pd.getSize(), folderId);
            boolean success = false;
            try {
                try {
                    Document doc;
                    this.beginTransaction("createDoc", octxt, redoRecorder);
                    SaveDocument redoPlayer = octxt == null ? null : (SaveDocument)octxt.getPlayer();
                    int itemId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getMessageId());
                    if (type == 8) {
                        doc = Document.create(itemId, this.getFolderById(folderId), pd.getFilename(), pd.getContentType(), pd, null);
                    } else {
                        if (type != 14) throw MailServiceException.INVALID_TYPE(type);
                        doc = WikiItem.create(itemId, this.getFolderById(folderId), pd.getFilename(), pd, null);
                    }
                    redoRecorder.setMessageId(itemId);
                    redoRecorder.setDocument(pd);
                    redoRecorder.setItemType(type);
                    MailboxBlob mailboxBlob = doc.setContent(staged, pd);
                    redoRecorder.setMessageBodyInfo(new MailboxBlobDataSource(mailboxBlob), mailboxBlob.getSize());
                    this.queueForIndexing(doc, false, pd.hasTemporaryAnalysisFailure() || !this.indexImmediately() ? null : pd.getDocumentList());
                    success = true;
                    document = doc;
                    Object var16_16 = null;
                }
                catch (IOException ioe) {
                    throw ServiceException.FAILURE("error writing document blob", ioe);
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                this.endTransaction(success);
                sm.quietDelete(staged);
                throw throwable;
            }
            this.endTransaction(success);
            sm.quietDelete(staged);
            return document;
        }
    }

    public Document addDocumentRevision(OperationContext octxt, int docId, InputStream data, String author, String name) throws ServiceException {
        this.mIndexHelper.maybeIndexDeferredItems();
        Document doc = this.getDocumentById(octxt, docId);
        try {
            ParsedDocument pd = new ParsedDocument(data, name, doc.getContentType(), System.currentTimeMillis(), author);
            return this.addDocumentRevision(octxt, docId, pd);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("error writing document blob", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document addDocumentRevision(OperationContext octxt, int docId, ParsedDocument pd) throws IOException, ServiceException {
        boolean deferIndexing = !this.indexImmediately() || pd.hasTemporaryAnalysisFailure();
        StoreManager sm = StoreManager.getInstance();
        StagedBlob staged = sm.stage(pd.getBlob(), this);
        Mailbox mailbox = this;
        synchronized (mailbox) {
            Document document;
            AddDocumentRevision redoRecorder = new AddDocumentRevision(this.mId, pd.getDigest(), pd.getSize(), 0);
            boolean success = false;
            try {
                try {
                    this.beginTransaction("addDocumentRevision", octxt, redoRecorder);
                    Document doc = this.getDocumentById(docId);
                    redoRecorder.setDocument(pd);
                    redoRecorder.setDocId(docId);
                    redoRecorder.setItemType(doc.getType());
                    MailboxBlob mailboxBlob = doc.setContent(staged, pd);
                    redoRecorder.setMessageBodyInfo(new MailboxBlobDataSource(mailboxBlob), mailboxBlob.getSize());
                    this.queueForIndexing(doc, false, deferIndexing ? null : pd.getDocumentList());
                    success = true;
                    document = doc;
                    Object var14_14 = null;
                }
                catch (IOException ioe) {
                    throw ServiceException.FAILURE("error writing document blob", ioe);
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                this.endTransaction(success);
                sm.quietDelete(staged);
                throw throwable;
            }
            this.endTransaction(success);
            sm.quietDelete(staged);
            return document;
        }
    }

    public Message updateOrCreateChat(OperationContext octxt, ParsedMessage pm, int id) throws IOException, ServiceException {
        if (this.indexImmediately()) {
            pm.analyzeFully();
        }
        if (id == -1) {
            return this.createChat(octxt, pm, 14, Flag.BITMASK_FROM_ME, null);
        }
        return this.updateChat(octxt, pm, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Chat createChat(OperationContext octxt, ParsedMessage pm, int folderId, int flags, String tagsStr) throws IOException, ServiceException {
        StagedBlob staged;
        int size;
        String digest;
        if (pm == null) {
            throw ServiceException.INVALID_REQUEST("null ParsedMessage when adding chat to mailbox " + this.mId, null);
        }
        try {
            digest = pm.getRawDigest();
            size = pm.getRawSize();
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("unable to get chat message properties", e);
        }
        this.mIndexHelper.maybeIndexDeferredItems();
        boolean deferIndexing = !this.indexImmediately();
        List<IndexDocument> docList = null;
        if (!deferIndexing) {
            pm.analyzeFully();
            docList = pm.getLuceneDocuments();
        }
        StoreManager sm = StoreManager.getInstance();
        InputStream is = pm.getRawInputStream();
        try {
            staged = sm.stage(is, size, null, this);
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        Mailbox mailbox = this;
        synchronized (mailbox) {
            Chat chat;
            CreateChat redoRecorder = new CreateChat(this.mId, digest, size, folderId, flags, tagsStr);
            boolean success = false;
            try {
                this.beginTransaction("createChat", octxt, redoRecorder);
                CreateChat redoPlayer = octxt == null ? null : (CreateChat)octxt.getPlayer();
                redoRecorder.setMessageBodyInfo(new ParsedMessageDataSource(pm), size);
                long tags = Tag.tagsToBitmask(tagsStr);
                int itemId = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getMessageId());
                Chat chat2 = Chat.create(itemId, this.getFolderById(folderId), pm, staged, false, flags, tags);
                redoRecorder.setMessageId(chat2.getId());
                MailboxBlob mblob = sm.link(staged, this, itemId, this.getOperationChangeID());
                this.markOtherItemDirty(mblob);
                chat2.updateBlobData(mblob);
                this.queueForIndexing(chat2, false, docList);
                success = true;
                chat = chat2;
                Object var24_25 = null;
            }
            catch (Throwable throwable) {
                Object var24_26 = null;
                this.endTransaction(success);
                sm.quietDelete(staged);
                throw throwable;
            }
            this.endTransaction(success);
            sm.quietDelete(staged);
            return chat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Chat updateChat(OperationContext octxt, ParsedMessage pm, int id) throws IOException, ServiceException {
        StagedBlob staged;
        int size;
        String digest;
        if (pm == null) {
            throw ServiceException.INVALID_REQUEST("null ParsedMessage when updating chat " + id + " in mailbox " + this.mId, null);
        }
        try {
            digest = pm.getRawDigest();
            size = pm.getRawSize();
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("unable to get chat message properties", e);
        }
        boolean deferIndexing = !this.indexImmediately() || pm.hasTemporaryAnalysisFailure();
        List<IndexDocument> docList = null;
        if (!deferIndexing) {
            docList = pm.getLuceneDocuments();
        }
        StoreManager sm = StoreManager.getInstance();
        InputStream is = pm.getRawInputStream();
        try {
            staged = sm.stage(is, size, null, this);
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        Mailbox mailbox = this;
        synchronized (mailbox) {
            Chat chat;
            SaveChat redoRecorder = new SaveChat(this.mId, id, digest, size, -1, 0, null);
            boolean success = false;
            try {
                this.beginTransaction("saveChat", octxt, redoRecorder);
                SaveChat redoPlayer = (SaveChat)this.mCurrentChange.getRedoPlayer();
                redoRecorder.setMessageBodyInfo(new ParsedMessageDataSource(pm), size);
                Chat chat2 = (Chat)this.getItemById(id, (byte)16);
                if (!chat2.isMutable()) {
                    throw MailServiceException.IMMUTABLE_OBJECT(id);
                }
                if (!this.checkItemChangeID(chat2)) {
                    throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument[0]);
                }
                int imapID = this.getNextItemId(redoPlayer == null ? -1 : redoPlayer.getImapId());
                redoRecorder.setImapId(imapID);
                chat2.setContent(staged, pm);
                this.queueForIndexing(chat2, true, docList);
                success = true;
                chat = chat2;
                Object var19_21 = null;
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                this.endTransaction(success);
                sm.quietDelete(staged);
                throw throwable;
            }
            this.endTransaction(success);
            sm.quietDelete(staged);
            return chat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginSharedDelivery() {
        SharedDeliveryCoordinator sharedDeliveryCoordinator = this.mSharedDelivCoord;
        synchronized (sharedDeliveryCoordinator) {
            assert (this.mSharedDelivCoord.mNumDelivs >= 0);
            if (this.mSharedDelivCoord.mSharedDeliveryAllowed) {
                ++this.mSharedDelivCoord.mNumDelivs;
                if (ZimbraLog.mailbox.isDebugEnabled()) {
                    ZimbraLog.mailbox.debug("# of shared deliv incr to " + this.mSharedDelivCoord.mNumDelivs + " for mailbox " + this.getId());
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSharedDelivery() {
        SharedDeliveryCoordinator sharedDeliveryCoordinator = this.mSharedDelivCoord;
        synchronized (sharedDeliveryCoordinator) {
            --this.mSharedDelivCoord.mNumDelivs;
            if (ZimbraLog.mailbox.isDebugEnabled()) {
                ZimbraLog.mailbox.debug("# of shared deliv decr to " + this.mSharedDelivCoord.mNumDelivs + " for mailbox " + this.getId());
            }
            assert (this.mSharedDelivCoord.mNumDelivs >= 0);
            if (this.mSharedDelivCoord.mNumDelivs == 0) {
                this.mSharedDelivCoord.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSharedDeliveryAllowed(boolean onoff) {
        SharedDeliveryCoordinator sharedDeliveryCoordinator = this.mSharedDelivCoord;
        synchronized (sharedDeliveryCoordinator) {
            this.mSharedDelivCoord.mSharedDeliveryAllowed = onoff;
            this.mSharedDelivCoord.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilSharedDeliveryCompletes() {
        SharedDeliveryCoordinator sharedDeliveryCoordinator = this.mSharedDelivCoord;
        synchronized (sharedDeliveryCoordinator) {
            while (this.mSharedDelivCoord.mNumDelivs > 0) {
                try {
                    this.mSharedDelivCoord.wait(3000L);
                    ZimbraLog.misc.info("wake up from wait for completion of shared delivery; mailbox=" + this.getId() + " # of shared deliv=" + this.mSharedDelivCoord.mNumDelivs);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharedDeliveryComplete() {
        SharedDeliveryCoordinator sharedDeliveryCoordinator = this.mSharedDelivCoord;
        synchronized (sharedDeliveryCoordinator) {
            return this.mSharedDelivCoord.mNumDelivs < 1;
        }
    }

    void setCurrentChangeIndexDeferredCount(int count) {
        assert (this.mCurrentChange.isActive());
        assert (Thread.holdsLock(this));
        this.mCurrentChange.idxDeferred = count;
    }

    void setCurrentChangeHighestModContentIndexed(SyncToken token) {
        assert (this.mCurrentChange.isActive());
        assert (Thread.holdsLock(this));
        this.mCurrentChange.highestModContentIndexed = token;
    }

    SyncToken getCurrentChangeHighestModContentIndexed() {
        assert (this.mCurrentChange.isActive());
        assert (Thread.holdsLock(this));
        return this.mCurrentChange.highestModContentIndexed;
    }

    void addIndexItemToCurrentChange(IndexItemEntry item) {
        assert (this.mCurrentChange.isActive());
        assert (Thread.holdsLock(this));
        this.mCurrentChange.addIndexItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void endTransaction(boolean success) throws ServiceException {
        boolean allGood;
        RedoableOp redoRecorder;
        boolean needRedo;
        block24: {
            block25: {
                assert (Thread.holdsLock(this));
                if (!this.mCurrentChange.isActive()) {
                    ZimbraLog.mailbox.warn((Object)"cannot end a transaction when not inside a transaction", new Exception());
                    return;
                }
                if (!this.mCurrentChange.endChange()) {
                    return;
                }
                DbPool.Connection conn = this.mCurrentChange.conn;
                ServiceException exception = null;
                if (success) {
                    try {
                        this.snapshotCounts();
                    }
                    catch (ServiceException e) {
                        exception = e;
                        success = false;
                    }
                }
                if (!success) {
                    if (conn != null) {
                        DbPool.quietRollback(conn);
                    }
                    this.rollbackCache(this.mCurrentChange);
                    if (exception != null) {
                        throw exception;
                    }
                    return;
                }
                needRedo = true;
                if (this.mCurrentChange.octxt != null) {
                    needRedo = this.mCurrentChange.octxt.needRedo();
                }
                if ((redoRecorder = this.mCurrentChange.recorder) != null && needRedo) {
                    redoRecorder.log(true);
                }
                List<IndexItemEntry> itemsToIndex = this.mCurrentChange.indexItems;
                allGood = false;
                try {
                    if (!(itemsToIndex.isEmpty() && this.mCurrentChange.indexItemsToDelete.size() <= 0 || DebugConfig.disableIndexing)) {
                        this.mCurrentChange.indexItems = new ArrayList<IndexItemEntry>();
                        this.mIndexHelper.indexingPartOfEndTransaction(itemsToIndex, this.mCurrentChange.indexItemsToDelete);
                    }
                    if (conn != null) {
                        try {
                            conn.commit();
                        }
                        catch (Throwable t) {
                            Zimbra.halt("Unable to commit database transaction.  Forcing server to abort.", t);
                        }
                    }
                    allGood = true;
                    Object var10_11 = null;
                    if (allGood) break block24;
                    if (needRedo && redoRecorder != null) {
                        redoRecorder.abort();
                    }
                    if (conn == null) break block25;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (!allGood) {
                        if (needRedo && redoRecorder != null) {
                            redoRecorder.abort();
                        }
                        if (conn != null) {
                            DbPool.quietRollback(conn);
                        }
                        this.rollbackCache(this.mCurrentChange);
                    }
                    throw throwable;
                }
                DbPool.quietRollback(conn);
            }
            this.rollbackCache(this.mCurrentChange);
            {
            }
        }
        if (allGood) {
            if (needRedo && redoRecorder != null) {
                AllAccountsRedoCommitCallback cb;
                if (this.mCurrentChange.mDirty != null && this.mCurrentChange.mDirty.changedTypes != 0 && (cb = AllAccountsRedoCommitCallback.getRedoCallbackIfNecessary(this.getAccountId(), this.mCurrentChange.mDirty.changedTypes)) != null) {
                    redoRecorder.setCommitCallback(cb);
                }
                redoRecorder.commit();
            }
            this.commitCache(this.mCurrentChange);
        }
    }

    void snapshotCounts() throws ServiceException {
        RedoableOp recorder = this.mCurrentChange.recorder;
        if (recorder != null && this.mCurrentChange.getRedoPlayer() == null) {
            boolean isSoapRequest;
            boolean isNewMessage;
            boolean bl = isNewMessage = recorder.getOpCode() == 27;
            if (isNewMessage) {
                CreateMessage cm = (CreateMessage)recorder;
                if (cm.getFolderId() == 4 || cm.getFolderId() == 3) {
                    isNewMessage = false;
                } else if ((cm.getFlags() & NON_DELIVERY_FLAGS) != 0) {
                    isNewMessage = false;
                } else if (this.mCurrentChange.octxt != null && this.mCurrentChange.octxt.getSession() != null && !this.mCurrentChange.octxt.isDelegatedRequest(this)) {
                    isNewMessage = false;
                }
            }
            boolean bl2 = isSoapRequest = this.mCurrentChange.octxt != null && this.mCurrentChange.octxt.getSession() instanceof SoapSession;
            if (isNewMessage) {
                this.mCurrentChange.recent = this.mData.recentMessages + 1;
            } else if (isSoapRequest && this.mData.recentMessages != 0) {
                this.mCurrentChange.recent = 0;
            }
        }
        if (this.mCurrentChange.isMailboxRowDirty(this.mData)) {
            DbMailbox.updateMailboxStats(this);
        }
        if (this.mCurrentChange.mDirty != null && this.mCurrentChange.mDirty.hasNotifications()) {
            if (this.mCurrentChange.mDirty.created != null) {
                for (MailItem item : this.mCurrentChange.mDirty.created.values()) {
                    if (item instanceof Folder && item.getSize() != 0L) {
                        ((Folder)item).saveFolderCounts(false);
                        continue;
                    }
                    if (!(item instanceof Tag) || !item.isUnread()) continue;
                    ((Tag)item).saveTagCounts();
                }
            }
            if (this.mCurrentChange.mDirty.modified != null) {
                for (PendingModifications.Change change : this.mCurrentChange.mDirty.modified.values()) {
                    if ((change.why & 0x11) != 0 && change.what instanceof Folder) {
                        ((Folder)change.what).saveFolderCounts(false);
                        continue;
                    }
                    if ((change.why & 1) == 0 || !(change.what instanceof Tag)) continue;
                    ((Tag)change.what).saveTagCounts();
                }
            }
        }
        if (DebugConfig.checkMailboxCacheConsistency && this.mCurrentChange.mDirty != null && this.mCurrentChange.mDirty.hasNotifications()) {
            if (this.mCurrentChange.mDirty.created != null) {
                for (MailItem item : this.mCurrentChange.mDirty.created.values()) {
                    DbMailItem.consistencyCheck(item, item.mData, item.encodeMetadata());
                }
            }
            if (this.mCurrentChange.mDirty.modified != null) {
                for (PendingModifications.Change change : this.mCurrentChange.mDirty.modified.values()) {
                    if (!(change.what instanceof MailItem)) continue;
                    MailItem item = (MailItem)change.what;
                    DbMailItem.consistencyCheck(item, item.mData, item.encodeMetadata());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitCache(MailboxChange change) {
        assert (Thread.holdsLock(this));
        if (change == null) {
            return;
        }
        PendingModifications dirty = null;
        if (change.mDirty != null && change.mDirty.hasNotifications()) {
            dirty = change.mDirty;
            change.mDirty = new PendingModifications();
        }
        Session source = this.mCurrentChange.octxt == null ? null : this.mCurrentChange.octxt.getSession();
        try {
            Object var9_11;
            try {
                MailItem.PendingDelete deletes;
                if (change.sync != null) {
                    this.mData.trackSync = change.sync;
                }
                if (change.imap != null) {
                    this.mData.trackImap = change.imap;
                }
                if (change.size != -1L) {
                    this.mData.size = change.size;
                }
                if (change.itemId != -1) {
                    this.mData.lastItemId = change.itemId;
                }
                if (change.contacts != -1) {
                    this.mData.contacts = change.contacts;
                }
                if (change.changeId != -1 && change.changeId > this.mData.lastChangeId) {
                    this.mData.lastChangeId = change.changeId;
                    this.mData.lastChangeDate = change.timestamp;
                }
                if (change.accessed != -1) {
                    this.mData.lastWriteDate = change.accessed;
                }
                if (change.recent != -1) {
                    this.mData.recentMessages = change.recent;
                }
                if (change.config != null) {
                    if (change.config.getSecond() == null) {
                        if (this.mData.configKeys != null) {
                            this.mData.configKeys.remove(change.config.getFirst());
                        }
                    } else {
                        if (this.mData.configKeys == null) {
                            this.mData.configKeys = new HashSet<String>(1);
                        }
                        this.mData.configKeys.add(change.config.getFirst());
                    }
                }
                if (change.idxDeferred != -1) {
                    this.mData.idxDeferredCount = change.idxDeferred;
                }
                if (change.highestModContentIndexed != null) {
                    this.mData.highestModContentIndexed = change.highestModContentIndexed;
                }
                if ((deletes = this.mCurrentChange.deletes) != null && deletes.indexIds != null && !deletes.indexIds.isEmpty()) {
                    try {
                        List<String> idxDeleted = this.mIndexHelper.deleteDocuments(deletes.indexIds);
                        if (idxDeleted.size() != deletes.indexIds.size() && ZimbraLog.index_add.isInfoEnabled()) {
                            ZimbraLog.index_add.info("could not delete all index entries for items: " + deletes.itemIds.getAll());
                        }
                    }
                    catch (IOException e) {
                        ZimbraLog.index_add.info((Object)("ignoring error while deleting index entries for items: " + deletes.itemIds.getAll()), e);
                    }
                }
                if (deletes != null && deletes.blobs != null) {
                    for (String digest : deletes.blobDigests) {
                        MessageCache.purge(digest);
                    }
                }
                StoreManager sm = StoreManager.getInstance();
                if (deletes != null && deletes.blobs != null) {
                    for (MailboxBlob mblob : deletes.blobs) {
                        sm.quietDelete(mblob);
                    }
                }
                var9_11 = null;
            }
            catch (RuntimeException e) {
                ZimbraLog.mailbox.error((Object)"ignoring error during cache commit", e);
                var9_11 = null;
                this.trimItemCache();
                change.reset();
            }
            this.trimItemCache();
            change.reset();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.trimItemCache();
            change.reset();
            throw throwable;
        }
        if (dirty != null && dirty.hasNotifications()) {
            FreeBusyProvider.mailboxChanged(this.getAccountId(), dirty.changedTypes);
            MailboxListener.mailboxChanged(this.getAccountId(), dirty.changedTypes, change.octxt);
        }
        if (!this.mListeners.isEmpty() && dirty != null && dirty.hasNotifications()) {
            for (Session session : this.mListeners) {
                try {
                    session.notifyPendingChanges(dirty, this.mData.lastChangeId, source);
                }
                catch (RuntimeException e) {
                    ZimbraLog.mailbox.error((Object)"ignoring error during notification", e);
                }
            }
        }
        if (dirty != null) {
            MemcachedCacheManager.notifyCommittedChanges(dirty, this.mData.lastChangeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackCache(MailboxChange change) {
        if (change == null) {
            return;
        }
        try {
            try {
                Map<Integer, MailItem> cache = change.itemCache;
                for (Map map : new Map[]{change.mDirty.created, change.mDirty.deleted, change.mDirty.modified}) {
                    if (map == null) continue;
                    for (Object obj : map.values()) {
                        if (obj instanceof PendingModifications.Change) {
                            obj = ((PendingModifications.Change)obj).what;
                        }
                        if (obj instanceof Tag) {
                            this.purge((byte)3);
                            continue;
                        }
                        if (obj instanceof Folder) {
                            this.purge((byte)1);
                            continue;
                        }
                        if (obj instanceof MailItem && cache != null) {
                            cache.remove(new Integer(((MailItem)obj).getId()));
                            continue;
                        }
                        if (!(obj instanceof Integer) || cache == null) continue;
                        cache.remove(obj);
                    }
                }
                StoreManager sm = StoreManager.getInstance();
                for (Object obj : change.mOtherDirtyStuff) {
                    if (obj instanceof MailboxBlob) {
                        sm.quietDelete((MailboxBlob)obj);
                        continue;
                    }
                    if (obj instanceof Blob) {
                        sm.quietDelete((Blob)obj);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    this.mConvHashes.remove(obj);
                }
                Object var10_12 = null;
            }
            catch (RuntimeException e) {
                ZimbraLog.mailbox.error((Object)"ignoring error during cache rollback", e);
                Object var10_13 = null;
                this.trimItemCache();
                change.reset();
            }
            this.trimItemCache();
            change.reset();
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.trimItemCache();
            change.reset();
            throw throwable;
        }
    }

    private void trimItemCache() {
        try {
            int sizeTarget = this.mListeners.isEmpty() ? MAX_ITEM_CACHE_WITHOUT_LISTENERS : MAX_ITEM_CACHE_WITH_LISTENERS;
            Map<Integer, MailItem> cache = this.mCurrentChange.itemCache;
            if (cache == null) {
                return;
            }
            int excess = cache.size() - sizeTarget;
            if (excess <= 0) {
                return;
            }
            MailItem[] overflow = new MailItem[excess];
            int i = 0;
            for (MailItem item : cache.values()) {
                overflow[i++] = item;
                if (i < excess) continue;
                break;
            }
            while (--i >= 0) {
                if (cache.size() <= sizeTarget) {
                    return;
                }
                try {
                    this.uncache(overflow[i]);
                }
                catch (ServiceException e) {}
            }
        }
        catch (RuntimeException e) {
            ZimbraLog.mailbox.error((Object)"ignoring error during item cache trim", e);
        }
    }

    public boolean attachmentsIndexingEnabled() throws ServiceException {
        return this.getAccount().getBooleanAttr("zimbraAttachmentsIndexingEnabled", true);
    }

    private void logCacheActivity(Integer key, byte type, MailItem item) {
        if (!Mailbox.isCachedType(type)) {
            ZimbraPerf.COUNTER_MBOX_ITEM_CACHE.increment(item == null ? 0L : 100L);
        }
        if (!ZimbraLog.cache.isDebugEnabled()) {
            return;
        }
        if (item == null) {
            ZimbraLog.cache.debug("Cache miss for item " + key + " in mailbox " + this.getId());
            return;
        }
        if (Mailbox.isCachedType(type)) {
            return;
        }
        ZimbraLog.cache.debug("Cache hit for " + MailItem.getNameForType(type) + " " + key + " in mailbox " + this.getId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mailbox: {");
        sb.append(CN_ID).append(": ").append(this.mId).append(", ");
        sb.append(CN_ACCOUNT_ID).append(": ").append(this.mData.accountId).append(", ");
        sb.append(CN_NEXT_ID).append(": ").append(this.mData.lastItemId).append(", ");
        sb.append(CN_SIZE).append(": ").append(this.mData.size);
        sb.append("}");
        return sb.toString();
    }

    private static class SharedDeliveryCoordinator {
        public int mNumDelivs = 0;
        public boolean mSharedDeliveryAllowed = true;
    }

    public static class SetCalendarItemData {
        public Invite mInv;
        public ParsedMessage mPm;

        public String toString() {
            StringBuilder toRet = new StringBuilder();
            toRet.append("inv:").append(this.mInv.toString());
            toRet.append(", hasBody:").append(this.mPm != null).append("\n");
            return toRet.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BrowseBy {
        attachments,
        domains,
        objects;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchResultMode {
        NORMAL,
        IMAP,
        MODSEQ,
        PARENT,
        IDS;


        public static SearchResultMode get(String value) throws ServiceException {
            if (value == null) {
                return NORMAL;
            }
            try {
                return SearchResultMode.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("Unknown resultMode value: " + value, null);
            }
        }
    }

    public static class FolderNode {
        public int mId;
        public String mName;
        public Folder mFolder;
        public List<FolderNode> mSubfolders = new ArrayList<FolderNode>();
    }

    public static class BatchedIndexStatus {
        public int mNumProcessed = 0;
        public int mNumToProcess = 0;
        public int mNumFailed = 0;
        public boolean mCancel = false;

        public String toString() {
            String status = "Completed " + this.mNumProcessed + " out of " + this.mNumToProcess + " (" + this.mNumFailed + " failures)";
            return (this.mCancel ? "--CANCELLING--  " : "") + status;
        }

        public Object clone() {
            BatchedIndexStatus toRet = new BatchedIndexStatus();
            toRet.mNumProcessed = this.mNumProcessed;
            toRet.mNumToProcess = this.mNumToProcess;
            toRet.mNumFailed = this.mNumFailed;
            return toRet;
        }
    }

    private final class MailboxChange {
        private static final int NO_CHANGE = -1;
        long timestamp = System.currentTimeMillis();
        int depth = 0;
        boolean active;
        DbPool.Connection conn = null;
        RedoableOp recorder = null;
        List<IndexItemEntry> indexItems = new ArrayList<IndexItemEntry>();
        List<String> indexItemsToDelete = new ArrayList<String>();
        Map<Integer, MailItem> itemCache = null;
        OperationContext octxt = null;
        MailItem.TargetConstraint tcon = null;
        Integer sync = null;
        Boolean imap = null;
        long size = -1L;
        int itemId = -1;
        int changeId = -1;
        int contacts = -1;
        int accessed = -1;
        int recent = -1;
        int idxDeferred = -1;
        SyncToken highestModContentIndexed = null;
        Pair<String, Metadata> config = null;
        PendingModifications mDirty = new PendingModifications();
        List<Object> mOtherDirtyStuff = new LinkedList<Object>();
        MailItem.PendingDelete deletes = null;

        MailboxChange() {
        }

        void setTimestamp(long millis) {
            if (this.depth == 1) {
                this.timestamp = millis;
            }
        }

        void startChange(String caller, OperationContext ctxt, RedoableOp op) {
            this.active = true;
            if (this.depth++ == 0) {
                this.octxt = ctxt;
                this.recorder = op;
                if (ZimbraLog.mailbox.isDebugEnabled()) {
                    ZimbraLog.mailbox.debug("beginning operation: " + caller);
                }
            } else if (ZimbraLog.mailbox.isDebugEnabled()) {
                ZimbraLog.mailbox.debug("  increasing stack depth to " + this.depth + " (" + caller + ')');
            }
        }

        boolean endChange() {
            if (ZimbraLog.mailbox.isDebugEnabled()) {
                if (this.depth <= 1) {
                    if (ZimbraLog.mailbox.isDebugEnabled()) {
                        ZimbraLog.mailbox.debug("ending operation" + (this.recorder == null ? "" : ": " + StringUtil.getSimpleClassName(this.recorder)));
                    }
                } else if (ZimbraLog.mailbox.isDebugEnabled()) {
                    ZimbraLog.mailbox.debug("  decreasing stack depth to " + (this.depth - 1));
                }
            }
            return --this.depth == 0;
        }

        boolean isActive() {
            return this.active;
        }

        DbPool.Connection getConnection() throws ServiceException {
            if (this.conn == null) {
                this.conn = DbPool.getConnection(Mailbox.this);
                if (ZimbraLog.mailbox.isDebugEnabled()) {
                    ZimbraLog.mailbox.debug("  fetching new DB connection");
                }
            }
            return this.conn;
        }

        RedoableOp getRedoPlayer() {
            return this.octxt == null ? null : this.octxt.getPlayer();
        }

        RedoableOp getRedoRecorder() {
            return this.recorder;
        }

        void addIndexItem(IndexItemEntry item) {
            this.indexItems.add(item);
        }

        void addIndexDelete(String id) {
            this.indexItemsToDelete.add(id);
        }

        void addPendingDelete(MailItem.PendingDelete info) {
            if (this.deletes == null) {
                this.deletes = info;
            } else {
                this.deletes.add(info);
            }
        }

        boolean isMailboxRowDirty(MailboxData data) {
            if (this.recent != -1 || this.size != -1L || this.contacts != -1 || this.idxDeferred != -1 || this.highestModContentIndexed != null) {
                return true;
            }
            if (this.itemId != -1 && this.itemId / 20 > data.lastItemId / 20) {
                return true;
            }
            return this.changeId != -1 && this.changeId / DbMailbox.CHANGE_CHECKPOINT_INCREMENT > data.lastChangeId / DbMailbox.CHANGE_CHECKPOINT_INCREMENT;
        }

        void reset() {
            if (this.conn != null) {
                DbPool.quietClose(this.conn);
            }
            this.active = false;
            this.conn = null;
            this.octxt = null;
            this.tcon = null;
            this.depth = 0;
            this.idxDeferred = -1;
            this.recent = -1;
            this.accessed = -1;
            this.contacts = -1;
            this.itemId = -1;
            this.changeId = -1;
            this.size = -1;
            this.sync = null;
            this.config = null;
            this.deletes = null;
            this.itemCache = null;
            this.indexItems.clear();
            this.indexItemsToDelete.clear();
            this.mDirty.clear();
            this.mOtherDirtyStuff.clear();
            this.highestModContentIndexed = null;
            if (ZimbraLog.mailbox.isDebugEnabled()) {
                ZimbraLog.mailbox.debug("clearing change");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IndexItemEntry {
        final boolean mDeleteFirst;
        final List<IndexDocument> mDocuments;
        final MailItem mMailItem;
        int mModContent;

        IndexItemEntry(boolean deleteFirst, MailItem mi, int modContent, List<IndexDocument> docList) {
            this.mMailItem = mi;
            this.mDeleteFirst = deleteFirst;
            this.mDocuments = docList;
            this.mModContent = modContent;
        }

        public String toString() {
            return "IndexItemEntry(" + (this.mDeleteFirst ? "TRUE" : "FALSE") + "," + this.mMailItem.getId() + "-" + this.mModContent + ")";
        }
    }

    public static final class MailboxData
    implements Cloneable {
        public long id;
        public long schemaGroupId;
        public String accountId;
        public long size;
        public int contacts;
        public short indexVolumeId;
        public int lastBackupDate;
        public int lastItemId;
        public int lastChangeId;
        public long lastChangeDate;
        public int lastWriteDate;
        public int recentMessages;
        public int trackSync;
        public boolean trackImap;
        public int idxDeferredCount;
        public SyncToken highestModContentIndexed = new SyncToken(0);
        public Set<String> configKeys;

        protected MailboxData clone() {
            MailboxData mbd = new MailboxData();
            mbd.id = this.id;
            mbd.schemaGroupId = this.schemaGroupId;
            mbd.accountId = this.accountId;
            mbd.size = this.size;
            mbd.contacts = this.contacts;
            mbd.indexVolumeId = this.indexVolumeId;
            mbd.lastItemId = this.lastItemId;
            mbd.lastChangeId = this.lastChangeId;
            mbd.lastChangeDate = this.lastChangeDate;
            mbd.lastWriteDate = this.lastWriteDate;
            mbd.recentMessages = this.recentMessages;
            mbd.trackSync = this.trackSync;
            mbd.trackImap = this.trackImap;
            mbd.idxDeferredCount = this.idxDeferredCount;
            mbd.highestModContentIndexed = this.highestModContentIndexed.clone();
            if (this.configKeys != null) {
                mbd.configKeys = new HashSet<String>(this.configKeys);
            }
            return mbd;
        }
    }
}

