/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.index.ContactHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.ContactAutoComplete;
import com.zimbra.cs.mailbox.ContactRankings;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Notification;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.mime.ParsedAddress;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.zclient.ZContactHit;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSender {
    public static final String MSGTYPE_REPLY = Flag.getAbbreviation(-3) + "";
    public static final String MSGTYPE_FORWARD = Flag.getAbbreviation(-4) + "";
    private Boolean mSaveToSent;
    private Collection<InternetAddress> mSaveContacts;
    private Collection<FileUploadServlet.Upload> mUploads;
    private ItemId mOriginalMessageId;
    private String mReplyType;
    private Identity mIdentity;
    private boolean mIgnoreFailedAddresses = false;
    private boolean mReplyToSender = false;
    private boolean mSkipSendAsCheck = false;
    private List<String> mSmtpHosts = new ArrayList<String>();
    private Session mSession;
    private boolean mTrackBadHosts = true;
    public static final String X_ORIGINATING_IP = "X-Originating-IP";
    private static final String X_MAILER = "X-Mailer";
    public static final String X_AUTHENTICATED_USER = "X-Authenticated-User";

    public MailSender setSaveContacts(Collection<InternetAddress> saveContacts) {
        this.mSaveContacts = saveContacts;
        return this;
    }

    public MailSender setUploads(Collection<FileUploadServlet.Upload> uploads) {
        this.mUploads = uploads;
        return this;
    }

    public MailSender setOriginalMessageId(ItemId id) {
        this.mOriginalMessageId = id;
        return this;
    }

    public MailSender setReplyType(String replyType) {
        this.mReplyType = replyType;
        return this;
    }

    public MailSender setIdentity(Identity identity) {
        this.mIdentity = identity;
        return this;
    }

    public MailSender setIgnoreFailedAddresses(boolean ignore) {
        this.mIgnoreFailedAddresses = ignore;
        return this;
    }

    public MailSender setReplyToSender(boolean replyToSender) {
        this.mReplyToSender = replyToSender;
        return this;
    }

    public MailSender setSkipSendAsCheck(boolean skip) {
        this.mSkipSendAsCheck = skip;
        return this;
    }

    public MailSender setSaveToSent(boolean saveToSent) {
        this.mSaveToSent = saveToSent;
        return this;
    }

    public MailSender setSmtpHosts(Collection<String> hosts) {
        this.mSmtpHosts.clear();
        this.mSmtpHosts.addAll(hosts);
        return this;
    }

    public MailSender setTrackBadHosts(boolean track) {
        this.mTrackBadHosts = track;
        return this;
    }

    public MailSender setSession(Session session) {
        this.mSession = session;
        return this;
    }

    public static int getSentFolderId(Mailbox mbox, Identity identity) throws ServiceException {
        int folderId = 5;
        String sentFolder = identity.getAttr("zimbraPrefSentMailFolder", null);
        if (sentFolder != null) {
            try {
                folderId = mbox.getFolderByPath(null, sentFolder).getId();
            }
            catch (MailServiceException.NoSuchItemException nsie) {
                // empty catch block
            }
        }
        return folderId;
    }

    public ItemId sendMimeMessage(OperationContext octxt, Mailbox mbox, MimeMessage mm, List<InternetAddress> newContacts, List<FileUploadServlet.Upload> uploads, ItemId origMsgId, String replyType, String identityId, boolean ignoreFailedAddresses, boolean replyToSender) throws ServiceException {
        Account authuser;
        Account account = authuser = octxt == null ? null : octxt.getAuthenticatedUser();
        if (authuser == null) {
            authuser = mbox.getAccount();
        }
        Identity identity = null;
        if (identityId != null) {
            identity = Provisioning.getInstance().get(authuser, Provisioning.IdentityBy.id, identityId);
        }
        return this.sendMimeMessage(octxt, mbox, null, mm, newContacts, uploads, origMsgId, replyType, identity, ignoreFailedAddresses, replyToSender);
    }

    public ItemId sendMimeMessage(OperationContext octxt, Mailbox mbox, Boolean saveToSent, MimeMessage mm, Collection<InternetAddress> saveContacts, Collection<FileUploadServlet.Upload> uploads, ItemId origMsgId, String replyType, Identity identity, boolean ignoreFailedAddresses, boolean replyToSender) throws ServiceException {
        this.mSaveToSent = saveToSent;
        this.mSaveContacts = saveContacts;
        this.mUploads = uploads;
        this.mOriginalMessageId = origMsgId;
        this.mReplyType = replyType;
        this.mIdentity = identity;
        this.mIgnoreFailedAddresses = ignoreFailedAddresses;
        this.mReplyToSender = replyToSender;
        return this.sendMimeMessage(octxt, mbox, mm);
    }

    public ItemId sendMimeMessage(OperationContext octxt, Mailbox mbox, MimeMessage mm) throws ServiceException {
        try {
            int flags;
            boolean isDelegatedRequest;
            boolean isAdminRequest;
            Account acct = mbox.getAccount();
            Account authuser = octxt == null ? null : octxt.getAuthenticatedUser();
            boolean bl = isAdminRequest = octxt == null ? false : octxt.isUsingAdminPrivileges();
            if (authuser == null) {
                authuser = acct;
            }
            boolean bl2 = isDelegatedRequest = !acct.getId().equalsIgnoreCase(authuser.getId());
            if (this.mSaveToSent == null) {
                this.mSaveToSent = authuser.getBooleanAttr("zimbraPrefSaveToSent", true);
            }
            int convId = -1;
            if (this.mOriginalMessageId != null && !isDelegatedRequest && this.mOriginalMessageId.belongsTo(mbox)) {
                convId = mbox.getConversationIdFromReferent(mm, this.mOriginalMessageId.getId());
            }
            if (mm instanceof Mime.FixedMimeMessage && this.mSession != null) {
                ZimbraLog.smtp.debug("setting alternate Session on the FixedMimeMessage");
                ((Mime.FixedMimeMessage)mm).setSession(this.mSession);
            }
            this.updateHeaders(mm, acct, authuser, octxt, octxt != null ? octxt.getRequestIP() : null, this.mReplyToSender, this.mSkipSendAsCheck);
            try {
                for (Class<? extends MimeVisitor> vclass : MimeVisitor.getMutators()) {
                    vclass.newInstance().accept(mm);
                }
            }
            catch (Exception e) {
                ZimbraLog.smtp.warn((Object)"failure to modify outbound message; aborting send", e);
                throw ServiceException.FAILURE("mutator error; aborting send", e);
            }
            boolean hasRecipients = mm.getAllRecipients() != null;
            this.mSaveToSent = this.mSaveToSent & hasRecipients;
            RollbackData[] rollback = new RollbackData[2];
            Object authMailbox = isDelegatedRequest ? null : mbox;
            ParsedMessage pm = null;
            if (this.mSaveToSent.booleanValue()) {
                if (this.mIdentity == null) {
                    this.mIdentity = Provisioning.getInstance().getDefaultIdentity(authuser);
                }
                if (authMailbox == null) {
                    authMailbox = this.getAuthenticatedMailbox(octxt, authuser, isAdminRequest);
                }
                if (authMailbox instanceof Mailbox) {
                    Mailbox mboxSave = authMailbox;
                    flags = Flag.BITMASK_FROM_ME;
                    pm = new ParsedMessage(mm, mm.getSentDate().getTime(), mboxSave.attachmentsIndexingEnabled());
                    int sentFolderId = MailSender.getSentFolderId(mboxSave, this.mIdentity);
                    Message msg = mboxSave.addMessage(octxt, pm, sentFolderId, true, flags, null, convId);
                    rollback[0] = new RollbackData(msg);
                } else if (authMailbox instanceof ZMailbox) {
                    ZMailbox zmbxSave = (ZMailbox)authMailbox;
                    pm = new ParsedMessage(mm, mm.getSentDate().getTime(), mbox.attachmentsIndexingEnabled());
                    String sentFolder = this.mIdentity.getAttr("zimbraPrefSentMailFolder", "5");
                    String msgId = zmbxSave.addMessage(sentFolder, "s", null, mm.getSentDate().getTime(), pm.getRawData(), true);
                    rollback[0] = new RollbackData(zmbxSave, authuser, msgId);
                }
            }
            Message msg = null;
            if (hasRecipients && isDelegatedRequest && mm.getSender() != null && acct.getBooleanAttr("zimbraPrefSaveToSent", true)) {
                flags = Flag.BITMASK_UNREAD | Flag.BITMASK_FROM_ME;
                OperationContext octxtTarget = new OperationContext(acct);
                if (pm == null || pm.isAttachmentIndexingEnabled() != mbox.attachmentsIndexingEnabled()) {
                    pm = new ParsedMessage(mm, mm.getSentDate().getTime(), mbox.attachmentsIndexingEnabled());
                }
                int sentFolderId = MailSender.getSentFolderId(mbox, Provisioning.getInstance().getDefaultIdentity(acct));
                msg = mbox.addMessage(octxtTarget, pm, sentFolderId, true, flags, null, convId);
                rollback[1] = new RollbackData(msg);
            }
            this.logMessage(mm, this.mOriginalMessageId, this.mUploads, this.mReplyType);
            Collection<Address> sentAddresses = this.sendMessage(mbox, mm, this.mIgnoreFailedAddresses, rollback);
            if (!sentAddresses.isEmpty() && octxt != null) {
                try {
                    ContactRankings.increment(octxt.getAuthenticatedUser().getId(), sentAddresses);
                }
                catch (Exception e) {
                    ZimbraLog.smtp.error((Object)"unable to update contact rankings", e);
                }
                if (authuser.getBooleanAttr("zimbraPrefAutoAddAddressEnabled", false)) {
                    List<InternetAddress> newContacts = this.getNewContacts(sentAddresses, authuser, octxt, authMailbox);
                    this.saveNewContacts(newContacts, octxt, authMailbox);
                }
            }
            if (!this.mSaveToSent.booleanValue()) {
                try {
                    Notification.getInstance().interceptIfNecessary(mbox, mm, "send message", null);
                }
                catch (ServiceException e) {
                    ZimbraLog.mailbox.error((Object)"Unable to send lawful intercept message.", e);
                }
            }
            if (this.mOriginalMessageId != null && !isDelegatedRequest && this.mOriginalMessageId.belongsTo(mbox)) {
                try {
                    if (MSGTYPE_REPLY.equals(this.mReplyType)) {
                        mbox.alterTag(octxt, this.mOriginalMessageId.getId(), (byte)5, -3, true);
                    } else if (MSGTYPE_FORWARD.equals(this.mReplyType)) {
                        mbox.alterTag(octxt, this.mOriginalMessageId.getId(), (byte)5, -4, true);
                    }
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
            if (this.mUploads != null) {
                FileUploadServlet.deleteUploads(this.mUploads);
            }
            return rollback[0] != null ? rollback[0].msgId : null;
        }
        catch (SafeSendFailedException sfe) {
            Address[] invalidAddrs = sfe.getInvalidAddresses();
            Address[] validUnsentAddrs = sfe.getValidUnsentAddresses();
            if (invalidAddrs != null && invalidAddrs.length > 0) {
                StringBuilder msg = new StringBuilder("Invalid address").append(invalidAddrs.length > 1 ? "es: " : ": ");
                for (int i = 0; i < invalidAddrs.length; ++i) {
                    if (i > 0) {
                        msg.append(",");
                    }
                    msg.append(invalidAddrs[i]);
                }
                msg.append(".  ").append(sfe.toString());
                if (Provisioning.getInstance().getLocalServer().isSmtpSendPartial()) {
                    throw MailServiceException.SEND_PARTIAL_ADDRESS_FAILURE(msg.toString(), (Exception)((Object)sfe), invalidAddrs, validUnsentAddrs);
                }
                throw MailServiceException.SEND_ABORTED_ADDRESS_FAILURE(msg.toString(), (Exception)((Object)sfe), invalidAddrs, validUnsentAddrs);
            }
            throw MailServiceException.SEND_FAILURE("SMTP server reported: " + sfe.getMessage(), (Exception)((Object)sfe), invalidAddrs, validUnsentAddrs);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("Unable to send message", ioe);
        }
        catch (MessagingException me) {
            Exception chained = me.getNextException();
            if (chained instanceof ConnectException || chained instanceof UnknownHostException) {
                throw MailServiceException.TRY_AGAIN("Unable to connect to the MTA", chained);
            }
            throw ServiceException.FAILURE("Unable to send message", me);
        }
    }

    private Object getAuthenticatedMailbox(OperationContext octxt, Account authuser, boolean isAdminRequest) {
        try {
            if (Provisioning.onLocalServer(authuser)) {
                return MailboxManager.getInstance().getMailboxByAccount(authuser);
            }
            String uri = AccountUtil.getSoapUri(authuser);
            if (uri == null) {
                return null;
            }
            AuthToken authToken = null;
            if (octxt != null) {
                authToken = octxt.getAuthToken(false);
            }
            if (authToken == null) {
                authToken = AuthProvider.getAuthToken(authuser, isAdminRequest);
            }
            ZMailbox.Options options = new ZMailbox.Options(authToken.toZAuthToken(), uri);
            options.setNoSession(true);
            return ZMailbox.getMailbox(options);
        }
        catch (Exception e) {
            ZimbraLog.smtp.info((Object)"could not fetch home mailbox for delegated send", e);
            return null;
        }
    }

    public void logMessage(MimeMessage mm, ItemId origMsgId, Collection<FileUploadServlet.Upload> uploads, String replyType) {
        if (ZimbraLog.smtp.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder("Sending message");
            if (mm instanceof Mime.FixedMimeMessage) {
                Session session = ((Mime.FixedMimeMessage)mm).getSession();
                msg.append(String.format(" to MTA at %s, port %s", session.getProperty("mail.smtp.host"), session.getProperty("mail.smtp.port")));
            }
            try {
                msg.append(": Message-ID=" + mm.getMessageID());
            }
            catch (MessagingException e) {
                msg.append((Object)e);
            }
            if (origMsgId != null) {
                msg.append(", origMsgId=" + origMsgId);
            }
            if (uploads != null && uploads.size() > 0) {
                msg.append(", uploads=" + uploads);
            }
            if (replyType != null) {
                msg.append(", replyType=" + replyType);
            }
            ZimbraLog.smtp.info(msg);
        }
    }

    public static String formatXOrigIpHeader(String origIp) {
        return "[" + origIp + "]";
    }

    void updateHeaders(MimeMessage mm, Account acct, Account authuser, OperationContext octxt, String originIP, boolean replyToSender, boolean skipSendAsCheck) throws MessagingException, ServiceException {
        Address addr;
        boolean overrideFromHeader;
        boolean addMailer;
        boolean addOriginatingIP;
        Provisioning prov = Provisioning.getInstance();
        if (originIP != null && (addOriginatingIP = prov.getConfig().getBooleanAttr("zimbraSmtpSendAddOriginatingIP", true))) {
            mm.addHeader(X_ORIGINATING_IP, MailSender.formatXOrigIpHeader(originIP));
        }
        if (addMailer = prov.getConfig().getBooleanAttr("zimbraSmtpSendAddMailer", true)) {
            String ua = octxt != null ? octxt.getUserAgent() : null;
            String mailer = "Zimbra " + BuildInfo.VERSION + (ua == null ? "" : " (" + ua + ")");
            mm.addHeader(X_MAILER, mailer);
        }
        if (prov.getConfig().getBooleanAttr("zimbraSmtpSendAddAuthenticatedUser", false)) {
            mm.addHeader(X_AUTHENTICATED_USER, authuser.getName());
        }
        if (skipSendAsCheck) {
            overrideFromHeader = false;
        } else {
            overrideFromHeader = true;
            try {
                InternetAddress from;
                String fromHdr = mm.getHeader("From", null);
                if (fromHdr != null && !fromHdr.equals("") && AccountUtil.allowFromAddress(acct, (from = new InternetAddress(fromHdr)).getAddress())) {
                    overrideFromHeader = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean isAdminRequest = octxt == null ? false : octxt.isUsingAdminPrivileges();
        boolean isDelegatedRequest = !acct.getId().equalsIgnoreCase(authuser.getId());
        boolean canSendAs = !isDelegatedRequest || AccessManager.getInstance().canDo(authuser, (Entry)acct, (Right)Rights.User.R_sendAs, isAdminRequest);
        InternetAddress sender = null;
        if (skipSendAsCheck) {
            addr = mm.getSender();
            if (addr != null && addr instanceof InternetAddress) {
                sender = (InternetAddress)addr;
            }
        } else {
            InternetAddress internetAddress = sender = canSendAs ? null : AccountUtil.getFriendlyEmailAddress(authuser);
            if (canSendAs && (addr = mm.getSender()) != null && addr instanceof InternetAddress && AccountUtil.addressMatchesAccount(authuser, ((InternetAddress)addr).getAddress())) {
                sender = (InternetAddress)addr;
            }
        }
        if (overrideFromHeader) {
            mm.setFrom((Address)AccountUtil.getFriendlyEmailAddress(acct));
        }
        mm.setSentDate(new Date());
        mm.setSender((Address)sender);
        if (sender == null) {
            String replyTo;
            Address[] existingReplyTos = mm.getReplyTo();
            if (!(existingReplyTos != null && existingReplyTos.length != 0 || (replyTo = acct.getAttr("zimbraPrefReplyToAddress")) == null || replyTo.trim().equals(""))) {
                mm.setHeader("Reply-To", replyTo);
            }
        } else if (replyToSender) {
            mm.setReplyTo(new Address[]{sender});
        }
        if (mm instanceof Mime.FixedMimeMessage) {
            Mime.FixedMimeMessage fmm = (Mime.FixedMimeMessage)mm;
            Session session = fmm.getSession() != null ? fmm.getSession() : JMSession.getSession();
            String mailfrom = (sender != null ? sender : AccountUtil.getFriendlyEmailAddress(authuser)).getAddress();
            session.getProperties().setProperty("mail.smtp.from", mailfrom);
            fmm.setSession(session);
        }
        mm.saveChanges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection<Address> sendMessage(Mailbox mbox, MimeMessage mm, boolean ignoreFailedAddresses, RollbackData[] rollback) throws SafeMessagingException, IOException {
        HashSet<Address> sentAddresses = new HashSet<Address>();
        try {
            Address[] rcptAddresses = mm.getAllRecipients();
            while (rcptAddresses != null && rcptAddresses.length > 0) {
                try {
                    Transport.send((javax.mail.Message)mm, (Address[])rcptAddresses);
                    sentAddresses.addAll(Arrays.asList(rcptAddresses));
                    return sentAddresses;
                }
                catch (SendFailedException sfe) {
                    if (!ignoreFailedAddresses) {
                        throw sfe;
                    }
                    rcptAddresses = sfe.getValidUnsentAddresses();
                    Address[] sent = sfe.getValidSentAddresses();
                    if (sent == null || sent.length <= 0) continue;
                    sentAddresses.addAll(Arrays.asList(sent));
                }
                catch (MessagingException e) {
                    Exception chained = e.getNextException();
                    if (!(chained instanceof ConnectException) && !(chained instanceof UnknownHostException)) throw e;
                    ZimbraLog.smtp.warn("Unable to connect to SMTP server: %s.", chained.toString());
                    if (!(mm instanceof Mime.FixedMimeMessage)) {
                        ZimbraLog.smtp.warn("SMTP retry not supported for %s.", mm.getClass().getName());
                        throw e;
                    }
                    String newHost = this.updateSmtpHost((Mime.FixedMimeMessage)mm, mbox, e);
                    ZimbraLog.smtp.info("Attempting to send to %s.", newHost);
                    continue;
                    return sentAddresses;
                }
            }
        }
        catch (SendFailedException e) {
            for (RollbackData rdata : rollback) {
                if (rdata == null) continue;
                rdata.rollback();
            }
            throw new SafeSendFailedException(e);
        }
        catch (MessagingException e) {
            for (RollbackData rdata : rollback) {
                if (rdata == null) continue;
                rdata.rollback();
            }
            throw new SafeMessagingException(e);
        }
        catch (RuntimeException e) {
            for (RollbackData rdata : rollback) {
                if (rdata == null) continue;
                rdata.rollback();
            }
            throw e;
        }
    }

    private String updateSmtpHost(Mime.FixedMimeMessage mm, Mailbox mbox, MessagingException originalException) throws MessagingException {
        Session session = mm.getSession();
        String badHost = session.getProperty("mail.smtp.host");
        this.mSmtpHosts.remove(badHost);
        if (this.mTrackBadHosts) {
            JMSession.markSmtpHostBad(badHost);
        }
        if (this.mSmtpHosts.isEmpty()) {
            ZimbraLog.smtp.error("No alternate SMTP host available.");
            throw originalException;
        }
        String newHost = this.mSmtpHosts.remove(0);
        session.getProperties().setProperty("mail.smtp.host", newHost);
        return newHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InternetAddress> getNewContacts(Collection<Address> contacts, Account authuser, OperationContext octxt, Object authmbox) {
        HashMap<String, InternetAddress> newContacts;
        block24: {
            if (contacts.isEmpty()) {
                return Collections.emptyList();
            }
            newContacts = new HashMap<String, InternetAddress>();
            Collection<String> emailKeys = new ContactAutoComplete(authuser.getId()).getEmailKeys();
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (Address addr : contacts) {
                if (!(addr instanceof InternetAddress)) continue;
                InternetAddress iaddr = (InternetAddress)addr;
                String email = iaddr.getAddress();
                newContacts.put(email, iaddr);
                for (String emailKey : emailKeys) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(" OR ");
                    }
                    buf.append("#").append(emailKey).append(":").append(email);
                }
            }
            byte[] types = new byte[]{6};
            String query = buf.toString();
            try {
                if (authmbox instanceof Mailbox) {
                    Mailbox mbox = (Mailbox)authmbox;
                    ZimbraQueryResults qres = null;
                    try {
                        qres = mbox.search(octxt, query, types, SortBy.NONE, contacts.size());
                        while (qres.hasNext()) {
                            ZimbraHit hit = qres.getNext();
                            if (!(hit instanceof ContactHit)) continue;
                            Contact c = ((ContactHit)hit).getContact();
                            for (String emailKey : emailKeys) {
                                String v = c.get(emailKey);
                                if (v == null) continue;
                                newContacts.remove(v);
                            }
                        }
                        Object var19_23 = null;
                        if (qres == null) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var19_24 = null;
                        if (qres == null) throw throwable;
                        try {
                            qres.doneWithSearchResults();
                            throw throwable;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (Exception e) {}
                    qres.doneWithSearchResults();
                    break block24;
                }
                if (authmbox instanceof ZMailbox) {
                    ZMailbox zmbox = (ZMailbox)authmbox;
                    ZSearchResult res = zmbox.search(new ZSearchParams(query));
                    for (ZSearchHit hit : res.getHits()) {
                        if (!(hit instanceof ZContactHit)) continue;
                        ZContactHit c = (ZContactHit)hit;
                        String v = c.getEmail();
                        if (v != null) {
                            newContacts.remove(v);
                        }
                        if ((v = c.getEmail2()) != null) {
                            newContacts.remove(v);
                        }
                        if ((v = c.getEmail3()) != null) {
                            newContacts.remove(v);
                        }
                        if ((v = c.getWorkEmail1()) != null) {
                            newContacts.remove(v);
                        }
                        if ((v = c.getWorkEmail2()) != null) {
                            newContacts.remove(v);
                        }
                        if ((v = c.getWorkEmail3()) == null) continue;
                        newContacts.remove(v);
                    }
                }
            }
            catch (ServiceException e) {
                ZimbraLog.smtp.warn((Object)"ignoring error while auto-adding contact", e);
                newContacts.clear();
            }
            catch (IOException e) {
                ZimbraLog.smtp.warn((Object)"ignoring error while auto-adding contact", e);
                newContacts.clear();
            }
            catch (ParseException e) {
                ZimbraLog.smtp.warn((Object)"ignoring error while auto-adding contact", e);
                newContacts.clear();
            }
        }
        ArrayList<InternetAddress> ret = new ArrayList<InternetAddress>();
        if (newContacts.isEmpty()) return ret;
        ret.addAll(newContacts.values());
        return ret;
    }

    public void saveNewContacts(Collection<InternetAddress> newContacts, OperationContext octxt, Object authMailbox) {
        for (InternetAddress inetaddr : newContacts) {
            ZimbraLog.smtp.debug("adding new contact: " + inetaddr);
            Map<String, String> fields = new ParsedAddress(inetaddr).getAttributes();
            try {
                if (authMailbox instanceof Mailbox) {
                    ParsedContact pc = new ParsedContact(fields);
                    ((Mailbox)authMailbox).createContact(octxt, pc, 13, null);
                    continue;
                }
                if (!(authMailbox instanceof ZMailbox)) continue;
                ((ZMailbox)authMailbox).createContact("13", null, fields);
            }
            catch (ServiceException e) {
                ZimbraLog.smtp.warn((Object)"ignoring error while auto-adding contact", e);
            }
        }
    }

    public static class SafeSendFailedException
    extends SafeMessagingException {
        private static final long serialVersionUID = 5625565177360027934L;
        private SendFailedException mSfe;

        public SafeSendFailedException(SendFailedException sfe) {
            super((MessagingException)sfe);
            this.mSfe = sfe;
        }

        public Address[] getInvalidAddresses() {
            return this.mSfe.getInvalidAddresses();
        }

        public Address[] getValidSentAddresses() {
            return this.mSfe.getValidSentAddresses();
        }

        public Address[] getValidUnsentAddresses() {
            return this.mSfe.getValidUnsentAddresses();
        }
    }

    public static class SafeMessagingException
    extends MessagingException {
        private static final long serialVersionUID = -4652297855877992478L;
        private MessagingException mMex;

        public SafeMessagingException(MessagingException mex) {
            this.mMex = mex;
            this.setStackTrace(this.mMex.getStackTrace());
        }

        public String getMessage() {
            return this.mMex.getMessage();
        }

        public Exception getNextException() {
            return this.mMex.getNextException();
        }

        public synchronized String toString() {
            StringBuffer sb = new StringBuffer();
            SafeMessagingException.appendException(sb, (Exception)((Object)this));
            Exception n = this.mMex.getNextException();
            int more = 0;
            while (n != null) {
                if (more == 0) {
                    sb.append("; chained exception is:\n\t");
                    SafeMessagingException.appendException(sb, n);
                }
                if (!(n instanceof MessagingException)) break;
                MessagingException mex = (MessagingException)((Object)n);
                if ((n = mex.getNextException()) == null) continue;
                ++more;
            }
            if (more > 0) {
                sb.append("\n\t(").append(more).append(" more chained exception");
                if (more > 1) {
                    sb.append('s');
                }
                sb.append(')');
            }
            return sb.toString();
        }

        private static StringBuffer appendException(StringBuffer sb, Exception e) {
            sb.append(e.getClass().getName());
            String message = e.getLocalizedMessage();
            if (message != null) {
                sb.append(": ").append(message);
            }
            return sb;
        }
    }

    protected static class RollbackData {
        Mailbox mbox;
        ZMailbox zmbox;
        ItemId msgId;

        RollbackData(Mailbox m, int i) {
            this.mbox = m;
            this.msgId = new ItemId(this.mbox, i);
        }

        RollbackData(Message msg) {
            this.mbox = msg.getMailbox();
            this.msgId = new ItemId(msg);
        }

        RollbackData(ZMailbox z, Account a, String s) throws ServiceException {
            this.zmbox = z;
            this.msgId = new ItemId(s, a.getId());
        }

        public void rollback() {
            try {
                if (this.mbox != null) {
                    this.mbox.delete(null, this.msgId.getId(), (byte)5);
                } else {
                    this.zmbox.deleteMessage("" + this.msgId);
                }
            }
            catch (ServiceException e) {
                ZimbraLog.smtp.warn((Object)("ignoring error while deleting saved sent message: " + this.msgId), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReplyForwardType {
        ORIGINAL,
        REPLY,
        FORWARD;

    }
}

