/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.SystemUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.Chat;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.Task;
import com.zimbra.cs.mailbox.VirtualConversation;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.mailbox.util.TypedIdList;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StagedBlob;
import com.zimbra.cs.store.StoreManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailItem
implements Comparable<MailItem> {
    public static final byte TYPE_FOLDER = 1;
    public static final byte TYPE_SEARCHFOLDER = 2;
    public static final byte TYPE_TAG = 3;
    public static final byte TYPE_CONVERSATION = 4;
    public static final byte TYPE_MESSAGE = 5;
    public static final byte TYPE_CONTACT = 6;
    public static final byte TYPE_DOCUMENT = 8;
    public static final byte TYPE_NOTE = 9;
    public static final byte TYPE_FLAG = 10;
    public static final byte TYPE_APPOINTMENT = 11;
    public static final byte TYPE_VIRTUAL_CONVERSATION = 12;
    public static final byte TYPE_MOUNTPOINT = 13;
    public static final byte TYPE_WIKI = 14;
    public static final byte TYPE_TASK = 15;
    public static final byte TYPE_CHAT = 16;
    public static final byte TYPE_MAX = 16;
    public static final byte TYPE_UNKNOWN = -1;
    private static String[] TYPE_NAMES = new String[]{null, "folder", "search folder", "tag", "conversation", "message", "contact", "invite", "document", "note", "flag", "appointment", "virtual conversation", "remote folder", "wiki", "task", "chat"};
    public static final int FLAG_UNCHANGED = Integer.MIN_VALUE;
    public static final long TAG_UNCHANGED = 0x80000000L;
    public static final int TAG_ID_OFFSET = 64;
    public static final int MAX_FLAG_COUNT = 31;
    public static final int MAX_TAG_COUNT = 63;
    public static final byte DEFAULT_COLOR = 0;
    public static final Color DEFAULT_COLOR_RGB = new Color(0);
    protected int mId;
    protected UnderlyingData mData;
    protected Mailbox mMailbox;
    protected MailboxBlob mBlob;
    protected int mVersion;
    protected List<MailItem> mRevisions;
    protected Color mRGBColor;
    protected CustomMetadata.CustomMetadataList mExtendedData;
    private static final int TOTAL_METADATA_LIMIT = 10000;
    private static final String INVALID_NAME_CHARACTERS = "[:/\"\t\r\n]";
    private static final String INVALID_NAME_PATTERN = ".*[:/\"\t\r\n].*";
    public static final int MAX_NAME_LENGTH = 128;
    private static final int UNREAD_ITEM_BATCH_SIZE = 500;
    private static final String CUSTOM_META_PREFIX = "xd.";
    private static final String CN_ID = "id";
    private static final String CN_TYPE = "type";
    private static final String CN_PARENT_ID = "parent_id";
    private static final String CN_FOLDER_ID = "folder_id";
    private static final String CN_DATE = "date";
    private static final String CN_SIZE = "size";
    private static final String CN_REVISION = "rev";
    private static final String CN_BLOB_DIGEST = "digest";
    private static final String CN_UNREAD_COUNT = "unread";
    private static final String CN_FLAGS = "flags";
    private static final String CN_TAGS = "tags";
    private static final String CN_SUBJECT = "subject";
    private static final String CN_NAME = "name";
    private static final String CN_COLOR = "color";
    private static final String CN_VERSION = "version";
    private static final String CN_IMAP_ID = "imap_id";

    public static final int typeToBitmask(byte mailItemType) {
        switch (mailItemType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 8: {
                return 64;
            }
            case 9: {
                return 128;
            }
            case 10: {
                return 256;
            }
            case 11: {
                return 512;
            }
            case 12: {
                return 1024;
            }
            case 13: {
                return 2048;
            }
            case 14: {
                return 4096;
            }
            case 15: {
                return 8192;
            }
            case 16: {
                return 16384;
            }
        }
        assert (false);
        return 0;
    }

    static byte validateType(byte type) throws ServiceException {
        if (type <= 0 || type > 16 || type == 7) {
            throw MailServiceException.INVALID_TYPE(type);
        }
        return type;
    }

    public static String getNameForType(MailItem item) {
        return MailItem.getNameForType(item == null ? (byte)-1 : (byte)item.getType());
    }

    public static String getNameForType(byte type) {
        return type <= 0 || type > 16 ? null : TYPE_NAMES[type];
    }

    public static byte getTypeForName(String name) {
        if (name != null && !name.trim().equals("")) {
            for (byte i = 1; i < TYPE_NAMES.length; i = (byte)(i + 1)) {
                if (!name.equals(TYPE_NAMES[i])) continue;
                return i;
            }
        }
        return -1;
    }

    MailItem(Mailbox mbox, UnderlyingData data) throws ServiceException {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        Flag.validateFlags(data.flags);
        this.mId = data.id;
        this.mData = data;
        this.mMailbox = mbox;
        this.decodeMetadata(this.mData.metadata);
        this.mData.metadata = null;
        if ((data.flags & Flag.BITMASK_UNCACHED) == 0) {
            mbox.cache(this);
        }
    }

    public int getId() {
        return this.mData.id;
    }

    public byte getType() {
        return this.mData.type;
    }

    public long getMailboxId() {
        return this.mMailbox.getId();
    }

    public Mailbox getMailbox() {
        return this.mMailbox;
    }

    public Account getAccount() throws ServiceException {
        return this.mMailbox.getAccount();
    }

    public byte getColor() {
        return this.mRGBColor.getMappedColor();
    }

    public Color getRgbColor() {
        return this.mRGBColor;
    }

    public String getName() {
        return this.mData.name == null ? "" : StringUtil.trimTrailingSpaces(this.mData.name);
    }

    public int getParentId() {
        return this.mData.parentId;
    }

    public int getFolderId() {
        return this.mData.folderId;
    }

    public String getPath() throws ServiceException {
        String path = this.getFolder().getPath();
        String name = this.getName();
        if (name == null || path == null) {
            return null;
        }
        return path + (path.endsWith("/") ? "" : "/") + name;
    }

    public String getIndexId() {
        return this.mData.indexId;
    }

    public int getImapUid() {
        return this.mData.imapId;
    }

    public String getLocator() {
        return this.mData.locator;
    }

    public String getDigest() {
        return this.mData.getBlobDigest();
    }

    public int getVersion() {
        return this.mVersion;
    }

    public long getDate() {
        return (long)this.mData.date * 1000L;
    }

    public int getSavedSequence() {
        return this.mData.modContent;
    }

    public long getChangeDate() {
        return (long)this.mData.dateChanged * 1000L;
    }

    public int getModifiedSequence() {
        return this.mData.modMetadata;
    }

    public long getSize() {
        return this.mData.size;
    }

    public long getTotalSize() throws ServiceException {
        long size = this.mData.size;
        if (this.isTagged(-13)) {
            for (MailItem revision : this.loadRevisions()) {
                size += revision.getSize();
            }
        }
        return size;
    }

    public String getSubject() {
        return this.mData.subject == null ? "" : this.mData.subject;
    }

    public UnderlyingData getUnderlyingData() {
        this.mData.metadata = this.encodeMetadata();
        return this.mData;
    }

    public abstract String getSender();

    public String getSortSubject() {
        String subject = this.getSubject();
        return subject.toUpperCase().substring(0, Math.min(1024, subject.length()));
    }

    public String getSortSender() {
        String sender = this.getSender();
        return sender.toUpperCase().substring(0, Math.min(128, sender.length()));
    }

    public int getFlagBitmask() {
        int flags = this.mData.flags;
        if (this.isUnread()) {
            flags |= Flag.BITMASK_UNREAD;
        }
        return flags;
    }

    public List<String> getCustomDataSections() {
        if (this.mExtendedData == null || this.mExtendedData.isEmpty()) {
            return Collections.emptyList();
        }
        return this.mExtendedData.listSections();
    }

    public CustomMetadata getCustomData(String section) throws ServiceException {
        if (section == null || this.mExtendedData == null) {
            return null;
        }
        return this.mExtendedData.getSection(section);
    }

    void setCustomData(CustomMetadata custom) throws ServiceException {
        if (custom == null) {
            return;
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the necessary permissions on the item");
        }
        this.markItemModified(524288);
        if (this.mExtendedData != null) {
            this.mExtendedData.addSection(custom);
        } else if (!custom.isEmpty()) {
            this.mExtendedData = custom.asList();
        }
        if (this.mExtendedData != null && !custom.isEmpty() && this.mExtendedData.guessSize() > 10000L) {
            throw MailServiceException.TOO_MUCH_METADATA(10000);
        }
        this.saveMetadata();
    }

    public int getInternalFlagBitmask() {
        return this.mData.flags;
    }

    public String getFlagString() {
        if (this.mData.flags == 0) {
            return this.isUnread() ? Flag.UNREAD_FLAG_ONLY : "";
        }
        int flags = this.mData.flags | (this.isUnread() ? Flag.BITMASK_UNREAD : 0);
        return Flag.bitmaskToFlags(flags);
    }

    public long getTagBitmask() {
        return this.mData.tags;
    }

    public String getTagString() {
        return Tag.bitmaskToTags(this.mData.tags);
    }

    public List<Tag> getTagList() throws ServiceException {
        return Tag.bitmaskToTagList(this.mMailbox, this.mData.tags);
    }

    public boolean isTagged(Tag tag) {
        long bitmask = tag instanceof Flag ? (long)this.mData.flags : this.mData.tags;
        return (bitmask & tag.getBitmask()) != 0L;
    }

    public boolean isTagged(int tagId) {
        boolean isFlag = tagId < 0;
        long bitfield = isFlag ? (long)this.mData.flags : this.mData.tags;
        byte position = isFlag ? Flag.getIndex(tagId) : Tag.getIndex(tagId);
        long bitmask = position < 0 || position > 63 ? 0L : 1L << position;
        return (bitfield & bitmask) != 0L;
    }

    boolean isFlagSet(int mask) {
        return (this.getFlagBitmask() & mask) != 0;
    }

    public boolean isUnread() {
        return this.mData.unreadCount > 0;
    }

    public int getUnreadCount() {
        return this.mData.unreadCount;
    }

    public boolean isFlagged() {
        return this.isTagged(-6);
    }

    public boolean hasAttachment() {
        return this.isTagged(-2);
    }

    public boolean inMailbox() throws ServiceException {
        return !this.inSpam() && !this.inTrash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTrash() throws ServiceException {
        if (this.mData.folderId <= 16) {
            return this.mData.folderId == 3;
        }
        Folder folder = null;
        Mailbox mailbox = this.mMailbox;
        synchronized (mailbox) {
            folder = this.mMailbox.getFolderById(null, this.getFolderId());
        }
        return folder.inTrash();
    }

    public boolean inSpam() {
        return this.mData.folderId == 4;
    }

    boolean canAccess(short rightsNeeded) throws ServiceException {
        return this.canAccess(rightsNeeded, this.mMailbox.getAuthenticatedAccount(), this.mMailbox.isUsingAdminPrivileges());
    }

    boolean canAccess(short rightsNeeded, Account authuser, boolean asAdmin) throws ServiceException {
        if (rightsNeeded == 0) {
            return true;
        }
        return this.checkRights(rightsNeeded, authuser, asAdmin) == rightsNeeded;
    }

    short checkRights(short rightsNeeded, Account authuser, boolean asAdmin) throws ServiceException {
        short granted = this.getFolder().checkRights(rightsNeeded, authuser, asAdmin);
        return (short)(granted & rightsNeeded);
    }

    public synchronized MailboxBlob getBlob() throws ServiceException {
        if (this.mBlob == null && this.getDigest() != null) {
            this.mBlob = StoreManager.getInstance().getMailboxBlob(this);
            if (this.mBlob == null) {
                throw MailServiceException.NO_SUCH_BLOB(this.mMailbox.getId(), this.mId, this.mData.modContent);
            }
        }
        return this.mBlob;
    }

    public InputStream getContentStream() throws ServiceException {
        if (this.getDigest() == null) {
            return null;
        }
        try {
            MailboxBlob mblob = this.getBlob();
            if (mblob == null) {
                throw ServiceException.FAILURE("missing blob for id: " + this.getId() + ", change: " + this.getModifiedSequence(), null);
            }
            return StoreManager.getInstance().getContent(mblob);
        }
        catch (IOException e) {
            String msg = String.format("Unable to get content for %s %d", this.getClass().getSimpleName(), this.getId());
            throw ServiceException.FAILURE(msg, e);
        }
    }

    public byte[] getContent() throws ServiceException {
        if (this.getDigest() == null) {
            return null;
        }
        try {
            return ByteUtil.getContent(this.getContentStream(), (int)this.getSize());
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to get content for item " + this.getId(), e);
        }
    }

    @Override
    public int compareTo(MailItem that) {
        if (this == that) {
            return 0;
        }
        return this.mId - that.getId();
    }

    static Comparator<MailItem> getComparator(SortBy sort) {
        boolean ascending = sort.getDirection() == SortBy.SortDirection.ASCENDING;
        switch (sort.getCriterion()) {
            case ID: {
                return ascending ? new SortIdAscending() : new SortIdDescending();
            }
            case DATE: {
                return ascending ? new SortDateAscending() : new SortDateDescending();
            }
            case SUBJECT: {
                return ascending ? new SortSubjectAscending() : new SortSubjectDescending();
            }
            case NAME_NATURAL_ORDER: {
                return ascending ? new SortNameNaturalOrderAscending() : new SortNameNaturalOrderDescending();
            }
        }
        return null;
    }

    public List<IndexDocument> generateIndexData(boolean doConsistencyCheck) throws TemporaryIndexingException {
        return null;
    }

    MailItem getParent() throws ServiceException {
        if (this.mData.parentId == -1) {
            return null;
        }
        return this.mMailbox.getItemById(this.mData.parentId, (byte)-1);
    }

    Folder getFolder() throws ServiceException {
        return this.mMailbox.getFolderById(this.mData.folderId);
    }

    abstract boolean isTaggable();

    abstract boolean isCopyable();

    abstract boolean isMovable();

    abstract boolean isMutable();

    abstract boolean isIndexed();

    abstract boolean canHaveChildren();

    boolean isDeletable() {
        return true;
    }

    boolean isLeafNode() {
        return true;
    }

    boolean trackUnread() {
        return true;
    }

    boolean canParent(MailItem child) {
        return this.canHaveChildren();
    }

    static MailItem getById(Mailbox mbox, int id) throws ServiceException {
        return MailItem.getById(mbox, id, (byte)-1);
    }

    static MailItem getById(Mailbox mbox, int id, byte type) throws ServiceException {
        return mbox.getItem(DbMailItem.getById(mbox, id, type));
    }

    static List<MailItem> getById(Mailbox mbox, Collection<Integer> ids, byte type) throws ServiceException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MailItem> items = new ArrayList<MailItem>();
        for (UnderlyingData ud : DbMailItem.getById(mbox, ids, type)) {
            items.add(mbox.getItem(ud));
        }
        return items;
    }

    static MailItem getByImapId(Mailbox mbox, int id, int folderId) throws ServiceException {
        return mbox.getItem(DbMailItem.getByImapId(mbox, id, folderId));
    }

    public static MailItem constructItem(Mailbox mbox, UnderlyingData data) throws ServiceException {
        if (data == null) {
            throw MailItem.noSuchItem(-1, (byte)-1);
        }
        switch (data.type) {
            case 1: {
                return new Folder(mbox, data);
            }
            case 2: {
                return new SearchFolder(mbox, data);
            }
            case 3: {
                return new Tag(mbox, data);
            }
            case 4: {
                return new Conversation(mbox, data);
            }
            case 5: {
                return new Message(mbox, data);
            }
            case 6: {
                return new Contact(mbox, data);
            }
            case 8: {
                return new Document(mbox, data);
            }
            case 9: {
                return new Note(mbox, data);
            }
            case 11: {
                return new Appointment(mbox, data);
            }
            case 15: {
                return new Task(mbox, data);
            }
            case 13: {
                return new Mountpoint(mbox, data);
            }
            case 14: {
                return new WikiItem(mbox, data);
            }
            case 16: {
                return new Chat(mbox, data);
            }
        }
        return null;
    }

    public static MailServiceException noSuchItem(int id, byte type) {
        switch (type) {
            case 1: 
            case 2: 
            case 13: {
                return MailServiceException.NO_SUCH_FOLDER(id);
            }
            case 3: 
            case 10: {
                return MailServiceException.NO_SUCH_TAG(id);
            }
            case 4: 
            case 12: {
                return MailServiceException.NO_SUCH_CONV(id);
            }
            case 5: 
            case 16: {
                return MailServiceException.NO_SUCH_MSG(id);
            }
            case 6: {
                return MailServiceException.NO_SUCH_CONTACT(id);
            }
            case 8: 
            case 14: {
                return MailServiceException.NO_SUCH_DOC(id);
            }
            case 9: {
                return MailServiceException.NO_SUCH_NOTE(id);
            }
            case 11: {
                return MailServiceException.NO_SUCH_APPT(id);
            }
            case 15: {
                return MailServiceException.NO_SUCH_TASK(id);
            }
        }
        return MailServiceException.NO_SUCH_ITEM(id);
    }

    public static boolean isAcceptableType(byte desired, byte actual) {
        if (desired == actual || desired == -1) {
            return true;
        }
        if (desired == 1 && actual == 2) {
            return true;
        }
        if (desired == 1 && actual == 13) {
            return true;
        }
        if (desired == 3 && actual == 10) {
            return true;
        }
        if (desired == 4 && actual == 12) {
            return true;
        }
        if (desired == 8 && actual == 14) {
            return true;
        }
        return desired == 5 && actual == 16;
    }

    public boolean isAcceptableType(byte desired) {
        return MailItem.isAcceptableType(desired, this.getType());
    }

    boolean checkChangeID() throws ServiceException {
        return this.mMailbox.checkItemChangeID(this);
    }

    void markItemCreated() {
        this.mMailbox.markItemCreated(this);
    }

    void markItemDeleted() {
        this.mMailbox.markItemDeleted(this);
    }

    void markItemModified(int reason) {
        this.mMailbox.markItemModified(this, reason);
    }

    void markBlobForDeletion() {
        try {
            this.markBlobForDeletion(this.getBlob());
        }
        catch (ServiceException e) {
            ZimbraLog.mailbox.warn((Object)("error queuing blob for deletion for id: " + this.mId + ", change: " + this.mData.modContent), e);
        }
    }

    void markBlobForDeletion(MailboxBlob mblob) {
        if (mblob == null) {
            return;
        }
        PendingDelete info = new PendingDelete();
        info.blobs.add(mblob);
        this.mMailbox.markOtherItemDirty(info);
    }

    protected void finishCreation(MailItem parent) throws ServiceException {
        Folder folder;
        this.markItemCreated();
        if (parent != null) {
            parent.addChild(this);
        }
        if (!(folder = this.getFolder()).canContain(this)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (this.isLeafNode()) {
            this.mMailbox.updateSize(this.mData.size);
            folder.updateSize(1, this.mData.size);
        }
        folder.updateUnread(this.mData.unreadCount);
        this.updateTagUnread(this.mData.unreadCount);
    }

    void setColor(Color color) throws ServiceException {
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the necessary permissions on the item");
        }
        if (color.equals(this.mRGBColor)) {
            return;
        }
        this.markItemModified(8192);
        this.mRGBColor.set(color);
        this.saveMetadata();
    }

    @Deprecated
    void setColor(byte color) throws ServiceException {
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the necessary permissions on the item");
        }
        if (color == this.mRGBColor.getMappedColor()) {
            return;
        }
        this.markItemModified(8192);
        this.mRGBColor.setColor(color);
        this.saveMetadata();
    }

    void setDate(long date) throws ServiceException {
        if ((long)this.mData.date == date) {
            return;
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the necessary permissions on the item");
        }
        this.markItemModified(32);
        this.mData.date = (int)(date / 1000L);
        this.mData.metadataChanged(this.mMailbox);
        if (ZimbraLog.mailop.isDebugEnabled()) {
            ZimbraLog.mailop.debug("Setting date of %s to %d.", MailItem.getMailopContext(this), date);
        }
        DbMailItem.saveDate(this);
    }

    void setImapUid(int imapId) throws ServiceException {
        if (this.mData.imapId == imapId) {
            return;
        }
        if (ZimbraLog.mailop.isDebugEnabled()) {
            ZimbraLog.mailop.debug("Setting imapId of %s to %d.", MailItem.getMailopContext(this), imapId);
        }
        this.markItemModified(128);
        this.mData.imapId = imapId;
        this.mData.metadataChanged(this.mMailbox);
        DbMailItem.saveImapUid(this);
        this.getFolder().updateUIDNEXT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    final MailboxBlob setContent(byte[] data, String digest, Object content) throws ServiceException, IOException {
        MailboxBlob mailboxBlob;
        if (data == null) {
            return this.setContent(null, content);
        }
        StoreManager sm = StoreManager.getInstance();
        StagedBlob staged = sm.stage(new ByteArrayInputStream(data), data.length, null, this.mMailbox);
        try {
            mailboxBlob = this.setContent(staged, content);
            Object var8_7 = null;
            sm.quietDelete(staged);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            sm.quietDelete(staged);
            throw throwable;
        }
        return mailboxBlob;
    }

    MailboxBlob setContent(StagedBlob staged, Object content) throws ServiceException, IOException {
        long size;
        this.addRevision(false);
        this.markItemModified(65712);
        if (this.getSavedSequence() != this.mMailbox.getOperationChangeID()) {
            MailItem lastRev;
            List<MailItem> revisions;
            if (!this.canAccess((short)2)) {
                throw ServiceException.PERM_DENIED("you do not have the necessary permissions on the item");
            }
            boolean delete = true;
            if (this.isTagged(-13) && !(revisions = this.loadRevisions()).isEmpty() && (lastRev = revisions.get(revisions.size() - 1)).getSavedSequence() == this.getSavedSequence()) {
                delete = false;
            }
            if (delete) {
                this.markBlobForDeletion();
            }
        }
        MessageCache.purge(this);
        long l = size = staged == null ? 0L : staged.getStagedSize();
        if (this.mData.size != size) {
            this.mMailbox.updateSize(size - this.mData.size, true);
            this.mData.size = size;
        }
        this.getFolder().updateSize(0, size - this.mData.size);
        this.mData.setBlobDigest(staged == null ? null : staged.getStagedDigest());
        this.mData.date = this.mMailbox.getOperationTimestamp();
        this.mData.imapId = this.mMailbox.isTrackingImap() ? 0 : this.mData.id;
        this.mData.contentChanged(this.mMailbox);
        MailboxBlob mblob = null;
        if (staged != null) {
            StoreManager sm = StoreManager.getInstance();
            mblob = SystemUtil.ON_WINDOWS ? sm.link(staged, this.mMailbox, this.mId, this.getSavedSequence()) : sm.renameTo(staged, this.mMailbox, this.mId, this.getSavedSequence());
            this.mMailbox.markOtherItemDirty(mblob);
        }
        this.mBlob = null;
        this.mData.locator = mblob == null ? null : mblob.getLocator();
        this.reanalyze(content);
        return mblob;
    }

    int getMaxRevisions() throws ServiceException {
        return 1;
    }

    List<MailItem> loadRevisions() throws ServiceException {
        if (this.mRevisions == null) {
            this.mRevisions = new ArrayList<MailItem>();
            if (this.isTagged(-13)) {
                for (UnderlyingData data : DbMailItem.getRevisionInfo(this)) {
                    this.mRevisions.add(MailItem.constructItem(this.mMailbox, data));
                }
            }
        }
        return this.mRevisions;
    }

    void addRevision(boolean persist) throws ServiceException {
        if (this.mData.modMetadata == this.mMailbox.getOperationChangeID()) {
            return;
        }
        Folder folder = this.getFolder();
        int maxNumRevisions = this.getMaxRevisions();
        if (maxNumRevisions != 1) {
            this.loadRevisions();
            if (!this.mRevisions.isEmpty()) {
                MailItem lastRev = this.mRevisions.get(this.mRevisions.size() - 1);
                if (lastRev.mData.modContent == this.mData.modContent && lastRev.mData.modMetadata == this.mData.modMetadata) {
                    return;
                }
                int maxVer = 0;
                for (MailItem rev : this.mRevisions) {
                    maxVer = Math.max(maxVer, rev.getVersion());
                }
                if (this.mVersion <= maxVer) {
                    ZimbraLog.mailop.info("Item's current version is not greater than highest revision; adjusting to " + (maxVer + 1) + " (was " + this.mVersion + ")");
                    this.mVersion = maxVer + 1;
                }
            }
            UnderlyingData data = this.mData.clone();
            data.metadata = this.encodeMetadata();
            data.flags |= Flag.BITMASK_UNCACHED;
            this.mRevisions.add(MailItem.constructItem(this.mMailbox, data));
            folder.updateSize(0, this.mData.size);
            this.mMailbox.updateSize(this.mData.size);
            ZimbraLog.mailop.debug("saving revision %d for %s", this.mVersion, MailItem.getMailopContext(this));
            DbMailItem.snapshotRevision(this, this.mVersion);
            if (!this.isTagged(-13)) {
                this.tagChanged(this.mMailbox.getFlagById(-13), true);
            }
        }
        ++this.mVersion;
        if (maxNumRevisions > 0 && this.isTagged(-13)) {
            List<MailItem> revisions = this.loadRevisions();
            int numRevsToPurge = revisions.size() - (maxNumRevisions - 1);
            if (numRevsToPurge > 0) {
                ArrayList<MailItem> toPurge = new ArrayList<MailItem>();
                Iterator<MailItem> it = revisions.iterator();
                for (int numPurged = 0; it.hasNext() && numPurged < numRevsToPurge; ++numPurged) {
                    MailItem revision = it.next();
                    toPurge.add(revision);
                    it.remove();
                }
                int oldestRemainingSavedSequence = revisions.isEmpty() ? this.mData.modContent : revisions.get(0).getSavedSequence();
                for (MailItem revision : toPurge) {
                    if (revision.getSavedSequence() >= oldestRemainingSavedSequence) continue;
                    this.mMailbox.updateSize(-revision.getSize());
                    folder.updateSize(0, -revision.getSize());
                    revision.markBlobForDeletion();
                }
                int highestPurgedVer = ((MailItem)toPurge.get(toPurge.size() - 1)).getVersion();
                DbMailItem.purgeRevisions(this, highestPurgedVer);
            }
            if (revisions.isEmpty()) {
                this.tagChanged(this.mMailbox.getFlagById(-13), false);
            }
        }
        this.mData.metadataChanged(this.mMailbox);
        if (persist) {
            this.saveData(this.getSender());
        }
    }

    MailItem getRevision(int version) throws ServiceException {
        if (version == this.mVersion) {
            return this;
        }
        if (version <= 0 || version > this.mVersion || !this.isTagged(-13)) {
            return null;
        }
        for (MailItem revision : this.loadRevisions()) {
            if (revision.mVersion != version) continue;
            return revision;
        }
        return null;
    }

    void reanalyze(Object data) throws ServiceException {
        throw ServiceException.FAILURE("reanalysis of " + MailItem.getNameForType(this) + "s not supported", null);
    }

    void detach() throws ServiceException {
    }

    void alterUnread(boolean unread) throws ServiceException {
        if (unread == this.isUnread()) {
            return;
        }
        Flag unreadFlag = this.mMailbox.getFlagById(-10);
        if (!unreadFlag.canTag(this)) {
            throw MailServiceException.CANNOT_TAG(unreadFlag, this);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        this.markItemModified(1);
        this.mData.metadataChanged(this.mMailbox);
        this.updateUnread(unread ? 1 : -1);
        DbMailItem.alterUnread(this, unread);
    }

    void alterTag(Tag tag, boolean newValue) throws ServiceException {
        if (tag == null) {
            throw ServiceException.FAILURE("no tag supplied when trying to tag item " + this.mId, null);
        }
        if (!this.isTaggable() || newValue && !tag.canTag(this)) {
            throw MailServiceException.CANNOT_TAG(tag, this);
        }
        if (tag.getId() == -10) {
            throw ServiceException.FAILURE("unread state must be set with alterUnread", null);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        if (newValue == this.isTagged(tag)) {
            return;
        }
        if (tag instanceof Flag && (tag.getBitmask() & (long)Flag.FLAG_SYSTEM) != 0L) {
            throw MailServiceException.CANNOT_TAG(tag, this);
        }
        MailItem parent = this.getParent();
        this.tagChanged(tag, newValue);
        if (tag.trackUnread() && this.mData.unreadCount > 0) {
            tag.updateUnread((newValue ? 1 : -1) * this.mData.unreadCount);
        }
        if (ZimbraLog.mailop.isDebugEnabled()) {
            ZimbraLog.mailop.debug("Setting %s for %s.", MailItem.getMailopContext(tag), MailItem.getMailopContext(this));
        }
        DbMailItem.alterTag(this, tag, newValue);
        if (parent != null) {
            parent.inheritedTagChanged(tag, newValue);
        }
    }

    final void alterSystemFlag(Flag flag, boolean newValue) throws ServiceException {
        if (flag == null) {
            throw ServiceException.FAILURE("no tag supplied when trying to tag item " + this.mId, null);
        }
        if ((flag.getBitmask() & (long)Flag.FLAG_SYSTEM) == 0L) {
            throw ServiceException.FAILURE("requested to alter a non-system tag", null);
        }
        if (newValue && !flag.canTag(this)) {
            throw MailServiceException.CANNOT_TAG(flag, this);
        }
        if (newValue == this.isTagged(flag)) {
            return;
        }
        MailItem parent = this.getParent();
        this.tagChanged(flag, newValue);
        DbMailItem.alterTag(flag, Arrays.asList(this.getId()), newValue);
        if (parent != null) {
            parent.inheritedTagChanged(flag, newValue);
        }
    }

    protected void tagChanged(Tag tag, boolean add) throws ServiceException {
        boolean isFlag = tag instanceof Flag;
        this.markItemModified(isFlag ? 4 : 2);
        if (!isFlag || (tag.getBitmask() & (long)Flag.FLAG_SYSTEM) == 0L) {
            this.mData.metadataChanged(this.mMailbox);
        }
        if (isFlag) {
            this.mData.flags = add ? (int)((long)this.mData.flags | tag.getBitmask()) : (int)((long)this.mData.flags & (tag.getBitmask() ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.mData.tags = add ? (this.mData.tags |= tag.getBitmask()) : (this.mData.tags &= tag.getBitmask() ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    protected void inheritedTagChanged(Tag tag, boolean add) throws ServiceException {
    }

    protected void updateUnread(int delta) throws ServiceException {
        if (delta == 0 || !this.trackUnread()) {
            return;
        }
        this.markItemModified(1);
        this.mData.unreadCount += delta;
        if (this.mData.unreadCount < 0) {
            throw ServiceException.FAILURE("inconsistent state: unread < 0 for item " + this.mId, null);
        }
    }

    protected void updateTagUnread(int delta) throws ServiceException {
        if (delta == 0 || !this.isTaggable() || this.mData.tags == 0L) {
            return;
        }
        long tags = this.mData.tags;
        for (int i = 0; tags != 0L && i < 63; ++i) {
            long mask = 1L << i;
            if ((tags & mask) == 0L) continue;
            Tag tag = null;
            try {
                tag = this.mMailbox.getTagById(i + 64);
            }
            catch (MailServiceException.NoSuchItemException nsie) {
                ZimbraLog.mailbox.warn("item " + this.mId + " has nonexistent tag " + (i + 64));
                continue;
            }
            tag.updateUnread(delta);
            tags &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    void setTags(int flags, long tags) throws ServiceException {
        long mask;
        int i;
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        if ((flags = flags & ~Flag.FLAG_SYSTEM | this.getFlagBitmask() & Flag.FLAG_SYSTEM) != this.mData.flags) {
            this.markItemModified(4);
            for (i = 0; i < 31; i = (int)((byte)(i + 1))) {
                Flag flag;
                mask = 1 << i;
                if (((long)flags & mask) == ((long)this.mData.flags & mask) || (flag = Flag.getFlag(this.mMailbox, (byte)i)) == null) continue;
                this.alterTag(flag, !this.isTagged(flag));
            }
        }
        if (tags != this.mData.tags) {
            this.markItemModified(2);
            for (i = 0; i < 63; ++i) {
                mask = 1L << i;
                if ((tags & mask) == (this.mData.tags & mask)) continue;
                Tag tag = null;
                try {
                    tag = this.mMailbox.getTagById(i + 64);
                }
                catch (MailServiceException.NoSuchItemException nsie) {
                    continue;
                }
                this.alterTag(tag, !this.isTagged(tag));
            }
        }
    }

    MailItem copy(Folder folder, int copyId, int parentId) throws IOException, ServiceException {
        MailItem parent;
        if (!this.isCopyable()) {
            throw MailServiceException.CANNOT_COPY(this.mId);
        }
        if (!folder.canContain(this)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!this.canAccess((short)1)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        if (!folder.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the target folder");
        }
        String indexId = this.mData.indexId;
        if (this.isIndexed() && (indexId == null || this.isMutable())) {
            indexId = folder.inSpam() ? null : Integer.toString(copyId);
        }
        boolean shared = indexId != null && indexId.equals(this.mData.indexId);
        boolean detach = parentId <= 0 || this.isTagged(-7) || this.inSpam() != folder.inSpam();
        MailItem mailItem = parent = detach ? null : this.getParent();
        if (shared && !this.isTagged(-5)) {
            this.alterSystemFlag(this.mMailbox.getFlagById(-5), true);
            if (ZimbraLog.mailop.isDebugEnabled()) {
                ZimbraLog.mailop.debug("setting copied flag for %s", MailItem.getMailopContext(this));
            }
        }
        String locator = null;
        MailboxBlob srcMblob = this.getBlob();
        if (srcMblob != null) {
            StoreManager sm = StoreManager.getInstance();
            MailboxBlob mblob = sm.link(srcMblob, this.mMailbox, copyId, this.mMailbox.getOperationChangeID());
            this.mMailbox.markOtherItemDirty(mblob);
            locator = mblob.getLocator();
        }
        UnderlyingData data = this.mData.duplicate(copyId, folder.getId(), locator);
        data.parentId = detach ? -1 : parentId;
        data.indexId = indexId;
        data.flags = data.flags & (shared ? -1 : ~Flag.BITMASK_COPIED);
        data.metadata = this.encodeMetadata();
        data.contentChanged(this.mMailbox);
        if (indexId != null && !indexId.equals(this.mData.indexId)) {
            this.mMailbox.queueForIndexing(this, false, null);
        }
        ZimbraLog.mailop.info("Copying %s: copyId=%d, folderId=%d, folderName=%s, parentId=%d.", MailItem.getMailopContext(this), copyId, folder.getId(), folder.getName(), data.parentId);
        DbMailItem.copy(this, copyId, folder, data.indexId, data.parentId, data.locator, data.metadata);
        MailItem copy = MailItem.constructItem(this.mMailbox, data);
        copy.finishCreation(parent);
        return copy;
    }

    MailItem icopy(Folder target, int copyId) throws IOException, ServiceException {
        boolean shared;
        if (!this.isCopyable()) {
            throw MailServiceException.CANNOT_COPY(this.mId);
        }
        if (!target.canContain(this)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!this.canAccess((short)1)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        if (!target.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the target folder");
        }
        MailItem parent = this.getParent();
        String locator = null;
        MailboxBlob srcMblob = this.getBlob();
        if (srcMblob != null) {
            StoreManager sm = StoreManager.getInstance();
            MailboxBlob mblob = sm.link(srcMblob, this.mMailbox, copyId, this.mMailbox.getOperationChangeID());
            this.mMailbox.markOtherItemDirty(mblob);
            locator = mblob.getLocator();
        }
        UnderlyingData data = this.mData.duplicate(copyId, target.getId(), locator);
        data.metadata = this.encodeMetadata();
        data.imapId = copyId;
        data.contentChanged(this.mMailbox);
        if (this.isIndexed() && (data.indexId == null || this.isMutable())) {
            data.indexId = target.inSpam() ? null : Integer.toString(copyId);
        }
        boolean bl = shared = data.indexId != null && data.indexId.equals(this.mData.indexId);
        if (data.indexId != null && !data.indexId.equals(this.mData.indexId)) {
            this.mMailbox.queueForIndexing(this, false, null);
        }
        ZimbraLog.mailop.info("Performing IMAP copy of %s: copyId=%d, folderId=%d, folderName=%s, parentId=%d.", MailItem.getMailopContext(this), copyId, target.getId(), target.getName(), data.parentId);
        DbMailItem.icopy(this, data, shared);
        MailItem copy = MailItem.constructItem(this.mMailbox, data);
        copy.finishCreation(null);
        if (shared && !this.isTagged(-5)) {
            Flag copiedFlag = this.mMailbox.getFlagById(-5);
            this.tagChanged(copiedFlag, true);
            copy.tagChanged(copiedFlag, true);
            if (parent != null) {
                parent.inheritedTagChanged(copiedFlag, true);
            }
        }
        if (parent != null && parent.getId() > 0) {
            this.markItemModified(512);
            parent.markItemModified(1024);
            this.mData.metadataChanged(this.mMailbox);
            this.mData.parentId = this.mData.type == 5 ? -this.mId : -1;
        }
        return copy;
    }

    static String validateItemName(String name) throws ServiceException {
        if (name == null || name != StringUtil.stripControlCharacters(name) || name.matches(INVALID_NAME_PATTERN)) {
            throw MailServiceException.INVALID_NAME(name);
        }
        String trimmed = StringUtil.trimTrailingSpaces(name);
        if (trimmed.length() == 0 || trimmed.length() > 128) {
            throw MailServiceException.INVALID_NAME(name);
        }
        return trimmed;
    }

    public static String normalizeItemName(String name) {
        try {
            return MailItem.validateItemName(name);
        }
        catch (ServiceException e) {
            name = StringUtil.stripControlCharacters(name);
            if (name == null) {
                name = "";
            }
            if (name.length() > 128) {
                name = name.substring(0, 128);
            }
            if (name.matches(INVALID_NAME_PATTERN)) {
                name = name.replaceAll(INVALID_NAME_CHARACTERS, "");
            }
            if ((name = StringUtil.trimTrailingSpaces(name)).trim().equals("")) {
                name = "item" + System.currentTimeMillis();
            }
            return name;
        }
    }

    void rename(String name) throws ServiceException {
        this.rename(name, this.getFolder());
    }

    void rename(String name, Folder target) throws ServiceException {
        boolean moved;
        boolean renamed = !(name = MailItem.validateItemName(name)).equals(this.mData.name);
        boolean bl = moved = target != this.getFolder();
        if (!renamed && !moved) {
            return;
        }
        if (moved && target.getId() != 3 && target.getId() != 4 && !target.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the target item");
        }
        if (moved && !this.canAccess((short)8)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        if (renamed && !this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        if (renamed) {
            if (this.mData.name == null) {
                throw MailServiceException.CANNOT_RENAME(this.getType());
            }
            if (!this.isMutable()) {
                throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
            }
            try {
                MailItem conflict = this.mMailbox.getItemByPath(null, name, target.getId());
                if (conflict != null && conflict != this) {
                    throw MailServiceException.ALREADY_EXISTS(name, new ServiceException.Argument[0]);
                }
            }
            catch (MailServiceException.NoSuchItemException nsie) {
                // empty catch block
            }
            MailboxBlob oldblob = this.getBlob();
            this.addRevision(false);
            if (ZimbraLog.mailop.isDebugEnabled()) {
                ZimbraLog.mailop.debug("renaming " + MailItem.getMailopContext(this) + " to " + name);
            }
            this.markItemModified(4096);
            this.mData.name = name;
            this.mData.subject = name;
            this.mData.date = this.mMailbox.getOperationTimestamp();
            this.mData.contentChanged(this.mMailbox);
            this.saveName(target.getId());
            if (oldblob != null) {
                try {
                    StoreManager.getInstance().link(oldblob, this.mMailbox, this.mId, this.getSavedSequence());
                }
                catch (IOException ioe) {
                    throw ServiceException.FAILURE("could not copy blob for renamed document", ioe);
                }
            }
        }
        if (moved) {
            this.move(target);
        }
    }

    boolean move(Folder target) throws ServiceException {
        if (this.mData.folderId == target.getId()) {
            return false;
        }
        this.markItemModified(256);
        if (!this.isMovable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!target.canContain(this)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        Folder oldFolder = this.getFolder();
        if (!oldFolder.canAccess((short)8)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the source folder");
        }
        if (target.getId() != 3 && target.getId() != 4 && !target.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the target folder");
        }
        if (this.isLeafNode()) {
            oldFolder.updateSize(-1, -this.getTotalSize());
            target.updateSize(1, this.getTotalSize());
        }
        if (!this.inTrash() && target.inTrash()) {
            if (this.mData.unreadCount > 0) {
                this.alterUnread(false);
            }
        } else {
            oldFolder.updateUnread(-this.mData.unreadCount);
            target.updateUnread(this.mData.unreadCount);
        }
        if (!this.inSpam() && target.inSpam()) {
            this.detach();
        }
        if (this.inSpam() && !target.inSpam() && this.isIndexed() && this.mData.indexId != null) {
            this.mData.indexId = Integer.toString(this.mData.id);
            this.getMailbox().queueForIndexing(this, false, null);
        }
        ZimbraLog.mailop.info("moving " + MailItem.getMailopContext(this) + " to " + MailItem.getMailopContext(target));
        DbMailItem.setFolder(this, target);
        this.folderChanged(target, 0);
        return true;
    }

    void indexIdChanged(String indexId) {
        this.mData.indexId = indexId;
    }

    void folderChanged(Folder newFolder, int imapId) throws ServiceException {
        if (this.mData.folderId == newFolder.getId()) {
            return;
        }
        this.markItemModified(256);
        this.mData.metadataChanged(this.mMailbox);
        this.mData.folderId = newFolder.getId();
        this.mData.imapId = this.mMailbox.isTrackingImap() ? imapId : this.mData.imapId;
    }

    void addChild(MailItem child) throws ServiceException {
        this.markItemModified(1024);
        if (!this.canParent(child)) {
            throw MailServiceException.CANNOT_PARENT();
        }
        if (this.mMailbox != child.getMailbox()) {
            throw MailServiceException.WRONG_MAILBOX();
        }
    }

    void removeChild(MailItem child) throws ServiceException {
        this.markItemModified(1024);
        if (child.mData.parentId == this.mId) {
            child.mData.parentId = -1;
        }
    }

    void delete() throws ServiceException {
        this.delete(DeleteScope.ENTIRE_ITEM, true);
    }

    void delete(DeleteScope scope, boolean writeTombstones) throws ServiceException {
        if (scope == DeleteScope.ENTIRE_ITEM && !this.isDeletable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        PendingDelete info = this.getDeletionInfo();
        assert (info != null && info.itemIds != null);
        if (scope == DeleteScope.CONTENTS_ONLY || info.incomplete) {
            info.itemIds.remove(this.getType(), this.mId);
        }
        MailItem.delete(this.mMailbox, info, this, scope, writeTombstones);
    }

    static void delete(Mailbox mbox, PendingDelete info, MailItem item, DeleteScope scope, boolean writeTombstones) throws ServiceException {
        if (info.itemIds.isEmpty()) {
            return;
        }
        mbox.markItemDeleted(info.itemIds.getTypesMask(), info.itemIds.getAll());
        MailItem parent = null;
        if (item != null && scope == DeleteScope.ENTIRE_ITEM && !info.incomplete) {
            item.markItemDeleted();
            parent = item.getParent();
        }
        mbox.updateSize(-info.size);
        mbox.updateContactCount(-info.contacts);
        if (item != null) {
            item.propagateDeletion(info);
        } else {
            for (Map.Entry<Integer, DbMailItem.LocationCount> entry : info.messages.entrySet()) {
                int folderID = entry.getKey();
                DbMailItem.LocationCount lcount = entry.getValue();
                mbox.getFolderById(folderID).updateSize(-lcount.count, -lcount.size);
            }
            List<UnderlyingData> unreadData = DbMailItem.getById(mbox, info.unreadIds, (byte)5);
            for (UnderlyingData data : unreadData) {
                mbox.getItem(data).updateUnread(-1);
            }
        }
        if (ZimbraLog.mailop.isInfoEnabled()) {
            if (item != null) {
                if (item instanceof VirtualConversation) {
                    ZimbraLog.mailop.info("Deleting Message (id=%d).", ((VirtualConversation)item).getMessageId());
                } else {
                    ZimbraLog.mailop.info("Deleting %s%s.", scope == DeleteScope.CONTENTS_ONLY ? "contents of " : "", MailItem.getMailopContext(item));
                }
            }
            int itemId = item == null ? 0 : Math.abs(item.getId());
            TreeSet<Integer> idSet = new TreeSet<Integer>();
            for (int id : info.itemIds.getAll()) {
                if ((id = Math.abs(id)) != itemId) {
                    idSet.add(id);
                }
                if (idSet.size() < 200) continue;
                ZimbraLog.mailop.info("Deleting items: %s.", StringUtil.join(",", idSet));
                idSet.clear();
            }
            if (idSet.size() > 0) {
                ZimbraLog.mailop.info("Deleting items: %s.", StringUtil.join(",", idSet));
            }
        }
        if (info.incomplete || item == null) {
            DbMailItem.delete(mbox, info.itemIds.getAll());
        } else if (scope == DeleteScope.CONTENTS_ONLY) {
            DbMailItem.deleteContents(item);
        } else {
            DbMailItem.delete(item);
        }
        if (item != null) {
            item.purgeCache(info, !info.incomplete && scope == DeleteScope.ENTIRE_ITEM);
            if (parent != null) {
                parent.removeChild(item);
            }
        } else if (!info.itemIds.isEmpty()) {
            info.cascadeIds = DbMailItem.markDeletionTargets(mbox, info.itemIds.getIds(5, 16), info.modifiedIds);
            if (info.cascadeIds != null) {
                info.modifiedIds.removeAll(info.cascadeIds);
            }
            mbox.purge((byte)4);
            if (!info.modifiedIds.isEmpty() && mbox.hasListeners(Session.Type.SOAP)) {
                for (MailItem conv : mbox.getItemById(info.modifiedIds, (byte)4)) {
                    ((Conversation)conv).getSenderList();
                }
            }
        }
        if (info.cascadeIds != null && !info.cascadeIds.isEmpty()) {
            DbMailItem.delete(mbox, info.cascadeIds);
            mbox.markItemDeleted(MailItem.typeToBitmask((byte)4), info.cascadeIds);
            info.itemIds.add((byte)4, info.cascadeIds);
        }
        if (info.sharedIndex != null && !info.sharedIndex.isEmpty()) {
            DbMailItem.resolveSharedIndex(mbox, info);
        }
        mbox.markOtherItemDirty(info);
        if (writeTombstones && mbox.isTrackingSync() && !info.itemIds.isEmpty()) {
            DbMailItem.writeTombstones(mbox, info.itemIds);
        }
    }

    static String getMailopContext(MailItem item) {
        if (item == null || !ZimbraLog.mailop.isInfoEnabled()) {
            return "<undefined>";
        }
        if (item instanceof Folder || item instanceof Tag || item instanceof WikiItem) {
            return String.format("%s %s (id=%d)", item.getClass().getSimpleName(), item.getName(), item.getId());
        }
        if (item instanceof Contact) {
            String email = ((Contact)item).get("email");
            if (StringUtil.isNullOrEmpty(email)) {
                email = "<undefined>";
            }
            return String.format("%s %s (id=%d)", item.getClass().getSimpleName(), email, item.getId());
        }
        return String.format("%s (id=%d)", item.getClass().getSimpleName(), item.getId());
    }

    PendingDelete getDeletionInfo() throws ServiceException {
        if (!this.canAccess((short)8)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        Integer id = new Integer(this.mId);
        PendingDelete info = new PendingDelete();
        info.rootId = this.mId;
        info.size = this.getTotalSize();
        info.itemIds.add(this.getType(), id);
        if (this.mData.unreadCount != 0 && this.mMailbox.getFlagById(-10).canTag(this)) {
            info.unreadIds.add(id);
        }
        info.messages.put(new Integer(this.getFolderId()), new DbMailItem.LocationCount(1, this.getTotalSize()));
        if (this.mData.indexId != null) {
            if (!this.isTagged(-5)) {
                info.indexIds.add(this.mData.indexId);
            } else {
                info.sharedIndex = new HashSet<String>();
                info.sharedIndex.add(this.mData.indexId);
            }
        }
        ArrayList<MailItem> items = new ArrayList<MailItem>(3);
        items.add(this);
        items.addAll(this.loadRevisions());
        for (MailItem revision : items) {
            try {
                info.blobs.add(revision.getBlob());
            }
            catch (Exception e) {
                ZimbraLog.mailbox.error("missing blob for id: " + this.mId + ", change: " + revision.getSavedSequence());
            }
        }
        return info;
    }

    void propagateDeletion(PendingDelete info) throws ServiceException {
        for (Map.Entry<Integer, DbMailItem.LocationCount> entry : info.messages.entrySet()) {
            Folder folder = this.mMailbox.getFolderById(entry.getKey());
            DbMailItem.LocationCount lcount = entry.getValue();
            folder.updateSize(-lcount.count, -lcount.size);
        }
        if (info.unreadIds.isEmpty()) {
            return;
        }
        int count = info.unreadIds.size();
        for (int i = 0; i < count; i += 500) {
            List<Integer> batch = info.unreadIds.subList(i, Math.min(i + 500, count));
            for (UnderlyingData data : DbMailItem.getById(this.mMailbox, batch, (byte)5)) {
                Message msg = (Message)this.mMailbox.getItem(data);
                if (msg.isUnread()) {
                    msg.updateUnread(-1);
                }
                this.mMailbox.uncache(msg);
            }
        }
    }

    void purgeCache(PendingDelete info, boolean purgeItem) throws ServiceException {
        if (purgeItem) {
            this.mMailbox.uncache(this);
        }
    }

    protected boolean trackUserAgentInMetadata() {
        return false;
    }

    String encodeMetadata() {
        OperationContext octxt;
        Metadata meta = this.encodeMetadata(new Metadata());
        if (this.trackUserAgentInMetadata() && (octxt = this.getMailbox().getOperationContext()) != null) {
            meta.put("ua", octxt.getUserAgent());
        }
        return meta.toString();
    }

    abstract Metadata encodeMetadata(Metadata var1);

    static Metadata encodeMetadata(Metadata meta, Color color, int version, CustomMetadata.CustomMetadataList extended) {
        if (color != null && color.getMappedColor() != 0) {
            meta.put("c", color.toMetadata());
        }
        if (version > 1) {
            meta.put("ver", version);
        }
        if (extended != null) {
            for (Pair mpair : extended) {
                meta.put(CUSTOM_META_PREFIX + (String)mpair.getFirst(), mpair.getSecond());
            }
        }
        return meta;
    }

    void decodeMetadata(String metadata) throws ServiceException {
        this.decodeMetadata(new Metadata(metadata, this));
    }

    void decodeMetadata(Metadata meta) throws ServiceException {
        if (meta == null) {
            return;
        }
        this.mRGBColor = Color.fromMetadata(meta.getLong("c", 0L));
        this.mVersion = (int)meta.getLong("ver", 1L);
        this.mExtendedData = null;
        for (Map.Entry entry : meta.asMap().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(CUSTOM_META_PREFIX)) continue;
            if (this.mExtendedData == null) {
                this.mExtendedData = new CustomMetadata.CustomMetadataList();
            }
            this.mExtendedData.addSection(key.substring(CUSTOM_META_PREFIX.length()), entry.getValue().toString());
        }
    }

    protected void saveMetadata() throws ServiceException {
        this.saveMetadata(this.encodeMetadata());
    }

    protected void saveMetadata(String metadata) throws ServiceException {
        this.mData.metadataChanged(this.mMailbox);
        if (ZimbraLog.mailop.isDebugEnabled()) {
            ZimbraLog.mailop.debug("saving metadata for " + MailItem.getMailopContext(this));
        }
        DbMailItem.saveMetadata(this, metadata);
    }

    protected void saveName() throws ServiceException {
        this.saveName(this.getFolderId());
    }

    protected void saveName(int folderId) throws ServiceException {
        this.mData.contentChanged(this.mMailbox);
        DbMailItem.saveName(this, folderId, this.encodeMetadata());
    }

    protected void saveData(String sender) throws ServiceException {
        this.saveData(sender, this.encodeMetadata());
    }

    protected void saveData(String sender, String metadata) throws ServiceException {
        this.mData.metadataChanged(this.mMailbox);
        if (ZimbraLog.mailop.isDebugEnabled()) {
            ZimbraLog.mailop.debug("saving data for " + MailItem.getMailopContext(this));
        }
        DbMailItem.saveData(this, this.mData.subject, sender, metadata);
    }

    protected StringBuffer appendCommonMembers(StringBuffer sb) {
        sb.append(CN_ID).append(": ").append(this.mId).append(", ");
        sb.append(CN_TYPE).append(": ").append(this.mData.type).append(", ");
        if (this.mData.name != null) {
            sb.append(CN_NAME).append(": ").append(this.mData.name).append(", ");
        }
        sb.append(CN_UNREAD_COUNT).append(": ").append(this.mData.unreadCount).append(", ");
        if (this.mData.flags != 0) {
            sb.append(CN_FLAGS).append(": ").append(this.getFlagString()).append(", ");
        }
        if (this.mData.tags != 0L) {
            sb.append(CN_TAGS).append(": [").append(this.getTagString()).append("], ");
        }
        sb.append(CN_FOLDER_ID).append(": ").append(this.mData.folderId).append(", ");
        sb.append(CN_SIZE).append(": ").append(this.mData.size).append(", ");
        if (this.mVersion > 1) {
            sb.append(CN_VERSION).append(": ").append(this.mVersion).append(", ");
        }
        if (this.mData.parentId > 0) {
            sb.append(CN_PARENT_ID).append(": ").append(this.mData.parentId).append(", ");
        }
        if (this.mRGBColor != null) {
            sb.append(CN_COLOR).append(": ").append(this.mRGBColor.getMappedColor()).append(", ");
        }
        if (this.mData.subject != null) {
            sb.append(CN_SUBJECT).append(": ").append(this.mData.subject).append(", ");
        }
        if (this.getDigest() != null) {
            sb.append(CN_BLOB_DIGEST).append(": ").append(this.getDigest()).append(", ");
        }
        if (this.mData.imapId > 0) {
            sb.append(CN_IMAP_ID).append(": ").append(this.mData.imapId).append(", ");
        }
        sb.append(CN_DATE).append(": ").append(this.mData.date).append(", ");
        sb.append(CN_REVISION).append(": ").append(this.mData.modContent).append(", ");
        return sb;
    }

    Metadata serializeUnderlyingData() {
        Metadata meta = this.mData.serialize();
        Metadata metaMeta = new Metadata();
        this.encodeMetadata(metaMeta);
        meta.put("meta", metaMeta.toString());
        return meta;
    }

    public static class Color {
        private static final int ORANGE = 9;
        private static final long RGB_INDICATOR = 0x1000000L;
        private static final long RGB_INDICATOR_MASK = -16777216L;
        private static final long RGB_MASK = 0xFFFFFFL;
        private static final long[] COLORS = new long[]{0L, 10401525L, 10807014L, 9947313L, 12224229L, 16553622L, 16774835L, 16686035L, 0xD3D3D3L, 16628821L};
        private long mRgb;

        public Color(long rgb) {
            this.setRgb(rgb);
        }

        public Color(byte c) {
            this.setColor(c);
        }

        public Color(String color) {
            this.setColor(color);
        }

        static Color fromMetadata(long rgb) {
            Color c = new Color(0L);
            if ((rgb & 0xFFFFFFFFFF000000L) > 0L) {
                c.setRgb(rgb & 0xFFFFFFL);
            } else {
                c.setColor((byte)rgb);
            }
            return c;
        }

        public byte getRed() {
            return (byte)(this.mRgb >> 16 & 0xFFL);
        }

        public byte getGreen() {
            return (byte)(this.mRgb >> 8 & 0xFFL);
        }

        public byte getBlue() {
            return (byte)(this.mRgb & 0xFFL);
        }

        public long getRgb() {
            return this.mRgb;
        }

        public byte getMappedColor() {
            byte c = 0;
            for (long color : COLORS) {
                if (this.mRgb == color) {
                    return c;
                }
                c = (byte)(c + 1);
            }
            return 9;
        }

        public boolean hasMapping() {
            for (long color : COLORS) {
                if (this.mRgb != color) continue;
                return true;
            }
            return false;
        }

        public void set(Color that) {
            this.mRgb = that.mRgb;
        }

        public void setRgb(long rgb) {
            this.mRgb = rgb;
        }

        public void setColor(byte color) {
            if (color > 9 || color < 0) {
                color = (byte)9;
            }
            this.mRgb = COLORS[color];
        }

        public void setColor(String color) {
            if (color.length() == 7) {
                color = color.substring(1);
            }
            if (color.length() == 6) {
                this.mRgb = Integer.parseInt(color.substring(0, 2), 16) << 16 | Integer.parseInt(color.substring(2, 4), 16) << 8 | Integer.parseInt(color.substring(4), 16);
            }
        }

        long toMetadata() {
            return this.mRgb | 0x1000000L;
        }

        public boolean equals(Object that) {
            if (that instanceof Color) {
                return this.mRgb == ((Color)that).mRgb;
            }
            return false;
        }

        public String toString() {
            String rgb = Long.toHexString(this.mRgb);
            int padding = 6 - rgb.length();
            for (int i = 0; i < padding; ++i) {
                rgb = "0" + rgb;
            }
            return "#" + rgb;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DeleteScope {
        ENTIRE_ITEM,
        CONTENTS_ONLY;

    }

    public static class PendingDelete {
        public int rootId;
        public int deletedTypes;
        public boolean incomplete;
        public long size;
        public int contacts;
        public TypedIdList itemIds = new TypedIdList();
        public List<Integer> unreadIds = new ArrayList<Integer>(1);
        public List<Integer> cascadeIds;
        public Set<Integer> modifiedIds = new HashSet<Integer>(2);
        public List<String> indexIds = new ArrayList<String>(1);
        public Set<String> sharedIndex;
        public List<MailboxBlob> blobs = new ArrayList<MailboxBlob>(1);
        public Map<Integer, DbMailItem.LocationCount> messages = new HashMap<Integer, DbMailItem.LocationCount>(2);
        public Set<String> blobDigests = new HashSet<String>(2);

        PendingDelete add(PendingDelete other) {
            if (other != null) {
                this.deletedTypes |= other.deletedTypes;
                this.incomplete |= other.incomplete;
                this.size += other.size;
                this.contacts += other.contacts;
                this.itemIds.add(other.itemIds);
                this.unreadIds.addAll(other.unreadIds);
                this.modifiedIds.addAll(other.modifiedIds);
                this.indexIds.addAll(other.indexIds);
                this.blobs.addAll(other.blobs);
                this.blobDigests.addAll(other.blobDigests);
                if (other.cascadeIds != null) {
                    (this.cascadeIds == null ? (this.cascadeIds = new ArrayList<Integer>(other.cascadeIds.size())) : this.cascadeIds).addAll(other.cascadeIds);
                }
                if (other.sharedIndex != null) {
                    (this.sharedIndex == null ? (this.sharedIndex = new HashSet<String>(other.sharedIndex.size())) : this.sharedIndex).addAll(other.sharedIndex);
                }
                for (Map.Entry<Integer, DbMailItem.LocationCount> entry : other.messages.entrySet()) {
                    DbMailItem.LocationCount lcount = this.messages.get(entry.getKey());
                    if (lcount == null) {
                        this.messages.put(entry.getKey(), new DbMailItem.LocationCount(entry.getValue()));
                        continue;
                    }
                    lcount.increment(entry.getValue());
                }
            }
            return this;
        }
    }

    static class TemporaryIndexingException
    extends Exception {
        private static final long serialVersionUID = 730987946876783701L;

        TemporaryIndexingException() {
        }
    }

    public static final class SortNameNaturalOrderDescending
    extends SortNameNaturalOrder {
        protected int returnResult(int result) {
            return -result;
        }
    }

    public static final class SortNameNaturalOrderAscending
    extends SortNameNaturalOrder {
        protected int returnResult(int result) {
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SortNameNaturalOrder
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            if (m1.getName() == null) {
                return this.returnResult(1);
            }
            if (m2.getName() == null) {
                return this.returnResult(-1);
            }
            return this.compareString(new Name(m1.getName()), new Name(m2.getName()));
        }

        public int compareString(Name n1, Name n2) {
            char first = n1.getChar();
            char second = n2.getChar();
            if (this.isDigit(first) && this.isDigit(second)) {
                return this.compareNumeric(n1, n2);
            }
            if (first != second) {
                return this.returnResult(first - second);
            }
            if (first == '\u0000' && second == '\u0000') {
                return 0;
            }
            return this.compareString(n1.next(), n2.next());
        }

        public int compareNumeric(Name n1, Name n2) {
            int secondNum;
            int firstNum = this.readInt(n1);
            if (firstNum != (secondNum = this.readInt(n2))) {
                return this.returnResult(firstNum - secondNum);
            }
            return this.compareString(n1.next(), n2.next());
        }

        public int readInt(Name n) {
            int start = n.pos;
            int end = 0;
            while (this.isDigit(n.getChar())) {
                n.next();
            }
            end = n.pos;
            if (end == start) {
                return 0;
            }
            try {
                return Integer.parseInt(new String(n.buf, start, end - start));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        public boolean isDigit(char c) {
            return Character.isDigit(c);
        }

        protected abstract int returnResult(int var1);

        private static class Name {
            public char[] buf;
            public int pos;
            public int len;

            public Name(String n) {
                this.buf = n.toCharArray();
                this.pos = 0;
                this.len = this.buf.length;
            }

            public char getChar() {
                if (this.pos < this.len) {
                    return this.buf[this.pos];
                }
                return '\u0000';
            }

            public Name next() {
                if (this.pos < this.len) {
                    ++this.pos;
                }
                return this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortSubjectDescending
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            return -m1.getSubject().compareToIgnoreCase(m2.getSubject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortSubjectAscending
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            return m1.getSubject().compareToIgnoreCase(m2.getSubject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortImapUid
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            return m1.getImapUid() - m2.getImapUid();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortDateDescending
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            long t2;
            long t1 = m1.getDate();
            if (t1 < (t2 = m2.getDate())) {
                return 1;
            }
            if (t1 == t2) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortDateAscending
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            long t2;
            long t1 = m1.getDate();
            if (t1 < (t2 = m2.getDate())) {
                return -1;
            }
            if (t1 == t2) {
                return 0;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortModifiedSequenceAscending
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            return m1.getModifiedSequence() - m2.getModifiedSequence();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortIdDescending
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            return m2.getId() - m1.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortIdAscending
    implements Comparator<MailItem> {
        @Override
        public int compare(MailItem m1, MailItem m2) {
            return m1.getId() - m2.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CustomMetadata
    extends HashMap<String, String> {
        private static final long serialVersionUID = -3866150929202858077L;
        private final String mSectionKey;
        private String mSerializedValue;

        public CustomMetadata(String section) {
            this(section, null);
        }

        public CustomMetadata(String section, String serialized) {
            super(8);
            this.mSectionKey = section.trim();
            this.mSerializedValue = serialized;
        }

        static CustomMetadata deserialize(Pair<String, String> serialized) throws ServiceException {
            CustomMetadata custom = new CustomMetadata(serialized.getFirst());
            for (Map.Entry entry : new Metadata(serialized.getSecond()).asMap().entrySet()) {
                custom.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return custom;
        }

        public String getSectionKey() {
            return this.mSectionKey;
        }

        public String getSerializedValue() {
            if (this.mSerializedValue != null) {
                return this.mSerializedValue;
            }
            this.remove(null);
            return new Metadata(this).toString();
        }

        @Override
        public String toString() {
            return this.mSectionKey + ": " + super.toString();
        }

        public CustomMetadataList asList() {
            return this.isEmpty() ? null : new CustomMetadataList(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class CustomMetadataList
        extends ArrayList<Pair<String, String>> {
            private static final long serialVersionUID = 3213399133413270157L;

            public CustomMetadataList() {
                super(1);
            }

            public CustomMetadataList(CustomMetadata custom) {
                this();
                this.addSection(custom);
            }

            public void addSection(CustomMetadata custom) {
                if (custom.isEmpty()) {
                    this.removeSection(custom.getSectionKey());
                } else {
                    this.addSection(custom.getSectionKey(), custom.getSerializedValue());
                }
            }

            public void addSection(String key, String encoded) {
                this.removeSection(key);
                if (key != null && encoded != null) {
                    this.add(new Pair<String, String>(key, encoded));
                }
            }

            public CustomMetadata getSection(String key) throws ServiceException {
                if (!this.isEmpty()) {
                    for (Pair entry : this) {
                        if (!key.equals(entry.getFirst())) continue;
                        return CustomMetadata.deserialize(entry);
                    }
                }
                return null;
            }

            public List<String> listSections() {
                ArrayList<String> sections = new ArrayList<String>(this.size());
                for (Pair entry : this) {
                    sections.add((String)entry.getFirst());
                }
                return sections;
            }

            public void removeSection(String key) {
                if (key != null && !this.isEmpty()) {
                    Iterator it = this.iterator();
                    while (it.hasNext()) {
                        if (!key.equals(((Pair)it.next()).getFirst())) continue;
                        it.remove();
                    }
                }
            }

            public long guessSize() {
                long size = 0L;
                if (!this.isEmpty()) {
                    for (Pair entry : this) {
                        size += (long)(((String)entry.getFirst()).length() + ((String)entry.getSecond()).length());
                    }
                }
                return size;
            }
        }
    }

    public static final class TargetConstraint {
        public static final short INCLUDE_TRASH = 1;
        public static final short INCLUDE_SPAM = 2;
        public static final short INCLUDE_SENT = 4;
        public static final short INCLUDE_OTHERS = 8;
        public static final short INCLUDE_QUERY = 16;
        private static final short ALL_LOCATIONS = 15;
        private static final char ENC_TRASH = 't';
        private static final char ENC_SPAM = 'j';
        private static final char ENC_SENT = 's';
        private static final char ENC_OTHER = 'o';
        private static final char ENC_QUERY = 'q';
        private short inclusions;
        private String query;
        private Mailbox mailbox;
        private int sentFolder = -1;

        public TargetConstraint(Mailbox mbox, short include) {
            this(mbox, include, null);
        }

        public TargetConstraint(Mailbox mbox, String includeQuery) {
            this(mbox, 16, includeQuery);
        }

        public TargetConstraint(Mailbox mbox, short include, String includeQuery) {
            this.mailbox = mbox;
            if (includeQuery == null || includeQuery.trim().length() == 0) {
                this.inclusions = (short)(include & 0xFFFFFFEF);
            } else {
                this.inclusions = (short)(include | 0x10);
                this.query = includeQuery;
            }
        }

        public static TargetConstraint parseConstraint(Mailbox mbox, String encoded) throws ServiceException {
            if (encoded == null) {
                return null;
            }
            boolean invert = false;
            short inclusions = 0;
            String query = null;
            block8: for (int i = 0; i < encoded.length(); ++i) {
                switch (encoded.charAt(i)) {
                    case 't': {
                        inclusions = (short)(inclusions | 1);
                        continue block8;
                    }
                    case 'j': {
                        inclusions = (short)(inclusions | 2);
                        continue block8;
                    }
                    case 's': {
                        inclusions = (short)(inclusions | 4);
                        continue block8;
                    }
                    case 'o': {
                        inclusions = (short)(inclusions | 8);
                        continue block8;
                    }
                    case 'q': {
                        inclusions = (short)(inclusions | 0x10);
                        query = encoded.substring(i + 1);
                        break block8;
                    }
                    case '-': {
                        if (i == 0 && encoded.length() > 1) {
                            invert = true;
                            continue block8;
                        }
                    }
                    default: {
                        throw ServiceException.INVALID_REQUEST("invalid encoded constraint: " + encoded, null);
                    }
                }
            }
            if (invert) {
                inclusions = (short)(inclusions ^ 0xF);
            }
            return new TargetConstraint(mbox, inclusions, query);
        }

        public String toString() {
            if (this.inclusions == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            if ((this.inclusions & 1) != 0) {
                sb.append('t');
            }
            if ((this.inclusions & 2) != 0) {
                sb.append('j');
            }
            if ((this.inclusions & 4) != 0) {
                sb.append('s');
            }
            if ((this.inclusions & 8) != 0) {
                sb.append('o');
            }
            if ((this.inclusions & 0x10) != 0) {
                sb.append('q').append(this.query);
            }
            return sb.toString();
        }

        public static boolean checkItem(TargetConstraint tcon, MailItem item) throws ServiceException {
            return tcon == null ? true : tcon.checkItem(item);
        }

        private boolean checkItem(MailItem item) throws ServiceException {
            if ((this.inclusions & 0xF) == 0) {
                return false;
            }
            if ((this.inclusions & 1) != 0 && item.inTrash()) {
                return true;
            }
            if ((this.inclusions & 2) != 0 && item.inSpam()) {
                return true;
            }
            if ((this.inclusions & 4) != 0 && this.inSent(item)) {
                return true;
            }
            return (this.inclusions & 8) != 0 && !item.inTrash() && !item.inSpam() && !this.inSent(item);
        }

        private boolean inSent(MailItem item) {
            if (item.getFolderId() != 5) {
                return false;
            }
            if (this.sentFolder == -1) {
                this.sentFolder = 5;
                try {
                    String sent = this.mailbox.getAccount().getAttr("zimbraPrefSentMailFolder", null);
                    if (sent != null) {
                        this.sentFolder = this.mailbox.getFolderByPath(null, sent).getId();
                    }
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            return this.sentFolder == 5 && this.sentFolder == item.getFolderId();
        }
    }

    public static final class UnderlyingData
    implements Cloneable {
        public int id;
        public byte type;
        public int parentId = -1;
        public int folderId = -1;
        public String indexId;
        public int imapId = -1;
        public String locator;
        private String blobDigest;
        public int date;
        public long size;
        public int unreadCount;
        public int flags;
        public long tags;
        public String subject;
        public String name;
        public String metadata;
        public int modMetadata;
        public int dateChanged;
        public int modContent;
        private static final String FN_ID = "id";
        private static final String FN_TYPE = "tp";
        private static final String FN_PARENT_ID = "pid";
        private static final String FN_FOLDER_ID = "fid";
        private static final String FN_INDEX_ID = "idx";
        private static final String FN_IMAP_ID = "imap";
        private static final String FN_LOCATOR = "loc";
        private static final String FN_BLOB_DIGEST = "dgst";
        private static final String FN_DATE = "dt";
        private static final String FN_SIZE = "sz";
        private static final String FN_UNREAD_COUNT = "uc";
        private static final String FN_FLAGS = "fg";
        private static final String FN_TAGS = "tg";
        private static final String FN_SUBJECT = "sbj";
        private static final String FN_NAME = "nm";
        private static final String FN_METADATA = "meta";
        private static final String FN_MOD_METADATA = "modm";
        private static final String FN_MOD_CONTENT = "modc";
        private static final String FN_DATE_CHANGED = "dc";

        public String getBlobDigest() {
            return this.blobDigest;
        }

        public void setBlobDigest(String digest) {
            this.blobDigest = "".equals(digest) ? null : digest;
        }

        public boolean isUnread() {
            return this.unreadCount > 0;
        }

        UnderlyingData duplicate(int newId, int newFolder, String newLocator) {
            UnderlyingData data = new UnderlyingData();
            data.id = newId;
            data.type = this.type;
            data.parentId = this.parentId;
            data.folderId = newFolder;
            data.indexId = this.indexId;
            data.imapId = this.imapId <= 0 ? this.imapId : newId;
            data.locator = newLocator;
            data.blobDigest = this.blobDigest;
            data.date = this.date;
            data.size = this.size;
            data.flags = this.flags;
            data.tags = this.tags;
            data.subject = this.subject;
            data.unreadCount = this.unreadCount;
            return data;
        }

        protected UnderlyingData clone() {
            try {
                return (UnderlyingData)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                return null;
            }
        }

        void metadataChanged(Mailbox mbox) throws ServiceException {
            this.modMetadata = mbox.getOperationChangeID();
            this.dateChanged = mbox.getOperationTimestamp();
            if (!MailItem.isAcceptableType((byte)1, this.type)) {
                mbox.getFolderById(this.folderId).updateHighestMODSEQ();
            }
        }

        void contentChanged(Mailbox mbox) throws ServiceException {
            this.metadataChanged(mbox);
            this.modContent = this.modMetadata;
        }

        Metadata serialize() {
            Metadata meta = new Metadata();
            meta.put("id", this.id);
            meta.put(FN_TYPE, this.type);
            meta.put(FN_PARENT_ID, this.parentId);
            meta.put(FN_FOLDER_ID, this.folderId);
            meta.put(FN_INDEX_ID, this.indexId);
            meta.put(FN_IMAP_ID, this.imapId);
            meta.put(FN_LOCATOR, this.locator);
            meta.put(FN_BLOB_DIGEST, this.blobDigest);
            meta.put(FN_DATE, this.date);
            meta.put(FN_SIZE, this.size);
            meta.put(FN_UNREAD_COUNT, this.unreadCount);
            meta.put(FN_FLAGS, this.flags);
            meta.put(FN_TAGS, this.tags);
            meta.put(FN_SUBJECT, this.subject);
            meta.put(FN_NAME, this.name);
            meta.put(FN_METADATA, this.metadata);
            meta.put(FN_MOD_METADATA, this.modMetadata);
            meta.put(FN_MOD_CONTENT, this.modContent);
            meta.put(FN_DATE_CHANGED, this.dateChanged);
            return meta;
        }

        void deserialize(Metadata meta) throws ServiceException {
            this.id = (int)meta.getLong("id", 0L);
            this.type = (byte)meta.getLong(FN_TYPE, 0L);
            this.parentId = (int)meta.getLong(FN_PARENT_ID, -1L);
            this.folderId = (int)meta.getLong(FN_FOLDER_ID, -1L);
            this.indexId = meta.get(FN_INDEX_ID, null);
            this.imapId = (int)meta.getLong(FN_IMAP_ID, -1L);
            this.locator = meta.get(FN_LOCATOR, null);
            this.blobDigest = meta.get(FN_BLOB_DIGEST, null);
            this.date = (int)meta.getLong(FN_DATE, 0L);
            this.size = meta.getLong(FN_SIZE, 0L);
            this.unreadCount = (int)meta.getLong(FN_UNREAD_COUNT, 0L);
            this.flags = (int)meta.getLong(FN_FLAGS, 0L);
            this.tags = meta.getLong(FN_TAGS, 0L);
            this.subject = meta.get(FN_SUBJECT, null);
            this.name = meta.get(FN_NAME, null);
            this.metadata = meta.get(FN_METADATA, null);
            this.modMetadata = (int)meta.getLong(FN_MOD_METADATA, 0L);
            this.modContent = (int)meta.getLong(FN_MOD_CONTENT, 0L);
            this.dateChanged = (int)meta.getLong(FN_DATE_CHANGED, 0L);
        }
    }
}

