/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ThreadPool;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbSearch;
import com.zimbra.cs.db.DbSearchConstraints;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxVersion;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.util.SyncToken;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexHelper {
    private static final long sBatchIndexMaxBytesPerTransaction = LC.zimbra_index_max_transaction_bytes.longValue();
    private static final int sBatchIndexMaxItemsPerTransaction = LC.zimbra_index_max_transaction_items.intValue();
    private static final long sIndexDeferredItemsRetryIntervalMs = LC.zimbra_index_deferred_items_delay.longValue() * 1000L;
    private static final long sIndexItemDeferredRetryDelayAfterFailureMs = 1000L * LC.zimbra_index_deferred_items_failure_delay.longValue();
    private SyncToken mHighestSubmittedToIndex = null;
    private int mNumIndexingInProgress = 0;
    private long mLastIndexingFailureTimestamp = 0L;
    private boolean mFullReindexInProgress = false;
    private Mailbox.BatchedIndexStatus mReIndexStatus = null;
    private long mLastIndexDeferredTime = 0L;
    private boolean mIndexingDeferredItems = false;
    private Object mIndexingDeferredItemsLock = new Object();
    private Mailbox mMbox;
    static ThreadPool sReIndexThreadPool = new ThreadPool("ReIndex", LC.zimbra_index_reindex_pool_size.intValue());
    static ThreadPool sIndexingCompletedThreadPool = new ThreadPool("IndexingCompleted", LC.zimbra_index_completed_pool_size.intValue());
    private MailboxIndex mMailboxIndex = null;
    private Object mIndexImmediatelyModeLock = new Object();
    private int mInIndexImmediatelyMode = 0;
    private static final int NO_CHANGE = -1;

    IndexHelper(Mailbox mbox) {
        this.mMbox = mbox;
    }

    static void startup() {
    }

    static void shutdown() {
        ZimbraLog.index.info("Shutting down IndexHelper thread pools....");
        sReIndexThreadPool.shutdownNow();
        ZimbraLog.index.info("...ReIndexing threadpool shutdown completed.");
        sIndexingCompletedThreadPool.shutdown();
        ZimbraLog.index.info("...IndexingCompleted threadpool shutdown completed.");
    }

    void instantiateMailboxIndex() throws ServiceException {
        this.mMailboxIndex = new MailboxIndex(this.getMailbox(), null);
    }

    private final Mailbox getMailbox() {
        return this.mMbox;
    }

    final MailboxIndex getMailboxIndex() {
        return this.mMailboxIndex;
    }

    ZimbraQueryResults search(SoapProtocol proto, OperationContext octxt, SearchParams params) throws IOException, ParseException, ServiceException {
        if (Thread.holdsLock(this.getMailbox())) {
            throw ServiceException.INVALID_REQUEST("Must not call Mailbox.search() while holding Mailbox lock", null);
        }
        if (octxt == null) {
            throw ServiceException.INVALID_REQUEST("The OperationContext must not be null", null);
        }
        try {
            boolean textIndexOutOfSync;
            boolean bl = textIndexOutOfSync = this.getNumNotSubmittedToIndex() > 0;
            if (this.mFullReindexInProgress) {
                textIndexOutOfSync = false;
            }
            return MailboxIndex.search(proto, octxt, this.getMailbox(), params, textIndexOutOfSync);
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.TEXT_INDEX_OUT_OF_SYNC") {
                this.indexDeferredItems();
                return MailboxIndex.search(proto, octxt, this.getMailbox(), params, false);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndexImmediatelyMode() {
        if (Thread.holdsLock(this.getMailbox())) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        IndexHelper.this.setIndexImmediatelyMode();
                    }
                    catch (OutOfMemoryError e) {
                        Zimbra.halt("Out of memory in AsyncSetIndexImmediatelyMode call to " + IndexHelper.this.getMailbox(), e);
                    }
                }
            };
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            Object object = this.mIndexImmediatelyModeLock;
            synchronized (object) {
                ++this.mInIndexImmediatelyMode;
            }
            this.indexDeferredItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearIndexImmediatelyMode() {
        Object object = this.mIndexImmediatelyModeLock;
        synchronized (object) {
            --this.mInIndexImmediatelyMode;
        }
    }

    String generateIndexId(int itemId) {
        if (this.getMailboxIndex() != null) {
            return this.getMailboxIndex().generateIndexId(itemId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBatchedIndexingCount() {
        Object object = this.mIndexImmediatelyModeLock;
        synchronized (object) {
            if (this.mInIndexImmediatelyMode > 0) {
                return 0;
            }
            if (this.getMailboxIndex() != null) {
                return this.getMailboxIndex().getBatchedIndexingCount();
            }
            return 0;
        }
    }

    void flush() {
        if (this.mMailboxIndex != null) {
            this.mMailboxIndex.flush();
        }
    }

    void deleteIndex() throws IOException {
        if (this.mMailboxIndex != null) {
            this.mMailboxIndex.deleteIndex();
        }
    }

    List<String> deleteDocuments(List<String> indexIds) throws IOException {
        if (this.getMailboxIndex() != null) {
            return this.getMailboxIndex().deleteDocuments(indexIds);
        }
        return indexIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeIndexDeferredItems() {
        if (Thread.holdsLock(this.getMailbox())) {
            return;
        }
        boolean shouldIndexDeferred = false;
        Mailbox mailbox = this.getMailbox();
        synchronized (mailbox) {
            long now;
            if (!this.mIndexingDeferredItems && this.getNumNotSubmittedToIndex() >= this.getBatchedIndexingCount() && (now = System.currentTimeMillis()) - sIndexItemDeferredRetryDelayAfterFailureMs > this.mLastIndexingFailureTimestamp && now - sIndexDeferredItemsRetryIntervalMs > this.mLastIndexDeferredTime) {
                shouldIndexDeferred = true;
            }
        }
        if (shouldIndexDeferred) {
            this.indexDeferredItems();
        }
    }

    int getNumNotSubmittedToIndex() {
        return this.getMailbox().getIndexDeferredCount() - this.mNumIndexingInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexDeferredItems() {
        Object object;
        assert (!Thread.holdsLock(this.getMailbox()));
        assert (!Thread.holdsLock(this.mIndexingDeferredItemsLock));
        Object object2 = this.mIndexingDeferredItemsLock;
        synchronized (object2) {
            Mailbox mailbox = this.getMailbox();
            synchronized (mailbox) {
                this.mLastIndexDeferredTime = System.currentTimeMillis();
                if (this.getNumNotSubmittedToIndex() == 0) {
                    return;
                }
            }
            while (this.mIndexingDeferredItems) {
                try {
                    this.mIndexingDeferredItemsLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.mIndexingDeferredItems = true;
        }
        try {
            this.indexDeferredItemsInternal();
            Object var6_6 = null;
            object = this.mIndexingDeferredItemsLock;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Object object3 = this.mIndexingDeferredItemsLock;
            synchronized (object3) {
                Mailbox mailbox = this.getMailbox();
                synchronized (mailbox) {
                    this.mLastIndexDeferredTime = System.currentTimeMillis();
                }
                this.mIndexingDeferredItems = false;
                this.mIndexingDeferredItemsLock.notify();
            }
            throw throwable;
        }
        synchronized (object) {
            Mailbox mailbox = this.getMailbox();
            synchronized (mailbox) {
                this.mLastIndexDeferredTime = System.currentTimeMillis();
            }
            this.mIndexingDeferredItems = false;
            this.mIndexingDeferredItemsLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexDeferredItemsInternal() {
        assert (!Thread.holdsLock(this.getMailbox()));
        assert (!Thread.holdsLock(this.mIndexingDeferredItemsLock));
        assert (this.mIndexingDeferredItems);
        long start = 0L;
        if (ZimbraLog.mailbox.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        ArrayList<DbSearch.SearchResult> items = new ArrayList<DbSearch.SearchResult>();
        Mailbox mailbox = this.getMailbox();
        synchronized (mailbox) {
            try {
                boolean success = false;
                try {
                    this.getMailbox().beginTransaction("IndexDeferredItems_Select", null);
                    DbSearchConstraints c = new DbSearchConstraints();
                    if (this.mNumIndexingInProgress > 0) assert (this.mHighestSubmittedToIndex != null);
                    DbSearchConstraints.NumericRange nr = new DbSearchConstraints.NumericRange();
                    nr.lowest = this.mHighestSubmittedToIndex == null ? (long)this.getMailbox().getHighestFlushedToIndex().getChangeId() : (long)this.mHighestSubmittedToIndex.getChangeId();
                    c.modified.add(nr);
                    c.modifiedContent.add(nr);
                    DbSearch.search(items, this.getMailbox().getOperationConnection(), c, this.getMailbox(), SortBy.NONE, DbSearch.SearchResult.ExtraData.MODCONTENT);
                    int deferredCount = this.getMailbox().getIndexDeferredCount();
                    int numInProgress = this.mNumIndexingInProgress;
                    if (items.size() + this.mNumIndexingInProgress != deferredCount) {
                        if (ZimbraLog.mailbox.isInfoEnabled()) {
                            ZimbraLog.mailbox.info("IndexDeferredItems(" + this.mHighestSubmittedToIndex + ", " + nr.lowest + "): Deferred count out of sync - found=" + items.size() + " " + "in progress=" + numInProgress + " (deferred count=" + this.getMailbox().getIndexDeferredCount() + ")");
                        }
                        this.getMailbox().setCurrentChangeIndexDeferredCount(items.size() + this.mNumIndexingInProgress);
                    } else if (ZimbraLog.mailbox.isDebugEnabled()) {
                        ZimbraLog.mailbox.debug("IndexDeferredItems(" + this.mHighestSubmittedToIndex + ", " + nr.lowest + "): found=" + items.size() + " " + "in progress=" + numInProgress + " (deferred count=" + this.getMailbox().getIndexDeferredCount() + ")");
                    }
                    success = true;
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    this.getMailbox().endTransaction(success);
                    throw throwable;
                }
                this.getMailbox().endTransaction(success);
                {
                }
            }
            catch (ServiceException e) {
                ZimbraLog.mailbox.info((Object)"Unable to index deferred items due to exception in step 1", e);
                return;
            }
        }
        Mailbox.BatchedIndexStatus status = new Mailbox.BatchedIndexStatus();
        status.mNumToProcess = items.size();
        try {
            this.indexItemList(items, status, false);
        }
        catch (ServiceException e) {
            ZimbraLog.mailbox.info((Object)"Exception from Mailbox.indexItemList", e);
        }
        if (ZimbraLog.mailbox.isInfoEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            String itemsPerSec = String.format("%.2f", 1000.0 * (double)(status.mNumProcessed - status.mNumFailed) / (double)elapsed);
            int successful = status.mNumProcessed - status.mNumFailed;
            if (ZimbraLog.mailbox.isInfoEnabled()) {
                ZimbraLog.mailbox.info("Deferred Indexing: submitted " + successful + " items in " + elapsed + "ms (" + itemsPerSec + "/sec). (" + status.mNumFailed + " items failed to index).  IndexDeferredCount now at " + this.getMailbox().getIndexDeferredCount() + " NumNotSubmitted= " + this.getNumNotSubmittedToIndex());
            }
        }
    }

    void reIndexInBackgroundThread(OperationContext octxt, Set<Byte> types, Set<Integer> itemIds, boolean skipDelete) throws ServiceException {
        this.startReIndex(new ReIndexTask(octxt, types, itemIds, skipDelete), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReIndex(ReIndexTask task, boolean globalStatus) throws ServiceException {
        try {
            if (globalStatus) {
                Mailbox mailbox = this.getMailbox();
                synchronized (mailbox) {
                    if (this.getMailbox().isReIndexInProgress()) {
                        throw ServiceException.ALREADY_IN_PROGRESS(Long.toString(this.getMailbox().getId()), this.mReIndexStatus.toString());
                    }
                    this.mReIndexStatus = task.mStatus;
                    task.setUseGlobalStatus(true);
                }
            }
            sReIndexThreadPool.execute(task);
        }
        catch (RejectedExecutionException e) {
            throw ServiceException.FAILURE("Unable to submit reindex request.  Try again later", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexAllDeferredFlagItems() throws ServiceException {
        HashSet<Integer> itemSet = new HashSet<Integer>();
        Mailbox mailbox = this.getMailbox();
        synchronized (mailbox) {
            boolean success = false;
            try {
                this.getMailbox().beginTransaction("indexAllDeferredFlagItems", null);
                ArrayList<DbSearch.SearchResult> items = new ArrayList<DbSearch.SearchResult>();
                DbSearchConstraints c = new DbSearchConstraints();
                c.tags = new HashSet<Tag>();
                c.tags.add(this.getMailbox().getFlagById(-14));
                DbSearch.search(items, this.getMailbox().getOperationConnection(), c, this.getMailbox(), SortBy.NONE, DbSearch.SearchResult.ExtraData.MODCONTENT);
                for (DbSearch.SearchResult sr : items) {
                    itemSet.add(sr.id);
                }
                success = true;
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.getMailbox().endTransaction(success);
                throw throwable;
            }
            this.getMailbox().endTransaction(success);
        }
        ReIndexTask task = new ReIndexTask(null, null, itemSet, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onCompletion() {
                try {
                    Mailbox mailbox = IndexHelper.this.getMailbox();
                    synchronized (mailbox) {
                        boolean success = false;
                        try {
                            IndexHelper.this.getMailbox().beginTransaction("indexAllDeferredFlagItems", null);
                            ArrayList<DbSearch.SearchResult> items = new ArrayList<DbSearch.SearchResult>();
                            DbSearchConstraints c = new DbSearchConstraints();
                            c.tags = new HashSet<Tag>();
                            c.tags.add(IndexHelper.this.getMailbox().getFlagById(-14));
                            DbSearch.search(items, IndexHelper.this.getMailbox().getOperationConnection(), c, IndexHelper.this.getMailbox(), SortBy.NONE, DbSearch.SearchResult.ExtraData.MODCONTENT);
                            ArrayList<Integer> deferredTagsToClear = new ArrayList<Integer>();
                            Flag indexingDeferredFlag = IndexHelper.this.getMailbox().getFlagById(-14);
                            for (DbSearch.SearchResult sr : items) {
                                MailItem item = IndexHelper.this.getMailbox().getItemById(sr.id, sr.type);
                                deferredTagsToClear.add(sr.id);
                                item.tagChanged(indexingDeferredFlag, false);
                            }
                            IndexHelper.this.getMailbox().getOperationConnection();
                            DbMailItem.alterTag(indexingDeferredFlag, deferredTagsToClear, false);
                            success = true;
                            Object var11_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            IndexHelper.this.getMailbox().endTransaction(success);
                            throw throwable;
                        }
                        IndexHelper.this.getMailbox().endTransaction(success);
                        if (!IndexHelper.this.getMailbox().getVersion().atLeast(1, 5)) {
                            try {
                                IndexHelper.this.getMailbox().updateVersion(new MailboxVersion(1, 5));
                            }
                            catch (ServiceException se) {
                                ZimbraLog.mailbox.warn((Object)"Failed to update mbox version after reindex all deferred items during mailbox upgrade initialization.", se);
                            }
                        }
                    }
                }
                catch (ServiceException se) {
                    ZimbraLog.mailbox.warn((Object)"Failed to clear deferred flag after reindex all deferred items during mailbox upgrade initialization.", se);
                }
            }
        };
        try {
            if (itemSet.isEmpty()) {
                task.onCompletion();
            } else {
                this.startReIndex(task, false);
            }
        }
        catch (RejectedExecutionException e) {
            ZimbraLog.mailbox.warn("Failed to reindex deferred items on mailbox upgrade initialization.  Skipping (you will have to manually reindex this mailbox)");
        }
    }

    void indexingCompleted(int count, SyncToken newHighestModContent, boolean succeeded) {
        try {
            sIndexingCompletedThreadPool.execute(new IndexingCompletedTask(count, newHighestModContent, succeeded));
        }
        catch (RejectedExecutionException e) {
            ZimbraLog.index_add.warn("Unable to submit IndexingCompletedTask(" + count + "," + newHighestModContent + "," + succeeded + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexItemList(List<DbSearch.SearchResult> items, Mailbox.BatchedIndexStatus status, boolean dontTrackIndexing) throws ServiceException {
        assert (!Thread.holdsLock(this.getMailbox()));
        if (ZimbraLog.mailbox.isDebugEnabled()) {
            ZimbraLog.mailbox.debug("indexItemList(" + items.size() + " items, " + (dontTrackIndexing ? "TRUE" : "FALSE"));
        }
        if (items.size() == 0) {
            return;
        }
        Collections.sort(items, new Comparator<DbSearch.SearchResult>(){

            @Override
            public int compare(DbSearch.SearchResult lhs, DbSearch.SearchResult rhs) {
                int diff = (Integer)lhs.extraData - (Integer)rhs.extraData;
                if (diff == 0) {
                    return lhs.id - rhs.id;
                }
                return diff;
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        });
        ArrayList<Mailbox.IndexItemEntry> chunk = new ArrayList<Mailbox.IndexItemEntry>();
        long chunkSizeBytes = 0L;
        int itemsAttempted = 0;
        Iterator<DbSearch.SearchResult> iter = items.iterator();
        while (iter.hasNext()) {
            MailItem item;
            DbSearch.SearchResult sr;
            block32: {
                sr = iter.next();
                ++itemsAttempted;
                item = null;
                try {
                    item = this.getMailbox().getItemById(null, sr.id, sr.type);
                }
                catch (ServiceException e) {
                    if (ZimbraLog.index_add.isDebugEnabled()) {
                        ZimbraLog.index_add.debug((Object)("Error fetching deferred item id = " + sr.id + ".  Item will not be indexed."), e);
                    }
                }
                catch (RuntimeException e) {
                    if (!ZimbraLog.index_add.isDebugEnabled()) break block32;
                    ZimbraLog.index_add.debug((Object)("Error fetching deferred item id = " + sr.id + ".  Item will not be indexed."), e);
                }
            }
            if (item != null) {
                chunkSizeBytes += item.getSize();
                try {
                    assert (!Thread.holdsLock(this.getMailbox()));
                    chunk.add(new Mailbox.IndexItemEntry(false, item, (Integer)sr.extraData, item.generateIndexData(true)));
                }
                catch (MailItem.TemporaryIndexingException e) {
                    if (!dontTrackIndexing) {
                        if (ZimbraLog.index_add.isInfoEnabled()) {
                            ZimbraLog.index_add.info((Object)("Temporary error generating index data for item ID: " + item.getId() + ".  Indexing will be retried"), e);
                        }
                        this.mLastIndexingFailureTimestamp = System.currentTimeMillis();
                        throw ServiceException.FAILURE("Temporary indexing exception", e);
                    }
                    if (ZimbraLog.index_add.isInfoEnabled()) {
                        ZimbraLog.index_add.info((Object)("Temporary error generating index data for item ID: " + item.getId() + ".  Indexing will be skipped"), e);
                    }
                }
            } else if (ZimbraLog.index_add.isDebugEnabled()) {
                ZimbraLog.index_add.debug("SKIPPING indexing of item " + sr.id + " ptr=" + item);
            }
            int chunkSizeToUse = sBatchIndexMaxItemsPerTransaction;
            if (this.mLastIndexingFailureTimestamp > 0L) {
                chunkSizeToUse = 5;
            }
            if (!iter.hasNext() || chunkSizeBytes > sBatchIndexMaxBytesPerTransaction || chunk.size() >= chunkSizeToUse) {
                Object var20_22;
                try {
                    Mailbox mailbox = this.getMailbox();
                    synchronized (mailbox) {
                        block33: {
                            if (status.mCancel) {
                                ZimbraLog.mailbox.warn("CANCELLING batch index of Mailbox " + this.getMailbox().getId() + " before it is complete.  (" + status.mNumProcessed + " processed out of " + items.size() + ")");
                                throw ServiceException.INTERRUPTED("ReIndexing Canceled");
                            }
                            try {
                                Object var17_21;
                                boolean success = false;
                                try {
                                    this.getMailbox().beginTransaction("IndexItemList_Chunk", null);
                                    for (Mailbox.IndexItemEntry ie : chunk) {
                                        if (dontTrackIndexing) {
                                            ie.mModContent = -1;
                                        }
                                        this.getMailbox().addIndexItemToCurrentChange(ie);
                                    }
                                    success = true;
                                    var17_21 = null;
                                }
                                catch (Throwable throwable) {
                                    var17_21 = null;
                                    this.getMailbox().endTransaction(success);
                                    throw throwable;
                                }
                                this.getMailbox().endTransaction(success);
                                {
                                }
                            }
                            catch (ServiceException e) {
                                if (!ZimbraLog.index_add.isInfoEnabled()) break block33;
                                StringBuilder sb = new StringBuilder();
                                for (Mailbox.IndexItemEntry ie : chunk) {
                                    sb.append(ie.mMailItem.getId()).append('-').append(ie.mModContent).append(',');
                                }
                                ZimbraLog.index_add.info((Object)("Error deferred-indexing one chunk: " + sb.toString() + " skipping it (will retry)"), e);
                            }
                        }
                        status.mNumProcessed = itemsAttempted;
                    }
                    var20_22 = null;
                    chunk.clear();
                    chunkSizeBytes = 0L;
                }
                catch (Throwable throwable) {
                    var20_22 = null;
                    chunk.clear();
                    chunkSizeBytes = 0L;
                    throw throwable;
                }
            }
            if (!ZimbraLog.mailbox.isInfoEnabled() || itemsAttempted % 2000 != 0 || !this.getMailbox().isReIndexInProgress()) continue;
            ZimbraLog.mailbox.info("Batch Indexing: Mailbox " + this.getMailbox().getId() + " on item " + itemsAttempted + " out of " + items.size());
        }
    }

    void upgradeMailboxTo1_2() {
        HashSet<Byte> types = new HashSet<Byte>();
        types.add((byte)6);
        if (!types.isEmpty()) {
            ReIndexTask task = new ReIndexTask(null, types, null, false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onCompletion() {
                    Mailbox mailbox = IndexHelper.this.getMailbox();
                    synchronized (mailbox) {
                        if (!IndexHelper.this.getMailbox().getVersion().atLeast(1, 2)) {
                            try {
                                IndexHelper.this.getMailbox().updateVersion(new MailboxVersion(1, 2));
                            }
                            catch (ServiceException se) {
                                ZimbraLog.mailbox.warn((Object)"Failed to update mbox version after reindex contacts on mailbox upgrade initialization.", se);
                            }
                        }
                    }
                }
            };
            try {
                this.startReIndex(task, false);
            }
            catch (ServiceException e) {
                ZimbraLog.mailbox.warn("Failed to reindex contacts on mailbox upgrade initialization.  Skipping (you will have to manually reindex contacts for this mailbox)");
            }
        }
    }

    void redoIndexItem(MailItem item, boolean deleteFirst, int itemId, byte itemType, long timestamp, boolean noRedo, List<IndexDocument> docList) {
        try {
            if (this.getMailboxIndex() != null) {
                this.getMailboxIndex().indexMailItem(this.getMailbox(), deleteFirst, docList, item, -1);
            }
        }
        catch (Exception e) {
            ZimbraLog.index_add.info((Object)("Skipping indexing; Unable to parse message " + itemId + ": " + e.toString()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void indexingPartOfEndTransaction(List<Mailbox.IndexItemEntry> itemsToIndex, List<String> itemsToDelete) {
        block20: {
            block18: {
                try {
                    if (this.getMailboxIndex() != null && itemsToDelete != null && !itemsToDelete.isEmpty()) {
                        this.getMailboxIndex().deleteDocuments(itemsToDelete);
                    }
                }
                catch (IOException e) {
                    if (!ZimbraLog.index_add.isDebugEnabled()) break block18;
                    ZimbraLog.index_add.debug((Object)"Caught IOException attempting to delete index entries in EndTransaction", e);
                }
            }
            int lastMailItemId = 0;
            this.getMailboxIndex().beginWriteOperation();
            for (Mailbox.IndexItemEntry entry : itemsToIndex) {
                block19: {
                    MailItem item = entry.mMailItem;
                    lastMailItemId = item.getId();
                    if (entry.mDocuments == null) {
                        ZimbraLog.index_add.warn("Got NULL index data in endTransaction.  Item " + item.getId() + " will not be indexed.");
                        continue;
                    }
                    if (ZimbraLog.mailbox.isDebugEnabled()) {
                        ZimbraLog.mailbox.debug("indexMailItem(changeId=" + this.getMailbox().getLastChangeID() + ", " + "token=" + entry.mModContent + "-" + entry.mMailItem.getId() + ")");
                    }
                    if (this.getMailboxIndex() != null) {
                        SyncToken old = this.mHighestSubmittedToIndex;
                        try {
                            if (entry.mModContent != -1) {
                                ++this.mNumIndexingInProgress;
                                this.mHighestSubmittedToIndex = new SyncToken(entry.mModContent, item.getId());
                            }
                            this.getMailboxIndex().indexMailItem(this.getMailbox(), entry.mDeleteFirst, entry.mDocuments, item, entry.mModContent);
                        }
                        catch (ServiceException e) {
                            if (entry.mModContent == -1) break block19;
                            this.mHighestSubmittedToIndex = old;
                            --this.mNumIndexingInProgress;
                            throw e;
                        }
                    }
                }
                this.mLastIndexingFailureTimestamp = 0L;
            }
            Object var10_11 = null;
            try {
                this.getMailboxIndex().endWriteOperation();
            }
            catch (Exception e2) {
                ZimbraLog.index_add.warn((Object)"Caught exception while flushing index - indexing blocked.  Possibly corrupt index?", e2);
                this.mLastIndexingFailureTimestamp = System.currentTimeMillis();
            }
            break block20;
            {
                catch (Exception e) {
                    ZimbraLog.index_add.warn((Object)("Caught exception while indexing message id " + lastMailItemId + " - indexing blocked.  Possibly corrupt index?"), e);
                    this.mLastIndexingFailureTimestamp = System.currentTimeMillis();
                    Object var10_12 = null;
                    try {
                        this.getMailboxIndex().endWriteOperation();
                    }
                    catch (Exception e2) {
                        ZimbraLog.index_add.warn((Object)"Caught exception while flushing index - indexing blocked.  Possibly corrupt index?", e2);
                        this.mLastIndexingFailureTimestamp = System.currentTimeMillis();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    this.getMailboxIndex().endWriteOperation();
                }
                catch (Exception e2) {
                    ZimbraLog.index_add.warn((Object)"Caught exception while flushing index - indexing blocked.  Possibly corrupt index?", e2);
                    this.mLastIndexingFailureTimestamp = System.currentTimeMillis();
                }
                throw throwable;
            }
        }
    }

    final Mailbox.BatchedIndexStatus getReIndexStatus() {
        return this.mReIndexStatus;
    }

    private class IndexingCompletedTask
    implements Runnable {
        int count;
        SyncToken newHighestModContent;
        boolean succeeded;

        IndexingCompletedTask(int count, SyncToken newHighestModContent, boolean succeeded) {
            this.count = count;
            this.newHighestModContent = newHighestModContent;
            this.succeeded = succeeded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ZimbraLog.addMboxToContext(IndexHelper.this.getMailbox().getId());
                ZimbraLog.addAccountNameToContext(IndexHelper.this.getMailbox().getAccount().getName());
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            Mailbox mailbox = IndexHelper.this.getMailbox();
            synchronized (mailbox) {
                try {
                    boolean success = false;
                    try {
                        IndexHelper.this.getMailbox().beginTransaction("indexingCompleted", null);
                        ZimbraLog.index_add.debug("IndexingCompletedTask(" + this.count + "," + this.newHighestModContent + "," + this.succeeded + ")" + " numInProgress=" + IndexHelper.this.mNumIndexingInProgress + " curIdxDeferred=" + IndexHelper.this.getMailbox().getIndexDeferredCount());
                        if (this.count > IndexHelper.this.mNumIndexingInProgress) {
                            ZimbraLog.mailbox.warn("IndexingCompleted called with " + this.count + " but only " + IndexHelper.this.mNumIndexingInProgress + "in progress.");
                            this.count = IndexHelper.this.mNumIndexingInProgress;
                        }
                        IndexHelper.this.getMailbox().getOperationConnection();
                        SyncToken highestFlushedToIndex = IndexHelper.this.getMailbox().getHighestFlushedToIndex();
                        assert (this.newHighestModContent.after(highestFlushedToIndex));
                        if (!this.newHighestModContent.after(highestFlushedToIndex)) {
                            ZimbraLog.mailbox.warn("invalid set for HighestModContentIndex -- highestFlushedToIndex=" + highestFlushedToIndex + " requested=" + this.newHighestModContent);
                        } else {
                            IndexHelper.this.getMailbox().setCurrentChangeHighestModContentIndexed(this.newHighestModContent);
                        }
                        int curIdxDeferred = IndexHelper.this.getMailbox().getIndexDeferredCount();
                        int newCount = curIdxDeferred - this.count;
                        if (newCount < 0) {
                            ZimbraLog.index_add.info("Count out of whack during indexingCompleted - completed " + this.count + " entries but current " + "indexDeferred is only " + curIdxDeferred + " in progress=" + IndexHelper.this.mNumIndexingInProgress);
                        }
                        IndexHelper.this.getMailbox().setCurrentChangeIndexDeferredCount(Math.max(0, newCount));
                        IndexHelper.this.mNumIndexingInProgress -= this.count;
                        if (IndexHelper.this.mNumIndexingInProgress < 0) {
                            ZimbraLog.index_add.info("IndexingInProgress count out of whack during indexingCompleted");
                            IndexHelper.this.mNumIndexingInProgress = 0;
                        }
                        if (IndexHelper.this.mNumIndexingInProgress == 0) {
                            IndexHelper.this.mHighestSubmittedToIndex = null;
                        }
                        success = true;
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        IndexHelper.this.getMailbox().endTransaction(success);
                        throw throwable;
                    }
                    IndexHelper.this.getMailbox().endTransaction(success);
                    {
                    }
                }
                catch (ServiceException e) {
                    ZimbraLog.mailbox.info((Object)("Caught exception in indexingCompleted: " + e), e);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("out of memory", e);
                }
                catch (Throwable t) {
                    ZimbraLog.index_add.warn((Object)"Caught exception in async IndexingCompletedTask", t);
                }
            }
            ZimbraLog.removeMboxFromContext();
            ZimbraLog.removeAccountFromContext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReIndexTask
    implements Runnable {
        protected OperationContext mOctxt;
        protected Set<Byte> mTypesOrNull;
        protected Set<Integer> mItemIdsOrNull;
        protected boolean mSkipDelete;
        protected Mailbox.BatchedIndexStatus mStatus = new Mailbox.BatchedIndexStatus();
        protected boolean mUseGlobalStatus = false;

        ReIndexTask(OperationContext octxt, Set<Byte> typesOrNull, Set<Integer> itemIdsOrNull, boolean skipDelete) {
            this.mOctxt = octxt;
            this.mTypesOrNull = typesOrNull;
            this.mItemIdsOrNull = itemIdsOrNull;
            this.mSkipDelete = skipDelete;
        }

        void setUseGlobalStatus(boolean value) {
            this.mUseGlobalStatus = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {
                    ZimbraLog.addMboxToContext(IndexHelper.this.getMailbox().getId());
                    ZimbraLog.addAccountNameToContext(IndexHelper.this.getMailbox().getAccount().getName());
                    this.reIndex(this.mOctxt, this.mTypesOrNull, this.mItemIdsOrNull, this.mSkipDelete);
                    this.onCompletion();
                    ZimbraLog.removeMboxFromContext();
                    ZimbraLog.removeAccountFromContext();
                }
                catch (ServiceException e) {
                    if (!e.getCode().equals("service.INTERRUPTED")) {
                        ZimbraLog.mailbox.warn((Object)("Background reindexing failed for Mailbox " + IndexHelper.this.getMailbox().getId() + " reindexing will not be completed.  " + "The mailbox must be manually reindexed"), e);
                    }
                    Object var3_2 = null;
                    if (!this.mUseGlobalStatus) return;
                    Mailbox mailbox2 = IndexHelper.this.getMailbox();
                    synchronized (mailbox2) {
                        IndexHelper.this.mReIndexStatus = null;
                        return;
                    }
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("out of memory", e);
                    Object var3_3 = null;
                    if (!this.mUseGlobalStatus) return;
                    Mailbox mailbox3 = IndexHelper.this.getMailbox();
                    synchronized (mailbox3) {
                        IndexHelper.this.mReIndexStatus = null;
                        return;
                    }
                }
                catch (Throwable t) {
                    ZimbraLog.index_add.warn((Object)"Caught exception in Async Reindex task", t);
                    Object var3_4 = null;
                    if (!this.mUseGlobalStatus) return;
                    Mailbox mailbox4 = IndexHelper.this.getMailbox();
                    synchronized (mailbox4) {
                        IndexHelper.this.mReIndexStatus = null;
                        return;
                    }
                }
                Object var3_1 = null;
                if (!this.mUseGlobalStatus) return;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                if (!this.mUseGlobalStatus) throw throwable;
                Mailbox mailbox = IndexHelper.this.getMailbox();
                synchronized (mailbox) {
                    IndexHelper.this.mReIndexStatus = null;
                    throw throwable;
                }
            }
            Mailbox mailbox = IndexHelper.this.getMailbox();
            synchronized (mailbox) {
                IndexHelper.this.mReIndexStatus = null;
                return;
            }
        }

        protected void onCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reIndex(OperationContext octxt, Set<Byte> typesOrNull, Set<Integer> itemIdsOrNull, boolean skipDelete) throws ServiceException {
            if (typesOrNull == null && itemIdsOrNull == null) {
                long start = 0L;
                if (ZimbraLog.mailbox.isInfoEnabled()) {
                    start = System.currentTimeMillis();
                }
                try {
                    Mailbox mailbox = IndexHelper.this.getMailbox();
                    synchronized (mailbox) {
                        boolean success = false;
                        try {
                            try {
                                IndexHelper.this.getMailbox().beginTransaction("reIndex_all", octxt, null);
                                IndexHelper.this.mFullReindexInProgress = true;
                                if (IndexHelper.this.getMailboxIndex() != null) {
                                    IndexHelper.this.getMailboxIndex().deleteIndex();
                                }
                                IndexHelper.this.mNumIndexingInProgress = 0;
                                IndexHelper.this.mHighestSubmittedToIndex = new SyncToken(0);
                                IndexHelper.this.getMailbox().setCurrentChangeIndexDeferredCount(100000);
                                IndexHelper.this.getMailbox().setCurrentChangeHighestModContentIndexed(new SyncToken(0));
                                success = true;
                            }
                            catch (IOException e) {
                                throw ServiceException.FAILURE("Error deleting index before re-indexing", e);
                            }
                            Object var11_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_14 = null;
                            IndexHelper.this.getMailbox().endTransaction(success);
                            throw throwable;
                        }
                        IndexHelper.this.getMailbox().endTransaction(success);
                    }
                    IndexHelper.this.indexDeferredItems();
                    Object var14_25 = null;
                }
                catch (Throwable throwable) {
                    Object var14_26 = null;
                    Mailbox mailbox = IndexHelper.this.getMailbox();
                    synchronized (mailbox) {
                        IndexHelper.this.mFullReindexInProgress = false;
                    }
                    throw throwable;
                }
                Mailbox mailbox = IndexHelper.this.getMailbox();
                synchronized (mailbox) {
                    IndexHelper.this.mFullReindexInProgress = false;
                }
                if (ZimbraLog.mailbox.isInfoEnabled()) {
                    long end = System.currentTimeMillis();
                    if (IndexHelper.this.getMailboxIndex() != null) {
                        IndexHelper.this.getMailboxIndex().flush();
                    }
                    ZimbraLog.mailbox.info("Re-Indexing: Mailbox " + IndexHelper.this.getMailbox().getId() + " COMPLETED in " + (end - start) + "ms");
                }
                return;
            }
            if (typesOrNull != null && typesOrNull.isEmpty()) {
                return;
            }
            if (itemIdsOrNull != null && itemIdsOrNull.isEmpty()) {
                return;
            }
            long start = 0L;
            if (ZimbraLog.mailbox.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            if (typesOrNull != null && itemIdsOrNull != null) {
                throw ServiceException.INVALID_REQUEST("Must only specify one of Types, ItemIds to Mailbox.reIndex", null);
            }
            ArrayList<DbSearch.SearchResult> msgs = null;
            try {
                Mailbox success = IndexHelper.this.getMailbox();
                synchronized (success) {
                    boolean success2 = false;
                    try {
                        try {
                            IndexHelper.this.getMailbox().beginTransaction("reIndex", octxt, null);
                            DbSearchConstraints c = new DbSearchConstraints();
                            if (itemIdsOrNull != null) {
                                c.itemIds = itemIdsOrNull;
                            } else if (typesOrNull != null) {
                                c.types = typesOrNull;
                            }
                            msgs = new ArrayList<DbSearch.SearchResult>();
                            DbSearch.search(msgs, IndexHelper.this.getMailbox().getOperationConnection(), c, IndexHelper.this.getMailbox(), SortBy.NONE, DbSearch.SearchResult.ExtraData.MODCONTENT);
                            if (!skipDelete) {
                                ArrayList<String> toDelete = new ArrayList<String>(msgs.size());
                                for (DbSearch.SearchResult s : msgs) {
                                    toDelete.add(s.indexId);
                                }
                                if (IndexHelper.this.getMailboxIndex() != null) {
                                    IndexHelper.this.getMailboxIndex().deleteDocuments(toDelete);
                                }
                            }
                            success2 = true;
                        }
                        catch (IOException e) {
                            throw ServiceException.FAILURE("Error deleting index before re-indexing", e);
                        }
                        Object var18_33 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_34 = null;
                        IndexHelper.this.getMailbox().endTransaction(success2);
                        throw throwable;
                    }
                    IndexHelper.this.getMailbox().endTransaction(success2);
                    this.mStatus.mNumToProcess = msgs.size();
                }
                IndexHelper.this.indexItemList(msgs, this.mStatus, true);
                if (ZimbraLog.mailbox.isInfoEnabled()) {
                    long end = System.currentTimeMillis();
                    long avg = 0L;
                    long mps = 0L;
                    if (this.mStatus.mNumProcessed > 0) {
                        avg = (end - start) / (long)this.mStatus.mNumProcessed;
                        long l = mps = avg > 0L ? 1000L / avg : 0L;
                    }
                    if (IndexHelper.this.getMailboxIndex() != null) {
                        IndexHelper.this.getMailboxIndex().flush();
                    }
                    ZimbraLog.mailbox.info("Re-Indexing: Mailbox " + IndexHelper.this.getMailbox().getId() + " COMPLETED.  Re-indexed " + this.mStatus.mNumProcessed + " items in " + (end - start) + "ms.  (avg " + avg + "ms/item= " + mps + " items/sec)" + " (" + this.mStatus.mNumFailed + " failed)");
                }
                Object var21_37 = null;
                if (IndexHelper.this.getMailboxIndex() != null) {
                    IndexHelper.this.getMailboxIndex().flush();
                }
            }
            catch (Throwable throwable) {
                Object var21_38 = null;
                if (IndexHelper.this.getMailboxIndex() != null) {
                    IndexHelper.this.getMailboxIndex().flush();
                }
                throw throwable;
            }
        }
    }
}

