/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.memcached.MemcachedMap;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.FoldersTagsCacheKey;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.util.Zimbra;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class FoldersTagsCache {
    private static final long SWEEP_INTERVAL_MSEC = 10000L;
    private static FoldersTagsCache sTheInstance = new FoldersTagsCache();
    private MemcachedMap<FoldersTagsCacheKey, FoldersTags> mMemcachedLookup;
    private Map<Long, Mailbox> mDirtyMailboxes;

    public static FoldersTagsCache getInstance() {
        return sTheInstance;
    }

    FoldersTagsCache() {
        ZimbraMemcachedClient memcachedClient = MemcachedConnector.getClient();
        FoldersTagsSerializer serializer = new FoldersTagsSerializer();
        this.mMemcachedLookup = new MemcachedMap(memcachedClient, serializer, false);
        this.mDirtyMailboxes = new HashMap<Long, Mailbox>(100);
        if (!DebugConfig.disableFoldersTagsCache) {
            Zimbra.sTimer.schedule((TimerTask)new DirtyMailboxesTask(), 10000L, 10000L);
        }
    }

    public FoldersTags get(Mailbox mbox) throws ServiceException {
        FoldersTagsCacheKey key = new FoldersTagsCacheKey(mbox.getAccountId(), mbox.getLastChangeID());
        return this.mMemcachedLookup.get(key);
    }

    public void put(Mailbox mbox, FoldersTags foldersTags) throws ServiceException {
        if (DebugConfig.disableFoldersTagsCache) {
            return;
        }
        FoldersTagsCacheKey key = new FoldersTagsCacheKey(mbox.getAccountId(), mbox.getLastChangeID());
        this.mMemcachedLookup.put(key, foldersTags);
    }

    public void purgeMailbox(Mailbox mbox) throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyCommittedChanges(PendingModifications mods, int changeId) {
        Mailbox mbox;
        if (DebugConfig.disableFoldersTagsCache) {
            return;
        }
        HashMap<String, Mailbox> mboxesToUpdate = new HashMap<String, Mailbox>();
        if (mods.created != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.created.entrySet()) {
                MailItem item = (MailItem)entry.getValue();
                if (!(item instanceof Folder) && !(item instanceof Tag)) continue;
                mbox = item.getMailbox();
                mboxesToUpdate.put(mbox.getAccountId(), mbox);
            }
        }
        if (mods.modified != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.modified.entrySet()) {
                PendingModifications.Change change = (PendingModifications.Change)entry.getValue();
                Object whatChanged = change.what;
                if (!(whatChanged instanceof Folder) && !(whatChanged instanceof Tag)) continue;
                MailItem mi = (MailItem)whatChanged;
                Mailbox mbox2 = mi.getMailbox();
                mboxesToUpdate.put(mbox2.getAccountId(), mbox2);
            }
        }
        if (mods.deleted != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.deleted.entrySet()) {
                String acctId;
                Object deletedObj = entry.getValue();
                if (deletedObj instanceof Folder || deletedObj instanceof Tag) {
                    MailItem mi = (MailItem)deletedObj;
                    Mailbox mbox3 = mi.getMailbox();
                    mboxesToUpdate.put(mbox3.getAccountId(), mbox3);
                    continue;
                }
                if (!(deletedObj instanceof Integer) || (acctId = entry.getKey().getAccountId()) == null || mboxesToUpdate.containsKey(acctId)) continue;
                mboxesToUpdate.put(acctId, null);
            }
        }
        try {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mboxesToUpdate.entrySet()) {
                String acctId = (String)((Object)entry.getKey());
                mbox = (Mailbox)entry.getValue();
                if (mbox == null) {
                    mbox = MailboxManager.getInstance().getMailboxByAccountId(acctId, false);
                }
                if (mbox == null) continue;
                Map<Long, Mailbox> map = this.mDirtyMailboxes;
                synchronized (map) {
                    this.mDirtyMailboxes.put(mbox.getId(), mbox);
                }
            }
            return;
        }
        catch (ServiceException e) {
            ZimbraLog.calendar.warn((Object)"Unable to notify folders/tags cache", e);
        }
    }

    private final class DirtyMailboxesTask
    extends TimerTask {
        private DirtyMailboxesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ArrayList dirty;
                Map map = FoldersTagsCache.this.mDirtyMailboxes;
                synchronized (map) {
                    dirty = new ArrayList(FoldersTagsCache.this.mDirtyMailboxes.values());
                    FoldersTagsCache.this.mDirtyMailboxes.clear();
                }
                ZimbraLog.mailbox.debug("Saving folders/tags to memcached for " + dirty.size() + " mailboxes");
                for (Mailbox mbox : dirty) {
                    try {
                        mbox.cacheFoldersTagsToMemcached();
                    }
                    catch (Throwable e) {
                        if (e instanceof OutOfMemoryError) {
                            Zimbra.halt("Caught out of memory error", e);
                        }
                        ZimbraLog.mailbox.warn((Object)"Caught exception in FolersTagsCache timer", e);
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    Zimbra.halt("Caught out of memory error", e);
                }
                ZimbraLog.mailbox.warn((Object)"Caught exception in FolersTagsCache timer", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FoldersTagsSerializer
    implements MemcachedSerializer<FoldersTags> {
        private FoldersTagsSerializer() {
        }

        @Override
        public Object serialize(FoldersTags value) {
            return value.encode().toString();
        }

        @Override
        public FoldersTags deserialize(Object obj) throws ServiceException {
            Metadata meta = new Metadata((String)obj);
            return FoldersTags.decode(meta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FoldersTags {
        private static final int DATA_VERSION = 1;
        private MetadataList mFolders;
        private MetadataList mTags;
        private static final String FN_DATA_VERSION = "dv";
        private static final String FN_FOLDERS = "folders";
        private static final String FN_TAGS = "tags";

        public FoldersTags(List<Folder> folders, List<Tag> tags) {
            this.mFolders = new MetadataList();
            for (Folder f : folders) {
                this.mFolders.add(f.serializeUnderlyingData());
            }
            this.mTags = new MetadataList();
            for (Tag t : tags) {
                this.mTags.add(t.serializeUnderlyingData());
            }
        }

        private FoldersTags(MetadataList folders, MetadataList tags) {
            this.mFolders = folders;
            this.mTags = tags;
        }

        public Metadata encode() {
            Metadata meta = new Metadata();
            meta.put(FN_DATA_VERSION, 1L);
            meta.put(FN_FOLDERS, this.mFolders);
            meta.put(FN_TAGS, this.mTags);
            return meta;
        }

        public static FoldersTags decode(Metadata meta) throws ServiceException {
            int ver = (int)meta.getLong(FN_DATA_VERSION, 0L);
            if (ver != 1) {
                ZimbraLog.mailbox.info("Ignoring cached folders/tags with stale data version");
                return null;
            }
            MetadataList folders = meta.getList(FN_FOLDERS);
            MetadataList tags = meta.getList(FN_TAGS);
            return new FoldersTags(folders, tags);
        }

        public List<Metadata> getFolders() {
            ArrayList<Metadata> toRet = new ArrayList<Metadata>();
            List list = this.mFolders.asList();
            for (Object obj : list) {
                if (!(obj instanceof Metadata)) continue;
                toRet.add((Metadata)obj);
            }
            return toRet;
        }

        public List<Metadata> getTags() {
            ArrayList<Metadata> toRet = new ArrayList<Metadata>();
            List list = this.mTags.asList();
            for (Object obj : list) {
                if (!(obj instanceof Metadata)) continue;
                toRet.add((Metadata)obj);
            }
            return toRet;
        }
    }
}

