/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ArrayUtil;
import com.zimbra.common.util.ListUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.session.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folder
extends MailItem {
    public static final byte FOLDER_IS_IMMUTABLE = 1;
    public static final byte FOLDER_DONT_TRACK_COUNTS = 2;
    protected byte mAttributes;
    protected byte mDefaultView;
    private List<Folder> mSubfolders;
    private long mTotalSize;
    private Folder mParent;
    private ACL mRights;
    private SyncData mSyncData;
    private int mImapUIDNEXT;
    private int mImapMODSEQ;
    private int mImapRECENT;
    private int mImapRECENTCutoff;
    protected static final String CN_ATTRIBUTES = "attributes";

    Folder(Mailbox mbox, MailItem.UnderlyingData ud) throws ServiceException {
        super(mbox, ud);
        if (this.mData.type != 1 && this.mData.type != 2 && this.mData.type != 13) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getSender() {
        return "";
    }

    @Override
    public String getPath() {
        if (this.mId == 11 || this.mId == 1) {
            return "/";
        }
        String parentPath = this.mParent.getPath();
        return parentPath + (parentPath.equals("/") ? "" : "/") + this.getName();
    }

    public byte getDefaultView() {
        return this.mDefaultView;
    }

    public byte getAttributes() {
        return this.mAttributes;
    }

    public long getItemCount() {
        return this.getSize();
    }

    @Override
    public long getTotalSize() {
        return this.mTotalSize;
    }

    public String getUrl() {
        return this.mSyncData == null || this.mSyncData.url == null ? "" : this.mSyncData.url;
    }

    public SyncData getSyncData() {
        return this.mSyncData == null ? null : new SyncData(this.mSyncData);
    }

    public long getLastSyncDate() {
        return this.mSyncData == null ? 0L : this.mSyncData.lastDate;
    }

    public int getImapRECENTCutoff() {
        for (Session s : this.mMailbox.getListeners(Session.Type.IMAP)) {
            ImapFolder i4folder = (ImapFolder)s;
            if (i4folder.getId() != this.mId || !i4folder.isWritable()) continue;
            return this.mMailbox.getLastItemId();
        }
        return this.mImapRECENTCutoff;
    }

    int getImapRECENT() throws ServiceException {
        if (this.getSize() == 0L) {
            return 0;
        }
        for (Session s : this.mMailbox.getListeners(Session.Type.IMAP)) {
            ImapFolder i4folder = (ImapFolder)s;
            if (i4folder.getId() != this.mId || !i4folder.isWritable()) continue;
            return 0;
        }
        if (this.mImapRECENT >= 0) {
            return this.mImapRECENT;
        }
        this.markItemModified(16);
        this.mImapRECENT = DbMailItem.countImapRecent(this, this.getImapRECENTCutoff());
        return this.mImapRECENT;
    }

    public int getImapUIDNEXT() {
        return this.mImapUIDNEXT;
    }

    public int getImapMODSEQ() {
        return this.mImapMODSEQ;
    }

    @Override
    public boolean inTrash() {
        if (this.mId <= 16) {
            return this.mId == 3;
        }
        return this.mParent.inTrash();
    }

    @Override
    public boolean inSpam() {
        return this.mId == 4;
    }

    public boolean isHidden() {
        switch (this.mId) {
            case 1: {
                return false;
            }
            case 11: {
                return true;
            }
        }
        return this.mParent.isHidden();
    }

    public boolean isDescendant(Folder folder) throws ServiceException {
        int parentId;
        while ((parentId = folder.getFolderId()) != this.getId()) {
            if (parentId == 11) {
                return false;
            }
            folder = folder.getMailbox().getFolderById(null, parentId);
        }
        return true;
    }

    @Override
    short checkRights(short rightsNeeded, Account authuser, boolean asAdmin) throws ServiceException {
        Short granted;
        if (rightsNeeded == 0) {
            return rightsNeeded;
        }
        if (authuser == null || authuser.getId().equals(this.mMailbox.getAccountId())) {
            return rightsNeeded;
        }
        if (AccessManager.getInstance().canAccessAccount(authuser, this.getAccount(), asAdmin)) {
            return rightsNeeded;
        }
        Short s = granted = this.mRights != null ? this.mRights.getGrantedRights(authuser) : null;
        if (granted != null) {
            return (short)(granted & rightsNeeded);
        }
        if (this.mId == 11 || this.isTagged(-23)) {
            return 0;
        }
        return this.mParent.checkRights(rightsNeeded, authuser, asAdmin);
    }

    ACL.Grant grantAccess(String zimbraId, byte type, short rights, String args) throws ServiceException {
        if (!this.canAccess((short)256)) {
            throw ServiceException.PERM_DENIED("you do not have admin rights to folder " + this.getPath());
        }
        if (type == 1 && zimbraId.equalsIgnoreCase(this.getMailbox().getAccountId())) {
            throw ServiceException.PERM_DENIED("cannot grant access to the owner of the folder");
        }
        this.alterTag(this.mMailbox.getFlagById(-23), true);
        this.markItemModified(0x200000);
        if (this.mRights == null) {
            this.mRights = new ACL();
        }
        ACL.Grant grant = this.mRights.grantAccess(zimbraId, type, rights, args);
        this.saveMetadata();
        return grant;
    }

    void revokeAccess(String zimbraId) throws ServiceException {
        if (!this.canAccess((short)256)) {
            throw ServiceException.PERM_DENIED("you do not have admin rights to folder " + this.getPath());
        }
        if (zimbraId.equalsIgnoreCase(this.getMailbox().getAccountId())) {
            throw ServiceException.PERM_DENIED("cannot revoke access from the owner of the folder");
        }
        ACL acl = this.getEffectiveACL();
        if (acl == null || !acl.revokeAccess(zimbraId)) {
            return;
        }
        this.alterTag(this.mMailbox.getFlagById(-23), true);
        this.markItemModified(0x200000);
        this.mRights.revokeAccess(zimbraId);
        if (this.mRights.isEmpty()) {
            this.mRights = null;
        }
        this.saveMetadata();
    }

    void setPermissions(ACL acl) throws ServiceException {
        if (!this.canAccess((short)256)) {
            throw ServiceException.PERM_DENIED("you do not have admin rights to folder " + this.getPath());
        }
        this.alterTag(this.mMailbox.getFlagById(-23), true);
        this.markItemModified(0x200000);
        if (acl != null && acl.isEmpty()) {
            acl = null;
        }
        if (acl == null && this.mRights == null) {
            return;
        }
        this.mRights = acl;
        this.saveMetadata();
    }

    public ACL getACL() {
        return this.mRights == null ? null : this.mRights.duplicate();
    }

    public ACL getEffectiveACL() {
        if (this.mId == 11 || this.isTagged(-23) || this.mParent == null) {
            return this.getACL();
        }
        return this.mParent.getEffectiveACL();
    }

    @Override
    public MailItem getParent() throws ServiceException {
        return this.mParent != null ? this.mParent : super.getFolder();
    }

    @Override
    Folder getFolder() throws ServiceException {
        return this.mParent != null ? this.mParent : super.getFolder();
    }

    public boolean hasSubfolders() {
        return this.mSubfolders != null && !this.mSubfolders.isEmpty();
    }

    Folder findSubfolder(String name) {
        if (name == null || this.mSubfolders == null) {
            return null;
        }
        name = StringUtil.trimTrailingSpaces(name);
        for (Folder subfolder : this.mSubfolders) {
            if (subfolder == null || !name.equalsIgnoreCase(subfolder.getName())) continue;
            return subfolder;
        }
        return null;
    }

    public List<Folder> getSubfolders(OperationContext octxt) throws ServiceException {
        if (this.mSubfolders == null) {
            return Collections.emptyList();
        }
        Collections.sort(this.mSubfolders, new SortByName());
        if (octxt == null || octxt.getAuthenticatedUser() == null) {
            return Collections.unmodifiableList(this.mSubfolders);
        }
        ArrayList<Folder> visible = new ArrayList<Folder>();
        for (Folder subfolder : this.mSubfolders) {
            if (!subfolder.canAccess((short)1, octxt.getAuthenticatedUser(), octxt.isUsingAdminPrivileges())) continue;
            visible.add(subfolder);
        }
        return visible;
    }

    public List<Folder> getSubfolderHierarchy() {
        return this.accumulateHierarchy(new ArrayList<Folder>());
    }

    private List<Folder> accumulateHierarchy(List<Folder> list) {
        list.add(this);
        if (this.mSubfolders != null) {
            for (Folder subfolder : this.mSubfolders) {
                subfolder.accumulateHierarchy(list);
            }
        }
        return list;
    }

    void updateSize(int countDelta, long sizeDelta) throws ServiceException {
        if (!this.trackSize()) {
            return;
        }
        this.markItemModified(16);
        if (countDelta > 0) {
            this.updateUIDNEXT();
        }
        if (countDelta != 0) {
            this.updateHighestMODSEQ();
        }
        this.mData.size = Math.max(0L, this.mData.size + (long)countDelta);
        this.mTotalSize = Math.max(0L, this.mTotalSize + sizeDelta);
        this.mImapRECENT = -1;
    }

    void setSize(long count, long totalSize) throws ServiceException {
        if (!this.trackSize()) {
            return;
        }
        this.markItemModified(16);
        if (count > this.mData.size) {
            this.updateUIDNEXT();
        }
        if (count != this.mData.size) {
            this.updateHighestMODSEQ();
            this.mImapRECENT = -1;
        }
        this.mData.size = count;
        this.mTotalSize = totalSize;
    }

    @Override
    protected void updateUnread(int delta) throws ServiceException {
        super.updateUnread(delta);
        if (delta != 0 && this.trackUnread()) {
            this.updateHighestMODSEQ();
        }
    }

    void updateUIDNEXT() {
        int uidnext = this.mMailbox.getLastItemId() + 1;
        if (this.trackImapStats() && this.mImapUIDNEXT < uidnext) {
            this.markItemModified(16);
            this.mImapUIDNEXT = uidnext;
        }
    }

    void updateHighestMODSEQ() throws ServiceException {
        int modseq = this.mMailbox.getOperationChangeID();
        if (this.trackImapStats() && this.mImapMODSEQ < modseq) {
            this.markItemModified(16);
            this.mImapMODSEQ = modseq;
        }
    }

    void checkpointRECENT() throws ServiceException {
        if (this.mImapRECENTCutoff == this.mMailbox.getLastItemId()) {
            return;
        }
        this.markItemModified(0x10000000);
        this.mImapRECENT = 0;
        this.mImapRECENTCutoff = this.mMailbox.getLastItemId();
        this.saveMetadata();
    }

    protected void saveFolderCounts(boolean initial) throws ServiceException {
        if (initial) {
            this.mImapUIDNEXT = this.mMailbox.getLastItemId() + 1;
            this.mImapMODSEQ = this.mMailbox.getLastChangeID();
        }
        DbMailItem.persistCounts(this, this.encodeMetadata());
    }

    @Override
    boolean isTaggable() {
        return false;
    }

    @Override
    boolean isCopyable() {
        return false;
    }

    @Override
    boolean isMovable() {
        return (this.mAttributes & 1) == 0;
    }

    @Override
    boolean isMutable() {
        return (this.mAttributes & 1) == 0;
    }

    @Override
    boolean isIndexed() {
        return false;
    }

    @Override
    boolean canHaveChildren() {
        return true;
    }

    @Override
    public boolean isDeletable() {
        return (this.mAttributes & 1) == 0;
    }

    @Override
    boolean isLeafNode() {
        return false;
    }

    @Override
    boolean trackUnread() {
        return (this.mAttributes & 2) == 0;
    }

    boolean trackSize() {
        return (this.mAttributes & 2) == 0;
    }

    boolean trackImapStats() {
        return (this.mAttributes & 2) == 0;
    }

    @Override
    boolean canParent(MailItem child) {
        return child instanceof Folder;
    }

    boolean canContain(MailItem child) {
        if (!this.canContain(child.getType())) {
            return false;
        }
        if (child instanceof Folder) {
            Folder folder = this;
            while (folder.getId() != 11) {
                if (folder.getId() == child.getId()) {
                    return false;
                }
                folder = folder.mParent;
            }
        }
        return true;
    }

    boolean canContain(byte type) {
        if (type == 3 != (this.mId == 8)) {
            return false;
        }
        if (type == 4 != (this.mId == 9)) {
            return false;
        }
        return type != 1 || this.mId != 4;
    }

    static Folder create(int id, Mailbox mbox, Folder parent, String name) throws ServiceException {
        return Folder.create(id, mbox, parent, name, (byte)0, (byte)-1, 0, DEFAULT_COLOR_RGB, null, null);
    }

    public static Folder create(int id, Mailbox mbox, Folder parent, String name, byte attributes, byte view, int flags, MailItem.Color color, String url, MailItem.CustomMetadata custom) throws ServiceException {
        if (id != 11) {
            if (parent == null || !parent.canContain((byte)1)) {
                throw MailServiceException.CANNOT_CONTAIN(parent, (byte)1);
            }
            if (parent.findSubfolder(name = Folder.validateItemName(name)) != null) {
                throw MailServiceException.ALREADY_EXISTS(name, new ServiceException.Argument[0]);
            }
            if (!parent.canAccess((short)512)) {
                throw ServiceException.PERM_DENIED("you do not have the required rights on the parent folder");
            }
        }
        if (view != -1) {
            Folder.validateType(view);
        }
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = id;
        data.type = 1;
        data.parentId = data.folderId = id == 11 ? id : parent.getId();
        data.date = mbox.getOperationTimestamp();
        data.flags = flags & Flag.FLAGS_FOLDER;
        data.name = name;
        data.subject = name;
        data.metadata = Folder.encodeMetadata(color, 1, custom, attributes, view, null, new SyncData(url), id + 1, 0L, mbox.getOperationChangeID(), -1, 0);
        data.contentChanged(mbox);
        ZimbraLog.mailop.info("adding folder %s: id=%d, parentId=%d.", name, data.id, data.parentId);
        DbMailItem.create(mbox, data, null);
        Folder folder = new Folder(mbox, data);
        folder.finishCreation(parent);
        return folder;
    }

    void setDefaultView(byte view) throws ServiceException {
        if (!this.isMutable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        if (view == this.mDefaultView) {
            return;
        }
        this.markItemModified(0x100000);
        this.mDefaultView = view;
        this.saveMetadata();
    }

    void setUrl(String url) throws ServiceException {
        if (url == null) {
            url = "";
        }
        if (this.getUrl().equals(url)) {
            return;
        }
        if (this.getUrl().equals("") && !url.equals("")) {
            throw MailServiceException.CANNOT_SUBSCRIBE(this.mId);
        }
        if (!this.isMutable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        this.markItemModified(262144);
        this.mSyncData = new SyncData(url);
        this.saveMetadata();
    }

    void setSubscriptionData(String guid, long date) throws ServiceException {
        if (this.getUrl().equals("")) {
            return;
        }
        if (!this.isMutable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        this.markItemModified(262144);
        this.mSyncData = new SyncData(this.getUrl(), guid, date);
        this.saveMetadata();
    }

    void setSyncDate(long date) throws ServiceException {
        if (!this.canAccess((short)2)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the folder");
        }
        this.markItemModified(262144);
        if (this.mSyncData == null) {
            this.mSyncData = new SyncData(null, null, date);
        } else {
            this.mSyncData.lastDate = date;
        }
        this.saveMetadata();
    }

    private void recursiveAlterUnread(boolean unread) throws ServiceException {
        this.alterUnread(unread);
        if (this.mSubfolders != null) {
            for (Folder subfolder : this.mSubfolders) {
                subfolder.recursiveAlterUnread(unread);
            }
        }
    }

    @Override
    void alterUnread(boolean unread) throws ServiceException {
        if (unread) {
            throw ServiceException.INVALID_REQUEST("folders can only be marked read", null);
        }
        if (!this.canAccess((short)1)) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the folder");
        }
        if (!this.isUnread()) {
            return;
        }
        List<MailItem.UnderlyingData> unreaddata = DbMailItem.getUnreadMessages(this);
        if (this.canAccess((short)2)) {
            HashSet<Integer> conversations = new HashSet<Integer>(unreaddata.size());
            for (MailItem.UnderlyingData data : unreaddata) {
                if (data.parentId <= 0) continue;
                conversations.add(data.parentId);
            }
            this.mMailbox.getItemById(conversations, (byte)4);
        }
        ArrayList<Integer> targets = new ArrayList<Integer>();
        boolean missed = false;
        for (MailItem.UnderlyingData data : unreaddata) {
            Message msg = this.mMailbox.getMessage(data);
            if (msg.checkChangeID() || !msg.canAccess((short)2)) {
                msg.updateUnread(-1);
                msg.mData.metadataChanged(this.mMailbox);
                targets.add(msg.getId());
                continue;
            }
            missed = true;
        }
        if (!missed) {
            if (ZimbraLog.mailop.isDebugEnabled()) {
                ZimbraLog.mailop.debug("marking all messages in " + Folder.getMailopContext(this) + " as " + (unread ? "unread" : "read"));
            }
            DbMailItem.alterUnread(this, unread);
        } else {
            if (ZimbraLog.mailop.isDebugEnabled() && targets.size() > 0) {
                String state = unread ? "unread" : "read";
                String context = Folder.getMailopContext(this);
                for (List<Integer> ids : ListUtil.split(targets, 200)) {
                    ZimbraLog.mailop.debug("marking messages in %s as %s.  ids: %s", context, state, StringUtil.join(",", ids));
                }
            }
            DbMailItem.alterUnread(this.mMailbox, targets, unread);
        }
    }

    @Override
    void alterTag(Tag tag, boolean newValue) throws ServiceException {
        ACL effectiveACL;
        if (!(tag instanceof Flag) || !((Flag)tag).isFolderOnly()) {
            super.alterTag(tag, newValue);
            return;
        }
        if (newValue == this.isTagged(tag)) {
            return;
        }
        boolean isNoInheritFlag = tag.getId() == -23;
        if (!this.canAccess(isNoInheritFlag ? (short)256 : 2)) {
            throw ServiceException.PERM_DENIED("you do not have the necessary privileges on the folder");
        }
        ACL aCL = effectiveACL = isNoInheritFlag ? this.getEffectiveACL() : null;
        if (effectiveACL != null && effectiveACL.isEmpty()) {
            effectiveACL = null;
        }
        this.markItemModified(tag instanceof Flag ? 4 : 2);
        this.tagChanged(tag, newValue);
        if (ZimbraLog.mailop.isDebugEnabled()) {
            ZimbraLog.mailop.debug("setting " + Folder.getMailopContext(tag) + " for " + Folder.getMailopContext(this));
        }
        DbMailItem.alterTag(tag, Arrays.asList(this.mId), newValue);
        if (isNoInheritFlag) {
            this.markItemModified(0x200000);
            if (!newValue && this.mRights != null) {
                this.mRights = null;
                this.saveMetadata();
            } else if (newValue) {
                this.mRights = effectiveACL;
                this.saveMetadata();
            }
        }
    }

    @Override
    void rename(String name, Folder target) throws ServiceException {
        boolean renamed;
        boolean bl = renamed = !(name = Folder.validateItemName(name)).equals(this.mData.name);
        if (!renamed && target == this.mParent) {
            return;
        }
        super.rename(name, target);
    }

    @Override
    boolean move(Folder target) throws ServiceException {
        this.markItemModified(768);
        if (this.mData.folderId == target.getId()) {
            return false;
        }
        if (!this.isMovable()) {
            throw MailServiceException.IMMUTABLE_OBJECT(this.mId);
        }
        if (!this.canAccess((short)8)) {
            throw ServiceException.PERM_DENIED("you do not have the required permissions");
        }
        if (target.getId() != 3 && target.getId() != 4 && !target.canAccess((short)4)) {
            throw ServiceException.PERM_DENIED("you do not have the required permissions");
        }
        if (!target.canContain(this)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!this.inTrash() && target.inTrash()) {
            this.recursiveAlterUnread(false);
        }
        this.mParent.removeChild(this);
        target.addChild(this);
        ZimbraLog.mailop.info("moving " + Folder.getMailopContext(this) + " to " + Folder.getMailopContext(target));
        this.mData.folderId = target.getId();
        this.mData.parentId = target.getId();
        this.mData.metadataChanged(this.mMailbox);
        DbMailItem.setFolder(this, target);
        return true;
    }

    @Override
    void addChild(MailItem child) throws ServiceException {
        if (child == null || !this.canParent(child)) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (child == this) {
            if (this.mId != 11) {
                throw MailServiceException.CANNOT_CONTAIN();
            }
        } else if (!(child instanceof Folder)) {
            super.addChild(child);
        } else {
            this.markItemModified(1024);
            Folder subfolder = (Folder)child;
            if (this.mSubfolders == null) {
                this.mSubfolders = new ArrayList<Folder>();
            } else {
                Folder existing = this.findSubfolder(subfolder.getName());
                if (existing == child) {
                    return;
                }
                if (existing != null) {
                    throw MailServiceException.ALREADY_EXISTS(subfolder.getName(), new ServiceException.Argument[0]);
                }
            }
            this.mSubfolders.add(subfolder);
            subfolder.mParent = this;
        }
    }

    @Override
    void removeChild(MailItem child) throws ServiceException {
        if (child == null) {
            throw MailServiceException.CANNOT_CONTAIN();
        }
        if (!(child instanceof Folder)) {
            super.removeChild(child);
        } else {
            this.markItemModified(1024);
            Folder subfolder = (Folder)child;
            if (this.mSubfolders == null) {
                throw MailServiceException.IS_NOT_CHILD();
            }
            int index = this.mSubfolders.indexOf(subfolder);
            if (index == -1) {
                throw MailServiceException.IS_NOT_CHILD();
            }
            this.mSubfolders.remove(index);
            subfolder.mParent = null;
        }
    }

    @Override
    void delete(MailItem.DeleteScope scope, boolean writeTombstones) throws ServiceException {
        if (scope == MailItem.DeleteScope.CONTENTS_ONLY) {
            this.deleteSingleFolder(writeTombstones);
        } else {
            List<Folder> subfolders = this.getSubfolderHierarchy();
            for (int i = subfolders.size() - 1; i >= 0; --i) {
                Folder subfolder = subfolders.get(i);
                subfolder.deleteSingleFolder(writeTombstones);
            }
        }
    }

    void empty(boolean includeSubfolders) throws ServiceException {
        if (includeSubfolders) {
            List<Folder> subfolders = this.getSubfolderHierarchy();
            for (int i = subfolders.size() - 1; i >= 1; --i) {
                Folder subfolder = subfolders.get(i);
                subfolder.deleteSingleFolder(true);
            }
        }
        super.delete(MailItem.DeleteScope.CONTENTS_ONLY, true);
    }

    void deleteSingleFolder(boolean writeTombstones) throws ServiceException {
        ZimbraLog.mailbox.info("deleting folder " + this.getPath() + ", id=" + this.getId());
        super.delete(this.hasSubfolders() ? MailItem.DeleteScope.CONTENTS_ONLY : MailItem.DeleteScope.ENTIRE_ITEM, writeTombstones);
    }

    @Override
    MailItem.PendingDelete getDeletionInfo() throws ServiceException {
        if (!this.canAccess((short)8)) {
            throw ServiceException.PERM_DENIED("you do not have the required rights on the item");
        }
        return DbMailItem.getLeafNodes(this);
    }

    @Override
    void propagateDeletion(MailItem.PendingDelete info) throws ServiceException {
        info.cascadeIds = info.incomplete ? DbMailItem.markDeletionTargets(this.mMailbox, info.itemIds.getIds(5, 16), info.modifiedIds) : DbMailItem.markDeletionTargets(this, info.modifiedIds);
        if (info.cascadeIds != null) {
            info.modifiedIds.removeAll(info.cascadeIds);
        }
        super.propagateDeletion(info);
    }

    @Override
    void purgeCache(MailItem.PendingDelete info, boolean purgeItem) throws ServiceException {
        this.mMailbox.purge((byte)4);
        this.mMailbox.getItemById(ArrayUtil.toIntArray(info.modifiedIds), (byte)4);
        super.purgeCache(info, purgeItem);
    }

    static void purgeMessages(Mailbox mbox, Folder folder, int beforeDate, Boolean unread, boolean useChangeDate, boolean deleteEmptySubfolders) throws ServiceException {
        if (beforeDate <= 0 || beforeDate >= mbox.getOperationTimestamp()) {
            return;
        }
        boolean allFolders = folder == null;
        List<Folder> folders = allFolders ? null : folder.getSubfolderHierarchy();
        MailItem.PendingDelete info = DbMailItem.getLeafNodes(mbox, folders, beforeDate, allFolders, unread, useChangeDate);
        Folder.delete(mbox, info, null, MailItem.DeleteScope.ENTIRE_ITEM, false);
        if (deleteEmptySubfolders) {
            for (int i = folders.size() - 1; i >= 1; --i) {
                Folder f = folders.get(i);
                long date = (useChangeDate ? f.getChangeDate() : f.getDate()) / 1000L;
                if (f.getItemCount() > 0L || date >= (long)beforeDate) continue;
                f.delete(MailItem.DeleteScope.ENTIRE_ITEM, false);
            }
        }
    }

    @Override
    void decodeMetadata(Metadata meta) throws ServiceException {
        MetadataList mlistACL;
        super.decodeMetadata(meta);
        int view = -1;
        switch (this.mId) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                view = 5;
                break;
            }
            case 10: {
                view = 11;
                break;
            }
            case 15: {
                view = 15;
                break;
            }
            case 7: 
            case 13: {
                view = 6;
                break;
            }
            case 14: {
                view = 5;
            }
        }
        this.mDefaultView = (byte)meta.getLong("vt", view);
        this.mAttributes = (byte)meta.getLong("a", 0L);
        this.mTotalSize = meta.getLong("sz", 0L);
        this.mImapUIDNEXT = (int)meta.getLong("unxt", 0L);
        this.mImapMODSEQ = (int)meta.getLong("mseq", 0L);
        this.mImapRECENT = (int)meta.getLong("i4l", -1L);
        this.mImapRECENTCutoff = (int)meta.getLong("i4r", 0L);
        if (meta.containsKey("url") || meta.containsKey("sd")) {
            this.mSyncData = new SyncData(meta.get("url", null), meta.get("sg", null), meta.getLong("sd", 0L));
        }
        if ((mlistACL = meta.getList("acl", true)) != null) {
            ACL acl = new ACL(mlistACL);
            ACL aCL = this.mRights = acl.isEmpty() ? null : acl;
            if (!this.isTagged(-23)) {
                this.alterTag(this.mMailbox.getFlagById(-23), true);
            }
        }
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return Folder.encodeMetadata(meta, this.mRGBColor, this.mVersion, this.mExtendedData, this.mAttributes, this.mDefaultView, this.mRights, this.mSyncData, this.mImapUIDNEXT, this.mTotalSize, this.mImapMODSEQ, this.mImapRECENT, this.mImapRECENTCutoff);
    }

    private static String encodeMetadata(MailItem.Color color, int version, MailItem.CustomMetadata custom, byte attributes, byte hint, ACL rights, SyncData fsd, int uidnext, long totalSize, int modseq, int imapRecent, int imapRecentCutoff) {
        MailItem.CustomMetadata.CustomMetadataList extended = custom == null ? null : custom.asList();
        return Folder.encodeMetadata(new Metadata(), color, version, extended, attributes, hint, rights, fsd, uidnext, totalSize, modseq, imapRecent, imapRecentCutoff).toString();
    }

    static Metadata encodeMetadata(Metadata meta, MailItem.Color color, int version, MailItem.CustomMetadata.CustomMetadataList extended, byte attributes, byte hint, ACL rights, SyncData fsd, int uidnext, long totalSize, int modseq, int imapRecent, int imapRecentCutoff) {
        if (hint != -1) {
            meta.put("vt", hint);
        }
        if (attributes != 0) {
            meta.put("a", attributes);
        }
        if (totalSize > 0L) {
            meta.put("sz", totalSize);
        }
        if (uidnext > 0) {
            meta.put("unxt", uidnext);
        }
        if (modseq > 0) {
            meta.put("mseq", modseq);
        }
        if (imapRecent > 0) {
            meta.put("i4l", imapRecent);
        }
        if (imapRecentCutoff > 0) {
            meta.put("i4r", imapRecentCutoff);
        }
        if (rights != null) {
            meta.put("acl", rights.encode());
        }
        if (fsd != null && fsd.url != null && !fsd.url.equals("")) {
            meta.put("url", fsd.url);
            meta.put("sg", fsd.lastGuid);
        }
        if (fsd != null && fsd.lastDate > 0L) {
            meta.put("sd", fsd.lastDate);
        }
        return MailItem.encodeMetadata(meta, color, version, extended);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("folder: {");
        sb.append("n:\"").append(this.getName()).append("\", ");
        this.appendCommonMembers(sb).append(", ");
        sb.append(CN_ATTRIBUTES).append(": ").append(this.mAttributes);
        sb.append("}");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SortByName
    implements Comparator<Folder> {
        SortByName() {
        }

        @Override
        public int compare(Folder f1, Folder f2) {
            String n1 = f1.getName();
            String n2 = f2.getName();
            return n1.compareToIgnoreCase(n2);
        }
    }

    public static final class SyncData {
        String url;
        String lastGuid;
        long lastDate;
        boolean stop;

        SyncData(String link) {
            this.url = link;
        }

        SyncData(SyncData sd) {
            this(sd.url, sd.lastGuid, sd.lastDate);
        }

        SyncData(String link, String guid, long date) {
            this.url = link;
            this.lastGuid = guid == null ? null : guid.trim();
            this.lastDate = date;
        }

        public boolean alreadySeen(String guid, Date date) {
            if (date != null) {
                return this.lastDate >= date.getTime();
            }
            if (this.stop) {
                return true;
            }
            if (guid == null || this.lastGuid == null || !guid.trim().equalsIgnoreCase(this.lastGuid)) {
                return false;
            }
            this.stop = true;
            return true;
        }
    }
}

