/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flag
extends Tag {
    public static final byte FLAG_GENERIC = 0;
    public static final byte FLAG_MESSAGE_ONLY = 1;
    public static final byte FLAG_FOLDER_ONLY = 2;
    public static final int ID_FLAG_FROM_ME = -1;
    public static final int ID_FLAG_ATTACHED = -2;
    public static final int ID_FLAG_REPLIED = -3;
    public static final int ID_FLAG_FORWARDED = -4;
    public static final int ID_FLAG_COPIED = -5;
    public static final int ID_FLAG_FLAGGED = -6;
    public static final int ID_FLAG_DRAFT = -7;
    public static final int ID_FLAG_DELETED = -8;
    public static final int ID_FLAG_NOTIFIED = -9;
    public static final int ID_FLAG_UNREAD = -10;
    public static final int ID_FLAG_HIGH_PRIORITY = -11;
    public static final int ID_FLAG_LOW_PRIORITY = -12;
    public static final int ID_FLAG_VERSIONED = -13;
    public static final int ID_FLAG_INDEXING_DEFERRED = -14;
    public static final int ID_FLAG_SUBSCRIBED = -20;
    public static final int ID_FLAG_EXCLUDE_FREEBUSY = -21;
    public static final int ID_FLAG_CHECKED = -22;
    public static final int ID_FLAG_NO_INHERIT = -23;
    public static final int ID_FLAG_INVITE = -24;
    public static final int ID_FLAG_SYNCFOLDER = -25;
    public static final int ID_FLAG_SYNC = -26;
    public static final int ID_FLAG_NO_INFERIORS = -27;
    public static final int ID_FLAG_GLOBAL = -29;
    public static final int ID_FLAG_UNCACHED = -31;
    public static final int BITMASK_FROM_ME = FlagInfo.getBitmask(-1);
    public static final int BITMASK_ATTACHED = FlagInfo.getBitmask(-2);
    public static final int BITMASK_REPLIED = FlagInfo.getBitmask(-3);
    public static final int BITMASK_FORWARDED = FlagInfo.getBitmask(-4);
    public static final int BITMASK_COPIED = FlagInfo.getBitmask(-5);
    public static final int BITMASK_FLAGGED = FlagInfo.getBitmask(-6);
    public static final int BITMASK_DRAFT = FlagInfo.getBitmask(-7);
    public static final int BITMASK_DELETED = FlagInfo.getBitmask(-8);
    public static final int BITMASK_NOTIFIED = FlagInfo.getBitmask(-9);
    public static final int BITMASK_UNREAD = FlagInfo.getBitmask(-10);
    public static final int BITMASK_HIGH_PRIORITY = FlagInfo.getBitmask(-11);
    public static final int BITMASK_LOW_PRIORITY = FlagInfo.getBitmask(-12);
    public static final int BITMASK_VERSIONED = FlagInfo.getBitmask(-13);
    public static final int BITMASK_INDEXING_DEFERRED = FlagInfo.getBitmask(-14);
    public static final int BITMASK_SUBSCRIBED = FlagInfo.getBitmask(-20);
    public static final int BITMASK_EXCLUDE_FREEBUSY = FlagInfo.getBitmask(-21);
    public static final int BITMASK_CHECKED = FlagInfo.getBitmask(-22);
    public static final int BITMASK_NO_INHERIT = FlagInfo.getBitmask(-23);
    public static final int BITMASK_INVITE = FlagInfo.getBitmask(-24);
    public static final int BITMASK_SYNCFOLDER = FlagInfo.getBitmask(-25);
    public static final int BITMASK_SYNC = FlagInfo.getBitmask(-26);
    public static final int BITMASK_NO_INFERIORS = FlagInfo.getBitmask(-27);
    public static final int BITMASK_GLOBAL = FlagInfo.getBitmask(-29);
    public static final int BITMASK_UNCACHED = FlagInfo.getBitmask(-31);
    static final String UNREAD_FLAG_ONLY = FlagInfo.getAbbreviation(-10) + "";
    public static final int FLAG_SYSTEM = FlagInfo.getSystemFlagBitmask();
    public static final int FLAGS_FOLDER = FlagInfo.aggregateBitmasks((byte)2);
    public static final int FLAGS_MESSAGE = FlagInfo.aggregateBitmasks((byte)1);
    public static final int FLAGS_GENERIC = FlagInfo.aggregateBitmasks((byte)0);
    public static final int FLAGS_ALL = (FLAGS_FOLDER | FLAGS_MESSAGE | FLAGS_GENERIC) & ~BITMASK_UNREAD;
    byte mAttributes;

    Flag(Mailbox mbox, MailItem.UnderlyingData ud) throws ServiceException {
        super(mbox, ud);
        if (this.mData.type != 10) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public byte getIndex() {
        return Flag.getIndex(this.mId);
    }

    public static byte getIndex(int flagId) {
        return (byte)(flagId > 0 || flagId < -31 ? -1 : -flagId - 1);
    }

    public char getAbbreviation() {
        return Flag.getAbbreviation(this.mId);
    }

    public static char getAbbreviation(int flagId) {
        return FlagInfo.getAbbreviation(flagId);
    }

    boolean isFolderOnly() {
        return (this.mAttributes & 2) != 0;
    }

    @Override
    boolean canTag(MailItem item) {
        if ((this.mAttributes & 2) != 0 && item instanceof Folder) {
            return true;
        }
        if (!item.isTaggable()) {
            return false;
        }
        return (this.mAttributes & 1) == 0 || item instanceof Message;
    }

    static void validateFlags(int flags) throws ServiceException {
        if ((flags & ~FLAGS_ALL) > 0) {
            throw ServiceException.FAILURE("invalid value for flags: " + flags, null);
        }
    }

    public static int flagsToBitmask(String flags) {
        return FlagInfo.flagsToBitmask(flags);
    }

    public static String bitmaskToFlags(int bitmask) {
        return FlagInfo.bitmaskToFlags(bitmask);
    }

    public static List<Integer> bitmaskToFlagIds(int bitmask) {
        return FlagInfo.bitmaskToFlagIds(bitmask);
    }

    @Override
    boolean canAccess(short rightsNeeded) {
        return true;
    }

    @Override
    boolean canAccess(short rightsNeeded, Account authuser, boolean asAdmin) {
        return true;
    }

    @Override
    boolean isMutable() {
        return false;
    }

    @Override
    boolean trackUnread() {
        return false;
    }

    static Flag getFlag(Mailbox mbox, int flagId) throws ServiceException {
        return FlagInfo.instantiate(mbox, flagId);
    }

    static Flag getFlag(Mailbox mbox, byte maskIndex) throws ServiceException {
        return FlagInfo.instantiate(mbox, -maskIndex - 1);
    }

    static Flag getFlag(Mailbox mbox, String name) throws ServiceException {
        return FlagInfo.instantiate(mbox, name);
    }

    static List<Flag> getAllFlags(Mailbox mbox) throws ServiceException {
        return FlagInfo.instantiateAll(mbox);
    }

    @Override
    void decodeMetadata(Metadata meta) {
    }

    @Override
    Metadata encodeMetadata(Metadata meta) {
        return meta;
    }

    public static void main(String[] args) {
        List<Integer> flagIds = Flag.bitmaskToFlagIds(FLAGS_MESSAGE);
        int bitmask = 0;
        for (int flagId : flagIds) {
            bitmask |= 1 << Flag.getIndex(flagId);
        }
        assert (bitmask == FLAGS_MESSAGE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlagInfo {
        private static final FlagInfo[] sFlagInfo = new FlagInfo[31];
        private static final FlagInfo[] sFlagAbbreviations = new FlagInfo[127];
        private static final Map<String, FlagInfo> sFlagNames = new HashMap<String, FlagInfo>();
        private static final char HIDDEN = '\u0000';
        private final String mName;
        private final int mId;
        private final char mAbbreviation;
        private final boolean mIsSystem;
        private final byte mAttributes;
        private final int mBitmask;
        private static final byte ATTRIBUTE_CONSTRAINT_MASK = 3;

        FlagInfo(String name, char abbr, byte attrs, boolean system, int id) {
            this.mName = name;
            this.mId = id;
            this.mAbbreviation = abbr;
            this.mIsSystem = system;
            this.mAttributes = attrs;
            byte index = Flag.getIndex(id);
            this.mBitmask = 1 << index;
            FlagInfo.sFlagInfo[index] = this;
            sFlagNames.put(name.toLowerCase(), this);
            if (abbr != '\u0000') {
                FlagInfo.sFlagAbbreviations[abbr] = this;
            }
        }

        static char getAbbreviation(int flagId) {
            byte index = Flag.getIndex(flagId);
            if (index < 0 || index >= sFlagInfo.length) {
                return '\u0000';
            }
            FlagInfo finfo = sFlagInfo[index];
            return finfo == null ? (char)'\u0000' : finfo.mAbbreviation;
        }

        static int getBitmask(int flagId) {
            byte index = Flag.getIndex(flagId);
            if (index < 0 || index >= sFlagInfo.length) {
                return 0;
            }
            FlagInfo finfo = sFlagInfo[index];
            return finfo == null ? 0 : finfo.mBitmask;
        }

        static int flagsToBitmask(String flags) {
            if (flags == null || flags.length() == 0) {
                return 0;
            }
            int bitmask = 0;
            int len = flags.length();
            for (int i = 0; i < len; ++i) {
                FlagInfo finfo;
                char c = flags.charAt(i);
                FlagInfo flagInfo = finfo = c > '\u0000' && c < '\u007f' ? sFlagAbbreviations[c] : null;
                if (finfo == null) continue;
                bitmask |= finfo.mBitmask;
            }
            return bitmask;
        }

        static String bitmaskToFlags(int bitmask) {
            if (bitmask == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (FlagInfo finfo : sFlagInfo) {
                if (finfo == null || (bitmask & finfo.mBitmask) == 0) continue;
                if (finfo.mAbbreviation != '\u0000') {
                    sb.append(finfo.mAbbreviation);
                }
                bitmask &= ~finfo.mBitmask;
            }
            return sb.toString();
        }

        static List<Integer> bitmaskToFlagIds(int bitmask) {
            if (bitmask == 0) {
                return Collections.emptyList();
            }
            ArrayList<Integer> flagIds = new ArrayList<Integer>(5);
            for (FlagInfo finfo : sFlagInfo) {
                if (finfo == null || (bitmask & finfo.mBitmask) == 0) continue;
                flagIds.add(finfo.mId);
                bitmask &= ~finfo.mBitmask;
            }
            return flagIds;
        }

        Flag instantiate(Mailbox mbox) throws ServiceException {
            MailItem.UnderlyingData data = new MailItem.UnderlyingData();
            data.id = this.mId;
            data.type = (byte)10;
            data.folderId = 8;
            data.flags = BITMASK_UNCACHED;
            data.name = this.mName;
            Flag flag = new Flag(mbox, data);
            flag.mAttributes = this.mAttributes;
            return flag;
        }

        static Flag instantiate(Mailbox mbox, int flagId) throws ServiceException {
            byte index = Flag.getIndex(flagId);
            FlagInfo finfo = index < 0 || index >= sFlagInfo.length ? null : sFlagInfo[index];
            return finfo == null ? null : finfo.instantiate(mbox);
        }

        static Flag instantiate(Mailbox mbox, String name) throws ServiceException {
            FlagInfo finfo = sFlagNames.get(name.toLowerCase());
            return finfo == null ? null : finfo.instantiate(mbox);
        }

        static List<Flag> instantiateAll(Mailbox mbox) throws ServiceException {
            ArrayList<Flag> flags = new ArrayList<Flag>(sFlagInfo.length);
            for (FlagInfo finfo : sFlagInfo) {
                if (finfo == null) continue;
                flags.add(finfo.instantiate(mbox));
            }
            return flags;
        }

        static int aggregateBitmasks(byte subsetMask) {
            int mask = 0;
            for (FlagInfo finfo : sFlagInfo) {
                if (finfo == null || (finfo.mAttributes & 3) != subsetMask) continue;
                mask |= finfo.mBitmask;
            }
            return mask;
        }

        static int getSystemFlagBitmask() {
            int mask = 0;
            for (FlagInfo finfo : sFlagInfo) {
                if (finfo == null || !finfo.mIsSystem) continue;
                mask |= finfo.mBitmask;
            }
            return mask;
        }

        static {
            new FlagInfo("\\Sent", 's', 1, true, -1);
            new FlagInfo("\\Attached", 'a', 0, true, -2);
            new FlagInfo("\\Answered", 'r', 1, false, -3);
            new FlagInfo("\\Forwarded", 'w', 1, false, -4);
            new FlagInfo("\\Copied", '\u0000', 0, true, -5);
            new FlagInfo("\\Flagged", 'f', 0, false, -6);
            new FlagInfo("\\Draft", 'd', 1, true, -7);
            new FlagInfo("\\Deleted", 'x', 0, false, -8);
            new FlagInfo("\\Notified", 'n', 1, false, -9);
            new FlagInfo("\\Unread", 'u', 1, false, -10);
            new FlagInfo("\\Urgent", '!', 1, true, -11);
            new FlagInfo("\\Bulk", '?', 1, true, -12);
            new FlagInfo("\\Versioned", '/', 0, true, -13);
            new FlagInfo("\\IdxDeferred", '\u0000', 0, true, -14);
            new FlagInfo("\\Subscribed", '*', 2, false, -20);
            new FlagInfo("\\ExcludeFB", 'b', 2, false, -21);
            new FlagInfo("\\Checked", '#', 2, false, -22);
            new FlagInfo("\\NoInherit", 'i', 2, false, -23);
            new FlagInfo("\\Invite", 'v', 1, true, -24);
            new FlagInfo("\\SyncFolder", 'y', 2, false, -25);
            new FlagInfo("\\Sync", '~', 2, false, -26);
            new FlagInfo("\\Noinferiors", 'o', 2, false, -27);
            new FlagInfo("\\Global", 'g', 2, true, -29);
            new FlagInfo("\\Uncached", '\u0000', 0, true, -31);
        }
    }
}

